/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableContext
extends ParosAbstractTable
implements TableContext {
    private static final String TABLE_NAME = "CONTEXT_DATA";
    private static final String DATAID = "DATAID";
    private static final String CONTEXTID = "CONTEXTID";
    private static final String TYPE = "TYPE";
    private static final String DATA = "DATA";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetAllData = null;
    private PreparedStatement psGetAllDataForContext = null;
    private PreparedStatement psGetAllDataForContextAndType = null;
    private PreparedStatement psDeleteData = null;
    private PreparedStatement psDeleteAllDataForContext = null;
    private PreparedStatement psDeleteAllDataForContextAndType = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, "CREATE cached TABLE CONTEXT_DATA (dataid bigint generated by default as identity (start with 1), contextId int not null, type int not null, data varchar(1048576) default '')");
            }
            this.psRead = conn.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE DATAID = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO CONTEXT_DATA (CONTEXTID,TYPE,DATA) VALUES (?, ?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psDeleteData = conn.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ? AND DATA = ?");
            this.psDeleteAllDataForContext = conn.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ?");
            this.psDeleteAllDataForContextAndType = conn.prepareStatement("DELETE FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ?");
            this.psGetAllData = conn.prepareStatement("SELECT * FROM CONTEXT_DATA");
            this.psGetAllDataForContext = conn.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE CONTEXTID = ?");
            this.psGetAllDataForContextAndType = conn.prepareStatement("SELECT * FROM CONTEXT_DATA WHERE CONTEXTID = ? AND TYPE = ?");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordContext read(long dataId) throws DatabaseException {
        try {
            this.psRead.setLong(1, dataId);
            try (ResultSet rs = this.psRead.executeQuery();){
                RecordContext result;
                RecordContext recordContext = result = this.build(rs);
                return recordContext;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordContext insert(int contextId, int type, String url) throws DatabaseException {
        try {
            long id;
            this.psInsert.setInt(1, contextId);
            this.psInsert.setInt(2, type);
            this.psInsert.setString(3, url);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getLong(1);
            }
            return this.read(id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(int contextId, int type, String data) throws DatabaseException {
        try {
            this.psDeleteData.setInt(1, contextId);
            this.psDeleteData.setInt(2, type);
            this.psDeleteData.setString(3, data);
            this.psDeleteData.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void deleteAllDataForContextAndType(int contextId, int type) throws DatabaseException {
        try {
            this.psDeleteAllDataForContextAndType.setInt(1, contextId);
            this.psDeleteAllDataForContextAndType.setInt(2, type);
            this.psDeleteAllDataForContextAndType.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void deleteAllDataForContext(int contextId) throws DatabaseException {
        try {
            this.psDeleteAllDataForContext.setInt(1, contextId);
            this.psDeleteAllDataForContext.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<RecordContext> getAllData() throws DatabaseException {
        try {
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            try (ResultSet rs = this.psGetAllData.executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized List<RecordContext> getDataForContext(int contextId) throws DatabaseException {
        try {
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            this.psGetAllDataForContext.setInt(1, contextId);
            try (ResultSet rs = this.psGetAllDataForContext.executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized List<RecordContext> getDataForContextAndType(int contextId, int type) throws DatabaseException {
        try {
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            this.psGetAllDataForContextAndType.setInt(1, contextId);
            this.psGetAllDataForContextAndType.setInt(2, type);
            try (ResultSet rs = this.psGetAllDataForContextAndType.executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordContext build(ResultSet rs) throws DatabaseException {
        try {
            RecordContext rt = null;
            if (rs.next()) {
                rt = new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setData(int contextId, int type, List<String> dataList) throws DatabaseException {
        this.deleteAllDataForContextAndType(contextId, type);
        for (String data : dataList) {
            this.insert(contextId, type, data);
        }
    }
}

