/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarPageTimings;
import edu.umass.cs.benchlab.har.HarWarning;
import edu.umass.cs.benchlab.har.ISO8601DateFormatter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPage {
    public static String TABLE_NAME = "pages";
    private String id;
    private Date startedDateTime;
    private String title;
    private HarPageTimings pageTimings;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarPage(String id, Date startedDateTime, String title, HarPageTimings pageTimings) {
        this.id = id;
        this.startedDateTime = startedDateTime;
        this.title = title;
        this.pageTimings = pageTimings;
    }

    public HarPage(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"pages\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("id".equals(name)) {
                this.setId(jp.getText());
                continue;
            }
            if ("startedDateTime".equals(name)) {
                try {
                    if (jp.getCurrentName().equals(jp.getText())) {
                        jp.nextToken();
                    }
                    this.setStartedDateTime(ISO8601DateFormatter.parseDate(jp.getText()));
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new JsonParseException("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation());
                }
            }
            if ("title".equals(name)) {
                this.setTitle(jp.getText());
                continue;
            }
            if ("pageTimings".equals(name)) {
                this.setPageTimings(new HarPageTimings(jp, warnings));
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in page element", jp.getCurrentLocation());
        }
        if (this.startedDateTime == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing startedDateTime field in pages element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing startedDateTime field in pages element", jp.getCurrentLocation());
            }
        }
        if (this.id == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing id field in pages element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing id field in pages element", jp.getCurrentLocation());
            }
        }
        if (this.title == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing title field in pages element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing title field in pages element", jp.getCurrentLocation());
            }
        }
        if (this.pageTimings == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing pageTimings field in pages element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing pageTimings field in pages element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarPage(HarDatabaseConfig config, long pageId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + "pages";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT start_date,id,title,comment FROM " + tableName + " WHERE page_id=?");
            ps.setLong(1, pageId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarPage for page id " + pageId + " found in database");
            }
            this.setStartedDateTime(rs.getTimestamp(1));
            this.setId(rs.getString(2));
            this.setTitle(rs.getString(3));
            this.setComment(rs.getString(4));
            this.pageTimings = new HarPageTimings(config, pageId);
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARPAGE, pageId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeStringField("startedDateTime", ISO8601DateFormatter.format(this.startedDateTime));
        g.writeStringField("id", this.id);
        g.writeStringField("title", this.title);
        this.pageTimings.writeHar(g);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(HarDatabaseConfig config, long logId, PreparedStatement pagePs, PreparedStatement timingPs) throws SQLException {
        ResultSet rs = null;
        try {
            pagePs.setTimestamp(1, new Timestamp(this.startedDateTime.getTime()));
            pagePs.setString(2, this.id);
            pagePs.setString(3, this.title);
            if (this.comment == null) {
                pagePs.setNull(4, -1);
            } else {
                pagePs.setString(4, this.comment);
            }
            pagePs.setLong(5, logId);
            pagePs.executeUpdate();
            rs = pagePs.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarPage entry");
            }
            long pageId = rs.getLong(1);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARPAGE, pageId, logId);
            this.pageTimings.writeJDBC(pageId, config, timingPs, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getStartedDateTime() {
        return this.startedDateTime;
    }

    public void setStartedDateTime(Date startedDateTime) {
        this.startedDateTime = startedDateTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HarPageTimings getPageTimings() {
        return this.pageTimings;
    }

    public void setPageTimings(HarPageTimings pageTimings) {
        this.pageTimings = pageTimings;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "  { \"startedDateTime\": \"" + ISO8601DateFormatter.format(this.startedDateTime) + "\", \"id\": \"" + this.id + "\", \"title\": \"" + this.title + "\", " + this.pageTimings + ", \"comment\": " + "\"" + this.comment + "\", " + this.customFields + "}\n";
    }
}

