;;; -*- coding: iso-2022-7bit  -*-
;;; ubig5.el --- tables between UCS and BIG5

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, BIG5

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from BIG5.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'chinese-big5-1 'unicode-assoc
     'chinese-big5-1-vs-unicode-assoc)

(put 'chinese-big5-2 'unicode-assoc
     'chinese-big5-2-vs-unicode-assoc)

(defvar
  chinese-big5-1-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(0!!(B . "0x3000") ;; IDEOGRAPHIC SPACE
       (?$(0!"(B . "0xFF0C") ;; FULLWIDTH COMMA
       (?$(0!#(B . "0x3001") ;; IDEOGRAPHIC COMMA
       (?$(0!$(B . "0x3002") ;; IDEOGRAPHIC FULL STOP
       (?$(0!%(B . "0xFF0E") ;; FULLWIDTH FULL STOP
       (?$(0!&(B . "0x2022") ;; BULLET
       (?$(0!'(B . "0xFF1B") ;; FULLWIDTH SEMICOLON
       (?$(0!((B . "0xFF1A") ;; FULLWIDTH COLON
       (?$(0!)(B . "0xFF1F") ;; FULLWIDTH QUESTION MARK
       (?$(0!*(B . "0xFF01") ;; FULLWIDTH EXCLAMATION MARK
       (?$(0!+(B . "0xFE30") ;; PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
       (?$(0!,(B . "0x2026") ;; HORIZONTAL ELLIPSIS
       (?$(0!-(B . "0x2025") ;; TWO DOT LEADER
       (?$(0!.(B . "0xFE50") ;; SMALL COMMA
       (?$(0!/(B . "0xFF64") ;; HALFWIDTH IDEOGRAPHIC COMMA
       (?$(0!0(B . "0xFE52") ;; SMALL FULL STOP
       (?$(0!1(B . "0x00B7") ;; MIDDLE DOT
       (?$(0!2(B . "0xFE54") ;; SMALL SEMICOLON
       (?$(0!3(B . "0xFE55") ;; SMALL COLON
       (?$(0!4(B . "0xFE56") ;; SMALL QUESTION MARK
       (?$(0!5(B . "0xFE57") ;; SMALL EXCLAMATION MARK
       (?$(0!6(B . "0xFF5C") ;; FULLWIDTH VERTICAL BAR
       (?$(0!7(B . "0x2013") ;; EN DASH
       (?$(0!8(B . "0xFE31") ;; PRESENTATION FORM FOR VERTICAL EM DASH
       (?$(0!9(B . "0x2014") ;; EM DASH
       (?$(0!:(B . "0xFE33") ;; PRESENTATION FORM FOR VERTICAL LOW LINE
       (?$(0!;(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0!<(B . "0xFE34") ;; PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
       (?$(0!=(B . "0xFE4F") ;; WAVY LOW LINE
       (?$(0!>(B . "0xFF08") ;; FULLWIDTH LEFT PARENTHESIS
       (?$(0!?(B . "0xFF09") ;; FULLWIDTH RIGHT PARENTHESIS
       (?$(0!@(B . "0xFE35") ;; PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
       (?$(0!A(B . "0xFE36") ;; PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
       (?$(0!B(B . "0xFF5B") ;; FULLWIDTH LEFT CURLY BRACKET
       (?$(0!C(B . "0xFF5D") ;; FULLWIDTH RIGHT CURLY BRACKET
       (?$(0!D(B . "0xFE37") ;; PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
       (?$(0!E(B . "0xFE38") ;; PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
       (?$(0!F(B . "0x3014") ;; LEFT TORTOISE SHELL BRACKET
       (?$(0!G(B . "0x3015") ;; RIGHT TORTOISE SHELL BRACKET
       (?$(0!H(B . "0xFE39") ;; PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
       (?$(0!I(B . "0xFE3A") ;; PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
       (?$(0!J(B . "0x3010") ;; LEFT BLACK LENTICULAR BRACKET
       (?$(0!K(B . "0x3011") ;; RIGHT BLACK LENTICULAR BRACKET
       (?$(0!L(B . "0xFE3B") ;; PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
       (?$(0!M(B . "0xFE3C") ;; PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
       (?$(0!N(B . "0x300A") ;; LEFT DOUBLE ANGLE BRACKET
       (?$(0!O(B . "0x300B") ;; RIGHT DOUBLE ANGLE BRACKET
       (?$(0!P(B . "0xFE3D") ;; PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
       (?$(0!Q(B . "0xFE3E") ;; PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
       (?$(0!R(B . "0x3008") ;; LEFT ANGLE BRACKET
       (?$(0!S(B . "0x3009") ;; RIGHT ANGLE BRACKET
       (?$(0!T(B . "0xFE3F") ;; PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
       (?$(0!U(B . "0xFE40") ;; PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
       (?$(0!V(B . "0x300C") ;; LEFT CORNER BRACKET
       (?$(0!W(B . "0x300D") ;; RIGHT CORNER BRACKET
       (?$(0!X(B . "0xFE41") ;; PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
       (?$(0!Y(B . "0xFE42") ;; PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
       (?$(0!Z(B . "0x300E") ;; LEFT WHITE CORNER BRACKET
       (?$(0![(B . "0x300F") ;; RIGHT WHITE CORNER BRACKET
       (?$(0!\(B . "0xFE43") ;; PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
       (?$(0!](B . "0xFE44") ;; PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
       (?$(0!^(B . "0xFE59") ;; SMALL LEFT PARENTHESIS
       (?$(0!_(B . "0xFE5A") ;; SMALL RIGHT PARENTHESIS
       (?$(0!`(B . "0xFE5B") ;; SMALL LEFT CURLY BRACKET
       (?$(0!a(B . "0xFE5C") ;; SMALL RIGHT CURLY BRACKET
       (?$(0!b(B . "0xFE5D") ;; SMALL LEFT TORTOISE SHELL BRACKET
       (?$(0!c(B . "0xFE5E") ;; SMALL RIGHT TORTOISE SHELL BRACKET
       (?$(0!d(B . "0x2018") ;; LEFT SINGLE QUOTATION MARK
       (?$(0!e(B . "0x2019") ;; RIGHT SINGLE QUOTATION MARK
       (?$(0!f(B . "0x201C") ;; LEFT DOUBLE QUOTATION MARK
       (?$(0!g(B . "0x201D") ;; RIGHT DOUBLE QUOTATION MARK
       (?$(0!h(B . "0x301D") ;; REVERSED DOUBLE PRIME QUOTATION MARK
       (?$(0!i(B . "0x301E") ;; DOUBLE PRIME QUOTATION MARK
       (?$(0!j(B . "0x2035") ;; REVERSED PRIME
       (?$(0!k(B . "0x2032") ;; PRIME
       (?$(0!l(B . "0xFF03") ;; FULLWIDTH NUMBER SIGN
       (?$(0!m(B . "0xFF06") ;; FULLWIDTH AMPERSAND
       (?$(0!n(B . "0xFF0A") ;; FULLWIDTH ASTERISK
       (?$(0!o(B . "0x203B") ;; REFERENCE MARK
       (?$(0!p(B . "0x00A7") ;; SECTION SIGN
       (?$(0!q(B . "0x3003") ;; DITTO MARK
       (?$(0!r(B . "0x25CB") ;; WHITE CIRCLE
       (?$(0!s(B . "0x25CF") ;; BLACK CIRCLE
       (?$(0!t(B . "0x25B3") ;; WHITE UP-POINTING TRIANGLE
       (?$(0!u(B . "0x25B2") ;; BLACK UP-POINTING TRIANGLE
       (?$(0!v(B . "0x25CE") ;; BULLSEYE
       (?$(0!w(B . "0x2606") ;; WHITE STAR
       (?$(0!x(B . "0x2605") ;; BLACK STAR
       (?$(0!y(B . "0x25C7") ;; WHITE DIAMOND
       (?$(0!z(B . "0x25C6") ;; BLACK DIAMOND
       (?$(0!{(B . "0x25A1") ;; WHITE SQUARE
       (?$(0!|(B . "0x25A0") ;; BLACK SQUARE
       (?$(0!}(B . "0x25BD") ;; WHITE DOWN-POINTING TRIANGLE
       (?$(0!~(B . "0x25BC") ;; BLACK DOWN-POINTING TRIANGLE
       (?$(0"!(B . "0x32A3") ;; CIRCLED IDEOGRAPH CORRECT
       (?$(0""(B . "0x2105") ;; CARE OF
       (?$(0"#(B . "0x203E") ;; OVERLINE
       (?$(0"$(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0"%(B . "0xFF3F") ;; FULLWIDTH LOW LINE
       (?$(0"&(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0"'(B . "0xFE49") ;; DASHED OVERLINE
       (?$(0"((B . "0xFE4A") ;; CENTRELINE OVERLINE
       (?$(0")(B . "0xFE4D") ;; DASHED LOW LINE
       (?$(0"*(B . "0xFE4E") ;; CENTRELINE LOW LINE
       (?$(0"+(B . "0xFE4B") ;; WAVY OVERLINE
       (?$(0",(B . "0xFE4C") ;; DOUBLE WAVY OVERLINE
       (?$(0"-(B . "0xFE5F") ;; SMALL NUMBER SIGN
       (?$(0".(B . "0xFE60") ;; SMALL AMPERSAND
       (?$(0"/(B . "0xFE61") ;; SMALL ASTERISK
       (?$(0"0(B . "0xFF0B") ;; FULLWIDTH PLUS SIGN
       (?$(0"1(B . "0xFF0D") ;; FULLWIDTH HYPHEN-MINUS
       (?$(0"2(B . "0x00D7") ;; MULTIPLICATION SIGN
       (?$(0"3(B . "0x00F7") ;; DIVISION SIGN
       (?$(0"4(B . "0x00B1") ;; PLUS-MINUS SIGN
       (?$(0"5(B . "0x221A") ;; SQUARE ROOT
       (?$(0"6(B . "0xFF1C") ;; FULLWIDTH LESS-THAN SIGN
       (?$(0"7(B . "0xFF1E") ;; FULLWIDTH GREATER-THAN SIGN
       (?$(0"8(B . "0xFF1D") ;; FULLWIDTH EQUALS SIGN
       (?$(0"9(B . "0x2266") ;; LESS THAN OVER EQUAL TO
       (?$(0":(B . "0x2267") ;; GREATER THAN OVER EQUAL TO
       (?$(0";(B . "0x2260") ;; NOT EQUAL TO
       (?$(0"<(B . "0x221E") ;; INFINITY
       (?$(0"=(B . "0x2252") ;; APPROXIMATELY EQUAL TO OR THE IMAGE OF
       (?$(0">(B . "0x2261") ;; IDENTICAL TO
       (?$(0"?(B . "0xFE62") ;; SMALL PLUS SIGN
       (?$(0"@(B . "0xFE63") ;; SMALL HYPHEN-MINUS
       (?$(0"A(B . "0xFE64") ;; SMALL LESS-THAN SIGN
       (?$(0"B(B . "0xFE65") ;; SMALL GREATER-THAN SIGN
       (?$(0"C(B . "0xFE66") ;; SMALL EQUALS SIGN
       (?$(0"D(B . "0x223C") ;; TILDE OPERATOR
       (?$(0"E(B . "0x2229") ;; INTERSECTION
       (?$(0"F(B . "0x222A") ;; UNION
       (?$(0"G(B . "0x22A5") ;; UP TACK
       (?$(0"H(B . "0x2220") ;; ANGLE
       (?$(0"I(B . "0x221F") ;; RIGHT ANGLE
       (?$(0"J(B . "0x22BF") ;; RIGHT TRIANGLE
       (?$(0"K(B . "0x33D2") ;; SQUARE LOG
       (?$(0"L(B . "0x33D1") ;; SQUARE LN
       (?$(0"M(B . "0x222B") ;; INTEGRAL
       (?$(0"N(B . "0x222E") ;; CONTOUR INTEGRAL
       (?$(0"O(B . "0x2235") ;; BECAUSE
       (?$(0"P(B . "0x2234") ;; THEREFORE
       (?$(0"Q(B . "0x2640") ;; FEMALE SIGN
       (?$(0"R(B . "0x2642") ;; MALE SIGN
       (?$(0"S(B . "0x2641") ;; EARTH
       (?$(0"T(B . "0x2609") ;; SUN
       (?$(0"U(B . "0x2191") ;; UPWARDS ARROW
       (?$(0"V(B . "0x2193") ;; DOWNWARDS ARROW
       (?$(0"W(B . "0x2190") ;; LEFTWARDS ARROW
       (?$(0"X(B . "0x2192") ;; RIGHTWARDS ARROW
       (?$(0"Y(B . "0x2196") ;; NORTH WEST ARROW
       (?$(0"Z(B . "0x2197") ;; NORTH EAST ARROW
       (?$(0"[(B . "0x2199") ;; SOUTH WEST ARROW
       (?$(0"\(B . "0x2198") ;; SOUTH EAST ARROW
       (?$(0"](B . "0x2225") ;; PARALLEL TO
       (?$(0"^(B . "0x2223") ;; DIVIDES
       (?$(0"_(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0"`(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0"a(B . "0xFF0F") ;; FULLWIDTH SOLIDUS
       (?$(0"b(B . "0xFF3C") ;; FULLWIDTH REVERSE SOLIDUS
       (?$(0"c(B . "0xFF04") ;; FULLWIDTH DOLLAR SIGN
       (?$(0"d(B . "0x00A5") ;; YEN SIGN
       (?$(0"e(B . "0x3012") ;; POSTAL MARK
       (?$(0"f(B . "0x00A2") ;; CENT SIGN
       (?$(0"g(B . "0x00A3") ;; POUND SIGN
       (?$(0"h(B . "0xFF05") ;; FULLWIDTH PERCENT SIGN
       (?$(0"i(B . "0xFF20") ;; FULLWIDTH COMMERCIAL AT
       (?$(0"j(B . "0x2103") ;; DEGREE CELSIUS
       (?$(0"k(B . "0x2109") ;; DEGREE FAHRENHEIT
       (?$(0"l(B . "0xFE69") ;; SMALL DOLLAR SIGN
       (?$(0"m(B . "0xFE6A") ;; SMALL PERCENT SIGN
       (?$(0"n(B . "0xFE6B") ;; SMALL COMMERCIAL AT
       (?$(0"o(B . "0x33D5") ;; SQUARE MIL
       (?$(0"p(B . "0x339C") ;; SQUARE MM
       (?$(0"q(B . "0x339D") ;; SQUARE CM
       (?$(0"r(B . "0x339E") ;; SQUARE KM
       (?$(0"s(B . "0x33CE") ;; SQUARE KM CAPITAL
       (?$(0"t(B . "0x33A1") ;; SQUARE M SQUARED
       (?$(0"u(B . "0x338E") ;; SQUARE MG
       (?$(0"v(B . "0x338F") ;; SQUARE KG
       (?$(0"w(B . "0x33C4") ;; SQUARE CC
       (?$(0"x(B . "0x00B0") ;; DEGREE SIGN
       (?$(0"y(B . "0x5159") ;; <CJK>
       (?$(0"z(B . "0x515B") ;; <CJK>
       (?$(0"{(B . "0x515E") ;; <CJK>
       (?$(0"|(B . "0x515D") ;; <CJK>
       (?$(0"}(B . "0x5161") ;; <CJK>
       (?$(0"~(B . "0x5163") ;; <CJK>
       (?$(0#!(B . "0x55E7") ;; <CJK>
       (?$(0#"(B . "0x74E9") ;; <CJK>
       (?$(0##(B . "0x7CCE") ;; <CJK>
       (?$(0#$(B . "0x2581") ;; LOWER ONE EIGHTH BLOCK
       (?$(0#%(B . "0x2582") ;; LOWER ONE QUARTER BLOCK
       (?$(0#&(B . "0x2583") ;; LOWER THREE EIGHTHS BLOCK
       (?$(0#'(B . "0x2584") ;; LOWER HALF BLOCK
       (?$(0#((B . "0x2585") ;; LOWER FIVE EIGHTHS BLOCK
       (?$(0#)(B . "0x2586") ;; LOWER THREE QUARTERS BLOCK
       (?$(0#*(B . "0x2587") ;; LOWER SEVEN EIGHTHS BLOCK
       (?$(0#+(B . "0x2588") ;; FULL BLOCK
       (?$(0#,(B . "0x258F") ;; LEFT ONE EIGHTH BLOCK
       (?$(0#-(B . "0x258E") ;; LEFT ONE QUARTER BLOCK
       (?$(0#.(B . "0x258D") ;; LEFT THREE EIGHTHS BLOCK
       (?$(0#/(B . "0x258C") ;; LEFT HALF BLOCK
       (?$(0#0(B . "0x258B") ;; LEFT FIVE EIGHTHS BLOCK
       (?$(0#1(B . "0x258A") ;; LEFT THREE QUARTERS BLOCK
       (?$(0#2(B . "0x2589") ;; LEFT SEVEN EIGHTHS BLOCK
       (?$(0#3(B . "0x253C") ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
       (?$(0#4(B . "0x2534") ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
       (?$(0#5(B . "0x252C") ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
       (?$(0#6(B . "0x2524") ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
       (?$(0#7(B . "0x251C") ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
       (?$(0#8(B . "0x2594") ;; UPPER ONE EIGHTH BLOCK
       (?$(0#9(B . "0x2500") ;; BOX DRAWINGS LIGHT HORIZONTAL
       (?$(0#:(B . "0x2502") ;; BOX DRAWINGS LIGHT VERTICAL
       (?$(0#;(B . "0x2595") ;; RIGHT ONE EIGHTH BLOCK
       (?$(0#<(B . "0x250C") ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
       (?$(0#=(B . "0x2510") ;; BOX DRAWINGS LIGHT DOWN AND LEFT
       (?$(0#>(B . "0x2514") ;; BOX DRAWINGS LIGHT UP AND RIGHT
       (?$(0#?(B . "0x2518") ;; BOX DRAWINGS LIGHT UP AND LEFT
       (?$(0#@(B . "0x256D") ;; BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
       (?$(0#A(B . "0x256E") ;; BOX DRAWINGS LIGHT ARC DOWN AND LEFT
       (?$(0#B(B . "0x2570") ;; BOX DRAWINGS LIGHT ARC UP AND RIGHT
       (?$(0#C(B . "0x256F") ;; BOX DRAWINGS LIGHT ARC UP AND LEFT
       (?$(0#D(B . "0x2550") ;; BOX DRAWINGS DOUBLE HORIZONTAL
       (?$(0#E(B . "0x255E") ;; BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
       (?$(0#F(B . "0x256A") ;; BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
       (?$(0#G(B . "0x2561") ;; BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
       (?$(0#H(B . "0x25E2") ;; BLACK LOWER RIGHT TRIANGLE
       (?$(0#I(B . "0x25E3") ;; BLACK LOWER LEFT TRIANGLE
       (?$(0#J(B . "0x25E5") ;; BLACK UPPER RIGHT TRIANGLE
       (?$(0#K(B . "0x25E4") ;; BLACK UPPER LEFT TRIANGLE
       (?$(0#L(B . "0x2571") ;; BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
       (?$(0#M(B . "0x2572") ;; BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
       (?$(0#N(B . "0x2573") ;; BOX DRAWINGS LIGHT DIAGONAL CROSS
       (?$(0#O(B . "0xFF10") ;; FULLWIDTH DIGIT ZERO
       (?$(0#P(B . "0xFF11") ;; FULLWIDTH DIGIT ONE
       (?$(0#Q(B . "0xFF12") ;; FULLWIDTH DIGIT TWO
       (?$(0#R(B . "0xFF13") ;; FULLWIDTH DIGIT THREE
       (?$(0#S(B . "0xFF14") ;; FULLWIDTH DIGIT FOUR
       (?$(0#T(B . "0xFF15") ;; FULLWIDTH DIGIT FIVE
       (?$(0#U(B . "0xFF16") ;; FULLWIDTH DIGIT SIX
       (?$(0#V(B . "0xFF17") ;; FULLWIDTH DIGIT SEVEN
       (?$(0#W(B . "0xFF18") ;; FULLWIDTH DIGIT EIGHT
       (?$(0#X(B . "0xFF19") ;; FULLWIDTH DIGIT NINE
       (?$(0#Y(B . "0x2160") ;; ROMAN NUMERAL ONE
       (?$(0#Z(B . "0x2161") ;; ROMAN NUMERAL TWO
       (?$(0#[(B . "0x2162") ;; ROMAN NUMERAL THREE
       (?$(0#\(B . "0x2163") ;; ROMAN NUMERAL FOUR
       (?$(0#](B . "0x2164") ;; ROMAN NUMERAL FIVE
       (?$(0#^(B . "0x2165") ;; ROMAN NUMERAL SIX
       (?$(0#_(B . "0x2166") ;; ROMAN NUMERAL SEVEN
       (?$(0#`(B . "0x2167") ;; ROMAN NUMERAL EIGHT
       (?$(0#a(B . "0x2168") ;; ROMAN NUMERAL NINE
       (?$(0#b(B . "0x2169") ;; ROMAN NUMERAL TEN
       (?$(0#c(B . "0x3021") ;; HANGZHOU NUMERAL ONE
       (?$(0#d(B . "0x3022") ;; HANGZHOU NUMERAL TWO
       (?$(0#e(B . "0x3023") ;; HANGZHOU NUMERAL THREE
       (?$(0#f(B . "0x3024") ;; HANGZHOU NUMERAL FOUR
       (?$(0#g(B . "0x3025") ;; HANGZHOU NUMERAL FIVE
       (?$(0#h(B . "0x3026") ;; HANGZHOU NUMERAL SIX
       (?$(0#i(B . "0x3027") ;; HANGZHOU NUMERAL SEVEN
       (?$(0#j(B . "0x3028") ;; HANGZHOU NUMERAL EIGHT
       (?$(0#k(B . "0x3029") ;; HANGZHOU NUMERAL NINE
       (?$(0#l(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0#m(B . "0x5344") ;; <CJK>
       (?$(0#n(B . "0xFFFD") ;; *** NO MAPPING ***
       (?$(0#o(B . "0xFF21") ;; FULLWIDTH LATIN CAPITAL LETTER A
       (?$(0#p(B . "0xFF22") ;; FULLWIDTH LATIN CAPITAL LETTER B
       (?$(0#q(B . "0xFF23") ;; FULLWIDTH LATIN CAPITAL LETTER C
       (?$(0#r(B . "0xFF24") ;; FULLWIDTH LATIN CAPITAL LETTER D
       (?$(0#s(B . "0xFF25") ;; FULLWIDTH LATIN CAPITAL LETTER E
       (?$(0#t(B . "0xFF26") ;; FULLWIDTH LATIN CAPITAL LETTER F
       (?$(0#u(B . "0xFF27") ;; FULLWIDTH LATIN CAPITAL LETTER G
       (?$(0#v(B . "0xFF28") ;; FULLWIDTH LATIN CAPITAL LETTER H
       (?$(0#w(B . "0xFF29") ;; FULLWIDTH LATIN CAPITAL LETTER I
       (?$(0#x(B . "0xFF2A") ;; FULLWIDTH LATIN CAPITAL LETTER J
       (?$(0#y(B . "0xFF2B") ;; FULLWIDTH LATIN CAPITAL LETTER K
       (?$(0#z(B . "0xFF2C") ;; FULLWIDTH LATIN CAPITAL LETTER L
       (?$(0#{(B . "0xFF2D") ;; FULLWIDTH LATIN CAPITAL LETTER M
       (?$(0#|(B . "0xFF2E") ;; FULLWIDTH LATIN CAPITAL LETTER N
       (?$(0#}(B . "0xFF2F") ;; FULLWIDTH LATIN CAPITAL LETTER O
       (?$(0#~(B . "0xFF30") ;; FULLWIDTH LATIN CAPITAL LETTER P
       (?$(0$!(B . "0xFF31") ;; FULLWIDTH LATIN CAPITAL LETTER Q
       (?$(0$"(B . "0xFF32") ;; FULLWIDTH LATIN CAPITAL LETTER R
       (?$(0$#(B . "0xFF33") ;; FULLWIDTH LATIN CAPITAL LETTER S
       (?$(0$$(B . "0xFF34") ;; FULLWIDTH LATIN CAPITAL LETTER T
       (?$(0$%(B . "0xFF35") ;; FULLWIDTH LATIN CAPITAL LETTER U
       (?$(0$&(B . "0xFF36") ;; FULLWIDTH LATIN CAPITAL LETTER V
       (?$(0$'(B . "0xFF37") ;; FULLWIDTH LATIN CAPITAL LETTER W
       (?$(0$((B . "0xFF38") ;; FULLWIDTH LATIN CAPITAL LETTER X
       (?$(0$)(B . "0xFF39") ;; FULLWIDTH LATIN CAPITAL LETTER Y
       (?$(0$*(B . "0xFF3A") ;; FULLWIDTH LATIN CAPITAL LETTER Z
       (?$(0$+(B . "0xFF41") ;; FULLWIDTH LATIN SMALL LETTER A
       (?$(0$,(B . "0xFF42") ;; FULLWIDTH LATIN SMALL LETTER B
       (?$(0$-(B . "0xFF43") ;; FULLWIDTH LATIN SMALL LETTER C
       (?$(0$.(B . "0xFF44") ;; FULLWIDTH LATIN SMALL LETTER D
       (?$(0$/(B . "0xFF45") ;; FULLWIDTH LATIN SMALL LETTER E
       (?$(0$0(B . "0xFF46") ;; FULLWIDTH LATIN SMALL LETTER F
       (?$(0$1(B . "0xFF47") ;; FULLWIDTH LATIN SMALL LETTER G
       (?$(0$2(B . "0xFF48") ;; FULLWIDTH LATIN SMALL LETTER H
       (?$(0$3(B . "0xFF49") ;; FULLWIDTH LATIN SMALL LETTER I
       (?$(0$4(B . "0xFF4A") ;; FULLWIDTH LATIN SMALL LETTER J
       (?$(0$5(B . "0xFF4B") ;; FULLWIDTH LATIN SMALL LETTER K
       (?$(0$6(B . "0xFF4C") ;; FULLWIDTH LATIN SMALL LETTER L
       (?$(0$7(B . "0xFF4D") ;; FULLWIDTH LATIN SMALL LETTER M
       (?$(0$8(B . "0xFF4E") ;; FULLWIDTH LATIN SMALL LETTER N
       (?$(0$9(B . "0xFF4F") ;; FULLWIDTH LATIN SMALL LETTER O
       (?$(0$:(B . "0xFF50") ;; FULLWIDTH LATIN SMALL LETTER P
       (?$(0$;(B . "0xFF51") ;; FULLWIDTH LATIN SMALL LETTER Q
       (?$(0$<(B . "0xFF52") ;; FULLWIDTH LATIN SMALL LETTER R
       (?$(0$=(B . "0xFF53") ;; FULLWIDTH LATIN SMALL LETTER S
       (?$(0$>(B . "0xFF54") ;; FULLWIDTH LATIN SMALL LETTER T
       (?$(0$?(B . "0xFF55") ;; FULLWIDTH LATIN SMALL LETTER U
       (?$(0$@(B . "0xFF56") ;; FULLWIDTH LATIN SMALL LETTER V
       (?$(0$A(B . "0xFF57") ;; FULLWIDTH LATIN SMALL LETTER W
       (?$(0$B(B . "0xFF58") ;; FULLWIDTH LATIN SMALL LETTER X
       (?$(0$C(B . "0xFF59") ;; FULLWIDTH LATIN SMALL LETTER Y
       (?$(0$D(B . "0xFF5A") ;; FULLWIDTH LATIN SMALL LETTER Z
       (?$(0$E(B . "0x0391") ;; GREEK CAPITAL LETTER ALPHA
       (?$(0$F(B . "0x0392") ;; GREEK CAPITAL LETTER BETA
       (?$(0$G(B . "0x0393") ;; GREEK CAPITAL LETTER GAMMA
       (?$(0$H(B . "0x0394") ;; GREEK CAPITAL LETTER DELTA
       (?$(0$I(B . "0x0395") ;; GREEK CAPITAL LETTER EPSILON
       (?$(0$J(B . "0x0396") ;; GREEK CAPITAL LETTER ZETA
       (?$(0$K(B . "0x0397") ;; GREEK CAPITAL LETTER ETA
       (?$(0$L(B . "0x0398") ;; GREEK CAPITAL LETTER THETA
       (?$(0$M(B . "0x0399") ;; GREEK CAPITAL LETTER IOTA
       (?$(0$N(B . "0x039A") ;; GREEK CAPITAL LETTER KAPPA
       (?$(0$O(B . "0x039B") ;; GREEK CAPITAL LETTER LAMDA
       (?$(0$P(B . "0x039C") ;; GREEK CAPITAL LETTER MU
       (?$(0$Q(B . "0x039D") ;; GREEK CAPITAL LETTER NU
       (?$(0$R(B . "0x039E") ;; GREEK CAPITAL LETTER XI
       (?$(0$S(B . "0x039F") ;; GREEK CAPITAL LETTER OMICRON
       (?$(0$T(B . "0x03A0") ;; GREEK CAPITAL LETTER PI
       (?$(0$U(B . "0x03A1") ;; GREEK CAPITAL LETTER RHO
       (?$(0$V(B . "0x03A3") ;; GREEK CAPITAL LETTER SIGMA
       (?$(0$W(B . "0x03A4") ;; GREEK CAPITAL LETTER TAU
       (?$(0$X(B . "0x03A5") ;; GREEK CAPITAL LETTER UPSILON
       (?$(0$Y(B . "0x03A6") ;; GREEK CAPITAL LETTER PHI
       (?$(0$Z(B . "0x03A7") ;; GREEK CAPITAL LETTER CHI
       (?$(0$[(B . "0x03A8") ;; GREEK CAPITAL LETTER PSI
       (?$(0$\(B . "0x03A9") ;; GREEK CAPITAL LETTER OMEGA
       (?$(0$](B . "0x03B1") ;; GREEK SMALL LETTER ALPHA
       (?$(0$^(B . "0x03B2") ;; GREEK SMALL LETTER BETA
       (?$(0$_(B . "0x03B3") ;; GREEK SMALL LETTER GAMMA
       (?$(0$`(B . "0x03B4") ;; GREEK SMALL LETTER DELTA
       (?$(0$a(B . "0x03B5") ;; GREEK SMALL LETTER EPSILON
       (?$(0$b(B . "0x03B6") ;; GREEK SMALL LETTER ZETA
       (?$(0$c(B . "0x03B7") ;; GREEK SMALL LETTER ETA
       (?$(0$d(B . "0x03B8") ;; GREEK SMALL LETTER THETA
       (?$(0$e(B . "0x03B9") ;; GREEK SMALL LETTER IOTA
       (?$(0$f(B . "0x03BA") ;; GREEK SMALL LETTER KAPPA
       (?$(0$g(B . "0x03BB") ;; GREEK SMALL LETTER LAMDA
       (?$(0$h(B . "0x03BC") ;; GREEK SMALL LETTER MU
       (?$(0$i(B . "0x03BD") ;; GREEK SMALL LETTER NU
       (?$(0$j(B . "0x03BE") ;; GREEK SMALL LETTER XI
       (?$(0$k(B . "0x03BF") ;; GREEK SMALL LETTER OMICRON
       (?$(0$l(B . "0x03C0") ;; GREEK SMALL LETTER PI
       (?$(0$m(B . "0x03C1") ;; GREEK SMALL LETTER RHO
       (?$(0$n(B . "0x03C3") ;; GREEK SMALL LETTER SIGMA
       (?$(0$o(B . "0x03C4") ;; GREEK SMALL LETTER TAU
       (?$(0$p(B . "0x03C5") ;; GREEK SMALL LETTER UPSILON
       (?$(0$q(B . "0x03C6") ;; GREEK SMALL LETTER PHI
       (?$(0$r(B . "0x03C7") ;; GREEK SMALL LETTER CHI
       (?$(0$s(B . "0x03C8") ;; GREEK SMALL LETTER PSI
       (?$(0$t(B . "0x03C9") ;; GREEK SMALL LETTER OMEGA
       (?$(0$u(B . "0x3105") ;; BOPOMOFO LETTER B
       (?$(0$v(B . "0x3106") ;; BOPOMOFO LETTER P
       (?$(0$w(B . "0x3107") ;; BOPOMOFO LETTER M
       (?$(0$x(B . "0x3108") ;; BOPOMOFO LETTER F
       (?$(0$y(B . "0x3109") ;; BOPOMOFO LETTER D
       (?$(0$z(B . "0x310A") ;; BOPOMOFO LETTER T
       (?$(0${(B . "0x310B") ;; BOPOMOFO LETTER N
       (?$(0$|(B . "0x310C") ;; BOPOMOFO LETTER L
       (?$(0$}(B . "0x310D") ;; BOPOMOFO LETTER G
       (?$(0$~(B . "0x310E") ;; BOPOMOFO LETTER K
       (?$(0%!(B . "0x310F") ;; BOPOMOFO LETTER H
       (?$(0%"(B . "0x3110") ;; BOPOMOFO LETTER J
       (?$(0%#(B . "0x3111") ;; BOPOMOFO LETTER Q
       (?$(0%$(B . "0x3112") ;; BOPOMOFO LETTER X
       (?$(0%%(B . "0x3113") ;; BOPOMOFO LETTER ZH
       (?$(0%&(B . "0x3114") ;; BOPOMOFO LETTER CH
       (?$(0%'(B . "0x3115") ;; BOPOMOFO LETTER SH
       (?$(0%((B . "0x3116") ;; BOPOMOFO LETTER R
       (?$(0%)(B . "0x3117") ;; BOPOMOFO LETTER Z
       (?$(0%*(B . "0x3118") ;; BOPOMOFO LETTER C
       (?$(0%+(B . "0x3119") ;; BOPOMOFO LETTER S
       (?$(0%,(B . "0x311A") ;; BOPOMOFO LETTER A
       (?$(0%-(B . "0x311B") ;; BOPOMOFO LETTER O
       (?$(0%.(B . "0x311C") ;; BOPOMOFO LETTER E
       (?$(0%/(B . "0x311D") ;; BOPOMOFO LETTER EH
       (?$(0%0(B . "0x311E") ;; BOPOMOFO LETTER AI
       (?$(0%1(B . "0x311F") ;; BOPOMOFO LETTER EI
       (?$(0%2(B . "0x3120") ;; BOPOMOFO LETTER AU
       (?$(0%3(B . "0x3121") ;; BOPOMOFO LETTER OU
       (?$(0%4(B . "0x3122") ;; BOPOMOFO LETTER AN
       (?$(0%5(B . "0x3123") ;; BOPOMOFO LETTER EN
       (?$(0%6(B . "0x3124") ;; BOPOMOFO LETTER ANG
       (?$(0%7(B . "0x3125") ;; BOPOMOFO LETTER ENG
       (?$(0%8(B . "0x3126") ;; BOPOMOFO LETTER ER
       (?$(0%9(B . "0x3127") ;; BOPOMOFO LETTER I
       (?$(0%:(B . "0x3128") ;; BOPOMOFO LETTER U
       (?$(0%;(B . "0x3129") ;; BOPOMOFO LETTER IU
       (?$(0%<(B . "0x02D9") ;; DOT ABOVE (Mandarin Chinese light tone)
       (?$(0%=(B . "0x02C9") ;; MODIFIER LETTER MACRON (Mandarin Chinese first tone)
       (?$(0%>(B . "0x02CA") ;; MODIFIER LETTER ACUTE ACCENT (Mandarin Chinese second tone)
       (?$(0%?(B . "0x02C7") ;; CARON (Mandarin Chinese third tone)
       (?$(0%@(B . "0x02CB") ;; MODIFIER LETTER GRAVE ACCENT (Mandarin Chinese fourth tone)
       (?$(0&"(B . "0x4E00") ;; <CJK>
       (?$(0&#(B . "0x4E59") ;; <CJK>
       (?$(0&$(B . "0x4E01") ;; <CJK>
       (?$(0&%(B . "0x4E03") ;; <CJK>
       (?$(0&&(B . "0x4E43") ;; <CJK>
       (?$(0&'(B . "0x4E5D") ;; <CJK>
       (?$(0&((B . "0x4E86") ;; <CJK>
       (?$(0&)(B . "0x4E8C") ;; <CJK>
       (?$(0&*(B . "0x4EBA") ;; <CJK>
       (?$(0&+(B . "0x513F") ;; <CJK>
       (?$(0&,(B . "0x5165") ;; <CJK>
       (?$(0&-(B . "0x516B") ;; <CJK>
       (?$(0&.(B . "0x51E0") ;; <CJK>
       (?$(0&/(B . "0x5200") ;; <CJK>
       (?$(0&0(B . "0x5201") ;; <CJK>
       (?$(0&1(B . "0x529B") ;; <CJK>
       (?$(0&2(B . "0x5315") ;; <CJK>
       (?$(0&3(B . "0x5341") ;; <CJK>
       (?$(0&4(B . "0x535C") ;; <CJK>
       (?$(0&5(B . "0x53C8") ;; <CJK>
       (?$(0&6(B . "0x4E09") ;; <CJK>
       (?$(0&7(B . "0x4E0B") ;; <CJK>
       (?$(0&8(B . "0x4E08") ;; <CJK>
       (?$(0&9(B . "0x4E0A") ;; <CJK>
       (?$(0&:(B . "0x4E2B") ;; <CJK>
       (?$(0&;(B . "0x4E38") ;; <CJK>
       (?$(0&<(B . "0x51E1") ;; <CJK>
       (?$(0&=(B . "0x4E45") ;; <CJK>
       (?$(0&>(B . "0x4E48") ;; <CJK>
       (?$(0&?(B . "0x4E5F") ;; <CJK>
       (?$(0&@(B . "0x4E5E") ;; <CJK>
       (?$(0&A(B . "0x4E8E") ;; <CJK>
       (?$(0&B(B . "0x4EA1") ;; <CJK>
       (?$(0&C(B . "0x5140") ;; <CJK>
       (?$(0&D(B . "0x5203") ;; <CJK>
       (?$(0&E(B . "0x52FA") ;; <CJK>
       (?$(0&F(B . "0x5343") ;; <CJK>
       (?$(0&G(B . "0x53C9") ;; <CJK>
       (?$(0&H(B . "0x53E3") ;; <CJK>
       (?$(0&I(B . "0x571F") ;; <CJK>
       (?$(0&J(B . "0x58EB") ;; <CJK>
       (?$(0&K(B . "0x5915") ;; <CJK>
       (?$(0&L(B . "0x5927") ;; <CJK>
       (?$(0&M(B . "0x5973") ;; <CJK>
       (?$(0&N(B . "0x5B50") ;; <CJK>
       (?$(0&O(B . "0x5B51") ;; <CJK>
       (?$(0&P(B . "0x5B53") ;; <CJK>
       (?$(0&Q(B . "0x5BF8") ;; <CJK>
       (?$(0&R(B . "0x5C0F") ;; <CJK>
       (?$(0&S(B . "0x5C22") ;; <CJK>
       (?$(0&T(B . "0x5C38") ;; <CJK>
       (?$(0&U(B . "0x5C71") ;; <CJK>
       (?$(0&V(B . "0x5DDD") ;; <CJK>
       (?$(0&W(B . "0x5DE5") ;; <CJK>
       (?$(0&X(B . "0x5DF1") ;; <CJK>
       (?$(0&Y(B . "0x5DF2") ;; <CJK>
       (?$(0&Z(B . "0x5DF3") ;; <CJK>
       (?$(0&[(B . "0x5DFE") ;; <CJK>
       (?$(0&\(B . "0x5E72") ;; <CJK>
       (?$(0&](B . "0x5EFE") ;; <CJK>
       (?$(0&^(B . "0x5F0B") ;; <CJK>
       (?$(0&_(B . "0x5F13") ;; <CJK>
       (?$(0&`(B . "0x624D") ;; <CJK>
       (?$(0&a(B . "0x4E11") ;; <CJK>
       (?$(0&b(B . "0x4E10") ;; <CJK>
       (?$(0&c(B . "0x4E0D") ;; <CJK>
       (?$(0&d(B . "0x4E2D") ;; <CJK>
       (?$(0&e(B . "0x4E30") ;; <CJK>
       (?$(0&f(B . "0x4E39") ;; <CJK>
       (?$(0&g(B . "0x4E4B") ;; <CJK>
       (?$(0&h(B . "0x5C39") ;; <CJK>
       (?$(0&i(B . "0x4E88") ;; <CJK>
       (?$(0&j(B . "0x4E91") ;; <CJK>
       (?$(0&k(B . "0x4E95") ;; <CJK>
       (?$(0&l(B . "0x4E92") ;; <CJK>
       (?$(0&m(B . "0x4E94") ;; <CJK>
       (?$(0&n(B . "0x4EA2") ;; <CJK>
       (?$(0&o(B . "0x4EC1") ;; <CJK>
       (?$(0&p(B . "0x4EC0") ;; <CJK>
       (?$(0&q(B . "0x4EC3") ;; <CJK>
       (?$(0&r(B . "0x4EC6") ;; <CJK>
       (?$(0&s(B . "0x4EC7") ;; <CJK>
       (?$(0&t(B . "0x4ECD") ;; <CJK>
       (?$(0&u(B . "0x4ECA") ;; <CJK>
       (?$(0&v(B . "0x4ECB") ;; <CJK>
       (?$(0&w(B . "0x4EC4") ;; <CJK>
       (?$(0&x(B . "0x5143") ;; <CJK>
       (?$(0&y(B . "0x5141") ;; <CJK>
       (?$(0&z(B . "0x5167") ;; <CJK>
       (?$(0&{(B . "0x516D") ;; <CJK>
       (?$(0&|(B . "0x516E") ;; <CJK>
       (?$(0&}(B . "0x516C") ;; <CJK>
       (?$(0&~(B . "0x5197") ;; <CJK>
       (?$(0'!(B . "0x51F6") ;; <CJK>
       (?$(0'"(B . "0x5206") ;; <CJK>
       (?$(0'#(B . "0x5207") ;; <CJK>
       (?$(0'$(B . "0x5208") ;; <CJK>
       (?$(0'%(B . "0x52FB") ;; <CJK>
       (?$(0'&(B . "0x52FE") ;; <CJK>
       (?$(0''(B . "0x52FF") ;; <CJK>
       (?$(0'((B . "0x5316") ;; <CJK>
       (?$(0')(B . "0x5339") ;; <CJK>
       (?$(0'*(B . "0x5348") ;; <CJK>
       (?$(0'+(B . "0x5347") ;; <CJK>
       (?$(0',(B . "0x5345") ;; <CJK>
       (?$(0'-(B . "0x535E") ;; <CJK>
       (?$(0'.(B . "0x5384") ;; <CJK>
       (?$(0'/(B . "0x53CB") ;; <CJK>
       (?$(0'0(B . "0x53CA") ;; <CJK>
       (?$(0'1(B . "0x53CD") ;; <CJK>
       (?$(0'2(B . "0x58EC") ;; <CJK>
       (?$(0'3(B . "0x5929") ;; <CJK>
       (?$(0'4(B . "0x592B") ;; <CJK>
       (?$(0'5(B . "0x592A") ;; <CJK>
       (?$(0'6(B . "0x592D") ;; <CJK>
       (?$(0'7(B . "0x5B54") ;; <CJK>
       (?$(0'8(B . "0x5C11") ;; <CJK>
       (?$(0'9(B . "0x5C24") ;; <CJK>
       (?$(0':(B . "0x5C3A") ;; <CJK>
       (?$(0';(B . "0x5C6F") ;; <CJK>
       (?$(0'<(B . "0x5DF4") ;; <CJK>
       (?$(0'=(B . "0x5E7B") ;; <CJK>
       (?$(0'>(B . "0x5EFF") ;; <CJK>
       (?$(0'?(B . "0x5F14") ;; <CJK>
       (?$(0'@(B . "0x5F15") ;; <CJK>
       (?$(0'A(B . "0x5FC3") ;; <CJK>
       (?$(0'B(B . "0x6208") ;; <CJK>
       (?$(0'C(B . "0x6236") ;; <CJK>
       (?$(0'D(B . "0x624B") ;; <CJK>
       (?$(0'E(B . "0x624E") ;; <CJK>
       (?$(0'F(B . "0x652F") ;; <CJK>
       (?$(0'G(B . "0x6587") ;; <CJK>
       (?$(0'H(B . "0x6597") ;; <CJK>
       (?$(0'I(B . "0x65A4") ;; <CJK>
       (?$(0'J(B . "0x65B9") ;; <CJK>
       (?$(0'K(B . "0x65E5") ;; <CJK>
       (?$(0'L(B . "0x66F0") ;; <CJK>
       (?$(0'M(B . "0x6708") ;; <CJK>
       (?$(0'N(B . "0x6728") ;; <CJK>
       (?$(0'O(B . "0x6B20") ;; <CJK>
       (?$(0'P(B . "0x6B62") ;; <CJK>
       (?$(0'Q(B . "0x6B79") ;; <CJK>
       (?$(0'R(B . "0x6BCB") ;; <CJK>
       (?$(0'S(B . "0x6BD4") ;; <CJK>
       (?$(0'T(B . "0x6BDB") ;; <CJK>
       (?$(0'U(B . "0x6C0F") ;; <CJK>
       (?$(0'V(B . "0x6C34") ;; <CJK>
       (?$(0'W(B . "0x706B") ;; <CJK>
       (?$(0'X(B . "0x722A") ;; <CJK>
       (?$(0'Y(B . "0x7236") ;; <CJK>
       (?$(0'Z(B . "0x723B") ;; <CJK>
       (?$(0'[(B . "0x7247") ;; <CJK>
       (?$(0'\(B . "0x7259") ;; <CJK>
       (?$(0'](B . "0x725B") ;; <CJK>
       (?$(0'^(B . "0x72AC") ;; <CJK>
       (?$(0'_(B . "0x738B") ;; <CJK>
       (?$(0'`(B . "0x4E19") ;; <CJK>
       (?$(0'a(B . "0x4E16") ;; <CJK>
       (?$(0'b(B . "0x4E15") ;; <CJK>
       (?$(0'c(B . "0x4E14") ;; <CJK>
       (?$(0'd(B . "0x4E18") ;; <CJK>
       (?$(0'e(B . "0x4E3B") ;; <CJK>
       (?$(0'f(B . "0x4E4D") ;; <CJK>
       (?$(0'g(B . "0x4E4F") ;; <CJK>
       (?$(0'h(B . "0x4E4E") ;; <CJK>
       (?$(0'i(B . "0x4EE5") ;; <CJK>
       (?$(0'j(B . "0x4ED8") ;; <CJK>
       (?$(0'k(B . "0x4ED4") ;; <CJK>
       (?$(0'l(B . "0x4ED5") ;; <CJK>
       (?$(0'm(B . "0x4ED6") ;; <CJK>
       (?$(0'n(B . "0x4ED7") ;; <CJK>
       (?$(0'o(B . "0x4EE3") ;; <CJK>
       (?$(0'p(B . "0x4EE4") ;; <CJK>
       (?$(0'q(B . "0x4ED9") ;; <CJK>
       (?$(0'r(B . "0x4EDE") ;; <CJK>
       (?$(0's(B . "0x5145") ;; <CJK>
       (?$(0't(B . "0x5144") ;; <CJK>
       (?$(0'u(B . "0x5189") ;; <CJK>
       (?$(0'v(B . "0x518A") ;; <CJK>
       (?$(0'w(B . "0x51AC") ;; <CJK>
       (?$(0'x(B . "0x51F9") ;; <CJK>
       (?$(0'y(B . "0x51FA") ;; <CJK>
       (?$(0'z(B . "0x51F8") ;; <CJK>
       (?$(0'{(B . "0x520A") ;; <CJK>
       (?$(0'|(B . "0x52A0") ;; <CJK>
       (?$(0'}(B . "0x529F") ;; <CJK>
       (?$(0'~(B . "0x5305") ;; <CJK>
       (?$(0(!(B . "0x5306") ;; <CJK>
       (?$(0("(B . "0x5317") ;; <CJK>
       (?$(0(#(B . "0x531D") ;; <CJK>
       (?$(0($(B . "0x4EDF") ;; <CJK>
       (?$(0(%(B . "0x534A") ;; <CJK>
       (?$(0(&(B . "0x5349") ;; <CJK>
       (?$(0('(B . "0x5361") ;; <CJK>
       (?$(0(((B . "0x5360") ;; <CJK>
       (?$(0()(B . "0x536F") ;; <CJK>
       (?$(0(*(B . "0x536E") ;; <CJK>
       (?$(0(+(B . "0x53BB") ;; <CJK>
       (?$(0(,(B . "0x53EF") ;; <CJK>
       (?$(0(-(B . "0x53E4") ;; <CJK>
       (?$(0(.(B . "0x53F3") ;; <CJK>
       (?$(0(/(B . "0x53EC") ;; <CJK>
       (?$(0(0(B . "0x53EE") ;; <CJK>
       (?$(0(1(B . "0x53E9") ;; <CJK>
       (?$(0(2(B . "0x53E8") ;; <CJK>
       (?$(0(3(B . "0x53FC") ;; <CJK>
       (?$(0(4(B . "0x53F8") ;; <CJK>
       (?$(0(5(B . "0x53F5") ;; <CJK>
       (?$(0(6(B . "0x53EB") ;; <CJK>
       (?$(0(7(B . "0x53E6") ;; <CJK>
       (?$(0(8(B . "0x53EA") ;; <CJK>
       (?$(0(9(B . "0x53F2") ;; <CJK>
       (?$(0(:(B . "0x53F1") ;; <CJK>
       (?$(0(;(B . "0x53F0") ;; <CJK>
       (?$(0(<(B . "0x53E5") ;; <CJK>
       (?$(0(=(B . "0x53ED") ;; <CJK>
       (?$(0(>(B . "0x53FB") ;; <CJK>
       (?$(0(?(B . "0x56DB") ;; <CJK>
       (?$(0(@(B . "0x56DA") ;; <CJK>
       (?$(0(A(B . "0x5916") ;; <CJK>
       (?$(0(B(B . "0x592E") ;; <CJK>
       (?$(0(C(B . "0x5931") ;; <CJK>
       (?$(0(D(B . "0x5974") ;; <CJK>
       (?$(0(E(B . "0x5976") ;; <CJK>
       (?$(0(F(B . "0x5B55") ;; <CJK>
       (?$(0(G(B . "0x5B83") ;; <CJK>
       (?$(0(H(B . "0x5C3C") ;; <CJK>
       (?$(0(I(B . "0x5DE8") ;; <CJK>
       (?$(0(J(B . "0x5DE7") ;; <CJK>
       (?$(0(K(B . "0x5DE6") ;; <CJK>
       (?$(0(L(B . "0x5E02") ;; <CJK>
       (?$(0(M(B . "0x5E03") ;; <CJK>
       (?$(0(N(B . "0x5E73") ;; <CJK>
       (?$(0(O(B . "0x5E7C") ;; <CJK>
       (?$(0(P(B . "0x5F01") ;; <CJK>
       (?$(0(Q(B . "0x5F18") ;; <CJK>
       (?$(0(R(B . "0x5F17") ;; <CJK>
       (?$(0(S(B . "0x5FC5") ;; <CJK>
       (?$(0(T(B . "0x620A") ;; <CJK>
       (?$(0(U(B . "0x6253") ;; <CJK>
       (?$(0(V(B . "0x6254") ;; <CJK>
       (?$(0(W(B . "0x6252") ;; <CJK>
       (?$(0(X(B . "0x6251") ;; <CJK>
       (?$(0(Y(B . "0x65A5") ;; <CJK>
       (?$(0(Z(B . "0x65E6") ;; <CJK>
       (?$(0([(B . "0x672E") ;; <CJK>
       (?$(0(\(B . "0x672C") ;; <CJK>
       (?$(0(](B . "0x672A") ;; <CJK>
       (?$(0(^(B . "0x672B") ;; <CJK>
       (?$(0(_(B . "0x672D") ;; <CJK>
       (?$(0(`(B . "0x6B63") ;; <CJK>
       (?$(0(a(B . "0x6BCD") ;; <CJK>
       (?$(0(b(B . "0x6C11") ;; <CJK>
       (?$(0(c(B . "0x6C10") ;; <CJK>
       (?$(0(d(B . "0x6C38") ;; <CJK>
       (?$(0(e(B . "0x6C41") ;; <CJK>
       (?$(0(f(B . "0x6C40") ;; <CJK>
       (?$(0(g(B . "0x6C3E") ;; <CJK>
       (?$(0(h(B . "0x72AF") ;; <CJK>
       (?$(0(i(B . "0x7384") ;; <CJK>
       (?$(0(j(B . "0x7389") ;; <CJK>
       (?$(0(k(B . "0x74DC") ;; <CJK>
       (?$(0(l(B . "0x74E6") ;; <CJK>
       (?$(0(m(B . "0x7518") ;; <CJK>
       (?$(0(n(B . "0x751F") ;; <CJK>
       (?$(0(o(B . "0x7528") ;; <CJK>
       (?$(0(p(B . "0x7529") ;; <CJK>
       (?$(0(q(B . "0x7530") ;; <CJK>
       (?$(0(r(B . "0x7531") ;; <CJK>
       (?$(0(s(B . "0x7532") ;; <CJK>
       (?$(0(t(B . "0x7533") ;; <CJK>
       (?$(0(u(B . "0x758B") ;; <CJK>
       (?$(0(v(B . "0x767D") ;; <CJK>
       (?$(0(w(B . "0x76AE") ;; <CJK>
       (?$(0(x(B . "0x76BF") ;; <CJK>
       (?$(0(y(B . "0x76EE") ;; <CJK>
       (?$(0(z(B . "0x77DB") ;; <CJK>
       (?$(0({(B . "0x77E2") ;; <CJK>
       (?$(0(|(B . "0x77F3") ;; <CJK>
       (?$(0(}(B . "0x793A") ;; <CJK>
       (?$(0(~(B . "0x79BE") ;; <CJK>
       (?$(0)!(B . "0x7A74") ;; <CJK>
       (?$(0)"(B . "0x7ACB") ;; <CJK>
       (?$(0)#(B . "0x4E1E") ;; <CJK>
       (?$(0)$(B . "0x4E1F") ;; <CJK>
       (?$(0)%(B . "0x4E52") ;; <CJK>
       (?$(0)&(B . "0x4E53") ;; <CJK>
       (?$(0)'(B . "0x4E69") ;; <CJK>
       (?$(0)((B . "0x4E99") ;; <CJK>
       (?$(0))(B . "0x4EA4") ;; <CJK>
       (?$(0)*(B . "0x4EA6") ;; <CJK>
       (?$(0)+(B . "0x4EA5") ;; <CJK>
       (?$(0),(B . "0x4EFF") ;; <CJK>
       (?$(0)-(B . "0x4F09") ;; <CJK>
       (?$(0).(B . "0x4F19") ;; <CJK>
       (?$(0)/(B . "0x4F0A") ;; <CJK>
       (?$(0)0(B . "0x4F15") ;; <CJK>
       (?$(0)1(B . "0x4F0D") ;; <CJK>
       (?$(0)2(B . "0x4F10") ;; <CJK>
       (?$(0)3(B . "0x4F11") ;; <CJK>
       (?$(0)4(B . "0x4F0F") ;; <CJK>
       (?$(0)5(B . "0x4EF2") ;; <CJK>
       (?$(0)6(B . "0x4EF6") ;; <CJK>
       (?$(0)7(B . "0x4EFB") ;; <CJK>
       (?$(0)8(B . "0x4EF0") ;; <CJK>
       (?$(0)9(B . "0x4EF3") ;; <CJK>
       (?$(0):(B . "0x4EFD") ;; <CJK>
       (?$(0);(B . "0x4F01") ;; <CJK>
       (?$(0)<(B . "0x4F0B") ;; <CJK>
       (?$(0)=(B . "0x5149") ;; <CJK>
       (?$(0)>(B . "0x5147") ;; <CJK>
       (?$(0)?(B . "0x5146") ;; <CJK>
       (?$(0)@(B . "0x5148") ;; <CJK>
       (?$(0)A(B . "0x5168") ;; <CJK>
       (?$(0)B(B . "0x5171") ;; <CJK>
       (?$(0)C(B . "0x518D") ;; <CJK>
       (?$(0)D(B . "0x51B0") ;; <CJK>
       (?$(0)E(B . "0x5217") ;; <CJK>
       (?$(0)F(B . "0x5211") ;; <CJK>
       (?$(0)G(B . "0x5212") ;; <CJK>
       (?$(0)H(B . "0x520E") ;; <CJK>
       (?$(0)I(B . "0x5216") ;; <CJK>
       (?$(0)J(B . "0x52A3") ;; <CJK>
       (?$(0)K(B . "0x5308") ;; <CJK>
       (?$(0)L(B . "0x5321") ;; <CJK>
       (?$(0)M(B . "0x5320") ;; <CJK>
       (?$(0)N(B . "0x5370") ;; <CJK>
       (?$(0)O(B . "0x5371") ;; <CJK>
       (?$(0)P(B . "0x5409") ;; <CJK>
       (?$(0)Q(B . "0x540F") ;; <CJK>
       (?$(0)R(B . "0x540C") ;; <CJK>
       (?$(0)S(B . "0x540A") ;; <CJK>
       (?$(0)T(B . "0x5410") ;; <CJK>
       (?$(0)U(B . "0x5401") ;; <CJK>
       (?$(0)V(B . "0x540B") ;; <CJK>
       (?$(0)W(B . "0x5404") ;; <CJK>
       (?$(0)X(B . "0x5411") ;; <CJK>
       (?$(0)Y(B . "0x540D") ;; <CJK>
       (?$(0)Z(B . "0x5408") ;; <CJK>
       (?$(0)[(B . "0x5403") ;; <CJK>
       (?$(0)\(B . "0x540E") ;; <CJK>
       (?$(0)](B . "0x5406") ;; <CJK>
       (?$(0)^(B . "0x5412") ;; <CJK>
       (?$(0)_(B . "0x56E0") ;; <CJK>
       (?$(0)`(B . "0x56DE") ;; <CJK>
       (?$(0)a(B . "0x56DD") ;; <CJK>
       (?$(0)b(B . "0x5733") ;; <CJK>
       (?$(0)c(B . "0x5730") ;; <CJK>
       (?$(0)d(B . "0x5728") ;; <CJK>
       (?$(0)e(B . "0x572D") ;; <CJK>
       (?$(0)f(B . "0x572C") ;; <CJK>
       (?$(0)g(B . "0x572F") ;; <CJK>
       (?$(0)h(B . "0x5729") ;; <CJK>
       (?$(0)i(B . "0x5919") ;; <CJK>
       (?$(0)j(B . "0x591A") ;; <CJK>
       (?$(0)k(B . "0x5937") ;; <CJK>
       (?$(0)l(B . "0x5938") ;; <CJK>
       (?$(0)m(B . "0x5984") ;; <CJK>
       (?$(0)n(B . "0x5978") ;; <CJK>
       (?$(0)o(B . "0x5983") ;; <CJK>
       (?$(0)p(B . "0x597D") ;; <CJK>
       (?$(0)q(B . "0x5979") ;; <CJK>
       (?$(0)r(B . "0x5982") ;; <CJK>
       (?$(0)s(B . "0x5981") ;; <CJK>
       (?$(0)t(B . "0x5B57") ;; <CJK>
       (?$(0)u(B . "0x5B58") ;; <CJK>
       (?$(0)v(B . "0x5B87") ;; <CJK>
       (?$(0)w(B . "0x5B88") ;; <CJK>
       (?$(0)x(B . "0x5B85") ;; <CJK>
       (?$(0)y(B . "0x5B89") ;; <CJK>
       (?$(0)z(B . "0x5BFA") ;; <CJK>
       (?$(0){(B . "0x5C16") ;; <CJK>
       (?$(0)|(B . "0x5C79") ;; <CJK>
       (?$(0)}(B . "0x5DDE") ;; <CJK>
       (?$(0)~(B . "0x5E06") ;; <CJK>
       (?$(0*!(B . "0x5E76") ;; <CJK>
       (?$(0*"(B . "0x5E74") ;; <CJK>
       (?$(0*#(B . "0x5F0F") ;; <CJK>
       (?$(0*$(B . "0x5F1B") ;; <CJK>
       (?$(0*%(B . "0x5FD9") ;; <CJK>
       (?$(0*&(B . "0x5FD6") ;; <CJK>
       (?$(0*'(B . "0x620E") ;; <CJK>
       (?$(0*((B . "0x620C") ;; <CJK>
       (?$(0*)(B . "0x620D") ;; <CJK>
       (?$(0**(B . "0x6210") ;; <CJK>
       (?$(0*+(B . "0x6263") ;; <CJK>
       (?$(0*,(B . "0x625B") ;; <CJK>
       (?$(0*-(B . "0x6258") ;; <CJK>
       (?$(0*.(B . "0x6536") ;; <CJK>
       (?$(0*/(B . "0x65E9") ;; <CJK>
       (?$(0*0(B . "0x65E8") ;; <CJK>
       (?$(0*1(B . "0x65EC") ;; <CJK>
       (?$(0*2(B . "0x65ED") ;; <CJK>
       (?$(0*3(B . "0x66F2") ;; <CJK>
       (?$(0*4(B . "0x66F3") ;; <CJK>
       (?$(0*5(B . "0x6709") ;; <CJK>
       (?$(0*6(B . "0x673D") ;; <CJK>
       (?$(0*7(B . "0x6734") ;; <CJK>
       (?$(0*8(B . "0x6731") ;; <CJK>
       (?$(0*9(B . "0x6735") ;; <CJK>
       (?$(0*:(B . "0x6B21") ;; <CJK>
       (?$(0*;(B . "0x6B64") ;; <CJK>
       (?$(0*<(B . "0x6B7B") ;; <CJK>
       (?$(0*=(B . "0x6C16") ;; <CJK>
       (?$(0*>(B . "0x6C5D") ;; <CJK>
       (?$(0*?(B . "0x6C57") ;; <CJK>
       (?$(0*@(B . "0x6C59") ;; <CJK>
       (?$(0*A(B . "0x6C5F") ;; <CJK>
       (?$(0*B(B . "0x6C60") ;; <CJK>
       (?$(0*C(B . "0x6C50") ;; <CJK>
       (?$(0*D(B . "0x6C55") ;; <CJK>
       (?$(0*E(B . "0x6C61") ;; <CJK>
       (?$(0*F(B . "0x6C5B") ;; <CJK>
       (?$(0*G(B . "0x6C4D") ;; <CJK>
       (?$(0*H(B . "0x6C4E") ;; <CJK>
       (?$(0*I(B . "0x7070") ;; <CJK>
       (?$(0*J(B . "0x725F") ;; <CJK>
       (?$(0*K(B . "0x725D") ;; <CJK>
       (?$(0*L(B . "0x767E") ;; <CJK>
       (?$(0*M(B . "0x7AF9") ;; <CJK>
       (?$(0*N(B . "0x7C73") ;; <CJK>
       (?$(0*O(B . "0x7CF8") ;; <CJK>
       (?$(0*P(B . "0x7F36") ;; <CJK>
       (?$(0*Q(B . "0x7F8A") ;; <CJK>
       (?$(0*R(B . "0x7FBD") ;; <CJK>
       (?$(0*S(B . "0x8001") ;; <CJK>
       (?$(0*T(B . "0x8003") ;; <CJK>
       (?$(0*U(B . "0x800C") ;; <CJK>
       (?$(0*V(B . "0x8012") ;; <CJK>
       (?$(0*W(B . "0x8033") ;; <CJK>
       (?$(0*X(B . "0x807F") ;; <CJK>
       (?$(0*Y(B . "0x8089") ;; <CJK>
       (?$(0*Z(B . "0x808B") ;; <CJK>
       (?$(0*[(B . "0x808C") ;; <CJK>
       (?$(0*\(B . "0x81E3") ;; <CJK>
       (?$(0*](B . "0x81EA") ;; <CJK>
       (?$(0*^(B . "0x81F3") ;; <CJK>
       (?$(0*_(B . "0x81FC") ;; <CJK>
       (?$(0*`(B . "0x820C") ;; <CJK>
       (?$(0*a(B . "0x821B") ;; <CJK>
       (?$(0*b(B . "0x821F") ;; <CJK>
       (?$(0*c(B . "0x826E") ;; <CJK>
       (?$(0*d(B . "0x8272") ;; <CJK>
       (?$(0*e(B . "0x827E") ;; <CJK>
       (?$(0*f(B . "0x866B") ;; <CJK>
       (?$(0*g(B . "0x8840") ;; <CJK>
       (?$(0*h(B . "0x884C") ;; <CJK>
       (?$(0*i(B . "0x8863") ;; <CJK>
       (?$(0*j(B . "0x897F") ;; <CJK>
       (?$(0*k(B . "0x9621") ;; <CJK>
       (?$(0*l(B . "0x4E32") ;; <CJK>
       (?$(0*m(B . "0x4EA8") ;; <CJK>
       (?$(0*n(B . "0x4F4D") ;; <CJK>
       (?$(0*o(B . "0x4F4F") ;; <CJK>
       (?$(0*p(B . "0x4F47") ;; <CJK>
       (?$(0*q(B . "0x4F57") ;; <CJK>
       (?$(0*r(B . "0x4F5E") ;; <CJK>
       (?$(0*s(B . "0x4F34") ;; <CJK>
       (?$(0*t(B . "0x4F5B") ;; <CJK>
       (?$(0*u(B . "0x4F55") ;; <CJK>
       (?$(0*v(B . "0x4F30") ;; <CJK>
       (?$(0*w(B . "0x4F50") ;; <CJK>
       (?$(0*x(B . "0x4F51") ;; <CJK>
       (?$(0*y(B . "0x4F3D") ;; <CJK>
       (?$(0*z(B . "0x4F3A") ;; <CJK>
       (?$(0*{(B . "0x4F38") ;; <CJK>
       (?$(0*|(B . "0x4F43") ;; <CJK>
       (?$(0*}(B . "0x4F54") ;; <CJK>
       (?$(0*~(B . "0x4F3C") ;; <CJK>
       (?$(0+!(B . "0x4F46") ;; <CJK>
       (?$(0+"(B . "0x4F63") ;; <CJK>
       (?$(0+#(B . "0x4F5C") ;; <CJK>
       (?$(0+$(B . "0x4F60") ;; <CJK>
       (?$(0+%(B . "0x4F2F") ;; <CJK>
       (?$(0+&(B . "0x4F4E") ;; <CJK>
       (?$(0+'(B . "0x4F36") ;; <CJK>
       (?$(0+((B . "0x4F59") ;; <CJK>
       (?$(0+)(B . "0x4F5D") ;; <CJK>
       (?$(0+*(B . "0x4F48") ;; <CJK>
       (?$(0++(B . "0x4F5A") ;; <CJK>
       (?$(0+,(B . "0x514C") ;; <CJK>
       (?$(0+-(B . "0x514B") ;; <CJK>
       (?$(0+.(B . "0x514D") ;; <CJK>
       (?$(0+/(B . "0x5175") ;; <CJK>
       (?$(0+0(B . "0x51B6") ;; <CJK>
       (?$(0+1(B . "0x51B7") ;; <CJK>
       (?$(0+2(B . "0x5225") ;; <CJK>
       (?$(0+3(B . "0x5224") ;; <CJK>
       (?$(0+4(B . "0x5229") ;; <CJK>
       (?$(0+5(B . "0x522A") ;; <CJK>
       (?$(0+6(B . "0x5228") ;; <CJK>
       (?$(0+7(B . "0x52AB") ;; <CJK>
       (?$(0+8(B . "0x52A9") ;; <CJK>
       (?$(0+9(B . "0x52AA") ;; <CJK>
       (?$(0+:(B . "0x52AC") ;; <CJK>
       (?$(0+;(B . "0x5323") ;; <CJK>
       (?$(0+<(B . "0x5373") ;; <CJK>
       (?$(0+=(B . "0x5375") ;; <CJK>
       (?$(0+>(B . "0x541D") ;; <CJK>
       (?$(0+?(B . "0x542D") ;; <CJK>
       (?$(0+@(B . "0x541E") ;; <CJK>
       (?$(0+A(B . "0x543E") ;; <CJK>
       (?$(0+B(B . "0x5426") ;; <CJK>
       (?$(0+C(B . "0x544E") ;; <CJK>
       (?$(0+D(B . "0x5427") ;; <CJK>
       (?$(0+E(B . "0x5446") ;; <CJK>
       (?$(0+F(B . "0x5443") ;; <CJK>
       (?$(0+G(B . "0x5433") ;; <CJK>
       (?$(0+H(B . "0x5448") ;; <CJK>
       (?$(0+I(B . "0x5442") ;; <CJK>
       (?$(0+J(B . "0x541B") ;; <CJK>
       (?$(0+K(B . "0x5429") ;; <CJK>
       (?$(0+L(B . "0x544A") ;; <CJK>
       (?$(0+M(B . "0x5439") ;; <CJK>
       (?$(0+N(B . "0x543B") ;; <CJK>
       (?$(0+O(B . "0x5438") ;; <CJK>
       (?$(0+P(B . "0x542E") ;; <CJK>
       (?$(0+Q(B . "0x5435") ;; <CJK>
       (?$(0+R(B . "0x5436") ;; <CJK>
       (?$(0+S(B . "0x5420") ;; <CJK>
       (?$(0+T(B . "0x543C") ;; <CJK>
       (?$(0+U(B . "0x5440") ;; <CJK>
       (?$(0+V(B . "0x5431") ;; <CJK>
       (?$(0+W(B . "0x542B") ;; <CJK>
       (?$(0+X(B . "0x541F") ;; <CJK>
       (?$(0+Y(B . "0x542C") ;; <CJK>
       (?$(0+Z(B . "0x56EA") ;; <CJK>
       (?$(0+[(B . "0x56F0") ;; <CJK>
       (?$(0+\(B . "0x56E4") ;; <CJK>
       (?$(0+](B . "0x56EB") ;; <CJK>
       (?$(0+^(B . "0x574A") ;; <CJK>
       (?$(0+_(B . "0x5751") ;; <CJK>
       (?$(0+`(B . "0x5740") ;; <CJK>
       (?$(0+a(B . "0x574D") ;; <CJK>
       (?$(0+b(B . "0x5747") ;; <CJK>
       (?$(0+c(B . "0x574E") ;; <CJK>
       (?$(0+d(B . "0x573E") ;; <CJK>
       (?$(0+e(B . "0x5750") ;; <CJK>
       (?$(0+f(B . "0x574F") ;; <CJK>
       (?$(0+g(B . "0x573B") ;; <CJK>
       (?$(0+h(B . "0x58EF") ;; <CJK>
       (?$(0+i(B . "0x593E") ;; <CJK>
       (?$(0+j(B . "0x599D") ;; <CJK>
       (?$(0+k(B . "0x5992") ;; <CJK>
       (?$(0+l(B . "0x59A8") ;; <CJK>
       (?$(0+m(B . "0x599E") ;; <CJK>
       (?$(0+n(B . "0x59A3") ;; <CJK>
       (?$(0+o(B . "0x5999") ;; <CJK>
       (?$(0+p(B . "0x5996") ;; <CJK>
       (?$(0+q(B . "0x598D") ;; <CJK>
       (?$(0+r(B . "0x59A4") ;; <CJK>
       (?$(0+s(B . "0x5993") ;; <CJK>
       (?$(0+t(B . "0x598A") ;; <CJK>
       (?$(0+u(B . "0x59A5") ;; <CJK>
       (?$(0+v(B . "0x5B5D") ;; <CJK>
       (?$(0+w(B . "0x5B5C") ;; <CJK>
       (?$(0+x(B . "0x5B5A") ;; <CJK>
       (?$(0+y(B . "0x5B5B") ;; <CJK>
       (?$(0+z(B . "0x5B8C") ;; <CJK>
       (?$(0+{(B . "0x5B8B") ;; <CJK>
       (?$(0+|(B . "0x5B8F") ;; <CJK>
       (?$(0+}(B . "0x5C2C") ;; <CJK>
       (?$(0+~(B . "0x5C40") ;; <CJK>
       (?$(0,!(B . "0x5C41") ;; <CJK>
       (?$(0,"(B . "0x5C3F") ;; <CJK>
       (?$(0,#(B . "0x5C3E") ;; <CJK>
       (?$(0,$(B . "0x5C90") ;; <CJK>
       (?$(0,%(B . "0x5C91") ;; <CJK>
       (?$(0,&(B . "0x5C94") ;; <CJK>
       (?$(0,'(B . "0x5C8C") ;; <CJK>
       (?$(0,((B . "0x5DEB") ;; <CJK>
       (?$(0,)(B . "0x5E0C") ;; <CJK>
       (?$(0,*(B . "0x5E8F") ;; <CJK>
       (?$(0,+(B . "0x5E87") ;; <CJK>
       (?$(0,,(B . "0x5E8A") ;; <CJK>
       (?$(0,-(B . "0x5EF7") ;; <CJK>
       (?$(0,.(B . "0x5F04") ;; <CJK>
       (?$(0,/(B . "0x5F1F") ;; <CJK>
       (?$(0,0(B . "0x5F64") ;; <CJK>
       (?$(0,1(B . "0x5F62") ;; <CJK>
       (?$(0,2(B . "0x5F77") ;; <CJK>
       (?$(0,3(B . "0x5F79") ;; <CJK>
       (?$(0,4(B . "0x5FD8") ;; <CJK>
       (?$(0,5(B . "0x5FCC") ;; <CJK>
       (?$(0,6(B . "0x5FD7") ;; <CJK>
       (?$(0,7(B . "0x5FCD") ;; <CJK>
       (?$(0,8(B . "0x5FF1") ;; <CJK>
       (?$(0,9(B . "0x5FEB") ;; <CJK>
       (?$(0,:(B . "0x5FF8") ;; <CJK>
       (?$(0,;(B . "0x5FEA") ;; <CJK>
       (?$(0,<(B . "0x6212") ;; <CJK>
       (?$(0,=(B . "0x6211") ;; <CJK>
       (?$(0,>(B . "0x6284") ;; <CJK>
       (?$(0,?(B . "0x6297") ;; <CJK>
       (?$(0,@(B . "0x6296") ;; <CJK>
       (?$(0,A(B . "0x6280") ;; <CJK>
       (?$(0,B(B . "0x6276") ;; <CJK>
       (?$(0,C(B . "0x6289") ;; <CJK>
       (?$(0,D(B . "0x626D") ;; <CJK>
       (?$(0,E(B . "0x628A") ;; <CJK>
       (?$(0,F(B . "0x627C") ;; <CJK>
       (?$(0,G(B . "0x627E") ;; <CJK>
       (?$(0,H(B . "0x6279") ;; <CJK>
       (?$(0,I(B . "0x6273") ;; <CJK>
       (?$(0,J(B . "0x6292") ;; <CJK>
       (?$(0,K(B . "0x626F") ;; <CJK>
       (?$(0,L(B . "0x6298") ;; <CJK>
       (?$(0,M(B . "0x626E") ;; <CJK>
       (?$(0,N(B . "0x6295") ;; <CJK>
       (?$(0,O(B . "0x6293") ;; <CJK>
       (?$(0,P(B . "0x6291") ;; <CJK>
       (?$(0,Q(B . "0x6286") ;; <CJK>
       (?$(0,R(B . "0x6539") ;; <CJK>
       (?$(0,S(B . "0x653B") ;; <CJK>
       (?$(0,T(B . "0x6538") ;; <CJK>
       (?$(0,U(B . "0x65F1") ;; <CJK>
       (?$(0,V(B . "0x66F4") ;; <CJK>
       (?$(0,W(B . "0x675F") ;; <CJK>
       (?$(0,X(B . "0x674E") ;; <CJK>
       (?$(0,Y(B . "0x674F") ;; <CJK>
       (?$(0,Z(B . "0x6750") ;; <CJK>
       (?$(0,[(B . "0x6751") ;; <CJK>
       (?$(0,\(B . "0x675C") ;; <CJK>
       (?$(0,](B . "0x6756") ;; <CJK>
       (?$(0,^(B . "0x675E") ;; <CJK>
       (?$(0,_(B . "0x6749") ;; <CJK>
       (?$(0,`(B . "0x6746") ;; <CJK>
       (?$(0,a(B . "0x6760") ;; <CJK>
       (?$(0,b(B . "0x6753") ;; <CJK>
       (?$(0,c(B . "0x6757") ;; <CJK>
       (?$(0,d(B . "0x6B65") ;; <CJK>
       (?$(0,e(B . "0x6BCF") ;; <CJK>
       (?$(0,f(B . "0x6C42") ;; <CJK>
       (?$(0,g(B . "0x6C5E") ;; <CJK>
       (?$(0,h(B . "0x6C99") ;; <CJK>
       (?$(0,i(B . "0x6C81") ;; <CJK>
       (?$(0,j(B . "0x6C88") ;; <CJK>
       (?$(0,k(B . "0x6C89") ;; <CJK>
       (?$(0,l(B . "0x6C85") ;; <CJK>
       (?$(0,m(B . "0x6C9B") ;; <CJK>
       (?$(0,n(B . "0x6C6A") ;; <CJK>
       (?$(0,o(B . "0x6C7A") ;; <CJK>
       (?$(0,p(B . "0x6C90") ;; <CJK>
       (?$(0,q(B . "0x6C70") ;; <CJK>
       (?$(0,r(B . "0x6C8C") ;; <CJK>
       (?$(0,s(B . "0x6C68") ;; <CJK>
       (?$(0,t(B . "0x6C96") ;; <CJK>
       (?$(0,u(B . "0x6C92") ;; <CJK>
       (?$(0,v(B . "0x6C7D") ;; <CJK>
       (?$(0,w(B . "0x6C83") ;; <CJK>
       (?$(0,x(B . "0x6C72") ;; <CJK>
       (?$(0,y(B . "0x6C7E") ;; <CJK>
       (?$(0,z(B . "0x6C74") ;; <CJK>
       (?$(0,{(B . "0x6C86") ;; <CJK>
       (?$(0,|(B . "0x6C76") ;; <CJK>
       (?$(0,}(B . "0x6C8D") ;; <CJK>
       (?$(0,~(B . "0x6C94") ;; <CJK>
       (?$(0-!(B . "0x6C98") ;; <CJK>
       (?$(0-"(B . "0x6C82") ;; <CJK>
       (?$(0-#(B . "0x7076") ;; <CJK>
       (?$(0-$(B . "0x707C") ;; <CJK>
       (?$(0-%(B . "0x707D") ;; <CJK>
       (?$(0-&(B . "0x7078") ;; <CJK>
       (?$(0-'(B . "0x7262") ;; <CJK>
       (?$(0-((B . "0x7261") ;; <CJK>
       (?$(0-)(B . "0x7260") ;; <CJK>
       (?$(0-*(B . "0x72C4") ;; <CJK>
       (?$(0-+(B . "0x72C2") ;; <CJK>
       (?$(0-,(B . "0x7396") ;; <CJK>
       (?$(0--(B . "0x752C") ;; <CJK>
       (?$(0-.(B . "0x752B") ;; <CJK>
       (?$(0-/(B . "0x7537") ;; <CJK>
       (?$(0-0(B . "0x7538") ;; <CJK>
       (?$(0-1(B . "0x7682") ;; <CJK>
       (?$(0-2(B . "0x76EF") ;; <CJK>
       (?$(0-3(B . "0x77E3") ;; <CJK>
       (?$(0-4(B . "0x79C1") ;; <CJK>
       (?$(0-5(B . "0x79C0") ;; <CJK>
       (?$(0-6(B . "0x79BF") ;; <CJK>
       (?$(0-7(B . "0x7A76") ;; <CJK>
       (?$(0-8(B . "0x7CFB") ;; <CJK>
       (?$(0-9(B . "0x7F55") ;; <CJK>
       (?$(0-:(B . "0x8096") ;; <CJK>
       (?$(0-;(B . "0x8093") ;; <CJK>
       (?$(0-<(B . "0x809D") ;; <CJK>
       (?$(0-=(B . "0x8098") ;; <CJK>
       (?$(0->(B . "0x809B") ;; <CJK>
       (?$(0-?(B . "0x809A") ;; <CJK>
       (?$(0-@(B . "0x80B2") ;; <CJK>
       (?$(0-A(B . "0x826F") ;; <CJK>
       (?$(0-B(B . "0x8292") ;; <CJK>
       (?$(0-C(B . "0x828B") ;; <CJK>
       (?$(0-D(B . "0x828D") ;; <CJK>
       (?$(0-E(B . "0x898B") ;; <CJK>
       (?$(0-F(B . "0x89D2") ;; <CJK>
       (?$(0-G(B . "0x8A00") ;; <CJK>
       (?$(0-H(B . "0x8C37") ;; <CJK>
       (?$(0-I(B . "0x8C46") ;; <CJK>
       (?$(0-J(B . "0x8C55") ;; <CJK>
       (?$(0-K(B . "0x8C9D") ;; <CJK>
       (?$(0-L(B . "0x8D64") ;; <CJK>
       (?$(0-M(B . "0x8D70") ;; <CJK>
       (?$(0-N(B . "0x8DB3") ;; <CJK>
       (?$(0-O(B . "0x8EAB") ;; <CJK>
       (?$(0-P(B . "0x8ECA") ;; <CJK>
       (?$(0-Q(B . "0x8F9B") ;; <CJK>
       (?$(0-R(B . "0x8FB0") ;; <CJK>
       (?$(0-S(B . "0x8FC2") ;; <CJK>
       (?$(0-T(B . "0x8FC6") ;; <CJK>
       (?$(0-U(B . "0x8FC5") ;; <CJK>
       (?$(0-V(B . "0x8FC4") ;; <CJK>
       (?$(0-W(B . "0x5DE1") ;; <CJK>
       (?$(0-X(B . "0x9091") ;; <CJK>
       (?$(0-Y(B . "0x90A2") ;; <CJK>
       (?$(0-Z(B . "0x90AA") ;; <CJK>
       (?$(0-[(B . "0x90A6") ;; <CJK>
       (?$(0-\(B . "0x90A3") ;; <CJK>
       (?$(0-](B . "0x9149") ;; <CJK>
       (?$(0-^(B . "0x91C6") ;; <CJK>
       (?$(0-_(B . "0x91CC") ;; <CJK>
       (?$(0-`(B . "0x9632") ;; <CJK>
       (?$(0-a(B . "0x962E") ;; <CJK>
       (?$(0-b(B . "0x9631") ;; <CJK>
       (?$(0-c(B . "0x962A") ;; <CJK>
       (?$(0-d(B . "0x962C") ;; <CJK>
       (?$(0-e(B . "0x4E26") ;; <CJK>
       (?$(0-f(B . "0x4E56") ;; <CJK>
       (?$(0-g(B . "0x4E73") ;; <CJK>
       (?$(0-h(B . "0x4E8B") ;; <CJK>
       (?$(0-i(B . "0x4E9B") ;; <CJK>
       (?$(0-j(B . "0x4E9E") ;; <CJK>
       (?$(0-k(B . "0x4EAB") ;; <CJK>
       (?$(0-l(B . "0x4EAC") ;; <CJK>
       (?$(0-m(B . "0x4F6F") ;; <CJK>
       (?$(0-n(B . "0x4F9D") ;; <CJK>
       (?$(0-o(B . "0x4F8D") ;; <CJK>
       (?$(0-p(B . "0x4F73") ;; <CJK>
       (?$(0-q(B . "0x4F7F") ;; <CJK>
       (?$(0-r(B . "0x4F6C") ;; <CJK>
       (?$(0-s(B . "0x4F9B") ;; <CJK>
       (?$(0-t(B . "0x4F8B") ;; <CJK>
       (?$(0-u(B . "0x4F86") ;; <CJK>
       (?$(0-v(B . "0x4F83") ;; <CJK>
       (?$(0-w(B . "0x4F70") ;; <CJK>
       (?$(0-x(B . "0x4F75") ;; <CJK>
       (?$(0-y(B . "0x4F88") ;; <CJK>
       (?$(0-z(B . "0x4F69") ;; <CJK>
       (?$(0-{(B . "0x4F7B") ;; <CJK>
       (?$(0-|(B . "0x4F96") ;; <CJK>
       (?$(0-}(B . "0x4F7E") ;; <CJK>
       (?$(0-~(B . "0x4F8F") ;; <CJK>
       (?$(0.!(B . "0x4F91") ;; <CJK>
       (?$(0."(B . "0x4F7A") ;; <CJK>
       (?$(0.#(B . "0x5154") ;; <CJK>
       (?$(0.$(B . "0x5152") ;; <CJK>
       (?$(0.%(B . "0x5155") ;; <CJK>
       (?$(0.&(B . "0x5169") ;; <CJK>
       (?$(0.'(B . "0x5177") ;; <CJK>
       (?$(0.((B . "0x5176") ;; <CJK>
       (?$(0.)(B . "0x5178") ;; <CJK>
       (?$(0.*(B . "0x51BD") ;; <CJK>
       (?$(0.+(B . "0x51FD") ;; <CJK>
       (?$(0.,(B . "0x523B") ;; <CJK>
       (?$(0.-(B . "0x5238") ;; <CJK>
       (?$(0..(B . "0x5237") ;; <CJK>
       (?$(0./(B . "0x523A") ;; <CJK>
       (?$(0.0(B . "0x5230") ;; <CJK>
       (?$(0.1(B . "0x522E") ;; <CJK>
       (?$(0.2(B . "0x5236") ;; <CJK>
       (?$(0.3(B . "0x5241") ;; <CJK>
       (?$(0.4(B . "0x52BE") ;; <CJK>
       (?$(0.5(B . "0x52BB") ;; <CJK>
       (?$(0.6(B . "0x5352") ;; <CJK>
       (?$(0.7(B . "0x5354") ;; <CJK>
       (?$(0.8(B . "0x5353") ;; <CJK>
       (?$(0.9(B . "0x5351") ;; <CJK>
       (?$(0.:(B . "0x5366") ;; <CJK>
       (?$(0.;(B . "0x5377") ;; <CJK>
       (?$(0.<(B . "0x5378") ;; <CJK>
       (?$(0.=(B . "0x5379") ;; <CJK>
       (?$(0.>(B . "0x53D6") ;; <CJK>
       (?$(0.?(B . "0x53D4") ;; <CJK>
       (?$(0.@(B . "0x53D7") ;; <CJK>
       (?$(0.A(B . "0x5473") ;; <CJK>
       (?$(0.B(B . "0x5475") ;; <CJK>
       (?$(0.C(B . "0x5496") ;; <CJK>
       (?$(0.D(B . "0x5478") ;; <CJK>
       (?$(0.E(B . "0x5495") ;; <CJK>
       (?$(0.F(B . "0x5480") ;; <CJK>
       (?$(0.G(B . "0x547B") ;; <CJK>
       (?$(0.H(B . "0x5477") ;; <CJK>
       (?$(0.I(B . "0x5484") ;; <CJK>
       (?$(0.J(B . "0x5492") ;; <CJK>
       (?$(0.K(B . "0x5486") ;; <CJK>
       (?$(0.L(B . "0x547C") ;; <CJK>
       (?$(0.M(B . "0x5490") ;; <CJK>
       (?$(0.N(B . "0x5471") ;; <CJK>
       (?$(0.O(B . "0x5476") ;; <CJK>
       (?$(0.P(B . "0x548C") ;; <CJK>
       (?$(0.Q(B . "0x549A") ;; <CJK>
       (?$(0.R(B . "0x5462") ;; <CJK>
       (?$(0.S(B . "0x5468") ;; <CJK>
       (?$(0.T(B . "0x548B") ;; <CJK>
       (?$(0.U(B . "0x547D") ;; <CJK>
       (?$(0.V(B . "0x548E") ;; <CJK>
       (?$(0.W(B . "0x56FA") ;; <CJK>
       (?$(0.X(B . "0x5783") ;; <CJK>
       (?$(0.Y(B . "0x5777") ;; <CJK>
       (?$(0.Z(B . "0x576A") ;; <CJK>
       (?$(0.[(B . "0x5769") ;; <CJK>
       (?$(0.\(B . "0x5761") ;; <CJK>
       (?$(0.](B . "0x5766") ;; <CJK>
       (?$(0.^(B . "0x5764") ;; <CJK>
       (?$(0._(B . "0x577C") ;; <CJK>
       (?$(0.`(B . "0x591C") ;; <CJK>
       (?$(0.a(B . "0x5949") ;; <CJK>
       (?$(0.b(B . "0x5947") ;; <CJK>
       (?$(0.c(B . "0x5948") ;; <CJK>
       (?$(0.d(B . "0x5944") ;; <CJK>
       (?$(0.e(B . "0x5954") ;; <CJK>
       (?$(0.f(B . "0x59BE") ;; <CJK>
       (?$(0.g(B . "0x59BB") ;; <CJK>
       (?$(0.h(B . "0x59D4") ;; <CJK>
       (?$(0.i(B . "0x59B9") ;; <CJK>
       (?$(0.j(B . "0x59AE") ;; <CJK>
       (?$(0.k(B . "0x59D1") ;; <CJK>
       (?$(0.l(B . "0x59C6") ;; <CJK>
       (?$(0.m(B . "0x59D0") ;; <CJK>
       (?$(0.n(B . "0x59CD") ;; <CJK>
       (?$(0.o(B . "0x59CB") ;; <CJK>
       (?$(0.p(B . "0x59D3") ;; <CJK>
       (?$(0.q(B . "0x59CA") ;; <CJK>
       (?$(0.r(B . "0x59AF") ;; <CJK>
       (?$(0.s(B . "0x59B3") ;; <CJK>
       (?$(0.t(B . "0x59D2") ;; <CJK>
       (?$(0.u(B . "0x59C5") ;; <CJK>
       (?$(0.v(B . "0x5B5F") ;; <CJK>
       (?$(0.w(B . "0x5B64") ;; <CJK>
       (?$(0.x(B . "0x5B63") ;; <CJK>
       (?$(0.y(B . "0x5B97") ;; <CJK>
       (?$(0.z(B . "0x5B9A") ;; <CJK>
       (?$(0.{(B . "0x5B98") ;; <CJK>
       (?$(0.|(B . "0x5B9C") ;; <CJK>
       (?$(0.}(B . "0x5B99") ;; <CJK>
       (?$(0.~(B . "0x5B9B") ;; <CJK>
       (?$(0/!(B . "0x5C1A") ;; <CJK>
       (?$(0/"(B . "0x5C48") ;; <CJK>
       (?$(0/#(B . "0x5C45") ;; <CJK>
       (?$(0/$(B . "0x5C46") ;; <CJK>
       (?$(0/%(B . "0x5CB7") ;; <CJK>
       (?$(0/&(B . "0x5CA1") ;; <CJK>
       (?$(0/'(B . "0x5CB8") ;; <CJK>
       (?$(0/((B . "0x5CA9") ;; <CJK>
       (?$(0/)(B . "0x5CAB") ;; <CJK>
       (?$(0/*(B . "0x5CB1") ;; <CJK>
       (?$(0/+(B . "0x5CB3") ;; <CJK>
       (?$(0/,(B . "0x5E18") ;; <CJK>
       (?$(0/-(B . "0x5E1A") ;; <CJK>
       (?$(0/.(B . "0x5E16") ;; <CJK>
       (?$(0//(B . "0x5E15") ;; <CJK>
       (?$(0/0(B . "0x5E1B") ;; <CJK>
       (?$(0/1(B . "0x5E11") ;; <CJK>
       (?$(0/2(B . "0x5E78") ;; <CJK>
       (?$(0/3(B . "0x5E9A") ;; <CJK>
       (?$(0/4(B . "0x5E97") ;; <CJK>
       (?$(0/5(B . "0x5E9C") ;; <CJK>
       (?$(0/6(B . "0x5E95") ;; <CJK>
       (?$(0/7(B . "0x5E96") ;; <CJK>
       (?$(0/8(B . "0x5EF6") ;; <CJK>
       (?$(0/9(B . "0x5F26") ;; <CJK>
       (?$(0/:(B . "0x5F27") ;; <CJK>
       (?$(0/;(B . "0x5F29") ;; <CJK>
       (?$(0/<(B . "0x5F80") ;; <CJK>
       (?$(0/=(B . "0x5F81") ;; <CJK>
       (?$(0/>(B . "0x5F7F") ;; <CJK>
       (?$(0/?(B . "0x5F7C") ;; <CJK>
       (?$(0/@(B . "0x5FDD") ;; <CJK>
       (?$(0/A(B . "0x5FE0") ;; <CJK>
       (?$(0/B(B . "0x5FFD") ;; <CJK>
       (?$(0/C(B . "0x5FF5") ;; <CJK>
       (?$(0/D(B . "0x5FFF") ;; <CJK>
       (?$(0/E(B . "0x600F") ;; <CJK>
       (?$(0/F(B . "0x6014") ;; <CJK>
       (?$(0/G(B . "0x602F") ;; <CJK>
       (?$(0/H(B . "0x6035") ;; <CJK>
       (?$(0/I(B . "0x6016") ;; <CJK>
       (?$(0/J(B . "0x602A") ;; <CJK>
       (?$(0/K(B . "0x6015") ;; <CJK>
       (?$(0/L(B . "0x6021") ;; <CJK>
       (?$(0/M(B . "0x6027") ;; <CJK>
       (?$(0/N(B . "0x6029") ;; <CJK>
       (?$(0/O(B . "0x602B") ;; <CJK>
       (?$(0/P(B . "0x601B") ;; <CJK>
       (?$(0/Q(B . "0x6216") ;; <CJK>
       (?$(0/R(B . "0x6215") ;; <CJK>
       (?$(0/S(B . "0x623F") ;; <CJK>
       (?$(0/T(B . "0x623E") ;; <CJK>
       (?$(0/U(B . "0x6240") ;; <CJK>
       (?$(0/V(B . "0x627F") ;; <CJK>
       (?$(0/W(B . "0x62C9") ;; <CJK>
       (?$(0/X(B . "0x62CC") ;; <CJK>
       (?$(0/Y(B . "0x62C4") ;; <CJK>
       (?$(0/Z(B . "0x62BF") ;; <CJK>
       (?$(0/[(B . "0x62C2") ;; <CJK>
       (?$(0/\(B . "0x62B9") ;; <CJK>
       (?$(0/](B . "0x62D2") ;; <CJK>
       (?$(0/^(B . "0x62DB") ;; <CJK>
       (?$(0/_(B . "0x62AB") ;; <CJK>
       (?$(0/`(B . "0x62D3") ;; <CJK>
       (?$(0/a(B . "0x62D4") ;; <CJK>
       (?$(0/b(B . "0x62CB") ;; <CJK>
       (?$(0/c(B . "0x62C8") ;; <CJK>
       (?$(0/d(B . "0x62A8") ;; <CJK>
       (?$(0/e(B . "0x62BD") ;; <CJK>
       (?$(0/f(B . "0x62BC") ;; <CJK>
       (?$(0/g(B . "0x62D0") ;; <CJK>
       (?$(0/h(B . "0x62D9") ;; <CJK>
       (?$(0/i(B . "0x62C7") ;; <CJK>
       (?$(0/j(B . "0x62CD") ;; <CJK>
       (?$(0/k(B . "0x62B5") ;; <CJK>
       (?$(0/l(B . "0x62DA") ;; <CJK>
       (?$(0/m(B . "0x62B1") ;; <CJK>
       (?$(0/n(B . "0x62D8") ;; <CJK>
       (?$(0/o(B . "0x62D6") ;; <CJK>
       (?$(0/p(B . "0x62D7") ;; <CJK>
       (?$(0/q(B . "0x62C6") ;; <CJK>
       (?$(0/r(B . "0x62AC") ;; <CJK>
       (?$(0/s(B . "0x62CE") ;; <CJK>
       (?$(0/t(B . "0x653E") ;; <CJK>
       (?$(0/u(B . "0x65A7") ;; <CJK>
       (?$(0/v(B . "0x65BC") ;; <CJK>
       (?$(0/w(B . "0x65FA") ;; <CJK>
       (?$(0/x(B . "0x6614") ;; <CJK>
       (?$(0/y(B . "0x6613") ;; <CJK>
       (?$(0/z(B . "0x660C") ;; <CJK>
       (?$(0/{(B . "0x6606") ;; <CJK>
       (?$(0/|(B . "0x6602") ;; <CJK>
       (?$(0/}(B . "0x660E") ;; <CJK>
       (?$(0/~(B . "0x6600") ;; <CJK>
       (?$(00!(B . "0x660F") ;; <CJK>
       (?$(00"(B . "0x6615") ;; <CJK>
       (?$(00#(B . "0x660A") ;; <CJK>
       (?$(00$(B . "0x6607") ;; <CJK>
       (?$(00%(B . "0x670D") ;; <CJK>
       (?$(00&(B . "0x670B") ;; <CJK>
       (?$(00'(B . "0x676D") ;; <CJK>
       (?$(00((B . "0x678B") ;; <CJK>
       (?$(00)(B . "0x6795") ;; <CJK>
       (?$(00*(B . "0x6771") ;; <CJK>
       (?$(00+(B . "0x679C") ;; <CJK>
       (?$(00,(B . "0x6773") ;; <CJK>
       (?$(00-(B . "0x6777") ;; <CJK>
       (?$(00.(B . "0x6787") ;; <CJK>
       (?$(00/(B . "0x679D") ;; <CJK>
       (?$(000(B . "0x6797") ;; <CJK>
       (?$(001(B . "0x676F") ;; <CJK>
       (?$(002(B . "0x6770") ;; <CJK>
       (?$(003(B . "0x677F") ;; <CJK>
       (?$(004(B . "0x6789") ;; <CJK>
       (?$(005(B . "0x677E") ;; <CJK>
       (?$(006(B . "0x6790") ;; <CJK>
       (?$(007(B . "0x6775") ;; <CJK>
       (?$(008(B . "0x679A") ;; <CJK>
       (?$(009(B . "0x6793") ;; <CJK>
       (?$(00:(B . "0x677C") ;; <CJK>
       (?$(00;(B . "0x676A") ;; <CJK>
       (?$(00<(B . "0x6772") ;; <CJK>
       (?$(00=(B . "0x6B23") ;; <CJK>
       (?$(00>(B . "0x6B66") ;; <CJK>
       (?$(00?(B . "0x6B67") ;; <CJK>
       (?$(00@(B . "0x6B7F") ;; <CJK>
       (?$(00A(B . "0x6C13") ;; <CJK>
       (?$(00B(B . "0x6C1B") ;; <CJK>
       (?$(00C(B . "0x6CE3") ;; <CJK>
       (?$(00D(B . "0x6CE8") ;; <CJK>
       (?$(00E(B . "0x6CF3") ;; <CJK>
       (?$(00F(B . "0x6CB1") ;; <CJK>
       (?$(00G(B . "0x6CCC") ;; <CJK>
       (?$(00H(B . "0x6CE5") ;; <CJK>
       (?$(00I(B . "0x6CB3") ;; <CJK>
       (?$(00J(B . "0x6CBD") ;; <CJK>
       (?$(00K(B . "0x6CBE") ;; <CJK>
       (?$(00L(B . "0x6CBC") ;; <CJK>
       (?$(00M(B . "0x6CE2") ;; <CJK>
       (?$(00N(B . "0x6CAB") ;; <CJK>
       (?$(00O(B . "0x6CD5") ;; <CJK>
       (?$(00P(B . "0x6CD3") ;; <CJK>
       (?$(00Q(B . "0x6CB8") ;; <CJK>
       (?$(00R(B . "0x6CC4") ;; <CJK>
       (?$(00S(B . "0x6CB9") ;; <CJK>
       (?$(00T(B . "0x6CC1") ;; <CJK>
       (?$(00U(B . "0x6CAE") ;; <CJK>
       (?$(00V(B . "0x6CD7") ;; <CJK>
       (?$(00W(B . "0x6CC5") ;; <CJK>
       (?$(00X(B . "0x6CF1") ;; <CJK>
       (?$(00Y(B . "0x6CBF") ;; <CJK>
       (?$(00Z(B . "0x6CBB") ;; <CJK>
       (?$(00[(B . "0x6CE1") ;; <CJK>
       (?$(00\(B . "0x6CDB") ;; <CJK>
       (?$(00](B . "0x6CCA") ;; <CJK>
       (?$(00^(B . "0x6CAC") ;; <CJK>
       (?$(00_(B . "0x6CEF") ;; <CJK>
       (?$(00`(B . "0x6CDC") ;; <CJK>
       (?$(00a(B . "0x6CD6") ;; <CJK>
       (?$(00b(B . "0x6CE0") ;; <CJK>
       (?$(00c(B . "0x7095") ;; <CJK>
       (?$(00d(B . "0x708E") ;; <CJK>
       (?$(00e(B . "0x7092") ;; <CJK>
       (?$(00f(B . "0x708A") ;; <CJK>
       (?$(00g(B . "0x7099") ;; <CJK>
       (?$(00h(B . "0x722C") ;; <CJK>
       (?$(00i(B . "0x722D") ;; <CJK>
       (?$(00j(B . "0x7238") ;; <CJK>
       (?$(00k(B . "0x7248") ;; <CJK>
       (?$(00l(B . "0x7267") ;; <CJK>
       (?$(00m(B . "0x7269") ;; <CJK>
       (?$(00n(B . "0x72C0") ;; <CJK>
       (?$(00o(B . "0x72CE") ;; <CJK>
       (?$(00p(B . "0x72D9") ;; <CJK>
       (?$(00q(B . "0x72D7") ;; <CJK>
       (?$(00r(B . "0x72D0") ;; <CJK>
       (?$(00s(B . "0x73A9") ;; <CJK>
       (?$(00t(B . "0x73A8") ;; <CJK>
       (?$(00u(B . "0x739F") ;; <CJK>
       (?$(00v(B . "0x73AB") ;; <CJK>
       (?$(00w(B . "0x73A5") ;; <CJK>
       (?$(00x(B . "0x753D") ;; <CJK>
       (?$(00y(B . "0x759D") ;; <CJK>
       (?$(00z(B . "0x7599") ;; <CJK>
       (?$(00{(B . "0x759A") ;; <CJK>
       (?$(00|(B . "0x7684") ;; <CJK>
       (?$(00}(B . "0x76C2") ;; <CJK>
       (?$(00~(B . "0x76F2") ;; <CJK>
       (?$(01!(B . "0x76F4") ;; <CJK>
       (?$(01"(B . "0x77E5") ;; <CJK>
       (?$(01#(B . "0x77FD") ;; <CJK>
       (?$(01$(B . "0x793E") ;; <CJK>
       (?$(01%(B . "0x7940") ;; <CJK>
       (?$(01&(B . "0x7941") ;; <CJK>
       (?$(01'(B . "0x79C9") ;; <CJK>
       (?$(01((B . "0x79C8") ;; <CJK>
       (?$(01)(B . "0x7A7A") ;; <CJK>
       (?$(01*(B . "0x7A79") ;; <CJK>
       (?$(01+(B . "0x7AFA") ;; <CJK>
       (?$(01,(B . "0x7CFE") ;; <CJK>
       (?$(01-(B . "0x7F54") ;; <CJK>
       (?$(01.(B . "0x7F8C") ;; <CJK>
       (?$(01/(B . "0x7F8B") ;; <CJK>
       (?$(010(B . "0x8005") ;; <CJK>
       (?$(011(B . "0x80BA") ;; <CJK>
       (?$(012(B . "0x80A5") ;; <CJK>
       (?$(013(B . "0x80A2") ;; <CJK>
       (?$(014(B . "0x80B1") ;; <CJK>
       (?$(015(B . "0x80A1") ;; <CJK>
       (?$(016(B . "0x80AB") ;; <CJK>
       (?$(017(B . "0x80A9") ;; <CJK>
       (?$(018(B . "0x80B4") ;; <CJK>
       (?$(019(B . "0x80AA") ;; <CJK>
       (?$(01:(B . "0x80AF") ;; <CJK>
       (?$(01;(B . "0x81E5") ;; <CJK>
       (?$(01<(B . "0x81FE") ;; <CJK>
       (?$(01=(B . "0x820D") ;; <CJK>
       (?$(01>(B . "0x82B3") ;; <CJK>
       (?$(01?(B . "0x829D") ;; <CJK>
       (?$(01@(B . "0x8299") ;; <CJK>
       (?$(01A(B . "0x82AD") ;; <CJK>
       (?$(01B(B . "0x82BD") ;; <CJK>
       (?$(01C(B . "0x829F") ;; <CJK>
       (?$(01D(B . "0x82B9") ;; <CJK>
       (?$(01E(B . "0x82B1") ;; <CJK>
       (?$(01F(B . "0x82AC") ;; <CJK>
       (?$(01G(B . "0x82A5") ;; <CJK>
       (?$(01H(B . "0x82AF") ;; <CJK>
       (?$(01I(B . "0x82B8") ;; <CJK>
       (?$(01J(B . "0x82A3") ;; <CJK>
       (?$(01K(B . "0x82B0") ;; <CJK>
       (?$(01L(B . "0x82BE") ;; <CJK>
       (?$(01M(B . "0x82B7") ;; <CJK>
       (?$(01N(B . "0x864E") ;; <CJK>
       (?$(01O(B . "0x8671") ;; <CJK>
       (?$(01P(B . "0x521D") ;; <CJK>
       (?$(01Q(B . "0x8868") ;; <CJK>
       (?$(01R(B . "0x8ECB") ;; <CJK>
       (?$(01S(B . "0x8FCE") ;; <CJK>
       (?$(01T(B . "0x8FD4") ;; <CJK>
       (?$(01U(B . "0x8FD1") ;; <CJK>
       (?$(01V(B . "0x90B5") ;; <CJK>
       (?$(01W(B . "0x90B8") ;; <CJK>
       (?$(01X(B . "0x90B1") ;; <CJK>
       (?$(01Y(B . "0x90B6") ;; <CJK>
       (?$(01Z(B . "0x91C7") ;; <CJK>
       (?$(01[(B . "0x91D1") ;; <CJK>
       (?$(01\(B . "0x9577") ;; <CJK>
       (?$(01](B . "0x9580") ;; <CJK>
       (?$(01^(B . "0x961C") ;; <CJK>
       (?$(01_(B . "0x9640") ;; <CJK>
       (?$(01`(B . "0x963F") ;; <CJK>
       (?$(01a(B . "0x963B") ;; <CJK>
       (?$(01b(B . "0x9644") ;; <CJK>
       (?$(01c(B . "0x9642") ;; <CJK>
       (?$(01d(B . "0x96B9") ;; <CJK>
       (?$(01e(B . "0x96E8") ;; <CJK>
       (?$(01f(B . "0x9752") ;; <CJK>
       (?$(01g(B . "0x975E") ;; <CJK>
       (?$(01h(B . "0x4E9F") ;; <CJK>
       (?$(01i(B . "0x4EAD") ;; <CJK>
       (?$(01j(B . "0x4EAE") ;; <CJK>
       (?$(01k(B . "0x4FE1") ;; <CJK>
       (?$(01l(B . "0x4FB5") ;; <CJK>
       (?$(01m(B . "0x4FAF") ;; <CJK>
       (?$(01n(B . "0x4FBF") ;; <CJK>
       (?$(01o(B . "0x4FE0") ;; <CJK>
       (?$(01p(B . "0x4FD1") ;; <CJK>
       (?$(01q(B . "0x4FCF") ;; <CJK>
       (?$(01r(B . "0x4FDD") ;; <CJK>
       (?$(01s(B . "0x4FC3") ;; <CJK>
       (?$(01t(B . "0x4FB6") ;; <CJK>
       (?$(01u(B . "0x4FD8") ;; <CJK>
       (?$(01v(B . "0x4FDF") ;; <CJK>
       (?$(01w(B . "0x4FCA") ;; <CJK>
       (?$(01x(B . "0x4FD7") ;; <CJK>
       (?$(01y(B . "0x4FAE") ;; <CJK>
       (?$(01z(B . "0x4FD0") ;; <CJK>
       (?$(01{(B . "0x4FC4") ;; <CJK>
       (?$(01|(B . "0x4FC2") ;; <CJK>
       (?$(01}(B . "0x4FDA") ;; <CJK>
       (?$(01~(B . "0x4FCE") ;; <CJK>
       (?$(02!(B . "0x4FDE") ;; <CJK>
       (?$(02"(B . "0x4FB7") ;; <CJK>
       (?$(02#(B . "0x5157") ;; <CJK>
       (?$(02$(B . "0x5192") ;; <CJK>
       (?$(02%(B . "0x5191") ;; <CJK>
       (?$(02&(B . "0x51A0") ;; <CJK>
       (?$(02'(B . "0x524E") ;; <CJK>
       (?$(02((B . "0x5243") ;; <CJK>
       (?$(02)(B . "0x524A") ;; <CJK>
       (?$(02*(B . "0x524D") ;; <CJK>
       (?$(02+(B . "0x524C") ;; <CJK>
       (?$(02,(B . "0x524B") ;; <CJK>
       (?$(02-(B . "0x5247") ;; <CJK>
       (?$(02.(B . "0x52C7") ;; <CJK>
       (?$(02/(B . "0x52C9") ;; <CJK>
       (?$(020(B . "0x52C3") ;; <CJK>
       (?$(021(B . "0x52C1") ;; <CJK>
       (?$(022(B . "0x530D") ;; <CJK>
       (?$(023(B . "0x5357") ;; <CJK>
       (?$(024(B . "0x537B") ;; <CJK>
       (?$(025(B . "0x539A") ;; <CJK>
       (?$(026(B . "0x53DB") ;; <CJK>
       (?$(027(B . "0x54AC") ;; <CJK>
       (?$(028(B . "0x54C0") ;; <CJK>
       (?$(029(B . "0x54A8") ;; <CJK>
       (?$(02:(B . "0x54CE") ;; <CJK>
       (?$(02;(B . "0x54C9") ;; <CJK>
       (?$(02<(B . "0x54B8") ;; <CJK>
       (?$(02=(B . "0x54A6") ;; <CJK>
       (?$(02>(B . "0x54B3") ;; <CJK>
       (?$(02?(B . "0x54C7") ;; <CJK>
       (?$(02@(B . "0x54C2") ;; <CJK>
       (?$(02A(B . "0x54BD") ;; <CJK>
       (?$(02B(B . "0x54AA") ;; <CJK>
       (?$(02C(B . "0x54C1") ;; <CJK>
       (?$(02D(B . "0x54C4") ;; <CJK>
       (?$(02E(B . "0x54C8") ;; <CJK>
       (?$(02F(B . "0x54AF") ;; <CJK>
       (?$(02G(B . "0x54AB") ;; <CJK>
       (?$(02H(B . "0x54B1") ;; <CJK>
       (?$(02I(B . "0x54BB") ;; <CJK>
       (?$(02J(B . "0x54A9") ;; <CJK>
       (?$(02K(B . "0x54A7") ;; <CJK>
       (?$(02L(B . "0x54BF") ;; <CJK>
       (?$(02M(B . "0x56FF") ;; <CJK>
       (?$(02N(B . "0x5782") ;; <CJK>
       (?$(02O(B . "0x578B") ;; <CJK>
       (?$(02P(B . "0x57A0") ;; <CJK>
       (?$(02Q(B . "0x57A3") ;; <CJK>
       (?$(02R(B . "0x57A2") ;; <CJK>
       (?$(02S(B . "0x57CE") ;; <CJK>
       (?$(02T(B . "0x57AE") ;; <CJK>
       (?$(02U(B . "0x5793") ;; <CJK>
       (?$(02V(B . "0x5955") ;; <CJK>
       (?$(02W(B . "0x5951") ;; <CJK>
       (?$(02X(B . "0x594F") ;; <CJK>
       (?$(02Y(B . "0x594E") ;; <CJK>
       (?$(02Z(B . "0x5950") ;; <CJK>
       (?$(02[(B . "0x59DC") ;; <CJK>
       (?$(02\(B . "0x59D8") ;; <CJK>
       (?$(02](B . "0x59FF") ;; <CJK>
       (?$(02^(B . "0x59E3") ;; <CJK>
       (?$(02_(B . "0x59E8") ;; <CJK>
       (?$(02`(B . "0x5A03") ;; <CJK>
       (?$(02a(B . "0x59E5") ;; <CJK>
       (?$(02b(B . "0x59EA") ;; <CJK>
       (?$(02c(B . "0x59DA") ;; <CJK>
       (?$(02d(B . "0x59E6") ;; <CJK>
       (?$(02e(B . "0x5A01") ;; <CJK>
       (?$(02f(B . "0x59FB") ;; <CJK>
       (?$(02g(B . "0x5B69") ;; <CJK>
       (?$(02h(B . "0x5BA3") ;; <CJK>
       (?$(02i(B . "0x5BA6") ;; <CJK>
       (?$(02j(B . "0x5BA4") ;; <CJK>
       (?$(02k(B . "0x5BA2") ;; <CJK>
       (?$(02l(B . "0x5BA5") ;; <CJK>
       (?$(02m(B . "0x5C01") ;; <CJK>
       (?$(02n(B . "0x5C4E") ;; <CJK>
       (?$(02o(B . "0x5C4F") ;; <CJK>
       (?$(02p(B . "0x5C4D") ;; <CJK>
       (?$(02q(B . "0x5C4B") ;; <CJK>
       (?$(02r(B . "0x5CD9") ;; <CJK>
       (?$(02s(B . "0x5CD2") ;; <CJK>
       (?$(02t(B . "0x5DF7") ;; <CJK>
       (?$(02u(B . "0x5E1D") ;; <CJK>
       (?$(02v(B . "0x5E25") ;; <CJK>
       (?$(02w(B . "0x5E1F") ;; <CJK>
       (?$(02x(B . "0x5E7D") ;; <CJK>
       (?$(02y(B . "0x5EA0") ;; <CJK>
       (?$(02z(B . "0x5EA6") ;; <CJK>
       (?$(02{(B . "0x5EFA") ;; <CJK>
       (?$(02|(B . "0x5F08") ;; <CJK>
       (?$(02}(B . "0x5F2D") ;; <CJK>
       (?$(02~(B . "0x5F65") ;; <CJK>
       (?$(03!(B . "0x5F88") ;; <CJK>
       (?$(03"(B . "0x5F85") ;; <CJK>
       (?$(03#(B . "0x5F8A") ;; <CJK>
       (?$(03$(B . "0x5F8B") ;; <CJK>
       (?$(03%(B . "0x5F87") ;; <CJK>
       (?$(03&(B . "0x5F8C") ;; <CJK>
       (?$(03'(B . "0x5F89") ;; <CJK>
       (?$(03((B . "0x6012") ;; <CJK>
       (?$(03)(B . "0x601D") ;; <CJK>
       (?$(03*(B . "0x6020") ;; <CJK>
       (?$(03+(B . "0x6025") ;; <CJK>
       (?$(03,(B . "0x600E") ;; <CJK>
       (?$(03-(B . "0x6028") ;; <CJK>
       (?$(03.(B . "0x604D") ;; <CJK>
       (?$(03/(B . "0x6070") ;; <CJK>
       (?$(030(B . "0x6068") ;; <CJK>
       (?$(031(B . "0x6062") ;; <CJK>
       (?$(032(B . "0x6046") ;; <CJK>
       (?$(033(B . "0x6043") ;; <CJK>
       (?$(034(B . "0x606C") ;; <CJK>
       (?$(035(B . "0x606B") ;; <CJK>
       (?$(036(B . "0x606A") ;; <CJK>
       (?$(037(B . "0x6064") ;; <CJK>
       (?$(038(B . "0x6241") ;; <CJK>
       (?$(039(B . "0x62DC") ;; <CJK>
       (?$(03:(B . "0x6316") ;; <CJK>
       (?$(03;(B . "0x6309") ;; <CJK>
       (?$(03<(B . "0x62FC") ;; <CJK>
       (?$(03=(B . "0x62ED") ;; <CJK>
       (?$(03>(B . "0x6301") ;; <CJK>
       (?$(03?(B . "0x62EE") ;; <CJK>
       (?$(03@(B . "0x62FD") ;; <CJK>
       (?$(03A(B . "0x6307") ;; <CJK>
       (?$(03B(B . "0x62F1") ;; <CJK>
       (?$(03C(B . "0x62F7") ;; <CJK>
       (?$(03D(B . "0x62EF") ;; <CJK>
       (?$(03E(B . "0x62EC") ;; <CJK>
       (?$(03F(B . "0x62FE") ;; <CJK>
       (?$(03G(B . "0x62F4") ;; <CJK>
       (?$(03H(B . "0x6311") ;; <CJK>
       (?$(03I(B . "0x6302") ;; <CJK>
       (?$(03J(B . "0x653F") ;; <CJK>
       (?$(03K(B . "0x6545") ;; <CJK>
       (?$(03L(B . "0x65AB") ;; <CJK>
       (?$(03M(B . "0x65BD") ;; <CJK>
       (?$(03N(B . "0x65E2") ;; <CJK>
       (?$(03O(B . "0x6625") ;; <CJK>
       (?$(03P(B . "0x662D") ;; <CJK>
       (?$(03Q(B . "0x6620") ;; <CJK>
       (?$(03R(B . "0x6627") ;; <CJK>
       (?$(03S(B . "0x662F") ;; <CJK>
       (?$(03T(B . "0x661F") ;; <CJK>
       (?$(03U(B . "0x6628") ;; <CJK>
       (?$(03V(B . "0x6631") ;; <CJK>
       (?$(03W(B . "0x6624") ;; <CJK>
       (?$(03X(B . "0x66F7") ;; <CJK>
       (?$(03Y(B . "0x67FF") ;; <CJK>
       (?$(03Z(B . "0x67D3") ;; <CJK>
       (?$(03[(B . "0x67F1") ;; <CJK>
       (?$(03\(B . "0x67D4") ;; <CJK>
       (?$(03](B . "0x67D0") ;; <CJK>
       (?$(03^(B . "0x67EC") ;; <CJK>
       (?$(03_(B . "0x67B6") ;; <CJK>
       (?$(03`(B . "0x67AF") ;; <CJK>
       (?$(03a(B . "0x67F5") ;; <CJK>
       (?$(03b(B . "0x67E9") ;; <CJK>
       (?$(03c(B . "0x67EF") ;; <CJK>
       (?$(03d(B . "0x67C4") ;; <CJK>
       (?$(03e(B . "0x67D1") ;; <CJK>
       (?$(03f(B . "0x67B4") ;; <CJK>
       (?$(03g(B . "0x67DA") ;; <CJK>
       (?$(03h(B . "0x67E5") ;; <CJK>
       (?$(03i(B . "0x67B8") ;; <CJK>
       (?$(03j(B . "0x67CF") ;; <CJK>
       (?$(03k(B . "0x67DE") ;; <CJK>
       (?$(03l(B . "0x67F3") ;; <CJK>
       (?$(03m(B . "0x67B0") ;; <CJK>
       (?$(03n(B . "0x67D9") ;; <CJK>
       (?$(03o(B . "0x67E2") ;; <CJK>
       (?$(03p(B . "0x67DD") ;; <CJK>
       (?$(03q(B . "0x67D2") ;; <CJK>
       (?$(03r(B . "0x6B6A") ;; <CJK>
       (?$(03s(B . "0x6B83") ;; <CJK>
       (?$(03t(B . "0x6B86") ;; <CJK>
       (?$(03u(B . "0x6BB5") ;; <CJK>
       (?$(03v(B . "0x6BD2") ;; <CJK>
       (?$(03w(B . "0x6BD7") ;; <CJK>
       (?$(03x(B . "0x6C1F") ;; <CJK>
       (?$(03y(B . "0x6CC9") ;; <CJK>
       (?$(03z(B . "0x6D0B") ;; <CJK>
       (?$(03{(B . "0x6D32") ;; <CJK>
       (?$(03|(B . "0x6D2A") ;; <CJK>
       (?$(03}(B . "0x6D41") ;; <CJK>
       (?$(03~(B . "0x6D25") ;; <CJK>
       (?$(04!(B . "0x6D0C") ;; <CJK>
       (?$(04"(B . "0x6D31") ;; <CJK>
       (?$(04#(B . "0x6D1E") ;; <CJK>
       (?$(04$(B . "0x6D17") ;; <CJK>
       (?$(04%(B . "0x6D3B") ;; <CJK>
       (?$(04&(B . "0x6D3D") ;; <CJK>
       (?$(04'(B . "0x6D3E") ;; <CJK>
       (?$(04((B . "0x6D36") ;; <CJK>
       (?$(04)(B . "0x6D1B") ;; <CJK>
       (?$(04*(B . "0x6CF5") ;; <CJK>
       (?$(04+(B . "0x6D39") ;; <CJK>
       (?$(04,(B . "0x6D27") ;; <CJK>
       (?$(04-(B . "0x6D38") ;; <CJK>
       (?$(04.(B . "0x6D29") ;; <CJK>
       (?$(04/(B . "0x6D2E") ;; <CJK>
       (?$(040(B . "0x6D35") ;; <CJK>
       (?$(041(B . "0x6D0E") ;; <CJK>
       (?$(042(B . "0x6D2B") ;; <CJK>
       (?$(043(B . "0x70AB") ;; <CJK>
       (?$(044(B . "0x70BA") ;; <CJK>
       (?$(045(B . "0x70B3") ;; <CJK>
       (?$(046(B . "0x70AC") ;; <CJK>
       (?$(047(B . "0x70AF") ;; <CJK>
       (?$(048(B . "0x70AD") ;; <CJK>
       (?$(049(B . "0x70B8") ;; <CJK>
       (?$(04:(B . "0x70AE") ;; <CJK>
       (?$(04;(B . "0x70A4") ;; <CJK>
       (?$(04<(B . "0x7230") ;; <CJK>
       (?$(04=(B . "0x7272") ;; <CJK>
       (?$(04>(B . "0x726F") ;; <CJK>
       (?$(04?(B . "0x7274") ;; <CJK>
       (?$(04@(B . "0x72E9") ;; <CJK>
       (?$(04A(B . "0x72E0") ;; <CJK>
       (?$(04B(B . "0x72E1") ;; <CJK>
       (?$(04C(B . "0x73B7") ;; <CJK>
       (?$(04D(B . "0x73CA") ;; <CJK>
       (?$(04E(B . "0x73BB") ;; <CJK>
       (?$(04F(B . "0x73B2") ;; <CJK>
       (?$(04G(B . "0x73CD") ;; <CJK>
       (?$(04H(B . "0x73C0") ;; <CJK>
       (?$(04I(B . "0x73B3") ;; <CJK>
       (?$(04J(B . "0x751A") ;; <CJK>
       (?$(04K(B . "0x752D") ;; <CJK>
       (?$(04L(B . "0x754F") ;; <CJK>
       (?$(04M(B . "0x754C") ;; <CJK>
       (?$(04N(B . "0x754E") ;; <CJK>
       (?$(04O(B . "0x754B") ;; <CJK>
       (?$(04P(B . "0x75AB") ;; <CJK>
       (?$(04Q(B . "0x75A4") ;; <CJK>
       (?$(04R(B . "0x75A5") ;; <CJK>
       (?$(04S(B . "0x75A2") ;; <CJK>
       (?$(04T(B . "0x75A3") ;; <CJK>
       (?$(04U(B . "0x7678") ;; <CJK>
       (?$(04V(B . "0x7686") ;; <CJK>
       (?$(04W(B . "0x7687") ;; <CJK>
       (?$(04X(B . "0x7688") ;; <CJK>
       (?$(04Y(B . "0x76C8") ;; <CJK>
       (?$(04Z(B . "0x76C6") ;; <CJK>
       (?$(04[(B . "0x76C3") ;; <CJK>
       (?$(04\(B . "0x76C5") ;; <CJK>
       (?$(04](B . "0x7701") ;; <CJK>
       (?$(04^(B . "0x76F9") ;; <CJK>
       (?$(04_(B . "0x76F8") ;; <CJK>
       (?$(04`(B . "0x7709") ;; <CJK>
       (?$(04a(B . "0x770B") ;; <CJK>
       (?$(04b(B . "0x76FE") ;; <CJK>
       (?$(04c(B . "0x76FC") ;; <CJK>
       (?$(04d(B . "0x7707") ;; <CJK>
       (?$(04e(B . "0x77DC") ;; <CJK>
       (?$(04f(B . "0x7802") ;; <CJK>
       (?$(04g(B . "0x7814") ;; <CJK>
       (?$(04h(B . "0x780C") ;; <CJK>
       (?$(04i(B . "0x780D") ;; <CJK>
       (?$(04j(B . "0x7946") ;; <CJK>
       (?$(04k(B . "0x7949") ;; <CJK>
       (?$(04l(B . "0x7948") ;; <CJK>
       (?$(04m(B . "0x7947") ;; <CJK>
       (?$(04n(B . "0x79B9") ;; <CJK>
       (?$(04o(B . "0x79BA") ;; <CJK>
       (?$(04p(B . "0x79D1") ;; <CJK>
       (?$(04q(B . "0x79D2") ;; <CJK>
       (?$(04r(B . "0x79CB") ;; <CJK>
       (?$(04s(B . "0x7A7F") ;; <CJK>
       (?$(04t(B . "0x7A81") ;; <CJK>
       (?$(04u(B . "0x7AFF") ;; <CJK>
       (?$(04v(B . "0x7AFD") ;; <CJK>
       (?$(04w(B . "0x7C7D") ;; <CJK>
       (?$(04x(B . "0x7D02") ;; <CJK>
       (?$(04y(B . "0x7D05") ;; <CJK>
       (?$(04z(B . "0x7D00") ;; <CJK>
       (?$(04{(B . "0x7D09") ;; <CJK>
       (?$(04|(B . "0x7D07") ;; <CJK>
       (?$(04}(B . "0x7D04") ;; <CJK>
       (?$(04~(B . "0x7D06") ;; <CJK>
       (?$(05!(B . "0x7F38") ;; <CJK>
       (?$(05"(B . "0x7F8E") ;; <CJK>
       (?$(05#(B . "0x7FBF") ;; <CJK>
       (?$(05$(B . "0x8004") ;; <CJK>
       (?$(05%(B . "0x8010") ;; <CJK>
       (?$(05&(B . "0x800D") ;; <CJK>
       (?$(05'(B . "0x8011") ;; <CJK>
       (?$(05((B . "0x8036") ;; <CJK>
       (?$(05)(B . "0x80D6") ;; <CJK>
       (?$(05*(B . "0x80E5") ;; <CJK>
       (?$(05+(B . "0x80DA") ;; <CJK>
       (?$(05,(B . "0x80C3") ;; <CJK>
       (?$(05-(B . "0x80C4") ;; <CJK>
       (?$(05.(B . "0x80CC") ;; <CJK>
       (?$(05/(B . "0x80E1") ;; <CJK>
       (?$(050(B . "0x80DB") ;; <CJK>
       (?$(051(B . "0x80CE") ;; <CJK>
       (?$(052(B . "0x80DE") ;; <CJK>
       (?$(053(B . "0x80E4") ;; <CJK>
       (?$(054(B . "0x80DD") ;; <CJK>
       (?$(055(B . "0x81F4") ;; <CJK>
       (?$(056(B . "0x8222") ;; <CJK>
       (?$(057(B . "0x82E7") ;; <CJK>
       (?$(058(B . "0x8303") ;; <CJK>
       (?$(059(B . "0x8305") ;; <CJK>
       (?$(05:(B . "0x82E3") ;; <CJK>
       (?$(05;(B . "0x82DB") ;; <CJK>
       (?$(05<(B . "0x82E6") ;; <CJK>
       (?$(05=(B . "0x8304") ;; <CJK>
       (?$(05>(B . "0x82E5") ;; <CJK>
       (?$(05?(B . "0x8302") ;; <CJK>
       (?$(05@(B . "0x8309") ;; <CJK>
       (?$(05A(B . "0x82D2") ;; <CJK>
       (?$(05B(B . "0x82D7") ;; <CJK>
       (?$(05C(B . "0x82F1") ;; <CJK>
       (?$(05D(B . "0x8301") ;; <CJK>
       (?$(05E(B . "0x82DC") ;; <CJK>
       (?$(05F(B . "0x82D4") ;; <CJK>
       (?$(05G(B . "0x82D1") ;; <CJK>
       (?$(05H(B . "0x82DE") ;; <CJK>
       (?$(05I(B . "0x82D3") ;; <CJK>
       (?$(05J(B . "0x82DF") ;; <CJK>
       (?$(05K(B . "0x82EF") ;; <CJK>
       (?$(05L(B . "0x8306") ;; <CJK>
       (?$(05M(B . "0x8650") ;; <CJK>
       (?$(05N(B . "0x8679") ;; <CJK>
       (?$(05O(B . "0x867B") ;; <CJK>
       (?$(05P(B . "0x867A") ;; <CJK>
       (?$(05Q(B . "0x884D") ;; <CJK>
       (?$(05R(B . "0x886B") ;; <CJK>
       (?$(05S(B . "0x8981") ;; <CJK>
       (?$(05T(B . "0x89D4") ;; <CJK>
       (?$(05U(B . "0x8A08") ;; <CJK>
       (?$(05V(B . "0x8A02") ;; <CJK>
       (?$(05W(B . "0x8A03") ;; <CJK>
       (?$(05X(B . "0x8C9E") ;; <CJK>
       (?$(05Y(B . "0x8CA0") ;; <CJK>
       (?$(05Z(B . "0x8D74") ;; <CJK>
       (?$(05[(B . "0x8D73") ;; <CJK>
       (?$(05\(B . "0x8DB4") ;; <CJK>
       (?$(05](B . "0x8ECD") ;; <CJK>
       (?$(05^(B . "0x8ECC") ;; <CJK>
       (?$(05_(B . "0x8FF0") ;; <CJK>
       (?$(05`(B . "0x8FE6") ;; <CJK>
       (?$(05a(B . "0x8FE2") ;; <CJK>
       (?$(05b(B . "0x8FEA") ;; <CJK>
       (?$(05c(B . "0x8FE5") ;; <CJK>
       (?$(05d(B . "0x8FED") ;; <CJK>
       (?$(05e(B . "0x8FEB") ;; <CJK>
       (?$(05f(B . "0x8FE4") ;; <CJK>
       (?$(05g(B . "0x8FE8") ;; <CJK>
       (?$(05h(B . "0x90CA") ;; <CJK>
       (?$(05i(B . "0x90CE") ;; <CJK>
       (?$(05j(B . "0x90C1") ;; <CJK>
       (?$(05k(B . "0x90C3") ;; <CJK>
       (?$(05l(B . "0x914B") ;; <CJK>
       (?$(05m(B . "0x914A") ;; <CJK>
       (?$(05n(B . "0x91CD") ;; <CJK>
       (?$(05o(B . "0x9582") ;; <CJK>
       (?$(05p(B . "0x9650") ;; <CJK>
       (?$(05q(B . "0x964B") ;; <CJK>
       (?$(05r(B . "0x964C") ;; <CJK>
       (?$(05s(B . "0x964D") ;; <CJK>
       (?$(05t(B . "0x9762") ;; <CJK>
       (?$(05u(B . "0x9769") ;; <CJK>
       (?$(05v(B . "0x97CB") ;; <CJK>
       (?$(05w(B . "0x97ED") ;; <CJK>
       (?$(05x(B . "0x97F3") ;; <CJK>
       (?$(05y(B . "0x9801") ;; <CJK>
       (?$(05z(B . "0x98A8") ;; <CJK>
       (?$(05{(B . "0x98DB") ;; <CJK>
       (?$(05|(B . "0x98DF") ;; <CJK>
       (?$(05}(B . "0x9996") ;; <CJK>
       (?$(05~(B . "0x9999") ;; <CJK>
       (?$(06!(B . "0x4E58") ;; <CJK>
       (?$(06"(B . "0x4EB3") ;; <CJK>
       (?$(06#(B . "0x500C") ;; <CJK>
       (?$(06$(B . "0x500D") ;; <CJK>
       (?$(06%(B . "0x5023") ;; <CJK>
       (?$(06&(B . "0x4FEF") ;; <CJK>
       (?$(06'(B . "0x5026") ;; <CJK>
       (?$(06((B . "0x5025") ;; <CJK>
       (?$(06)(B . "0x4FF8") ;; <CJK>
       (?$(06*(B . "0x5029") ;; <CJK>
       (?$(06+(B . "0x5016") ;; <CJK>
       (?$(06,(B . "0x5006") ;; <CJK>
       (?$(06-(B . "0x503C") ;; <CJK>
       (?$(06.(B . "0x501F") ;; <CJK>
       (?$(06/(B . "0x501A") ;; <CJK>
       (?$(060(B . "0x5012") ;; <CJK>
       (?$(061(B . "0x5011") ;; <CJK>
       (?$(062(B . "0x4FFA") ;; <CJK>
       (?$(063(B . "0x5000") ;; <CJK>
       (?$(064(B . "0x5014") ;; <CJK>
       (?$(065(B . "0x5028") ;; <CJK>
       (?$(066(B . "0x4FF1") ;; <CJK>
       (?$(067(B . "0x5021") ;; <CJK>
       (?$(068(B . "0x500B") ;; <CJK>
       (?$(069(B . "0x5019") ;; <CJK>
       (?$(06:(B . "0x5018") ;; <CJK>
       (?$(06;(B . "0x4FF3") ;; <CJK>
       (?$(06<(B . "0x4FEE") ;; <CJK>
       (?$(06=(B . "0x502D") ;; <CJK>
       (?$(06>(B . "0x502A") ;; <CJK>
       (?$(06?(B . "0x4FFE") ;; <CJK>
       (?$(06@(B . "0x502B") ;; <CJK>
       (?$(06A(B . "0x5009") ;; <CJK>
       (?$(06B(B . "0x517C") ;; <CJK>
       (?$(06C(B . "0x51A4") ;; <CJK>
       (?$(06D(B . "0x51A5") ;; <CJK>
       (?$(06E(B . "0x51A2") ;; <CJK>
       (?$(06F(B . "0x51CD") ;; <CJK>
       (?$(06G(B . "0x51CC") ;; <CJK>
       (?$(06H(B . "0x51C6") ;; <CJK>
       (?$(06I(B . "0x51CB") ;; <CJK>
       (?$(06J(B . "0x5256") ;; <CJK>
       (?$(06K(B . "0x525C") ;; <CJK>
       (?$(06L(B . "0x5254") ;; <CJK>
       (?$(06M(B . "0x525B") ;; <CJK>
       (?$(06N(B . "0x525D") ;; <CJK>
       (?$(06O(B . "0x532A") ;; <CJK>
       (?$(06P(B . "0x537F") ;; <CJK>
       (?$(06Q(B . "0x539F") ;; <CJK>
       (?$(06R(B . "0x539D") ;; <CJK>
       (?$(06S(B . "0x53DF") ;; <CJK>
       (?$(06T(B . "0x54E8") ;; <CJK>
       (?$(06U(B . "0x5510") ;; <CJK>
       (?$(06V(B . "0x5501") ;; <CJK>
       (?$(06W(B . "0x5537") ;; <CJK>
       (?$(06X(B . "0x54FC") ;; <CJK>
       (?$(06Y(B . "0x54E5") ;; <CJK>
       (?$(06Z(B . "0x54F2") ;; <CJK>
       (?$(06[(B . "0x5506") ;; <CJK>
       (?$(06\(B . "0x54FA") ;; <CJK>
       (?$(06](B . "0x5514") ;; <CJK>
       (?$(06^(B . "0x54E9") ;; <CJK>
       (?$(06_(B . "0x54ED") ;; <CJK>
       (?$(06`(B . "0x54E1") ;; <CJK>
       (?$(06a(B . "0x5509") ;; <CJK>
       (?$(06b(B . "0x54EE") ;; <CJK>
       (?$(06c(B . "0x54EA") ;; <CJK>
       (?$(06d(B . "0x54E6") ;; <CJK>
       (?$(06e(B . "0x5527") ;; <CJK>
       (?$(06f(B . "0x5507") ;; <CJK>
       (?$(06g(B . "0x54FD") ;; <CJK>
       (?$(06h(B . "0x550F") ;; <CJK>
       (?$(06i(B . "0x5703") ;; <CJK>
       (?$(06j(B . "0x5704") ;; <CJK>
       (?$(06k(B . "0x57C2") ;; <CJK>
       (?$(06l(B . "0x57D4") ;; <CJK>
       (?$(06m(B . "0x57CB") ;; <CJK>
       (?$(06n(B . "0x57C3") ;; <CJK>
       (?$(06o(B . "0x5809") ;; <CJK>
       (?$(06p(B . "0x590F") ;; <CJK>
       (?$(06q(B . "0x5957") ;; <CJK>
       (?$(06r(B . "0x5958") ;; <CJK>
       (?$(06s(B . "0x595A") ;; <CJK>
       (?$(06t(B . "0x5A11") ;; <CJK>
       (?$(06u(B . "0x5A18") ;; <CJK>
       (?$(06v(B . "0x5A1C") ;; <CJK>
       (?$(06w(B . "0x5A1F") ;; <CJK>
       (?$(06x(B . "0x5A1B") ;; <CJK>
       (?$(06y(B . "0x5A13") ;; <CJK>
       (?$(06z(B . "0x59EC") ;; <CJK>
       (?$(06{(B . "0x5A20") ;; <CJK>
       (?$(06|(B . "0x5A23") ;; <CJK>
       (?$(06}(B . "0x5A29") ;; <CJK>
       (?$(06~(B . "0x5A25") ;; <CJK>
       (?$(07!(B . "0x5A0C") ;; <CJK>
       (?$(07"(B . "0x5A09") ;; <CJK>
       (?$(07#(B . "0x5B6B") ;; <CJK>
       (?$(07$(B . "0x5C58") ;; <CJK>
       (?$(07%(B . "0x5BB0") ;; <CJK>
       (?$(07&(B . "0x5BB3") ;; <CJK>
       (?$(07'(B . "0x5BB6") ;; <CJK>
       (?$(07((B . "0x5BB4") ;; <CJK>
       (?$(07)(B . "0x5BAE") ;; <CJK>
       (?$(07*(B . "0x5BB5") ;; <CJK>
       (?$(07+(B . "0x5BB9") ;; <CJK>
       (?$(07,(B . "0x5BB8") ;; <CJK>
       (?$(07-(B . "0x5C04") ;; <CJK>
       (?$(07.(B . "0x5C51") ;; <CJK>
       (?$(07/(B . "0x5C55") ;; <CJK>
       (?$(070(B . "0x5C50") ;; <CJK>
       (?$(071(B . "0x5CED") ;; <CJK>
       (?$(072(B . "0x5CFD") ;; <CJK>
       (?$(073(B . "0x5CFB") ;; <CJK>
       (?$(074(B . "0x5CEA") ;; <CJK>
       (?$(075(B . "0x5CE8") ;; <CJK>
       (?$(076(B . "0x5CF0") ;; <CJK>
       (?$(077(B . "0x5CF6") ;; <CJK>
       (?$(078(B . "0x5D01") ;; <CJK>
       (?$(079(B . "0x5CF4") ;; <CJK>
       (?$(07:(B . "0x5DEE") ;; <CJK>
       (?$(07;(B . "0x5E2D") ;; <CJK>
       (?$(07<(B . "0x5E2B") ;; <CJK>
       (?$(07=(B . "0x5EAB") ;; <CJK>
       (?$(07>(B . "0x5EAD") ;; <CJK>
       (?$(07?(B . "0x5EA7") ;; <CJK>
       (?$(07@(B . "0x5F31") ;; <CJK>
       (?$(07A(B . "0x5F92") ;; <CJK>
       (?$(07B(B . "0x5F91") ;; <CJK>
       (?$(07C(B . "0x5F90") ;; <CJK>
       (?$(07D(B . "0x6059") ;; <CJK>
       (?$(07E(B . "0x6063") ;; <CJK>
       (?$(07F(B . "0x6065") ;; <CJK>
       (?$(07G(B . "0x6050") ;; <CJK>
       (?$(07H(B . "0x6055") ;; <CJK>
       (?$(07I(B . "0x606D") ;; <CJK>
       (?$(07J(B . "0x6069") ;; <CJK>
       (?$(07K(B . "0x606F") ;; <CJK>
       (?$(07L(B . "0x6084") ;; <CJK>
       (?$(07M(B . "0x609F") ;; <CJK>
       (?$(07N(B . "0x609A") ;; <CJK>
       (?$(07O(B . "0x608D") ;; <CJK>
       (?$(07P(B . "0x6094") ;; <CJK>
       (?$(07Q(B . "0x608C") ;; <CJK>
       (?$(07R(B . "0x6085") ;; <CJK>
       (?$(07S(B . "0x6096") ;; <CJK>
       (?$(07T(B . "0x6247") ;; <CJK>
       (?$(07U(B . "0x62F3") ;; <CJK>
       (?$(07V(B . "0x6308") ;; <CJK>
       (?$(07W(B . "0x62FF") ;; <CJK>
       (?$(07X(B . "0x634E") ;; <CJK>
       (?$(07Y(B . "0x633E") ;; <CJK>
       (?$(07Z(B . "0x632F") ;; <CJK>
       (?$(07[(B . "0x6355") ;; <CJK>
       (?$(07\(B . "0x6342") ;; <CJK>
       (?$(07](B . "0x6346") ;; <CJK>
       (?$(07^(B . "0x634F") ;; <CJK>
       (?$(07_(B . "0x6349") ;; <CJK>
       (?$(07`(B . "0x633A") ;; <CJK>
       (?$(07a(B . "0x6350") ;; <CJK>
       (?$(07b(B . "0x633D") ;; <CJK>
       (?$(07c(B . "0x632A") ;; <CJK>
       (?$(07d(B . "0x632B") ;; <CJK>
       (?$(07e(B . "0x6328") ;; <CJK>
       (?$(07f(B . "0x634D") ;; <CJK>
       (?$(07g(B . "0x634C") ;; <CJK>
       (?$(07h(B . "0x6548") ;; <CJK>
       (?$(07i(B . "0x6549") ;; <CJK>
       (?$(07j(B . "0x6599") ;; <CJK>
       (?$(07k(B . "0x65C1") ;; <CJK>
       (?$(07l(B . "0x65C5") ;; <CJK>
       (?$(07m(B . "0x6642") ;; <CJK>
       (?$(07n(B . "0x6649") ;; <CJK>
       (?$(07o(B . "0x664F") ;; <CJK>
       (?$(07p(B . "0x6643") ;; <CJK>
       (?$(07q(B . "0x6652") ;; <CJK>
       (?$(07r(B . "0x664C") ;; <CJK>
       (?$(07s(B . "0x6645") ;; <CJK>
       (?$(07t(B . "0x6641") ;; <CJK>
       (?$(07u(B . "0x66F8") ;; <CJK>
       (?$(07v(B . "0x6714") ;; <CJK>
       (?$(07w(B . "0x6715") ;; <CJK>
       (?$(07x(B . "0x6717") ;; <CJK>
       (?$(07y(B . "0x6821") ;; <CJK>
       (?$(07z(B . "0x6838") ;; <CJK>
       (?$(07{(B . "0x6848") ;; <CJK>
       (?$(07|(B . "0x6846") ;; <CJK>
       (?$(07}(B . "0x6853") ;; <CJK>
       (?$(07~(B . "0x6839") ;; <CJK>
       (?$(08!(B . "0x6842") ;; <CJK>
       (?$(08"(B . "0x6854") ;; <CJK>
       (?$(08#(B . "0x6829") ;; <CJK>
       (?$(08$(B . "0x68B3") ;; <CJK>
       (?$(08%(B . "0x6817") ;; <CJK>
       (?$(08&(B . "0x684C") ;; <CJK>
       (?$(08'(B . "0x6851") ;; <CJK>
       (?$(08((B . "0x683D") ;; <CJK>
       (?$(08)(B . "0x67F4") ;; <CJK>
       (?$(08*(B . "0x6850") ;; <CJK>
       (?$(08+(B . "0x6840") ;; <CJK>
       (?$(08,(B . "0x683C") ;; <CJK>
       (?$(08-(B . "0x6843") ;; <CJK>
       (?$(08.(B . "0x682A") ;; <CJK>
       (?$(08/(B . "0x6845") ;; <CJK>
       (?$(080(B . "0x6813") ;; <CJK>
       (?$(081(B . "0x6818") ;; <CJK>
       (?$(082(B . "0x6841") ;; <CJK>
       (?$(083(B . "0x6B8A") ;; <CJK>
       (?$(084(B . "0x6B89") ;; <CJK>
       (?$(085(B . "0x6BB7") ;; <CJK>
       (?$(086(B . "0x6C23") ;; <CJK>
       (?$(087(B . "0x6C27") ;; <CJK>
       (?$(088(B . "0x6C28") ;; <CJK>
       (?$(089(B . "0x6C26") ;; <CJK>
       (?$(08:(B . "0x6C24") ;; <CJK>
       (?$(08;(B . "0x6CF0") ;; <CJK>
       (?$(08<(B . "0x6D6A") ;; <CJK>
       (?$(08=(B . "0x6D95") ;; <CJK>
       (?$(08>(B . "0x6D88") ;; <CJK>
       (?$(08?(B . "0x6D87") ;; <CJK>
       (?$(08@(B . "0x6D66") ;; <CJK>
       (?$(08A(B . "0x6D78") ;; <CJK>
       (?$(08B(B . "0x6D77") ;; <CJK>
       (?$(08C(B . "0x6D59") ;; <CJK>
       (?$(08D(B . "0x6D93") ;; <CJK>
       (?$(08E(B . "0x6D6C") ;; <CJK>
       (?$(08F(B . "0x6D89") ;; <CJK>
       (?$(08G(B . "0x6D6E") ;; <CJK>
       (?$(08H(B . "0x6D5A") ;; <CJK>
       (?$(08I(B . "0x6D74") ;; <CJK>
       (?$(08J(B . "0x6D69") ;; <CJK>
       (?$(08K(B . "0x6D8C") ;; <CJK>
       (?$(08L(B . "0x6D8A") ;; <CJK>
       (?$(08M(B . "0x6D79") ;; <CJK>
       (?$(08N(B . "0x6D85") ;; <CJK>
       (?$(08O(B . "0x6D65") ;; <CJK>
       (?$(08P(B . "0x6D94") ;; <CJK>
       (?$(08Q(B . "0x70CA") ;; <CJK>
       (?$(08R(B . "0x70D8") ;; <CJK>
       (?$(08S(B . "0x70E4") ;; <CJK>
       (?$(08T(B . "0x70D9") ;; <CJK>
       (?$(08U(B . "0x70C8") ;; <CJK>
       (?$(08V(B . "0x70CF") ;; <CJK>
       (?$(08W(B . "0x7239") ;; <CJK>
       (?$(08X(B . "0x7279") ;; <CJK>
       (?$(08Y(B . "0x72FC") ;; <CJK>
       (?$(08Z(B . "0x72F9") ;; <CJK>
       (?$(08[(B . "0x72FD") ;; <CJK>
       (?$(08\(B . "0x72F8") ;; <CJK>
       (?$(08](B . "0x72F7") ;; <CJK>
       (?$(08^(B . "0x7386") ;; <CJK>
       (?$(08_(B . "0x73ED") ;; <CJK>
       (?$(08`(B . "0x7409") ;; <CJK>
       (?$(08a(B . "0x73EE") ;; <CJK>
       (?$(08b(B . "0x73E0") ;; <CJK>
       (?$(08c(B . "0x73EA") ;; <CJK>
       (?$(08d(B . "0x73DE") ;; <CJK>
       (?$(08e(B . "0x7554") ;; <CJK>
       (?$(08f(B . "0x755D") ;; <CJK>
       (?$(08g(B . "0x755C") ;; <CJK>
       (?$(08h(B . "0x755A") ;; <CJK>
       (?$(08i(B . "0x7559") ;; <CJK>
       (?$(08j(B . "0x75BE") ;; <CJK>
       (?$(08k(B . "0x75C5") ;; <CJK>
       (?$(08l(B . "0x75C7") ;; <CJK>
       (?$(08m(B . "0x75B2") ;; <CJK>
       (?$(08n(B . "0x75B3") ;; <CJK>
       (?$(08o(B . "0x75BD") ;; <CJK>
       (?$(08p(B . "0x75BC") ;; <CJK>
       (?$(08q(B . "0x75B9") ;; <CJK>
       (?$(08r(B . "0x75C2") ;; <CJK>
       (?$(08s(B . "0x75B8") ;; <CJK>
       (?$(08t(B . "0x768B") ;; <CJK>
       (?$(08u(B . "0x76B0") ;; <CJK>
       (?$(08v(B . "0x76CA") ;; <CJK>
       (?$(08w(B . "0x76CD") ;; <CJK>
       (?$(08x(B . "0x76CE") ;; <CJK>
       (?$(08y(B . "0x7729") ;; <CJK>
       (?$(08z(B . "0x771F") ;; <CJK>
       (?$(08{(B . "0x7720") ;; <CJK>
       (?$(08|(B . "0x7728") ;; <CJK>
       (?$(08}(B . "0x77E9") ;; <CJK>
       (?$(08~(B . "0x7830") ;; <CJK>
       (?$(09!(B . "0x7827") ;; <CJK>
       (?$(09"(B . "0x7838") ;; <CJK>
       (?$(09#(B . "0x781D") ;; <CJK>
       (?$(09$(B . "0x7834") ;; <CJK>
       (?$(09%(B . "0x7837") ;; <CJK>
       (?$(09&(B . "0x7825") ;; <CJK>
       (?$(09'(B . "0x782D") ;; <CJK>
       (?$(09((B . "0x7820") ;; <CJK>
       (?$(09)(B . "0x781F") ;; <CJK>
       (?$(09*(B . "0x7832") ;; <CJK>
       (?$(09+(B . "0x7955") ;; <CJK>
       (?$(09,(B . "0x7950") ;; <CJK>
       (?$(09-(B . "0x7960") ;; <CJK>
       (?$(09.(B . "0x795F") ;; <CJK>
       (?$(09/(B . "0x7956") ;; <CJK>
       (?$(090(B . "0x795E") ;; <CJK>
       (?$(091(B . "0x795D") ;; <CJK>
       (?$(092(B . "0x7957") ;; <CJK>
       (?$(093(B . "0x795A") ;; <CJK>
       (?$(094(B . "0x79E4") ;; <CJK>
       (?$(095(B . "0x79E3") ;; <CJK>
       (?$(096(B . "0x79E7") ;; <CJK>
       (?$(097(B . "0x79DF") ;; <CJK>
       (?$(098(B . "0x79E6") ;; <CJK>
       (?$(099(B . "0x79E9") ;; <CJK>
       (?$(09:(B . "0x79D8") ;; <CJK>
       (?$(09;(B . "0x7A84") ;; <CJK>
       (?$(09<(B . "0x7A88") ;; <CJK>
       (?$(09=(B . "0x7AD9") ;; <CJK>
       (?$(09>(B . "0x7B06") ;; <CJK>
       (?$(09?(B . "0x7B11") ;; <CJK>
       (?$(09@(B . "0x7C89") ;; <CJK>
       (?$(09A(B . "0x7D21") ;; <CJK>
       (?$(09B(B . "0x7D17") ;; <CJK>
       (?$(09C(B . "0x7D0B") ;; <CJK>
       (?$(09D(B . "0x7D0A") ;; <CJK>
       (?$(09E(B . "0x7D20") ;; <CJK>
       (?$(09F(B . "0x7D22") ;; <CJK>
       (?$(09G(B . "0x7D14") ;; <CJK>
       (?$(09H(B . "0x7D10") ;; <CJK>
       (?$(09I(B . "0x7D15") ;; <CJK>
       (?$(09J(B . "0x7D1A") ;; <CJK>
       (?$(09K(B . "0x7D1C") ;; <CJK>
       (?$(09L(B . "0x7D0D") ;; <CJK>
       (?$(09M(B . "0x7D19") ;; <CJK>
       (?$(09N(B . "0x7D1B") ;; <CJK>
       (?$(09O(B . "0x7F3A") ;; <CJK>
       (?$(09P(B . "0x7F5F") ;; <CJK>
       (?$(09Q(B . "0x7F94") ;; <CJK>
       (?$(09R(B . "0x7FC5") ;; <CJK>
       (?$(09S(B . "0x7FC1") ;; <CJK>
       (?$(09T(B . "0x8006") ;; <CJK>
       (?$(09U(B . "0x8018") ;; <CJK>
       (?$(09V(B . "0x8015") ;; <CJK>
       (?$(09W(B . "0x8019") ;; <CJK>
       (?$(09X(B . "0x8017") ;; <CJK>
       (?$(09Y(B . "0x803D") ;; <CJK>
       (?$(09Z(B . "0x803F") ;; <CJK>
       (?$(09[(B . "0x80F1") ;; <CJK>
       (?$(09\(B . "0x8102") ;; <CJK>
       (?$(09](B . "0x80F0") ;; <CJK>
       (?$(09^(B . "0x8105") ;; <CJK>
       (?$(09_(B . "0x80ED") ;; <CJK>
       (?$(09`(B . "0x80F4") ;; <CJK>
       (?$(09a(B . "0x8106") ;; <CJK>
       (?$(09b(B . "0x80F8") ;; <CJK>
       (?$(09c(B . "0x80F3") ;; <CJK>
       (?$(09d(B . "0x8108") ;; <CJK>
       (?$(09e(B . "0x80FD") ;; <CJK>
       (?$(09f(B . "0x810A") ;; <CJK>
       (?$(09g(B . "0x80FC") ;; <CJK>
       (?$(09h(B . "0x80EF") ;; <CJK>
       (?$(09i(B . "0x81ED") ;; <CJK>
       (?$(09j(B . "0x81EC") ;; <CJK>
       (?$(09k(B . "0x8200") ;; <CJK>
       (?$(09l(B . "0x8210") ;; <CJK>
       (?$(09m(B . "0x822A") ;; <CJK>
       (?$(09n(B . "0x822B") ;; <CJK>
       (?$(09o(B . "0x8228") ;; <CJK>
       (?$(09p(B . "0x822C") ;; <CJK>
       (?$(09q(B . "0x82BB") ;; <CJK>
       (?$(09r(B . "0x832B") ;; <CJK>
       (?$(09s(B . "0x8352") ;; <CJK>
       (?$(09t(B . "0x8354") ;; <CJK>
       (?$(09u(B . "0x834A") ;; <CJK>
       (?$(09v(B . "0x8338") ;; <CJK>
       (?$(09w(B . "0x8350") ;; <CJK>
       (?$(09x(B . "0x8349") ;; <CJK>
       (?$(09y(B . "0x8335") ;; <CJK>
       (?$(09z(B . "0x8334") ;; <CJK>
       (?$(09{(B . "0x834F") ;; <CJK>
       (?$(09|(B . "0x8332") ;; <CJK>
       (?$(09}(B . "0x8339") ;; <CJK>
       (?$(09~(B . "0x8336") ;; <CJK>
       (?$(0:!(B . "0x8317") ;; <CJK>
       (?$(0:"(B . "0x8340") ;; <CJK>
       (?$(0:#(B . "0x8331") ;; <CJK>
       (?$(0:$(B . "0x8328") ;; <CJK>
       (?$(0:%(B . "0x8343") ;; <CJK>
       (?$(0:&(B . "0x8654") ;; <CJK>
       (?$(0:'(B . "0x868A") ;; <CJK>
       (?$(0:((B . "0x86AA") ;; <CJK>
       (?$(0:)(B . "0x8693") ;; <CJK>
       (?$(0:*(B . "0x86A4") ;; <CJK>
       (?$(0:+(B . "0x86A9") ;; <CJK>
       (?$(0:,(B . "0x868C") ;; <CJK>
       (?$(0:-(B . "0x86A3") ;; <CJK>
       (?$(0:.(B . "0x869C") ;; <CJK>
       (?$(0:/(B . "0x8870") ;; <CJK>
       (?$(0:0(B . "0x8877") ;; <CJK>
       (?$(0:1(B . "0x8881") ;; <CJK>
       (?$(0:2(B . "0x8882") ;; <CJK>
       (?$(0:3(B . "0x887D") ;; <CJK>
       (?$(0:4(B . "0x8879") ;; <CJK>
       (?$(0:5(B . "0x8A18") ;; <CJK>
       (?$(0:6(B . "0x8A10") ;; <CJK>
       (?$(0:7(B . "0x8A0E") ;; <CJK>
       (?$(0:8(B . "0x8A0C") ;; <CJK>
       (?$(0:9(B . "0x8A15") ;; <CJK>
       (?$(0::(B . "0x8A0A") ;; <CJK>
       (?$(0:;(B . "0x8A17") ;; <CJK>
       (?$(0:<(B . "0x8A13") ;; <CJK>
       (?$(0:=(B . "0x8A16") ;; <CJK>
       (?$(0:>(B . "0x8A0F") ;; <CJK>
       (?$(0:?(B . "0x8A11") ;; <CJK>
       (?$(0:@(B . "0x8C48") ;; <CJK>
       (?$(0:A(B . "0x8C7A") ;; <CJK>
       (?$(0:B(B . "0x8C79") ;; <CJK>
       (?$(0:C(B . "0x8CA1") ;; <CJK>
       (?$(0:D(B . "0x8CA2") ;; <CJK>
       (?$(0:E(B . "0x8D77") ;; <CJK>
       (?$(0:F(B . "0x8EAC") ;; <CJK>
       (?$(0:G(B . "0x8ED2") ;; <CJK>
       (?$(0:H(B . "0x8ED4") ;; <CJK>
       (?$(0:I(B . "0x8ECF") ;; <CJK>
       (?$(0:J(B . "0x8FB1") ;; <CJK>
       (?$(0:K(B . "0x9001") ;; <CJK>
       (?$(0:L(B . "0x9006") ;; <CJK>
       (?$(0:M(B . "0x8FF7") ;; <CJK>
       (?$(0:N(B . "0x9000") ;; <CJK>
       (?$(0:O(B . "0x8FFA") ;; <CJK>
       (?$(0:P(B . "0x8FF4") ;; <CJK>
       (?$(0:Q(B . "0x9003") ;; <CJK>
       (?$(0:R(B . "0x8FFD") ;; <CJK>
       (?$(0:S(B . "0x9005") ;; <CJK>
       (?$(0:T(B . "0x8FF8") ;; <CJK>
       (?$(0:U(B . "0x9095") ;; <CJK>
       (?$(0:V(B . "0x90E1") ;; <CJK>
       (?$(0:W(B . "0x90DD") ;; <CJK>
       (?$(0:X(B . "0x90E2") ;; <CJK>
       (?$(0:Y(B . "0x9152") ;; <CJK>
       (?$(0:Z(B . "0x914D") ;; <CJK>
       (?$(0:[(B . "0x914C") ;; <CJK>
       (?$(0:\(B . "0x91D8") ;; <CJK>
       (?$(0:](B . "0x91DD") ;; <CJK>
       (?$(0:^(B . "0x91D7") ;; <CJK>
       (?$(0:_(B . "0x91DC") ;; <CJK>
       (?$(0:`(B . "0x91D9") ;; <CJK>
       (?$(0:a(B . "0x9583") ;; <CJK>
       (?$(0:b(B . "0x9662") ;; <CJK>
       (?$(0:c(B . "0x9663") ;; <CJK>
       (?$(0:d(B . "0x9661") ;; <CJK>
       (?$(0:e(B . "0x965B") ;; <CJK>
       (?$(0:f(B . "0x965D") ;; <CJK>
       (?$(0:g(B . "0x9664") ;; <CJK>
       (?$(0:h(B . "0x9658") ;; <CJK>
       (?$(0:i(B . "0x965E") ;; <CJK>
       (?$(0:j(B . "0x96BB") ;; <CJK>
       (?$(0:k(B . "0x98E2") ;; <CJK>
       (?$(0:l(B . "0x99AC") ;; <CJK>
       (?$(0:m(B . "0x9AA8") ;; <CJK>
       (?$(0:n(B . "0x9AD8") ;; <CJK>
       (?$(0:o(B . "0x9B25") ;; <CJK>
       (?$(0:p(B . "0x9B32") ;; <CJK>
       (?$(0:q(B . "0x9B3C") ;; <CJK>
       (?$(0:r(B . "0x4E7E") ;; <CJK>
       (?$(0:s(B . "0x507A") ;; <CJK>
       (?$(0:t(B . "0x507D") ;; <CJK>
       (?$(0:u(B . "0x505C") ;; <CJK>
       (?$(0:v(B . "0x5047") ;; <CJK>
       (?$(0:w(B . "0x5043") ;; <CJK>
       (?$(0:x(B . "0x504C") ;; <CJK>
       (?$(0:y(B . "0x505A") ;; <CJK>
       (?$(0:z(B . "0x5049") ;; <CJK>
       (?$(0:{(B . "0x5065") ;; <CJK>
       (?$(0:|(B . "0x5076") ;; <CJK>
       (?$(0:}(B . "0x504E") ;; <CJK>
       (?$(0:~(B . "0x5055") ;; <CJK>
       (?$(0;!(B . "0x5075") ;; <CJK>
       (?$(0;"(B . "0x5074") ;; <CJK>
       (?$(0;#(B . "0x5077") ;; <CJK>
       (?$(0;$(B . "0x504F") ;; <CJK>
       (?$(0;%(B . "0x500F") ;; <CJK>
       (?$(0;&(B . "0x506F") ;; <CJK>
       (?$(0;'(B . "0x506D") ;; <CJK>
       (?$(0;((B . "0x515C") ;; <CJK>
       (?$(0;)(B . "0x5195") ;; <CJK>
       (?$(0;*(B . "0x51F0") ;; <CJK>
       (?$(0;+(B . "0x526A") ;; <CJK>
       (?$(0;,(B . "0x526F") ;; <CJK>
       (?$(0;-(B . "0x52D2") ;; <CJK>
       (?$(0;.(B . "0x52D9") ;; <CJK>
       (?$(0;/(B . "0x52D8") ;; <CJK>
       (?$(0;0(B . "0x52D5") ;; <CJK>
       (?$(0;1(B . "0x5310") ;; <CJK>
       (?$(0;2(B . "0x530F") ;; <CJK>
       (?$(0;3(B . "0x5319") ;; <CJK>
       (?$(0;4(B . "0x533F") ;; <CJK>
       (?$(0;5(B . "0x5340") ;; <CJK>
       (?$(0;6(B . "0x533E") ;; <CJK>
       (?$(0;7(B . "0x53C3") ;; <CJK>
       (?$(0;8(B . "0x66FC") ;; <CJK>
       (?$(0;9(B . "0x5546") ;; <CJK>
       (?$(0;:(B . "0x556A") ;; <CJK>
       (?$(0;;(B . "0x5566") ;; <CJK>
       (?$(0;<(B . "0x5544") ;; <CJK>
       (?$(0;=(B . "0x555E") ;; <CJK>
       (?$(0;>(B . "0x5561") ;; <CJK>
       (?$(0;?(B . "0x5543") ;; <CJK>
       (?$(0;@(B . "0x554A") ;; <CJK>
       (?$(0;A(B . "0x5531") ;; <CJK>
       (?$(0;B(B . "0x5556") ;; <CJK>
       (?$(0;C(B . "0x554F") ;; <CJK>
       (?$(0;D(B . "0x5555") ;; <CJK>
       (?$(0;E(B . "0x552F") ;; <CJK>
       (?$(0;F(B . "0x5564") ;; <CJK>
       (?$(0;G(B . "0x5538") ;; <CJK>
       (?$(0;H(B . "0x552E") ;; <CJK>
       (?$(0;I(B . "0x555C") ;; <CJK>
       (?$(0;J(B . "0x552C") ;; <CJK>
       (?$(0;K(B . "0x5563") ;; <CJK>
       (?$(0;L(B . "0x5533") ;; <CJK>
       (?$(0;M(B . "0x5541") ;; <CJK>
       (?$(0;N(B . "0x5557") ;; <CJK>
       (?$(0;O(B . "0x5708") ;; <CJK>
       (?$(0;P(B . "0x570B") ;; <CJK>
       (?$(0;Q(B . "0x5709") ;; <CJK>
       (?$(0;R(B . "0x57DF") ;; <CJK>
       (?$(0;S(B . "0x5805") ;; <CJK>
       (?$(0;T(B . "0x580A") ;; <CJK>
       (?$(0;U(B . "0x5806") ;; <CJK>
       (?$(0;V(B . "0x57E0") ;; <CJK>
       (?$(0;W(B . "0x57E4") ;; <CJK>
       (?$(0;X(B . "0x57FA") ;; <CJK>
       (?$(0;Y(B . "0x5802") ;; <CJK>
       (?$(0;Z(B . "0x5835") ;; <CJK>
       (?$(0;[(B . "0x57F7") ;; <CJK>
       (?$(0;\(B . "0x57F9") ;; <CJK>
       (?$(0;](B . "0x5920") ;; <CJK>
       (?$(0;^(B . "0x5962") ;; <CJK>
       (?$(0;_(B . "0x5A36") ;; <CJK>
       (?$(0;`(B . "0x5A41") ;; <CJK>
       (?$(0;a(B . "0x5A49") ;; <CJK>
       (?$(0;b(B . "0x5A66") ;; <CJK>
       (?$(0;c(B . "0x5A6A") ;; <CJK>
       (?$(0;d(B . "0x5A40") ;; <CJK>
       (?$(0;e(B . "0x5A3C") ;; <CJK>
       (?$(0;f(B . "0x5A62") ;; <CJK>
       (?$(0;g(B . "0x5A5A") ;; <CJK>
       (?$(0;h(B . "0x5A46") ;; <CJK>
       (?$(0;i(B . "0x5A4A") ;; <CJK>
       (?$(0;j(B . "0x5B70") ;; <CJK>
       (?$(0;k(B . "0x5BC7") ;; <CJK>
       (?$(0;l(B . "0x5BC5") ;; <CJK>
       (?$(0;m(B . "0x5BC4") ;; <CJK>
       (?$(0;n(B . "0x5BC2") ;; <CJK>
       (?$(0;o(B . "0x5BBF") ;; <CJK>
       (?$(0;p(B . "0x5BC6") ;; <CJK>
       (?$(0;q(B . "0x5C09") ;; <CJK>
       (?$(0;r(B . "0x5C08") ;; <CJK>
       (?$(0;s(B . "0x5C07") ;; <CJK>
       (?$(0;t(B . "0x5C60") ;; <CJK>
       (?$(0;u(B . "0x5C5C") ;; <CJK>
       (?$(0;v(B . "0x5C5D") ;; <CJK>
       (?$(0;w(B . "0x5D07") ;; <CJK>
       (?$(0;x(B . "0x5D06") ;; <CJK>
       (?$(0;y(B . "0x5D0E") ;; <CJK>
       (?$(0;z(B . "0x5D1B") ;; <CJK>
       (?$(0;{(B . "0x5D16") ;; <CJK>
       (?$(0;|(B . "0x5D22") ;; <CJK>
       (?$(0;}(B . "0x5D11") ;; <CJK>
       (?$(0;~(B . "0x5D29") ;; <CJK>
       (?$(0<!(B . "0x5D14") ;; <CJK>
       (?$(0<"(B . "0x5D19") ;; <CJK>
       (?$(0<#(B . "0x5D24") ;; <CJK>
       (?$(0<$(B . "0x5D27") ;; <CJK>
       (?$(0<%(B . "0x5D17") ;; <CJK>
       (?$(0<&(B . "0x5DE2") ;; <CJK>
       (?$(0<'(B . "0x5E38") ;; <CJK>
       (?$(0<((B . "0x5E36") ;; <CJK>
       (?$(0<)(B . "0x5E33") ;; <CJK>
       (?$(0<*(B . "0x5E37") ;; <CJK>
       (?$(0<+(B . "0x5EB7") ;; <CJK>
       (?$(0<,(B . "0x5EB8") ;; <CJK>
       (?$(0<-(B . "0x5EB6") ;; <CJK>
       (?$(0<.(B . "0x5EB5") ;; <CJK>
       (?$(0</(B . "0x5EBE") ;; <CJK>
       (?$(0<0(B . "0x5F35") ;; <CJK>
       (?$(0<1(B . "0x5F37") ;; <CJK>
       (?$(0<2(B . "0x5F57") ;; <CJK>
       (?$(0<3(B . "0x5F6C") ;; <CJK>
       (?$(0<4(B . "0x5F69") ;; <CJK>
       (?$(0<5(B . "0x5F6B") ;; <CJK>
       (?$(0<6(B . "0x5F97") ;; <CJK>
       (?$(0<7(B . "0x5F99") ;; <CJK>
       (?$(0<8(B . "0x5F9E") ;; <CJK>
       (?$(0<9(B . "0x5F98") ;; <CJK>
       (?$(0<:(B . "0x5FA1") ;; <CJK>
       (?$(0<;(B . "0x5FA0") ;; <CJK>
       (?$(0<<(B . "0x5F9C") ;; <CJK>
       (?$(0<=(B . "0x607F") ;; <CJK>
       (?$(0<>(B . "0x60A3") ;; <CJK>
       (?$(0<?(B . "0x6089") ;; <CJK>
       (?$(0<@(B . "0x60A0") ;; <CJK>
       (?$(0<A(B . "0x60A8") ;; <CJK>
       (?$(0<B(B . "0x60CB") ;; <CJK>
       (?$(0<C(B . "0x60B4") ;; <CJK>
       (?$(0<D(B . "0x60E6") ;; <CJK>
       (?$(0<E(B . "0x60BD") ;; <CJK>
       (?$(0<F(B . "0x60C5") ;; <CJK>
       (?$(0<G(B . "0x60BB") ;; <CJK>
       (?$(0<H(B . "0x60B5") ;; <CJK>
       (?$(0<I(B . "0x60DC") ;; <CJK>
       (?$(0<J(B . "0x60BC") ;; <CJK>
       (?$(0<K(B . "0x60D8") ;; <CJK>
       (?$(0<L(B . "0x60D5") ;; <CJK>
       (?$(0<M(B . "0x60C6") ;; <CJK>
       (?$(0<N(B . "0x60DF") ;; <CJK>
       (?$(0<O(B . "0x60B8") ;; <CJK>
       (?$(0<P(B . "0x60DA") ;; <CJK>
       (?$(0<Q(B . "0x60C7") ;; <CJK>
       (?$(0<R(B . "0x621A") ;; <CJK>
       (?$(0<S(B . "0x621B") ;; <CJK>
       (?$(0<T(B . "0x6248") ;; <CJK>
       (?$(0<U(B . "0x63A0") ;; <CJK>
       (?$(0<V(B . "0x63A7") ;; <CJK>
       (?$(0<W(B . "0x6372") ;; <CJK>
       (?$(0<X(B . "0x6396") ;; <CJK>
       (?$(0<Y(B . "0x63A2") ;; <CJK>
       (?$(0<Z(B . "0x63A5") ;; <CJK>
       (?$(0<[(B . "0x6377") ;; <CJK>
       (?$(0<\(B . "0x6367") ;; <CJK>
       (?$(0<](B . "0x6398") ;; <CJK>
       (?$(0<^(B . "0x63AA") ;; <CJK>
       (?$(0<_(B . "0x6371") ;; <CJK>
       (?$(0<`(B . "0x63A9") ;; <CJK>
       (?$(0<a(B . "0x6389") ;; <CJK>
       (?$(0<b(B . "0x6383") ;; <CJK>
       (?$(0<c(B . "0x639B") ;; <CJK>
       (?$(0<d(B . "0x636B") ;; <CJK>
       (?$(0<e(B . "0x63A8") ;; <CJK>
       (?$(0<f(B . "0x6384") ;; <CJK>
       (?$(0<g(B . "0x6388") ;; <CJK>
       (?$(0<h(B . "0x6399") ;; <CJK>
       (?$(0<i(B . "0x63A1") ;; <CJK>
       (?$(0<j(B . "0x63AC") ;; <CJK>
       (?$(0<k(B . "0x6392") ;; <CJK>
       (?$(0<l(B . "0x638F") ;; <CJK>
       (?$(0<m(B . "0x6380") ;; <CJK>
       (?$(0<n(B . "0x637B") ;; <CJK>
       (?$(0<o(B . "0x6369") ;; <CJK>
       (?$(0<p(B . "0x6368") ;; <CJK>
       (?$(0<q(B . "0x637A") ;; <CJK>
       (?$(0<r(B . "0x655D") ;; <CJK>
       (?$(0<s(B . "0x6556") ;; <CJK>
       (?$(0<t(B . "0x6551") ;; <CJK>
       (?$(0<u(B . "0x6559") ;; <CJK>
       (?$(0<v(B . "0x6557") ;; <CJK>
       (?$(0<w(B . "0x555F") ;; <CJK>
       (?$(0<x(B . "0x654F") ;; <CJK>
       (?$(0<y(B . "0x6558") ;; <CJK>
       (?$(0<z(B . "0x6555") ;; <CJK>
       (?$(0<{(B . "0x6554") ;; <CJK>
       (?$(0<|(B . "0x659C") ;; <CJK>
       (?$(0<}(B . "0x659B") ;; <CJK>
       (?$(0<~(B . "0x65AC") ;; <CJK>
       (?$(0=!(B . "0x65CF") ;; <CJK>
       (?$(0="(B . "0x65CB") ;; <CJK>
       (?$(0=#(B . "0x65CC") ;; <CJK>
       (?$(0=$(B . "0x65CE") ;; <CJK>
       (?$(0=%(B . "0x665D") ;; <CJK>
       (?$(0=&(B . "0x665A") ;; <CJK>
       (?$(0='(B . "0x6664") ;; <CJK>
       (?$(0=((B . "0x6668") ;; <CJK>
       (?$(0=)(B . "0x6666") ;; <CJK>
       (?$(0=*(B . "0x665E") ;; <CJK>
       (?$(0=+(B . "0x66F9") ;; <CJK>
       (?$(0=,(B . "0x52D7") ;; <CJK>
       (?$(0=-(B . "0x671B") ;; <CJK>
       (?$(0=.(B . "0x6881") ;; <CJK>
       (?$(0=/(B . "0x68AF") ;; <CJK>
       (?$(0=0(B . "0x68A2") ;; <CJK>
       (?$(0=1(B . "0x6893") ;; <CJK>
       (?$(0=2(B . "0x68B5") ;; <CJK>
       (?$(0=3(B . "0x687F") ;; <CJK>
       (?$(0=4(B . "0x6876") ;; <CJK>
       (?$(0=5(B . "0x68B1") ;; <CJK>
       (?$(0=6(B . "0x68A7") ;; <CJK>
       (?$(0=7(B . "0x6897") ;; <CJK>
       (?$(0=8(B . "0x68B0") ;; <CJK>
       (?$(0=9(B . "0x6883") ;; <CJK>
       (?$(0=:(B . "0x68C4") ;; <CJK>
       (?$(0=;(B . "0x68AD") ;; <CJK>
       (?$(0=<(B . "0x6886") ;; <CJK>
       (?$(0==(B . "0x6885") ;; <CJK>
       (?$(0=>(B . "0x6894") ;; <CJK>
       (?$(0=?(B . "0x689D") ;; <CJK>
       (?$(0=@(B . "0x68A8") ;; <CJK>
       (?$(0=A(B . "0x689F") ;; <CJK>
       (?$(0=B(B . "0x68A1") ;; <CJK>
       (?$(0=C(B . "0x6882") ;; <CJK>
       (?$(0=D(B . "0x6B32") ;; <CJK>
       (?$(0=E(B . "0x6BBA") ;; <CJK>
       (?$(0=F(B . "0x6BEB") ;; <CJK>
       (?$(0=G(B . "0x6BEC") ;; <CJK>
       (?$(0=H(B . "0x6C2B") ;; <CJK>
       (?$(0=I(B . "0x6D8E") ;; <CJK>
       (?$(0=J(B . "0x6DBC") ;; <CJK>
       (?$(0=K(B . "0x6DF3") ;; <CJK>
       (?$(0=L(B . "0x6DD9") ;; <CJK>
       (?$(0=M(B . "0x6DB2") ;; <CJK>
       (?$(0=N(B . "0x6DE1") ;; <CJK>
       (?$(0=O(B . "0x6DCC") ;; <CJK>
       (?$(0=P(B . "0x6DE4") ;; <CJK>
       (?$(0=Q(B . "0x6DFB") ;; <CJK>
       (?$(0=R(B . "0x6DFA") ;; <CJK>
       (?$(0=S(B . "0x6E05") ;; <CJK>
       (?$(0=T(B . "0x6DC7") ;; <CJK>
       (?$(0=U(B . "0x6DCB") ;; <CJK>
       (?$(0=V(B . "0x6DAF") ;; <CJK>
       (?$(0=W(B . "0x6DD1") ;; <CJK>
       (?$(0=X(B . "0x6DAE") ;; <CJK>
       (?$(0=Y(B . "0x6DDE") ;; <CJK>
       (?$(0=Z(B . "0x6DF9") ;; <CJK>
       (?$(0=[(B . "0x6DB8") ;; <CJK>
       (?$(0=\(B . "0x6DF7") ;; <CJK>
       (?$(0=](B . "0x6DF5") ;; <CJK>
       (?$(0=^(B . "0x6DC5") ;; <CJK>
       (?$(0=_(B . "0x6DD2") ;; <CJK>
       (?$(0=`(B . "0x6E1A") ;; <CJK>
       (?$(0=a(B . "0x6DB5") ;; <CJK>
       (?$(0=b(B . "0x6DDA") ;; <CJK>
       (?$(0=c(B . "0x6DEB") ;; <CJK>
       (?$(0=d(B . "0x6DD8") ;; <CJK>
       (?$(0=e(B . "0x6DEA") ;; <CJK>
       (?$(0=f(B . "0x6DF1") ;; <CJK>
       (?$(0=g(B . "0x6DEE") ;; <CJK>
       (?$(0=h(B . "0x6DE8") ;; <CJK>
       (?$(0=i(B . "0x6DC6") ;; <CJK>
       (?$(0=j(B . "0x6DC4") ;; <CJK>
       (?$(0=k(B . "0x6DAA") ;; <CJK>
       (?$(0=l(B . "0x6DEC") ;; <CJK>
       (?$(0=m(B . "0x6DBF") ;; <CJK>
       (?$(0=n(B . "0x6DE6") ;; <CJK>
       (?$(0=o(B . "0x70F9") ;; <CJK>
       (?$(0=p(B . "0x7109") ;; <CJK>
       (?$(0=q(B . "0x710A") ;; <CJK>
       (?$(0=r(B . "0x70FD") ;; <CJK>
       (?$(0=s(B . "0x70EF") ;; <CJK>
       (?$(0=t(B . "0x723D") ;; <CJK>
       (?$(0=u(B . "0x727D") ;; <CJK>
       (?$(0=v(B . "0x7281") ;; <CJK>
       (?$(0=w(B . "0x731C") ;; <CJK>
       (?$(0=x(B . "0x731B") ;; <CJK>
       (?$(0=y(B . "0x7316") ;; <CJK>
       (?$(0=z(B . "0x7313") ;; <CJK>
       (?$(0={(B . "0x7319") ;; <CJK>
       (?$(0=|(B . "0x7387") ;; <CJK>
       (?$(0=}(B . "0x7405") ;; <CJK>
       (?$(0=~(B . "0x740A") ;; <CJK>
       (?$(0>!(B . "0x7403") ;; <CJK>
       (?$(0>"(B . "0x7406") ;; <CJK>
       (?$(0>#(B . "0x73FE") ;; <CJK>
       (?$(0>$(B . "0x740D") ;; <CJK>
       (?$(0>%(B . "0x74E0") ;; <CJK>
       (?$(0>&(B . "0x74F6") ;; <CJK>
       (?$(0>'(B . "0x74F7") ;; <CJK>
       (?$(0>((B . "0x751C") ;; <CJK>
       (?$(0>)(B . "0x7522") ;; <CJK>
       (?$(0>*(B . "0x7565") ;; <CJK>
       (?$(0>+(B . "0x7566") ;; <CJK>
       (?$(0>,(B . "0x7562") ;; <CJK>
       (?$(0>-(B . "0x7570") ;; <CJK>
       (?$(0>.(B . "0x758F") ;; <CJK>
       (?$(0>/(B . "0x75D4") ;; <CJK>
       (?$(0>0(B . "0x75D5") ;; <CJK>
       (?$(0>1(B . "0x75B5") ;; <CJK>
       (?$(0>2(B . "0x75CA") ;; <CJK>
       (?$(0>3(B . "0x75CD") ;; <CJK>
       (?$(0>4(B . "0x768E") ;; <CJK>
       (?$(0>5(B . "0x76D4") ;; <CJK>
       (?$(0>6(B . "0x76D2") ;; <CJK>
       (?$(0>7(B . "0x76DB") ;; <CJK>
       (?$(0>8(B . "0x7737") ;; <CJK>
       (?$(0>9(B . "0x773E") ;; <CJK>
       (?$(0>:(B . "0x773C") ;; <CJK>
       (?$(0>;(B . "0x7736") ;; <CJK>
       (?$(0><(B . "0x7738") ;; <CJK>
       (?$(0>=(B . "0x773A") ;; <CJK>
       (?$(0>>(B . "0x786B") ;; <CJK>
       (?$(0>?(B . "0x7843") ;; <CJK>
       (?$(0>@(B . "0x784E") ;; <CJK>
       (?$(0>A(B . "0x7965") ;; <CJK>
       (?$(0>B(B . "0x7968") ;; <CJK>
       (?$(0>C(B . "0x796D") ;; <CJK>
       (?$(0>D(B . "0x79FB") ;; <CJK>
       (?$(0>E(B . "0x7A92") ;; <CJK>
       (?$(0>F(B . "0x7A95") ;; <CJK>
       (?$(0>G(B . "0x7B20") ;; <CJK>
       (?$(0>H(B . "0x7B28") ;; <CJK>
       (?$(0>I(B . "0x7B1B") ;; <CJK>
       (?$(0>J(B . "0x7B2C") ;; <CJK>
       (?$(0>K(B . "0x7B26") ;; <CJK>
       (?$(0>L(B . "0x7B19") ;; <CJK>
       (?$(0>M(B . "0x7B1E") ;; <CJK>
       (?$(0>N(B . "0x7B2E") ;; <CJK>
       (?$(0>O(B . "0x7C92") ;; <CJK>
       (?$(0>P(B . "0x7C97") ;; <CJK>
       (?$(0>Q(B . "0x7C95") ;; <CJK>
       (?$(0>R(B . "0x7D46") ;; <CJK>
       (?$(0>S(B . "0x7D43") ;; <CJK>
       (?$(0>T(B . "0x7D71") ;; <CJK>
       (?$(0>U(B . "0x7D2E") ;; <CJK>
       (?$(0>V(B . "0x7D39") ;; <CJK>
       (?$(0>W(B . "0x7D3C") ;; <CJK>
       (?$(0>X(B . "0x7D40") ;; <CJK>
       (?$(0>Y(B . "0x7D30") ;; <CJK>
       (?$(0>Z(B . "0x7D33") ;; <CJK>
       (?$(0>[(B . "0x7D44") ;; <CJK>
       (?$(0>\(B . "0x7D2F") ;; <CJK>
       (?$(0>](B . "0x7D42") ;; <CJK>
       (?$(0>^(B . "0x7D32") ;; <CJK>
       (?$(0>_(B . "0x7D31") ;; <CJK>
       (?$(0>`(B . "0x7F3D") ;; <CJK>
       (?$(0>a(B . "0x7F9E") ;; <CJK>
       (?$(0>b(B . "0x7F9A") ;; <CJK>
       (?$(0>c(B . "0x7FCC") ;; <CJK>
       (?$(0>d(B . "0x7FCE") ;; <CJK>
       (?$(0>e(B . "0x7FD2") ;; <CJK>
       (?$(0>f(B . "0x801C") ;; <CJK>
       (?$(0>g(B . "0x804A") ;; <CJK>
       (?$(0>h(B . "0x8046") ;; <CJK>
       (?$(0>i(B . "0x812F") ;; <CJK>
       (?$(0>j(B . "0x8116") ;; <CJK>
       (?$(0>k(B . "0x8123") ;; <CJK>
       (?$(0>l(B . "0x812B") ;; <CJK>
       (?$(0>m(B . "0x8129") ;; <CJK>
       (?$(0>n(B . "0x8130") ;; <CJK>
       (?$(0>o(B . "0x8124") ;; <CJK>
       (?$(0>p(B . "0x8202") ;; <CJK>
       (?$(0>q(B . "0x8235") ;; <CJK>
       (?$(0>r(B . "0x8237") ;; <CJK>
       (?$(0>s(B . "0x8236") ;; <CJK>
       (?$(0>t(B . "0x8239") ;; <CJK>
       (?$(0>u(B . "0x838E") ;; <CJK>
       (?$(0>v(B . "0x839E") ;; <CJK>
       (?$(0>w(B . "0x8398") ;; <CJK>
       (?$(0>x(B . "0x8378") ;; <CJK>
       (?$(0>y(B . "0x83A2") ;; <CJK>
       (?$(0>z(B . "0x8396") ;; <CJK>
       (?$(0>{(B . "0x83BD") ;; <CJK>
       (?$(0>|(B . "0x83AB") ;; <CJK>
       (?$(0>}(B . "0x8392") ;; <CJK>
       (?$(0>~(B . "0x838A") ;; <CJK>
       (?$(0?!(B . "0x8393") ;; <CJK>
       (?$(0?"(B . "0x8389") ;; <CJK>
       (?$(0?#(B . "0x83A0") ;; <CJK>
       (?$(0?$(B . "0x8377") ;; <CJK>
       (?$(0?%(B . "0x837B") ;; <CJK>
       (?$(0?&(B . "0x837C") ;; <CJK>
       (?$(0?'(B . "0x8386") ;; <CJK>
       (?$(0?((B . "0x83A7") ;; <CJK>
       (?$(0?)(B . "0x8655") ;; <CJK>
       (?$(0?*(B . "0x5F6A") ;; <CJK>
       (?$(0?+(B . "0x86C7") ;; <CJK>
       (?$(0?,(B . "0x86C0") ;; <CJK>
       (?$(0?-(B . "0x86B6") ;; <CJK>
       (?$(0?.(B . "0x86C4") ;; <CJK>
       (?$(0?/(B . "0x86B5") ;; <CJK>
       (?$(0?0(B . "0x86C6") ;; <CJK>
       (?$(0?1(B . "0x86CB") ;; <CJK>
       (?$(0?2(B . "0x86B1") ;; <CJK>
       (?$(0?3(B . "0x86AF") ;; <CJK>
       (?$(0?4(B . "0x86C9") ;; <CJK>
       (?$(0?5(B . "0x8853") ;; <CJK>
       (?$(0?6(B . "0x889E") ;; <CJK>
       (?$(0?7(B . "0x8888") ;; <CJK>
       (?$(0?8(B . "0x88AB") ;; <CJK>
       (?$(0?9(B . "0x8892") ;; <CJK>
       (?$(0?:(B . "0x8896") ;; <CJK>
       (?$(0?;(B . "0x888D") ;; <CJK>
       (?$(0?<(B . "0x888B") ;; <CJK>
       (?$(0?=(B . "0x8993") ;; <CJK>
       (?$(0?>(B . "0x898F") ;; <CJK>
       (?$(0??(B . "0x8A2A") ;; <CJK>
       (?$(0?@(B . "0x8A1D") ;; <CJK>
       (?$(0?A(B . "0x8A23") ;; <CJK>
       (?$(0?B(B . "0x8A25") ;; <CJK>
       (?$(0?C(B . "0x8A31") ;; <CJK>
       (?$(0?D(B . "0x8A2D") ;; <CJK>
       (?$(0?E(B . "0x8A1F") ;; <CJK>
       (?$(0?F(B . "0x8A1B") ;; <CJK>
       (?$(0?G(B . "0x8A22") ;; <CJK>
       (?$(0?H(B . "0x8C49") ;; <CJK>
       (?$(0?I(B . "0x8C5A") ;; <CJK>
       (?$(0?J(B . "0x8CA9") ;; <CJK>
       (?$(0?K(B . "0x8CAC") ;; <CJK>
       (?$(0?L(B . "0x8CAB") ;; <CJK>
       (?$(0?M(B . "0x8CA8") ;; <CJK>
       (?$(0?N(B . "0x8CAA") ;; <CJK>
       (?$(0?O(B . "0x8CA7") ;; <CJK>
       (?$(0?P(B . "0x8D67") ;; <CJK>
       (?$(0?Q(B . "0x8D66") ;; <CJK>
       (?$(0?R(B . "0x8DBE") ;; <CJK>
       (?$(0?S(B . "0x8DBA") ;; <CJK>
       (?$(0?T(B . "0x8EDB") ;; <CJK>
       (?$(0?U(B . "0x8EDF") ;; <CJK>
       (?$(0?V(B . "0x9019") ;; <CJK>
       (?$(0?W(B . "0x900D") ;; <CJK>
       (?$(0?X(B . "0x901A") ;; <CJK>
       (?$(0?Y(B . "0x9017") ;; <CJK>
       (?$(0?Z(B . "0x9023") ;; <CJK>
       (?$(0?[(B . "0x901F") ;; <CJK>
       (?$(0?\(B . "0x901D") ;; <CJK>
       (?$(0?](B . "0x9010") ;; <CJK>
       (?$(0?^(B . "0x9015") ;; <CJK>
       (?$(0?_(B . "0x901E") ;; <CJK>
       (?$(0?`(B . "0x9020") ;; <CJK>
       (?$(0?a(B . "0x900F") ;; <CJK>
       (?$(0?b(B . "0x9022") ;; <CJK>
       (?$(0?c(B . "0x9016") ;; <CJK>
       (?$(0?d(B . "0x901B") ;; <CJK>
       (?$(0?e(B . "0x9014") ;; <CJK>
       (?$(0?f(B . "0x90E8") ;; <CJK>
       (?$(0?g(B . "0x90ED") ;; <CJK>
       (?$(0?h(B . "0x90FD") ;; <CJK>
       (?$(0?i(B . "0x9157") ;; <CJK>
       (?$(0?j(B . "0x91CE") ;; <CJK>
       (?$(0?k(B . "0x91F5") ;; <CJK>
       (?$(0?l(B . "0x91E6") ;; <CJK>
       (?$(0?m(B . "0x91E3") ;; <CJK>
       (?$(0?n(B . "0x91E7") ;; <CJK>
       (?$(0?o(B . "0x91ED") ;; <CJK>
       (?$(0?p(B . "0x91E9") ;; <CJK>
       (?$(0?q(B . "0x9589") ;; <CJK>
       (?$(0?r(B . "0x966A") ;; <CJK>
       (?$(0?s(B . "0x9675") ;; <CJK>
       (?$(0?t(B . "0x9673") ;; <CJK>
       (?$(0?u(B . "0x9678") ;; <CJK>
       (?$(0?v(B . "0x9670") ;; <CJK>
       (?$(0?w(B . "0x9674") ;; <CJK>
       (?$(0?x(B . "0x9676") ;; <CJK>
       (?$(0?y(B . "0x9677") ;; <CJK>
       (?$(0?z(B . "0x966C") ;; <CJK>
       (?$(0?{(B . "0x96C0") ;; <CJK>
       (?$(0?|(B . "0x96EA") ;; <CJK>
       (?$(0?}(B . "0x96E9") ;; <CJK>
       (?$(0?~(B . "0x7AE0") ;; <CJK>
       (?$(0@!(B . "0x7ADF") ;; <CJK>
       (?$(0@"(B . "0x9802") ;; <CJK>
       (?$(0@#(B . "0x9803") ;; <CJK>
       (?$(0@$(B . "0x9B5A") ;; <CJK>
       (?$(0@%(B . "0x9CE5") ;; <CJK>
       (?$(0@&(B . "0x9E75") ;; <CJK>
       (?$(0@'(B . "0x9E7F") ;; <CJK>
       (?$(0@((B . "0x9EA5") ;; <CJK>
       (?$(0@)(B . "0x9EBB") ;; <CJK>
       (?$(0@*(B . "0x50A2") ;; <CJK>
       (?$(0@+(B . "0x508D") ;; <CJK>
       (?$(0@,(B . "0x5085") ;; <CJK>
       (?$(0@-(B . "0x5099") ;; <CJK>
       (?$(0@.(B . "0x5091") ;; <CJK>
       (?$(0@/(B . "0x5080") ;; <CJK>
       (?$(0@0(B . "0x5096") ;; <CJK>
       (?$(0@1(B . "0x5098") ;; <CJK>
       (?$(0@2(B . "0x509A") ;; <CJK>
       (?$(0@3(B . "0x6700") ;; <CJK>
       (?$(0@4(B . "0x51F1") ;; <CJK>
       (?$(0@5(B . "0x5272") ;; <CJK>
       (?$(0@6(B . "0x5274") ;; <CJK>
       (?$(0@7(B . "0x5275") ;; <CJK>
       (?$(0@8(B . "0x5269") ;; <CJK>
       (?$(0@9(B . "0x52DE") ;; <CJK>
       (?$(0@:(B . "0x52DD") ;; <CJK>
       (?$(0@;(B . "0x52DB") ;; <CJK>
       (?$(0@<(B . "0x535A") ;; <CJK>
       (?$(0@=(B . "0x53A5") ;; <CJK>
       (?$(0@>(B . "0x557B") ;; <CJK>
       (?$(0@?(B . "0x5580") ;; <CJK>
       (?$(0@@(B . "0x55A7") ;; <CJK>
       (?$(0@A(B . "0x557C") ;; <CJK>
       (?$(0@B(B . "0x558A") ;; <CJK>
       (?$(0@C(B . "0x559D") ;; <CJK>
       (?$(0@D(B . "0x5598") ;; <CJK>
       (?$(0@E(B . "0x5582") ;; <CJK>
       (?$(0@F(B . "0x559C") ;; <CJK>
       (?$(0@G(B . "0x55AA") ;; <CJK>
       (?$(0@H(B . "0x5594") ;; <CJK>
       (?$(0@I(B . "0x5587") ;; <CJK>
       (?$(0@J(B . "0x558B") ;; <CJK>
       (?$(0@K(B . "0x5583") ;; <CJK>
       (?$(0@L(B . "0x55B3") ;; <CJK>
       (?$(0@M(B . "0x55AE") ;; <CJK>
       (?$(0@N(B . "0x559F") ;; <CJK>
       (?$(0@O(B . "0x553E") ;; <CJK>
       (?$(0@P(B . "0x55B2") ;; <CJK>
       (?$(0@Q(B . "0x559A") ;; <CJK>
       (?$(0@R(B . "0x55BB") ;; <CJK>
       (?$(0@S(B . "0x55AC") ;; <CJK>
       (?$(0@T(B . "0x55B1") ;; <CJK>
       (?$(0@U(B . "0x557E") ;; <CJK>
       (?$(0@V(B . "0x5589") ;; <CJK>
       (?$(0@W(B . "0x55AB") ;; <CJK>
       (?$(0@X(B . "0x5599") ;; <CJK>
       (?$(0@Y(B . "0x570D") ;; <CJK>
       (?$(0@Z(B . "0x582F") ;; <CJK>
       (?$(0@[(B . "0x582A") ;; <CJK>
       (?$(0@\(B . "0x5834") ;; <CJK>
       (?$(0@](B . "0x5824") ;; <CJK>
       (?$(0@^(B . "0x5830") ;; <CJK>
       (?$(0@_(B . "0x5831") ;; <CJK>
       (?$(0@`(B . "0x5821") ;; <CJK>
       (?$(0@a(B . "0x581D") ;; <CJK>
       (?$(0@b(B . "0x5820") ;; <CJK>
       (?$(0@c(B . "0x58F9") ;; <CJK>
       (?$(0@d(B . "0x58FA") ;; <CJK>
       (?$(0@e(B . "0x5960") ;; <CJK>
       (?$(0@f(B . "0x5A77") ;; <CJK>
       (?$(0@g(B . "0x5A9A") ;; <CJK>
       (?$(0@h(B . "0x5A7F") ;; <CJK>
       (?$(0@i(B . "0x5A92") ;; <CJK>
       (?$(0@j(B . "0x5A9B") ;; <CJK>
       (?$(0@k(B . "0x5AA7") ;; <CJK>
       (?$(0@l(B . "0x5B73") ;; <CJK>
       (?$(0@m(B . "0x5B71") ;; <CJK>
       (?$(0@n(B . "0x5BD2") ;; <CJK>
       (?$(0@o(B . "0x5BCC") ;; <CJK>
       (?$(0@p(B . "0x5BD3") ;; <CJK>
       (?$(0@q(B . "0x5BD0") ;; <CJK>
       (?$(0@r(B . "0x5C0A") ;; <CJK>
       (?$(0@s(B . "0x5C0B") ;; <CJK>
       (?$(0@t(B . "0x5C31") ;; <CJK>
       (?$(0@u(B . "0x5D4C") ;; <CJK>
       (?$(0@v(B . "0x5D50") ;; <CJK>
       (?$(0@w(B . "0x5D34") ;; <CJK>
       (?$(0@x(B . "0x5D47") ;; <CJK>
       (?$(0@y(B . "0x5DFD") ;; <CJK>
       (?$(0@z(B . "0x5E45") ;; <CJK>
       (?$(0@{(B . "0x5E3D") ;; <CJK>
       (?$(0@|(B . "0x5E40") ;; <CJK>
       (?$(0@}(B . "0x5E43") ;; <CJK>
       (?$(0@~(B . "0x5E7E") ;; <CJK>
       (?$(0A!(B . "0x5ECA") ;; <CJK>
       (?$(0A"(B . "0x5EC1") ;; <CJK>
       (?$(0A#(B . "0x5EC2") ;; <CJK>
       (?$(0A$(B . "0x5EC4") ;; <CJK>
       (?$(0A%(B . "0x5F3C") ;; <CJK>
       (?$(0A&(B . "0x5F6D") ;; <CJK>
       (?$(0A'(B . "0x5FA9") ;; <CJK>
       (?$(0A((B . "0x5FAA") ;; <CJK>
       (?$(0A)(B . "0x5FA8") ;; <CJK>
       (?$(0A*(B . "0x60D1") ;; <CJK>
       (?$(0A+(B . "0x60E1") ;; <CJK>
       (?$(0A,(B . "0x60B2") ;; <CJK>
       (?$(0A-(B . "0x60B6") ;; <CJK>
       (?$(0A.(B . "0x60E0") ;; <CJK>
       (?$(0A/(B . "0x611C") ;; <CJK>
       (?$(0A0(B . "0x6123") ;; <CJK>
       (?$(0A1(B . "0x60FA") ;; <CJK>
       (?$(0A2(B . "0x6115") ;; <CJK>
       (?$(0A3(B . "0x60F0") ;; <CJK>
       (?$(0A4(B . "0x60FB") ;; <CJK>
       (?$(0A5(B . "0x60F4") ;; <CJK>
       (?$(0A6(B . "0x6168") ;; <CJK>
       (?$(0A7(B . "0x60F1") ;; <CJK>
       (?$(0A8(B . "0x610E") ;; <CJK>
       (?$(0A9(B . "0x60F6") ;; <CJK>
       (?$(0A:(B . "0x6109") ;; <CJK>
       (?$(0A;(B . "0x6100") ;; <CJK>
       (?$(0A<(B . "0x6112") ;; <CJK>
       (?$(0A=(B . "0x621F") ;; <CJK>
       (?$(0A>(B . "0x6249") ;; <CJK>
       (?$(0A?(B . "0x63A3") ;; <CJK>
       (?$(0A@(B . "0x638C") ;; <CJK>
       (?$(0AA(B . "0x63CF") ;; <CJK>
       (?$(0AB(B . "0x63C0") ;; <CJK>
       (?$(0AC(B . "0x63E9") ;; <CJK>
       (?$(0AD(B . "0x63C9") ;; <CJK>
       (?$(0AE(B . "0x63C6") ;; <CJK>
       (?$(0AF(B . "0x63CD") ;; <CJK>
       (?$(0AG(B . "0x63D2") ;; <CJK>
       (?$(0AH(B . "0x63E3") ;; <CJK>
       (?$(0AI(B . "0x63D0") ;; <CJK>
       (?$(0AJ(B . "0x63E1") ;; <CJK>
       (?$(0AK(B . "0x63D6") ;; <CJK>
       (?$(0AL(B . "0x63ED") ;; <CJK>
       (?$(0AM(B . "0x63EE") ;; <CJK>
       (?$(0AN(B . "0x6376") ;; <CJK>
       (?$(0AO(B . "0x63F4") ;; <CJK>
       (?$(0AP(B . "0x63EA") ;; <CJK>
       (?$(0AQ(B . "0x63DB") ;; <CJK>
       (?$(0AR(B . "0x6452") ;; <CJK>
       (?$(0AS(B . "0x63DA") ;; <CJK>
       (?$(0AT(B . "0x63F9") ;; <CJK>
       (?$(0AU(B . "0x655E") ;; <CJK>
       (?$(0AV(B . "0x6566") ;; <CJK>
       (?$(0AW(B . "0x6562") ;; <CJK>
       (?$(0AX(B . "0x6563") ;; <CJK>
       (?$(0AY(B . "0x6591") ;; <CJK>
       (?$(0AZ(B . "0x6590") ;; <CJK>
       (?$(0A[(B . "0x65AF") ;; <CJK>
       (?$(0A\(B . "0x666E") ;; <CJK>
       (?$(0A](B . "0x6670") ;; <CJK>
       (?$(0A^(B . "0x6674") ;; <CJK>
       (?$(0A_(B . "0x6676") ;; <CJK>
       (?$(0A`(B . "0x666F") ;; <CJK>
       (?$(0Aa(B . "0x6691") ;; <CJK>
       (?$(0Ab(B . "0x667A") ;; <CJK>
       (?$(0Ac(B . "0x667E") ;; <CJK>
       (?$(0Ad(B . "0x6677") ;; <CJK>
       (?$(0Ae(B . "0x66FE") ;; <CJK>
       (?$(0Af(B . "0x66FF") ;; <CJK>
       (?$(0Ag(B . "0x671F") ;; <CJK>
       (?$(0Ah(B . "0x671D") ;; <CJK>
       (?$(0Ai(B . "0x68FA") ;; <CJK>
       (?$(0Aj(B . "0x68D5") ;; <CJK>
       (?$(0Ak(B . "0x68E0") ;; <CJK>
       (?$(0Al(B . "0x68D8") ;; <CJK>
       (?$(0Am(B . "0x68D7") ;; <CJK>
       (?$(0An(B . "0x6905") ;; <CJK>
       (?$(0Ao(B . "0x68DF") ;; <CJK>
       (?$(0Ap(B . "0x68F5") ;; <CJK>
       (?$(0Aq(B . "0x68EE") ;; <CJK>
       (?$(0Ar(B . "0x68E7") ;; <CJK>
       (?$(0As(B . "0x68F9") ;; <CJK>
       (?$(0At(B . "0x68D2") ;; <CJK>
       (?$(0Au(B . "0x68F2") ;; <CJK>
       (?$(0Av(B . "0x68E3") ;; <CJK>
       (?$(0Aw(B . "0x68CB") ;; <CJK>
       (?$(0Ax(B . "0x68CD") ;; <CJK>
       (?$(0Ay(B . "0x690D") ;; <CJK>
       (?$(0Az(B . "0x6912") ;; <CJK>
       (?$(0A{(B . "0x690E") ;; <CJK>
       (?$(0A|(B . "0x68C9") ;; <CJK>
       (?$(0A}(B . "0x68DA") ;; <CJK>
       (?$(0A~(B . "0x696E") ;; <CJK>
       (?$(0B!(B . "0x68FB") ;; <CJK>
       (?$(0B"(B . "0x6B3E") ;; <CJK>
       (?$(0B#(B . "0x6B3A") ;; <CJK>
       (?$(0B$(B . "0x6B3D") ;; <CJK>
       (?$(0B%(B . "0x6B98") ;; <CJK>
       (?$(0B&(B . "0x6B96") ;; <CJK>
       (?$(0B'(B . "0x6BBC") ;; <CJK>
       (?$(0B((B . "0x6BEF") ;; <CJK>
       (?$(0B)(B . "0x6C2E") ;; <CJK>
       (?$(0B*(B . "0x6C2F") ;; <CJK>
       (?$(0B+(B . "0x6C2C") ;; <CJK>
       (?$(0B,(B . "0x6E2F") ;; <CJK>
       (?$(0B-(B . "0x6E38") ;; <CJK>
       (?$(0B.(B . "0x6E54") ;; <CJK>
       (?$(0B/(B . "0x6E21") ;; <CJK>
       (?$(0B0(B . "0x6E32") ;; <CJK>
       (?$(0B1(B . "0x6E67") ;; <CJK>
       (?$(0B2(B . "0x6E4A") ;; <CJK>
       (?$(0B3(B . "0x6E20") ;; <CJK>
       (?$(0B4(B . "0x6E25") ;; <CJK>
       (?$(0B5(B . "0x6E23") ;; <CJK>
       (?$(0B6(B . "0x6E1B") ;; <CJK>
       (?$(0B7(B . "0x6E5B") ;; <CJK>
       (?$(0B8(B . "0x6E58") ;; <CJK>
       (?$(0B9(B . "0x6E24") ;; <CJK>
       (?$(0B:(B . "0x6E56") ;; <CJK>
       (?$(0B;(B . "0x6E6E") ;; <CJK>
       (?$(0B<(B . "0x6E2D") ;; <CJK>
       (?$(0B=(B . "0x6E26") ;; <CJK>
       (?$(0B>(B . "0x6E6F") ;; <CJK>
       (?$(0B?(B . "0x6E34") ;; <CJK>
       (?$(0B@(B . "0x6E4D") ;; <CJK>
       (?$(0BA(B . "0x6E3A") ;; <CJK>
       (?$(0BB(B . "0x6E2C") ;; <CJK>
       (?$(0BC(B . "0x6E43") ;; <CJK>
       (?$(0BD(B . "0x6E1D") ;; <CJK>
       (?$(0BE(B . "0x6E3E") ;; <CJK>
       (?$(0BF(B . "0x6ECB") ;; <CJK>
       (?$(0BG(B . "0x6E89") ;; <CJK>
       (?$(0BH(B . "0x6E19") ;; <CJK>
       (?$(0BI(B . "0x6E4E") ;; <CJK>
       (?$(0BJ(B . "0x6E63") ;; <CJK>
       (?$(0BK(B . "0x6E44") ;; <CJK>
       (?$(0BL(B . "0x6E72") ;; <CJK>
       (?$(0BM(B . "0x6E69") ;; <CJK>
       (?$(0BN(B . "0x6E5F") ;; <CJK>
       (?$(0BO(B . "0x7119") ;; <CJK>
       (?$(0BP(B . "0x711A") ;; <CJK>
       (?$(0BQ(B . "0x7126") ;; <CJK>
       (?$(0BR(B . "0x7130") ;; <CJK>
       (?$(0BS(B . "0x7121") ;; <CJK>
       (?$(0BT(B . "0x7136") ;; <CJK>
       (?$(0BU(B . "0x716E") ;; <CJK>
       (?$(0BV(B . "0x711C") ;; <CJK>
       (?$(0BW(B . "0x724C") ;; <CJK>
       (?$(0BX(B . "0x7284") ;; <CJK>
       (?$(0BY(B . "0x7280") ;; <CJK>
       (?$(0BZ(B . "0x7336") ;; <CJK>
       (?$(0B[(B . "0x7325") ;; <CJK>
       (?$(0B\(B . "0x7334") ;; <CJK>
       (?$(0B](B . "0x7329") ;; <CJK>
       (?$(0B^(B . "0x743A") ;; <CJK>
       (?$(0B_(B . "0x742A") ;; <CJK>
       (?$(0B`(B . "0x7433") ;; <CJK>
       (?$(0Ba(B . "0x7422") ;; <CJK>
       (?$(0Bb(B . "0x7425") ;; <CJK>
       (?$(0Bc(B . "0x7435") ;; <CJK>
       (?$(0Bd(B . "0x7436") ;; <CJK>
       (?$(0Be(B . "0x7434") ;; <CJK>
       (?$(0Bf(B . "0x742F") ;; <CJK>
       (?$(0Bg(B . "0x741B") ;; <CJK>
       (?$(0Bh(B . "0x7426") ;; <CJK>
       (?$(0Bi(B . "0x7428") ;; <CJK>
       (?$(0Bj(B . "0x7525") ;; <CJK>
       (?$(0Bk(B . "0x7526") ;; <CJK>
       (?$(0Bl(B . "0x756B") ;; <CJK>
       (?$(0Bm(B . "0x756A") ;; <CJK>
       (?$(0Bn(B . "0x75E2") ;; <CJK>
       (?$(0Bo(B . "0x75DB") ;; <CJK>
       (?$(0Bp(B . "0x75E3") ;; <CJK>
       (?$(0Bq(B . "0x75D9") ;; <CJK>
       (?$(0Br(B . "0x75D8") ;; <CJK>
       (?$(0Bs(B . "0x75DE") ;; <CJK>
       (?$(0Bt(B . "0x75E0") ;; <CJK>
       (?$(0Bu(B . "0x767B") ;; <CJK>
       (?$(0Bv(B . "0x767C") ;; <CJK>
       (?$(0Bw(B . "0x7696") ;; <CJK>
       (?$(0Bx(B . "0x7693") ;; <CJK>
       (?$(0By(B . "0x76B4") ;; <CJK>
       (?$(0Bz(B . "0x76DC") ;; <CJK>
       (?$(0B{(B . "0x774F") ;; <CJK>
       (?$(0B|(B . "0x77ED") ;; <CJK>
       (?$(0B}(B . "0x785D") ;; <CJK>
       (?$(0B~(B . "0x786C") ;; <CJK>
       (?$(0C!(B . "0x786F") ;; <CJK>
       (?$(0C"(B . "0x7A0D") ;; <CJK>
       (?$(0C#(B . "0x7A08") ;; <CJK>
       (?$(0C$(B . "0x7A0B") ;; <CJK>
       (?$(0C%(B . "0x7A05") ;; <CJK>
       (?$(0C&(B . "0x7A00") ;; <CJK>
       (?$(0C'(B . "0x7A98") ;; <CJK>
       (?$(0C((B . "0x7A97") ;; <CJK>
       (?$(0C)(B . "0x7A96") ;; <CJK>
       (?$(0C*(B . "0x7AE5") ;; <CJK>
       (?$(0C+(B . "0x7AE3") ;; <CJK>
       (?$(0C,(B . "0x7B49") ;; <CJK>
       (?$(0C-(B . "0x7B56") ;; <CJK>
       (?$(0C.(B . "0x7B46") ;; <CJK>
       (?$(0C/(B . "0x7B50") ;; <CJK>
       (?$(0C0(B . "0x7B52") ;; <CJK>
       (?$(0C1(B . "0x7B54") ;; <CJK>
       (?$(0C2(B . "0x7B4D") ;; <CJK>
       (?$(0C3(B . "0x7B4B") ;; <CJK>
       (?$(0C4(B . "0x7B4F") ;; <CJK>
       (?$(0C5(B . "0x7B51") ;; <CJK>
       (?$(0C6(B . "0x7C9F") ;; <CJK>
       (?$(0C7(B . "0x7CA5") ;; <CJK>
       (?$(0C8(B . "0x7D5E") ;; <CJK>
       (?$(0C9(B . "0x7D50") ;; <CJK>
       (?$(0C:(B . "0x7D68") ;; <CJK>
       (?$(0C;(B . "0x7D55") ;; <CJK>
       (?$(0C<(B . "0x7D2B") ;; <CJK>
       (?$(0C=(B . "0x7D6E") ;; <CJK>
       (?$(0C>(B . "0x7D72") ;; <CJK>
       (?$(0C?(B . "0x7D61") ;; <CJK>
       (?$(0C@(B . "0x7D66") ;; <CJK>
       (?$(0CA(B . "0x7D62") ;; <CJK>
       (?$(0CB(B . "0x7D70") ;; <CJK>
       (?$(0CC(B . "0x7D73") ;; <CJK>
       (?$(0CD(B . "0x5584") ;; <CJK>
       (?$(0CE(B . "0x7FD4") ;; <CJK>
       (?$(0CF(B . "0x7FD5") ;; <CJK>
       (?$(0CG(B . "0x800B") ;; <CJK>
       (?$(0CH(B . "0x8052") ;; <CJK>
       (?$(0CI(B . "0x8085") ;; <CJK>
       (?$(0CJ(B . "0x8155") ;; <CJK>
       (?$(0CK(B . "0x8154") ;; <CJK>
       (?$(0CL(B . "0x814B") ;; <CJK>
       (?$(0CM(B . "0x8151") ;; <CJK>
       (?$(0CN(B . "0x814E") ;; <CJK>
       (?$(0CO(B . "0x8139") ;; <CJK>
       (?$(0CP(B . "0x8146") ;; <CJK>
       (?$(0CQ(B . "0x813E") ;; <CJK>
       (?$(0CR(B . "0x814C") ;; <CJK>
       (?$(0CS(B . "0x8153") ;; <CJK>
       (?$(0CT(B . "0x8174") ;; <CJK>
       (?$(0CU(B . "0x8212") ;; <CJK>
       (?$(0CV(B . "0x821C") ;; <CJK>
       (?$(0CW(B . "0x83E9") ;; <CJK>
       (?$(0CX(B . "0x8403") ;; <CJK>
       (?$(0CY(B . "0x83F8") ;; <CJK>
       (?$(0CZ(B . "0x840D") ;; <CJK>
       (?$(0C[(B . "0x83E0") ;; <CJK>
       (?$(0C\(B . "0x83C5") ;; <CJK>
       (?$(0C](B . "0x840B") ;; <CJK>
       (?$(0C^(B . "0x83C1") ;; <CJK>
       (?$(0C_(B . "0x83EF") ;; <CJK>
       (?$(0C`(B . "0x83F1") ;; <CJK>
       (?$(0Ca(B . "0x83F4") ;; <CJK>
       (?$(0Cb(B . "0x8457") ;; <CJK>
       (?$(0Cc(B . "0x840A") ;; <CJK>
       (?$(0Cd(B . "0x83F0") ;; <CJK>
       (?$(0Ce(B . "0x840C") ;; <CJK>
       (?$(0Cf(B . "0x83CC") ;; <CJK>
       (?$(0Cg(B . "0x83FD") ;; <CJK>
       (?$(0Ch(B . "0x83F2") ;; <CJK>
       (?$(0Ci(B . "0x83CA") ;; <CJK>
       (?$(0Cj(B . "0x8438") ;; <CJK>
       (?$(0Ck(B . "0x840E") ;; <CJK>
       (?$(0Cl(B . "0x8404") ;; <CJK>
       (?$(0Cm(B . "0x83DC") ;; <CJK>
       (?$(0Cn(B . "0x8407") ;; <CJK>
       (?$(0Co(B . "0x83D4") ;; <CJK>
       (?$(0Cp(B . "0x83DF") ;; <CJK>
       (?$(0Cq(B . "0x865B") ;; <CJK>
       (?$(0Cr(B . "0x86DF") ;; <CJK>
       (?$(0Cs(B . "0x86D9") ;; <CJK>
       (?$(0Ct(B . "0x86ED") ;; <CJK>
       (?$(0Cu(B . "0x86D4") ;; <CJK>
       (?$(0Cv(B . "0x86DB") ;; <CJK>
       (?$(0Cw(B . "0x86E4") ;; <CJK>
       (?$(0Cx(B . "0x86D0") ;; <CJK>
       (?$(0Cy(B . "0x86DE") ;; <CJK>
       (?$(0Cz(B . "0x8857") ;; <CJK>
       (?$(0C{(B . "0x88C1") ;; <CJK>
       (?$(0C|(B . "0x88C2") ;; <CJK>
       (?$(0C}(B . "0x88B1") ;; <CJK>
       (?$(0C~(B . "0x8983") ;; <CJK>
       (?$(0D!(B . "0x8996") ;; <CJK>
       (?$(0D"(B . "0x8A3B") ;; <CJK>
       (?$(0D#(B . "0x8A60") ;; <CJK>
       (?$(0D$(B . "0x8A55") ;; <CJK>
       (?$(0D%(B . "0x8A5E") ;; <CJK>
       (?$(0D&(B . "0x8A3C") ;; <CJK>
       (?$(0D'(B . "0x8A41") ;; <CJK>
       (?$(0D((B . "0x8A54") ;; <CJK>
       (?$(0D)(B . "0x8A5B") ;; <CJK>
       (?$(0D*(B . "0x8A50") ;; <CJK>
       (?$(0D+(B . "0x8A46") ;; <CJK>
       (?$(0D,(B . "0x8A34") ;; <CJK>
       (?$(0D-(B . "0x8A3A") ;; <CJK>
       (?$(0D.(B . "0x8A36") ;; <CJK>
       (?$(0D/(B . "0x8A56") ;; <CJK>
       (?$(0D0(B . "0x8C61") ;; <CJK>
       (?$(0D1(B . "0x8C82") ;; <CJK>
       (?$(0D2(B . "0x8CAF") ;; <CJK>
       (?$(0D3(B . "0x8CBC") ;; <CJK>
       (?$(0D4(B . "0x8CB3") ;; <CJK>
       (?$(0D5(B . "0x8CBD") ;; <CJK>
       (?$(0D6(B . "0x8CC1") ;; <CJK>
       (?$(0D7(B . "0x8CBB") ;; <CJK>
       (?$(0D8(B . "0x8CC0") ;; <CJK>
       (?$(0D9(B . "0x8CB4") ;; <CJK>
       (?$(0D:(B . "0x8CB7") ;; <CJK>
       (?$(0D;(B . "0x8CB6") ;; <CJK>
       (?$(0D<(B . "0x8CBF") ;; <CJK>
       (?$(0D=(B . "0x8CB8") ;; <CJK>
       (?$(0D>(B . "0x8D8A") ;; <CJK>
       (?$(0D?(B . "0x8D85") ;; <CJK>
       (?$(0D@(B . "0x8D81") ;; <CJK>
       (?$(0DA(B . "0x8DCE") ;; <CJK>
       (?$(0DB(B . "0x8DDD") ;; <CJK>
       (?$(0DC(B . "0x8DCB") ;; <CJK>
       (?$(0DD(B . "0x8DDA") ;; <CJK>
       (?$(0DE(B . "0x8DD1") ;; <CJK>
       (?$(0DF(B . "0x8DCC") ;; <CJK>
       (?$(0DG(B . "0x8DDB") ;; <CJK>
       (?$(0DH(B . "0x8DC6") ;; <CJK>
       (?$(0DI(B . "0x8EFB") ;; <CJK>
       (?$(0DJ(B . "0x8EF8") ;; <CJK>
       (?$(0DK(B . "0x8EFC") ;; <CJK>
       (?$(0DL(B . "0x8F9C") ;; <CJK>
       (?$(0DM(B . "0x902E") ;; <CJK>
       (?$(0DN(B . "0x9035") ;; <CJK>
       (?$(0DO(B . "0x9031") ;; <CJK>
       (?$(0DP(B . "0x9038") ;; <CJK>
       (?$(0DQ(B . "0x9032") ;; <CJK>
       (?$(0DR(B . "0x9036") ;; <CJK>
       (?$(0DS(B . "0x9102") ;; <CJK>
       (?$(0DT(B . "0x90F5") ;; <CJK>
       (?$(0DU(B . "0x9109") ;; <CJK>
       (?$(0DV(B . "0x90FE") ;; <CJK>
       (?$(0DW(B . "0x9163") ;; <CJK>
       (?$(0DX(B . "0x9165") ;; <CJK>
       (?$(0DY(B . "0x91CF") ;; <CJK>
       (?$(0DZ(B . "0x9214") ;; <CJK>
       (?$(0D[(B . "0x9215") ;; <CJK>
       (?$(0D\(B . "0x9223") ;; <CJK>
       (?$(0D](B . "0x9209") ;; <CJK>
       (?$(0D^(B . "0x921E") ;; <CJK>
       (?$(0D_(B . "0x920D") ;; <CJK>
       (?$(0D`(B . "0x9210") ;; <CJK>
       (?$(0Da(B . "0x9207") ;; <CJK>
       (?$(0Db(B . "0x9211") ;; <CJK>
       (?$(0Dc(B . "0x9594") ;; <CJK>
       (?$(0Dd(B . "0x958F") ;; <CJK>
       (?$(0De(B . "0x958B") ;; <CJK>
       (?$(0Df(B . "0x9591") ;; <CJK>
       (?$(0Dg(B . "0x9593") ;; <CJK>
       (?$(0Dh(B . "0x9592") ;; <CJK>
       (?$(0Di(B . "0x958E") ;; <CJK>
       (?$(0Dj(B . "0x968A") ;; <CJK>
       (?$(0Dk(B . "0x968E") ;; <CJK>
       (?$(0Dl(B . "0x968B") ;; <CJK>
       (?$(0Dm(B . "0x967D") ;; <CJK>
       (?$(0Dn(B . "0x9685") ;; <CJK>
       (?$(0Do(B . "0x9686") ;; <CJK>
       (?$(0Dp(B . "0x968D") ;; <CJK>
       (?$(0Dq(B . "0x9672") ;; <CJK>
       (?$(0Dr(B . "0x9684") ;; <CJK>
       (?$(0Ds(B . "0x96C1") ;; <CJK>
       (?$(0Dt(B . "0x96C5") ;; <CJK>
       (?$(0Du(B . "0x96C4") ;; <CJK>
       (?$(0Dv(B . "0x96C6") ;; <CJK>
       (?$(0Dw(B . "0x96C7") ;; <CJK>
       (?$(0Dx(B . "0x96EF") ;; <CJK>
       (?$(0Dy(B . "0x96F2") ;; <CJK>
       (?$(0Dz(B . "0x97CC") ;; <CJK>
       (?$(0D{(B . "0x9805") ;; <CJK>
       (?$(0D|(B . "0x9806") ;; <CJK>
       (?$(0D}(B . "0x9808") ;; <CJK>
       (?$(0D~(B . "0x98E7") ;; <CJK>
       (?$(0E!(B . "0x98EA") ;; <CJK>
       (?$(0E"(B . "0x98EF") ;; <CJK>
       (?$(0E#(B . "0x98E9") ;; <CJK>
       (?$(0E$(B . "0x98F2") ;; <CJK>
       (?$(0E%(B . "0x98ED") ;; <CJK>
       (?$(0E&(B . "0x99AE") ;; <CJK>
       (?$(0E'(B . "0x99AD") ;; <CJK>
       (?$(0E((B . "0x9EC3") ;; <CJK>
       (?$(0E)(B . "0x9ECD") ;; <CJK>
       (?$(0E*(B . "0x9ED1") ;; <CJK>
       (?$(0E+(B . "0x4E82") ;; <CJK>
       (?$(0E,(B . "0x50AD") ;; <CJK>
       (?$(0E-(B . "0x50B5") ;; <CJK>
       (?$(0E.(B . "0x50B2") ;; <CJK>
       (?$(0E/(B . "0x50B3") ;; <CJK>
       (?$(0E0(B . "0x50C5") ;; <CJK>
       (?$(0E1(B . "0x50BE") ;; <CJK>
       (?$(0E2(B . "0x50AC") ;; <CJK>
       (?$(0E3(B . "0x50B7") ;; <CJK>
       (?$(0E4(B . "0x50BB") ;; <CJK>
       (?$(0E5(B . "0x50AF") ;; <CJK>
       (?$(0E6(B . "0x50C7") ;; <CJK>
       (?$(0E7(B . "0x527F") ;; <CJK>
       (?$(0E8(B . "0x5277") ;; <CJK>
       (?$(0E9(B . "0x527D") ;; <CJK>
       (?$(0E:(B . "0x52DF") ;; <CJK>
       (?$(0E;(B . "0x52E6") ;; <CJK>
       (?$(0E<(B . "0x52E4") ;; <CJK>
       (?$(0E=(B . "0x52E2") ;; <CJK>
       (?$(0E>(B . "0x52E3") ;; <CJK>
       (?$(0E?(B . "0x532F") ;; <CJK>
       (?$(0E@(B . "0x55DF") ;; <CJK>
       (?$(0EA(B . "0x55E8") ;; <CJK>
       (?$(0EB(B . "0x55D3") ;; <CJK>
       (?$(0EC(B . "0x55E6") ;; <CJK>
       (?$(0ED(B . "0x55CE") ;; <CJK>
       (?$(0EE(B . "0x55DC") ;; <CJK>
       (?$(0EF(B . "0x55C7") ;; <CJK>
       (?$(0EG(B . "0x55D1") ;; <CJK>
       (?$(0EH(B . "0x55E3") ;; <CJK>
       (?$(0EI(B . "0x55E4") ;; <CJK>
       (?$(0EJ(B . "0x55EF") ;; <CJK>
       (?$(0EK(B . "0x55DA") ;; <CJK>
       (?$(0EL(B . "0x55E1") ;; <CJK>
       (?$(0EM(B . "0x55C5") ;; <CJK>
       (?$(0EN(B . "0x55C6") ;; <CJK>
       (?$(0EO(B . "0x55E5") ;; <CJK>
       (?$(0EP(B . "0x55C9") ;; <CJK>
       (?$(0EQ(B . "0x5712") ;; <CJK>
       (?$(0ER(B . "0x5713") ;; <CJK>
       (?$(0ES(B . "0x585E") ;; <CJK>
       (?$(0ET(B . "0x5851") ;; <CJK>
       (?$(0EU(B . "0x5858") ;; <CJK>
       (?$(0EV(B . "0x5857") ;; <CJK>
       (?$(0EW(B . "0x585A") ;; <CJK>
       (?$(0EX(B . "0x5854") ;; <CJK>
       (?$(0EY(B . "0x586B") ;; <CJK>
       (?$(0EZ(B . "0x584C") ;; <CJK>
       (?$(0E[(B . "0x586D") ;; <CJK>
       (?$(0E\(B . "0x584A") ;; <CJK>
       (?$(0E](B . "0x5862") ;; <CJK>
       (?$(0E^(B . "0x5852") ;; <CJK>
       (?$(0E_(B . "0x584B") ;; <CJK>
       (?$(0E`(B . "0x5967") ;; <CJK>
       (?$(0Ea(B . "0x5AC1") ;; <CJK>
       (?$(0Eb(B . "0x5AC9") ;; <CJK>
       (?$(0Ec(B . "0x5ACC") ;; <CJK>
       (?$(0Ed(B . "0x5ABE") ;; <CJK>
       (?$(0Ee(B . "0x5ABD") ;; <CJK>
       (?$(0Ef(B . "0x5ABC") ;; <CJK>
       (?$(0Eg(B . "0x5AB3") ;; <CJK>
       (?$(0Eh(B . "0x5AC2") ;; <CJK>
       (?$(0Ei(B . "0x5AB2") ;; <CJK>
       (?$(0Ej(B . "0x5D69") ;; <CJK>
       (?$(0Ek(B . "0x5D6F") ;; <CJK>
       (?$(0El(B . "0x5E4C") ;; <CJK>
       (?$(0Em(B . "0x5E79") ;; <CJK>
       (?$(0En(B . "0x5EC9") ;; <CJK>
       (?$(0Eo(B . "0x5EC8") ;; <CJK>
       (?$(0Ep(B . "0x5F12") ;; <CJK>
       (?$(0Eq(B . "0x5F59") ;; <CJK>
       (?$(0Er(B . "0x5FAC") ;; <CJK>
       (?$(0Es(B . "0x5FAE") ;; <CJK>
       (?$(0Et(B . "0x611A") ;; <CJK>
       (?$(0Eu(B . "0x610F") ;; <CJK>
       (?$(0Ev(B . "0x6148") ;; <CJK>
       (?$(0Ew(B . "0x611F") ;; <CJK>
       (?$(0Ex(B . "0x60F3") ;; <CJK>
       (?$(0Ey(B . "0x611B") ;; <CJK>
       (?$(0Ez(B . "0x60F9") ;; <CJK>
       (?$(0E{(B . "0x6101") ;; <CJK>
       (?$(0E|(B . "0x6108") ;; <CJK>
       (?$(0E}(B . "0x614E") ;; <CJK>
       (?$(0E~(B . "0x614C") ;; <CJK>
       (?$(0F!(B . "0x6144") ;; <CJK>
       (?$(0F"(B . "0x614D") ;; <CJK>
       (?$(0F#(B . "0x613E") ;; <CJK>
       (?$(0F$(B . "0x6134") ;; <CJK>
       (?$(0F%(B . "0x6127") ;; <CJK>
       (?$(0F&(B . "0x610D") ;; <CJK>
       (?$(0F'(B . "0x6106") ;; <CJK>
       (?$(0F((B . "0x6137") ;; <CJK>
       (?$(0F)(B . "0x6221") ;; <CJK>
       (?$(0F*(B . "0x6222") ;; <CJK>
       (?$(0F+(B . "0x6413") ;; <CJK>
       (?$(0F,(B . "0x643E") ;; <CJK>
       (?$(0F-(B . "0x641E") ;; <CJK>
       (?$(0F.(B . "0x642A") ;; <CJK>
       (?$(0F/(B . "0x642D") ;; <CJK>
       (?$(0F0(B . "0x643D") ;; <CJK>
       (?$(0F1(B . "0x642C") ;; <CJK>
       (?$(0F2(B . "0x640F") ;; <CJK>
       (?$(0F3(B . "0x641C") ;; <CJK>
       (?$(0F4(B . "0x6414") ;; <CJK>
       (?$(0F5(B . "0x640D") ;; <CJK>
       (?$(0F6(B . "0x6436") ;; <CJK>
       (?$(0F7(B . "0x6416") ;; <CJK>
       (?$(0F8(B . "0x6417") ;; <CJK>
       (?$(0F9(B . "0x6406") ;; <CJK>
       (?$(0F:(B . "0x656C") ;; <CJK>
       (?$(0F;(B . "0x659F") ;; <CJK>
       (?$(0F<(B . "0x65B0") ;; <CJK>
       (?$(0F=(B . "0x6697") ;; <CJK>
       (?$(0F>(B . "0x6689") ;; <CJK>
       (?$(0F?(B . "0x6687") ;; <CJK>
       (?$(0F@(B . "0x6688") ;; <CJK>
       (?$(0FA(B . "0x6696") ;; <CJK>
       (?$(0FB(B . "0x6684") ;; <CJK>
       (?$(0FC(B . "0x6698") ;; <CJK>
       (?$(0FD(B . "0x668D") ;; <CJK>
       (?$(0FE(B . "0x6703") ;; <CJK>
       (?$(0FF(B . "0x6994") ;; <CJK>
       (?$(0FG(B . "0x696D") ;; <CJK>
       (?$(0FH(B . "0x695A") ;; <CJK>
       (?$(0FI(B . "0x6977") ;; <CJK>
       (?$(0FJ(B . "0x6960") ;; <CJK>
       (?$(0FK(B . "0x6954") ;; <CJK>
       (?$(0FL(B . "0x6975") ;; <CJK>
       (?$(0FM(B . "0x6930") ;; <CJK>
       (?$(0FN(B . "0x6982") ;; <CJK>
       (?$(0FO(B . "0x694A") ;; <CJK>
       (?$(0FP(B . "0x6968") ;; <CJK>
       (?$(0FQ(B . "0x696B") ;; <CJK>
       (?$(0FR(B . "0x695E") ;; <CJK>
       (?$(0FS(B . "0x6953") ;; <CJK>
       (?$(0FT(B . "0x6979") ;; <CJK>
       (?$(0FU(B . "0x6986") ;; <CJK>
       (?$(0FV(B . "0x695D") ;; <CJK>
       (?$(0FW(B . "0x6963") ;; <CJK>
       (?$(0FX(B . "0x695B") ;; <CJK>
       (?$(0FY(B . "0x6B47") ;; <CJK>
       (?$(0FZ(B . "0x6B72") ;; <CJK>
       (?$(0F[(B . "0x6BC0") ;; <CJK>
       (?$(0F\(B . "0x6BBF") ;; <CJK>
       (?$(0F](B . "0x6BD3") ;; <CJK>
       (?$(0F^(B . "0x6BFD") ;; <CJK>
       (?$(0F_(B . "0x6EA2") ;; <CJK>
       (?$(0F`(B . "0x6EAF") ;; <CJK>
       (?$(0Fa(B . "0x6ED3") ;; <CJK>
       (?$(0Fb(B . "0x6EB6") ;; <CJK>
       (?$(0Fc(B . "0x6EC2") ;; <CJK>
       (?$(0Fd(B . "0x6E90") ;; <CJK>
       (?$(0Fe(B . "0x6E9D") ;; <CJK>
       (?$(0Ff(B . "0x6EC7") ;; <CJK>
       (?$(0Fg(B . "0x6EC5") ;; <CJK>
       (?$(0Fh(B . "0x6EA5") ;; <CJK>
       (?$(0Fi(B . "0x6E98") ;; <CJK>
       (?$(0Fj(B . "0x6EBC") ;; <CJK>
       (?$(0Fk(B . "0x6EBA") ;; <CJK>
       (?$(0Fl(B . "0x6EAB") ;; <CJK>
       (?$(0Fm(B . "0x6ED1") ;; <CJK>
       (?$(0Fn(B . "0x6E96") ;; <CJK>
       (?$(0Fo(B . "0x6E9C") ;; <CJK>
       (?$(0Fp(B . "0x6EC4") ;; <CJK>
       (?$(0Fq(B . "0x6ED4") ;; <CJK>
       (?$(0Fr(B . "0x6EAA") ;; <CJK>
       (?$(0Fs(B . "0x6EA7") ;; <CJK>
       (?$(0Ft(B . "0x6EB4") ;; <CJK>
       (?$(0Fu(B . "0x714E") ;; <CJK>
       (?$(0Fv(B . "0x7159") ;; <CJK>
       (?$(0Fw(B . "0x7169") ;; <CJK>
       (?$(0Fx(B . "0x7164") ;; <CJK>
       (?$(0Fy(B . "0x7149") ;; <CJK>
       (?$(0Fz(B . "0x7167") ;; <CJK>
       (?$(0F{(B . "0x715C") ;; <CJK>
       (?$(0F|(B . "0x716C") ;; <CJK>
       (?$(0F}(B . "0x7166") ;; <CJK>
       (?$(0F~(B . "0x714C") ;; <CJK>
       (?$(0G!(B . "0x7165") ;; <CJK>
       (?$(0G"(B . "0x715E") ;; <CJK>
       (?$(0G#(B . "0x7146") ;; <CJK>
       (?$(0G$(B . "0x7168") ;; <CJK>
       (?$(0G%(B . "0x7156") ;; <CJK>
       (?$(0G&(B . "0x723A") ;; <CJK>
       (?$(0G'(B . "0x7252") ;; <CJK>
       (?$(0G((B . "0x7337") ;; <CJK>
       (?$(0G)(B . "0x7345") ;; <CJK>
       (?$(0G*(B . "0x733F") ;; <CJK>
       (?$(0G+(B . "0x733E") ;; <CJK>
       (?$(0G,(B . "0x746F") ;; <CJK>
       (?$(0G-(B . "0x745A") ;; <CJK>
       (?$(0G.(B . "0x7455") ;; <CJK>
       (?$(0G/(B . "0x745F") ;; <CJK>
       (?$(0G0(B . "0x745E") ;; <CJK>
       (?$(0G1(B . "0x7441") ;; <CJK>
       (?$(0G2(B . "0x743F") ;; <CJK>
       (?$(0G3(B . "0x7459") ;; <CJK>
       (?$(0G4(B . "0x745B") ;; <CJK>
       (?$(0G5(B . "0x745C") ;; <CJK>
       (?$(0G6(B . "0x7576") ;; <CJK>
       (?$(0G7(B . "0x7578") ;; <CJK>
       (?$(0G8(B . "0x7600") ;; <CJK>
       (?$(0G9(B . "0x75F0") ;; <CJK>
       (?$(0G:(B . "0x7601") ;; <CJK>
       (?$(0G;(B . "0x75F2") ;; <CJK>
       (?$(0G<(B . "0x75F1") ;; <CJK>
       (?$(0G=(B . "0x75FA") ;; <CJK>
       (?$(0G>(B . "0x75FF") ;; <CJK>
       (?$(0G?(B . "0x75F4") ;; <CJK>
       (?$(0G@(B . "0x75F3") ;; <CJK>
       (?$(0GA(B . "0x76DE") ;; <CJK>
       (?$(0GB(B . "0x76DF") ;; <CJK>
       (?$(0GC(B . "0x775B") ;; <CJK>
       (?$(0GD(B . "0x776B") ;; <CJK>
       (?$(0GE(B . "0x7766") ;; <CJK>
       (?$(0GF(B . "0x775E") ;; <CJK>
       (?$(0GG(B . "0x7763") ;; <CJK>
       (?$(0GH(B . "0x7779") ;; <CJK>
       (?$(0GI(B . "0x776A") ;; <CJK>
       (?$(0GJ(B . "0x776C") ;; <CJK>
       (?$(0GK(B . "0x775C") ;; <CJK>
       (?$(0GL(B . "0x7765") ;; <CJK>
       (?$(0GM(B . "0x7768") ;; <CJK>
       (?$(0GN(B . "0x7762") ;; <CJK>
       (?$(0GO(B . "0x77EE") ;; <CJK>
       (?$(0GP(B . "0x788E") ;; <CJK>
       (?$(0GQ(B . "0x78B0") ;; <CJK>
       (?$(0GR(B . "0x7897") ;; <CJK>
       (?$(0GS(B . "0x7898") ;; <CJK>
       (?$(0GT(B . "0x788C") ;; <CJK>
       (?$(0GU(B . "0x7889") ;; <CJK>
       (?$(0GV(B . "0x787C") ;; <CJK>
       (?$(0GW(B . "0x7891") ;; <CJK>
       (?$(0GX(B . "0x7893") ;; <CJK>
       (?$(0GY(B . "0x787F") ;; <CJK>
       (?$(0GZ(B . "0x797A") ;; <CJK>
       (?$(0G[(B . "0x797F") ;; <CJK>
       (?$(0G\(B . "0x7981") ;; <CJK>
       (?$(0G](B . "0x842C") ;; <CJK>
       (?$(0G^(B . "0x79BD") ;; <CJK>
       (?$(0G_(B . "0x7A1C") ;; <CJK>
       (?$(0G`(B . "0x7A1A") ;; <CJK>
       (?$(0Ga(B . "0x7A20") ;; <CJK>
       (?$(0Gb(B . "0x7A14") ;; <CJK>
       (?$(0Gc(B . "0x7A1F") ;; <CJK>
       (?$(0Gd(B . "0x7A1E") ;; <CJK>
       (?$(0Ge(B . "0x7A9F") ;; <CJK>
       (?$(0Gf(B . "0x7AA0") ;; <CJK>
       (?$(0Gg(B . "0x7B77") ;; <CJK>
       (?$(0Gh(B . "0x7BC0") ;; <CJK>
       (?$(0Gi(B . "0x7B60") ;; <CJK>
       (?$(0Gj(B . "0x7B6E") ;; <CJK>
       (?$(0Gk(B . "0x7B67") ;; <CJK>
       (?$(0Gl(B . "0x7CB1") ;; <CJK>
       (?$(0Gm(B . "0x7CB3") ;; <CJK>
       (?$(0Gn(B . "0x7CB5") ;; <CJK>
       (?$(0Go(B . "0x7D93") ;; <CJK>
       (?$(0Gp(B . "0x7D79") ;; <CJK>
       (?$(0Gq(B . "0x7D91") ;; <CJK>
       (?$(0Gr(B . "0x7D81") ;; <CJK>
       (?$(0Gs(B . "0x7D8F") ;; <CJK>
       (?$(0Gt(B . "0x7D5B") ;; <CJK>
       (?$(0Gu(B . "0x7F6E") ;; <CJK>
       (?$(0Gv(B . "0x7F69") ;; <CJK>
       (?$(0Gw(B . "0x7F6A") ;; <CJK>
       (?$(0Gx(B . "0x7F72") ;; <CJK>
       (?$(0Gy(B . "0x7FA9") ;; <CJK>
       (?$(0Gz(B . "0x7FA8") ;; <CJK>
       (?$(0G{(B . "0x7FA4") ;; <CJK>
       (?$(0G|(B . "0x8056") ;; <CJK>
       (?$(0G}(B . "0x8058") ;; <CJK>
       (?$(0G~(B . "0x8086") ;; <CJK>
       (?$(0H!(B . "0x8084") ;; <CJK>
       (?$(0H"(B . "0x8171") ;; <CJK>
       (?$(0H#(B . "0x8170") ;; <CJK>
       (?$(0H$(B . "0x8178") ;; <CJK>
       (?$(0H%(B . "0x8165") ;; <CJK>
       (?$(0H&(B . "0x816E") ;; <CJK>
       (?$(0H'(B . "0x8173") ;; <CJK>
       (?$(0H((B . "0x816B") ;; <CJK>
       (?$(0H)(B . "0x8179") ;; <CJK>
       (?$(0H*(B . "0x817A") ;; <CJK>
       (?$(0H+(B . "0x8166") ;; <CJK>
       (?$(0H,(B . "0x8205") ;; <CJK>
       (?$(0H-(B . "0x8247") ;; <CJK>
       (?$(0H.(B . "0x8482") ;; <CJK>
       (?$(0H/(B . "0x8477") ;; <CJK>
       (?$(0H0(B . "0x843D") ;; <CJK>
       (?$(0H1(B . "0x8431") ;; <CJK>
       (?$(0H2(B . "0x8475") ;; <CJK>
       (?$(0H3(B . "0x8466") ;; <CJK>
       (?$(0H4(B . "0x846B") ;; <CJK>
       (?$(0H5(B . "0x8449") ;; <CJK>
       (?$(0H6(B . "0x846C") ;; <CJK>
       (?$(0H7(B . "0x845B") ;; <CJK>
       (?$(0H8(B . "0x843C") ;; <CJK>
       (?$(0H9(B . "0x8435") ;; <CJK>
       (?$(0H:(B . "0x8461") ;; <CJK>
       (?$(0H;(B . "0x8463") ;; <CJK>
       (?$(0H<(B . "0x8469") ;; <CJK>
       (?$(0H=(B . "0x846D") ;; <CJK>
       (?$(0H>(B . "0x8446") ;; <CJK>
       (?$(0H?(B . "0x865E") ;; <CJK>
       (?$(0H@(B . "0x865C") ;; <CJK>
       (?$(0HA(B . "0x865F") ;; <CJK>
       (?$(0HB(B . "0x86F9") ;; <CJK>
       (?$(0HC(B . "0x8713") ;; <CJK>
       (?$(0HD(B . "0x8708") ;; <CJK>
       (?$(0HE(B . "0x8707") ;; <CJK>
       (?$(0HF(B . "0x8700") ;; <CJK>
       (?$(0HG(B . "0x86FE") ;; <CJK>
       (?$(0HH(B . "0x86FB") ;; <CJK>
       (?$(0HI(B . "0x8702") ;; <CJK>
       (?$(0HJ(B . "0x8703") ;; <CJK>
       (?$(0HK(B . "0x8706") ;; <CJK>
       (?$(0HL(B . "0x870A") ;; <CJK>
       (?$(0HM(B . "0x8859") ;; <CJK>
       (?$(0HN(B . "0x88DF") ;; <CJK>
       (?$(0HO(B . "0x88D4") ;; <CJK>
       (?$(0HP(B . "0x88D9") ;; <CJK>
       (?$(0HQ(B . "0x88DC") ;; <CJK>
       (?$(0HR(B . "0x88D8") ;; <CJK>
       (?$(0HS(B . "0x88DD") ;; <CJK>
       (?$(0HT(B . "0x88E1") ;; <CJK>
       (?$(0HU(B . "0x88CA") ;; <CJK>
       (?$(0HV(B . "0x88D5") ;; <CJK>
       (?$(0HW(B . "0x88D2") ;; <CJK>
       (?$(0HX(B . "0x899C") ;; <CJK>
       (?$(0HY(B . "0x89E3") ;; <CJK>
       (?$(0HZ(B . "0x8A6B") ;; <CJK>
       (?$(0H[(B . "0x8A72") ;; <CJK>
       (?$(0H\(B . "0x8A73") ;; <CJK>
       (?$(0H](B . "0x8A66") ;; <CJK>
       (?$(0H^(B . "0x8A69") ;; <CJK>
       (?$(0H_(B . "0x8A70") ;; <CJK>
       (?$(0H`(B . "0x8A87") ;; <CJK>
       (?$(0Ha(B . "0x8A7C") ;; <CJK>
       (?$(0Hb(B . "0x8A63") ;; <CJK>
       (?$(0Hc(B . "0x8AA0") ;; <CJK>
       (?$(0Hd(B . "0x8A71") ;; <CJK>
       (?$(0He(B . "0x8A85") ;; <CJK>
       (?$(0Hf(B . "0x8A6D") ;; <CJK>
       (?$(0Hg(B . "0x8A62") ;; <CJK>
       (?$(0Hh(B . "0x8A6E") ;; <CJK>
       (?$(0Hi(B . "0x8A6C") ;; <CJK>
       (?$(0Hj(B . "0x8A79") ;; <CJK>
       (?$(0Hk(B . "0x8A7B") ;; <CJK>
       (?$(0Hl(B . "0x8A3E") ;; <CJK>
       (?$(0Hm(B . "0x8A68") ;; <CJK>
       (?$(0Hn(B . "0x8C62") ;; <CJK>
       (?$(0Ho(B . "0x8C8A") ;; <CJK>
       (?$(0Hp(B . "0x8C89") ;; <CJK>
       (?$(0Hq(B . "0x8CCA") ;; <CJK>
       (?$(0Hr(B . "0x8CC7") ;; <CJK>
       (?$(0Hs(B . "0x8CC8") ;; <CJK>
       (?$(0Ht(B . "0x8CC4") ;; <CJK>
       (?$(0Hu(B . "0x8CB2") ;; <CJK>
       (?$(0Hv(B . "0x8CC3") ;; <CJK>
       (?$(0Hw(B . "0x8CC2") ;; <CJK>
       (?$(0Hx(B . "0x8CC5") ;; <CJK>
       (?$(0Hy(B . "0x8DE1") ;; <CJK>
       (?$(0Hz(B . "0x8DDF") ;; <CJK>
       (?$(0H{(B . "0x8DE8") ;; <CJK>
       (?$(0H|(B . "0x8DEF") ;; <CJK>
       (?$(0H}(B . "0x8DF3") ;; <CJK>
       (?$(0H~(B . "0x8DFA") ;; <CJK>
       (?$(0I!(B . "0x8DEA") ;; <CJK>
       (?$(0I"(B . "0x8DE4") ;; <CJK>
       (?$(0I#(B . "0x8DE6") ;; <CJK>
       (?$(0I$(B . "0x8EB2") ;; <CJK>
       (?$(0I%(B . "0x8F03") ;; <CJK>
       (?$(0I&(B . "0x8F09") ;; <CJK>
       (?$(0I'(B . "0x8EFE") ;; <CJK>
       (?$(0I((B . "0x8F0A") ;; <CJK>
       (?$(0I)(B . "0x8F9F") ;; <CJK>
       (?$(0I*(B . "0x8FB2") ;; <CJK>
       (?$(0I+(B . "0x904B") ;; <CJK>
       (?$(0I,(B . "0x904A") ;; <CJK>
       (?$(0I-(B . "0x9053") ;; <CJK>
       (?$(0I.(B . "0x9042") ;; <CJK>
       (?$(0I/(B . "0x9054") ;; <CJK>
       (?$(0I0(B . "0x903C") ;; <CJK>
       (?$(0I1(B . "0x9055") ;; <CJK>
       (?$(0I2(B . "0x9050") ;; <CJK>
       (?$(0I3(B . "0x9047") ;; <CJK>
       (?$(0I4(B . "0x904F") ;; <CJK>
       (?$(0I5(B . "0x904E") ;; <CJK>
       (?$(0I6(B . "0x904D") ;; <CJK>
       (?$(0I7(B . "0x9051") ;; <CJK>
       (?$(0I8(B . "0x903E") ;; <CJK>
       (?$(0I9(B . "0x9041") ;; <CJK>
       (?$(0I:(B . "0x9112") ;; <CJK>
       (?$(0I;(B . "0x9117") ;; <CJK>
       (?$(0I<(B . "0x916C") ;; <CJK>
       (?$(0I=(B . "0x916A") ;; <CJK>
       (?$(0I>(B . "0x9169") ;; <CJK>
       (?$(0I?(B . "0x91C9") ;; <CJK>
       (?$(0I@(B . "0x9237") ;; <CJK>
       (?$(0IA(B . "0x9257") ;; <CJK>
       (?$(0IB(B . "0x9238") ;; <CJK>
       (?$(0IC(B . "0x923D") ;; <CJK>
       (?$(0ID(B . "0x9240") ;; <CJK>
       (?$(0IE(B . "0x923E") ;; <CJK>
       (?$(0IF(B . "0x925B") ;; <CJK>
       (?$(0IG(B . "0x924B") ;; <CJK>
       (?$(0IH(B . "0x9264") ;; <CJK>
       (?$(0II(B . "0x9251") ;; <CJK>
       (?$(0IJ(B . "0x9234") ;; <CJK>
       (?$(0IK(B . "0x9249") ;; <CJK>
       (?$(0IL(B . "0x924D") ;; <CJK>
       (?$(0IM(B . "0x9245") ;; <CJK>
       (?$(0IN(B . "0x9239") ;; <CJK>
       (?$(0IO(B . "0x923F") ;; <CJK>
       (?$(0IP(B . "0x925A") ;; <CJK>
       (?$(0IQ(B . "0x9598") ;; <CJK>
       (?$(0IR(B . "0x9698") ;; <CJK>
       (?$(0IS(B . "0x9694") ;; <CJK>
       (?$(0IT(B . "0x9695") ;; <CJK>
       (?$(0IU(B . "0x96CD") ;; <CJK>
       (?$(0IV(B . "0x96CB") ;; <CJK>
       (?$(0IW(B . "0x96C9") ;; <CJK>
       (?$(0IX(B . "0x96CA") ;; <CJK>
       (?$(0IY(B . "0x96F7") ;; <CJK>
       (?$(0IZ(B . "0x96FB") ;; <CJK>
       (?$(0I[(B . "0x96F9") ;; <CJK>
       (?$(0I\(B . "0x96F6") ;; <CJK>
       (?$(0I](B . "0x9756") ;; <CJK>
       (?$(0I^(B . "0x9774") ;; <CJK>
       (?$(0I_(B . "0x9776") ;; <CJK>
       (?$(0I`(B . "0x9810") ;; <CJK>
       (?$(0Ia(B . "0x9811") ;; <CJK>
       (?$(0Ib(B . "0x9813") ;; <CJK>
       (?$(0Ic(B . "0x980A") ;; <CJK>
       (?$(0Id(B . "0x9812") ;; <CJK>
       (?$(0Ie(B . "0x980C") ;; <CJK>
       (?$(0If(B . "0x98FC") ;; <CJK>
       (?$(0Ig(B . "0x98F4") ;; <CJK>
       (?$(0Ih(B . "0x98FD") ;; <CJK>
       (?$(0Ii(B . "0x98FE") ;; <CJK>
       (?$(0Ij(B . "0x99B3") ;; <CJK>
       (?$(0Ik(B . "0x99B1") ;; <CJK>
       (?$(0Il(B . "0x99B4") ;; <CJK>
       (?$(0Im(B . "0x9AE1") ;; <CJK>
       (?$(0In(B . "0x9CE9") ;; <CJK>
       (?$(0Io(B . "0x9E82") ;; <CJK>
       (?$(0Ip(B . "0x9F0E") ;; <CJK>
       (?$(0Iq(B . "0x9F13") ;; <CJK>
       (?$(0Ir(B . "0x9F20") ;; <CJK>
       (?$(0Is(B . "0x50E7") ;; <CJK>
       (?$(0It(B . "0x50EE") ;; <CJK>
       (?$(0Iu(B . "0x50E5") ;; <CJK>
       (?$(0Iv(B . "0x50D6") ;; <CJK>
       (?$(0Iw(B . "0x50ED") ;; <CJK>
       (?$(0Ix(B . "0x50DA") ;; <CJK>
       (?$(0Iy(B . "0x50D5") ;; <CJK>
       (?$(0Iz(B . "0x50CF") ;; <CJK>
       (?$(0I{(B . "0x50D1") ;; <CJK>
       (?$(0I|(B . "0x50F1") ;; <CJK>
       (?$(0I}(B . "0x50CE") ;; <CJK>
       (?$(0I~(B . "0x50E9") ;; <CJK>
       (?$(0J!(B . "0x5162") ;; <CJK>
       (?$(0J"(B . "0x51F3") ;; <CJK>
       (?$(0J#(B . "0x5283") ;; <CJK>
       (?$(0J$(B . "0x5282") ;; <CJK>
       (?$(0J%(B . "0x5331") ;; <CJK>
       (?$(0J&(B . "0x53AD") ;; <CJK>
       (?$(0J'(B . "0x55FE") ;; <CJK>
       (?$(0J((B . "0x5600") ;; <CJK>
       (?$(0J)(B . "0x561B") ;; <CJK>
       (?$(0J*(B . "0x5617") ;; <CJK>
       (?$(0J+(B . "0x55FD") ;; <CJK>
       (?$(0J,(B . "0x5614") ;; <CJK>
       (?$(0J-(B . "0x5606") ;; <CJK>
       (?$(0J.(B . "0x5609") ;; <CJK>
       (?$(0J/(B . "0x560D") ;; <CJK>
       (?$(0J0(B . "0x560E") ;; <CJK>
       (?$(0J1(B . "0x55F7") ;; <CJK>
       (?$(0J2(B . "0x5616") ;; <CJK>
       (?$(0J3(B . "0x561F") ;; <CJK>
       (?$(0J4(B . "0x5608") ;; <CJK>
       (?$(0J5(B . "0x5610") ;; <CJK>
       (?$(0J6(B . "0x55F6") ;; <CJK>
       (?$(0J7(B . "0x5718") ;; <CJK>
       (?$(0J8(B . "0x5716") ;; <CJK>
       (?$(0J9(B . "0x5875") ;; <CJK>
       (?$(0J:(B . "0x587E") ;; <CJK>
       (?$(0J;(B . "0x5883") ;; <CJK>
       (?$(0J<(B . "0x5893") ;; <CJK>
       (?$(0J=(B . "0x588A") ;; <CJK>
       (?$(0J>(B . "0x5879") ;; <CJK>
       (?$(0J?(B . "0x5885") ;; <CJK>
       (?$(0J@(B . "0x587D") ;; <CJK>
       (?$(0JA(B . "0x58FD") ;; <CJK>
       (?$(0JB(B . "0x5925") ;; <CJK>
       (?$(0JC(B . "0x5922") ;; <CJK>
       (?$(0JD(B . "0x5924") ;; <CJK>
       (?$(0JE(B . "0x596A") ;; <CJK>
       (?$(0JF(B . "0x5969") ;; <CJK>
       (?$(0JG(B . "0x5AE1") ;; <CJK>
       (?$(0JH(B . "0x5AE6") ;; <CJK>
       (?$(0JI(B . "0x5AE9") ;; <CJK>
       (?$(0JJ(B . "0x5AD7") ;; <CJK>
       (?$(0JK(B . "0x5AD6") ;; <CJK>
       (?$(0JL(B . "0x5AD8") ;; <CJK>
       (?$(0JM(B . "0x5AE3") ;; <CJK>
       (?$(0JN(B . "0x5B75") ;; <CJK>
       (?$(0JO(B . "0x5BDE") ;; <CJK>
       (?$(0JP(B . "0x5BE7") ;; <CJK>
       (?$(0JQ(B . "0x5BE1") ;; <CJK>
       (?$(0JR(B . "0x5BE5") ;; <CJK>
       (?$(0JS(B . "0x5BE6") ;; <CJK>
       (?$(0JT(B . "0x5BE8") ;; <CJK>
       (?$(0JU(B . "0x5BE2") ;; <CJK>
       (?$(0JV(B . "0x5BE4") ;; <CJK>
       (?$(0JW(B . "0x5BDF") ;; <CJK>
       (?$(0JX(B . "0x5C0D") ;; <CJK>
       (?$(0JY(B . "0x5C62") ;; <CJK>
       (?$(0JZ(B . "0x5D84") ;; <CJK>
       (?$(0J[(B . "0x5D87") ;; <CJK>
       (?$(0J\(B . "0x5E5B") ;; <CJK>
       (?$(0J](B . "0x5E63") ;; <CJK>
       (?$(0J^(B . "0x5E55") ;; <CJK>
       (?$(0J_(B . "0x5E57") ;; <CJK>
       (?$(0J`(B . "0x5E54") ;; <CJK>
       (?$(0Ja(B . "0x5ED3") ;; <CJK>
       (?$(0Jb(B . "0x5ED6") ;; <CJK>
       (?$(0Jc(B . "0x5F0A") ;; <CJK>
       (?$(0Jd(B . "0x5F46") ;; <CJK>
       (?$(0Je(B . "0x5F70") ;; <CJK>
       (?$(0Jf(B . "0x5FB9") ;; <CJK>
       (?$(0Jg(B . "0x6147") ;; <CJK>
       (?$(0Jh(B . "0x613F") ;; <CJK>
       (?$(0Ji(B . "0x614B") ;; <CJK>
       (?$(0Jj(B . "0x6177") ;; <CJK>
       (?$(0Jk(B . "0x6162") ;; <CJK>
       (?$(0Jl(B . "0x6163") ;; <CJK>
       (?$(0Jm(B . "0x615F") ;; <CJK>
       (?$(0Jn(B . "0x615A") ;; <CJK>
       (?$(0Jo(B . "0x6158") ;; <CJK>
       (?$(0Jp(B . "0x6175") ;; <CJK>
       (?$(0Jq(B . "0x622A") ;; <CJK>
       (?$(0Jr(B . "0x6487") ;; <CJK>
       (?$(0Js(B . "0x6458") ;; <CJK>
       (?$(0Jt(B . "0x6454") ;; <CJK>
       (?$(0Ju(B . "0x64A4") ;; <CJK>
       (?$(0Jv(B . "0x6478") ;; <CJK>
       (?$(0Jw(B . "0x645F") ;; <CJK>
       (?$(0Jx(B . "0x647A") ;; <CJK>
       (?$(0Jy(B . "0x6451") ;; <CJK>
       (?$(0Jz(B . "0x6467") ;; <CJK>
       (?$(0J{(B . "0x6434") ;; <CJK>
       (?$(0J|(B . "0x646D") ;; <CJK>
       (?$(0J}(B . "0x647B") ;; <CJK>
       (?$(0J~(B . "0x6572") ;; <CJK>
       (?$(0K!(B . "0x65A1") ;; <CJK>
       (?$(0K"(B . "0x65D7") ;; <CJK>
       (?$(0K#(B . "0x65D6") ;; <CJK>
       (?$(0K$(B . "0x66A2") ;; <CJK>
       (?$(0K%(B . "0x66A8") ;; <CJK>
       (?$(0K&(B . "0x669D") ;; <CJK>
       (?$(0K'(B . "0x699C") ;; <CJK>
       (?$(0K((B . "0x69A8") ;; <CJK>
       (?$(0K)(B . "0x6995") ;; <CJK>
       (?$(0K*(B . "0x69C1") ;; <CJK>
       (?$(0K+(B . "0x69AE") ;; <CJK>
       (?$(0K,(B . "0x69D3") ;; <CJK>
       (?$(0K-(B . "0x69CB") ;; <CJK>
       (?$(0K.(B . "0x699B") ;; <CJK>
       (?$(0K/(B . "0x69B7") ;; <CJK>
       (?$(0K0(B . "0x69BB") ;; <CJK>
       (?$(0K1(B . "0x69AB") ;; <CJK>
       (?$(0K2(B . "0x69B4") ;; <CJK>
       (?$(0K3(B . "0x69D0") ;; <CJK>
       (?$(0K4(B . "0x69CD") ;; <CJK>
       (?$(0K5(B . "0x69AD") ;; <CJK>
       (?$(0K6(B . "0x69CC") ;; <CJK>
       (?$(0K7(B . "0x69A6") ;; <CJK>
       (?$(0K8(B . "0x69C3") ;; <CJK>
       (?$(0K9(B . "0x69A3") ;; <CJK>
       (?$(0K:(B . "0x6B49") ;; <CJK>
       (?$(0K;(B . "0x6B4C") ;; <CJK>
       (?$(0K<(B . "0x6C33") ;; <CJK>
       (?$(0K=(B . "0x6F33") ;; <CJK>
       (?$(0K>(B . "0x6F14") ;; <CJK>
       (?$(0K?(B . "0x6EFE") ;; <CJK>
       (?$(0K@(B . "0x6F13") ;; <CJK>
       (?$(0KA(B . "0x6EF4") ;; <CJK>
       (?$(0KB(B . "0x6F29") ;; <CJK>
       (?$(0KC(B . "0x6F3E") ;; <CJK>
       (?$(0KD(B . "0x6F20") ;; <CJK>
       (?$(0KE(B . "0x6F2C") ;; <CJK>
       (?$(0KF(B . "0x6F0F") ;; <CJK>
       (?$(0KG(B . "0x6F02") ;; <CJK>
       (?$(0KH(B . "0x6F22") ;; <CJK>
       (?$(0KI(B . "0x6EFF") ;; <CJK>
       (?$(0KJ(B . "0x6EEF") ;; <CJK>
       (?$(0KK(B . "0x6F06") ;; <CJK>
       (?$(0KL(B . "0x6F31") ;; <CJK>
       (?$(0KM(B . "0x6F38") ;; <CJK>
       (?$(0KN(B . "0x6F32") ;; <CJK>
       (?$(0KO(B . "0x6F23") ;; <CJK>
       (?$(0KP(B . "0x6F15") ;; <CJK>
       (?$(0KQ(B . "0x6F2B") ;; <CJK>
       (?$(0KR(B . "0x6F2F") ;; <CJK>
       (?$(0KS(B . "0x6F88") ;; <CJK>
       (?$(0KT(B . "0x6F2A") ;; <CJK>
       (?$(0KU(B . "0x6EEC") ;; <CJK>
       (?$(0KV(B . "0x6F01") ;; <CJK>
       (?$(0KW(B . "0x6EF2") ;; <CJK>
       (?$(0KX(B . "0x6ECC") ;; <CJK>
       (?$(0KY(B . "0x6EF7") ;; <CJK>
       (?$(0KZ(B . "0x7194") ;; <CJK>
       (?$(0K[(B . "0x7199") ;; <CJK>
       (?$(0K\(B . "0x717D") ;; <CJK>
       (?$(0K](B . "0x718A") ;; <CJK>
       (?$(0K^(B . "0x7184") ;; <CJK>
       (?$(0K_(B . "0x7192") ;; <CJK>
       (?$(0K`(B . "0x723E") ;; <CJK>
       (?$(0Ka(B . "0x7292") ;; <CJK>
       (?$(0Kb(B . "0x7296") ;; <CJK>
       (?$(0Kc(B . "0x7344") ;; <CJK>
       (?$(0Kd(B . "0x7350") ;; <CJK>
       (?$(0Ke(B . "0x7464") ;; <CJK>
       (?$(0Kf(B . "0x7463") ;; <CJK>
       (?$(0Kg(B . "0x746A") ;; <CJK>
       (?$(0Kh(B . "0x7470") ;; <CJK>
       (?$(0Ki(B . "0x746D") ;; <CJK>
       (?$(0Kj(B . "0x7504") ;; <CJK>
       (?$(0Kk(B . "0x7591") ;; <CJK>
       (?$(0Kl(B . "0x7627") ;; <CJK>
       (?$(0Km(B . "0x760D") ;; <CJK>
       (?$(0Kn(B . "0x760B") ;; <CJK>
       (?$(0Ko(B . "0x7609") ;; <CJK>
       (?$(0Kp(B . "0x7613") ;; <CJK>
       (?$(0Kq(B . "0x76E1") ;; <CJK>
       (?$(0Kr(B . "0x76E3") ;; <CJK>
       (?$(0Ks(B . "0x7784") ;; <CJK>
       (?$(0Kt(B . "0x777D") ;; <CJK>
       (?$(0Ku(B . "0x777F") ;; <CJK>
       (?$(0Kv(B . "0x7761") ;; <CJK>
       (?$(0Kw(B . "0x78C1") ;; <CJK>
       (?$(0Kx(B . "0x789F") ;; <CJK>
       (?$(0Ky(B . "0x78A7") ;; <CJK>
       (?$(0Kz(B . "0x78B3") ;; <CJK>
       (?$(0K{(B . "0x78A9") ;; <CJK>
       (?$(0K|(B . "0x78A3") ;; <CJK>
       (?$(0K}(B . "0x798E") ;; <CJK>
       (?$(0K~(B . "0x798F") ;; <CJK>
       (?$(0L!(B . "0x798D") ;; <CJK>
       (?$(0L"(B . "0x7A2E") ;; <CJK>
       (?$(0L#(B . "0x7A31") ;; <CJK>
       (?$(0L$(B . "0x7AAA") ;; <CJK>
       (?$(0L%(B . "0x7AA9") ;; <CJK>
       (?$(0L&(B . "0x7AED") ;; <CJK>
       (?$(0L'(B . "0x7AEF") ;; <CJK>
       (?$(0L((B . "0x7BA1") ;; <CJK>
       (?$(0L)(B . "0x7B95") ;; <CJK>
       (?$(0L*(B . "0x7B8B") ;; <CJK>
       (?$(0L+(B . "0x7B75") ;; <CJK>
       (?$(0L,(B . "0x7B97") ;; <CJK>
       (?$(0L-(B . "0x7B9D") ;; <CJK>
       (?$(0L.(B . "0x7B94") ;; <CJK>
       (?$(0L/(B . "0x7B8F") ;; <CJK>
       (?$(0L0(B . "0x7BB8") ;; <CJK>
       (?$(0L1(B . "0x7B87") ;; <CJK>
       (?$(0L2(B . "0x7B84") ;; <CJK>
       (?$(0L3(B . "0x7CB9") ;; <CJK>
       (?$(0L4(B . "0x7CBD") ;; <CJK>
       (?$(0L5(B . "0x7CBE") ;; <CJK>
       (?$(0L6(B . "0x7DBB") ;; <CJK>
       (?$(0L7(B . "0x7DB0") ;; <CJK>
       (?$(0L8(B . "0x7D9C") ;; <CJK>
       (?$(0L9(B . "0x7DBD") ;; <CJK>
       (?$(0L:(B . "0x7DBE") ;; <CJK>
       (?$(0L;(B . "0x7DA0") ;; <CJK>
       (?$(0L<(B . "0x7DCA") ;; <CJK>
       (?$(0L=(B . "0x7DB4") ;; <CJK>
       (?$(0L>(B . "0x7DB2") ;; <CJK>
       (?$(0L?(B . "0x7DB1") ;; <CJK>
       (?$(0L@(B . "0x7DBA") ;; <CJK>
       (?$(0LA(B . "0x7DA2") ;; <CJK>
       (?$(0LB(B . "0x7DBF") ;; <CJK>
       (?$(0LC(B . "0x7DB5") ;; <CJK>
       (?$(0LD(B . "0x7DB8") ;; <CJK>
       (?$(0LE(B . "0x7DAD") ;; <CJK>
       (?$(0LF(B . "0x7DD2") ;; <CJK>
       (?$(0LG(B . "0x7DC7") ;; <CJK>
       (?$(0LH(B . "0x7DAC") ;; <CJK>
       (?$(0LI(B . "0x7F70") ;; <CJK>
       (?$(0LJ(B . "0x7FE0") ;; <CJK>
       (?$(0LK(B . "0x7FE1") ;; <CJK>
       (?$(0LL(B . "0x7FDF") ;; <CJK>
       (?$(0LM(B . "0x805E") ;; <CJK>
       (?$(0LN(B . "0x805A") ;; <CJK>
       (?$(0LO(B . "0x8087") ;; <CJK>
       (?$(0LP(B . "0x8150") ;; <CJK>
       (?$(0LQ(B . "0x8180") ;; <CJK>
       (?$(0LR(B . "0x818F") ;; <CJK>
       (?$(0LS(B . "0x8188") ;; <CJK>
       (?$(0LT(B . "0x818A") ;; <CJK>
       (?$(0LU(B . "0x817F") ;; <CJK>
       (?$(0LV(B . "0x8182") ;; <CJK>
       (?$(0LW(B . "0x81E7") ;; <CJK>
       (?$(0LX(B . "0x81FA") ;; <CJK>
       (?$(0LY(B . "0x8207") ;; <CJK>
       (?$(0LZ(B . "0x8214") ;; <CJK>
       (?$(0L[(B . "0x821E") ;; <CJK>
       (?$(0L\(B . "0x824B") ;; <CJK>
       (?$(0L](B . "0x84C9") ;; <CJK>
       (?$(0L^(B . "0x84BF") ;; <CJK>
       (?$(0L_(B . "0x84C6") ;; <CJK>
       (?$(0L`(B . "0x84C4") ;; <CJK>
       (?$(0La(B . "0x8499") ;; <CJK>
       (?$(0Lb(B . "0x849E") ;; <CJK>
       (?$(0Lc(B . "0x84B2") ;; <CJK>
       (?$(0Ld(B . "0x849C") ;; <CJK>
       (?$(0Le(B . "0x84CB") ;; <CJK>
       (?$(0Lf(B . "0x84B8") ;; <CJK>
       (?$(0Lg(B . "0x84C0") ;; <CJK>
       (?$(0Lh(B . "0x84D3") ;; <CJK>
       (?$(0Li(B . "0x8490") ;; <CJK>
       (?$(0Lj(B . "0x84BC") ;; <CJK>
       (?$(0Lk(B . "0x84D1") ;; <CJK>
       (?$(0Ll(B . "0x84CA") ;; <CJK>
       (?$(0Lm(B . "0x873F") ;; <CJK>
       (?$(0Ln(B . "0x871C") ;; <CJK>
       (?$(0Lo(B . "0x873B") ;; <CJK>
       (?$(0Lp(B . "0x8722") ;; <CJK>
       (?$(0Lq(B . "0x8725") ;; <CJK>
       (?$(0Lr(B . "0x8734") ;; <CJK>
       (?$(0Ls(B . "0x8718") ;; <CJK>
       (?$(0Lt(B . "0x8755") ;; <CJK>
       (?$(0Lu(B . "0x8737") ;; <CJK>
       (?$(0Lv(B . "0x8729") ;; <CJK>
       (?$(0Lw(B . "0x88F3") ;; <CJK>
       (?$(0Lx(B . "0x8902") ;; <CJK>
       (?$(0Ly(B . "0x88F4") ;; <CJK>
       (?$(0Lz(B . "0x88F9") ;; <CJK>
       (?$(0L{(B . "0x88F8") ;; <CJK>
       (?$(0L|(B . "0x88FD") ;; <CJK>
       (?$(0L}(B . "0x88E8") ;; <CJK>
       (?$(0L~(B . "0x891A") ;; <CJK>
       (?$(0M!(B . "0x88EF") ;; <CJK>
       (?$(0M"(B . "0x8AA6") ;; <CJK>
       (?$(0M#(B . "0x8A8C") ;; <CJK>
       (?$(0M$(B . "0x8A9E") ;; <CJK>
       (?$(0M%(B . "0x8AA3") ;; <CJK>
       (?$(0M&(B . "0x8A8D") ;; <CJK>
       (?$(0M'(B . "0x8AA1") ;; <CJK>
       (?$(0M((B . "0x8A93") ;; <CJK>
       (?$(0M)(B . "0x8AA4") ;; <CJK>
       (?$(0M*(B . "0x8AAA") ;; <CJK>
       (?$(0M+(B . "0x8AA5") ;; <CJK>
       (?$(0M,(B . "0x8AA8") ;; <CJK>
       (?$(0M-(B . "0x8A98") ;; <CJK>
       (?$(0M.(B . "0x8A91") ;; <CJK>
       (?$(0M/(B . "0x8A9A") ;; <CJK>
       (?$(0M0(B . "0x8AA7") ;; <CJK>
       (?$(0M1(B . "0x8C6A") ;; <CJK>
       (?$(0M2(B . "0x8C8D") ;; <CJK>
       (?$(0M3(B . "0x8C8C") ;; <CJK>
       (?$(0M4(B . "0x8CD3") ;; <CJK>
       (?$(0M5(B . "0x8CD1") ;; <CJK>
       (?$(0M6(B . "0x8CD2") ;; <CJK>
       (?$(0M7(B . "0x8D6B") ;; <CJK>
       (?$(0M8(B . "0x8D99") ;; <CJK>
       (?$(0M9(B . "0x8D95") ;; <CJK>
       (?$(0M:(B . "0x8DFC") ;; <CJK>
       (?$(0M;(B . "0x8F14") ;; <CJK>
       (?$(0M<(B . "0x8F12") ;; <CJK>
       (?$(0M=(B . "0x8F15") ;; <CJK>
       (?$(0M>(B . "0x8F13") ;; <CJK>
       (?$(0M?(B . "0x8FA3") ;; <CJK>
       (?$(0M@(B . "0x9060") ;; <CJK>
       (?$(0MA(B . "0x9058") ;; <CJK>
       (?$(0MB(B . "0x905C") ;; <CJK>
       (?$(0MC(B . "0x9063") ;; <CJK>
       (?$(0MD(B . "0x9059") ;; <CJK>
       (?$(0ME(B . "0x905E") ;; <CJK>
       (?$(0MF(B . "0x9062") ;; <CJK>
       (?$(0MG(B . "0x905D") ;; <CJK>
       (?$(0MH(B . "0x905B") ;; <CJK>
       (?$(0MI(B . "0x9119") ;; <CJK>
       (?$(0MJ(B . "0x9118") ;; <CJK>
       (?$(0MK(B . "0x911E") ;; <CJK>
       (?$(0ML(B . "0x9175") ;; <CJK>
       (?$(0MM(B . "0x9178") ;; <CJK>
       (?$(0MN(B . "0x9177") ;; <CJK>
       (?$(0MO(B . "0x9174") ;; <CJK>
       (?$(0MP(B . "0x9278") ;; <CJK>
       (?$(0MQ(B . "0x9280") ;; <CJK>
       (?$(0MR(B . "0x9285") ;; <CJK>
       (?$(0MS(B . "0x9298") ;; <CJK>
       (?$(0MT(B . "0x9296") ;; <CJK>
       (?$(0MU(B . "0x927B") ;; <CJK>
       (?$(0MV(B . "0x9293") ;; <CJK>
       (?$(0MW(B . "0x929C") ;; <CJK>
       (?$(0MX(B . "0x92A8") ;; <CJK>
       (?$(0MY(B . "0x927C") ;; <CJK>
       (?$(0MZ(B . "0x9291") ;; <CJK>
       (?$(0M[(B . "0x95A1") ;; <CJK>
       (?$(0M\(B . "0x95A8") ;; <CJK>
       (?$(0M](B . "0x95A9") ;; <CJK>
       (?$(0M^(B . "0x95A3") ;; <CJK>
       (?$(0M_(B . "0x95A5") ;; <CJK>
       (?$(0M`(B . "0x95A4") ;; <CJK>
       (?$(0Ma(B . "0x9699") ;; <CJK>
       (?$(0Mb(B . "0x969C") ;; <CJK>
       (?$(0Mc(B . "0x969B") ;; <CJK>
       (?$(0Md(B . "0x96CC") ;; <CJK>
       (?$(0Me(B . "0x96D2") ;; <CJK>
       (?$(0Mf(B . "0x9700") ;; <CJK>
       (?$(0Mg(B . "0x977C") ;; <CJK>
       (?$(0Mh(B . "0x9785") ;; <CJK>
       (?$(0Mi(B . "0x97F6") ;; <CJK>
       (?$(0Mj(B . "0x9817") ;; <CJK>
       (?$(0Mk(B . "0x9818") ;; <CJK>
       (?$(0Ml(B . "0x98AF") ;; <CJK>
       (?$(0Mm(B . "0x98B1") ;; <CJK>
       (?$(0Mn(B . "0x9903") ;; <CJK>
       (?$(0Mo(B . "0x9905") ;; <CJK>
       (?$(0Mp(B . "0x990C") ;; <CJK>
       (?$(0Mq(B . "0x9909") ;; <CJK>
       (?$(0Mr(B . "0x99C1") ;; <CJK>
       (?$(0Ms(B . "0x9AAF") ;; <CJK>
       (?$(0Mt(B . "0x9AB0") ;; <CJK>
       (?$(0Mu(B . "0x9AE6") ;; <CJK>
       (?$(0Mv(B . "0x9B41") ;; <CJK>
       (?$(0Mw(B . "0x9B42") ;; <CJK>
       (?$(0Mx(B . "0x9CF4") ;; <CJK>
       (?$(0My(B . "0x9CF6") ;; <CJK>
       (?$(0Mz(B . "0x9CF3") ;; <CJK>
       (?$(0M{(B . "0x9EBC") ;; <CJK>
       (?$(0M|(B . "0x9F3B") ;; <CJK>
       (?$(0M}(B . "0x9F4A") ;; <CJK>
       (?$(0M~(B . "0x5104") ;; <CJK>
       (?$(0N!(B . "0x5100") ;; <CJK>
       (?$(0N"(B . "0x50FB") ;; <CJK>
       (?$(0N#(B . "0x50F5") ;; <CJK>
       (?$(0N$(B . "0x50F9") ;; <CJK>
       (?$(0N%(B . "0x5102") ;; <CJK>
       (?$(0N&(B . "0x5108") ;; <CJK>
       (?$(0N'(B . "0x5109") ;; <CJK>
       (?$(0N((B . "0x5105") ;; <CJK>
       (?$(0N)(B . "0x51DC") ;; <CJK>
       (?$(0N*(B . "0x5287") ;; <CJK>
       (?$(0N+(B . "0x5288") ;; <CJK>
       (?$(0N,(B . "0x5289") ;; <CJK>
       (?$(0N-(B . "0x528D") ;; <CJK>
       (?$(0N.(B . "0x528A") ;; <CJK>
       (?$(0N/(B . "0x52F0") ;; <CJK>
       (?$(0N0(B . "0x53B2") ;; <CJK>
       (?$(0N1(B . "0x562E") ;; <CJK>
       (?$(0N2(B . "0x563B") ;; <CJK>
       (?$(0N3(B . "0x5639") ;; <CJK>
       (?$(0N4(B . "0x5632") ;; <CJK>
       (?$(0N5(B . "0x563F") ;; <CJK>
       (?$(0N6(B . "0x5634") ;; <CJK>
       (?$(0N7(B . "0x5629") ;; <CJK>
       (?$(0N8(B . "0x5653") ;; <CJK>
       (?$(0N9(B . "0x564E") ;; <CJK>
       (?$(0N:(B . "0x5657") ;; <CJK>
       (?$(0N;(B . "0x5674") ;; <CJK>
       (?$(0N<(B . "0x5636") ;; <CJK>
       (?$(0N=(B . "0x562F") ;; <CJK>
       (?$(0N>(B . "0x5630") ;; <CJK>
       (?$(0N?(B . "0x5880") ;; <CJK>
       (?$(0N@(B . "0x589F") ;; <CJK>
       (?$(0NA(B . "0x589E") ;; <CJK>
       (?$(0NB(B . "0x58B3") ;; <CJK>
       (?$(0NC(B . "0x589C") ;; <CJK>
       (?$(0ND(B . "0x58AE") ;; <CJK>
       (?$(0NE(B . "0x58A9") ;; <CJK>
       (?$(0NF(B . "0x58A6") ;; <CJK>
       (?$(0NG(B . "0x596D") ;; <CJK>
       (?$(0NH(B . "0x5B09") ;; <CJK>
       (?$(0NI(B . "0x5AFB") ;; <CJK>
       (?$(0NJ(B . "0x5B0B") ;; <CJK>
       (?$(0NK(B . "0x5AF5") ;; <CJK>
       (?$(0NL(B . "0x5B0C") ;; <CJK>
       (?$(0NM(B . "0x5B08") ;; <CJK>
       (?$(0NN(B . "0x5BEE") ;; <CJK>
       (?$(0NO(B . "0x5BEC") ;; <CJK>
       (?$(0NP(B . "0x5BE9") ;; <CJK>
       (?$(0NQ(B . "0x5BEB") ;; <CJK>
       (?$(0NR(B . "0x5C64") ;; <CJK>
       (?$(0NS(B . "0x5C65") ;; <CJK>
       (?$(0NT(B . "0x5D9D") ;; <CJK>
       (?$(0NU(B . "0x5D94") ;; <CJK>
       (?$(0NV(B . "0x5E62") ;; <CJK>
       (?$(0NW(B . "0x5E5F") ;; <CJK>
       (?$(0NX(B . "0x5E61") ;; <CJK>
       (?$(0NY(B . "0x5EE2") ;; <CJK>
       (?$(0NZ(B . "0x5EDA") ;; <CJK>
       (?$(0N[(B . "0x5EDF") ;; <CJK>
       (?$(0N\(B . "0x5EDD") ;; <CJK>
       (?$(0N](B . "0x5EE3") ;; <CJK>
       (?$(0N^(B . "0x5EE0") ;; <CJK>
       (?$(0N_(B . "0x5F48") ;; <CJK>
       (?$(0N`(B . "0x5F71") ;; <CJK>
       (?$(0Na(B . "0x5FB7") ;; <CJK>
       (?$(0Nb(B . "0x5FB5") ;; <CJK>
       (?$(0Nc(B . "0x6176") ;; <CJK>
       (?$(0Nd(B . "0x6167") ;; <CJK>
       (?$(0Ne(B . "0x616E") ;; <CJK>
       (?$(0Nf(B . "0x615D") ;; <CJK>
       (?$(0Ng(B . "0x6155") ;; <CJK>
       (?$(0Nh(B . "0x6182") ;; <CJK>
       (?$(0Ni(B . "0x617C") ;; <CJK>
       (?$(0Nj(B . "0x6170") ;; <CJK>
       (?$(0Nk(B . "0x616B") ;; <CJK>
       (?$(0Nl(B . "0x617E") ;; <CJK>
       (?$(0Nm(B . "0x61A7") ;; <CJK>
       (?$(0Nn(B . "0x6190") ;; <CJK>
       (?$(0No(B . "0x61AB") ;; <CJK>
       (?$(0Np(B . "0x618E") ;; <CJK>
       (?$(0Nq(B . "0x61AC") ;; <CJK>
       (?$(0Nr(B . "0x619A") ;; <CJK>
       (?$(0Ns(B . "0x61A4") ;; <CJK>
       (?$(0Nt(B . "0x6194") ;; <CJK>
       (?$(0Nu(B . "0x61AE") ;; <CJK>
       (?$(0Nv(B . "0x622E") ;; <CJK>
       (?$(0Nw(B . "0x6469") ;; <CJK>
       (?$(0Nx(B . "0x646F") ;; <CJK>
       (?$(0Ny(B . "0x6479") ;; <CJK>
       (?$(0Nz(B . "0x649E") ;; <CJK>
       (?$(0N{(B . "0x64B2") ;; <CJK>
       (?$(0N|(B . "0x6488") ;; <CJK>
       (?$(0N}(B . "0x6490") ;; <CJK>
       (?$(0N~(B . "0x64B0") ;; <CJK>
       (?$(0O!(B . "0x64A5") ;; <CJK>
       (?$(0O"(B . "0x6493") ;; <CJK>
       (?$(0O#(B . "0x6495") ;; <CJK>
       (?$(0O$(B . "0x64A9") ;; <CJK>
       (?$(0O%(B . "0x6492") ;; <CJK>
       (?$(0O&(B . "0x64AE") ;; <CJK>
       (?$(0O'(B . "0x64AD") ;; <CJK>
       (?$(0O((B . "0x64AB") ;; <CJK>
       (?$(0O)(B . "0x649A") ;; <CJK>
       (?$(0O*(B . "0x64AC") ;; <CJK>
       (?$(0O+(B . "0x6499") ;; <CJK>
       (?$(0O,(B . "0x64A2") ;; <CJK>
       (?$(0O-(B . "0x64B3") ;; <CJK>
       (?$(0O.(B . "0x6575") ;; <CJK>
       (?$(0O/(B . "0x6577") ;; <CJK>
       (?$(0O0(B . "0x6578") ;; <CJK>
       (?$(0O1(B . "0x66AE") ;; <CJK>
       (?$(0O2(B . "0x66AB") ;; <CJK>
       (?$(0O3(B . "0x66B4") ;; <CJK>
       (?$(0O4(B . "0x66B1") ;; <CJK>
       (?$(0O5(B . "0x6A23") ;; <CJK>
       (?$(0O6(B . "0x6A1F") ;; <CJK>
       (?$(0O7(B . "0x69E8") ;; <CJK>
       (?$(0O8(B . "0x6A01") ;; <CJK>
       (?$(0O9(B . "0x6A1E") ;; <CJK>
       (?$(0O:(B . "0x6A19") ;; <CJK>
       (?$(0O;(B . "0x69FD") ;; <CJK>
       (?$(0O<(B . "0x6A21") ;; <CJK>
       (?$(0O=(B . "0x6A13") ;; <CJK>
       (?$(0O>(B . "0x6A0A") ;; <CJK>
       (?$(0O?(B . "0x69F3") ;; <CJK>
       (?$(0O@(B . "0x6A02") ;; <CJK>
       (?$(0OA(B . "0x6A05") ;; <CJK>
       (?$(0OB(B . "0x69ED") ;; <CJK>
       (?$(0OC(B . "0x6A11") ;; <CJK>
       (?$(0OD(B . "0x6B50") ;; <CJK>
       (?$(0OE(B . "0x6B4E") ;; <CJK>
       (?$(0OF(B . "0x6BA4") ;; <CJK>
       (?$(0OG(B . "0x6BC5") ;; <CJK>
       (?$(0OH(B . "0x6BC6") ;; <CJK>
       (?$(0OI(B . "0x6F3F") ;; <CJK>
       (?$(0OJ(B . "0x6F7C") ;; <CJK>
       (?$(0OK(B . "0x6F84") ;; <CJK>
       (?$(0OL(B . "0x6F51") ;; <CJK>
       (?$(0OM(B . "0x6F66") ;; <CJK>
       (?$(0ON(B . "0x6F54") ;; <CJK>
       (?$(0OO(B . "0x6F86") ;; <CJK>
       (?$(0OP(B . "0x6F6D") ;; <CJK>
       (?$(0OQ(B . "0x6F5B") ;; <CJK>
       (?$(0OR(B . "0x6F78") ;; <CJK>
       (?$(0OS(B . "0x6F6E") ;; <CJK>
       (?$(0OT(B . "0x6F8E") ;; <CJK>
       (?$(0OU(B . "0x6F7A") ;; <CJK>
       (?$(0OV(B . "0x6F70") ;; <CJK>
       (?$(0OW(B . "0x6F64") ;; <CJK>
       (?$(0OX(B . "0x6F97") ;; <CJK>
       (?$(0OY(B . "0x6F58") ;; <CJK>
       (?$(0OZ(B . "0x6ED5") ;; <CJK>
       (?$(0O[(B . "0x6F6F") ;; <CJK>
       (?$(0O\(B . "0x6F60") ;; <CJK>
       (?$(0O](B . "0x6F5F") ;; <CJK>
       (?$(0O^(B . "0x719F") ;; <CJK>
       (?$(0O_(B . "0x71AC") ;; <CJK>
       (?$(0O`(B . "0x71B1") ;; <CJK>
       (?$(0Oa(B . "0x71A8") ;; <CJK>
       (?$(0Ob(B . "0x7256") ;; <CJK>
       (?$(0Oc(B . "0x729B") ;; <CJK>
       (?$(0Od(B . "0x734E") ;; <CJK>
       (?$(0Oe(B . "0x7357") ;; <CJK>
       (?$(0Of(B . "0x7469") ;; <CJK>
       (?$(0Og(B . "0x748B") ;; <CJK>
       (?$(0Oh(B . "0x7483") ;; <CJK>
       (?$(0Oi(B . "0x747E") ;; <CJK>
       (?$(0Oj(B . "0x7480") ;; <CJK>
       (?$(0Ok(B . "0x757F") ;; <CJK>
       (?$(0Ol(B . "0x7620") ;; <CJK>
       (?$(0Om(B . "0x7629") ;; <CJK>
       (?$(0On(B . "0x761F") ;; <CJK>
       (?$(0Oo(B . "0x7624") ;; <CJK>
       (?$(0Op(B . "0x7626") ;; <CJK>
       (?$(0Oq(B . "0x7621") ;; <CJK>
       (?$(0Or(B . "0x7622") ;; <CJK>
       (?$(0Os(B . "0x769A") ;; <CJK>
       (?$(0Ot(B . "0x76BA") ;; <CJK>
       (?$(0Ou(B . "0x76E4") ;; <CJK>
       (?$(0Ov(B . "0x778E") ;; <CJK>
       (?$(0Ow(B . "0x7787") ;; <CJK>
       (?$(0Ox(B . "0x778C") ;; <CJK>
       (?$(0Oy(B . "0x7791") ;; <CJK>
       (?$(0Oz(B . "0x778B") ;; <CJK>
       (?$(0O{(B . "0x78CB") ;; <CJK>
       (?$(0O|(B . "0x78C5") ;; <CJK>
       (?$(0O}(B . "0x78BA") ;; <CJK>
       (?$(0O~(B . "0x78CA") ;; <CJK>
       (?$(0P!(B . "0x78BE") ;; <CJK>
       (?$(0P"(B . "0x78D5") ;; <CJK>
       (?$(0P#(B . "0x78BC") ;; <CJK>
       (?$(0P$(B . "0x78D0") ;; <CJK>
       (?$(0P%(B . "0x7A3F") ;; <CJK>
       (?$(0P&(B . "0x7A3C") ;; <CJK>
       (?$(0P'(B . "0x7A40") ;; <CJK>
       (?$(0P((B . "0x7A3D") ;; <CJK>
       (?$(0P)(B . "0x7A37") ;; <CJK>
       (?$(0P*(B . "0x7A3B") ;; <CJK>
       (?$(0P+(B . "0x7AAF") ;; <CJK>
       (?$(0P,(B . "0x7AAE") ;; <CJK>
       (?$(0P-(B . "0x7BAD") ;; <CJK>
       (?$(0P.(B . "0x7BB1") ;; <CJK>
       (?$(0P/(B . "0x7BC4") ;; <CJK>
       (?$(0P0(B . "0x7BB4") ;; <CJK>
       (?$(0P1(B . "0x7BC6") ;; <CJK>
       (?$(0P2(B . "0x7BC7") ;; <CJK>
       (?$(0P3(B . "0x7BC1") ;; <CJK>
       (?$(0P4(B . "0x7BA0") ;; <CJK>
       (?$(0P5(B . "0x7BCC") ;; <CJK>
       (?$(0P6(B . "0x7CCA") ;; <CJK>
       (?$(0P7(B . "0x7DE0") ;; <CJK>
       (?$(0P8(B . "0x7DF4") ;; <CJK>
       (?$(0P9(B . "0x7DEF") ;; <CJK>
       (?$(0P:(B . "0x7DFB") ;; <CJK>
       (?$(0P;(B . "0x7DD8") ;; <CJK>
       (?$(0P<(B . "0x7DEC") ;; <CJK>
       (?$(0P=(B . "0x7DDD") ;; <CJK>
       (?$(0P>(B . "0x7DE8") ;; <CJK>
       (?$(0P?(B . "0x7DE3") ;; <CJK>
       (?$(0P@(B . "0x7DDA") ;; <CJK>
       (?$(0PA(B . "0x7DDE") ;; <CJK>
       (?$(0PB(B . "0x7DE9") ;; <CJK>
       (?$(0PC(B . "0x7D9E") ;; <CJK>
       (?$(0PD(B . "0x7DD9") ;; <CJK>
       (?$(0PE(B . "0x7DF2") ;; <CJK>
       (?$(0PF(B . "0x7DF9") ;; <CJK>
       (?$(0PG(B . "0x7F75") ;; <CJK>
       (?$(0PH(B . "0x7F77") ;; <CJK>
       (?$(0PI(B . "0x7FAF") ;; <CJK>
       (?$(0PJ(B . "0x7FE9") ;; <CJK>
       (?$(0PK(B . "0x8026") ;; <CJK>
       (?$(0PL(B . "0x819B") ;; <CJK>
       (?$(0PM(B . "0x819C") ;; <CJK>
       (?$(0PN(B . "0x819D") ;; <CJK>
       (?$(0PO(B . "0x81A0") ;; <CJK>
       (?$(0PP(B . "0x819A") ;; <CJK>
       (?$(0PQ(B . "0x8198") ;; <CJK>
       (?$(0PR(B . "0x8517") ;; <CJK>
       (?$(0PS(B . "0x853D") ;; <CJK>
       (?$(0PT(B . "0x851A") ;; <CJK>
       (?$(0PU(B . "0x84EE") ;; <CJK>
       (?$(0PV(B . "0x852C") ;; <CJK>
       (?$(0PW(B . "0x852D") ;; <CJK>
       (?$(0PX(B . "0x8513") ;; <CJK>
       (?$(0PY(B . "0x8511") ;; <CJK>
       (?$(0PZ(B . "0x8523") ;; <CJK>
       (?$(0P[(B . "0x8521") ;; <CJK>
       (?$(0P\(B . "0x8514") ;; <CJK>
       (?$(0P](B . "0x84EC") ;; <CJK>
       (?$(0P^(B . "0x8525") ;; <CJK>
       (?$(0P_(B . "0x84FF") ;; <CJK>
       (?$(0P`(B . "0x8506") ;; <CJK>
       (?$(0Pa(B . "0x8782") ;; <CJK>
       (?$(0Pb(B . "0x8774") ;; <CJK>
       (?$(0Pc(B . "0x8776") ;; <CJK>
       (?$(0Pd(B . "0x8760") ;; <CJK>
       (?$(0Pe(B . "0x8766") ;; <CJK>
       (?$(0Pf(B . "0x8778") ;; <CJK>
       (?$(0Pg(B . "0x8768") ;; <CJK>
       (?$(0Ph(B . "0x8759") ;; <CJK>
       (?$(0Pi(B . "0x8757") ;; <CJK>
       (?$(0Pj(B . "0x874C") ;; <CJK>
       (?$(0Pk(B . "0x8753") ;; <CJK>
       (?$(0Pl(B . "0x885B") ;; <CJK>
       (?$(0Pm(B . "0x885D") ;; <CJK>
       (?$(0Pn(B . "0x8910") ;; <CJK>
       (?$(0Po(B . "0x8907") ;; <CJK>
       (?$(0Pp(B . "0x8912") ;; <CJK>
       (?$(0Pq(B . "0x8913") ;; <CJK>
       (?$(0Pr(B . "0x8915") ;; <CJK>
       (?$(0Ps(B . "0x890A") ;; <CJK>
       (?$(0Pt(B . "0x8ABC") ;; <CJK>
       (?$(0Pu(B . "0x8AD2") ;; <CJK>
       (?$(0Pv(B . "0x8AC7") ;; <CJK>
       (?$(0Pw(B . "0x8AC4") ;; <CJK>
       (?$(0Px(B . "0x8A95") ;; <CJK>
       (?$(0Py(B . "0x8ACB") ;; <CJK>
       (?$(0Pz(B . "0x8AF8") ;; <CJK>
       (?$(0P{(B . "0x8AB2") ;; <CJK>
       (?$(0P|(B . "0x8AC9") ;; <CJK>
       (?$(0P}(B . "0x8AC2") ;; <CJK>
       (?$(0P~(B . "0x8ABF") ;; <CJK>
       (?$(0Q!(B . "0x8AB0") ;; <CJK>
       (?$(0Q"(B . "0x8AD6") ;; <CJK>
       (?$(0Q#(B . "0x8ACD") ;; <CJK>
       (?$(0Q$(B . "0x8AB6") ;; <CJK>
       (?$(0Q%(B . "0x8AB9") ;; <CJK>
       (?$(0Q&(B . "0x8ADB") ;; <CJK>
       (?$(0Q'(B . "0x8C4C") ;; <CJK>
       (?$(0Q((B . "0x8C4E") ;; <CJK>
       (?$(0Q)(B . "0x8C6C") ;; <CJK>
       (?$(0Q*(B . "0x8CE0") ;; <CJK>
       (?$(0Q+(B . "0x8CDE") ;; <CJK>
       (?$(0Q,(B . "0x8CE6") ;; <CJK>
       (?$(0Q-(B . "0x8CE4") ;; <CJK>
       (?$(0Q.(B . "0x8CEC") ;; <CJK>
       (?$(0Q/(B . "0x8CED") ;; <CJK>
       (?$(0Q0(B . "0x8CE2") ;; <CJK>
       (?$(0Q1(B . "0x8CE3") ;; <CJK>
       (?$(0Q2(B . "0x8CDC") ;; <CJK>
       (?$(0Q3(B . "0x8CEA") ;; <CJK>
       (?$(0Q4(B . "0x8CE1") ;; <CJK>
       (?$(0Q5(B . "0x8D6D") ;; <CJK>
       (?$(0Q6(B . "0x8D9F") ;; <CJK>
       (?$(0Q7(B . "0x8DA3") ;; <CJK>
       (?$(0Q8(B . "0x8E2B") ;; <CJK>
       (?$(0Q9(B . "0x8E10") ;; <CJK>
       (?$(0Q:(B . "0x8E1D") ;; <CJK>
       (?$(0Q;(B . "0x8E22") ;; <CJK>
       (?$(0Q<(B . "0x8E0F") ;; <CJK>
       (?$(0Q=(B . "0x8E29") ;; <CJK>
       (?$(0Q>(B . "0x8E1F") ;; <CJK>
       (?$(0Q?(B . "0x8E21") ;; <CJK>
       (?$(0Q@(B . "0x8E1E") ;; <CJK>
       (?$(0QA(B . "0x8EBA") ;; <CJK>
       (?$(0QB(B . "0x8F1D") ;; <CJK>
       (?$(0QC(B . "0x8F1B") ;; <CJK>
       (?$(0QD(B . "0x8F1F") ;; <CJK>
       (?$(0QE(B . "0x8F29") ;; <CJK>
       (?$(0QF(B . "0x8F26") ;; <CJK>
       (?$(0QG(B . "0x8F2A") ;; <CJK>
       (?$(0QH(B . "0x8F1C") ;; <CJK>
       (?$(0QI(B . "0x8F1E") ;; <CJK>
       (?$(0QJ(B . "0x8F25") ;; <CJK>
       (?$(0QK(B . "0x9069") ;; <CJK>
       (?$(0QL(B . "0x906E") ;; <CJK>
       (?$(0QM(B . "0x9068") ;; <CJK>
       (?$(0QN(B . "0x906D") ;; <CJK>
       (?$(0QO(B . "0x9077") ;; <CJK>
       (?$(0QP(B . "0x9130") ;; <CJK>
       (?$(0QQ(B . "0x912D") ;; <CJK>
       (?$(0QR(B . "0x9127") ;; <CJK>
       (?$(0QS(B . "0x9131") ;; <CJK>
       (?$(0QT(B . "0x9187") ;; <CJK>
       (?$(0QU(B . "0x9189") ;; <CJK>
       (?$(0QV(B . "0x918B") ;; <CJK>
       (?$(0QW(B . "0x9183") ;; <CJK>
       (?$(0QX(B . "0x92C5") ;; <CJK>
       (?$(0QY(B . "0x92BB") ;; <CJK>
       (?$(0QZ(B . "0x92B7") ;; <CJK>
       (?$(0Q[(B . "0x92EA") ;; <CJK>
       (?$(0Q\(B . "0x92AC") ;; <CJK>
       (?$(0Q](B . "0x92E4") ;; <CJK>
       (?$(0Q^(B . "0x92C1") ;; <CJK>
       (?$(0Q_(B . "0x92B3") ;; <CJK>
       (?$(0Q`(B . "0x92BC") ;; <CJK>
       (?$(0Qa(B . "0x92D2") ;; <CJK>
       (?$(0Qb(B . "0x92C7") ;; <CJK>
       (?$(0Qc(B . "0x92F0") ;; <CJK>
       (?$(0Qd(B . "0x92B2") ;; <CJK>
       (?$(0Qe(B . "0x95AD") ;; <CJK>
       (?$(0Qf(B . "0x95B1") ;; <CJK>
       (?$(0Qg(B . "0x9704") ;; <CJK>
       (?$(0Qh(B . "0x9706") ;; <CJK>
       (?$(0Qi(B . "0x9707") ;; <CJK>
       (?$(0Qj(B . "0x9709") ;; <CJK>
       (?$(0Qk(B . "0x9760") ;; <CJK>
       (?$(0Ql(B . "0x978D") ;; <CJK>
       (?$(0Qm(B . "0x978B") ;; <CJK>
       (?$(0Qn(B . "0x978F") ;; <CJK>
       (?$(0Qo(B . "0x9821") ;; <CJK>
       (?$(0Qp(B . "0x982B") ;; <CJK>
       (?$(0Qq(B . "0x981C") ;; <CJK>
       (?$(0Qr(B . "0x98B3") ;; <CJK>
       (?$(0Qs(B . "0x990A") ;; <CJK>
       (?$(0Qt(B . "0x9913") ;; <CJK>
       (?$(0Qu(B . "0x9912") ;; <CJK>
       (?$(0Qv(B . "0x9918") ;; <CJK>
       (?$(0Qw(B . "0x99DD") ;; <CJK>
       (?$(0Qx(B . "0x99D0") ;; <CJK>
       (?$(0Qy(B . "0x99DF") ;; <CJK>
       (?$(0Qz(B . "0x99DB") ;; <CJK>
       (?$(0Q{(B . "0x99D1") ;; <CJK>
       (?$(0Q|(B . "0x99D5") ;; <CJK>
       (?$(0Q}(B . "0x99D2") ;; <CJK>
       (?$(0Q~(B . "0x99D9") ;; <CJK>
       (?$(0R!(B . "0x9AB7") ;; <CJK>
       (?$(0R"(B . "0x9AEE") ;; <CJK>
       (?$(0R#(B . "0x9AEF") ;; <CJK>
       (?$(0R$(B . "0x9B27") ;; <CJK>
       (?$(0R%(B . "0x9B45") ;; <CJK>
       (?$(0R&(B . "0x9B44") ;; <CJK>
       (?$(0R'(B . "0x9B77") ;; <CJK>
       (?$(0R((B . "0x9B6F") ;; <CJK>
       (?$(0R)(B . "0x9D06") ;; <CJK>
       (?$(0R*(B . "0x9D09") ;; <CJK>
       (?$(0R+(B . "0x9D03") ;; <CJK>
       (?$(0R,(B . "0x9EA9") ;; <CJK>
       (?$(0R-(B . "0x9EBE") ;; <CJK>
       (?$(0R.(B . "0x9ECE") ;; <CJK>
       (?$(0R/(B . "0x58A8") ;; <CJK>
       (?$(0R0(B . "0x9F52") ;; <CJK>
       (?$(0R1(B . "0x5112") ;; <CJK>
       (?$(0R2(B . "0x5118") ;; <CJK>
       (?$(0R3(B . "0x5114") ;; <CJK>
       (?$(0R4(B . "0x5110") ;; <CJK>
       (?$(0R5(B . "0x5115") ;; <CJK>
       (?$(0R6(B . "0x5180") ;; <CJK>
       (?$(0R7(B . "0x51AA") ;; <CJK>
       (?$(0R8(B . "0x51DD") ;; <CJK>
       (?$(0R9(B . "0x5291") ;; <CJK>
       (?$(0R:(B . "0x5293") ;; <CJK>
       (?$(0R;(B . "0x52F3") ;; <CJK>
       (?$(0R<(B . "0x5659") ;; <CJK>
       (?$(0R=(B . "0x566B") ;; <CJK>
       (?$(0R>(B . "0x5679") ;; <CJK>
       (?$(0R?(B . "0x5669") ;; <CJK>
       (?$(0R@(B . "0x5664") ;; <CJK>
       (?$(0RA(B . "0x5678") ;; <CJK>
       (?$(0RB(B . "0x566A") ;; <CJK>
       (?$(0RC(B . "0x5668") ;; <CJK>
       (?$(0RD(B . "0x5665") ;; <CJK>
       (?$(0RE(B . "0x5671") ;; <CJK>
       (?$(0RF(B . "0x566F") ;; <CJK>
       (?$(0RG(B . "0x566C") ;; <CJK>
       (?$(0RH(B . "0x5662") ;; <CJK>
       (?$(0RI(B . "0x5676") ;; <CJK>
       (?$(0RJ(B . "0x58C1") ;; <CJK>
       (?$(0RK(B . "0x58BE") ;; <CJK>
       (?$(0RL(B . "0x58C7") ;; <CJK>
       (?$(0RM(B . "0x58C5") ;; <CJK>
       (?$(0RN(B . "0x596E") ;; <CJK>
       (?$(0RO(B . "0x5B1D") ;; <CJK>
       (?$(0RP(B . "0x5B34") ;; <CJK>
       (?$(0RQ(B . "0x5B78") ;; <CJK>
       (?$(0RR(B . "0x5BF0") ;; <CJK>
       (?$(0RS(B . "0x5C0E") ;; <CJK>
       (?$(0RT(B . "0x5F4A") ;; <CJK>
       (?$(0RU(B . "0x61B2") ;; <CJK>
       (?$(0RV(B . "0x6191") ;; <CJK>
       (?$(0RW(B . "0x61A9") ;; <CJK>
       (?$(0RX(B . "0x618A") ;; <CJK>
       (?$(0RY(B . "0x61CD") ;; <CJK>
       (?$(0RZ(B . "0x61B6") ;; <CJK>
       (?$(0R[(B . "0x61BE") ;; <CJK>
       (?$(0R\(B . "0x61CA") ;; <CJK>
       (?$(0R](B . "0x61C8") ;; <CJK>
       (?$(0R^(B . "0x6230") ;; <CJK>
       (?$(0R_(B . "0x64C5") ;; <CJK>
       (?$(0R`(B . "0x64C1") ;; <CJK>
       (?$(0Ra(B . "0x64CB") ;; <CJK>
       (?$(0Rb(B . "0x64BB") ;; <CJK>
       (?$(0Rc(B . "0x64BC") ;; <CJK>
       (?$(0Rd(B . "0x64DA") ;; <CJK>
       (?$(0Re(B . "0x64C4") ;; <CJK>
       (?$(0Rf(B . "0x64C7") ;; <CJK>
       (?$(0Rg(B . "0x64C2") ;; <CJK>
       (?$(0Rh(B . "0x64CD") ;; <CJK>
       (?$(0Ri(B . "0x64BF") ;; <CJK>
       (?$(0Rj(B . "0x64D2") ;; <CJK>
       (?$(0Rk(B . "0x64D4") ;; <CJK>
       (?$(0Rl(B . "0x64BE") ;; <CJK>
       (?$(0Rm(B . "0x6574") ;; <CJK>
       (?$(0Rn(B . "0x66C6") ;; <CJK>
       (?$(0Ro(B . "0x66C9") ;; <CJK>
       (?$(0Rp(B . "0x66B9") ;; <CJK>
       (?$(0Rq(B . "0x66C4") ;; <CJK>
       (?$(0Rr(B . "0x66C7") ;; <CJK>
       (?$(0Rs(B . "0x66B8") ;; <CJK>
       (?$(0Rt(B . "0x6A3D") ;; <CJK>
       (?$(0Ru(B . "0x6A38") ;; <CJK>
       (?$(0Rv(B . "0x6A3A") ;; <CJK>
       (?$(0Rw(B . "0x6A59") ;; <CJK>
       (?$(0Rx(B . "0x6A6B") ;; <CJK>
       (?$(0Ry(B . "0x6A58") ;; <CJK>
       (?$(0Rz(B . "0x6A39") ;; <CJK>
       (?$(0R{(B . "0x6A44") ;; <CJK>
       (?$(0R|(B . "0x6A62") ;; <CJK>
       (?$(0R}(B . "0x6A61") ;; <CJK>
       (?$(0R~(B . "0x6A4B") ;; <CJK>
       (?$(0S!(B . "0x6A47") ;; <CJK>
       (?$(0S"(B . "0x6A35") ;; <CJK>
       (?$(0S#(B . "0x6A5F") ;; <CJK>
       (?$(0S$(B . "0x6A48") ;; <CJK>
       (?$(0S%(B . "0x6B59") ;; <CJK>
       (?$(0S&(B . "0x6B77") ;; <CJK>
       (?$(0S'(B . "0x6C05") ;; <CJK>
       (?$(0S((B . "0x6FC2") ;; <CJK>
       (?$(0S)(B . "0x6FB1") ;; <CJK>
       (?$(0S*(B . "0x6FA1") ;; <CJK>
       (?$(0S+(B . "0x6FC3") ;; <CJK>
       (?$(0S,(B . "0x6FA4") ;; <CJK>
       (?$(0S-(B . "0x6FC1") ;; <CJK>
       (?$(0S.(B . "0x6FA7") ;; <CJK>
       (?$(0S/(B . "0x6FB3") ;; <CJK>
       (?$(0S0(B . "0x6FC0") ;; <CJK>
       (?$(0S1(B . "0x6FB9") ;; <CJK>
       (?$(0S2(B . "0x6FB6") ;; <CJK>
       (?$(0S3(B . "0x6FA6") ;; <CJK>
       (?$(0S4(B . "0x6FA0") ;; <CJK>
       (?$(0S5(B . "0x6FB4") ;; <CJK>
       (?$(0S6(B . "0x71BE") ;; <CJK>
       (?$(0S7(B . "0x71C9") ;; <CJK>
       (?$(0S8(B . "0x71D0") ;; <CJK>
       (?$(0S9(B . "0x71D2") ;; <CJK>
       (?$(0S:(B . "0x71C8") ;; <CJK>
       (?$(0S;(B . "0x71D5") ;; <CJK>
       (?$(0S<(B . "0x71B9") ;; <CJK>
       (?$(0S=(B . "0x71CE") ;; <CJK>
       (?$(0S>(B . "0x71D9") ;; <CJK>
       (?$(0S?(B . "0x71DC") ;; <CJK>
       (?$(0S@(B . "0x71C3") ;; <CJK>
       (?$(0SA(B . "0x71C4") ;; <CJK>
       (?$(0SB(B . "0x7368") ;; <CJK>
       (?$(0SC(B . "0x749C") ;; <CJK>
       (?$(0SD(B . "0x74A3") ;; <CJK>
       (?$(0SE(B . "0x7498") ;; <CJK>
       (?$(0SF(B . "0x749F") ;; <CJK>
       (?$(0SG(B . "0x749E") ;; <CJK>
       (?$(0SH(B . "0x74E2") ;; <CJK>
       (?$(0SI(B . "0x750C") ;; <CJK>
       (?$(0SJ(B . "0x750D") ;; <CJK>
       (?$(0SK(B . "0x7634") ;; <CJK>
       (?$(0SL(B . "0x7638") ;; <CJK>
       (?$(0SM(B . "0x763A") ;; <CJK>
       (?$(0SN(B . "0x76E7") ;; <CJK>
       (?$(0SO(B . "0x76E5") ;; <CJK>
       (?$(0SP(B . "0x77A0") ;; <CJK>
       (?$(0SQ(B . "0x779E") ;; <CJK>
       (?$(0SR(B . "0x779F") ;; <CJK>
       (?$(0SS(B . "0x77A5") ;; <CJK>
       (?$(0ST(B . "0x78E8") ;; <CJK>
       (?$(0SU(B . "0x78DA") ;; <CJK>
       (?$(0SV(B . "0x78EC") ;; <CJK>
       (?$(0SW(B . "0x78E7") ;; <CJK>
       (?$(0SX(B . "0x79A6") ;; <CJK>
       (?$(0SY(B . "0x7A4D") ;; <CJK>
       (?$(0SZ(B . "0x7A4E") ;; <CJK>
       (?$(0S[(B . "0x7A46") ;; <CJK>
       (?$(0S\(B . "0x7A4C") ;; <CJK>
       (?$(0S](B . "0x7A4B") ;; <CJK>
       (?$(0S^(B . "0x7ABA") ;; <CJK>
       (?$(0S_(B . "0x7BD9") ;; <CJK>
       (?$(0S`(B . "0x7C11") ;; <CJK>
       (?$(0Sa(B . "0x7BC9") ;; <CJK>
       (?$(0Sb(B . "0x7BE4") ;; <CJK>
       (?$(0Sc(B . "0x7BDB") ;; <CJK>
       (?$(0Sd(B . "0x7BE1") ;; <CJK>
       (?$(0Se(B . "0x7BE9") ;; <CJK>
       (?$(0Sf(B . "0x7BE6") ;; <CJK>
       (?$(0Sg(B . "0x7CD5") ;; <CJK>
       (?$(0Sh(B . "0x7CD6") ;; <CJK>
       (?$(0Si(B . "0x7E0A") ;; <CJK>
       (?$(0Sj(B . "0x7E11") ;; <CJK>
       (?$(0Sk(B . "0x7E08") ;; <CJK>
       (?$(0Sl(B . "0x7E1B") ;; <CJK>
       (?$(0Sm(B . "0x7E23") ;; <CJK>
       (?$(0Sn(B . "0x7E1E") ;; <CJK>
       (?$(0So(B . "0x7E1D") ;; <CJK>
       (?$(0Sp(B . "0x7E09") ;; <CJK>
       (?$(0Sq(B . "0x7E10") ;; <CJK>
       (?$(0Sr(B . "0x7F79") ;; <CJK>
       (?$(0Ss(B . "0x7FB2") ;; <CJK>
       (?$(0St(B . "0x7FF0") ;; <CJK>
       (?$(0Su(B . "0x7FF1") ;; <CJK>
       (?$(0Sv(B . "0x7FEE") ;; <CJK>
       (?$(0Sw(B . "0x8028") ;; <CJK>
       (?$(0Sx(B . "0x81B3") ;; <CJK>
       (?$(0Sy(B . "0x81A9") ;; <CJK>
       (?$(0Sz(B . "0x81A8") ;; <CJK>
       (?$(0S{(B . "0x81FB") ;; <CJK>
       (?$(0S|(B . "0x8208") ;; <CJK>
       (?$(0S}(B . "0x8258") ;; <CJK>
       (?$(0S~(B . "0x8259") ;; <CJK>
       (?$(0T!(B . "0x854A") ;; <CJK>
       (?$(0T"(B . "0x8559") ;; <CJK>
       (?$(0T#(B . "0x8548") ;; <CJK>
       (?$(0T$(B . "0x8568") ;; <CJK>
       (?$(0T%(B . "0x8569") ;; <CJK>
       (?$(0T&(B . "0x8543") ;; <CJK>
       (?$(0T'(B . "0x8549") ;; <CJK>
       (?$(0T((B . "0x856D") ;; <CJK>
       (?$(0T)(B . "0x856A") ;; <CJK>
       (?$(0T*(B . "0x855E") ;; <CJK>
       (?$(0T+(B . "0x8783") ;; <CJK>
       (?$(0T,(B . "0x879F") ;; <CJK>
       (?$(0T-(B . "0x879E") ;; <CJK>
       (?$(0T.(B . "0x87A2") ;; <CJK>
       (?$(0T/(B . "0x878D") ;; <CJK>
       (?$(0T0(B . "0x8861") ;; <CJK>
       (?$(0T1(B . "0x892A") ;; <CJK>
       (?$(0T2(B . "0x8932") ;; <CJK>
       (?$(0T3(B . "0x8925") ;; <CJK>
       (?$(0T4(B . "0x892B") ;; <CJK>
       (?$(0T5(B . "0x8921") ;; <CJK>
       (?$(0T6(B . "0x89AA") ;; <CJK>
       (?$(0T7(B . "0x89A6") ;; <CJK>
       (?$(0T8(B . "0x8AE6") ;; <CJK>
       (?$(0T9(B . "0x8AFA") ;; <CJK>
       (?$(0T:(B . "0x8AEB") ;; <CJK>
       (?$(0T;(B . "0x8AF1") ;; <CJK>
       (?$(0T<(B . "0x8B00") ;; <CJK>
       (?$(0T=(B . "0x8ADC") ;; <CJK>
       (?$(0T>(B . "0x8AE7") ;; <CJK>
       (?$(0T?(B . "0x8AEE") ;; <CJK>
       (?$(0T@(B . "0x8AFE") ;; <CJK>
       (?$(0TA(B . "0x8B01") ;; <CJK>
       (?$(0TB(B . "0x8B02") ;; <CJK>
       (?$(0TC(B . "0x8AF7") ;; <CJK>
       (?$(0TD(B . "0x8AED") ;; <CJK>
       (?$(0TE(B . "0x8AF3") ;; <CJK>
       (?$(0TF(B . "0x8AF6") ;; <CJK>
       (?$(0TG(B . "0x8AFC") ;; <CJK>
       (?$(0TH(B . "0x8C6B") ;; <CJK>
       (?$(0TI(B . "0x8C6D") ;; <CJK>
       (?$(0TJ(B . "0x8C93") ;; <CJK>
       (?$(0TK(B . "0x8CF4") ;; <CJK>
       (?$(0TL(B . "0x8E44") ;; <CJK>
       (?$(0TM(B . "0x8E31") ;; <CJK>
       (?$(0TN(B . "0x8E34") ;; <CJK>
       (?$(0TO(B . "0x8E42") ;; <CJK>
       (?$(0TP(B . "0x8E39") ;; <CJK>
       (?$(0TQ(B . "0x8E35") ;; <CJK>
       (?$(0TR(B . "0x8F3B") ;; <CJK>
       (?$(0TS(B . "0x8F2F") ;; <CJK>
       (?$(0TT(B . "0x8F38") ;; <CJK>
       (?$(0TU(B . "0x8F33") ;; <CJK>
       (?$(0TV(B . "0x8FA8") ;; <CJK>
       (?$(0TW(B . "0x8FA6") ;; <CJK>
       (?$(0TX(B . "0x9075") ;; <CJK>
       (?$(0TY(B . "0x9074") ;; <CJK>
       (?$(0TZ(B . "0x9078") ;; <CJK>
       (?$(0T[(B . "0x9072") ;; <CJK>
       (?$(0T\(B . "0x907C") ;; <CJK>
       (?$(0T](B . "0x907A") ;; <CJK>
       (?$(0T^(B . "0x9134") ;; <CJK>
       (?$(0T_(B . "0x9192") ;; <CJK>
       (?$(0T`(B . "0x9320") ;; <CJK>
       (?$(0Ta(B . "0x9336") ;; <CJK>
       (?$(0Tb(B . "0x92F8") ;; <CJK>
       (?$(0Tc(B . "0x9333") ;; <CJK>
       (?$(0Td(B . "0x932F") ;; <CJK>
       (?$(0Te(B . "0x9322") ;; <CJK>
       (?$(0Tf(B . "0x92FC") ;; <CJK>
       (?$(0Tg(B . "0x932B") ;; <CJK>
       (?$(0Th(B . "0x9304") ;; <CJK>
       (?$(0Ti(B . "0x931A") ;; <CJK>
       (?$(0Tj(B . "0x9310") ;; <CJK>
       (?$(0Tk(B . "0x9326") ;; <CJK>
       (?$(0Tl(B . "0x9321") ;; <CJK>
       (?$(0Tm(B . "0x9315") ;; <CJK>
       (?$(0Tn(B . "0x932E") ;; <CJK>
       (?$(0To(B . "0x9319") ;; <CJK>
       (?$(0Tp(B . "0x95BB") ;; <CJK>
       (?$(0Tq(B . "0x96A7") ;; <CJK>
       (?$(0Tr(B . "0x96A8") ;; <CJK>
       (?$(0Ts(B . "0x96AA") ;; <CJK>
       (?$(0Tt(B . "0x96D5") ;; <CJK>
       (?$(0Tu(B . "0x970E") ;; <CJK>
       (?$(0Tv(B . "0x9711") ;; <CJK>
       (?$(0Tw(B . "0x9716") ;; <CJK>
       (?$(0Tx(B . "0x970D") ;; <CJK>
       (?$(0Ty(B . "0x9713") ;; <CJK>
       (?$(0Tz(B . "0x970F") ;; <CJK>
       (?$(0T{(B . "0x975B") ;; <CJK>
       (?$(0T|(B . "0x975C") ;; <CJK>
       (?$(0T}(B . "0x9766") ;; <CJK>
       (?$(0T~(B . "0x9798") ;; <CJK>
       (?$(0U!(B . "0x9830") ;; <CJK>
       (?$(0U"(B . "0x9838") ;; <CJK>
       (?$(0U#(B . "0x983B") ;; <CJK>
       (?$(0U$(B . "0x9837") ;; <CJK>
       (?$(0U%(B . "0x982D") ;; <CJK>
       (?$(0U&(B . "0x9839") ;; <CJK>
       (?$(0U'(B . "0x9824") ;; <CJK>
       (?$(0U((B . "0x9910") ;; <CJK>
       (?$(0U)(B . "0x9928") ;; <CJK>
       (?$(0U*(B . "0x991E") ;; <CJK>
       (?$(0U+(B . "0x991B") ;; <CJK>
       (?$(0U,(B . "0x9921") ;; <CJK>
       (?$(0U-(B . "0x991A") ;; <CJK>
       (?$(0U.(B . "0x99ED") ;; <CJK>
       (?$(0U/(B . "0x99E2") ;; <CJK>
       (?$(0U0(B . "0x99F1") ;; <CJK>
       (?$(0U1(B . "0x9AB8") ;; <CJK>
       (?$(0U2(B . "0x9ABC") ;; <CJK>
       (?$(0U3(B . "0x9AFB") ;; <CJK>
       (?$(0U4(B . "0x9AED") ;; <CJK>
       (?$(0U5(B . "0x9B28") ;; <CJK>
       (?$(0U6(B . "0x9B91") ;; <CJK>
       (?$(0U7(B . "0x9D15") ;; <CJK>
       (?$(0U8(B . "0x9D23") ;; <CJK>
       (?$(0U9(B . "0x9D26") ;; <CJK>
       (?$(0U:(B . "0x9D28") ;; <CJK>
       (?$(0U;(B . "0x9D12") ;; <CJK>
       (?$(0U<(B . "0x9D1B") ;; <CJK>
       (?$(0U=(B . "0x9ED8") ;; <CJK>
       (?$(0U>(B . "0x9ED4") ;; <CJK>
       (?$(0U?(B . "0x9F8D") ;; <CJK>
       (?$(0U@(B . "0x9F9C") ;; <CJK>
       (?$(0UA(B . "0x512A") ;; <CJK>
       (?$(0UB(B . "0x511F") ;; <CJK>
       (?$(0UC(B . "0x5121") ;; <CJK>
       (?$(0UD(B . "0x5132") ;; <CJK>
       (?$(0UE(B . "0x52F5") ;; <CJK>
       (?$(0UF(B . "0x568E") ;; <CJK>
       (?$(0UG(B . "0x5680") ;; <CJK>
       (?$(0UH(B . "0x5690") ;; <CJK>
       (?$(0UI(B . "0x5685") ;; <CJK>
       (?$(0UJ(B . "0x5687") ;; <CJK>
       (?$(0UK(B . "0x568F") ;; <CJK>
       (?$(0UL(B . "0x58D5") ;; <CJK>
       (?$(0UM(B . "0x58D3") ;; <CJK>
       (?$(0UN(B . "0x58D1") ;; <CJK>
       (?$(0UO(B . "0x58CE") ;; <CJK>
       (?$(0UP(B . "0x5B30") ;; <CJK>
       (?$(0UQ(B . "0x5B2A") ;; <CJK>
       (?$(0UR(B . "0x5B24") ;; <CJK>
       (?$(0US(B . "0x5B7A") ;; <CJK>
       (?$(0UT(B . "0x5C37") ;; <CJK>
       (?$(0UU(B . "0x5C68") ;; <CJK>
       (?$(0UV(B . "0x5DBC") ;; <CJK>
       (?$(0UW(B . "0x5DBA") ;; <CJK>
       (?$(0UX(B . "0x5DBD") ;; <CJK>
       (?$(0UY(B . "0x5DB8") ;; <CJK>
       (?$(0UZ(B . "0x5E6B") ;; <CJK>
       (?$(0U[(B . "0x5F4C") ;; <CJK>
       (?$(0U\(B . "0x5FBD") ;; <CJK>
       (?$(0U](B . "0x61C9") ;; <CJK>
       (?$(0U^(B . "0x61C2") ;; <CJK>
       (?$(0U_(B . "0x61C7") ;; <CJK>
       (?$(0U`(B . "0x61E6") ;; <CJK>
       (?$(0Ua(B . "0x61CB") ;; <CJK>
       (?$(0Ub(B . "0x6232") ;; <CJK>
       (?$(0Uc(B . "0x6234") ;; <CJK>
       (?$(0Ud(B . "0x64CE") ;; <CJK>
       (?$(0Ue(B . "0x64CA") ;; <CJK>
       (?$(0Uf(B . "0x64D8") ;; <CJK>
       (?$(0Ug(B . "0x64E0") ;; <CJK>
       (?$(0Uh(B . "0x64F0") ;; <CJK>
       (?$(0Ui(B . "0x64E6") ;; <CJK>
       (?$(0Uj(B . "0x64EC") ;; <CJK>
       (?$(0Uk(B . "0x64F1") ;; <CJK>
       (?$(0Ul(B . "0x64E2") ;; <CJK>
       (?$(0Um(B . "0x64ED") ;; <CJK>
       (?$(0Un(B . "0x6582") ;; <CJK>
       (?$(0Uo(B . "0x6583") ;; <CJK>
       (?$(0Up(B . "0x66D9") ;; <CJK>
       (?$(0Uq(B . "0x66D6") ;; <CJK>
       (?$(0Ur(B . "0x6A80") ;; <CJK>
       (?$(0Us(B . "0x6A94") ;; <CJK>
       (?$(0Ut(B . "0x6A84") ;; <CJK>
       (?$(0Uu(B . "0x6AA2") ;; <CJK>
       (?$(0Uv(B . "0x6A9C") ;; <CJK>
       (?$(0Uw(B . "0x6ADB") ;; <CJK>
       (?$(0Ux(B . "0x6AA3") ;; <CJK>
       (?$(0Uy(B . "0x6A7E") ;; <CJK>
       (?$(0Uz(B . "0x6A97") ;; <CJK>
       (?$(0U{(B . "0x6A90") ;; <CJK>
       (?$(0U|(B . "0x6AA0") ;; <CJK>
       (?$(0U}(B . "0x6B5C") ;; <CJK>
       (?$(0U~(B . "0x6BAE") ;; <CJK>
       (?$(0V!(B . "0x6BDA") ;; <CJK>
       (?$(0V"(B . "0x6C08") ;; <CJK>
       (?$(0V#(B . "0x6FD8") ;; <CJK>
       (?$(0V$(B . "0x6FF1") ;; <CJK>
       (?$(0V%(B . "0x6FDF") ;; <CJK>
       (?$(0V&(B . "0x6FE0") ;; <CJK>
       (?$(0V'(B . "0x6FDB") ;; <CJK>
       (?$(0V((B . "0x6FE4") ;; <CJK>
       (?$(0V)(B . "0x6FEB") ;; <CJK>
       (?$(0V*(B . "0x6FEF") ;; <CJK>
       (?$(0V+(B . "0x6F80") ;; <CJK>
       (?$(0V,(B . "0x6FEC") ;; <CJK>
       (?$(0V-(B . "0x6FE1") ;; <CJK>
       (?$(0V.(B . "0x6FE9") ;; <CJK>
       (?$(0V/(B . "0x6FD5") ;; <CJK>
       (?$(0V0(B . "0x6FEE") ;; <CJK>
       (?$(0V1(B . "0x6FF0") ;; <CJK>
       (?$(0V2(B . "0x71E7") ;; <CJK>
       (?$(0V3(B . "0x71DF") ;; <CJK>
       (?$(0V4(B . "0x71EE") ;; <CJK>
       (?$(0V5(B . "0x71E6") ;; <CJK>
       (?$(0V6(B . "0x71E5") ;; <CJK>
       (?$(0V7(B . "0x71ED") ;; <CJK>
       (?$(0V8(B . "0x71EC") ;; <CJK>
       (?$(0V9(B . "0x71F4") ;; <CJK>
       (?$(0V:(B . "0x71E0") ;; <CJK>
       (?$(0V;(B . "0x7235") ;; <CJK>
       (?$(0V<(B . "0x7246") ;; <CJK>
       (?$(0V=(B . "0x7370") ;; <CJK>
       (?$(0V>(B . "0x7372") ;; <CJK>
       (?$(0V?(B . "0x74A9") ;; <CJK>
       (?$(0V@(B . "0x74B0") ;; <CJK>
       (?$(0VA(B . "0x74A6") ;; <CJK>
       (?$(0VB(B . "0x74A8") ;; <CJK>
       (?$(0VC(B . "0x7646") ;; <CJK>
       (?$(0VD(B . "0x7642") ;; <CJK>
       (?$(0VE(B . "0x764C") ;; <CJK>
       (?$(0VF(B . "0x76EA") ;; <CJK>
       (?$(0VG(B . "0x77B3") ;; <CJK>
       (?$(0VH(B . "0x77AA") ;; <CJK>
       (?$(0VI(B . "0x77B0") ;; <CJK>
       (?$(0VJ(B . "0x77AC") ;; <CJK>
       (?$(0VK(B . "0x77A7") ;; <CJK>
       (?$(0VL(B . "0x77AD") ;; <CJK>
       (?$(0VM(B . "0x77EF") ;; <CJK>
       (?$(0VN(B . "0x78F7") ;; <CJK>
       (?$(0VO(B . "0x78FA") ;; <CJK>
       (?$(0VP(B . "0x78F4") ;; <CJK>
       (?$(0VQ(B . "0x78EF") ;; <CJK>
       (?$(0VR(B . "0x7901") ;; <CJK>
       (?$(0VS(B . "0x79A7") ;; <CJK>
       (?$(0VT(B . "0x79AA") ;; <CJK>
       (?$(0VU(B . "0x7A57") ;; <CJK>
       (?$(0VV(B . "0x7ABF") ;; <CJK>
       (?$(0VW(B . "0x7C07") ;; <CJK>
       (?$(0VX(B . "0x7C0D") ;; <CJK>
       (?$(0VY(B . "0x7BFE") ;; <CJK>
       (?$(0VZ(B . "0x7BF7") ;; <CJK>
       (?$(0V[(B . "0x7C0C") ;; <CJK>
       (?$(0V\(B . "0x7BE0") ;; <CJK>
       (?$(0V](B . "0x7CE0") ;; <CJK>
       (?$(0V^(B . "0x7CDC") ;; <CJK>
       (?$(0V_(B . "0x7CDE") ;; <CJK>
       (?$(0V`(B . "0x7CE2") ;; <CJK>
       (?$(0Va(B . "0x7CDF") ;; <CJK>
       (?$(0Vb(B . "0x7CD9") ;; <CJK>
       (?$(0Vc(B . "0x7CDD") ;; <CJK>
       (?$(0Vd(B . "0x7E2E") ;; <CJK>
       (?$(0Ve(B . "0x7E3E") ;; <CJK>
       (?$(0Vf(B . "0x7E46") ;; <CJK>
       (?$(0Vg(B . "0x7E37") ;; <CJK>
       (?$(0Vh(B . "0x7E32") ;; <CJK>
       (?$(0Vi(B . "0x7E43") ;; <CJK>
       (?$(0Vj(B . "0x7E2B") ;; <CJK>
       (?$(0Vk(B . "0x7E3D") ;; <CJK>
       (?$(0Vl(B . "0x7E31") ;; <CJK>
       (?$(0Vm(B . "0x7E45") ;; <CJK>
       (?$(0Vn(B . "0x7E41") ;; <CJK>
       (?$(0Vo(B . "0x7E34") ;; <CJK>
       (?$(0Vp(B . "0x7E39") ;; <CJK>
       (?$(0Vq(B . "0x7E48") ;; <CJK>
       (?$(0Vr(B . "0x7E35") ;; <CJK>
       (?$(0Vs(B . "0x7E3F") ;; <CJK>
       (?$(0Vt(B . "0x7E2F") ;; <CJK>
       (?$(0Vu(B . "0x7F44") ;; <CJK>
       (?$(0Vv(B . "0x7FF3") ;; <CJK>
       (?$(0Vw(B . "0x7FFC") ;; <CJK>
       (?$(0Vx(B . "0x8071") ;; <CJK>
       (?$(0Vy(B . "0x8072") ;; <CJK>
       (?$(0Vz(B . "0x8070") ;; <CJK>
       (?$(0V{(B . "0x806F") ;; <CJK>
       (?$(0V|(B . "0x8073") ;; <CJK>
       (?$(0V}(B . "0x81C6") ;; <CJK>
       (?$(0V~(B . "0x81C3") ;; <CJK>
       (?$(0W!(B . "0x81BA") ;; <CJK>
       (?$(0W"(B . "0x81C2") ;; <CJK>
       (?$(0W#(B . "0x81C0") ;; <CJK>
       (?$(0W$(B . "0x81BF") ;; <CJK>
       (?$(0W%(B . "0x81BD") ;; <CJK>
       (?$(0W&(B . "0x81C9") ;; <CJK>
       (?$(0W'(B . "0x81BE") ;; <CJK>
       (?$(0W((B . "0x81E8") ;; <CJK>
       (?$(0W)(B . "0x8209") ;; <CJK>
       (?$(0W*(B . "0x8271") ;; <CJK>
       (?$(0W+(B . "0x85AA") ;; <CJK>
       (?$(0W,(B . "0x8584") ;; <CJK>
       (?$(0W-(B . "0x857E") ;; <CJK>
       (?$(0W.(B . "0x859C") ;; <CJK>
       (?$(0W/(B . "0x8591") ;; <CJK>
       (?$(0W0(B . "0x8594") ;; <CJK>
       (?$(0W1(B . "0x85AF") ;; <CJK>
       (?$(0W2(B . "0x859B") ;; <CJK>
       (?$(0W3(B . "0x8587") ;; <CJK>
       (?$(0W4(B . "0x85A8") ;; <CJK>
       (?$(0W5(B . "0x858A") ;; <CJK>
       (?$(0W6(B . "0x8667") ;; <CJK>
       (?$(0W7(B . "0x87C0") ;; <CJK>
       (?$(0W8(B . "0x87D1") ;; <CJK>
       (?$(0W9(B . "0x87B3") ;; <CJK>
       (?$(0W:(B . "0x87D2") ;; <CJK>
       (?$(0W;(B . "0x87C6") ;; <CJK>
       (?$(0W<(B . "0x87AB") ;; <CJK>
       (?$(0W=(B . "0x87BB") ;; <CJK>
       (?$(0W>(B . "0x87BA") ;; <CJK>
       (?$(0W?(B . "0x87C8") ;; <CJK>
       (?$(0W@(B . "0x87CB") ;; <CJK>
       (?$(0WA(B . "0x893B") ;; <CJK>
       (?$(0WB(B . "0x8936") ;; <CJK>
       (?$(0WC(B . "0x8944") ;; <CJK>
       (?$(0WD(B . "0x8938") ;; <CJK>
       (?$(0WE(B . "0x893D") ;; <CJK>
       (?$(0WF(B . "0x89AC") ;; <CJK>
       (?$(0WG(B . "0x8B0E") ;; <CJK>
       (?$(0WH(B . "0x8B17") ;; <CJK>
       (?$(0WI(B . "0x8B19") ;; <CJK>
       (?$(0WJ(B . "0x8B1B") ;; <CJK>
       (?$(0WK(B . "0x8B0A") ;; <CJK>
       (?$(0WL(B . "0x8B20") ;; <CJK>
       (?$(0WM(B . "0x8B1D") ;; <CJK>
       (?$(0WN(B . "0x8B04") ;; <CJK>
       (?$(0WO(B . "0x8B10") ;; <CJK>
       (?$(0WP(B . "0x8C41") ;; <CJK>
       (?$(0WQ(B . "0x8C3F") ;; <CJK>
       (?$(0WR(B . "0x8C73") ;; <CJK>
       (?$(0WS(B . "0x8CFA") ;; <CJK>
       (?$(0WT(B . "0x8CFD") ;; <CJK>
       (?$(0WU(B . "0x8CFC") ;; <CJK>
       (?$(0WV(B . "0x8CF8") ;; <CJK>
       (?$(0WW(B . "0x8CFB") ;; <CJK>
       (?$(0WX(B . "0x8DA8") ;; <CJK>
       (?$(0WY(B . "0x8E49") ;; <CJK>
       (?$(0WZ(B . "0x8E4B") ;; <CJK>
       (?$(0W[(B . "0x8E48") ;; <CJK>
       (?$(0W\(B . "0x8E4A") ;; <CJK>
       (?$(0W](B . "0x8F44") ;; <CJK>
       (?$(0W^(B . "0x8F3E") ;; <CJK>
       (?$(0W_(B . "0x8F42") ;; <CJK>
       (?$(0W`(B . "0x8F45") ;; <CJK>
       (?$(0Wa(B . "0x8F3F") ;; <CJK>
       (?$(0Wb(B . "0x907F") ;; <CJK>
       (?$(0Wc(B . "0x907D") ;; <CJK>
       (?$(0Wd(B . "0x9084") ;; <CJK>
       (?$(0We(B . "0x9081") ;; <CJK>
       (?$(0Wf(B . "0x9082") ;; <CJK>
       (?$(0Wg(B . "0x9080") ;; <CJK>
       (?$(0Wh(B . "0x9139") ;; <CJK>
       (?$(0Wi(B . "0x91A3") ;; <CJK>
       (?$(0Wj(B . "0x919E") ;; <CJK>
       (?$(0Wk(B . "0x919C") ;; <CJK>
       (?$(0Wl(B . "0x934D") ;; <CJK>
       (?$(0Wm(B . "0x9382") ;; <CJK>
       (?$(0Wn(B . "0x9328") ;; <CJK>
       (?$(0Wo(B . "0x9375") ;; <CJK>
       (?$(0Wp(B . "0x934A") ;; <CJK>
       (?$(0Wq(B . "0x9365") ;; <CJK>
       (?$(0Wr(B . "0x934B") ;; <CJK>
       (?$(0Ws(B . "0x9318") ;; <CJK>
       (?$(0Wt(B . "0x937E") ;; <CJK>
       (?$(0Wu(B . "0x936C") ;; <CJK>
       (?$(0Wv(B . "0x935B") ;; <CJK>
       (?$(0Ww(B . "0x9370") ;; <CJK>
       (?$(0Wx(B . "0x935A") ;; <CJK>
       (?$(0Wy(B . "0x9354") ;; <CJK>
       (?$(0Wz(B . "0x95CA") ;; <CJK>
       (?$(0W{(B . "0x95CB") ;; <CJK>
       (?$(0W|(B . "0x95CC") ;; <CJK>
       (?$(0W}(B . "0x95C8") ;; <CJK>
       (?$(0W~(B . "0x95C6") ;; <CJK>
       (?$(0X!(B . "0x96B1") ;; <CJK>
       (?$(0X"(B . "0x96B8") ;; <CJK>
       (?$(0X#(B . "0x96D6") ;; <CJK>
       (?$(0X$(B . "0x971C") ;; <CJK>
       (?$(0X%(B . "0x971E") ;; <CJK>
       (?$(0X&(B . "0x97A0") ;; <CJK>
       (?$(0X'(B . "0x97D3") ;; <CJK>
       (?$(0X((B . "0x9846") ;; <CJK>
       (?$(0X)(B . "0x98B6") ;; <CJK>
       (?$(0X*(B . "0x9935") ;; <CJK>
       (?$(0X+(B . "0x9A01") ;; <CJK>
       (?$(0X,(B . "0x99FF") ;; <CJK>
       (?$(0X-(B . "0x9BAE") ;; <CJK>
       (?$(0X.(B . "0x9BAB") ;; <CJK>
       (?$(0X/(B . "0x9BAA") ;; <CJK>
       (?$(0X0(B . "0x9BAD") ;; <CJK>
       (?$(0X1(B . "0x9D3B") ;; <CJK>
       (?$(0X2(B . "0x9D3F") ;; <CJK>
       (?$(0X3(B . "0x9E8B") ;; <CJK>
       (?$(0X4(B . "0x9ECF") ;; <CJK>
       (?$(0X5(B . "0x9EDE") ;; <CJK>
       (?$(0X6(B . "0x9EDC") ;; <CJK>
       (?$(0X7(B . "0x9EDD") ;; <CJK>
       (?$(0X8(B . "0x9EDB") ;; <CJK>
       (?$(0X9(B . "0x9F3E") ;; <CJK>
       (?$(0X:(B . "0x9F4B") ;; <CJK>
       (?$(0X;(B . "0x53E2") ;; <CJK>
       (?$(0X<(B . "0x5695") ;; <CJK>
       (?$(0X=(B . "0x56AE") ;; <CJK>
       (?$(0X>(B . "0x58D9") ;; <CJK>
       (?$(0X?(B . "0x58D8") ;; <CJK>
       (?$(0X@(B . "0x5B38") ;; <CJK>
       (?$(0XA(B . "0x5F5D") ;; <CJK>
       (?$(0XB(B . "0x61E3") ;; <CJK>
       (?$(0XC(B . "0x6233") ;; <CJK>
       (?$(0XD(B . "0x64F4") ;; <CJK>
       (?$(0XE(B . "0x64F2") ;; <CJK>
       (?$(0XF(B . "0x64FE") ;; <CJK>
       (?$(0XG(B . "0x6506") ;; <CJK>
       (?$(0XH(B . "0x64FA") ;; <CJK>
       (?$(0XI(B . "0x64FB") ;; <CJK>
       (?$(0XJ(B . "0x64F7") ;; <CJK>
       (?$(0XK(B . "0x65B7") ;; <CJK>
       (?$(0XL(B . "0x66DC") ;; <CJK>
       (?$(0XM(B . "0x6726") ;; <CJK>
       (?$(0XN(B . "0x6AB3") ;; <CJK>
       (?$(0XO(B . "0x6AAC") ;; <CJK>
       (?$(0XP(B . "0x6AC3") ;; <CJK>
       (?$(0XQ(B . "0x6ABB") ;; <CJK>
       (?$(0XR(B . "0x6AB8") ;; <CJK>
       (?$(0XS(B . "0x6AC2") ;; <CJK>
       (?$(0XT(B . "0x6AAE") ;; <CJK>
       (?$(0XU(B . "0x6AAF") ;; <CJK>
       (?$(0XV(B . "0x6B5F") ;; <CJK>
       (?$(0XW(B . "0x6B78") ;; <CJK>
       (?$(0XX(B . "0x6BAF") ;; <CJK>
       (?$(0XY(B . "0x7009") ;; <CJK>
       (?$(0XZ(B . "0x700B") ;; <CJK>
       (?$(0X[(B . "0x6FFE") ;; <CJK>
       (?$(0X\(B . "0x7006") ;; <CJK>
       (?$(0X](B . "0x6FFA") ;; <CJK>
       (?$(0X^(B . "0x7011") ;; <CJK>
       (?$(0X_(B . "0x700F") ;; <CJK>
       (?$(0X`(B . "0x71FB") ;; <CJK>
       (?$(0Xa(B . "0x71FC") ;; <CJK>
       (?$(0Xb(B . "0x71FE") ;; <CJK>
       (?$(0Xc(B . "0x71F8") ;; <CJK>
       (?$(0Xd(B . "0x7377") ;; <CJK>
       (?$(0Xe(B . "0x7375") ;; <CJK>
       (?$(0Xf(B . "0x74A7") ;; <CJK>
       (?$(0Xg(B . "0x74BF") ;; <CJK>
       (?$(0Xh(B . "0x7515") ;; <CJK>
       (?$(0Xi(B . "0x7656") ;; <CJK>
       (?$(0Xj(B . "0x7658") ;; <CJK>
       (?$(0Xk(B . "0x7652") ;; <CJK>
       (?$(0Xl(B . "0x77BD") ;; <CJK>
       (?$(0Xm(B . "0x77BF") ;; <CJK>
       (?$(0Xn(B . "0x77BB") ;; <CJK>
       (?$(0Xo(B . "0x77BC") ;; <CJK>
       (?$(0Xp(B . "0x790E") ;; <CJK>
       (?$(0Xq(B . "0x79AE") ;; <CJK>
       (?$(0Xr(B . "0x7A61") ;; <CJK>
       (?$(0Xs(B . "0x7A62") ;; <CJK>
       (?$(0Xt(B . "0x7A60") ;; <CJK>
       (?$(0Xu(B . "0x7AC4") ;; <CJK>
       (?$(0Xv(B . "0x7AC5") ;; <CJK>
       (?$(0Xw(B . "0x7C2B") ;; <CJK>
       (?$(0Xx(B . "0x7C27") ;; <CJK>
       (?$(0Xy(B . "0x7C2A") ;; <CJK>
       (?$(0Xz(B . "0x7C1E") ;; <CJK>
       (?$(0X{(B . "0x7C23") ;; <CJK>
       (?$(0X|(B . "0x7C21") ;; <CJK>
       (?$(0X}(B . "0x7CE7") ;; <CJK>
       (?$(0X~(B . "0x7E54") ;; <CJK>
       (?$(0Y!(B . "0x7E55") ;; <CJK>
       (?$(0Y"(B . "0x7E5E") ;; <CJK>
       (?$(0Y#(B . "0x7E5A") ;; <CJK>
       (?$(0Y$(B . "0x7E61") ;; <CJK>
       (?$(0Y%(B . "0x7E52") ;; <CJK>
       (?$(0Y&(B . "0x7E59") ;; <CJK>
       (?$(0Y'(B . "0x7F48") ;; <CJK>
       (?$(0Y((B . "0x7FF9") ;; <CJK>
       (?$(0Y)(B . "0x7FFB") ;; <CJK>
       (?$(0Y*(B . "0x8077") ;; <CJK>
       (?$(0Y+(B . "0x8076") ;; <CJK>
       (?$(0Y,(B . "0x81CD") ;; <CJK>
       (?$(0Y-(B . "0x81CF") ;; <CJK>
       (?$(0Y.(B . "0x820A") ;; <CJK>
       (?$(0Y/(B . "0x85CF") ;; <CJK>
       (?$(0Y0(B . "0x85A9") ;; <CJK>
       (?$(0Y1(B . "0x85CD") ;; <CJK>
       (?$(0Y2(B . "0x85D0") ;; <CJK>
       (?$(0Y3(B . "0x85C9") ;; <CJK>
       (?$(0Y4(B . "0x85B0") ;; <CJK>
       (?$(0Y5(B . "0x85BA") ;; <CJK>
       (?$(0Y6(B . "0x85B9") ;; <CJK>
       (?$(0Y7(B . "0x85A6") ;; <CJK>
       (?$(0Y8(B . "0x87EF") ;; <CJK>
       (?$(0Y9(B . "0x87EC") ;; <CJK>
       (?$(0Y:(B . "0x87F2") ;; <CJK>
       (?$(0Y;(B . "0x87E0") ;; <CJK>
       (?$(0Y<(B . "0x8986") ;; <CJK>
       (?$(0Y=(B . "0x89B2") ;; <CJK>
       (?$(0Y>(B . "0x89F4") ;; <CJK>
       (?$(0Y?(B . "0x8B28") ;; <CJK>
       (?$(0Y@(B . "0x8B39") ;; <CJK>
       (?$(0YA(B . "0x8B2C") ;; <CJK>
       (?$(0YB(B . "0x8B2B") ;; <CJK>
       (?$(0YC(B . "0x8C50") ;; <CJK>
       (?$(0YD(B . "0x8D05") ;; <CJK>
       (?$(0YE(B . "0x8E59") ;; <CJK>
       (?$(0YF(B . "0x8E63") ;; <CJK>
       (?$(0YG(B . "0x8E66") ;; <CJK>
       (?$(0YH(B . "0x8E64") ;; <CJK>
       (?$(0YI(B . "0x8E5F") ;; <CJK>
       (?$(0YJ(B . "0x8E55") ;; <CJK>
       (?$(0YK(B . "0x8EC0") ;; <CJK>
       (?$(0YL(B . "0x8F49") ;; <CJK>
       (?$(0YM(B . "0x8F4D") ;; <CJK>
       (?$(0YN(B . "0x9087") ;; <CJK>
       (?$(0YO(B . "0x9083") ;; <CJK>
       (?$(0YP(B . "0x9088") ;; <CJK>
       (?$(0YQ(B . "0x91AB") ;; <CJK>
       (?$(0YR(B . "0x91AC") ;; <CJK>
       (?$(0YS(B . "0x91D0") ;; <CJK>
       (?$(0YT(B . "0x9394") ;; <CJK>
       (?$(0YU(B . "0x938A") ;; <CJK>
       (?$(0YV(B . "0x9396") ;; <CJK>
       (?$(0YW(B . "0x93A2") ;; <CJK>
       (?$(0YX(B . "0x93B3") ;; <CJK>
       (?$(0YY(B . "0x93AE") ;; <CJK>
       (?$(0YZ(B . "0x93AC") ;; <CJK>
       (?$(0Y[(B . "0x93B0") ;; <CJK>
       (?$(0Y\(B . "0x9398") ;; <CJK>
       (?$(0Y](B . "0x939A") ;; <CJK>
       (?$(0Y^(B . "0x9397") ;; <CJK>
       (?$(0Y_(B . "0x95D4") ;; <CJK>
       (?$(0Y`(B . "0x95D6") ;; <CJK>
       (?$(0Ya(B . "0x95D0") ;; <CJK>
       (?$(0Yb(B . "0x95D5") ;; <CJK>
       (?$(0Yc(B . "0x96E2") ;; <CJK>
       (?$(0Yd(B . "0x96DC") ;; <CJK>
       (?$(0Ye(B . "0x96D9") ;; <CJK>
       (?$(0Yf(B . "0x96DB") ;; <CJK>
       (?$(0Yg(B . "0x96DE") ;; <CJK>
       (?$(0Yh(B . "0x9724") ;; <CJK>
       (?$(0Yi(B . "0x97A3") ;; <CJK>
       (?$(0Yj(B . "0x97A6") ;; <CJK>
       (?$(0Yk(B . "0x97AD") ;; <CJK>
       (?$(0Yl(B . "0x97F9") ;; <CJK>
       (?$(0Ym(B . "0x984D") ;; <CJK>
       (?$(0Yn(B . "0x984F") ;; <CJK>
       (?$(0Yo(B . "0x984C") ;; <CJK>
       (?$(0Yp(B . "0x984E") ;; <CJK>
       (?$(0Yq(B . "0x9853") ;; <CJK>
       (?$(0Yr(B . "0x98BA") ;; <CJK>
       (?$(0Ys(B . "0x993E") ;; <CJK>
       (?$(0Yt(B . "0x993F") ;; <CJK>
       (?$(0Yu(B . "0x993D") ;; <CJK>
       (?$(0Yv(B . "0x992E") ;; <CJK>
       (?$(0Yw(B . "0x99A5") ;; <CJK>
       (?$(0Yx(B . "0x9A0E") ;; <CJK>
       (?$(0Yy(B . "0x9AC1") ;; <CJK>
       (?$(0Yz(B . "0x9B03") ;; <CJK>
       (?$(0Y{(B . "0x9B06") ;; <CJK>
       (?$(0Y|(B . "0x9B4F") ;; <CJK>
       (?$(0Y}(B . "0x9B4E") ;; <CJK>
       (?$(0Y~(B . "0x9B4D") ;; <CJK>
       (?$(0Z!(B . "0x9BCA") ;; <CJK>
       (?$(0Z"(B . "0x9BC9") ;; <CJK>
       (?$(0Z#(B . "0x9BFD") ;; <CJK>
       (?$(0Z$(B . "0x9BC8") ;; <CJK>
       (?$(0Z%(B . "0x9BC0") ;; <CJK>
       (?$(0Z&(B . "0x9D51") ;; <CJK>
       (?$(0Z'(B . "0x9D5D") ;; <CJK>
       (?$(0Z((B . "0x9D60") ;; <CJK>
       (?$(0Z)(B . "0x9EE0") ;; <CJK>
       (?$(0Z*(B . "0x9F15") ;; <CJK>
       (?$(0Z+(B . "0x9F2C") ;; <CJK>
       (?$(0Z,(B . "0x5133") ;; <CJK>
       (?$(0Z-(B . "0x56A5") ;; <CJK>
       (?$(0Z.(B . "0x58DE") ;; <CJK>
       (?$(0Z/(B . "0x58DF") ;; <CJK>
       (?$(0Z0(B . "0x58E2") ;; <CJK>
       (?$(0Z1(B . "0x5BF5") ;; <CJK>
       (?$(0Z2(B . "0x9F90") ;; <CJK>
       (?$(0Z3(B . "0x5EEC") ;; <CJK>
       (?$(0Z4(B . "0x61F2") ;; <CJK>
       (?$(0Z5(B . "0x61F7") ;; <CJK>
       (?$(0Z6(B . "0x61F6") ;; <CJK>
       (?$(0Z7(B . "0x61F5") ;; <CJK>
       (?$(0Z8(B . "0x6500") ;; <CJK>
       (?$(0Z9(B . "0x650F") ;; <CJK>
       (?$(0Z:(B . "0x66E0") ;; <CJK>
       (?$(0Z;(B . "0x66DD") ;; <CJK>
       (?$(0Z<(B . "0x6AE5") ;; <CJK>
       (?$(0Z=(B . "0x6ADD") ;; <CJK>
       (?$(0Z>(B . "0x6ADA") ;; <CJK>
       (?$(0Z?(B . "0x6AD3") ;; <CJK>
       (?$(0Z@(B . "0x701B") ;; <CJK>
       (?$(0ZA(B . "0x701F") ;; <CJK>
       (?$(0ZB(B . "0x7028") ;; <CJK>
       (?$(0ZC(B . "0x701A") ;; <CJK>
       (?$(0ZD(B . "0x701D") ;; <CJK>
       (?$(0ZE(B . "0x7015") ;; <CJK>
       (?$(0ZF(B . "0x7018") ;; <CJK>
       (?$(0ZG(B . "0x7206") ;; <CJK>
       (?$(0ZH(B . "0x720D") ;; <CJK>
       (?$(0ZI(B . "0x7258") ;; <CJK>
       (?$(0ZJ(B . "0x72A2") ;; <CJK>
       (?$(0ZK(B . "0x7378") ;; <CJK>
       (?$(0ZL(B . "0x737A") ;; <CJK>
       (?$(0ZM(B . "0x74BD") ;; <CJK>
       (?$(0ZN(B . "0x74CA") ;; <CJK>
       (?$(0ZO(B . "0x74E3") ;; <CJK>
       (?$(0ZP(B . "0x7587") ;; <CJK>
       (?$(0ZQ(B . "0x7586") ;; <CJK>
       (?$(0ZR(B . "0x765F") ;; <CJK>
       (?$(0ZS(B . "0x7661") ;; <CJK>
       (?$(0ZT(B . "0x77C7") ;; <CJK>
       (?$(0ZU(B . "0x7919") ;; <CJK>
       (?$(0ZV(B . "0x79B1") ;; <CJK>
       (?$(0ZW(B . "0x7A6B") ;; <CJK>
       (?$(0ZX(B . "0x7A69") ;; <CJK>
       (?$(0ZY(B . "0x7C3E") ;; <CJK>
       (?$(0ZZ(B . "0x7C3F") ;; <CJK>
       (?$(0Z[(B . "0x7C38") ;; <CJK>
       (?$(0Z\(B . "0x7C3D") ;; <CJK>
       (?$(0Z](B . "0x7C37") ;; <CJK>
       (?$(0Z^(B . "0x7C40") ;; <CJK>
       (?$(0Z_(B . "0x7E6B") ;; <CJK>
       (?$(0Z`(B . "0x7E6D") ;; <CJK>
       (?$(0Za(B . "0x7E79") ;; <CJK>
       (?$(0Zb(B . "0x7E69") ;; <CJK>
       (?$(0Zc(B . "0x7E6A") ;; <CJK>
       (?$(0Zd(B . "0x7F85") ;; <CJK>
       (?$(0Ze(B . "0x7E73") ;; <CJK>
       (?$(0Zf(B . "0x7FB6") ;; <CJK>
       (?$(0Zg(B . "0x7FB9") ;; <CJK>
       (?$(0Zh(B . "0x7FB8") ;; <CJK>
       (?$(0Zi(B . "0x81D8") ;; <CJK>
       (?$(0Zj(B . "0x85E9") ;; <CJK>
       (?$(0Zk(B . "0x85DD") ;; <CJK>
       (?$(0Zl(B . "0x85EA") ;; <CJK>
       (?$(0Zm(B . "0x85D5") ;; <CJK>
       (?$(0Zn(B . "0x85E4") ;; <CJK>
       (?$(0Zo(B . "0x85E5") ;; <CJK>
       (?$(0Zp(B . "0x85F7") ;; <CJK>
       (?$(0Zq(B . "0x87FB") ;; <CJK>
       (?$(0Zr(B . "0x8805") ;; <CJK>
       (?$(0Zs(B . "0x880D") ;; <CJK>
       (?$(0Zt(B . "0x87F9") ;; <CJK>
       (?$(0Zu(B . "0x87FE") ;; <CJK>
       (?$(0Zv(B . "0x8960") ;; <CJK>
       (?$(0Zw(B . "0x895F") ;; <CJK>
       (?$(0Zx(B . "0x8956") ;; <CJK>
       (?$(0Zy(B . "0x895E") ;; <CJK>
       (?$(0Zz(B . "0x8B41") ;; <CJK>
       (?$(0Z{(B . "0x8B5C") ;; <CJK>
       (?$(0Z|(B . "0x8B58") ;; <CJK>
       (?$(0Z}(B . "0x8B49") ;; <CJK>
       (?$(0Z~(B . "0x8B5A") ;; <CJK>
       (?$(0[!(B . "0x8B4E") ;; <CJK>
       (?$(0["(B . "0x8B4F") ;; <CJK>
       (?$(0[#(B . "0x8B46") ;; <CJK>
       (?$(0[$(B . "0x8B59") ;; <CJK>
       (?$(0[%(B . "0x8D08") ;; <CJK>
       (?$(0[&(B . "0x8D0A") ;; <CJK>
       (?$(0['(B . "0x8E7C") ;; <CJK>
       (?$(0[((B . "0x8E72") ;; <CJK>
       (?$(0[)(B . "0x8E87") ;; <CJK>
       (?$(0[*(B . "0x8E76") ;; <CJK>
       (?$(0[+(B . "0x8E6C") ;; <CJK>
       (?$(0[,(B . "0x8E7A") ;; <CJK>
       (?$(0[-(B . "0x8E74") ;; <CJK>
       (?$(0[.(B . "0x8F54") ;; <CJK>
       (?$(0[/(B . "0x8F4E") ;; <CJK>
       (?$(0[0(B . "0x8FAD") ;; <CJK>
       (?$(0[1(B . "0x908A") ;; <CJK>
       (?$(0[2(B . "0x908B") ;; <CJK>
       (?$(0[3(B . "0x91B1") ;; <CJK>
       (?$(0[4(B . "0x91AE") ;; <CJK>
       (?$(0[5(B . "0x93E1") ;; <CJK>
       (?$(0[6(B . "0x93D1") ;; <CJK>
       (?$(0[7(B . "0x93DF") ;; <CJK>
       (?$(0[8(B . "0x93C3") ;; <CJK>
       (?$(0[9(B . "0x93C8") ;; <CJK>
       (?$(0[:(B . "0x93DC") ;; <CJK>
       (?$(0[;(B . "0x93DD") ;; <CJK>
       (?$(0[<(B . "0x93D6") ;; <CJK>
       (?$(0[=(B . "0x93E2") ;; <CJK>
       (?$(0[>(B . "0x93CD") ;; <CJK>
       (?$(0[?(B . "0x93D8") ;; <CJK>
       (?$(0[@(B . "0x93E4") ;; <CJK>
       (?$(0[A(B . "0x93D7") ;; <CJK>
       (?$(0[B(B . "0x93E8") ;; <CJK>
       (?$(0[C(B . "0x95DC") ;; <CJK>
       (?$(0[D(B . "0x96B4") ;; <CJK>
       (?$(0[E(B . "0x96E3") ;; <CJK>
       (?$(0[F(B . "0x972A") ;; <CJK>
       (?$(0[G(B . "0x9727") ;; <CJK>
       (?$(0[H(B . "0x9761") ;; <CJK>
       (?$(0[I(B . "0x97DC") ;; <CJK>
       (?$(0[J(B . "0x97FB") ;; <CJK>
       (?$(0[K(B . "0x985E") ;; <CJK>
       (?$(0[L(B . "0x9858") ;; <CJK>
       (?$(0[M(B . "0x985B") ;; <CJK>
       (?$(0[N(B . "0x98BC") ;; <CJK>
       (?$(0[O(B . "0x9945") ;; <CJK>
       (?$(0[P(B . "0x9949") ;; <CJK>
       (?$(0[Q(B . "0x9A16") ;; <CJK>
       (?$(0[R(B . "0x9A19") ;; <CJK>
       (?$(0[S(B . "0x9B0D") ;; <CJK>
       (?$(0[T(B . "0x9BE8") ;; <CJK>
       (?$(0[U(B . "0x9BE7") ;; <CJK>
       (?$(0[V(B . "0x9BD6") ;; <CJK>
       (?$(0[W(B . "0x9BDB") ;; <CJK>
       (?$(0[X(B . "0x9D89") ;; <CJK>
       (?$(0[Y(B . "0x9D61") ;; <CJK>
       (?$(0[Z(B . "0x9D72") ;; <CJK>
       (?$(0[[(B . "0x9D6A") ;; <CJK>
       (?$(0[\(B . "0x9D6C") ;; <CJK>
       (?$(0[](B . "0x9E92") ;; <CJK>
       (?$(0[^(B . "0x9E97") ;; <CJK>
       (?$(0[_(B . "0x9E93") ;; <CJK>
       (?$(0[`(B . "0x9EB4") ;; <CJK>
       (?$(0[a(B . "0x52F8") ;; <CJK>
       (?$(0[b(B . "0x56A8") ;; <CJK>
       (?$(0[c(B . "0x56B7") ;; <CJK>
       (?$(0[d(B . "0x56B6") ;; <CJK>
       (?$(0[e(B . "0x56B4") ;; <CJK>
       (?$(0[f(B . "0x56BC") ;; <CJK>
       (?$(0[g(B . "0x58E4") ;; <CJK>
       (?$(0[h(B . "0x5B40") ;; <CJK>
       (?$(0[i(B . "0x5B43") ;; <CJK>
       (?$(0[j(B . "0x5B7D") ;; <CJK>
       (?$(0[k(B . "0x5BF6") ;; <CJK>
       (?$(0[l(B . "0x5DC9") ;; <CJK>
       (?$(0[m(B . "0x61F8") ;; <CJK>
       (?$(0[n(B . "0x61FA") ;; <CJK>
       (?$(0[o(B . "0x6518") ;; <CJK>
       (?$(0[p(B . "0x6514") ;; <CJK>
       (?$(0[q(B . "0x6519") ;; <CJK>
       (?$(0[r(B . "0x66E6") ;; <CJK>
       (?$(0[s(B . "0x6727") ;; <CJK>
       (?$(0[t(B . "0x6AEC") ;; <CJK>
       (?$(0[u(B . "0x703E") ;; <CJK>
       (?$(0[v(B . "0x7030") ;; <CJK>
       (?$(0[w(B . "0x7032") ;; <CJK>
       (?$(0[x(B . "0x7210") ;; <CJK>
       (?$(0[y(B . "0x737B") ;; <CJK>
       (?$(0[z(B . "0x74CF") ;; <CJK>
       (?$(0[{(B . "0x7662") ;; <CJK>
       (?$(0[|(B . "0x7665") ;; <CJK>
       (?$(0[}(B . "0x7926") ;; <CJK>
       (?$(0[~(B . "0x792A") ;; <CJK>
       (?$(0\!(B . "0x792C") ;; <CJK>
       (?$(0\"(B . "0x792B") ;; <CJK>
       (?$(0\#(B . "0x7AC7") ;; <CJK>
       (?$(0\$(B . "0x7AF6") ;; <CJK>
       (?$(0\%(B . "0x7C4C") ;; <CJK>
       (?$(0\&(B . "0x7C43") ;; <CJK>
       (?$(0\'(B . "0x7C4D") ;; <CJK>
       (?$(0\((B . "0x7CEF") ;; <CJK>
       (?$(0\)(B . "0x7CF0") ;; <CJK>
       (?$(0\*(B . "0x8FAE") ;; <CJK>
       (?$(0\+(B . "0x7E7D") ;; <CJK>
       (?$(0\,(B . "0x7E7C") ;; <CJK>
       (?$(0\-(B . "0x7E82") ;; <CJK>
       (?$(0\.(B . "0x7F4C") ;; <CJK>
       (?$(0\/(B . "0x8000") ;; <CJK>
       (?$(0\0(B . "0x81DA") ;; <CJK>
       (?$(0\1(B . "0x8266") ;; <CJK>
       (?$(0\2(B . "0x85FB") ;; <CJK>
       (?$(0\3(B . "0x85F9") ;; <CJK>
       (?$(0\4(B . "0x8611") ;; <CJK>
       (?$(0\5(B . "0x85FA") ;; <CJK>
       (?$(0\6(B . "0x8606") ;; <CJK>
       (?$(0\7(B . "0x860B") ;; <CJK>
       (?$(0\8(B . "0x8607") ;; <CJK>
       (?$(0\9(B . "0x860A") ;; <CJK>
       (?$(0\:(B . "0x8814") ;; <CJK>
       (?$(0\;(B . "0x8815") ;; <CJK>
       (?$(0\<(B . "0x8964") ;; <CJK>
       (?$(0\=(B . "0x89BA") ;; <CJK>
       (?$(0\>(B . "0x89F8") ;; <CJK>
       (?$(0\?(B . "0x8B70") ;; <CJK>
       (?$(0\@(B . "0x8B6C") ;; <CJK>
       (?$(0\A(B . "0x8B66") ;; <CJK>
       (?$(0\B(B . "0x8B6F") ;; <CJK>
       (?$(0\C(B . "0x8B5F") ;; <CJK>
       (?$(0\D(B . "0x8B6B") ;; <CJK>
       (?$(0\E(B . "0x8D0F") ;; <CJK>
       (?$(0\F(B . "0x8D0D") ;; <CJK>
       (?$(0\G(B . "0x8E89") ;; <CJK>
       (?$(0\H(B . "0x8E81") ;; <CJK>
       (?$(0\I(B . "0x8E85") ;; <CJK>
       (?$(0\J(B . "0x8E82") ;; <CJK>
       (?$(0\K(B . "0x91B4") ;; <CJK>
       (?$(0\L(B . "0x91CB") ;; <CJK>
       (?$(0\M(B . "0x9418") ;; <CJK>
       (?$(0\N(B . "0x9403") ;; <CJK>
       (?$(0\O(B . "0x93FD") ;; <CJK>
       (?$(0\P(B . "0x95E1") ;; <CJK>
       (?$(0\Q(B . "0x9730") ;; <CJK>
       (?$(0\R(B . "0x98C4") ;; <CJK>
       (?$(0\S(B . "0x9952") ;; <CJK>
       (?$(0\T(B . "0x9951") ;; <CJK>
       (?$(0\U(B . "0x99A8") ;; <CJK>
       (?$(0\V(B . "0x9A2B") ;; <CJK>
       (?$(0\W(B . "0x9A30") ;; <CJK>
       (?$(0\X(B . "0x9A37") ;; <CJK>
       (?$(0\Y(B . "0x9A35") ;; <CJK>
       (?$(0\Z(B . "0x9C13") ;; <CJK>
       (?$(0\[(B . "0x9C0D") ;; <CJK>
       (?$(0\\(B . "0x9E79") ;; <CJK>
       (?$(0\](B . "0x9EB5") ;; <CJK>
       (?$(0\^(B . "0x9EE8") ;; <CJK>
       (?$(0\_(B . "0x9F2F") ;; <CJK>
       (?$(0\`(B . "0x9F5F") ;; <CJK>
       (?$(0\a(B . "0x9F63") ;; <CJK>
       (?$(0\b(B . "0x9F61") ;; <CJK>
       (?$(0\c(B . "0x5137") ;; <CJK>
       (?$(0\d(B . "0x5138") ;; <CJK>
       (?$(0\e(B . "0x56C1") ;; <CJK>
       (?$(0\f(B . "0x56C0") ;; <CJK>
       (?$(0\g(B . "0x56C2") ;; <CJK>
       (?$(0\h(B . "0x5914") ;; <CJK>
       (?$(0\i(B . "0x5C6C") ;; <CJK>
       (?$(0\j(B . "0x5DCD") ;; <CJK>
       (?$(0\k(B . "0x61FC") ;; <CJK>
       (?$(0\l(B . "0x61FE") ;; <CJK>
       (?$(0\m(B . "0x651D") ;; <CJK>
       (?$(0\n(B . "0x651C") ;; <CJK>
       (?$(0\o(B . "0x6595") ;; <CJK>
       (?$(0\p(B . "0x66E9") ;; <CJK>
       (?$(0\q(B . "0x6AFB") ;; <CJK>
       (?$(0\r(B . "0x6B04") ;; <CJK>
       (?$(0\s(B . "0x6AFA") ;; <CJK>
       (?$(0\t(B . "0x6BB2") ;; <CJK>
       (?$(0\u(B . "0x704C") ;; <CJK>
       (?$(0\v(B . "0x721B") ;; <CJK>
       (?$(0\w(B . "0x72A7") ;; <CJK>
       (?$(0\x(B . "0x74D6") ;; <CJK>
       (?$(0\y(B . "0x74D4") ;; <CJK>
       (?$(0\z(B . "0x7669") ;; <CJK>
       (?$(0\{(B . "0x77D3") ;; <CJK>
       (?$(0\|(B . "0x7C50") ;; <CJK>
       (?$(0\}(B . "0x7E8F") ;; <CJK>
       (?$(0\~(B . "0x7E8C") ;; <CJK>
       (?$(0]!(B . "0x7FBC") ;; <CJK>
       (?$(0]"(B . "0x8617") ;; <CJK>
       (?$(0]#(B . "0x862D") ;; <CJK>
       (?$(0]$(B . "0x861A") ;; <CJK>
       (?$(0]%(B . "0x8823") ;; <CJK>
       (?$(0]&(B . "0x8822") ;; <CJK>
       (?$(0]'(B . "0x8821") ;; <CJK>
       (?$(0]((B . "0x881F") ;; <CJK>
       (?$(0])(B . "0x896A") ;; <CJK>
       (?$(0]*(B . "0x896C") ;; <CJK>
       (?$(0]+(B . "0x89BD") ;; <CJK>
       (?$(0],(B . "0x8B74") ;; <CJK>
       (?$(0]-(B . "0x8B77") ;; <CJK>
       (?$(0].(B . "0x8B7D") ;; <CJK>
       (?$(0]/(B . "0x8D13") ;; <CJK>
       (?$(0]0(B . "0x8E8A") ;; <CJK>
       (?$(0]1(B . "0x8E8D") ;; <CJK>
       (?$(0]2(B . "0x8E8B") ;; <CJK>
       (?$(0]3(B . "0x8F5F") ;; <CJK>
       (?$(0]4(B . "0x8FAF") ;; <CJK>
       (?$(0]5(B . "0x91BA") ;; <CJK>
       (?$(0]6(B . "0x942E") ;; <CJK>
       (?$(0]7(B . "0x9433") ;; <CJK>
       (?$(0]8(B . "0x9435") ;; <CJK>
       (?$(0]9(B . "0x943A") ;; <CJK>
       (?$(0]:(B . "0x9438") ;; <CJK>
       (?$(0];(B . "0x9432") ;; <CJK>
       (?$(0]<(B . "0x942B") ;; <CJK>
       (?$(0]=(B . "0x95E2") ;; <CJK>
       (?$(0]>(B . "0x9738") ;; <CJK>
       (?$(0]?(B . "0x9739") ;; <CJK>
       (?$(0]@(B . "0x9732") ;; <CJK>
       (?$(0]A(B . "0x97FF") ;; <CJK>
       (?$(0]B(B . "0x9867") ;; <CJK>
       (?$(0]C(B . "0x9865") ;; <CJK>
       (?$(0]D(B . "0x9957") ;; <CJK>
       (?$(0]E(B . "0x9A45") ;; <CJK>
       (?$(0]F(B . "0x9A43") ;; <CJK>
       (?$(0]G(B . "0x9A40") ;; <CJK>
       (?$(0]H(B . "0x9A3E") ;; <CJK>
       (?$(0]I(B . "0x9ACF") ;; <CJK>
       (?$(0]J(B . "0x9B54") ;; <CJK>
       (?$(0]K(B . "0x9B51") ;; <CJK>
       (?$(0]L(B . "0x9C2D") ;; <CJK>
       (?$(0]M(B . "0x9C25") ;; <CJK>
       (?$(0]N(B . "0x9DAF") ;; <CJK>
       (?$(0]O(B . "0x9DB4") ;; <CJK>
       (?$(0]P(B . "0x9DC2") ;; <CJK>
       (?$(0]Q(B . "0x9DB8") ;; <CJK>
       (?$(0]R(B . "0x9E9D") ;; <CJK>
       (?$(0]S(B . "0x9EEF") ;; <CJK>
       (?$(0]T(B . "0x9F19") ;; <CJK>
       (?$(0]U(B . "0x9F5C") ;; <CJK>
       (?$(0]V(B . "0x9F66") ;; <CJK>
       (?$(0]W(B . "0x9F67") ;; <CJK>
       (?$(0]X(B . "0x513C") ;; <CJK>
       (?$(0]Y(B . "0x513B") ;; <CJK>
       (?$(0]Z(B . "0x56C8") ;; <CJK>
       (?$(0][(B . "0x56CA") ;; <CJK>
       (?$(0]\(B . "0x56C9") ;; <CJK>
       (?$(0]](B . "0x5B7F") ;; <CJK>
       (?$(0]^(B . "0x5DD4") ;; <CJK>
       (?$(0]_(B . "0x5DD2") ;; <CJK>
       (?$(0]`(B . "0x5F4E") ;; <CJK>
       (?$(0]a(B . "0x61FF") ;; <CJK>
       (?$(0]b(B . "0x6524") ;; <CJK>
       (?$(0]c(B . "0x6B0A") ;; <CJK>
       (?$(0]d(B . "0x6B61") ;; <CJK>
       (?$(0]e(B . "0x7051") ;; <CJK>
       (?$(0]f(B . "0x7058") ;; <CJK>
       (?$(0]g(B . "0x7380") ;; <CJK>
       (?$(0]h(B . "0x74E4") ;; <CJK>
       (?$(0]i(B . "0x758A") ;; <CJK>
       (?$(0]j(B . "0x766E") ;; <CJK>
       (?$(0]k(B . "0x766C") ;; <CJK>
       (?$(0]l(B . "0x79B3") ;; <CJK>
       (?$(0]m(B . "0x7C60") ;; <CJK>
       (?$(0]n(B . "0x7C5F") ;; <CJK>
       (?$(0]o(B . "0x807E") ;; <CJK>
       (?$(0]p(B . "0x807D") ;; <CJK>
       (?$(0]q(B . "0x81DF") ;; <CJK>
       (?$(0]r(B . "0x8972") ;; <CJK>
       (?$(0]s(B . "0x896F") ;; <CJK>
       (?$(0]t(B . "0x89FC") ;; <CJK>
       (?$(0]u(B . "0x8B80") ;; <CJK>
       (?$(0]v(B . "0x8D16") ;; <CJK>
       (?$(0]w(B . "0x8D17") ;; <CJK>
       (?$(0]x(B . "0x8E91") ;; <CJK>
       (?$(0]y(B . "0x8E93") ;; <CJK>
       (?$(0]z(B . "0x8F61") ;; <CJK>
       (?$(0]{(B . "0x9148") ;; <CJK>
       (?$(0]|(B . "0x9444") ;; <CJK>
       (?$(0]}(B . "0x9451") ;; <CJK>
       (?$(0]~(B . "0x9452") ;; <CJK>
       (?$(0^!(B . "0x973D") ;; <CJK>
       (?$(0^"(B . "0x973E") ;; <CJK>
       (?$(0^#(B . "0x97C3") ;; <CJK>
       (?$(0^$(B . "0x97C1") ;; <CJK>
       (?$(0^%(B . "0x986B") ;; <CJK>
       (?$(0^&(B . "0x9955") ;; <CJK>
       (?$(0^'(B . "0x9A55") ;; <CJK>
       (?$(0^((B . "0x9A4D") ;; <CJK>
       (?$(0^)(B . "0x9AD2") ;; <CJK>
       (?$(0^*(B . "0x9B1A") ;; <CJK>
       (?$(0^+(B . "0x9C49") ;; <CJK>
       (?$(0^,(B . "0x9C31") ;; <CJK>
       (?$(0^-(B . "0x9C3E") ;; <CJK>
       (?$(0^.(B . "0x9C3B") ;; <CJK>
       (?$(0^/(B . "0x9DD3") ;; <CJK>
       (?$(0^0(B . "0x9DD7") ;; <CJK>
       (?$(0^1(B . "0x9F34") ;; <CJK>
       (?$(0^2(B . "0x9F6C") ;; <CJK>
       (?$(0^3(B . "0x9F6A") ;; <CJK>
       (?$(0^4(B . "0x9F94") ;; <CJK>
       (?$(0^5(B . "0x56CC") ;; <CJK>
       (?$(0^6(B . "0x5DD6") ;; <CJK>
       (?$(0^7(B . "0x6200") ;; <CJK>
       (?$(0^8(B . "0x6523") ;; <CJK>
       (?$(0^9(B . "0x652B") ;; <CJK>
       (?$(0^:(B . "0x652A") ;; <CJK>
       (?$(0^;(B . "0x66EC") ;; <CJK>
       (?$(0^<(B . "0x6B10") ;; <CJK>
       (?$(0^=(B . "0x74DA") ;; <CJK>
       (?$(0^>(B . "0x7ACA") ;; <CJK>
       (?$(0^?(B . "0x7C64") ;; <CJK>
       (?$(0^@(B . "0x7C63") ;; <CJK>
       (?$(0^A(B . "0x7C65") ;; <CJK>
       (?$(0^B(B . "0x7E93") ;; <CJK>
       (?$(0^C(B . "0x7E96") ;; <CJK>
       (?$(0^D(B . "0x7E94") ;; <CJK>
       (?$(0^E(B . "0x81E2") ;; <CJK>
       (?$(0^F(B . "0x8638") ;; <CJK>
       (?$(0^G(B . "0x863F") ;; <CJK>
       (?$(0^H(B . "0x8831") ;; <CJK>
       (?$(0^I(B . "0x8B8A") ;; <CJK>
       (?$(0^J(B . "0x9090") ;; <CJK>
       (?$(0^K(B . "0x908F") ;; <CJK>
       (?$(0^L(B . "0x9463") ;; <CJK>
       (?$(0^M(B . "0x9460") ;; <CJK>
       (?$(0^N(B . "0x9464") ;; <CJK>
       (?$(0^O(B . "0x9768") ;; <CJK>
       (?$(0^P(B . "0x986F") ;; <CJK>
       (?$(0^Q(B . "0x995C") ;; <CJK>
       (?$(0^R(B . "0x9A5A") ;; <CJK>
       (?$(0^S(B . "0x9A5B") ;; <CJK>
       (?$(0^T(B . "0x9A57") ;; <CJK>
       (?$(0^U(B . "0x9AD3") ;; <CJK>
       (?$(0^V(B . "0x9AD4") ;; <CJK>
       (?$(0^W(B . "0x9AD1") ;; <CJK>
       (?$(0^X(B . "0x9C54") ;; <CJK>
       (?$(0^Y(B . "0x9C57") ;; <CJK>
       (?$(0^Z(B . "0x9C56") ;; <CJK>
       (?$(0^[(B . "0x9DE5") ;; <CJK>
       (?$(0^\(B . "0x9E9F") ;; <CJK>
       (?$(0^](B . "0x9EF4") ;; <CJK>
       (?$(0^^(B . "0x56D1") ;; <CJK>
       (?$(0^_(B . "0x58E9") ;; <CJK>
       (?$(0^`(B . "0x652C") ;; <CJK>
       (?$(0^a(B . "0x705E") ;; <CJK>
       (?$(0^b(B . "0x7671") ;; <CJK>
       (?$(0^c(B . "0x7672") ;; <CJK>
       (?$(0^d(B . "0x77D7") ;; <CJK>
       (?$(0^e(B . "0x7F50") ;; <CJK>
       (?$(0^f(B . "0x7F88") ;; <CJK>
       (?$(0^g(B . "0x8836") ;; <CJK>
       (?$(0^h(B . "0x8839") ;; <CJK>
       (?$(0^i(B . "0x8862") ;; <CJK>
       (?$(0^j(B . "0x8B93") ;; <CJK>
       (?$(0^k(B . "0x8B92") ;; <CJK>
       (?$(0^l(B . "0x8B96") ;; <CJK>
       (?$(0^m(B . "0x8277") ;; <CJK>
       (?$(0^n(B . "0x8D1B") ;; <CJK>
       (?$(0^o(B . "0x91C0") ;; <CJK>
       (?$(0^p(B . "0x946A") ;; <CJK>
       (?$(0^q(B . "0x9742") ;; <CJK>
       (?$(0^r(B . "0x9748") ;; <CJK>
       (?$(0^s(B . "0x9744") ;; <CJK>
       (?$(0^t(B . "0x97C6") ;; <CJK>
       (?$(0^u(B . "0x9870") ;; <CJK>
       (?$(0^v(B . "0x9A5F") ;; <CJK>
       (?$(0^w(B . "0x9B22") ;; <CJK>
       (?$(0^x(B . "0x9B58") ;; <CJK>
       (?$(0^y(B . "0x9C5F") ;; <CJK>
       (?$(0^z(B . "0x9DF9") ;; <CJK>
       (?$(0^{(B . "0x9DFA") ;; <CJK>
       (?$(0^|(B . "0x9E7C") ;; <CJK>
       (?$(0^}(B . "0x9E7D") ;; <CJK>
       (?$(0^~(B . "0x9F07") ;; <CJK>
       (?$(0_!(B . "0x9F77") ;; <CJK>
       (?$(0_"(B . "0x9F72") ;; <CJK>
       (?$(0_#(B . "0x5EF3") ;; <CJK>
       (?$(0_$(B . "0x6B16") ;; <CJK>
       (?$(0_%(B . "0x7063") ;; <CJK>
       (?$(0_&(B . "0x7C6C") ;; <CJK>
       (?$(0_'(B . "0x7C6E") ;; <CJK>
       (?$(0_((B . "0x883B") ;; <CJK>
       (?$(0_)(B . "0x89C0") ;; <CJK>
       (?$(0_*(B . "0x8EA1") ;; <CJK>
       (?$(0_+(B . "0x91C1") ;; <CJK>
       (?$(0_,(B . "0x9472") ;; <CJK>
       (?$(0_-(B . "0x9470") ;; <CJK>
       (?$(0_.(B . "0x9871") ;; <CJK>
       (?$(0_/(B . "0x995E") ;; <CJK>
       (?$(0_0(B . "0x9AD6") ;; <CJK>
       (?$(0_1(B . "0x9B23") ;; <CJK>
       (?$(0_2(B . "0x9ECC") ;; <CJK>
       (?$(0_3(B . "0x7064") ;; <CJK>
       (?$(0_4(B . "0x77DA") ;; <CJK>
       (?$(0_5(B . "0x8B9A") ;; <CJK>
       (?$(0_6(B . "0x9477") ;; <CJK>
       (?$(0_7(B . "0x97C9") ;; <CJK>
       (?$(0_8(B . "0x9A62") ;; <CJK>
       (?$(0_9(B . "0x9A65") ;; <CJK>
       (?$(0_:(B . "0x7E9C") ;; <CJK>
       (?$(0_;(B . "0x8B9C") ;; <CJK>
       (?$(0_<(B . "0x8EAA") ;; <CJK>
       (?$(0_=(B . "0x91C5") ;; <CJK>
       (?$(0_>(B . "0x947D") ;; <CJK>
       (?$(0_?(B . "0x947E") ;; <CJK>
       (?$(0_@(B . "0x947C") ;; <CJK>
       (?$(0_A(B . "0x9C77") ;; <CJK>
       (?$(0_B(B . "0x9C78") ;; <CJK>
       (?$(0_C(B . "0x9EF7") ;; <CJK>
       (?$(0_D(B . "0x8C54") ;; <CJK>
       (?$(0_E(B . "0x947F") ;; <CJK>
       (?$(0_F(B . "0x9E1A") ;; <CJK>
       (?$(0_G(B . "0x7228") ;; <CJK>
       (?$(0_H(B . "0x9A6A") ;; <CJK>
       (?$(0_I(B . "0x9B31") ;; <CJK>
       (?$(0_J(B . "0x9E1B") ;; <CJK>
       (?$(0_K(B . "0x9E1E") ;; <CJK>
       (?$(0_L(B . "0x7C72") ;; <CJK>
       (?$(0_M(B . "0x30FE") ;; KATAKANA VOICED ITERATION MARK
       (?$(0_N(B . "0x309D") ;; HIRAGANA ITERATION MARK
       (?$(0_O(B . "0x309E") ;; HIRAGANA VOICED ITERATION MARK
       (?$(0_P(B . "0x3005") ;; IDEOGRAPHIC ITERATION MARK
       (?$(0_Q(B . "0x3041") ;; HIRAGANA LETTER SMALL A
       (?$(0_R(B . "0x3042") ;; HIRAGANA LETTER A
       (?$(0_S(B . "0x3043") ;; HIRAGANA LETTER SMALL I
       (?$(0_T(B . "0x3044") ;; HIRAGANA LETTER I
       (?$(0_U(B . "0x3045") ;; HIRAGANA LETTER SMALL U
       (?$(0_V(B . "0x3046") ;; HIRAGANA LETTER U
       (?$(0_W(B . "0x3047") ;; HIRAGANA LETTER SMALL E
       (?$(0_X(B . "0x3048") ;; HIRAGANA LETTER E
       (?$(0_Y(B . "0x3049") ;; HIRAGANA LETTER SMALL O
       (?$(0_Z(B . "0x304A") ;; HIRAGANA LETTER O
       (?$(0_[(B . "0x304B") ;; HIRAGANA LETTER KA
       (?$(0_\(B . "0x304C") ;; HIRAGANA LETTER GA
       (?$(0_](B . "0x304D") ;; HIRAGANA LETTER KI
       (?$(0_^(B . "0x304E") ;; HIRAGANA LETTER GI
       (?$(0__(B . "0x304F") ;; HIRAGANA LETTER KU
       (?$(0_`(B . "0x3050") ;; HIRAGANA LETTER GU
       (?$(0_a(B . "0x3051") ;; HIRAGANA LETTER KE
       (?$(0_b(B . "0x3052") ;; HIRAGANA LETTER GE
       (?$(0_c(B . "0x3053") ;; HIRAGANA LETTER KO
       (?$(0_d(B . "0x3054") ;; HIRAGANA LETTER GO
       (?$(0_e(B . "0x3055") ;; HIRAGANA LETTER SA
       (?$(0_f(B . "0x3056") ;; HIRAGANA LETTER ZA
       (?$(0_g(B . "0x3057") ;; HIRAGANA LETTER SI
       (?$(0_h(B . "0x3058") ;; HIRAGANA LETTER ZI
       (?$(0_i(B . "0x3059") ;; HIRAGANA LETTER SU
       (?$(0_j(B . "0x305A") ;; HIRAGANA LETTER ZU
       (?$(0_k(B . "0x305B") ;; HIRAGANA LETTER SE
       (?$(0_l(B . "0x305C") ;; HIRAGANA LETTER ZE
       (?$(0_m(B . "0x305D") ;; HIRAGANA LETTER SO
       (?$(0_n(B . "0x305E") ;; HIRAGANA LETTER ZO
       (?$(0_o(B . "0x305F") ;; HIRAGANA LETTER TA
       (?$(0_p(B . "0x3060") ;; HIRAGANA LETTER DA
       (?$(0_q(B . "0x3061") ;; HIRAGANA LETTER TI
       (?$(0_r(B . "0x3062") ;; HIRAGANA LETTER DI
       (?$(0_s(B . "0x3063") ;; HIRAGANA LETTER SMALL TU
       (?$(0_t(B . "0x3064") ;; HIRAGANA LETTER TU
       (?$(0_u(B . "0x3065") ;; HIRAGANA LETTER DU
       (?$(0_v(B . "0x3066") ;; HIRAGANA LETTER TE
       (?$(0_w(B . "0x3067") ;; HIRAGANA LETTER DE
       (?$(0_x(B . "0x3068") ;; HIRAGANA LETTER TO
       (?$(0_y(B . "0x3069") ;; HIRAGANA LETTER DO
       (?$(0_z(B . "0x306A") ;; HIRAGANA LETTER NA
       (?$(0_{(B . "0x306B") ;; HIRAGANA LETTER NI
       (?$(0_|(B . "0x306C") ;; HIRAGANA LETTER NU
       (?$(0_}(B . "0x306D") ;; HIRAGANA LETTER NE
       (?$(0_~(B . "0x306E") ;; HIRAGANA LETTER NO
       (?$(0`!(B . "0x306F") ;; HIRAGANA LETTER HA
       (?$(0`"(B . "0x3070") ;; HIRAGANA LETTER BA
       (?$(0`#(B . "0x3071") ;; HIRAGANA LETTER PA
       (?$(0`$(B . "0x3072") ;; HIRAGANA LETTER HI
       (?$(0`%(B . "0x3073") ;; HIRAGANA LETTER BI
       (?$(0`&(B . "0x3074") ;; HIRAGANA LETTER PI
       (?$(0`'(B . "0x3075") ;; HIRAGANA LETTER HU
       (?$(0`((B . "0x3076") ;; HIRAGANA LETTER BU
       (?$(0`)(B . "0x3077") ;; HIRAGANA LETTER PU
       (?$(0`*(B . "0x3078") ;; HIRAGANA LETTER HE
       (?$(0`+(B . "0x3079") ;; HIRAGANA LETTER BE
       (?$(0`,(B . "0x307A") ;; HIRAGANA LETTER PE
       (?$(0`-(B . "0x307B") ;; HIRAGANA LETTER HO
       (?$(0`.(B . "0x307C") ;; HIRAGANA LETTER BO
       (?$(0`/(B . "0x307D") ;; HIRAGANA LETTER PO
       (?$(0`0(B . "0x307E") ;; HIRAGANA LETTER MA
       (?$(0`1(B . "0x307F") ;; HIRAGANA LETTER MI
       (?$(0`2(B . "0x3080") ;; HIRAGANA LETTER MU
       (?$(0`3(B . "0x3081") ;; HIRAGANA LETTER ME
       (?$(0`4(B . "0x3082") ;; HIRAGANA LETTER MO
       (?$(0`5(B . "0x3083") ;; HIRAGANA LETTER SMALL YA
       (?$(0`6(B . "0x3084") ;; HIRAGANA LETTER YA
       (?$(0`7(B . "0x3085") ;; HIRAGANA LETTER SMALL YU
       (?$(0`8(B . "0x3086") ;; HIRAGANA LETTER YU
       (?$(0`9(B . "0x3087") ;; HIRAGANA LETTER SMALL YO
       (?$(0`:(B . "0x3088") ;; HIRAGANA LETTER YO
       (?$(0`;(B . "0x3089") ;; HIRAGANA LETTER RA
       (?$(0`<(B . "0x308A") ;; HIRAGANA LETTER RI
       (?$(0`=(B . "0x308B") ;; HIRAGANA LETTER RU
       (?$(0`>(B . "0x308C") ;; HIRAGANA LETTER RE
       (?$(0`?(B . "0x308D") ;; HIRAGANA LETTER RO
       (?$(0`@(B . "0x308E") ;; HIRAGANA LETTER SMALL WA
       (?$(0`A(B . "0x308F") ;; HIRAGANA LETTER WA
       (?$(0`B(B . "0x3090") ;; HIRAGANA LETTER WI
       (?$(0`C(B . "0x3091") ;; HIRAGANA LETTER WE
       (?$(0`D(B . "0x3092") ;; HIRAGANA LETTER WO
       (?$(0`E(B . "0x3093") ;; HIRAGANA LETTER N
       (?$(0`F(B . "0x30A1") ;; KATAKANA LETTER SMALL A
       (?$(0`G(B . "0x30A2") ;; KATAKANA LETTER A
       (?$(0`H(B . "0x30A3") ;; KATAKANA LETTER SMALL I
       (?$(0`I(B . "0x30A4") ;; KATAKANA LETTER I
       (?$(0`J(B . "0x30A5") ;; KATAKANA LETTER SMALL U
       (?$(0`K(B . "0x30A6") ;; KATAKANA LETTER U
       (?$(0`L(B . "0x30A7") ;; KATAKANA LETTER SMALL E
       (?$(0`M(B . "0x30A8") ;; KATAKANA LETTER E
       (?$(0`N(B . "0x30A9") ;; KATAKANA LETTER SMALL O
       (?$(0`O(B . "0x30AA") ;; KATAKANA LETTER O
       (?$(0`P(B . "0x30AB") ;; KATAKANA LETTER KA
       (?$(0`Q(B . "0x30AC") ;; KATAKANA LETTER GA
       (?$(0`R(B . "0x30AD") ;; KATAKANA LETTER KI
       (?$(0`S(B . "0x30AE") ;; KATAKANA LETTER GI
       (?$(0`T(B . "0x30AF") ;; KATAKANA LETTER KU
       (?$(0`U(B . "0x30B0") ;; KATAKANA LETTER GU
       (?$(0`V(B . "0x30B1") ;; KATAKANA LETTER KE
       (?$(0`W(B . "0x30B2") ;; KATAKANA LETTER GE
       (?$(0`X(B . "0x30B3") ;; KATAKANA LETTER KO
       (?$(0`Y(B . "0x30B4") ;; KATAKANA LETTER GO
       (?$(0`Z(B . "0x30B5") ;; KATAKANA LETTER SA
       (?$(0`[(B . "0x30B6") ;; KATAKANA LETTER ZA
       (?$(0`\(B . "0x30B7") ;; KATAKANA LETTER SI
       (?$(0`](B . "0x30B8") ;; KATAKANA LETTER ZI
       (?$(0`^(B . "0x30B9") ;; KATAKANA LETTER SU
       (?$(0`_(B . "0x30BA") ;; KATAKANA LETTER ZU
       (?$(0``(B . "0x30BB") ;; KATAKANA LETTER SE
       (?$(0`a(B . "0x30BC") ;; KATAKANA LETTER ZE
       (?$(0`b(B . "0x30BD") ;; KATAKANA LETTER SO
       (?$(0`c(B . "0x30BE") ;; KATAKANA LETTER ZO
       (?$(0`d(B . "0x30BF") ;; KATAKANA LETTER TA
       (?$(0`e(B . "0x30C0") ;; KATAKANA LETTER DA
       (?$(0`f(B . "0x30C1") ;; KATAKANA LETTER TI
       (?$(0`g(B . "0x30C2") ;; KATAKANA LETTER DI
       (?$(0`h(B . "0x30C3") ;; KATAKANA LETTER SMALL TU
       (?$(0`i(B . "0x30C4") ;; KATAKANA LETTER TU
       (?$(0`j(B . "0x30C5") ;; KATAKANA LETTER DU
       (?$(0`k(B . "0x30C6") ;; KATAKANA LETTER TE
       (?$(0`l(B . "0x30C7") ;; KATAKANA LETTER DE
       (?$(0`m(B . "0x30C8") ;; KATAKANA LETTER TO
       (?$(0`n(B . "0x30C9") ;; KATAKANA LETTER DO
       (?$(0`o(B . "0x30CA") ;; KATAKANA LETTER NA
       (?$(0`p(B . "0x30CB") ;; KATAKANA LETTER NI
       (?$(0`q(B . "0x30CC") ;; KATAKANA LETTER NU
       (?$(0`r(B . "0x30CD") ;; KATAKANA LETTER NE
       (?$(0`s(B . "0x30CE") ;; KATAKANA LETTER NO
       (?$(0`t(B . "0x30CF") ;; KATAKANA LETTER HA
       (?$(0`u(B . "0x30D0") ;; KATAKANA LETTER BA
       (?$(0`v(B . "0x30D1") ;; KATAKANA LETTER PA
       (?$(0`w(B . "0x30D2") ;; KATAKANA LETTER HI
       (?$(0`x(B . "0x30D3") ;; KATAKANA LETTER BI
       (?$(0`y(B . "0x30D4") ;; KATAKANA LETTER PI
       (?$(0`z(B . "0x30D5") ;; KATAKANA LETTER HU
       (?$(0`{(B . "0x30D6") ;; KATAKANA LETTER BU
       (?$(0`|(B . "0x30D7") ;; KATAKANA LETTER PU
       (?$(0`}(B . "0x30D8") ;; KATAKANA LETTER HE
       (?$(0`~(B . "0x30D9") ;; KATAKANA LETTER BE
       (?$(0a!(B . "0x30DA") ;; KATAKANA LETTER PE
       (?$(0a"(B . "0x30DB") ;; KATAKANA LETTER HO
       (?$(0a#(B . "0x30DC") ;; KATAKANA LETTER BO
       (?$(0a$(B . "0x30DD") ;; KATAKANA LETTER PO
       (?$(0a%(B . "0x30DE") ;; KATAKANA LETTER MA
       (?$(0a&(B . "0x30DF") ;; KATAKANA LETTER MI
       (?$(0a'(B . "0x30E0") ;; KATAKANA LETTER MU
       (?$(0a((B . "0x30E1") ;; KATAKANA LETTER ME
       (?$(0a)(B . "0x30E2") ;; KATAKANA LETTER MO
       (?$(0a*(B . "0x30E3") ;; KATAKANA LETTER SMALL YA
       (?$(0a+(B . "0x30E4") ;; KATAKANA LETTER YA
       (?$(0a,(B . "0x30E5") ;; KATAKANA LETTER SMALL YU
       (?$(0a-(B . "0x30E6") ;; KATAKANA LETTER YU
       (?$(0a.(B . "0x30E7") ;; KATAKANA LETTER SMALL YO
       (?$(0a/(B . "0x30E8") ;; KATAKANA LETTER YO
       (?$(0a0(B . "0x30E9") ;; KATAKANA LETTER RA
       (?$(0a1(B . "0x30EA") ;; KATAKANA LETTER RI
       (?$(0a2(B . "0x30EB") ;; KATAKANA LETTER RU
       (?$(0a3(B . "0x30EC") ;; KATAKANA LETTER RE
       (?$(0a4(B . "0x30ED") ;; KATAKANA LETTER RO
       (?$(0a5(B . "0x30EE") ;; KATAKANA LETTER SMALL WA
       (?$(0a6(B . "0x30EF") ;; KATAKANA LETTER WA
       (?$(0a7(B . "0x30F0") ;; KATAKANA LETTER WI
       (?$(0a8(B . "0x30F1") ;; KATAKANA LETTER WE
       (?$(0a9(B . "0x30F2") ;; KATAKANA LETTER WO
       (?$(0a:(B . "0x30F3") ;; KATAKANA LETTER N
       (?$(0a;(B . "0x30F4") ;; KATAKANA LETTER VU
       (?$(0a<(B . "0x30F5") ;; KATAKANA LETTER SMALL KA
       (?$(0a=(B . "0x30F6") ;; KATAKANA LETTER SMALL KE
       (?$(0a>(B . "0x0414") ;; CYRILLIC CAPITAL LETTER DE
       (?$(0a?(B . "0x0415") ;; CYRILLIC CAPITAL LETTER IE
       (?$(0a@(B . "0x0401") ;; CYRILLIC CAPITAL LETTER IO
       (?$(0aA(B . "0x0416") ;; CYRILLIC CAPITAL LETTER ZHE
       (?$(0aB(B . "0x0417") ;; CYRILLIC CAPITAL LETTER ZE
       (?$(0aC(B . "0x0418") ;; CYRILLIC CAPITAL LETTER I
       (?$(0aD(B . "0x0419") ;; CYRILLIC CAPITAL LETTER SHORT I
       (?$(0aE(B . "0x041A") ;; CYRILLIC CAPITAL LETTER KA
       (?$(0aF(B . "0x041B") ;; CYRILLIC CAPITAL LETTER EL
       (?$(0aG(B . "0x041C") ;; CYRILLIC CAPITAL LETTER EM
       (?$(0aH(B . "0x0423") ;; CYRILLIC CAPITAL LETTER U
       (?$(0aI(B . "0x0424") ;; CYRILLIC CAPITAL LETTER EF
       (?$(0aJ(B . "0x0425") ;; CYRILLIC CAPITAL LETTER HA
       (?$(0aK(B . "0x0426") ;; CYRILLIC CAPITAL LETTER TSE
       (?$(0aL(B . "0x0427") ;; CYRILLIC CAPITAL LETTER CHE
       (?$(0aM(B . "0x0428") ;; CYRILLIC CAPITAL LETTER SHA
       (?$(0aN(B . "0x0429") ;; CYRILLIC CAPITAL LETTER SHCHA
       (?$(0aO(B . "0x042A") ;; CYRILLIC CAPITAL LETTER HARD SIGN
       (?$(0aP(B . "0x042B") ;; CYRILLIC CAPITAL LETTER YERU
       (?$(0aQ(B . "0x042C") ;; CYRILLIC CAPITAL LETTER SOFT SIGN
       (?$(0aR(B . "0x042D") ;; CYRILLIC CAPITAL LETTER E
       (?$(0aS(B . "0x042E") ;; CYRILLIC CAPITAL LETTER YU
       (?$(0aT(B . "0x042F") ;; CYRILLIC CAPITAL LETTER YA
       (?$(0aU(B . "0x0430") ;; CYRILLIC SMALL LETTER A
       (?$(0aV(B . "0x0431") ;; CYRILLIC SMALL LETTER BE
       (?$(0aW(B . "0x0432") ;; CYRILLIC SMALL LETTER VE
       (?$(0aX(B . "0x0433") ;; CYRILLIC SMALL LETTER GHE
       (?$(0aY(B . "0x0434") ;; CYRILLIC SMALL LETTER DE
       (?$(0aZ(B . "0x0435") ;; CYRILLIC SMALL LETTER IE
       (?$(0a[(B . "0x0451") ;; CYRILLIC SMALL LETTER IO
       (?$(0a\(B . "0x0436") ;; CYRILLIC SMALL LETTER ZHE
       (?$(0a](B . "0x0437") ;; CYRILLIC SMALL LETTER ZE
       (?$(0a^(B . "0x0438") ;; CYRILLIC SMALL LETTER I
       (?$(0a_(B . "0x0439") ;; CYRILLIC SMALL LETTER SHORT I
       (?$(0a`(B . "0x043A") ;; CYRILLIC SMALL LETTER KA
       (?$(0aa(B . "0x043B") ;; CYRILLIC SMALL LETTER EL
       (?$(0ab(B . "0x043C") ;; CYRILLIC SMALL LETTER EM
       (?$(0ac(B . "0x043D") ;; CYRILLIC SMALL LETTER EN
       (?$(0ad(B . "0x043E") ;; CYRILLIC SMALL LETTER O
       (?$(0ae(B . "0x043F") ;; CYRILLIC SMALL LETTER PE
       (?$(0af(B . "0x0440") ;; CYRILLIC SMALL LETTER ER
       (?$(0ag(B . "0x0441") ;; CYRILLIC SMALL LETTER ES
       (?$(0ah(B . "0x0442") ;; CYRILLIC SMALL LETTER TE
       (?$(0ai(B . "0x0443") ;; CYRILLIC SMALL LETTER U
       (?$(0aj(B . "0x0444") ;; CYRILLIC SMALL LETTER EF
       (?$(0ak(B . "0x0445") ;; CYRILLIC SMALL LETTER HA
       (?$(0al(B . "0x0446") ;; CYRILLIC SMALL LETTER TSE
       (?$(0am(B . "0x0447") ;; CYRILLIC SMALL LETTER CHE
       (?$(0an(B . "0x0448") ;; CYRILLIC SMALL LETTER SHA
       (?$(0ao(B . "0x0449") ;; CYRILLIC SMALL LETTER SHCHA
       (?$(0ap(B . "0x044A") ;; CYRILLIC SMALL LETTER HARD SIGN
       (?$(0aq(B . "0x044B") ;; CYRILLIC SMALL LETTER YERU
       (?$(0ar(B . "0x044C") ;; CYRILLIC SMALL LETTER SOFT SIGN
       (?$(0as(B . "0x044D") ;; CYRILLIC SMALL LETTER E
       (?$(0at(B . "0x044E") ;; CYRILLIC SMALL LETTER YU
       (?$(0au(B . "0x044F") ;; CYRILLIC SMALL LETTER YA
       (?$(0av(B . "0x2460") ;; CIRCLED DIGIT ONE
       (?$(0aw(B . "0x2461") ;; CIRCLED DIGIT TWO
       (?$(0ax(B . "0x2462") ;; CIRCLED DIGIT THREE
       (?$(0ay(B . "0x2463") ;; CIRCLED DIGIT FOUR
       (?$(0az(B . "0x2464") ;; CIRCLED DIGIT FIVE
       (?$(0a{(B . "0x2465") ;; CIRCLED DIGIT SIX
       (?$(0a|(B . "0x2466") ;; CIRCLED DIGIT SEVEN
       (?$(0a}(B . "0x2467") ;; CIRCLED DIGIT EIGHT
       (?$(0a~(B . "0x2468") ;; CIRCLED DIGIT NINE
       (?$(0b!(B . "0x2469") ;; CIRCLED NUMBER TEN
       (?$(0b"(B . "0x2474") ;; PARENTHESIZED DIGIT ONE
       (?$(0b#(B . "0x2475") ;; PARENTHESIZED DIGIT TWO
       (?$(0b$(B . "0x2476") ;; PARENTHESIZED DIGIT THREE
       (?$(0b%(B . "0x2477") ;; PARENTHESIZED DIGIT FOUR
       (?$(0b&(B . "0x2478") ;; PARENTHESIZED DIGIT FIVE
       (?$(0b'(B . "0x2479") ;; PARENTHESIZED DIGIT SIX
       (?$(0b((B . "0x247A") ;; PARENTHESIZED DIGIT SEVEN
       (?$(0b)(B . "0x247B") ;; PARENTHESIZED DIGIT EIGHT
       (?$(0b*(B . "0x247C") ;; PARENTHESIZED DIGIT NINE
       (?$(0b+(B . "0x247D") ;; PARENTHESIZED NUMBER TEN
       ))))
  
(defvar
  chinese-big5-2-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(1!!(B . "0x4E42") ;; <CJK>
       (?$(1!"(B . "0x4E5C") ;; <CJK>
       (?$(1!#(B . "0x51F5") ;; <CJK>
       (?$(1!$(B . "0x531A") ;; <CJK>
       (?$(1!%(B . "0x5382") ;; <CJK>
       (?$(1!&(B . "0x4E07") ;; <CJK>
       (?$(1!'(B . "0x4E0C") ;; <CJK>
       (?$(1!((B . "0x4E47") ;; <CJK>
       (?$(1!)(B . "0x4E8D") ;; <CJK>
       (?$(1!*(B . "0x56D7") ;; <CJK>
       (?$(1!+(B . "0xFA0C") ;; CJK COMPATIBILITY IDEOGRAPH-FA0C
       (?$(1!,(B . "0x5C6E") ;; <CJK>
       (?$(1!-(B . "0x5F73") ;; <CJK>
       (?$(1!.(B . "0x4E0F") ;; <CJK>
       (?$(1!/(B . "0x5187") ;; <CJK>
       (?$(1!0(B . "0x4E0E") ;; <CJK>
       (?$(1!1(B . "0x4E2E") ;; <CJK>
       (?$(1!2(B . "0x4E93") ;; <CJK>
       (?$(1!3(B . "0x4EC2") ;; <CJK>
       (?$(1!4(B . "0x4EC9") ;; <CJK>
       (?$(1!5(B . "0x4EC8") ;; <CJK>
       (?$(1!6(B . "0x5198") ;; <CJK>
       (?$(1!7(B . "0x52FC") ;; <CJK>
       (?$(1!8(B . "0x536C") ;; <CJK>
       (?$(1!9(B . "0x53B9") ;; <CJK>
       (?$(1!:(B . "0x5720") ;; <CJK>
       (?$(1!;(B . "0x5903") ;; <CJK>
       (?$(1!<(B . "0x592C") ;; <CJK>
       (?$(1!=(B . "0x5C10") ;; <CJK>
       (?$(1!>(B . "0x5DFF") ;; <CJK>
       (?$(1!?(B . "0x65E1") ;; <CJK>
       (?$(1!@(B . "0x6BB3") ;; <CJK>
       (?$(1!A(B . "0x6BCC") ;; <CJK>
       (?$(1!B(B . "0x6C14") ;; <CJK>
       (?$(1!C(B . "0x723F") ;; <CJK>
       (?$(1!D(B . "0x4E31") ;; <CJK>
       (?$(1!E(B . "0x4E3C") ;; <CJK>
       (?$(1!F(B . "0x4EE8") ;; <CJK>
       (?$(1!G(B . "0x4EDC") ;; <CJK>
       (?$(1!H(B . "0x4EE9") ;; <CJK>
       (?$(1!I(B . "0x4EE1") ;; <CJK>
       (?$(1!J(B . "0x4EDD") ;; <CJK>
       (?$(1!K(B . "0x4EDA") ;; <CJK>
       (?$(1!L(B . "0x520C") ;; <CJK>
       (?$(1!M(B . "0x531C") ;; <CJK>
       (?$(1!N(B . "0x534C") ;; <CJK>
       (?$(1!O(B . "0x5722") ;; <CJK>
       (?$(1!P(B . "0x5723") ;; <CJK>
       (?$(1!Q(B . "0x5917") ;; <CJK>
       (?$(1!R(B . "0x592F") ;; <CJK>
       (?$(1!S(B . "0x5B81") ;; <CJK>
       (?$(1!T(B . "0x5B84") ;; <CJK>
       (?$(1!U(B . "0x5C12") ;; <CJK>
       (?$(1!V(B . "0x5C3B") ;; <CJK>
       (?$(1!W(B . "0x5C74") ;; <CJK>
       (?$(1!X(B . "0x5C73") ;; <CJK>
       (?$(1!Y(B . "0x5E04") ;; <CJK>
       (?$(1!Z(B . "0x5E80") ;; <CJK>
       (?$(1![(B . "0x5E82") ;; <CJK>
       (?$(1!\(B . "0x5FC9") ;; <CJK>
       (?$(1!](B . "0x6209") ;; <CJK>
       (?$(1!^(B . "0x6250") ;; <CJK>
       (?$(1!_(B . "0x6C15") ;; <CJK>
       (?$(1!`(B . "0x6C36") ;; <CJK>
       (?$(1!a(B . "0x6C43") ;; <CJK>
       (?$(1!b(B . "0x6C3F") ;; <CJK>
       (?$(1!c(B . "0x6C3B") ;; <CJK>
       (?$(1!d(B . "0x72AE") ;; <CJK>
       (?$(1!e(B . "0x72B0") ;; <CJK>
       (?$(1!f(B . "0x738A") ;; <CJK>
       (?$(1!g(B . "0x79B8") ;; <CJK>
       (?$(1!h(B . "0x808A") ;; <CJK>
       (?$(1!i(B . "0x961E") ;; <CJK>
       (?$(1!j(B . "0x4F0E") ;; <CJK>
       (?$(1!k(B . "0x4F18") ;; <CJK>
       (?$(1!l(B . "0x4F2C") ;; <CJK>
       (?$(1!m(B . "0x4EF5") ;; <CJK>
       (?$(1!n(B . "0x4F14") ;; <CJK>
       (?$(1!o(B . "0x4EF1") ;; <CJK>
       (?$(1!p(B . "0x4F00") ;; <CJK>
       (?$(1!q(B . "0x4EF7") ;; <CJK>
       (?$(1!r(B . "0x4F08") ;; <CJK>
       (?$(1!s(B . "0x4F1D") ;; <CJK>
       (?$(1!t(B . "0x4F02") ;; <CJK>
       (?$(1!u(B . "0x4F05") ;; <CJK>
       (?$(1!v(B . "0x4F22") ;; <CJK>
       (?$(1!w(B . "0x4F13") ;; <CJK>
       (?$(1!x(B . "0x4F04") ;; <CJK>
       (?$(1!y(B . "0x4EF4") ;; <CJK>
       (?$(1!z(B . "0x4F12") ;; <CJK>
       (?$(1!{(B . "0x51B1") ;; <CJK>
       (?$(1!|(B . "0x5213") ;; <CJK>
       (?$(1!}(B . "0x5209") ;; <CJK>
       (?$(1!~(B . "0x5210") ;; <CJK>
       (?$(1"!(B . "0x52A6") ;; <CJK>
       (?$(1""(B . "0x5322") ;; <CJK>
       (?$(1"#(B . "0x531F") ;; <CJK>
       (?$(1"$(B . "0x534D") ;; <CJK>
       (?$(1"%(B . "0x538A") ;; <CJK>
       (?$(1"&(B . "0x5407") ;; <CJK>
       (?$(1"'(B . "0x56E1") ;; <CJK>
       (?$(1"((B . "0x56DF") ;; <CJK>
       (?$(1")(B . "0x572E") ;; <CJK>
       (?$(1"*(B . "0x572A") ;; <CJK>
       (?$(1"+(B . "0x5734") ;; <CJK>
       (?$(1",(B . "0x593C") ;; <CJK>
       (?$(1"-(B . "0x5980") ;; <CJK>
       (?$(1".(B . "0x597C") ;; <CJK>
       (?$(1"/(B . "0x5985") ;; <CJK>
       (?$(1"0(B . "0x597B") ;; <CJK>
       (?$(1"1(B . "0x597E") ;; <CJK>
       (?$(1"2(B . "0x5977") ;; <CJK>
       (?$(1"3(B . "0x597F") ;; <CJK>
       (?$(1"4(B . "0x5B56") ;; <CJK>
       (?$(1"5(B . "0x5C15") ;; <CJK>
       (?$(1"6(B . "0x5C25") ;; <CJK>
       (?$(1"7(B . "0x5C7C") ;; <CJK>
       (?$(1"8(B . "0x5C7A") ;; <CJK>
       (?$(1"9(B . "0x5C7B") ;; <CJK>
       (?$(1":(B . "0x5C7E") ;; <CJK>
       (?$(1";(B . "0x5DDF") ;; <CJK>
       (?$(1"<(B . "0x5E75") ;; <CJK>
       (?$(1"=(B . "0x5E84") ;; <CJK>
       (?$(1">(B . "0x5F02") ;; <CJK>
       (?$(1"?(B . "0x5F1A") ;; <CJK>
       (?$(1"@(B . "0x5F74") ;; <CJK>
       (?$(1"A(B . "0x5FD5") ;; <CJK>
       (?$(1"B(B . "0x5FD4") ;; <CJK>
       (?$(1"C(B . "0x5FCF") ;; <CJK>
       (?$(1"D(B . "0x625C") ;; <CJK>
       (?$(1"E(B . "0x625E") ;; <CJK>
       (?$(1"F(B . "0x6264") ;; <CJK>
       (?$(1"G(B . "0x6261") ;; <CJK>
       (?$(1"H(B . "0x6266") ;; <CJK>
       (?$(1"I(B . "0x6262") ;; <CJK>
       (?$(1"J(B . "0x6259") ;; <CJK>
       (?$(1"K(B . "0x6260") ;; <CJK>
       (?$(1"L(B . "0x625A") ;; <CJK>
       (?$(1"M(B . "0x6265") ;; <CJK>
       (?$(1"N(B . "0x65EF") ;; <CJK>
       (?$(1"O(B . "0x65EE") ;; <CJK>
       (?$(1"P(B . "0x673E") ;; <CJK>
       (?$(1"Q(B . "0x6739") ;; <CJK>
       (?$(1"R(B . "0x6738") ;; <CJK>
       (?$(1"S(B . "0x673B") ;; <CJK>
       (?$(1"T(B . "0x673A") ;; <CJK>
       (?$(1"U(B . "0x673F") ;; <CJK>
       (?$(1"V(B . "0x673C") ;; <CJK>
       (?$(1"W(B . "0x6733") ;; <CJK>
       (?$(1"X(B . "0x6C18") ;; <CJK>
       (?$(1"Y(B . "0x6C46") ;; <CJK>
       (?$(1"Z(B . "0x6C52") ;; <CJK>
       (?$(1"[(B . "0x6C5C") ;; <CJK>
       (?$(1"\(B . "0x6C4F") ;; <CJK>
       (?$(1"](B . "0x6C4A") ;; <CJK>
       (?$(1"^(B . "0x6C54") ;; <CJK>
       (?$(1"_(B . "0x6C4B") ;; <CJK>
       (?$(1"`(B . "0x6C4C") ;; <CJK>
       (?$(1"a(B . "0x7071") ;; <CJK>
       (?$(1"b(B . "0x725E") ;; <CJK>
       (?$(1"c(B . "0x72B4") ;; <CJK>
       (?$(1"d(B . "0x72B5") ;; <CJK>
       (?$(1"e(B . "0x738E") ;; <CJK>
       (?$(1"f(B . "0x752A") ;; <CJK>
       (?$(1"g(B . "0x767F") ;; <CJK>
       (?$(1"h(B . "0x7A75") ;; <CJK>
       (?$(1"i(B . "0x7F51") ;; <CJK>
       (?$(1"j(B . "0x8278") ;; <CJK>
       (?$(1"k(B . "0x827C") ;; <CJK>
       (?$(1"l(B . "0x8280") ;; <CJK>
       (?$(1"m(B . "0x827D") ;; <CJK>
       (?$(1"n(B . "0x827F") ;; <CJK>
       (?$(1"o(B . "0x864D") ;; <CJK>
       (?$(1"p(B . "0x897E") ;; <CJK>
       (?$(1"q(B . "0x9099") ;; <CJK>
       (?$(1"r(B . "0x9097") ;; <CJK>
       (?$(1"s(B . "0x9098") ;; <CJK>
       (?$(1"t(B . "0x909B") ;; <CJK>
       (?$(1"u(B . "0x9094") ;; <CJK>
       (?$(1"v(B . "0x9622") ;; <CJK>
       (?$(1"w(B . "0x9624") ;; <CJK>
       (?$(1"x(B . "0x9620") ;; <CJK>
       (?$(1"y(B . "0x9623") ;; <CJK>
       (?$(1"z(B . "0x4F56") ;; <CJK>
       (?$(1"{(B . "0x4F3B") ;; <CJK>
       (?$(1"|(B . "0x4F62") ;; <CJK>
       (?$(1"}(B . "0x4F49") ;; <CJK>
       (?$(1"~(B . "0x4F53") ;; <CJK>
       (?$(1#!(B . "0x4F64") ;; <CJK>
       (?$(1#"(B . "0x4F3E") ;; <CJK>
       (?$(1##(B . "0x4F67") ;; <CJK>
       (?$(1#$(B . "0x4F52") ;; <CJK>
       (?$(1#%(B . "0x4F5F") ;; <CJK>
       (?$(1#&(B . "0x4F41") ;; <CJK>
       (?$(1#'(B . "0x4F58") ;; <CJK>
       (?$(1#((B . "0x4F2D") ;; <CJK>
       (?$(1#)(B . "0x4F33") ;; <CJK>
       (?$(1#*(B . "0x4F3F") ;; <CJK>
       (?$(1#+(B . "0x4F61") ;; <CJK>
       (?$(1#,(B . "0x518F") ;; <CJK>
       (?$(1#-(B . "0x51B9") ;; <CJK>
       (?$(1#.(B . "0x521C") ;; <CJK>
       (?$(1#/(B . "0x521E") ;; <CJK>
       (?$(1#0(B . "0x5221") ;; <CJK>
       (?$(1#1(B . "0x52AD") ;; <CJK>
       (?$(1#2(B . "0x52AE") ;; <CJK>
       (?$(1#3(B . "0x5309") ;; <CJK>
       (?$(1#4(B . "0x5363") ;; <CJK>
       (?$(1#5(B . "0x5372") ;; <CJK>
       (?$(1#6(B . "0x538E") ;; <CJK>
       (?$(1#7(B . "0x538F") ;; <CJK>
       (?$(1#8(B . "0x5430") ;; <CJK>
       (?$(1#9(B . "0x5437") ;; <CJK>
       (?$(1#:(B . "0x542A") ;; <CJK>
       (?$(1#;(B . "0x5454") ;; <CJK>
       (?$(1#<(B . "0x5445") ;; <CJK>
       (?$(1#=(B . "0x5419") ;; <CJK>
       (?$(1#>(B . "0x541C") ;; <CJK>
       (?$(1#?(B . "0x5425") ;; <CJK>
       (?$(1#@(B . "0x5418") ;; <CJK>
       (?$(1#A(B . "0x543D") ;; <CJK>
       (?$(1#B(B . "0x544F") ;; <CJK>
       (?$(1#C(B . "0x5441") ;; <CJK>
       (?$(1#D(B . "0x5428") ;; <CJK>
       (?$(1#E(B . "0x5424") ;; <CJK>
       (?$(1#F(B . "0x5447") ;; <CJK>
       (?$(1#G(B . "0x56EE") ;; <CJK>
       (?$(1#H(B . "0x56E7") ;; <CJK>
       (?$(1#I(B . "0x56E5") ;; <CJK>
       (?$(1#J(B . "0x5741") ;; <CJK>
       (?$(1#K(B . "0x5745") ;; <CJK>
       (?$(1#L(B . "0x574C") ;; <CJK>
       (?$(1#M(B . "0x5749") ;; <CJK>
       (?$(1#N(B . "0x574B") ;; <CJK>
       (?$(1#O(B . "0x5752") ;; <CJK>
       (?$(1#P(B . "0x5906") ;; <CJK>
       (?$(1#Q(B . "0x5940") ;; <CJK>
       (?$(1#R(B . "0x59A6") ;; <CJK>
       (?$(1#S(B . "0x5998") ;; <CJK>
       (?$(1#T(B . "0x59A0") ;; <CJK>
       (?$(1#U(B . "0x5997") ;; <CJK>
       (?$(1#V(B . "0x598E") ;; <CJK>
       (?$(1#W(B . "0x59A2") ;; <CJK>
       (?$(1#X(B . "0x5990") ;; <CJK>
       (?$(1#Y(B . "0x598F") ;; <CJK>
       (?$(1#Z(B . "0x59A7") ;; <CJK>
       (?$(1#[(B . "0x59A1") ;; <CJK>
       (?$(1#\(B . "0x5B8E") ;; <CJK>
       (?$(1#](B . "0x5B92") ;; <CJK>
       (?$(1#^(B . "0x5C28") ;; <CJK>
       (?$(1#_(B . "0x5C2A") ;; <CJK>
       (?$(1#`(B . "0x5C8D") ;; <CJK>
       (?$(1#a(B . "0x5C8F") ;; <CJK>
       (?$(1#b(B . "0x5C88") ;; <CJK>
       (?$(1#c(B . "0x5C8B") ;; <CJK>
       (?$(1#d(B . "0x5C89") ;; <CJK>
       (?$(1#e(B . "0x5C92") ;; <CJK>
       (?$(1#f(B . "0x5C8A") ;; <CJK>
       (?$(1#g(B . "0x5C86") ;; <CJK>
       (?$(1#h(B . "0x5C93") ;; <CJK>
       (?$(1#i(B . "0x5C95") ;; <CJK>
       (?$(1#j(B . "0x5DE0") ;; <CJK>
       (?$(1#k(B . "0x5E0A") ;; <CJK>
       (?$(1#l(B . "0x5E0E") ;; <CJK>
       (?$(1#m(B . "0x5E8B") ;; <CJK>
       (?$(1#n(B . "0x5E89") ;; <CJK>
       (?$(1#o(B . "0x5E8C") ;; <CJK>
       (?$(1#p(B . "0x5E88") ;; <CJK>
       (?$(1#q(B . "0x5E8D") ;; <CJK>
       (?$(1#r(B . "0x5F05") ;; <CJK>
       (?$(1#s(B . "0x5F1D") ;; <CJK>
       (?$(1#t(B . "0x5F78") ;; <CJK>
       (?$(1#u(B . "0x5F76") ;; <CJK>
       (?$(1#v(B . "0x5FD2") ;; <CJK>
       (?$(1#w(B . "0x5FD1") ;; <CJK>
       (?$(1#x(B . "0x5FD0") ;; <CJK>
       (?$(1#y(B . "0x5FED") ;; <CJK>
       (?$(1#z(B . "0x5FE8") ;; <CJK>
       (?$(1#{(B . "0x5FEE") ;; <CJK>
       (?$(1#|(B . "0x5FF3") ;; <CJK>
       (?$(1#}(B . "0x5FE1") ;; <CJK>
       (?$(1#~(B . "0x5FE4") ;; <CJK>
       (?$(1$!(B . "0x5FE3") ;; <CJK>
       (?$(1$"(B . "0x5FFA") ;; <CJK>
       (?$(1$#(B . "0x5FEF") ;; <CJK>
       (?$(1$$(B . "0x5FF7") ;; <CJK>
       (?$(1$%(B . "0x5FFB") ;; <CJK>
       (?$(1$&(B . "0x6000") ;; <CJK>
       (?$(1$'(B . "0x5FF4") ;; <CJK>
       (?$(1$((B . "0x623A") ;; <CJK>
       (?$(1$)(B . "0x6283") ;; <CJK>
       (?$(1$*(B . "0x628C") ;; <CJK>
       (?$(1$+(B . "0x628E") ;; <CJK>
       (?$(1$,(B . "0x628F") ;; <CJK>
       (?$(1$-(B . "0x6294") ;; <CJK>
       (?$(1$.(B . "0x6287") ;; <CJK>
       (?$(1$/(B . "0x6271") ;; <CJK>
       (?$(1$0(B . "0x627B") ;; <CJK>
       (?$(1$1(B . "0x627A") ;; <CJK>
       (?$(1$2(B . "0x6270") ;; <CJK>
       (?$(1$3(B . "0x6281") ;; <CJK>
       (?$(1$4(B . "0x6288") ;; <CJK>
       (?$(1$5(B . "0x6277") ;; <CJK>
       (?$(1$6(B . "0x627D") ;; <CJK>
       (?$(1$7(B . "0x6272") ;; <CJK>
       (?$(1$8(B . "0x6274") ;; <CJK>
       (?$(1$9(B . "0x6537") ;; <CJK>
       (?$(1$:(B . "0x65F0") ;; <CJK>
       (?$(1$;(B . "0x65F4") ;; <CJK>
       (?$(1$<(B . "0x65F3") ;; <CJK>
       (?$(1$=(B . "0x65F2") ;; <CJK>
       (?$(1$>(B . "0x65F5") ;; <CJK>
       (?$(1$?(B . "0x6745") ;; <CJK>
       (?$(1$@(B . "0x6747") ;; <CJK>
       (?$(1$A(B . "0x6759") ;; <CJK>
       (?$(1$B(B . "0x6755") ;; <CJK>
       (?$(1$C(B . "0x674C") ;; <CJK>
       (?$(1$D(B . "0x6748") ;; <CJK>
       (?$(1$E(B . "0x675D") ;; <CJK>
       (?$(1$F(B . "0x674D") ;; <CJK>
       (?$(1$G(B . "0x675A") ;; <CJK>
       (?$(1$H(B . "0x674B") ;; <CJK>
       (?$(1$I(B . "0x6BD0") ;; <CJK>
       (?$(1$J(B . "0x6C19") ;; <CJK>
       (?$(1$K(B . "0x6C1A") ;; <CJK>
       (?$(1$L(B . "0x6C78") ;; <CJK>
       (?$(1$M(B . "0x6C67") ;; <CJK>
       (?$(1$N(B . "0x6C6B") ;; <CJK>
       (?$(1$O(B . "0x6C84") ;; <CJK>
       (?$(1$P(B . "0x6C8B") ;; <CJK>
       (?$(1$Q(B . "0x6C8F") ;; <CJK>
       (?$(1$R(B . "0x6C71") ;; <CJK>
       (?$(1$S(B . "0x6C6F") ;; <CJK>
       (?$(1$T(B . "0x6C69") ;; <CJK>
       (?$(1$U(B . "0x6C9A") ;; <CJK>
       (?$(1$V(B . "0x6C6D") ;; <CJK>
       (?$(1$W(B . "0x6C87") ;; <CJK>
       (?$(1$X(B . "0x6C95") ;; <CJK>
       (?$(1$Y(B . "0x6C9C") ;; <CJK>
       (?$(1$Z(B . "0x6C66") ;; <CJK>
       (?$(1$[(B . "0x6C73") ;; <CJK>
       (?$(1$\(B . "0x6C65") ;; <CJK>
       (?$(1$](B . "0x6C7B") ;; <CJK>
       (?$(1$^(B . "0x6C8E") ;; <CJK>
       (?$(1$_(B . "0x7074") ;; <CJK>
       (?$(1$`(B . "0x707A") ;; <CJK>
       (?$(1$a(B . "0x7263") ;; <CJK>
       (?$(1$b(B . "0x72BF") ;; <CJK>
       (?$(1$c(B . "0x72BD") ;; <CJK>
       (?$(1$d(B . "0x72C3") ;; <CJK>
       (?$(1$e(B . "0x72C6") ;; <CJK>
       (?$(1$f(B . "0x72C1") ;; <CJK>
       (?$(1$g(B . "0x72BA") ;; <CJK>
       (?$(1$h(B . "0x72C5") ;; <CJK>
       (?$(1$i(B . "0x7395") ;; <CJK>
       (?$(1$j(B . "0x7397") ;; <CJK>
       (?$(1$k(B . "0x7393") ;; <CJK>
       (?$(1$l(B . "0x7394") ;; <CJK>
       (?$(1$m(B . "0x7392") ;; <CJK>
       (?$(1$n(B . "0x753A") ;; <CJK>
       (?$(1$o(B . "0x7539") ;; <CJK>
       (?$(1$p(B . "0x7594") ;; <CJK>
       (?$(1$q(B . "0x7595") ;; <CJK>
       (?$(1$r(B . "0x7681") ;; <CJK>
       (?$(1$s(B . "0x793D") ;; <CJK>
       (?$(1$t(B . "0x8034") ;; <CJK>
       (?$(1$u(B . "0x8095") ;; <CJK>
       (?$(1$v(B . "0x8099") ;; <CJK>
       (?$(1$w(B . "0x8090") ;; <CJK>
       (?$(1$x(B . "0x8092") ;; <CJK>
       (?$(1$y(B . "0x809C") ;; <CJK>
       (?$(1$z(B . "0x8290") ;; <CJK>
       (?$(1${(B . "0x828F") ;; <CJK>
       (?$(1$|(B . "0x8285") ;; <CJK>
       (?$(1$}(B . "0x828E") ;; <CJK>
       (?$(1$~(B . "0x8291") ;; <CJK>
       (?$(1%!(B . "0x8293") ;; <CJK>
       (?$(1%"(B . "0x828A") ;; <CJK>
       (?$(1%#(B . "0x8283") ;; <CJK>
       (?$(1%$(B . "0x8284") ;; <CJK>
       (?$(1%%(B . "0x8C78") ;; <CJK>
       (?$(1%&(B . "0x8FC9") ;; <CJK>
       (?$(1%'(B . "0x8FBF") ;; <CJK>
       (?$(1%((B . "0x909F") ;; <CJK>
       (?$(1%)(B . "0x90A1") ;; <CJK>
       (?$(1%*(B . "0x90A5") ;; <CJK>
       (?$(1%+(B . "0x909E") ;; <CJK>
       (?$(1%,(B . "0x90A7") ;; <CJK>
       (?$(1%-(B . "0x90A0") ;; <CJK>
       (?$(1%.(B . "0x9630") ;; <CJK>
       (?$(1%/(B . "0x9628") ;; <CJK>
       (?$(1%0(B . "0x962F") ;; <CJK>
       (?$(1%1(B . "0x962D") ;; <CJK>
       (?$(1%2(B . "0x4E33") ;; <CJK>
       (?$(1%3(B . "0x4F98") ;; <CJK>
       (?$(1%4(B . "0x4F7C") ;; <CJK>
       (?$(1%5(B . "0x4F85") ;; <CJK>
       (?$(1%6(B . "0x4F7D") ;; <CJK>
       (?$(1%7(B . "0x4F80") ;; <CJK>
       (?$(1%8(B . "0x4F87") ;; <CJK>
       (?$(1%9(B . "0x4F76") ;; <CJK>
       (?$(1%:(B . "0x4F74") ;; <CJK>
       (?$(1%;(B . "0x4F89") ;; <CJK>
       (?$(1%<(B . "0x4F84") ;; <CJK>
       (?$(1%=(B . "0x4F77") ;; <CJK>
       (?$(1%>(B . "0x4F4C") ;; <CJK>
       (?$(1%?(B . "0x4F97") ;; <CJK>
       (?$(1%@(B . "0x4F6A") ;; <CJK>
       (?$(1%A(B . "0x4F9A") ;; <CJK>
       (?$(1%B(B . "0x4F79") ;; <CJK>
       (?$(1%C(B . "0x4F81") ;; <CJK>
       (?$(1%D(B . "0x4F78") ;; <CJK>
       (?$(1%E(B . "0x4F90") ;; <CJK>
       (?$(1%F(B . "0x4F9C") ;; <CJK>
       (?$(1%G(B . "0x4F94") ;; <CJK>
       (?$(1%H(B . "0x4F9E") ;; <CJK>
       (?$(1%I(B . "0x4F92") ;; <CJK>
       (?$(1%J(B . "0x4F82") ;; <CJK>
       (?$(1%K(B . "0x4F95") ;; <CJK>
       (?$(1%L(B . "0x4F6B") ;; <CJK>
       (?$(1%M(B . "0x4F6E") ;; <CJK>
       (?$(1%N(B . "0x519E") ;; <CJK>
       (?$(1%O(B . "0x51BC") ;; <CJK>
       (?$(1%P(B . "0x51BE") ;; <CJK>
       (?$(1%Q(B . "0x5235") ;; <CJK>
       (?$(1%R(B . "0x5232") ;; <CJK>
       (?$(1%S(B . "0x5233") ;; <CJK>
       (?$(1%T(B . "0x5246") ;; <CJK>
       (?$(1%U(B . "0x5231") ;; <CJK>
       (?$(1%V(B . "0x52BC") ;; <CJK>
       (?$(1%W(B . "0x530A") ;; <CJK>
       (?$(1%X(B . "0x530B") ;; <CJK>
       (?$(1%Y(B . "0x533C") ;; <CJK>
       (?$(1%Z(B . "0x5392") ;; <CJK>
       (?$(1%[(B . "0x5394") ;; <CJK>
       (?$(1%\(B . "0x5487") ;; <CJK>
       (?$(1%](B . "0x547F") ;; <CJK>
       (?$(1%^(B . "0x5481") ;; <CJK>
       (?$(1%_(B . "0x5491") ;; <CJK>
       (?$(1%`(B . "0x5482") ;; <CJK>
       (?$(1%a(B . "0x5488") ;; <CJK>
       (?$(1%b(B . "0x546B") ;; <CJK>
       (?$(1%c(B . "0x547A") ;; <CJK>
       (?$(1%d(B . "0x547E") ;; <CJK>
       (?$(1%e(B . "0x5465") ;; <CJK>
       (?$(1%f(B . "0x546C") ;; <CJK>
       (?$(1%g(B . "0x5474") ;; <CJK>
       (?$(1%h(B . "0x5466") ;; <CJK>
       (?$(1%i(B . "0x548D") ;; <CJK>
       (?$(1%j(B . "0x546F") ;; <CJK>
       (?$(1%k(B . "0x5461") ;; <CJK>
       (?$(1%l(B . "0x5460") ;; <CJK>
       (?$(1%m(B . "0x5498") ;; <CJK>
       (?$(1%n(B . "0x5463") ;; <CJK>
       (?$(1%o(B . "0x5467") ;; <CJK>
       (?$(1%p(B . "0x5464") ;; <CJK>
       (?$(1%q(B . "0x56F7") ;; <CJK>
       (?$(1%r(B . "0x56F9") ;; <CJK>
       (?$(1%s(B . "0x576F") ;; <CJK>
       (?$(1%t(B . "0x5772") ;; <CJK>
       (?$(1%u(B . "0x576D") ;; <CJK>
       (?$(1%v(B . "0x576B") ;; <CJK>
       (?$(1%w(B . "0x5771") ;; <CJK>
       (?$(1%x(B . "0x5770") ;; <CJK>
       (?$(1%y(B . "0x5776") ;; <CJK>
       (?$(1%z(B . "0x5780") ;; <CJK>
       (?$(1%{(B . "0x5775") ;; <CJK>
       (?$(1%|(B . "0x577B") ;; <CJK>
       (?$(1%}(B . "0x5773") ;; <CJK>
       (?$(1%~(B . "0x5774") ;; <CJK>
       (?$(1&!(B . "0x5762") ;; <CJK>
       (?$(1&"(B . "0x5768") ;; <CJK>
       (?$(1&#(B . "0x577D") ;; <CJK>
       (?$(1&$(B . "0x590C") ;; <CJK>
       (?$(1&%(B . "0x5945") ;; <CJK>
       (?$(1&&(B . "0x59B5") ;; <CJK>
       (?$(1&'(B . "0x59BA") ;; <CJK>
       (?$(1&((B . "0x59CF") ;; <CJK>
       (?$(1&)(B . "0x59CE") ;; <CJK>
       (?$(1&*(B . "0x59B2") ;; <CJK>
       (?$(1&+(B . "0x59CC") ;; <CJK>
       (?$(1&,(B . "0x59C1") ;; <CJK>
       (?$(1&-(B . "0x59B6") ;; <CJK>
       (?$(1&.(B . "0x59BC") ;; <CJK>
       (?$(1&/(B . "0x59C3") ;; <CJK>
       (?$(1&0(B . "0x59D6") ;; <CJK>
       (?$(1&1(B . "0x59B1") ;; <CJK>
       (?$(1&2(B . "0x59BD") ;; <CJK>
       (?$(1&3(B . "0x59C0") ;; <CJK>
       (?$(1&4(B . "0x59C8") ;; <CJK>
       (?$(1&5(B . "0x59B4") ;; <CJK>
       (?$(1&6(B . "0x59C7") ;; <CJK>
       (?$(1&7(B . "0x5B62") ;; <CJK>
       (?$(1&8(B . "0x5B65") ;; <CJK>
       (?$(1&9(B . "0x5B93") ;; <CJK>
       (?$(1&:(B . "0x5B95") ;; <CJK>
       (?$(1&;(B . "0x5C44") ;; <CJK>
       (?$(1&<(B . "0x5C47") ;; <CJK>
       (?$(1&=(B . "0x5CAE") ;; <CJK>
       (?$(1&>(B . "0x5CA4") ;; <CJK>
       (?$(1&?(B . "0x5CA0") ;; <CJK>
       (?$(1&@(B . "0x5CB5") ;; <CJK>
       (?$(1&A(B . "0x5CAF") ;; <CJK>
       (?$(1&B(B . "0x5CA8") ;; <CJK>
       (?$(1&C(B . "0x5CAC") ;; <CJK>
       (?$(1&D(B . "0x5C9F") ;; <CJK>
       (?$(1&E(B . "0x5CA3") ;; <CJK>
       (?$(1&F(B . "0x5CAD") ;; <CJK>
       (?$(1&G(B . "0x5CA2") ;; <CJK>
       (?$(1&H(B . "0x5CAA") ;; <CJK>
       (?$(1&I(B . "0x5CA7") ;; <CJK>
       (?$(1&J(B . "0x5C9D") ;; <CJK>
       (?$(1&K(B . "0x5CA5") ;; <CJK>
       (?$(1&L(B . "0x5CB6") ;; <CJK>
       (?$(1&M(B . "0x5CB0") ;; <CJK>
       (?$(1&N(B . "0x5CA6") ;; <CJK>
       (?$(1&O(B . "0x5E17") ;; <CJK>
       (?$(1&P(B . "0x5E14") ;; <CJK>
       (?$(1&Q(B . "0x5E19") ;; <CJK>
       (?$(1&R(B . "0x5F28") ;; <CJK>
       (?$(1&S(B . "0x5F22") ;; <CJK>
       (?$(1&T(B . "0x5F23") ;; <CJK>
       (?$(1&U(B . "0x5F24") ;; <CJK>
       (?$(1&V(B . "0x5F54") ;; <CJK>
       (?$(1&W(B . "0x5F82") ;; <CJK>
       (?$(1&X(B . "0x5F7E") ;; <CJK>
       (?$(1&Y(B . "0x5F7D") ;; <CJK>
       (?$(1&Z(B . "0x5FDE") ;; <CJK>
       (?$(1&[(B . "0x5FE5") ;; <CJK>
       (?$(1&\(B . "0x602D") ;; <CJK>
       (?$(1&](B . "0x6026") ;; <CJK>
       (?$(1&^(B . "0x6019") ;; <CJK>
       (?$(1&_(B . "0x6032") ;; <CJK>
       (?$(1&`(B . "0x600B") ;; <CJK>
       (?$(1&a(B . "0x6034") ;; <CJK>
       (?$(1&b(B . "0x600A") ;; <CJK>
       (?$(1&c(B . "0x6017") ;; <CJK>
       (?$(1&d(B . "0x6033") ;; <CJK>
       (?$(1&e(B . "0x601A") ;; <CJK>
       (?$(1&f(B . "0x601E") ;; <CJK>
       (?$(1&g(B . "0x602C") ;; <CJK>
       (?$(1&h(B . "0x6022") ;; <CJK>
       (?$(1&i(B . "0x600D") ;; <CJK>
       (?$(1&j(B . "0x6010") ;; <CJK>
       (?$(1&k(B . "0x602E") ;; <CJK>
       (?$(1&l(B . "0x6013") ;; <CJK>
       (?$(1&m(B . "0x6011") ;; <CJK>
       (?$(1&n(B . "0x600C") ;; <CJK>
       (?$(1&o(B . "0x6009") ;; <CJK>
       (?$(1&p(B . "0x601C") ;; <CJK>
       (?$(1&q(B . "0x6214") ;; <CJK>
       (?$(1&r(B . "0x623D") ;; <CJK>
       (?$(1&s(B . "0x62AD") ;; <CJK>
       (?$(1&t(B . "0x62B4") ;; <CJK>
       (?$(1&u(B . "0x62D1") ;; <CJK>
       (?$(1&v(B . "0x62BE") ;; <CJK>
       (?$(1&w(B . "0x62AA") ;; <CJK>
       (?$(1&x(B . "0x62B6") ;; <CJK>
       (?$(1&y(B . "0x62CA") ;; <CJK>
       (?$(1&z(B . "0x62AE") ;; <CJK>
       (?$(1&{(B . "0x62B3") ;; <CJK>
       (?$(1&|(B . "0x62AF") ;; <CJK>
       (?$(1&}(B . "0x62BB") ;; <CJK>
       (?$(1&~(B . "0x62A9") ;; <CJK>
       (?$(1'!(B . "0x62B0") ;; <CJK>
       (?$(1'"(B . "0x62B8") ;; <CJK>
       (?$(1'#(B . "0x653D") ;; <CJK>
       (?$(1'$(B . "0x65A8") ;; <CJK>
       (?$(1'%(B . "0x65BB") ;; <CJK>
       (?$(1'&(B . "0x6609") ;; <CJK>
       (?$(1''(B . "0x65FC") ;; <CJK>
       (?$(1'((B . "0x6604") ;; <CJK>
       (?$(1')(B . "0x6612") ;; <CJK>
       (?$(1'*(B . "0x6608") ;; <CJK>
       (?$(1'+(B . "0x65FB") ;; <CJK>
       (?$(1',(B . "0x6603") ;; <CJK>
       (?$(1'-(B . "0x660B") ;; <CJK>
       (?$(1'.(B . "0x660D") ;; <CJK>
       (?$(1'/(B . "0x6605") ;; <CJK>
       (?$(1'0(B . "0x65FD") ;; <CJK>
       (?$(1'1(B . "0x6611") ;; <CJK>
       (?$(1'2(B . "0x6610") ;; <CJK>
       (?$(1'3(B . "0x66F6") ;; <CJK>
       (?$(1'4(B . "0x670A") ;; <CJK>
       (?$(1'5(B . "0x6785") ;; <CJK>
       (?$(1'6(B . "0x676C") ;; <CJK>
       (?$(1'7(B . "0x678E") ;; <CJK>
       (?$(1'8(B . "0x6792") ;; <CJK>
       (?$(1'9(B . "0x6776") ;; <CJK>
       (?$(1':(B . "0x677B") ;; <CJK>
       (?$(1';(B . "0x6798") ;; <CJK>
       (?$(1'<(B . "0x6786") ;; <CJK>
       (?$(1'=(B . "0x6784") ;; <CJK>
       (?$(1'>(B . "0x6774") ;; <CJK>
       (?$(1'?(B . "0x678D") ;; <CJK>
       (?$(1'@(B . "0x678C") ;; <CJK>
       (?$(1'A(B . "0x677A") ;; <CJK>
       (?$(1'B(B . "0x679F") ;; <CJK>
       (?$(1'C(B . "0x6791") ;; <CJK>
       (?$(1'D(B . "0x6799") ;; <CJK>
       (?$(1'E(B . "0x6783") ;; <CJK>
       (?$(1'F(B . "0x677D") ;; <CJK>
       (?$(1'G(B . "0x6781") ;; <CJK>
       (?$(1'H(B . "0x6778") ;; <CJK>
       (?$(1'I(B . "0x6779") ;; <CJK>
       (?$(1'J(B . "0x6794") ;; <CJK>
       (?$(1'K(B . "0x6B25") ;; <CJK>
       (?$(1'L(B . "0x6B80") ;; <CJK>
       (?$(1'M(B . "0x6B7E") ;; <CJK>
       (?$(1'N(B . "0x6BDE") ;; <CJK>
       (?$(1'O(B . "0x6C1D") ;; <CJK>
       (?$(1'P(B . "0x6C93") ;; <CJK>
       (?$(1'Q(B . "0x6CEC") ;; <CJK>
       (?$(1'R(B . "0x6CEB") ;; <CJK>
       (?$(1'S(B . "0x6CEE") ;; <CJK>
       (?$(1'T(B . "0x6CD9") ;; <CJK>
       (?$(1'U(B . "0x6CB6") ;; <CJK>
       (?$(1'V(B . "0x6CD4") ;; <CJK>
       (?$(1'W(B . "0x6CAD") ;; <CJK>
       (?$(1'X(B . "0x6CE7") ;; <CJK>
       (?$(1'Y(B . "0x6CB7") ;; <CJK>
       (?$(1'Z(B . "0x6CD0") ;; <CJK>
       (?$(1'[(B . "0x6CC2") ;; <CJK>
       (?$(1'\(B . "0x6CBA") ;; <CJK>
       (?$(1'](B . "0x6CC3") ;; <CJK>
       (?$(1'^(B . "0x6CC6") ;; <CJK>
       (?$(1'_(B . "0x6CED") ;; <CJK>
       (?$(1'`(B . "0x6CF2") ;; <CJK>
       (?$(1'a(B . "0x6CD2") ;; <CJK>
       (?$(1'b(B . "0x6CDD") ;; <CJK>
       (?$(1'c(B . "0x6CB4") ;; <CJK>
       (?$(1'd(B . "0x6C8A") ;; <CJK>
       (?$(1'e(B . "0x6C9D") ;; <CJK>
       (?$(1'f(B . "0x6C80") ;; <CJK>
       (?$(1'g(B . "0x6CDE") ;; <CJK>
       (?$(1'h(B . "0x6CC0") ;; <CJK>
       (?$(1'i(B . "0x6D30") ;; <CJK>
       (?$(1'j(B . "0x6CCD") ;; <CJK>
       (?$(1'k(B . "0x6CC7") ;; <CJK>
       (?$(1'l(B . "0x6CB0") ;; <CJK>
       (?$(1'm(B . "0x6CF9") ;; <CJK>
       (?$(1'n(B . "0x6CCF") ;; <CJK>
       (?$(1'o(B . "0x6CE9") ;; <CJK>
       (?$(1'p(B . "0x6CD1") ;; <CJK>
       (?$(1'q(B . "0x7094") ;; <CJK>
       (?$(1'r(B . "0x7098") ;; <CJK>
       (?$(1's(B . "0x7085") ;; <CJK>
       (?$(1't(B . "0x7093") ;; <CJK>
       (?$(1'u(B . "0x7086") ;; <CJK>
       (?$(1'v(B . "0x7084") ;; <CJK>
       (?$(1'w(B . "0x7091") ;; <CJK>
       (?$(1'x(B . "0x7096") ;; <CJK>
       (?$(1'y(B . "0x7082") ;; <CJK>
       (?$(1'z(B . "0x709A") ;; <CJK>
       (?$(1'{(B . "0x7083") ;; <CJK>
       (?$(1'|(B . "0x726A") ;; <CJK>
       (?$(1'}(B . "0x72D6") ;; <CJK>
       (?$(1'~(B . "0x72CB") ;; <CJK>
       (?$(1(!(B . "0x72D8") ;; <CJK>
       (?$(1("(B . "0x72C9") ;; <CJK>
       (?$(1(#(B . "0x72DC") ;; <CJK>
       (?$(1($(B . "0x72D2") ;; <CJK>
       (?$(1(%(B . "0x72D4") ;; <CJK>
       (?$(1(&(B . "0x72DA") ;; <CJK>
       (?$(1('(B . "0x72CC") ;; <CJK>
       (?$(1(((B . "0x72D1") ;; <CJK>
       (?$(1()(B . "0x73A4") ;; <CJK>
       (?$(1(*(B . "0x73A1") ;; <CJK>
       (?$(1(+(B . "0x73AD") ;; <CJK>
       (?$(1(,(B . "0x73A6") ;; <CJK>
       (?$(1(-(B . "0x73A2") ;; <CJK>
       (?$(1(.(B . "0x73A0") ;; <CJK>
       (?$(1(/(B . "0x73AC") ;; <CJK>
       (?$(1(0(B . "0x739D") ;; <CJK>
       (?$(1(1(B . "0x74DD") ;; <CJK>
       (?$(1(2(B . "0x74E8") ;; <CJK>
       (?$(1(3(B . "0x753F") ;; <CJK>
       (?$(1(4(B . "0x7540") ;; <CJK>
       (?$(1(5(B . "0x753E") ;; <CJK>
       (?$(1(6(B . "0x758C") ;; <CJK>
       (?$(1(7(B . "0x7598") ;; <CJK>
       (?$(1(8(B . "0x76AF") ;; <CJK>
       (?$(1(9(B . "0x76F3") ;; <CJK>
       (?$(1(:(B . "0x76F1") ;; <CJK>
       (?$(1(;(B . "0x76F0") ;; <CJK>
       (?$(1(<(B . "0x76F5") ;; <CJK>
       (?$(1(=(B . "0x77F8") ;; <CJK>
       (?$(1(>(B . "0x77FC") ;; <CJK>
       (?$(1(?(B . "0x77F9") ;; <CJK>
       (?$(1(@(B . "0x77FB") ;; <CJK>
       (?$(1(A(B . "0x77FA") ;; <CJK>
       (?$(1(B(B . "0x77F7") ;; <CJK>
       (?$(1(C(B . "0x7942") ;; <CJK>
       (?$(1(D(B . "0x793F") ;; <CJK>
       (?$(1(E(B . "0x79C5") ;; <CJK>
       (?$(1(F(B . "0x7A78") ;; <CJK>
       (?$(1(G(B . "0x7A7B") ;; <CJK>
       (?$(1(H(B . "0x7AFB") ;; <CJK>
       (?$(1(I(B . "0x7C75") ;; <CJK>
       (?$(1(J(B . "0x7CFD") ;; <CJK>
       (?$(1(K(B . "0x8035") ;; <CJK>
       (?$(1(L(B . "0x808F") ;; <CJK>
       (?$(1(M(B . "0x80AE") ;; <CJK>
       (?$(1(N(B . "0x80A3") ;; <CJK>
       (?$(1(O(B . "0x80B8") ;; <CJK>
       (?$(1(P(B . "0x80B5") ;; <CJK>
       (?$(1(Q(B . "0x80AD") ;; <CJK>
       (?$(1(R(B . "0x8220") ;; <CJK>
       (?$(1(S(B . "0x82A0") ;; <CJK>
       (?$(1(T(B . "0x82C0") ;; <CJK>
       (?$(1(U(B . "0x82AB") ;; <CJK>
       (?$(1(V(B . "0x829A") ;; <CJK>
       (?$(1(W(B . "0x8298") ;; <CJK>
       (?$(1(X(B . "0x829B") ;; <CJK>
       (?$(1(Y(B . "0x82B5") ;; <CJK>
       (?$(1(Z(B . "0x82A7") ;; <CJK>
       (?$(1([(B . "0x82AE") ;; <CJK>
       (?$(1(\(B . "0x82BC") ;; <CJK>
       (?$(1(](B . "0x829E") ;; <CJK>
       (?$(1(^(B . "0x82BA") ;; <CJK>
       (?$(1(_(B . "0x82B4") ;; <CJK>
       (?$(1(`(B . "0x82A8") ;; <CJK>
       (?$(1(a(B . "0x82A1") ;; <CJK>
       (?$(1(b(B . "0x82A9") ;; <CJK>
       (?$(1(c(B . "0x82C2") ;; <CJK>
       (?$(1(d(B . "0x82A4") ;; <CJK>
       (?$(1(e(B . "0x82C3") ;; <CJK>
       (?$(1(f(B . "0x82B6") ;; <CJK>
       (?$(1(g(B . "0x82A2") ;; <CJK>
       (?$(1(h(B . "0x8670") ;; <CJK>
       (?$(1(i(B . "0x866F") ;; <CJK>
       (?$(1(j(B . "0x866D") ;; <CJK>
       (?$(1(k(B . "0x866E") ;; <CJK>
       (?$(1(l(B . "0x8C56") ;; <CJK>
       (?$(1(m(B . "0x8FD2") ;; <CJK>
       (?$(1(n(B . "0x8FCB") ;; <CJK>
       (?$(1(o(B . "0x8FD3") ;; <CJK>
       (?$(1(p(B . "0x8FCD") ;; <CJK>
       (?$(1(q(B . "0x8FD6") ;; <CJK>
       (?$(1(r(B . "0x8FD5") ;; <CJK>
       (?$(1(s(B . "0x8FD7") ;; <CJK>
       (?$(1(t(B . "0x90B2") ;; <CJK>
       (?$(1(u(B . "0x90B4") ;; <CJK>
       (?$(1(v(B . "0x90AF") ;; <CJK>
       (?$(1(w(B . "0x90B3") ;; <CJK>
       (?$(1(x(B . "0x90B0") ;; <CJK>
       (?$(1(y(B . "0x9639") ;; <CJK>
       (?$(1(z(B . "0x963D") ;; <CJK>
       (?$(1({(B . "0x963C") ;; <CJK>
       (?$(1(|(B . "0x963A") ;; <CJK>
       (?$(1(}(B . "0x9643") ;; <CJK>
       (?$(1(~(B . "0x4FCD") ;; <CJK>
       (?$(1)!(B . "0x4FC5") ;; <CJK>
       (?$(1)"(B . "0x4FD3") ;; <CJK>
       (?$(1)#(B . "0x4FB2") ;; <CJK>
       (?$(1)$(B . "0x4FC9") ;; <CJK>
       (?$(1)%(B . "0x4FCB") ;; <CJK>
       (?$(1)&(B . "0x4FC1") ;; <CJK>
       (?$(1)'(B . "0x4FD4") ;; <CJK>
       (?$(1)((B . "0x4FDC") ;; <CJK>
       (?$(1))(B . "0x4FD9") ;; <CJK>
       (?$(1)*(B . "0x4FBB") ;; <CJK>
       (?$(1)+(B . "0x4FB3") ;; <CJK>
       (?$(1),(B . "0x4FDB") ;; <CJK>
       (?$(1)-(B . "0x4FC7") ;; <CJK>
       (?$(1).(B . "0x4FD6") ;; <CJK>
       (?$(1)/(B . "0x4FBA") ;; <CJK>
       (?$(1)0(B . "0x4FC0") ;; <CJK>
       (?$(1)1(B . "0x4FB9") ;; <CJK>
       (?$(1)2(B . "0x4FEC") ;; <CJK>
       (?$(1)3(B . "0x5244") ;; <CJK>
       (?$(1)4(B . "0x5249") ;; <CJK>
       (?$(1)5(B . "0x52C0") ;; <CJK>
       (?$(1)6(B . "0x52C2") ;; <CJK>
       (?$(1)7(B . "0x533D") ;; <CJK>
       (?$(1)8(B . "0x537C") ;; <CJK>
       (?$(1)9(B . "0x5397") ;; <CJK>
       (?$(1):(B . "0x5396") ;; <CJK>
       (?$(1);(B . "0x5399") ;; <CJK>
       (?$(1)<(B . "0x5398") ;; <CJK>
       (?$(1)=(B . "0x54BA") ;; <CJK>
       (?$(1)>(B . "0x54A1") ;; <CJK>
       (?$(1)?(B . "0x54AD") ;; <CJK>
       (?$(1)@(B . "0x54A5") ;; <CJK>
       (?$(1)A(B . "0x54CF") ;; <CJK>
       (?$(1)B(B . "0x54C3") ;; <CJK>
       (?$(1)C(B . "0x830D") ;; <CJK>
       (?$(1)D(B . "0x54B7") ;; <CJK>
       (?$(1)E(B . "0x54AE") ;; <CJK>
       (?$(1)F(B . "0x54D6") ;; <CJK>
       (?$(1)G(B . "0x54B6") ;; <CJK>
       (?$(1)H(B . "0x54C5") ;; <CJK>
       (?$(1)I(B . "0x54C6") ;; <CJK>
       (?$(1)J(B . "0x54A0") ;; <CJK>
       (?$(1)K(B . "0x5470") ;; <CJK>
       (?$(1)L(B . "0x54BC") ;; <CJK>
       (?$(1)M(B . "0x54A2") ;; <CJK>
       (?$(1)N(B . "0x54BE") ;; <CJK>
       (?$(1)O(B . "0x5472") ;; <CJK>
       (?$(1)P(B . "0x54DE") ;; <CJK>
       (?$(1)Q(B . "0x54B0") ;; <CJK>
       (?$(1)R(B . "0x57B5") ;; <CJK>
       (?$(1)S(B . "0x579E") ;; <CJK>
       (?$(1)T(B . "0x579F") ;; <CJK>
       (?$(1)U(B . "0x57A4") ;; <CJK>
       (?$(1)V(B . "0x578C") ;; <CJK>
       (?$(1)W(B . "0x5797") ;; <CJK>
       (?$(1)X(B . "0x579D") ;; <CJK>
       (?$(1)Y(B . "0x579B") ;; <CJK>
       (?$(1)Z(B . "0x5794") ;; <CJK>
       (?$(1)[(B . "0x5798") ;; <CJK>
       (?$(1)\(B . "0x578F") ;; <CJK>
       (?$(1)](B . "0x5799") ;; <CJK>
       (?$(1)^(B . "0x57A5") ;; <CJK>
       (?$(1)_(B . "0x579A") ;; <CJK>
       (?$(1)`(B . "0x5795") ;; <CJK>
       (?$(1)a(B . "0x58F4") ;; <CJK>
       (?$(1)b(B . "0x590D") ;; <CJK>
       (?$(1)c(B . "0x5953") ;; <CJK>
       (?$(1)d(B . "0x59E1") ;; <CJK>
       (?$(1)e(B . "0x59DE") ;; <CJK>
       (?$(1)f(B . "0x59EE") ;; <CJK>
       (?$(1)g(B . "0x5A00") ;; <CJK>
       (?$(1)h(B . "0x59F1") ;; <CJK>
       (?$(1)i(B . "0x59DD") ;; <CJK>
       (?$(1)j(B . "0x59FA") ;; <CJK>
       (?$(1)k(B . "0x59FD") ;; <CJK>
       (?$(1)l(B . "0x59FC") ;; <CJK>
       (?$(1)m(B . "0x59F6") ;; <CJK>
       (?$(1)n(B . "0x59E4") ;; <CJK>
       (?$(1)o(B . "0x59F2") ;; <CJK>
       (?$(1)p(B . "0x59F7") ;; <CJK>
       (?$(1)q(B . "0x59DB") ;; <CJK>
       (?$(1)r(B . "0x59E9") ;; <CJK>
       (?$(1)s(B . "0x59F3") ;; <CJK>
       (?$(1)t(B . "0x59F5") ;; <CJK>
       (?$(1)u(B . "0x59E0") ;; <CJK>
       (?$(1)v(B . "0x59FE") ;; <CJK>
       (?$(1)w(B . "0x59F4") ;; <CJK>
       (?$(1)x(B . "0x59ED") ;; <CJK>
       (?$(1)y(B . "0x5BA8") ;; <CJK>
       (?$(1)z(B . "0x5C4C") ;; <CJK>
       (?$(1){(B . "0x5CD0") ;; <CJK>
       (?$(1)|(B . "0x5CD8") ;; <CJK>
       (?$(1)}(B . "0x5CCC") ;; <CJK>
       (?$(1)~(B . "0x5CD7") ;; <CJK>
       (?$(1*!(B . "0x5CCB") ;; <CJK>
       (?$(1*"(B . "0x5CDB") ;; <CJK>
       (?$(1*#(B . "0x5CDE") ;; <CJK>
       (?$(1*$(B . "0x5CDA") ;; <CJK>
       (?$(1*%(B . "0x5CC9") ;; <CJK>
       (?$(1*&(B . "0x5CC7") ;; <CJK>
       (?$(1*'(B . "0x5CCA") ;; <CJK>
       (?$(1*((B . "0x5CD6") ;; <CJK>
       (?$(1*)(B . "0x5CD3") ;; <CJK>
       (?$(1**(B . "0x5CD4") ;; <CJK>
       (?$(1*+(B . "0x5CCF") ;; <CJK>
       (?$(1*,(B . "0x5CC8") ;; <CJK>
       (?$(1*-(B . "0x5CC6") ;; <CJK>
       (?$(1*.(B . "0x5CCE") ;; <CJK>
       (?$(1*/(B . "0x5CDF") ;; <CJK>
       (?$(1*0(B . "0x5CF8") ;; <CJK>
       (?$(1*1(B . "0x5DF9") ;; <CJK>
       (?$(1*2(B . "0x5E21") ;; <CJK>
       (?$(1*3(B . "0x5E22") ;; <CJK>
       (?$(1*4(B . "0x5E23") ;; <CJK>
       (?$(1*5(B . "0x5E20") ;; <CJK>
       (?$(1*6(B . "0x5E24") ;; <CJK>
       (?$(1*7(B . "0x5EB0") ;; <CJK>
       (?$(1*8(B . "0x5EA4") ;; <CJK>
       (?$(1*9(B . "0x5EA2") ;; <CJK>
       (?$(1*:(B . "0x5E9B") ;; <CJK>
       (?$(1*;(B . "0x5EA3") ;; <CJK>
       (?$(1*<(B . "0x5EA5") ;; <CJK>
       (?$(1*=(B . "0x5F07") ;; <CJK>
       (?$(1*>(B . "0x5F2E") ;; <CJK>
       (?$(1*?(B . "0x5F56") ;; <CJK>
       (?$(1*@(B . "0x5F86") ;; <CJK>
       (?$(1*A(B . "0x6037") ;; <CJK>
       (?$(1*B(B . "0x6039") ;; <CJK>
       (?$(1*C(B . "0x6054") ;; <CJK>
       (?$(1*D(B . "0x6072") ;; <CJK>
       (?$(1*E(B . "0x605E") ;; <CJK>
       (?$(1*F(B . "0x6045") ;; <CJK>
       (?$(1*G(B . "0x6053") ;; <CJK>
       (?$(1*H(B . "0x6047") ;; <CJK>
       (?$(1*I(B . "0x6049") ;; <CJK>
       (?$(1*J(B . "0x605B") ;; <CJK>
       (?$(1*K(B . "0x604C") ;; <CJK>
       (?$(1*L(B . "0x6040") ;; <CJK>
       (?$(1*M(B . "0x6042") ;; <CJK>
       (?$(1*N(B . "0x605F") ;; <CJK>
       (?$(1*O(B . "0x6024") ;; <CJK>
       (?$(1*P(B . "0x6044") ;; <CJK>
       (?$(1*Q(B . "0x6058") ;; <CJK>
       (?$(1*R(B . "0x6066") ;; <CJK>
       (?$(1*S(B . "0x606E") ;; <CJK>
       (?$(1*T(B . "0x6242") ;; <CJK>
       (?$(1*U(B . "0x6243") ;; <CJK>
       (?$(1*V(B . "0x62CF") ;; <CJK>
       (?$(1*W(B . "0x630D") ;; <CJK>
       (?$(1*X(B . "0x630B") ;; <CJK>
       (?$(1*Y(B . "0x62F5") ;; <CJK>
       (?$(1*Z(B . "0x630E") ;; <CJK>
       (?$(1*[(B . "0x6303") ;; <CJK>
       (?$(1*\(B . "0x62EB") ;; <CJK>
       (?$(1*](B . "0x62F9") ;; <CJK>
       (?$(1*^(B . "0x630F") ;; <CJK>
       (?$(1*_(B . "0x630C") ;; <CJK>
       (?$(1*`(B . "0x62F8") ;; <CJK>
       (?$(1*a(B . "0x62F6") ;; <CJK>
       (?$(1*b(B . "0x6300") ;; <CJK>
       (?$(1*c(B . "0x6313") ;; <CJK>
       (?$(1*d(B . "0x6314") ;; <CJK>
       (?$(1*e(B . "0x62FA") ;; <CJK>
       (?$(1*f(B . "0x6315") ;; <CJK>
       (?$(1*g(B . "0x62FB") ;; <CJK>
       (?$(1*h(B . "0x62F0") ;; <CJK>
       (?$(1*i(B . "0x6541") ;; <CJK>
       (?$(1*j(B . "0x6543") ;; <CJK>
       (?$(1*k(B . "0x65AA") ;; <CJK>
       (?$(1*l(B . "0x65BF") ;; <CJK>
       (?$(1*m(B . "0x6636") ;; <CJK>
       (?$(1*n(B . "0x6621") ;; <CJK>
       (?$(1*o(B . "0x6632") ;; <CJK>
       (?$(1*p(B . "0x6635") ;; <CJK>
       (?$(1*q(B . "0x661C") ;; <CJK>
       (?$(1*r(B . "0x6626") ;; <CJK>
       (?$(1*s(B . "0x6622") ;; <CJK>
       (?$(1*t(B . "0x6633") ;; <CJK>
       (?$(1*u(B . "0x662B") ;; <CJK>
       (?$(1*v(B . "0x663A") ;; <CJK>
       (?$(1*w(B . "0x661D") ;; <CJK>
       (?$(1*x(B . "0x6634") ;; <CJK>
       (?$(1*y(B . "0x6639") ;; <CJK>
       (?$(1*z(B . "0x662E") ;; <CJK>
       (?$(1*{(B . "0x670F") ;; <CJK>
       (?$(1*|(B . "0x6710") ;; <CJK>
       (?$(1*}(B . "0x67C1") ;; <CJK>
       (?$(1*~(B . "0x67F2") ;; <CJK>
       (?$(1+!(B . "0x67C8") ;; <CJK>
       (?$(1+"(B . "0x67BA") ;; <CJK>
       (?$(1+#(B . "0x67DC") ;; <CJK>
       (?$(1+$(B . "0x67BB") ;; <CJK>
       (?$(1+%(B . "0x67F8") ;; <CJK>
       (?$(1+&(B . "0x67D8") ;; <CJK>
       (?$(1+'(B . "0x67C0") ;; <CJK>
       (?$(1+((B . "0x67B7") ;; <CJK>
       (?$(1+)(B . "0x67C5") ;; <CJK>
       (?$(1+*(B . "0x67EB") ;; <CJK>
       (?$(1++(B . "0x67E4") ;; <CJK>
       (?$(1+,(B . "0x67DF") ;; <CJK>
       (?$(1+-(B . "0x67B5") ;; <CJK>
       (?$(1+.(B . "0x67CD") ;; <CJK>
       (?$(1+/(B . "0x67B3") ;; <CJK>
       (?$(1+0(B . "0x67F7") ;; <CJK>
       (?$(1+1(B . "0x67F6") ;; <CJK>
       (?$(1+2(B . "0x67EE") ;; <CJK>
       (?$(1+3(B . "0x67E3") ;; <CJK>
       (?$(1+4(B . "0x67C2") ;; <CJK>
       (?$(1+5(B . "0x67B9") ;; <CJK>
       (?$(1+6(B . "0x67CE") ;; <CJK>
       (?$(1+7(B . "0x67E7") ;; <CJK>
       (?$(1+8(B . "0x67F0") ;; <CJK>
       (?$(1+9(B . "0x67B2") ;; <CJK>
       (?$(1+:(B . "0x67FC") ;; <CJK>
       (?$(1+;(B . "0x67C6") ;; <CJK>
       (?$(1+<(B . "0x67ED") ;; <CJK>
       (?$(1+=(B . "0x67CC") ;; <CJK>
       (?$(1+>(B . "0x67AE") ;; <CJK>
       (?$(1+?(B . "0x67E6") ;; <CJK>
       (?$(1+@(B . "0x67DB") ;; <CJK>
       (?$(1+A(B . "0x67FA") ;; <CJK>
       (?$(1+B(B . "0x67C9") ;; <CJK>
       (?$(1+C(B . "0x67CA") ;; <CJK>
       (?$(1+D(B . "0x67C3") ;; <CJK>
       (?$(1+E(B . "0x67EA") ;; <CJK>
       (?$(1+F(B . "0x67CB") ;; <CJK>
       (?$(1+G(B . "0x6B28") ;; <CJK>
       (?$(1+H(B . "0x6B82") ;; <CJK>
       (?$(1+I(B . "0x6B84") ;; <CJK>
       (?$(1+J(B . "0x6BB6") ;; <CJK>
       (?$(1+K(B . "0x6BD6") ;; <CJK>
       (?$(1+L(B . "0x6BD8") ;; <CJK>
       (?$(1+M(B . "0x6BE0") ;; <CJK>
       (?$(1+N(B . "0x6C20") ;; <CJK>
       (?$(1+O(B . "0x6C21") ;; <CJK>
       (?$(1+P(B . "0x6D28") ;; <CJK>
       (?$(1+Q(B . "0x6D34") ;; <CJK>
       (?$(1+R(B . "0x6D2D") ;; <CJK>
       (?$(1+S(B . "0x6D1F") ;; <CJK>
       (?$(1+T(B . "0x6D3C") ;; <CJK>
       (?$(1+U(B . "0x6D3F") ;; <CJK>
       (?$(1+V(B . "0x6D12") ;; <CJK>
       (?$(1+W(B . "0x6D0A") ;; <CJK>
       (?$(1+X(B . "0x6CDA") ;; <CJK>
       (?$(1+Y(B . "0x6D33") ;; <CJK>
       (?$(1+Z(B . "0x6D04") ;; <CJK>
       (?$(1+[(B . "0x6D19") ;; <CJK>
       (?$(1+\(B . "0x6D3A") ;; <CJK>
       (?$(1+](B . "0x6D1A") ;; <CJK>
       (?$(1+^(B . "0x6D11") ;; <CJK>
       (?$(1+_(B . "0x6D00") ;; <CJK>
       (?$(1+`(B . "0x6D1D") ;; <CJK>
       (?$(1+a(B . "0x6D42") ;; <CJK>
       (?$(1+b(B . "0x6D01") ;; <CJK>
       (?$(1+c(B . "0x6D18") ;; <CJK>
       (?$(1+d(B . "0x6D37") ;; <CJK>
       (?$(1+e(B . "0x6D03") ;; <CJK>
       (?$(1+f(B . "0x6D0F") ;; <CJK>
       (?$(1+g(B . "0x6D40") ;; <CJK>
       (?$(1+h(B . "0x6D07") ;; <CJK>
       (?$(1+i(B . "0x6D20") ;; <CJK>
       (?$(1+j(B . "0x6D2C") ;; <CJK>
       (?$(1+k(B . "0x6D08") ;; <CJK>
       (?$(1+l(B . "0x6D22") ;; <CJK>
       (?$(1+m(B . "0x6D09") ;; <CJK>
       (?$(1+n(B . "0x6D10") ;; <CJK>
       (?$(1+o(B . "0x70B7") ;; <CJK>
       (?$(1+p(B . "0x709F") ;; <CJK>
       (?$(1+q(B . "0x70BE") ;; <CJK>
       (?$(1+r(B . "0x70B1") ;; <CJK>
       (?$(1+s(B . "0x70B0") ;; <CJK>
       (?$(1+t(B . "0x70A1") ;; <CJK>
       (?$(1+u(B . "0x70B4") ;; <CJK>
       (?$(1+v(B . "0x70B5") ;; <CJK>
       (?$(1+w(B . "0x70A9") ;; <CJK>
       (?$(1+x(B . "0x7241") ;; <CJK>
       (?$(1+y(B . "0x7249") ;; <CJK>
       (?$(1+z(B . "0x724A") ;; <CJK>
       (?$(1+{(B . "0x726C") ;; <CJK>
       (?$(1+|(B . "0x7270") ;; <CJK>
       (?$(1+}(B . "0x7273") ;; <CJK>
       (?$(1+~(B . "0x726E") ;; <CJK>
       (?$(1,!(B . "0x72CA") ;; <CJK>
       (?$(1,"(B . "0x72E4") ;; <CJK>
       (?$(1,#(B . "0x72E8") ;; <CJK>
       (?$(1,$(B . "0x72EB") ;; <CJK>
       (?$(1,%(B . "0x72DF") ;; <CJK>
       (?$(1,&(B . "0x72EA") ;; <CJK>
       (?$(1,'(B . "0x72E6") ;; <CJK>
       (?$(1,((B . "0x72E3") ;; <CJK>
       (?$(1,)(B . "0x7385") ;; <CJK>
       (?$(1,*(B . "0x73CC") ;; <CJK>
       (?$(1,+(B . "0x73C2") ;; <CJK>
       (?$(1,,(B . "0x73C8") ;; <CJK>
       (?$(1,-(B . "0x73C5") ;; <CJK>
       (?$(1,.(B . "0x73B9") ;; <CJK>
       (?$(1,/(B . "0x73B6") ;; <CJK>
       (?$(1,0(B . "0x73B5") ;; <CJK>
       (?$(1,1(B . "0x73B4") ;; <CJK>
       (?$(1,2(B . "0x73EB") ;; <CJK>
       (?$(1,3(B . "0x73BF") ;; <CJK>
       (?$(1,4(B . "0x73C7") ;; <CJK>
       (?$(1,5(B . "0x73BE") ;; <CJK>
       (?$(1,6(B . "0x73C3") ;; <CJK>
       (?$(1,7(B . "0x73C6") ;; <CJK>
       (?$(1,8(B . "0x73B8") ;; <CJK>
       (?$(1,9(B . "0x73CB") ;; <CJK>
       (?$(1,:(B . "0x74EC") ;; <CJK>
       (?$(1,;(B . "0x74EE") ;; <CJK>
       (?$(1,<(B . "0x752E") ;; <CJK>
       (?$(1,=(B . "0x7547") ;; <CJK>
       (?$(1,>(B . "0x7548") ;; <CJK>
       (?$(1,?(B . "0x75A7") ;; <CJK>
       (?$(1,@(B . "0x75AA") ;; <CJK>
       (?$(1,A(B . "0x7679") ;; <CJK>
       (?$(1,B(B . "0x76C4") ;; <CJK>
       (?$(1,C(B . "0x7708") ;; <CJK>
       (?$(1,D(B . "0x7703") ;; <CJK>
       (?$(1,E(B . "0x7704") ;; <CJK>
       (?$(1,F(B . "0x7705") ;; <CJK>
       (?$(1,G(B . "0x770A") ;; <CJK>
       (?$(1,H(B . "0x76F7") ;; <CJK>
       (?$(1,I(B . "0x76FB") ;; <CJK>
       (?$(1,J(B . "0x76FA") ;; <CJK>
       (?$(1,K(B . "0x77E7") ;; <CJK>
       (?$(1,L(B . "0x77E8") ;; <CJK>
       (?$(1,M(B . "0x7806") ;; <CJK>
       (?$(1,N(B . "0x7811") ;; <CJK>
       (?$(1,O(B . "0x7812") ;; <CJK>
       (?$(1,P(B . "0x7805") ;; <CJK>
       (?$(1,Q(B . "0x7810") ;; <CJK>
       (?$(1,R(B . "0x780F") ;; <CJK>
       (?$(1,S(B . "0x780E") ;; <CJK>
       (?$(1,T(B . "0x7809") ;; <CJK>
       (?$(1,U(B . "0x7803") ;; <CJK>
       (?$(1,V(B . "0x7813") ;; <CJK>
       (?$(1,W(B . "0x794A") ;; <CJK>
       (?$(1,X(B . "0x794C") ;; <CJK>
       (?$(1,Y(B . "0x794B") ;; <CJK>
       (?$(1,Z(B . "0x7945") ;; <CJK>
       (?$(1,[(B . "0x7944") ;; <CJK>
       (?$(1,\(B . "0x79D5") ;; <CJK>
       (?$(1,](B . "0x79CD") ;; <CJK>
       (?$(1,^(B . "0x79CF") ;; <CJK>
       (?$(1,_(B . "0x79D6") ;; <CJK>
       (?$(1,`(B . "0x79CE") ;; <CJK>
       (?$(1,a(B . "0x7A80") ;; <CJK>
       (?$(1,b(B . "0x7A7E") ;; <CJK>
       (?$(1,c(B . "0x7AD1") ;; <CJK>
       (?$(1,d(B . "0x7B00") ;; <CJK>
       (?$(1,e(B . "0x7B01") ;; <CJK>
       (?$(1,f(B . "0x7C7A") ;; <CJK>
       (?$(1,g(B . "0x7C78") ;; <CJK>
       (?$(1,h(B . "0x7C79") ;; <CJK>
       (?$(1,i(B . "0x7C7F") ;; <CJK>
       (?$(1,j(B . "0x7C80") ;; <CJK>
       (?$(1,k(B . "0x7C81") ;; <CJK>
       (?$(1,l(B . "0x7D03") ;; <CJK>
       (?$(1,m(B . "0x7D08") ;; <CJK>
       (?$(1,n(B . "0x7D01") ;; <CJK>
       (?$(1,o(B . "0x7F58") ;; <CJK>
       (?$(1,p(B . "0x7F91") ;; <CJK>
       (?$(1,q(B . "0x7F8D") ;; <CJK>
       (?$(1,r(B . "0x7FBE") ;; <CJK>
       (?$(1,s(B . "0x8007") ;; <CJK>
       (?$(1,t(B . "0x800E") ;; <CJK>
       (?$(1,u(B . "0x800F") ;; <CJK>
       (?$(1,v(B . "0x8014") ;; <CJK>
       (?$(1,w(B . "0x8037") ;; <CJK>
       (?$(1,x(B . "0x80D8") ;; <CJK>
       (?$(1,y(B . "0x80C7") ;; <CJK>
       (?$(1,z(B . "0x80E0") ;; <CJK>
       (?$(1,{(B . "0x80D1") ;; <CJK>
       (?$(1,|(B . "0x80C8") ;; <CJK>
       (?$(1,}(B . "0x80C2") ;; <CJK>
       (?$(1,~(B . "0x80D0") ;; <CJK>
       (?$(1-!(B . "0x80C5") ;; <CJK>
       (?$(1-"(B . "0x80E3") ;; <CJK>
       (?$(1-#(B . "0x80D9") ;; <CJK>
       (?$(1-$(B . "0x80DC") ;; <CJK>
       (?$(1-%(B . "0x80CA") ;; <CJK>
       (?$(1-&(B . "0x80D5") ;; <CJK>
       (?$(1-'(B . "0x80C9") ;; <CJK>
       (?$(1-((B . "0x80CF") ;; <CJK>
       (?$(1-)(B . "0x80D7") ;; <CJK>
       (?$(1-*(B . "0x80E6") ;; <CJK>
       (?$(1-+(B . "0x80CD") ;; <CJK>
       (?$(1-,(B . "0x81FF") ;; <CJK>
       (?$(1--(B . "0x8221") ;; <CJK>
       (?$(1-.(B . "0x8294") ;; <CJK>
       (?$(1-/(B . "0x82D9") ;; <CJK>
       (?$(1-0(B . "0x82FE") ;; <CJK>
       (?$(1-1(B . "0x82F9") ;; <CJK>
       (?$(1-2(B . "0x8307") ;; <CJK>
       (?$(1-3(B . "0x82E8") ;; <CJK>
       (?$(1-4(B . "0x8300") ;; <CJK>
       (?$(1-5(B . "0x82D5") ;; <CJK>
       (?$(1-6(B . "0x833A") ;; <CJK>
       (?$(1-7(B . "0x82EB") ;; <CJK>
       (?$(1-8(B . "0x82D6") ;; <CJK>
       (?$(1-9(B . "0x82F4") ;; <CJK>
       (?$(1-:(B . "0x82EC") ;; <CJK>
       (?$(1-;(B . "0x82E1") ;; <CJK>
       (?$(1-<(B . "0x82F2") ;; <CJK>
       (?$(1-=(B . "0x82F5") ;; <CJK>
       (?$(1->(B . "0x830C") ;; <CJK>
       (?$(1-?(B . "0x82FB") ;; <CJK>
       (?$(1-@(B . "0x82F6") ;; <CJK>
       (?$(1-A(B . "0x82F0") ;; <CJK>
       (?$(1-B(B . "0x82EA") ;; <CJK>
       (?$(1-C(B . "0x82E4") ;; <CJK>
       (?$(1-D(B . "0x82E0") ;; <CJK>
       (?$(1-E(B . "0x82FA") ;; <CJK>
       (?$(1-F(B . "0x82F3") ;; <CJK>
       (?$(1-G(B . "0x82ED") ;; <CJK>
       (?$(1-H(B . "0x8677") ;; <CJK>
       (?$(1-I(B . "0x8674") ;; <CJK>
       (?$(1-J(B . "0x867C") ;; <CJK>
       (?$(1-K(B . "0x8673") ;; <CJK>
       (?$(1-L(B . "0x8841") ;; <CJK>
       (?$(1-M(B . "0x884E") ;; <CJK>
       (?$(1-N(B . "0x8867") ;; <CJK>
       (?$(1-O(B . "0x886A") ;; <CJK>
       (?$(1-P(B . "0x8869") ;; <CJK>
       (?$(1-Q(B . "0x89D3") ;; <CJK>
       (?$(1-R(B . "0x8A04") ;; <CJK>
       (?$(1-S(B . "0x8A07") ;; <CJK>
       (?$(1-T(B . "0x8D72") ;; <CJK>
       (?$(1-U(B . "0x8FE3") ;; <CJK>
       (?$(1-V(B . "0x8FE1") ;; <CJK>
       (?$(1-W(B . "0x8FEE") ;; <CJK>
       (?$(1-X(B . "0x8FE0") ;; <CJK>
       (?$(1-Y(B . "0x90F1") ;; <CJK>
       (?$(1-Z(B . "0x90BD") ;; <CJK>
       (?$(1-[(B . "0x90BF") ;; <CJK>
       (?$(1-\(B . "0x90D5") ;; <CJK>
       (?$(1-](B . "0x90C5") ;; <CJK>
       (?$(1-^(B . "0x90BE") ;; <CJK>
       (?$(1-_(B . "0x90C7") ;; <CJK>
       (?$(1-`(B . "0x90CB") ;; <CJK>
       (?$(1-a(B . "0x90C8") ;; <CJK>
       (?$(1-b(B . "0x91D4") ;; <CJK>
       (?$(1-c(B . "0x91D3") ;; <CJK>
       (?$(1-d(B . "0x9654") ;; <CJK>
       (?$(1-e(B . "0x964F") ;; <CJK>
       (?$(1-f(B . "0x9651") ;; <CJK>
       (?$(1-g(B . "0x9653") ;; <CJK>
       (?$(1-h(B . "0x964A") ;; <CJK>
       (?$(1-i(B . "0x964E") ;; <CJK>
       (?$(1-j(B . "0x501E") ;; <CJK>
       (?$(1-k(B . "0x5005") ;; <CJK>
       (?$(1-l(B . "0x5007") ;; <CJK>
       (?$(1-m(B . "0x5013") ;; <CJK>
       (?$(1-n(B . "0x5022") ;; <CJK>
       (?$(1-o(B . "0x5030") ;; <CJK>
       (?$(1-p(B . "0x501B") ;; <CJK>
       (?$(1-q(B . "0x4FF5") ;; <CJK>
       (?$(1-r(B . "0x4FF4") ;; <CJK>
       (?$(1-s(B . "0x5033") ;; <CJK>
       (?$(1-t(B . "0x5037") ;; <CJK>
       (?$(1-u(B . "0x502C") ;; <CJK>
       (?$(1-v(B . "0x4FF6") ;; <CJK>
       (?$(1-w(B . "0x4FF7") ;; <CJK>
       (?$(1-x(B . "0x5017") ;; <CJK>
       (?$(1-y(B . "0x501C") ;; <CJK>
       (?$(1-z(B . "0x5020") ;; <CJK>
       (?$(1-{(B . "0x5027") ;; <CJK>
       (?$(1-|(B . "0x5035") ;; <CJK>
       (?$(1-}(B . "0x502F") ;; <CJK>
       (?$(1-~(B . "0x5031") ;; <CJK>
       (?$(1.!(B . "0x500E") ;; <CJK>
       (?$(1."(B . "0x515A") ;; <CJK>
       (?$(1.#(B . "0x5194") ;; <CJK>
       (?$(1.$(B . "0x5193") ;; <CJK>
       (?$(1.%(B . "0x51CA") ;; <CJK>
       (?$(1.&(B . "0x51C4") ;; <CJK>
       (?$(1.'(B . "0x51C5") ;; <CJK>
       (?$(1.((B . "0x51C8") ;; <CJK>
       (?$(1.)(B . "0x51CE") ;; <CJK>
       (?$(1.*(B . "0x5261") ;; <CJK>
       (?$(1.+(B . "0x525A") ;; <CJK>
       (?$(1.,(B . "0x5252") ;; <CJK>
       (?$(1.-(B . "0x525E") ;; <CJK>
       (?$(1..(B . "0x525F") ;; <CJK>
       (?$(1./(B . "0x5255") ;; <CJK>
       (?$(1.0(B . "0x5262") ;; <CJK>
       (?$(1.1(B . "0x52CD") ;; <CJK>
       (?$(1.2(B . "0x530E") ;; <CJK>
       (?$(1.3(B . "0x539E") ;; <CJK>
       (?$(1.4(B . "0x5526") ;; <CJK>
       (?$(1.5(B . "0x54E2") ;; <CJK>
       (?$(1.6(B . "0x5517") ;; <CJK>
       (?$(1.7(B . "0x5512") ;; <CJK>
       (?$(1.8(B . "0x54E7") ;; <CJK>
       (?$(1.9(B . "0x54F3") ;; <CJK>
       (?$(1.:(B . "0x54E4") ;; <CJK>
       (?$(1.;(B . "0x551A") ;; <CJK>
       (?$(1.<(B . "0x54FF") ;; <CJK>
       (?$(1.=(B . "0x5504") ;; <CJK>
       (?$(1.>(B . "0x5508") ;; <CJK>
       (?$(1.?(B . "0x54EB") ;; <CJK>
       (?$(1.@(B . "0x5511") ;; <CJK>
       (?$(1.A(B . "0x5505") ;; <CJK>
       (?$(1.B(B . "0x54F1") ;; <CJK>
       (?$(1.C(B . "0x550A") ;; <CJK>
       (?$(1.D(B . "0x54FB") ;; <CJK>
       (?$(1.E(B . "0x54F7") ;; <CJK>
       (?$(1.F(B . "0x54F8") ;; <CJK>
       (?$(1.G(B . "0x54E0") ;; <CJK>
       (?$(1.H(B . "0x550E") ;; <CJK>
       (?$(1.I(B . "0x5503") ;; <CJK>
       (?$(1.J(B . "0x550B") ;; <CJK>
       (?$(1.K(B . "0x5701") ;; <CJK>
       (?$(1.L(B . "0x5702") ;; <CJK>
       (?$(1.M(B . "0x57CC") ;; <CJK>
       (?$(1.N(B . "0x5832") ;; <CJK>
       (?$(1.O(B . "0x57D5") ;; <CJK>
       (?$(1.P(B . "0x57D2") ;; <CJK>
       (?$(1.Q(B . "0x57BA") ;; <CJK>
       (?$(1.R(B . "0x57C6") ;; <CJK>
       (?$(1.S(B . "0x57BD") ;; <CJK>
       (?$(1.T(B . "0x57BC") ;; <CJK>
       (?$(1.U(B . "0x57B8") ;; <CJK>
       (?$(1.V(B . "0x57B6") ;; <CJK>
       (?$(1.W(B . "0x57BF") ;; <CJK>
       (?$(1.X(B . "0x57C7") ;; <CJK>
       (?$(1.Y(B . "0x57D0") ;; <CJK>
       (?$(1.Z(B . "0x57B9") ;; <CJK>
       (?$(1.[(B . "0x57C1") ;; <CJK>
       (?$(1.\(B . "0x590E") ;; <CJK>
       (?$(1.](B . "0x594A") ;; <CJK>
       (?$(1.^(B . "0x5A19") ;; <CJK>
       (?$(1._(B . "0x5A16") ;; <CJK>
       (?$(1.`(B . "0x5A2D") ;; <CJK>
       (?$(1.a(B . "0x5A2E") ;; <CJK>
       (?$(1.b(B . "0x5A15") ;; <CJK>
       (?$(1.c(B . "0x5A0F") ;; <CJK>
       (?$(1.d(B . "0x5A17") ;; <CJK>
       (?$(1.e(B . "0x5A0A") ;; <CJK>
       (?$(1.f(B . "0x5A1E") ;; <CJK>
       (?$(1.g(B . "0x5A33") ;; <CJK>
       (?$(1.h(B . "0x5B6C") ;; <CJK>
       (?$(1.i(B . "0x5BA7") ;; <CJK>
       (?$(1.j(B . "0x5BAD") ;; <CJK>
       (?$(1.k(B . "0x5BAC") ;; <CJK>
       (?$(1.l(B . "0x5C03") ;; <CJK>
       (?$(1.m(B . "0x5C56") ;; <CJK>
       (?$(1.n(B . "0x5C54") ;; <CJK>
       (?$(1.o(B . "0x5CEC") ;; <CJK>
       (?$(1.p(B . "0x5CFF") ;; <CJK>
       (?$(1.q(B . "0x5CEE") ;; <CJK>
       (?$(1.r(B . "0x5CF1") ;; <CJK>
       (?$(1.s(B . "0x5CF7") ;; <CJK>
       (?$(1.t(B . "0x5D00") ;; <CJK>
       (?$(1.u(B . "0x5CF9") ;; <CJK>
       (?$(1.v(B . "0x5E29") ;; <CJK>
       (?$(1.w(B . "0x5E28") ;; <CJK>
       (?$(1.x(B . "0x5EA8") ;; <CJK>
       (?$(1.y(B . "0x5EAE") ;; <CJK>
       (?$(1.z(B . "0x5EAA") ;; <CJK>
       (?$(1.{(B . "0x5EAC") ;; <CJK>
       (?$(1.|(B . "0x5F33") ;; <CJK>
       (?$(1.}(B . "0x5F30") ;; <CJK>
       (?$(1.~(B . "0x5F67") ;; <CJK>
       (?$(1/!(B . "0x605D") ;; <CJK>
       (?$(1/"(B . "0x605A") ;; <CJK>
       (?$(1/#(B . "0x6067") ;; <CJK>
       (?$(1/$(B . "0x6041") ;; <CJK>
       (?$(1/%(B . "0x60A2") ;; <CJK>
       (?$(1/&(B . "0x6088") ;; <CJK>
       (?$(1/'(B . "0x6080") ;; <CJK>
       (?$(1/((B . "0x6092") ;; <CJK>
       (?$(1/)(B . "0x6081") ;; <CJK>
       (?$(1/*(B . "0x609D") ;; <CJK>
       (?$(1/+(B . "0x6083") ;; <CJK>
       (?$(1/,(B . "0x6095") ;; <CJK>
       (?$(1/-(B . "0x609B") ;; <CJK>
       (?$(1/.(B . "0x6097") ;; <CJK>
       (?$(1//(B . "0x6087") ;; <CJK>
       (?$(1/0(B . "0x609C") ;; <CJK>
       (?$(1/1(B . "0x608E") ;; <CJK>
       (?$(1/2(B . "0x6219") ;; <CJK>
       (?$(1/3(B . "0x6246") ;; <CJK>
       (?$(1/4(B . "0x62F2") ;; <CJK>
       (?$(1/5(B . "0x6310") ;; <CJK>
       (?$(1/6(B . "0x6356") ;; <CJK>
       (?$(1/7(B . "0x632C") ;; <CJK>
       (?$(1/8(B . "0x6344") ;; <CJK>
       (?$(1/9(B . "0x6345") ;; <CJK>
       (?$(1/:(B . "0x6336") ;; <CJK>
       (?$(1/;(B . "0x6343") ;; <CJK>
       (?$(1/<(B . "0x63E4") ;; <CJK>
       (?$(1/=(B . "0x6339") ;; <CJK>
       (?$(1/>(B . "0x634B") ;; <CJK>
       (?$(1/?(B . "0x634A") ;; <CJK>
       (?$(1/@(B . "0x633C") ;; <CJK>
       (?$(1/A(B . "0x6329") ;; <CJK>
       (?$(1/B(B . "0x6341") ;; <CJK>
       (?$(1/C(B . "0x6334") ;; <CJK>
       (?$(1/D(B . "0x6358") ;; <CJK>
       (?$(1/E(B . "0x6354") ;; <CJK>
       (?$(1/F(B . "0x6359") ;; <CJK>
       (?$(1/G(B . "0x632D") ;; <CJK>
       (?$(1/H(B . "0x6347") ;; <CJK>
       (?$(1/I(B . "0x6333") ;; <CJK>
       (?$(1/J(B . "0x635A") ;; <CJK>
       (?$(1/K(B . "0x6351") ;; <CJK>
       (?$(1/L(B . "0x6338") ;; <CJK>
       (?$(1/M(B . "0x6357") ;; <CJK>
       (?$(1/N(B . "0x6340") ;; <CJK>
       (?$(1/O(B . "0x6348") ;; <CJK>
       (?$(1/P(B . "0x654A") ;; <CJK>
       (?$(1/Q(B . "0x6546") ;; <CJK>
       (?$(1/R(B . "0x65C6") ;; <CJK>
       (?$(1/S(B . "0x65C3") ;; <CJK>
       (?$(1/T(B . "0x65C4") ;; <CJK>
       (?$(1/U(B . "0x65C2") ;; <CJK>
       (?$(1/V(B . "0x664A") ;; <CJK>
       (?$(1/W(B . "0x665F") ;; <CJK>
       (?$(1/X(B . "0x6647") ;; <CJK>
       (?$(1/Y(B . "0x6651") ;; <CJK>
       (?$(1/Z(B . "0x6712") ;; <CJK>
       (?$(1/[(B . "0x6713") ;; <CJK>
       (?$(1/\(B . "0x681F") ;; <CJK>
       (?$(1/](B . "0x681A") ;; <CJK>
       (?$(1/^(B . "0x6849") ;; <CJK>
       (?$(1/_(B . "0x6832") ;; <CJK>
       (?$(1/`(B . "0x6833") ;; <CJK>
       (?$(1/a(B . "0x683B") ;; <CJK>
       (?$(1/b(B . "0x684B") ;; <CJK>
       (?$(1/c(B . "0x684F") ;; <CJK>
       (?$(1/d(B . "0x6816") ;; <CJK>
       (?$(1/e(B . "0x6831") ;; <CJK>
       (?$(1/f(B . "0x681C") ;; <CJK>
       (?$(1/g(B . "0x6835") ;; <CJK>
       (?$(1/h(B . "0x682B") ;; <CJK>
       (?$(1/i(B . "0x682D") ;; <CJK>
       (?$(1/j(B . "0x682F") ;; <CJK>
       (?$(1/k(B . "0x684E") ;; <CJK>
       (?$(1/l(B . "0x6844") ;; <CJK>
       (?$(1/m(B . "0x6834") ;; <CJK>
       (?$(1/n(B . "0x681D") ;; <CJK>
       (?$(1/o(B . "0x6812") ;; <CJK>
       (?$(1/p(B . "0x6814") ;; <CJK>
       (?$(1/q(B . "0x6826") ;; <CJK>
       (?$(1/r(B . "0x6828") ;; <CJK>
       (?$(1/s(B . "0x682E") ;; <CJK>
       (?$(1/t(B . "0x684D") ;; <CJK>
       (?$(1/u(B . "0x683A") ;; <CJK>
       (?$(1/v(B . "0x6825") ;; <CJK>
       (?$(1/w(B . "0x6820") ;; <CJK>
       (?$(1/x(B . "0x6B2C") ;; <CJK>
       (?$(1/y(B . "0x6B2F") ;; <CJK>
       (?$(1/z(B . "0x6B2D") ;; <CJK>
       (?$(1/{(B . "0x6B31") ;; <CJK>
       (?$(1/|(B . "0x6B34") ;; <CJK>
       (?$(1/}(B . "0x6B6D") ;; <CJK>
       (?$(1/~(B . "0x8082") ;; <CJK>
       (?$(10!(B . "0x6B88") ;; <CJK>
       (?$(10"(B . "0x6BE6") ;; <CJK>
       (?$(10#(B . "0x6BE4") ;; <CJK>
       (?$(10$(B . "0x6BE8") ;; <CJK>
       (?$(10%(B . "0x6BE3") ;; <CJK>
       (?$(10&(B . "0x6BE2") ;; <CJK>
       (?$(10'(B . "0x6BE7") ;; <CJK>
       (?$(10((B . "0x6C25") ;; <CJK>
       (?$(10)(B . "0x6D7A") ;; <CJK>
       (?$(10*(B . "0x6D63") ;; <CJK>
       (?$(10+(B . "0x6D64") ;; <CJK>
       (?$(10,(B . "0x6D76") ;; <CJK>
       (?$(10-(B . "0x6D0D") ;; <CJK>
       (?$(10.(B . "0x6D61") ;; <CJK>
       (?$(10/(B . "0x6D92") ;; <CJK>
       (?$(100(B . "0x6D58") ;; <CJK>
       (?$(101(B . "0x6D62") ;; <CJK>
       (?$(102(B . "0x6D6D") ;; <CJK>
       (?$(103(B . "0x6D6F") ;; <CJK>
       (?$(104(B . "0x6D91") ;; <CJK>
       (?$(105(B . "0x6D8D") ;; <CJK>
       (?$(106(B . "0x6DEF") ;; <CJK>
       (?$(107(B . "0x6D7F") ;; <CJK>
       (?$(108(B . "0x6D86") ;; <CJK>
       (?$(109(B . "0x6D5E") ;; <CJK>
       (?$(10:(B . "0x6D67") ;; <CJK>
       (?$(10;(B . "0x6D60") ;; <CJK>
       (?$(10<(B . "0x6D97") ;; <CJK>
       (?$(10=(B . "0x6D70") ;; <CJK>
       (?$(10>(B . "0x6D7C") ;; <CJK>
       (?$(10?(B . "0x6D5F") ;; <CJK>
       (?$(10@(B . "0x6D82") ;; <CJK>
       (?$(10A(B . "0x6D98") ;; <CJK>
       (?$(10B(B . "0x6D2F") ;; <CJK>
       (?$(10C(B . "0x6D68") ;; <CJK>
       (?$(10D(B . "0x6D8B") ;; <CJK>
       (?$(10E(B . "0x6D7E") ;; <CJK>
       (?$(10F(B . "0x6D80") ;; <CJK>
       (?$(10G(B . "0x6D84") ;; <CJK>
       (?$(10H(B . "0x6D16") ;; <CJK>
       (?$(10I(B . "0x6D83") ;; <CJK>
       (?$(10J(B . "0x6D7B") ;; <CJK>
       (?$(10K(B . "0x6D7D") ;; <CJK>
       (?$(10L(B . "0x6D75") ;; <CJK>
       (?$(10M(B . "0x6D90") ;; <CJK>
       (?$(10N(B . "0x70DC") ;; <CJK>
       (?$(10O(B . "0x70D3") ;; <CJK>
       (?$(10P(B . "0x70D1") ;; <CJK>
       (?$(10Q(B . "0x70DD") ;; <CJK>
       (?$(10R(B . "0x70CB") ;; <CJK>
       (?$(10S(B . "0x7F39") ;; <CJK>
       (?$(10T(B . "0x70E2") ;; <CJK>
       (?$(10U(B . "0x70D7") ;; <CJK>
       (?$(10V(B . "0x70D2") ;; <CJK>
       (?$(10W(B . "0x70DE") ;; <CJK>
       (?$(10X(B . "0x70E0") ;; <CJK>
       (?$(10Y(B . "0x70D4") ;; <CJK>
       (?$(10Z(B . "0x70CD") ;; <CJK>
       (?$(10[(B . "0x70C5") ;; <CJK>
       (?$(10\(B . "0x70C6") ;; <CJK>
       (?$(10](B . "0x70C7") ;; <CJK>
       (?$(10^(B . "0x70DA") ;; <CJK>
       (?$(10_(B . "0x70CE") ;; <CJK>
       (?$(10`(B . "0x70E1") ;; <CJK>
       (?$(10a(B . "0x7242") ;; <CJK>
       (?$(10b(B . "0x7278") ;; <CJK>
       (?$(10c(B . "0x7277") ;; <CJK>
       (?$(10d(B . "0x7276") ;; <CJK>
       (?$(10e(B . "0x7300") ;; <CJK>
       (?$(10f(B . "0x72FA") ;; <CJK>
       (?$(10g(B . "0x72F4") ;; <CJK>
       (?$(10h(B . "0x72FE") ;; <CJK>
       (?$(10i(B . "0x72F6") ;; <CJK>
       (?$(10j(B . "0x72F3") ;; <CJK>
       (?$(10k(B . "0x72FB") ;; <CJK>
       (?$(10l(B . "0x7301") ;; <CJK>
       (?$(10m(B . "0x73D3") ;; <CJK>
       (?$(10n(B . "0x73D9") ;; <CJK>
       (?$(10o(B . "0x73E5") ;; <CJK>
       (?$(10p(B . "0x73D6") ;; <CJK>
       (?$(10q(B . "0x73BC") ;; <CJK>
       (?$(10r(B . "0x73E7") ;; <CJK>
       (?$(10s(B . "0x73E3") ;; <CJK>
       (?$(10t(B . "0x73E9") ;; <CJK>
       (?$(10u(B . "0x73DC") ;; <CJK>
       (?$(10v(B . "0x73D2") ;; <CJK>
       (?$(10w(B . "0x73DB") ;; <CJK>
       (?$(10x(B . "0x73D4") ;; <CJK>
       (?$(10y(B . "0x73DD") ;; <CJK>
       (?$(10z(B . "0x73DA") ;; <CJK>
       (?$(10{(B . "0x73D7") ;; <CJK>
       (?$(10|(B . "0x73D8") ;; <CJK>
       (?$(10}(B . "0x73E8") ;; <CJK>
       (?$(10~(B . "0x74DE") ;; <CJK>
       (?$(11!(B . "0x74DF") ;; <CJK>
       (?$(11"(B . "0x74F4") ;; <CJK>
       (?$(11#(B . "0x74F5") ;; <CJK>
       (?$(11$(B . "0x7521") ;; <CJK>
       (?$(11%(B . "0x755B") ;; <CJK>
       (?$(11&(B . "0x755F") ;; <CJK>
       (?$(11'(B . "0x75B0") ;; <CJK>
       (?$(11((B . "0x75C1") ;; <CJK>
       (?$(11)(B . "0x75BB") ;; <CJK>
       (?$(11*(B . "0x75C4") ;; <CJK>
       (?$(11+(B . "0x75C0") ;; <CJK>
       (?$(11,(B . "0x75BF") ;; <CJK>
       (?$(11-(B . "0x75B6") ;; <CJK>
       (?$(11.(B . "0x75BA") ;; <CJK>
       (?$(11/(B . "0x768A") ;; <CJK>
       (?$(110(B . "0x76C9") ;; <CJK>
       (?$(111(B . "0x771D") ;; <CJK>
       (?$(112(B . "0x771B") ;; <CJK>
       (?$(113(B . "0x7710") ;; <CJK>
       (?$(114(B . "0x7713") ;; <CJK>
       (?$(115(B . "0x7712") ;; <CJK>
       (?$(116(B . "0x7723") ;; <CJK>
       (?$(117(B . "0x7711") ;; <CJK>
       (?$(118(B . "0x7715") ;; <CJK>
       (?$(119(B . "0x7719") ;; <CJK>
       (?$(11:(B . "0x771A") ;; <CJK>
       (?$(11;(B . "0x7722") ;; <CJK>
       (?$(11<(B . "0x7727") ;; <CJK>
       (?$(11=(B . "0x7823") ;; <CJK>
       (?$(11>(B . "0x782C") ;; <CJK>
       (?$(11?(B . "0x7822") ;; <CJK>
       (?$(11@(B . "0x7835") ;; <CJK>
       (?$(11A(B . "0x782F") ;; <CJK>
       (?$(11B(B . "0x7828") ;; <CJK>
       (?$(11C(B . "0x782E") ;; <CJK>
       (?$(11D(B . "0x782B") ;; <CJK>
       (?$(11E(B . "0x7821") ;; <CJK>
       (?$(11F(B . "0x7829") ;; <CJK>
       (?$(11G(B . "0x7833") ;; <CJK>
       (?$(11H(B . "0x782A") ;; <CJK>
       (?$(11I(B . "0x7831") ;; <CJK>
       (?$(11J(B . "0x7954") ;; <CJK>
       (?$(11K(B . "0x795B") ;; <CJK>
       (?$(11L(B . "0x794F") ;; <CJK>
       (?$(11M(B . "0x795C") ;; <CJK>
       (?$(11N(B . "0x7953") ;; <CJK>
       (?$(11O(B . "0x7952") ;; <CJK>
       (?$(11P(B . "0x7951") ;; <CJK>
       (?$(11Q(B . "0x79EB") ;; <CJK>
       (?$(11R(B . "0x79EC") ;; <CJK>
       (?$(11S(B . "0x79E0") ;; <CJK>
       (?$(11T(B . "0x79EE") ;; <CJK>
       (?$(11U(B . "0x79ED") ;; <CJK>
       (?$(11V(B . "0x79EA") ;; <CJK>
       (?$(11W(B . "0x79DC") ;; <CJK>
       (?$(11X(B . "0x79DE") ;; <CJK>
       (?$(11Y(B . "0x79DD") ;; <CJK>
       (?$(11Z(B . "0x7A86") ;; <CJK>
       (?$(11[(B . "0x7A89") ;; <CJK>
       (?$(11\(B . "0x7A85") ;; <CJK>
       (?$(11](B . "0x7A8B") ;; <CJK>
       (?$(11^(B . "0x7A8C") ;; <CJK>
       (?$(11_(B . "0x7A8A") ;; <CJK>
       (?$(11`(B . "0x7A87") ;; <CJK>
       (?$(11a(B . "0x7AD8") ;; <CJK>
       (?$(11b(B . "0x7B10") ;; <CJK>
       (?$(11c(B . "0x7B04") ;; <CJK>
       (?$(11d(B . "0x7B13") ;; <CJK>
       (?$(11e(B . "0x7B05") ;; <CJK>
       (?$(11f(B . "0x7B0F") ;; <CJK>
       (?$(11g(B . "0x7B08") ;; <CJK>
       (?$(11h(B . "0x7B0A") ;; <CJK>
       (?$(11i(B . "0x7B0E") ;; <CJK>
       (?$(11j(B . "0x7B09") ;; <CJK>
       (?$(11k(B . "0x7B12") ;; <CJK>
       (?$(11l(B . "0x7C84") ;; <CJK>
       (?$(11m(B . "0x7C91") ;; <CJK>
       (?$(11n(B . "0x7C8A") ;; <CJK>
       (?$(11o(B . "0x7C8C") ;; <CJK>
       (?$(11p(B . "0x7C88") ;; <CJK>
       (?$(11q(B . "0x7C8D") ;; <CJK>
       (?$(11r(B . "0x7C85") ;; <CJK>
       (?$(11s(B . "0x7D1E") ;; <CJK>
       (?$(11t(B . "0x7D1D") ;; <CJK>
       (?$(11u(B . "0x7D11") ;; <CJK>
       (?$(11v(B . "0x7D0E") ;; <CJK>
       (?$(11w(B . "0x7D18") ;; <CJK>
       (?$(11x(B . "0x7D16") ;; <CJK>
       (?$(11y(B . "0x7D13") ;; <CJK>
       (?$(11z(B . "0x7D1F") ;; <CJK>
       (?$(11{(B . "0x7D12") ;; <CJK>
       (?$(11|(B . "0x7D0F") ;; <CJK>
       (?$(11}(B . "0x7D0C") ;; <CJK>
       (?$(11~(B . "0x7F5C") ;; <CJK>
       (?$(12!(B . "0x7F61") ;; <CJK>
       (?$(12"(B . "0x7F5E") ;; <CJK>
       (?$(12#(B . "0x7F60") ;; <CJK>
       (?$(12$(B . "0x7F5D") ;; <CJK>
       (?$(12%(B . "0x7F5B") ;; <CJK>
       (?$(12&(B . "0x7F96") ;; <CJK>
       (?$(12'(B . "0x7F92") ;; <CJK>
       (?$(12((B . "0x7FC3") ;; <CJK>
       (?$(12)(B . "0x7FC2") ;; <CJK>
       (?$(12*(B . "0x7FC0") ;; <CJK>
       (?$(12+(B . "0x8016") ;; <CJK>
       (?$(12,(B . "0x803E") ;; <CJK>
       (?$(12-(B . "0x8039") ;; <CJK>
       (?$(12.(B . "0x80FA") ;; <CJK>
       (?$(12/(B . "0x80F2") ;; <CJK>
       (?$(120(B . "0x80F9") ;; <CJK>
       (?$(121(B . "0x80F5") ;; <CJK>
       (?$(122(B . "0x8101") ;; <CJK>
       (?$(123(B . "0x80FB") ;; <CJK>
       (?$(124(B . "0x8100") ;; <CJK>
       (?$(125(B . "0x8201") ;; <CJK>
       (?$(126(B . "0x822F") ;; <CJK>
       (?$(127(B . "0x8225") ;; <CJK>
       (?$(128(B . "0x8333") ;; <CJK>
       (?$(129(B . "0x832D") ;; <CJK>
       (?$(12:(B . "0x8344") ;; <CJK>
       (?$(12;(B . "0x8319") ;; <CJK>
       (?$(12<(B . "0x8351") ;; <CJK>
       (?$(12=(B . "0x8325") ;; <CJK>
       (?$(12>(B . "0x8356") ;; <CJK>
       (?$(12?(B . "0x833F") ;; <CJK>
       (?$(12@(B . "0x8341") ;; <CJK>
       (?$(12A(B . "0x8326") ;; <CJK>
       (?$(12B(B . "0x831C") ;; <CJK>
       (?$(12C(B . "0x8322") ;; <CJK>
       (?$(12D(B . "0x8342") ;; <CJK>
       (?$(12E(B . "0x834E") ;; <CJK>
       (?$(12F(B . "0x831B") ;; <CJK>
       (?$(12G(B . "0x832A") ;; <CJK>
       (?$(12H(B . "0x8308") ;; <CJK>
       (?$(12I(B . "0x833C") ;; <CJK>
       (?$(12J(B . "0x834D") ;; <CJK>
       (?$(12K(B . "0x8316") ;; <CJK>
       (?$(12L(B . "0x8324") ;; <CJK>
       (?$(12M(B . "0x8320") ;; <CJK>
       (?$(12N(B . "0x8337") ;; <CJK>
       (?$(12O(B . "0x832F") ;; <CJK>
       (?$(12P(B . "0x8329") ;; <CJK>
       (?$(12Q(B . "0x8347") ;; <CJK>
       (?$(12R(B . "0x8345") ;; <CJK>
       (?$(12S(B . "0x834C") ;; <CJK>
       (?$(12T(B . "0x8353") ;; <CJK>
       (?$(12U(B . "0x831E") ;; <CJK>
       (?$(12V(B . "0x832C") ;; <CJK>
       (?$(12W(B . "0x834B") ;; <CJK>
       (?$(12X(B . "0x8327") ;; <CJK>
       (?$(12Y(B . "0x8348") ;; <CJK>
       (?$(12Z(B . "0x8653") ;; <CJK>
       (?$(12[(B . "0x8652") ;; <CJK>
       (?$(12\(B . "0x86A2") ;; <CJK>
       (?$(12](B . "0x86A8") ;; <CJK>
       (?$(12^(B . "0x8696") ;; <CJK>
       (?$(12_(B . "0x868D") ;; <CJK>
       (?$(12`(B . "0x8691") ;; <CJK>
       (?$(12a(B . "0x869E") ;; <CJK>
       (?$(12b(B . "0x8687") ;; <CJK>
       (?$(12c(B . "0x8697") ;; <CJK>
       (?$(12d(B . "0x8686") ;; <CJK>
       (?$(12e(B . "0x868B") ;; <CJK>
       (?$(12f(B . "0x869A") ;; <CJK>
       (?$(12g(B . "0x8685") ;; <CJK>
       (?$(12h(B . "0x86A5") ;; <CJK>
       (?$(12i(B . "0x8699") ;; <CJK>
       (?$(12j(B . "0x86A1") ;; <CJK>
       (?$(12k(B . "0x86A7") ;; <CJK>
       (?$(12l(B . "0x8695") ;; <CJK>
       (?$(12m(B . "0x8698") ;; <CJK>
       (?$(12n(B . "0x868E") ;; <CJK>
       (?$(12o(B . "0x869D") ;; <CJK>
       (?$(12p(B . "0x8690") ;; <CJK>
       (?$(12q(B . "0x8694") ;; <CJK>
       (?$(12r(B . "0x8843") ;; <CJK>
       (?$(12s(B . "0x8844") ;; <CJK>
       (?$(12t(B . "0x886D") ;; <CJK>
       (?$(12u(B . "0x8875") ;; <CJK>
       (?$(12v(B . "0x8876") ;; <CJK>
       (?$(12w(B . "0x8872") ;; <CJK>
       (?$(12x(B . "0x8880") ;; <CJK>
       (?$(12y(B . "0x8871") ;; <CJK>
       (?$(12z(B . "0x887F") ;; <CJK>
       (?$(12{(B . "0x886F") ;; <CJK>
       (?$(12|(B . "0x8883") ;; <CJK>
       (?$(12}(B . "0x887E") ;; <CJK>
       (?$(12~(B . "0x8874") ;; <CJK>
       (?$(13!(B . "0x887C") ;; <CJK>
       (?$(13"(B . "0x8A12") ;; <CJK>
       (?$(13#(B . "0x8C47") ;; <CJK>
       (?$(13$(B . "0x8C57") ;; <CJK>
       (?$(13%(B . "0x8C7B") ;; <CJK>
       (?$(13&(B . "0x8CA4") ;; <CJK>
       (?$(13'(B . "0x8CA3") ;; <CJK>
       (?$(13((B . "0x8D76") ;; <CJK>
       (?$(13)(B . "0x8D78") ;; <CJK>
       (?$(13*(B . "0x8DB5") ;; <CJK>
       (?$(13+(B . "0x8DB7") ;; <CJK>
       (?$(13,(B . "0x8DB6") ;; <CJK>
       (?$(13-(B . "0x8ED1") ;; <CJK>
       (?$(13.(B . "0x8ED3") ;; <CJK>
       (?$(13/(B . "0x8FFE") ;; <CJK>
       (?$(130(B . "0x8FF5") ;; <CJK>
       (?$(131(B . "0x9002") ;; <CJK>
       (?$(132(B . "0x8FFF") ;; <CJK>
       (?$(133(B . "0x8FFB") ;; <CJK>
       (?$(134(B . "0x9004") ;; <CJK>
       (?$(135(B . "0x8FFC") ;; <CJK>
       (?$(136(B . "0x8FF6") ;; <CJK>
       (?$(137(B . "0x90D6") ;; <CJK>
       (?$(138(B . "0x90E0") ;; <CJK>
       (?$(139(B . "0x90D9") ;; <CJK>
       (?$(13:(B . "0x90DA") ;; <CJK>
       (?$(13;(B . "0x90E3") ;; <CJK>
       (?$(13<(B . "0x90DF") ;; <CJK>
       (?$(13=(B . "0x90E5") ;; <CJK>
       (?$(13>(B . "0x90D8") ;; <CJK>
       (?$(13?(B . "0x90DB") ;; <CJK>
       (?$(13@(B . "0x90D7") ;; <CJK>
       (?$(13A(B . "0x90DC") ;; <CJK>
       (?$(13B(B . "0x90E4") ;; <CJK>
       (?$(13C(B . "0x9150") ;; <CJK>
       (?$(13D(B . "0x914E") ;; <CJK>
       (?$(13E(B . "0x914F") ;; <CJK>
       (?$(13F(B . "0x91D5") ;; <CJK>
       (?$(13G(B . "0x91E2") ;; <CJK>
       (?$(13H(B . "0x91DA") ;; <CJK>
       (?$(13I(B . "0x965C") ;; <CJK>
       (?$(13J(B . "0x965F") ;; <CJK>
       (?$(13K(B . "0x96BC") ;; <CJK>
       (?$(13L(B . "0x98E3") ;; <CJK>
       (?$(13M(B . "0x9ADF") ;; <CJK>
       (?$(13N(B . "0x9B2F") ;; <CJK>
       (?$(13O(B . "0x4E7F") ;; <CJK>
       (?$(13P(B . "0x5070") ;; <CJK>
       (?$(13Q(B . "0x506A") ;; <CJK>
       (?$(13R(B . "0x5061") ;; <CJK>
       (?$(13S(B . "0x505E") ;; <CJK>
       (?$(13T(B . "0x5060") ;; <CJK>
       (?$(13U(B . "0x5053") ;; <CJK>
       (?$(13V(B . "0x504B") ;; <CJK>
       (?$(13W(B . "0x505D") ;; <CJK>
       (?$(13X(B . "0x5072") ;; <CJK>
       (?$(13Y(B . "0x5048") ;; <CJK>
       (?$(13Z(B . "0x504D") ;; <CJK>
       (?$(13[(B . "0x5041") ;; <CJK>
       (?$(13\(B . "0x505B") ;; <CJK>
       (?$(13](B . "0x504A") ;; <CJK>
       (?$(13^(B . "0x5062") ;; <CJK>
       (?$(13_(B . "0x5015") ;; <CJK>
       (?$(13`(B . "0x5045") ;; <CJK>
       (?$(13a(B . "0x505F") ;; <CJK>
       (?$(13b(B . "0x5069") ;; <CJK>
       (?$(13c(B . "0x506B") ;; <CJK>
       (?$(13d(B . "0x5063") ;; <CJK>
       (?$(13e(B . "0x5064") ;; <CJK>
       (?$(13f(B . "0x5046") ;; <CJK>
       (?$(13g(B . "0x5040") ;; <CJK>
       (?$(13h(B . "0x506E") ;; <CJK>
       (?$(13i(B . "0x5073") ;; <CJK>
       (?$(13j(B . "0x5057") ;; <CJK>
       (?$(13k(B . "0x5051") ;; <CJK>
       (?$(13l(B . "0x51D0") ;; <CJK>
       (?$(13m(B . "0x526B") ;; <CJK>
       (?$(13n(B . "0x526D") ;; <CJK>
       (?$(13o(B . "0x526C") ;; <CJK>
       (?$(13p(B . "0x526E") ;; <CJK>
       (?$(13q(B . "0x52D6") ;; <CJK>
       (?$(13r(B . "0x52D3") ;; <CJK>
       (?$(13s(B . "0x532D") ;; <CJK>
       (?$(13t(B . "0x539C") ;; <CJK>
       (?$(13u(B . "0x5575") ;; <CJK>
       (?$(13v(B . "0x5576") ;; <CJK>
       (?$(13w(B . "0x553C") ;; <CJK>
       (?$(13x(B . "0x554D") ;; <CJK>
       (?$(13y(B . "0x5550") ;; <CJK>
       (?$(13z(B . "0x5534") ;; <CJK>
       (?$(13{(B . "0x552A") ;; <CJK>
       (?$(13|(B . "0x5551") ;; <CJK>
       (?$(13}(B . "0x5562") ;; <CJK>
       (?$(13~(B . "0x5536") ;; <CJK>
       (?$(14!(B . "0x5535") ;; <CJK>
       (?$(14"(B . "0x5530") ;; <CJK>
       (?$(14#(B . "0x5552") ;; <CJK>
       (?$(14$(B . "0x5545") ;; <CJK>
       (?$(14%(B . "0x550C") ;; <CJK>
       (?$(14&(B . "0x5532") ;; <CJK>
       (?$(14'(B . "0x5565") ;; <CJK>
       (?$(14((B . "0x554E") ;; <CJK>
       (?$(14)(B . "0x5539") ;; <CJK>
       (?$(14*(B . "0x5548") ;; <CJK>
       (?$(14+(B . "0x552D") ;; <CJK>
       (?$(14,(B . "0x553B") ;; <CJK>
       (?$(14-(B . "0x5540") ;; <CJK>
       (?$(14.(B . "0x554B") ;; <CJK>
       (?$(14/(B . "0x570A") ;; <CJK>
       (?$(140(B . "0x5707") ;; <CJK>
       (?$(141(B . "0x57FB") ;; <CJK>
       (?$(142(B . "0x5814") ;; <CJK>
       (?$(143(B . "0x57E2") ;; <CJK>
       (?$(144(B . "0x57F6") ;; <CJK>
       (?$(145(B . "0x57DC") ;; <CJK>
       (?$(146(B . "0x57F4") ;; <CJK>
       (?$(147(B . "0x5800") ;; <CJK>
       (?$(148(B . "0x57ED") ;; <CJK>
       (?$(149(B . "0x57FD") ;; <CJK>
       (?$(14:(B . "0x5808") ;; <CJK>
       (?$(14;(B . "0x57F8") ;; <CJK>
       (?$(14<(B . "0x580B") ;; <CJK>
       (?$(14=(B . "0x57F3") ;; <CJK>
       (?$(14>(B . "0x57CF") ;; <CJK>
       (?$(14?(B . "0x5807") ;; <CJK>
       (?$(14@(B . "0x57EE") ;; <CJK>
       (?$(14A(B . "0x57E3") ;; <CJK>
       (?$(14B(B . "0x57F2") ;; <CJK>
       (?$(14C(B . "0x57E5") ;; <CJK>
       (?$(14D(B . "0x57EC") ;; <CJK>
       (?$(14E(B . "0x57E1") ;; <CJK>
       (?$(14F(B . "0x580E") ;; <CJK>
       (?$(14G(B . "0x57FC") ;; <CJK>
       (?$(14H(B . "0x5810") ;; <CJK>
       (?$(14I(B . "0x57E7") ;; <CJK>
       (?$(14J(B . "0x5801") ;; <CJK>
       (?$(14K(B . "0x580C") ;; <CJK>
       (?$(14L(B . "0x57F1") ;; <CJK>
       (?$(14M(B . "0x57E9") ;; <CJK>
       (?$(14N(B . "0x57F0") ;; <CJK>
       (?$(14O(B . "0x580D") ;; <CJK>
       (?$(14P(B . "0x5804") ;; <CJK>
       (?$(14Q(B . "0x595C") ;; <CJK>
       (?$(14R(B . "0x5A60") ;; <CJK>
       (?$(14S(B . "0x5A58") ;; <CJK>
       (?$(14T(B . "0x5A55") ;; <CJK>
       (?$(14U(B . "0x5A67") ;; <CJK>
       (?$(14V(B . "0x5A5E") ;; <CJK>
       (?$(14W(B . "0x5A38") ;; <CJK>
       (?$(14X(B . "0x5A35") ;; <CJK>
       (?$(14Y(B . "0x5A6D") ;; <CJK>
       (?$(14Z(B . "0x5A50") ;; <CJK>
       (?$(14[(B . "0x5A5F") ;; <CJK>
       (?$(14\(B . "0x5A65") ;; <CJK>
       (?$(14](B . "0x5A6C") ;; <CJK>
       (?$(14^(B . "0x5A53") ;; <CJK>
       (?$(14_(B . "0x5A64") ;; <CJK>
       (?$(14`(B . "0x5A57") ;; <CJK>
       (?$(14a(B . "0x5A43") ;; <CJK>
       (?$(14b(B . "0x5A5D") ;; <CJK>
       (?$(14c(B . "0x5A52") ;; <CJK>
       (?$(14d(B . "0x5A44") ;; <CJK>
       (?$(14e(B . "0x5A5B") ;; <CJK>
       (?$(14f(B . "0x5A48") ;; <CJK>
       (?$(14g(B . "0x5A8E") ;; <CJK>
       (?$(14h(B . "0x5A3E") ;; <CJK>
       (?$(14i(B . "0x5A4D") ;; <CJK>
       (?$(14j(B . "0x5A39") ;; <CJK>
       (?$(14k(B . "0x5A4C") ;; <CJK>
       (?$(14l(B . "0x5A70") ;; <CJK>
       (?$(14m(B . "0x5A69") ;; <CJK>
       (?$(14n(B . "0x5A47") ;; <CJK>
       (?$(14o(B . "0x5A51") ;; <CJK>
       (?$(14p(B . "0x5A56") ;; <CJK>
       (?$(14q(B . "0x5A42") ;; <CJK>
       (?$(14r(B . "0x5A5C") ;; <CJK>
       (?$(14s(B . "0x5B72") ;; <CJK>
       (?$(14t(B . "0x5B6E") ;; <CJK>
       (?$(14u(B . "0x5BC1") ;; <CJK>
       (?$(14v(B . "0x5BC0") ;; <CJK>
       (?$(14w(B . "0x5C59") ;; <CJK>
       (?$(14x(B . "0x5D1E") ;; <CJK>
       (?$(14y(B . "0x5D0B") ;; <CJK>
       (?$(14z(B . "0x5D1D") ;; <CJK>
       (?$(14{(B . "0x5D1A") ;; <CJK>
       (?$(14|(B . "0x5D20") ;; <CJK>
       (?$(14}(B . "0x5D0C") ;; <CJK>
       (?$(14~(B . "0x5D28") ;; <CJK>
       (?$(15!(B . "0x5D0D") ;; <CJK>
       (?$(15"(B . "0x5D26") ;; <CJK>
       (?$(15#(B . "0x5D25") ;; <CJK>
       (?$(15$(B . "0x5D0F") ;; <CJK>
       (?$(15%(B . "0x5D30") ;; <CJK>
       (?$(15&(B . "0x5D12") ;; <CJK>
       (?$(15'(B . "0x5D23") ;; <CJK>
       (?$(15((B . "0x5D1F") ;; <CJK>
       (?$(15)(B . "0x5D2E") ;; <CJK>
       (?$(15*(B . "0x5E3E") ;; <CJK>
       (?$(15+(B . "0x5E34") ;; <CJK>
       (?$(15,(B . "0x5EB1") ;; <CJK>
       (?$(15-(B . "0x5EB4") ;; <CJK>
       (?$(15.(B . "0x5EB9") ;; <CJK>
       (?$(15/(B . "0x5EB2") ;; <CJK>
       (?$(150(B . "0x5EB3") ;; <CJK>
       (?$(151(B . "0x5F36") ;; <CJK>
       (?$(152(B . "0x5F38") ;; <CJK>
       (?$(153(B . "0x5F9B") ;; <CJK>
       (?$(154(B . "0x5F96") ;; <CJK>
       (?$(155(B . "0x5F9F") ;; <CJK>
       (?$(156(B . "0x608A") ;; <CJK>
       (?$(157(B . "0x6090") ;; <CJK>
       (?$(158(B . "0x6086") ;; <CJK>
       (?$(159(B . "0x60BE") ;; <CJK>
       (?$(15:(B . "0x60B0") ;; <CJK>
       (?$(15;(B . "0x60BA") ;; <CJK>
       (?$(15<(B . "0x60D3") ;; <CJK>
       (?$(15=(B . "0x60D4") ;; <CJK>
       (?$(15>(B . "0x60CF") ;; <CJK>
       (?$(15?(B . "0x60E4") ;; <CJK>
       (?$(15@(B . "0x60D9") ;; <CJK>
       (?$(15A(B . "0x60DD") ;; <CJK>
       (?$(15B(B . "0x60C8") ;; <CJK>
       (?$(15C(B . "0x60B1") ;; <CJK>
       (?$(15D(B . "0x60DB") ;; <CJK>
       (?$(15E(B . "0x60B7") ;; <CJK>
       (?$(15F(B . "0x60CA") ;; <CJK>
       (?$(15G(B . "0x60BF") ;; <CJK>
       (?$(15H(B . "0x60C3") ;; <CJK>
       (?$(15I(B . "0x60CD") ;; <CJK>
       (?$(15J(B . "0x60C0") ;; <CJK>
       (?$(15K(B . "0x6332") ;; <CJK>
       (?$(15L(B . "0x6365") ;; <CJK>
       (?$(15M(B . "0x638A") ;; <CJK>
       (?$(15N(B . "0x6382") ;; <CJK>
       (?$(15O(B . "0x637D") ;; <CJK>
       (?$(15P(B . "0x63BD") ;; <CJK>
       (?$(15Q(B . "0x639E") ;; <CJK>
       (?$(15R(B . "0x63AD") ;; <CJK>
       (?$(15S(B . "0x639D") ;; <CJK>
       (?$(15T(B . "0x6397") ;; <CJK>
       (?$(15U(B . "0x63AB") ;; <CJK>
       (?$(15V(B . "0x638E") ;; <CJK>
       (?$(15W(B . "0x636F") ;; <CJK>
       (?$(15X(B . "0x6387") ;; <CJK>
       (?$(15Y(B . "0x6390") ;; <CJK>
       (?$(15Z(B . "0x636E") ;; <CJK>
       (?$(15[(B . "0x63AF") ;; <CJK>
       (?$(15\(B . "0x6375") ;; <CJK>
       (?$(15](B . "0x639C") ;; <CJK>
       (?$(15^(B . "0x636D") ;; <CJK>
       (?$(15_(B . "0x63AE") ;; <CJK>
       (?$(15`(B . "0x637C") ;; <CJK>
       (?$(15a(B . "0x63A4") ;; <CJK>
       (?$(15b(B . "0x633B") ;; <CJK>
       (?$(15c(B . "0x639F") ;; <CJK>
       (?$(15d(B . "0x6378") ;; <CJK>
       (?$(15e(B . "0x6385") ;; <CJK>
       (?$(15f(B . "0x6381") ;; <CJK>
       (?$(15g(B . "0x6391") ;; <CJK>
       (?$(15h(B . "0x638D") ;; <CJK>
       (?$(15i(B . "0x6370") ;; <CJK>
       (?$(15j(B . "0x6553") ;; <CJK>
       (?$(15k(B . "0x65CD") ;; <CJK>
       (?$(15l(B . "0x6665") ;; <CJK>
       (?$(15m(B . "0x6661") ;; <CJK>
       (?$(15n(B . "0x665B") ;; <CJK>
       (?$(15o(B . "0x6659") ;; <CJK>
       (?$(15p(B . "0x665C") ;; <CJK>
       (?$(15q(B . "0x6662") ;; <CJK>
       (?$(15r(B . "0x6718") ;; <CJK>
       (?$(15s(B . "0x6879") ;; <CJK>
       (?$(15t(B . "0x6887") ;; <CJK>
       (?$(15u(B . "0x6890") ;; <CJK>
       (?$(15v(B . "0x689C") ;; <CJK>
       (?$(15w(B . "0x686D") ;; <CJK>
       (?$(15x(B . "0x686E") ;; <CJK>
       (?$(15y(B . "0x68AE") ;; <CJK>
       (?$(15z(B . "0x68AB") ;; <CJK>
       (?$(15{(B . "0x6956") ;; <CJK>
       (?$(15|(B . "0x686F") ;; <CJK>
       (?$(15}(B . "0x68A3") ;; <CJK>
       (?$(15~(B . "0x68AC") ;; <CJK>
       (?$(16!(B . "0x68A9") ;; <CJK>
       (?$(16"(B . "0x6875") ;; <CJK>
       (?$(16#(B . "0x6874") ;; <CJK>
       (?$(16$(B . "0x68B2") ;; <CJK>
       (?$(16%(B . "0x688F") ;; <CJK>
       (?$(16&(B . "0x6877") ;; <CJK>
       (?$(16'(B . "0x6892") ;; <CJK>
       (?$(16((B . "0x687C") ;; <CJK>
       (?$(16)(B . "0x686B") ;; <CJK>
       (?$(16*(B . "0x6872") ;; <CJK>
       (?$(16+(B . "0x68AA") ;; <CJK>
       (?$(16,(B . "0x6880") ;; <CJK>
       (?$(16-(B . "0x6871") ;; <CJK>
       (?$(16.(B . "0x687E") ;; <CJK>
       (?$(16/(B . "0x689B") ;; <CJK>
       (?$(160(B . "0x6896") ;; <CJK>
       (?$(161(B . "0x688B") ;; <CJK>
       (?$(162(B . "0x68A0") ;; <CJK>
       (?$(163(B . "0x6889") ;; <CJK>
       (?$(164(B . "0x68A4") ;; <CJK>
       (?$(165(B . "0x6878") ;; <CJK>
       (?$(166(B . "0x687B") ;; <CJK>
       (?$(167(B . "0x6891") ;; <CJK>
       (?$(168(B . "0x688C") ;; <CJK>
       (?$(169(B . "0x688A") ;; <CJK>
       (?$(16:(B . "0x687D") ;; <CJK>
       (?$(16;(B . "0x6B36") ;; <CJK>
       (?$(16<(B . "0x6B33") ;; <CJK>
       (?$(16=(B . "0x6B37") ;; <CJK>
       (?$(16>(B . "0x6B38") ;; <CJK>
       (?$(16?(B . "0x6B91") ;; <CJK>
       (?$(16@(B . "0x6B8F") ;; <CJK>
       (?$(16A(B . "0x6B8D") ;; <CJK>
       (?$(16B(B . "0x6B8E") ;; <CJK>
       (?$(16C(B . "0x6B8C") ;; <CJK>
       (?$(16D(B . "0x6C2A") ;; <CJK>
       (?$(16E(B . "0x6DC0") ;; <CJK>
       (?$(16F(B . "0x6DAB") ;; <CJK>
       (?$(16G(B . "0x6DB4") ;; <CJK>
       (?$(16H(B . "0x6DB3") ;; <CJK>
       (?$(16I(B . "0x6E74") ;; <CJK>
       (?$(16J(B . "0x6DAC") ;; <CJK>
       (?$(16K(B . "0x6DE9") ;; <CJK>
       (?$(16L(B . "0x6DE2") ;; <CJK>
       (?$(16M(B . "0x6DB7") ;; <CJK>
       (?$(16N(B . "0x6DF6") ;; <CJK>
       (?$(16O(B . "0x6DD4") ;; <CJK>
       (?$(16P(B . "0x6E00") ;; <CJK>
       (?$(16Q(B . "0x6DC8") ;; <CJK>
       (?$(16R(B . "0x6DE0") ;; <CJK>
       (?$(16S(B . "0x6DDF") ;; <CJK>
       (?$(16T(B . "0x6DD6") ;; <CJK>
       (?$(16U(B . "0x6DBE") ;; <CJK>
       (?$(16V(B . "0x6DE5") ;; <CJK>
       (?$(16W(B . "0x6DDC") ;; <CJK>
       (?$(16X(B . "0x6DDD") ;; <CJK>
       (?$(16Y(B . "0x6DDB") ;; <CJK>
       (?$(16Z(B . "0x6DF4") ;; <CJK>
       (?$(16[(B . "0x6DCA") ;; <CJK>
       (?$(16\(B . "0x6DBD") ;; <CJK>
       (?$(16](B . "0x6DED") ;; <CJK>
       (?$(16^(B . "0x6DF0") ;; <CJK>
       (?$(16_(B . "0x6DBA") ;; <CJK>
       (?$(16`(B . "0x6DD5") ;; <CJK>
       (?$(16a(B . "0x6DC2") ;; <CJK>
       (?$(16b(B . "0x6DCF") ;; <CJK>
       (?$(16c(B . "0x6DC9") ;; <CJK>
       (?$(16d(B . "0x6DD0") ;; <CJK>
       (?$(16e(B . "0x6DF2") ;; <CJK>
       (?$(16f(B . "0x6DD3") ;; <CJK>
       (?$(16g(B . "0x6DFD") ;; <CJK>
       (?$(16h(B . "0x6DD7") ;; <CJK>
       (?$(16i(B . "0x6DCD") ;; <CJK>
       (?$(16j(B . "0x6DE3") ;; <CJK>
       (?$(16k(B . "0x6DBB") ;; <CJK>
       (?$(16l(B . "0x70FA") ;; <CJK>
       (?$(16m(B . "0x710D") ;; <CJK>
       (?$(16n(B . "0x70F7") ;; <CJK>
       (?$(16o(B . "0x7117") ;; <CJK>
       (?$(16p(B . "0x70F4") ;; <CJK>
       (?$(16q(B . "0x710C") ;; <CJK>
       (?$(16r(B . "0x70F0") ;; <CJK>
       (?$(16s(B . "0x7104") ;; <CJK>
       (?$(16t(B . "0x70F3") ;; <CJK>
       (?$(16u(B . "0x7110") ;; <CJK>
       (?$(16v(B . "0x70FC") ;; <CJK>
       (?$(16w(B . "0x70FF") ;; <CJK>
       (?$(16x(B . "0x7106") ;; <CJK>
       (?$(16y(B . "0x7113") ;; <CJK>
       (?$(16z(B . "0x7100") ;; <CJK>
       (?$(16{(B . "0x70F8") ;; <CJK>
       (?$(16|(B . "0x70F6") ;; <CJK>
       (?$(16}(B . "0x710B") ;; <CJK>
       (?$(16~(B . "0x7102") ;; <CJK>
       (?$(17!(B . "0x710E") ;; <CJK>
       (?$(17"(B . "0x727E") ;; <CJK>
       (?$(17#(B . "0x727B") ;; <CJK>
       (?$(17$(B . "0x727C") ;; <CJK>
       (?$(17%(B . "0x727F") ;; <CJK>
       (?$(17&(B . "0x731D") ;; <CJK>
       (?$(17'(B . "0x7317") ;; <CJK>
       (?$(17((B . "0x7307") ;; <CJK>
       (?$(17)(B . "0x7311") ;; <CJK>
       (?$(17*(B . "0x7318") ;; <CJK>
       (?$(17+(B . "0x730A") ;; <CJK>
       (?$(17,(B . "0x7308") ;; <CJK>
       (?$(17-(B . "0x72FF") ;; <CJK>
       (?$(17.(B . "0x730F") ;; <CJK>
       (?$(17/(B . "0x731E") ;; <CJK>
       (?$(170(B . "0x7388") ;; <CJK>
       (?$(171(B . "0x73F6") ;; <CJK>
       (?$(172(B . "0x73F8") ;; <CJK>
       (?$(173(B . "0x73F5") ;; <CJK>
       (?$(174(B . "0x7404") ;; <CJK>
       (?$(175(B . "0x7401") ;; <CJK>
       (?$(176(B . "0x73FD") ;; <CJK>
       (?$(177(B . "0x7407") ;; <CJK>
       (?$(178(B . "0x7400") ;; <CJK>
       (?$(179(B . "0x73FA") ;; <CJK>
       (?$(17:(B . "0x73FC") ;; <CJK>
       (?$(17;(B . "0x73FF") ;; <CJK>
       (?$(17<(B . "0x740C") ;; <CJK>
       (?$(17=(B . "0x740B") ;; <CJK>
       (?$(17>(B . "0x73F4") ;; <CJK>
       (?$(17?(B . "0x7408") ;; <CJK>
       (?$(17@(B . "0x7564") ;; <CJK>
       (?$(17A(B . "0x7563") ;; <CJK>
       (?$(17B(B . "0x75CE") ;; <CJK>
       (?$(17C(B . "0x75D2") ;; <CJK>
       (?$(17D(B . "0x75CF") ;; <CJK>
       (?$(17E(B . "0x75CB") ;; <CJK>
       (?$(17F(B . "0x75CC") ;; <CJK>
       (?$(17G(B . "0x75D1") ;; <CJK>
       (?$(17H(B . "0x75D0") ;; <CJK>
       (?$(17I(B . "0x768F") ;; <CJK>
       (?$(17J(B . "0x7689") ;; <CJK>
       (?$(17K(B . "0x76D3") ;; <CJK>
       (?$(17L(B . "0x7739") ;; <CJK>
       (?$(17M(B . "0x772F") ;; <CJK>
       (?$(17N(B . "0x772D") ;; <CJK>
       (?$(17O(B . "0x7731") ;; <CJK>
       (?$(17P(B . "0x7732") ;; <CJK>
       (?$(17Q(B . "0x7734") ;; <CJK>
       (?$(17R(B . "0x7733") ;; <CJK>
       (?$(17S(B . "0x773D") ;; <CJK>
       (?$(17T(B . "0x7725") ;; <CJK>
       (?$(17U(B . "0x773B") ;; <CJK>
       (?$(17V(B . "0x7735") ;; <CJK>
       (?$(17W(B . "0x7848") ;; <CJK>
       (?$(17X(B . "0x7852") ;; <CJK>
       (?$(17Y(B . "0x7849") ;; <CJK>
       (?$(17Z(B . "0x784D") ;; <CJK>
       (?$(17[(B . "0x784A") ;; <CJK>
       (?$(17\(B . "0x784C") ;; <CJK>
       (?$(17](B . "0x7826") ;; <CJK>
       (?$(17^(B . "0x7845") ;; <CJK>
       (?$(17_(B . "0x7850") ;; <CJK>
       (?$(17`(B . "0x7964") ;; <CJK>
       (?$(17a(B . "0x7967") ;; <CJK>
       (?$(17b(B . "0x7969") ;; <CJK>
       (?$(17c(B . "0x796A") ;; <CJK>
       (?$(17d(B . "0x7963") ;; <CJK>
       (?$(17e(B . "0x796B") ;; <CJK>
       (?$(17f(B . "0x7961") ;; <CJK>
       (?$(17g(B . "0x79BB") ;; <CJK>
       (?$(17h(B . "0x79FA") ;; <CJK>
       (?$(17i(B . "0x79F8") ;; <CJK>
       (?$(17j(B . "0x79F6") ;; <CJK>
       (?$(17k(B . "0x79F7") ;; <CJK>
       (?$(17l(B . "0x7A8F") ;; <CJK>
       (?$(17m(B . "0x7A94") ;; <CJK>
       (?$(17n(B . "0x7A90") ;; <CJK>
       (?$(17o(B . "0x7B35") ;; <CJK>
       (?$(17p(B . "0x7B47") ;; <CJK>
       (?$(17q(B . "0x7B34") ;; <CJK>
       (?$(17r(B . "0x7B25") ;; <CJK>
       (?$(17s(B . "0x7B30") ;; <CJK>
       (?$(17t(B . "0x7B22") ;; <CJK>
       (?$(17u(B . "0x7B24") ;; <CJK>
       (?$(17v(B . "0x7B33") ;; <CJK>
       (?$(17w(B . "0x7B18") ;; <CJK>
       (?$(17x(B . "0x7B2A") ;; <CJK>
       (?$(17y(B . "0x7B1D") ;; <CJK>
       (?$(17z(B . "0x7B31") ;; <CJK>
       (?$(17{(B . "0x7B2B") ;; <CJK>
       (?$(17|(B . "0x7B2D") ;; <CJK>
       (?$(17}(B . "0x7B2F") ;; <CJK>
       (?$(17~(B . "0x7B32") ;; <CJK>
       (?$(18!(B . "0x7B38") ;; <CJK>
       (?$(18"(B . "0x7B1A") ;; <CJK>
       (?$(18#(B . "0x7B23") ;; <CJK>
       (?$(18$(B . "0x7C94") ;; <CJK>
       (?$(18%(B . "0x7C98") ;; <CJK>
       (?$(18&(B . "0x7C96") ;; <CJK>
       (?$(18'(B . "0x7CA3") ;; <CJK>
       (?$(18((B . "0x7D35") ;; <CJK>
       (?$(18)(B . "0x7D3D") ;; <CJK>
       (?$(18*(B . "0x7D38") ;; <CJK>
       (?$(18+(B . "0x7D36") ;; <CJK>
       (?$(18,(B . "0x7D3A") ;; <CJK>
       (?$(18-(B . "0x7D45") ;; <CJK>
       (?$(18.(B . "0x7D2C") ;; <CJK>
       (?$(18/(B . "0x7D29") ;; <CJK>
       (?$(180(B . "0x7D41") ;; <CJK>
       (?$(181(B . "0x7D47") ;; <CJK>
       (?$(182(B . "0x7D3E") ;; <CJK>
       (?$(183(B . "0x7D3F") ;; <CJK>
       (?$(184(B . "0x7D4A") ;; <CJK>
       (?$(185(B . "0x7D3B") ;; <CJK>
       (?$(186(B . "0x7D28") ;; <CJK>
       (?$(187(B . "0x7F63") ;; <CJK>
       (?$(188(B . "0x7F95") ;; <CJK>
       (?$(189(B . "0x7F9C") ;; <CJK>
       (?$(18:(B . "0x7F9D") ;; <CJK>
       (?$(18;(B . "0x7F9B") ;; <CJK>
       (?$(18<(B . "0x7FCA") ;; <CJK>
       (?$(18=(B . "0x7FCB") ;; <CJK>
       (?$(18>(B . "0x7FCD") ;; <CJK>
       (?$(18?(B . "0x7FD0") ;; <CJK>
       (?$(18@(B . "0x7FD1") ;; <CJK>
       (?$(18A(B . "0x7FC7") ;; <CJK>
       (?$(18B(B . "0x7FCF") ;; <CJK>
       (?$(18C(B . "0x7FC9") ;; <CJK>
       (?$(18D(B . "0x801F") ;; <CJK>
       (?$(18E(B . "0x801E") ;; <CJK>
       (?$(18F(B . "0x801B") ;; <CJK>
       (?$(18G(B . "0x8047") ;; <CJK>
       (?$(18H(B . "0x8043") ;; <CJK>
       (?$(18I(B . "0x8048") ;; <CJK>
       (?$(18J(B . "0x8118") ;; <CJK>
       (?$(18K(B . "0x8125") ;; <CJK>
       (?$(18L(B . "0x8119") ;; <CJK>
       (?$(18M(B . "0x811B") ;; <CJK>
       (?$(18N(B . "0x812D") ;; <CJK>
       (?$(18O(B . "0x811F") ;; <CJK>
       (?$(18P(B . "0x812C") ;; <CJK>
       (?$(18Q(B . "0x811E") ;; <CJK>
       (?$(18R(B . "0x8121") ;; <CJK>
       (?$(18S(B . "0x8115") ;; <CJK>
       (?$(18T(B . "0x8127") ;; <CJK>
       (?$(18U(B . "0x811D") ;; <CJK>
       (?$(18V(B . "0x8122") ;; <CJK>
       (?$(18W(B . "0x8211") ;; <CJK>
       (?$(18X(B . "0x8238") ;; <CJK>
       (?$(18Y(B . "0x8233") ;; <CJK>
       (?$(18Z(B . "0x823A") ;; <CJK>
       (?$(18[(B . "0x8234") ;; <CJK>
       (?$(18\(B . "0x8232") ;; <CJK>
       (?$(18](B . "0x8274") ;; <CJK>
       (?$(18^(B . "0x8390") ;; <CJK>
       (?$(18_(B . "0x83A3") ;; <CJK>
       (?$(18`(B . "0x83A8") ;; <CJK>
       (?$(18a(B . "0x838D") ;; <CJK>
       (?$(18b(B . "0x837A") ;; <CJK>
       (?$(18c(B . "0x8373") ;; <CJK>
       (?$(18d(B . "0x83A4") ;; <CJK>
       (?$(18e(B . "0x8374") ;; <CJK>
       (?$(18f(B . "0x838F") ;; <CJK>
       (?$(18g(B . "0x8381") ;; <CJK>
       (?$(18h(B . "0x8395") ;; <CJK>
       (?$(18i(B . "0x8399") ;; <CJK>
       (?$(18j(B . "0x8375") ;; <CJK>
       (?$(18k(B . "0x8394") ;; <CJK>
       (?$(18l(B . "0x83A9") ;; <CJK>
       (?$(18m(B . "0x837D") ;; <CJK>
       (?$(18n(B . "0x8383") ;; <CJK>
       (?$(18o(B . "0x838C") ;; <CJK>
       (?$(18p(B . "0x839D") ;; <CJK>
       (?$(18q(B . "0x839B") ;; <CJK>
       (?$(18r(B . "0x83AA") ;; <CJK>
       (?$(18s(B . "0x838B") ;; <CJK>
       (?$(18t(B . "0x837E") ;; <CJK>
       (?$(18u(B . "0x83A5") ;; <CJK>
       (?$(18v(B . "0x83AF") ;; <CJK>
       (?$(18w(B . "0x8388") ;; <CJK>
       (?$(18x(B . "0x8397") ;; <CJK>
       (?$(18y(B . "0x83B0") ;; <CJK>
       (?$(18z(B . "0x837F") ;; <CJK>
       (?$(18{(B . "0x83A6") ;; <CJK>
       (?$(18|(B . "0x8387") ;; <CJK>
       (?$(18}(B . "0x83AE") ;; <CJK>
       (?$(18~(B . "0x8376") ;; <CJK>
       (?$(19!(B . "0x839A") ;; <CJK>
       (?$(19"(B . "0x8659") ;; <CJK>
       (?$(19#(B . "0x8656") ;; <CJK>
       (?$(19$(B . "0x86BF") ;; <CJK>
       (?$(19%(B . "0x86B7") ;; <CJK>
       (?$(19&(B . "0x86C2") ;; <CJK>
       (?$(19'(B . "0x86C1") ;; <CJK>
       (?$(19((B . "0x86C5") ;; <CJK>
       (?$(19)(B . "0x86BA") ;; <CJK>
       (?$(19*(B . "0x86B0") ;; <CJK>
       (?$(19+(B . "0x86C8") ;; <CJK>
       (?$(19,(B . "0x86B9") ;; <CJK>
       (?$(19-(B . "0x86B3") ;; <CJK>
       (?$(19.(B . "0x86B8") ;; <CJK>
       (?$(19/(B . "0x86CC") ;; <CJK>
       (?$(190(B . "0x86B4") ;; <CJK>
       (?$(191(B . "0x86BB") ;; <CJK>
       (?$(192(B . "0x86BC") ;; <CJK>
       (?$(193(B . "0x86C3") ;; <CJK>
       (?$(194(B . "0x86BD") ;; <CJK>
       (?$(195(B . "0x86BE") ;; <CJK>
       (?$(196(B . "0x8852") ;; <CJK>
       (?$(197(B . "0x8889") ;; <CJK>
       (?$(198(B . "0x8895") ;; <CJK>
       (?$(199(B . "0x88A8") ;; <CJK>
       (?$(19:(B . "0x88A2") ;; <CJK>
       (?$(19;(B . "0x88AA") ;; <CJK>
       (?$(19<(B . "0x889A") ;; <CJK>
       (?$(19=(B . "0x8891") ;; <CJK>
       (?$(19>(B . "0x88A1") ;; <CJK>
       (?$(19?(B . "0x889F") ;; <CJK>
       (?$(19@(B . "0x8898") ;; <CJK>
       (?$(19A(B . "0x88A7") ;; <CJK>
       (?$(19B(B . "0x8899") ;; <CJK>
       (?$(19C(B . "0x889B") ;; <CJK>
       (?$(19D(B . "0x8897") ;; <CJK>
       (?$(19E(B . "0x88A4") ;; <CJK>
       (?$(19F(B . "0x88AC") ;; <CJK>
       (?$(19G(B . "0x888C") ;; <CJK>
       (?$(19H(B . "0x8893") ;; <CJK>
       (?$(19I(B . "0x888E") ;; <CJK>
       (?$(19J(B . "0x8982") ;; <CJK>
       (?$(19K(B . "0x89D6") ;; <CJK>
       (?$(19L(B . "0x89D9") ;; <CJK>
       (?$(19M(B . "0x89D5") ;; <CJK>
       (?$(19N(B . "0x8A30") ;; <CJK>
       (?$(19O(B . "0x8A27") ;; <CJK>
       (?$(19P(B . "0x8A2C") ;; <CJK>
       (?$(19Q(B . "0x8A1E") ;; <CJK>
       (?$(19R(B . "0x8C39") ;; <CJK>
       (?$(19S(B . "0x8C3B") ;; <CJK>
       (?$(19T(B . "0x8C5C") ;; <CJK>
       (?$(19U(B . "0x8C5D") ;; <CJK>
       (?$(19V(B . "0x8C7D") ;; <CJK>
       (?$(19W(B . "0x8CA5") ;; <CJK>
       (?$(19X(B . "0x8D7D") ;; <CJK>
       (?$(19Y(B . "0x8D7B") ;; <CJK>
       (?$(19Z(B . "0x8D79") ;; <CJK>
       (?$(19[(B . "0x8DBC") ;; <CJK>
       (?$(19\(B . "0x8DC2") ;; <CJK>
       (?$(19](B . "0x8DB9") ;; <CJK>
       (?$(19^(B . "0x8DBF") ;; <CJK>
       (?$(19_(B . "0x8DC1") ;; <CJK>
       (?$(19`(B . "0x8ED8") ;; <CJK>
       (?$(19a(B . "0x8EDE") ;; <CJK>
       (?$(19b(B . "0x8EDD") ;; <CJK>
       (?$(19c(B . "0x8EDC") ;; <CJK>
       (?$(19d(B . "0x8ED7") ;; <CJK>
       (?$(19e(B . "0x8EE0") ;; <CJK>
       (?$(19f(B . "0x8EE1") ;; <CJK>
       (?$(19g(B . "0x9024") ;; <CJK>
       (?$(19h(B . "0x900B") ;; <CJK>
       (?$(19i(B . "0x9011") ;; <CJK>
       (?$(19j(B . "0x901C") ;; <CJK>
       (?$(19k(B . "0x900C") ;; <CJK>
       (?$(19l(B . "0x9021") ;; <CJK>
       (?$(19m(B . "0x90EF") ;; <CJK>
       (?$(19n(B . "0x90EA") ;; <CJK>
       (?$(19o(B . "0x90F0") ;; <CJK>
       (?$(19p(B . "0x90F4") ;; <CJK>
       (?$(19q(B . "0x90F2") ;; <CJK>
       (?$(19r(B . "0x90F3") ;; <CJK>
       (?$(19s(B . "0x90D4") ;; <CJK>
       (?$(19t(B . "0x90EB") ;; <CJK>
       (?$(19u(B . "0x90EC") ;; <CJK>
       (?$(19v(B . "0x90E9") ;; <CJK>
       (?$(19w(B . "0x9156") ;; <CJK>
       (?$(19x(B . "0x9158") ;; <CJK>
       (?$(19y(B . "0x915A") ;; <CJK>
       (?$(19z(B . "0x9153") ;; <CJK>
       (?$(19{(B . "0x9155") ;; <CJK>
       (?$(19|(B . "0x91EC") ;; <CJK>
       (?$(19}(B . "0x91F4") ;; <CJK>
       (?$(19~(B . "0x91F1") ;; <CJK>
       (?$(1:!(B . "0x91F3") ;; <CJK>
       (?$(1:"(B . "0x91F8") ;; <CJK>
       (?$(1:#(B . "0x91E4") ;; <CJK>
       (?$(1:$(B . "0x91F9") ;; <CJK>
       (?$(1:%(B . "0x91EA") ;; <CJK>
       (?$(1:&(B . "0x91EB") ;; <CJK>
       (?$(1:'(B . "0x91F7") ;; <CJK>
       (?$(1:((B . "0x91E8") ;; <CJK>
       (?$(1:)(B . "0x91EE") ;; <CJK>
       (?$(1:*(B . "0x957A") ;; <CJK>
       (?$(1:+(B . "0x9586") ;; <CJK>
       (?$(1:,(B . "0x9588") ;; <CJK>
       (?$(1:-(B . "0x967C") ;; <CJK>
       (?$(1:.(B . "0x966D") ;; <CJK>
       (?$(1:/(B . "0x966B") ;; <CJK>
       (?$(1:0(B . "0x9671") ;; <CJK>
       (?$(1:1(B . "0x966F") ;; <CJK>
       (?$(1:2(B . "0x96BF") ;; <CJK>
       (?$(1:3(B . "0x976A") ;; <CJK>
       (?$(1:4(B . "0x9804") ;; <CJK>
       (?$(1:5(B . "0x98E5") ;; <CJK>
       (?$(1:6(B . "0x9997") ;; <CJK>
       (?$(1:7(B . "0x509B") ;; <CJK>
       (?$(1:8(B . "0x5095") ;; <CJK>
       (?$(1:9(B . "0x5094") ;; <CJK>
       (?$(1::(B . "0x509E") ;; <CJK>
       (?$(1:;(B . "0x508B") ;; <CJK>
       (?$(1:<(B . "0x50A3") ;; <CJK>
       (?$(1:=(B . "0x5083") ;; <CJK>
       (?$(1:>(B . "0x508C") ;; <CJK>
       (?$(1:?(B . "0x508E") ;; <CJK>
       (?$(1:@(B . "0x509D") ;; <CJK>
       (?$(1:A(B . "0x5068") ;; <CJK>
       (?$(1:B(B . "0x509C") ;; <CJK>
       (?$(1:C(B . "0x5092") ;; <CJK>
       (?$(1:D(B . "0x5082") ;; <CJK>
       (?$(1:E(B . "0x5087") ;; <CJK>
       (?$(1:F(B . "0x515F") ;; <CJK>
       (?$(1:G(B . "0x51D4") ;; <CJK>
       (?$(1:H(B . "0x5312") ;; <CJK>
       (?$(1:I(B . "0x5311") ;; <CJK>
       (?$(1:J(B . "0x53A4") ;; <CJK>
       (?$(1:K(B . "0x53A7") ;; <CJK>
       (?$(1:L(B . "0x5591") ;; <CJK>
       (?$(1:M(B . "0x55A8") ;; <CJK>
       (?$(1:N(B . "0x55A5") ;; <CJK>
       (?$(1:O(B . "0x55AD") ;; <CJK>
       (?$(1:P(B . "0x5577") ;; <CJK>
       (?$(1:Q(B . "0x5645") ;; <CJK>
       (?$(1:R(B . "0x55A2") ;; <CJK>
       (?$(1:S(B . "0x5593") ;; <CJK>
       (?$(1:T(B . "0x5588") ;; <CJK>
       (?$(1:U(B . "0x558F") ;; <CJK>
       (?$(1:V(B . "0x55B5") ;; <CJK>
       (?$(1:W(B . "0x5581") ;; <CJK>
       (?$(1:X(B . "0x55A3") ;; <CJK>
       (?$(1:Y(B . "0x5592") ;; <CJK>
       (?$(1:Z(B . "0x55A4") ;; <CJK>
       (?$(1:[(B . "0x557D") ;; <CJK>
       (?$(1:\(B . "0x558C") ;; <CJK>
       (?$(1:](B . "0x55A6") ;; <CJK>
       (?$(1:^(B . "0x557F") ;; <CJK>
       (?$(1:_(B . "0x5595") ;; <CJK>
       (?$(1:`(B . "0x55A1") ;; <CJK>
       (?$(1:a(B . "0x558E") ;; <CJK>
       (?$(1:b(B . "0x570C") ;; <CJK>
       (?$(1:c(B . "0x5829") ;; <CJK>
       (?$(1:d(B . "0x5837") ;; <CJK>
       (?$(1:e(B . "0x5819") ;; <CJK>
       (?$(1:f(B . "0x581E") ;; <CJK>
       (?$(1:g(B . "0x5827") ;; <CJK>
       (?$(1:h(B . "0x5823") ;; <CJK>
       (?$(1:i(B . "0x5828") ;; <CJK>
       (?$(1:j(B . "0x57F5") ;; <CJK>
       (?$(1:k(B . "0x5848") ;; <CJK>
       (?$(1:l(B . "0x5825") ;; <CJK>
       (?$(1:m(B . "0x581C") ;; <CJK>
       (?$(1:n(B . "0x581B") ;; <CJK>
       (?$(1:o(B . "0x5833") ;; <CJK>
       (?$(1:p(B . "0x583F") ;; <CJK>
       (?$(1:q(B . "0x5836") ;; <CJK>
       (?$(1:r(B . "0x582E") ;; <CJK>
       (?$(1:s(B . "0x5839") ;; <CJK>
       (?$(1:t(B . "0x5838") ;; <CJK>
       (?$(1:u(B . "0x582D") ;; <CJK>
       (?$(1:v(B . "0x582C") ;; <CJK>
       (?$(1:w(B . "0x583B") ;; <CJK>
       (?$(1:x(B . "0x5961") ;; <CJK>
       (?$(1:y(B . "0x5AAF") ;; <CJK>
       (?$(1:z(B . "0x5A94") ;; <CJK>
       (?$(1:{(B . "0x5A9F") ;; <CJK>
       (?$(1:|(B . "0x5A7A") ;; <CJK>
       (?$(1:}(B . "0x5AA2") ;; <CJK>
       (?$(1:~(B . "0x5A9E") ;; <CJK>
       (?$(1;!(B . "0x5A78") ;; <CJK>
       (?$(1;"(B . "0x5AA6") ;; <CJK>
       (?$(1;#(B . "0x5A7C") ;; <CJK>
       (?$(1;$(B . "0x5AA5") ;; <CJK>
       (?$(1;%(B . "0x5AAC") ;; <CJK>
       (?$(1;&(B . "0x5A95") ;; <CJK>
       (?$(1;'(B . "0x5AAE") ;; <CJK>
       (?$(1;((B . "0x5A37") ;; <CJK>
       (?$(1;)(B . "0x5A84") ;; <CJK>
       (?$(1;*(B . "0x5A8A") ;; <CJK>
       (?$(1;+(B . "0x5A97") ;; <CJK>
       (?$(1;,(B . "0x5A83") ;; <CJK>
       (?$(1;-(B . "0x5A8B") ;; <CJK>
       (?$(1;.(B . "0x5AA9") ;; <CJK>
       (?$(1;/(B . "0x5A7B") ;; <CJK>
       (?$(1;0(B . "0x5A7D") ;; <CJK>
       (?$(1;1(B . "0x5A8C") ;; <CJK>
       (?$(1;2(B . "0x5A9C") ;; <CJK>
       (?$(1;3(B . "0x5A8F") ;; <CJK>
       (?$(1;4(B . "0x5A93") ;; <CJK>
       (?$(1;5(B . "0x5A9D") ;; <CJK>
       (?$(1;6(B . "0x5BEA") ;; <CJK>
       (?$(1;7(B . "0x5BCD") ;; <CJK>
       (?$(1;8(B . "0x5BCB") ;; <CJK>
       (?$(1;9(B . "0x5BD4") ;; <CJK>
       (?$(1;:(B . "0x5BD1") ;; <CJK>
       (?$(1;;(B . "0x5BCA") ;; <CJK>
       (?$(1;<(B . "0x5BCE") ;; <CJK>
       (?$(1;=(B . "0x5C0C") ;; <CJK>
       (?$(1;>(B . "0x5C30") ;; <CJK>
       (?$(1;?(B . "0x5D37") ;; <CJK>
       (?$(1;@(B . "0x5D43") ;; <CJK>
       (?$(1;A(B . "0x5D6B") ;; <CJK>
       (?$(1;B(B . "0x5D41") ;; <CJK>
       (?$(1;C(B . "0x5D4B") ;; <CJK>
       (?$(1;D(B . "0x5D3F") ;; <CJK>
       (?$(1;E(B . "0x5D35") ;; <CJK>
       (?$(1;F(B . "0x5D51") ;; <CJK>
       (?$(1;G(B . "0x5D4E") ;; <CJK>
       (?$(1;H(B . "0x5D55") ;; <CJK>
       (?$(1;I(B . "0x5D33") ;; <CJK>
       (?$(1;J(B . "0x5D3A") ;; <CJK>
       (?$(1;K(B . "0x5D52") ;; <CJK>
       (?$(1;L(B . "0x5D3D") ;; <CJK>
       (?$(1;M(B . "0x5D31") ;; <CJK>
       (?$(1;N(B . "0x5D59") ;; <CJK>
       (?$(1;O(B . "0x5D42") ;; <CJK>
       (?$(1;P(B . "0x5D39") ;; <CJK>
       (?$(1;Q(B . "0x5D49") ;; <CJK>
       (?$(1;R(B . "0x5D38") ;; <CJK>
       (?$(1;S(B . "0x5D3C") ;; <CJK>
       (?$(1;T(B . "0x5D32") ;; <CJK>
       (?$(1;U(B . "0x5D36") ;; <CJK>
       (?$(1;V(B . "0x5D40") ;; <CJK>
       (?$(1;W(B . "0x5D45") ;; <CJK>
       (?$(1;X(B . "0x5E44") ;; <CJK>
       (?$(1;Y(B . "0x5E41") ;; <CJK>
       (?$(1;Z(B . "0x5F58") ;; <CJK>
       (?$(1;[(B . "0x5FA6") ;; <CJK>
       (?$(1;\(B . "0x5FA5") ;; <CJK>
       (?$(1;](B . "0x5FAB") ;; <CJK>
       (?$(1;^(B . "0x60C9") ;; <CJK>
       (?$(1;_(B . "0x60B9") ;; <CJK>
       (?$(1;`(B . "0x60CC") ;; <CJK>
       (?$(1;a(B . "0x60E2") ;; <CJK>
       (?$(1;b(B . "0x60CE") ;; <CJK>
       (?$(1;c(B . "0x60C4") ;; <CJK>
       (?$(1;d(B . "0x6114") ;; <CJK>
       (?$(1;e(B . "0x60F2") ;; <CJK>
       (?$(1;f(B . "0x610A") ;; <CJK>
       (?$(1;g(B . "0x6116") ;; <CJK>
       (?$(1;h(B . "0x6105") ;; <CJK>
       (?$(1;i(B . "0x60F5") ;; <CJK>
       (?$(1;j(B . "0x6113") ;; <CJK>
       (?$(1;k(B . "0x60F8") ;; <CJK>
       (?$(1;l(B . "0x60FC") ;; <CJK>
       (?$(1;m(B . "0x60FE") ;; <CJK>
       (?$(1;n(B . "0x60C1") ;; <CJK>
       (?$(1;o(B . "0x6103") ;; <CJK>
       (?$(1;p(B . "0x6118") ;; <CJK>
       (?$(1;q(B . "0x611D") ;; <CJK>
       (?$(1;r(B . "0x6110") ;; <CJK>
       (?$(1;s(B . "0x60FF") ;; <CJK>
       (?$(1;t(B . "0x6104") ;; <CJK>
       (?$(1;u(B . "0x610B") ;; <CJK>
       (?$(1;v(B . "0x624A") ;; <CJK>
       (?$(1;w(B . "0x6394") ;; <CJK>
       (?$(1;x(B . "0x63B1") ;; <CJK>
       (?$(1;y(B . "0x63B0") ;; <CJK>
       (?$(1;z(B . "0x63CE") ;; <CJK>
       (?$(1;{(B . "0x63E5") ;; <CJK>
       (?$(1;|(B . "0x63E8") ;; <CJK>
       (?$(1;}(B . "0x63EF") ;; <CJK>
       (?$(1;~(B . "0x63C3") ;; <CJK>
       (?$(1<!(B . "0x649D") ;; <CJK>
       (?$(1<"(B . "0x63F3") ;; <CJK>
       (?$(1<#(B . "0x63CA") ;; <CJK>
       (?$(1<$(B . "0x63E0") ;; <CJK>
       (?$(1<%(B . "0x63F6") ;; <CJK>
       (?$(1<&(B . "0x63D5") ;; <CJK>
       (?$(1<'(B . "0x63F2") ;; <CJK>
       (?$(1<((B . "0x63F5") ;; <CJK>
       (?$(1<)(B . "0x6461") ;; <CJK>
       (?$(1<*(B . "0x63DF") ;; <CJK>
       (?$(1<+(B . "0x63BE") ;; <CJK>
       (?$(1<,(B . "0x63DD") ;; <CJK>
       (?$(1<-(B . "0x63DC") ;; <CJK>
       (?$(1<.(B . "0x63C4") ;; <CJK>
       (?$(1</(B . "0x63D8") ;; <CJK>
       (?$(1<0(B . "0x63D3") ;; <CJK>
       (?$(1<1(B . "0x63C2") ;; <CJK>
       (?$(1<2(B . "0x63C7") ;; <CJK>
       (?$(1<3(B . "0x63CC") ;; <CJK>
       (?$(1<4(B . "0x63CB") ;; <CJK>
       (?$(1<5(B . "0x63C8") ;; <CJK>
       (?$(1<6(B . "0x63F0") ;; <CJK>
       (?$(1<7(B . "0x63D7") ;; <CJK>
       (?$(1<8(B . "0x63D9") ;; <CJK>
       (?$(1<9(B . "0x6532") ;; <CJK>
       (?$(1<:(B . "0x6567") ;; <CJK>
       (?$(1<;(B . "0x656A") ;; <CJK>
       (?$(1<<(B . "0x6564") ;; <CJK>
       (?$(1<=(B . "0x655C") ;; <CJK>
       (?$(1<>(B . "0x6568") ;; <CJK>
       (?$(1<?(B . "0x6565") ;; <CJK>
       (?$(1<@(B . "0x658C") ;; <CJK>
       (?$(1<A(B . "0x659D") ;; <CJK>
       (?$(1<B(B . "0x659E") ;; <CJK>
       (?$(1<C(B . "0x65AE") ;; <CJK>
       (?$(1<D(B . "0x65D0") ;; <CJK>
       (?$(1<E(B . "0x65D2") ;; <CJK>
       (?$(1<F(B . "0x667C") ;; <CJK>
       (?$(1<G(B . "0x666C") ;; <CJK>
       (?$(1<H(B . "0x667B") ;; <CJK>
       (?$(1<I(B . "0x6680") ;; <CJK>
       (?$(1<J(B . "0x6671") ;; <CJK>
       (?$(1<K(B . "0x6679") ;; <CJK>
       (?$(1<L(B . "0x666A") ;; <CJK>
       (?$(1<M(B . "0x6672") ;; <CJK>
       (?$(1<N(B . "0x6701") ;; <CJK>
       (?$(1<O(B . "0x690C") ;; <CJK>
       (?$(1<P(B . "0x68D3") ;; <CJK>
       (?$(1<Q(B . "0x6904") ;; <CJK>
       (?$(1<R(B . "0x68DC") ;; <CJK>
       (?$(1<S(B . "0x692A") ;; <CJK>
       (?$(1<T(B . "0x68EC") ;; <CJK>
       (?$(1<U(B . "0x68EA") ;; <CJK>
       (?$(1<V(B . "0x68F1") ;; <CJK>
       (?$(1<W(B . "0x690F") ;; <CJK>
       (?$(1<X(B . "0x68D6") ;; <CJK>
       (?$(1<Y(B . "0x68F7") ;; <CJK>
       (?$(1<Z(B . "0x68EB") ;; <CJK>
       (?$(1<[(B . "0x68E4") ;; <CJK>
       (?$(1<\(B . "0x68F6") ;; <CJK>
       (?$(1<](B . "0x6913") ;; <CJK>
       (?$(1<^(B . "0x6910") ;; <CJK>
       (?$(1<_(B . "0x68F3") ;; <CJK>
       (?$(1<`(B . "0x68E1") ;; <CJK>
       (?$(1<a(B . "0x6907") ;; <CJK>
       (?$(1<b(B . "0x68CC") ;; <CJK>
       (?$(1<c(B . "0x6908") ;; <CJK>
       (?$(1<d(B . "0x6970") ;; <CJK>
       (?$(1<e(B . "0x68B4") ;; <CJK>
       (?$(1<f(B . "0x6911") ;; <CJK>
       (?$(1<g(B . "0x68EF") ;; <CJK>
       (?$(1<h(B . "0x68C6") ;; <CJK>
       (?$(1<i(B . "0x6914") ;; <CJK>
       (?$(1<j(B . "0x68F8") ;; <CJK>
       (?$(1<k(B . "0x68D0") ;; <CJK>
       (?$(1<l(B . "0x68FD") ;; <CJK>
       (?$(1<m(B . "0x68FC") ;; <CJK>
       (?$(1<n(B . "0x68E8") ;; <CJK>
       (?$(1<o(B . "0x690B") ;; <CJK>
       (?$(1<p(B . "0x690A") ;; <CJK>
       (?$(1<q(B . "0x6917") ;; <CJK>
       (?$(1<r(B . "0x68CE") ;; <CJK>
       (?$(1<s(B . "0x68C8") ;; <CJK>
       (?$(1<t(B . "0x68DD") ;; <CJK>
       (?$(1<u(B . "0x68DE") ;; <CJK>
       (?$(1<v(B . "0x68E6") ;; <CJK>
       (?$(1<w(B . "0x68F4") ;; <CJK>
       (?$(1<x(B . "0x68D1") ;; <CJK>
       (?$(1<y(B . "0x6906") ;; <CJK>
       (?$(1<z(B . "0x68D4") ;; <CJK>
       (?$(1<{(B . "0x68E9") ;; <CJK>
       (?$(1<|(B . "0x6915") ;; <CJK>
       (?$(1<}(B . "0x6925") ;; <CJK>
       (?$(1<~(B . "0x68C7") ;; <CJK>
       (?$(1=!(B . "0x6B39") ;; <CJK>
       (?$(1="(B . "0x6B3B") ;; <CJK>
       (?$(1=#(B . "0x6B3F") ;; <CJK>
       (?$(1=$(B . "0x6B3C") ;; <CJK>
       (?$(1=%(B . "0x6B94") ;; <CJK>
       (?$(1=&(B . "0x6B97") ;; <CJK>
       (?$(1='(B . "0x6B99") ;; <CJK>
       (?$(1=((B . "0x6B95") ;; <CJK>
       (?$(1=)(B . "0x6BBD") ;; <CJK>
       (?$(1=*(B . "0x6BF0") ;; <CJK>
       (?$(1=+(B . "0x6BF2") ;; <CJK>
       (?$(1=,(B . "0x6BF3") ;; <CJK>
       (?$(1=-(B . "0x6C30") ;; <CJK>
       (?$(1=.(B . "0x6DFC") ;; <CJK>
       (?$(1=/(B . "0x6E46") ;; <CJK>
       (?$(1=0(B . "0x6E47") ;; <CJK>
       (?$(1=1(B . "0x6E1F") ;; <CJK>
       (?$(1=2(B . "0x6E49") ;; <CJK>
       (?$(1=3(B . "0x6E88") ;; <CJK>
       (?$(1=4(B . "0x6E3C") ;; <CJK>
       (?$(1=5(B . "0x6E3D") ;; <CJK>
       (?$(1=6(B . "0x6E45") ;; <CJK>
       (?$(1=7(B . "0x6E62") ;; <CJK>
       (?$(1=8(B . "0x6E2B") ;; <CJK>
       (?$(1=9(B . "0x6E3F") ;; <CJK>
       (?$(1=:(B . "0x6E41") ;; <CJK>
       (?$(1=;(B . "0x6E5D") ;; <CJK>
       (?$(1=<(B . "0x6E73") ;; <CJK>
       (?$(1==(B . "0x6E1C") ;; <CJK>
       (?$(1=>(B . "0x6E33") ;; <CJK>
       (?$(1=?(B . "0x6E4B") ;; <CJK>
       (?$(1=@(B . "0x6E40") ;; <CJK>
       (?$(1=A(B . "0x6E51") ;; <CJK>
       (?$(1=B(B . "0x6E3B") ;; <CJK>
       (?$(1=C(B . "0x6E03") ;; <CJK>
       (?$(1=D(B . "0x6E2E") ;; <CJK>
       (?$(1=E(B . "0x6E5E") ;; <CJK>
       (?$(1=F(B . "0x6E68") ;; <CJK>
       (?$(1=G(B . "0x6E5C") ;; <CJK>
       (?$(1=H(B . "0x6E61") ;; <CJK>
       (?$(1=I(B . "0x6E31") ;; <CJK>
       (?$(1=J(B . "0x6E28") ;; <CJK>
       (?$(1=K(B . "0x6E60") ;; <CJK>
       (?$(1=L(B . "0x6E71") ;; <CJK>
       (?$(1=M(B . "0x6E6B") ;; <CJK>
       (?$(1=N(B . "0x6E39") ;; <CJK>
       (?$(1=O(B . "0x6E22") ;; <CJK>
       (?$(1=P(B . "0x6E30") ;; <CJK>
       (?$(1=Q(B . "0x6E53") ;; <CJK>
       (?$(1=R(B . "0x6E65") ;; <CJK>
       (?$(1=S(B . "0x6E27") ;; <CJK>
       (?$(1=T(B . "0x6E78") ;; <CJK>
       (?$(1=U(B . "0x6E64") ;; <CJK>
       (?$(1=V(B . "0x6E77") ;; <CJK>
       (?$(1=W(B . "0x6E55") ;; <CJK>
       (?$(1=X(B . "0x6E79") ;; <CJK>
       (?$(1=Y(B . "0x6E52") ;; <CJK>
       (?$(1=Z(B . "0x6E66") ;; <CJK>
       (?$(1=[(B . "0x6E35") ;; <CJK>
       (?$(1=\(B . "0x6E36") ;; <CJK>
       (?$(1=](B . "0x6E5A") ;; <CJK>
       (?$(1=^(B . "0x7120") ;; <CJK>
       (?$(1=_(B . "0x711E") ;; <CJK>
       (?$(1=`(B . "0x712F") ;; <CJK>
       (?$(1=a(B . "0x70FB") ;; <CJK>
       (?$(1=b(B . "0x712E") ;; <CJK>
       (?$(1=c(B . "0x7131") ;; <CJK>
       (?$(1=d(B . "0x7123") ;; <CJK>
       (?$(1=e(B . "0x7125") ;; <CJK>
       (?$(1=f(B . "0x7122") ;; <CJK>
       (?$(1=g(B . "0x7132") ;; <CJK>
       (?$(1=h(B . "0x711F") ;; <CJK>
       (?$(1=i(B . "0x7128") ;; <CJK>
       (?$(1=j(B . "0x713A") ;; <CJK>
       (?$(1=k(B . "0x711B") ;; <CJK>
       (?$(1=l(B . "0x724B") ;; <CJK>
       (?$(1=m(B . "0x725A") ;; <CJK>
       (?$(1=n(B . "0x7288") ;; <CJK>
       (?$(1=o(B . "0x7289") ;; <CJK>
       (?$(1=p(B . "0x7286") ;; <CJK>
       (?$(1=q(B . "0x7285") ;; <CJK>
       (?$(1=r(B . "0x728B") ;; <CJK>
       (?$(1=s(B . "0x7312") ;; <CJK>
       (?$(1=t(B . "0x730B") ;; <CJK>
       (?$(1=u(B . "0x7330") ;; <CJK>
       (?$(1=v(B . "0x7322") ;; <CJK>
       (?$(1=w(B . "0x7331") ;; <CJK>
       (?$(1=x(B . "0x7333") ;; <CJK>
       (?$(1=y(B . "0x7327") ;; <CJK>
       (?$(1=z(B . "0x7332") ;; <CJK>
       (?$(1={(B . "0x732D") ;; <CJK>
       (?$(1=|(B . "0x7326") ;; <CJK>
       (?$(1=}(B . "0x7323") ;; <CJK>
       (?$(1=~(B . "0x7335") ;; <CJK>
       (?$(1>!(B . "0x730C") ;; <CJK>
       (?$(1>"(B . "0x742E") ;; <CJK>
       (?$(1>#(B . "0x742C") ;; <CJK>
       (?$(1>$(B . "0x7430") ;; <CJK>
       (?$(1>%(B . "0x742B") ;; <CJK>
       (?$(1>&(B . "0x7416") ;; <CJK>
       (?$(1>'(B . "0x741A") ;; <CJK>
       (?$(1>((B . "0x7421") ;; <CJK>
       (?$(1>)(B . "0x742D") ;; <CJK>
       (?$(1>*(B . "0x7431") ;; <CJK>
       (?$(1>+(B . "0x7424") ;; <CJK>
       (?$(1>,(B . "0x7423") ;; <CJK>
       (?$(1>-(B . "0x741D") ;; <CJK>
       (?$(1>.(B . "0x7429") ;; <CJK>
       (?$(1>/(B . "0x7420") ;; <CJK>
       (?$(1>0(B . "0x7432") ;; <CJK>
       (?$(1>1(B . "0x74FB") ;; <CJK>
       (?$(1>2(B . "0x752F") ;; <CJK>
       (?$(1>3(B . "0x756F") ;; <CJK>
       (?$(1>4(B . "0x756C") ;; <CJK>
       (?$(1>5(B . "0x75E7") ;; <CJK>
       (?$(1>6(B . "0x75DA") ;; <CJK>
       (?$(1>7(B . "0x75E1") ;; <CJK>
       (?$(1>8(B . "0x75E6") ;; <CJK>
       (?$(1>9(B . "0x75DD") ;; <CJK>
       (?$(1>:(B . "0x75DF") ;; <CJK>
       (?$(1>;(B . "0x75E4") ;; <CJK>
       (?$(1><(B . "0x75D7") ;; <CJK>
       (?$(1>=(B . "0x7695") ;; <CJK>
       (?$(1>>(B . "0x7692") ;; <CJK>
       (?$(1>?(B . "0x76DA") ;; <CJK>
       (?$(1>@(B . "0x7746") ;; <CJK>
       (?$(1>A(B . "0x7747") ;; <CJK>
       (?$(1>B(B . "0x7744") ;; <CJK>
       (?$(1>C(B . "0x774D") ;; <CJK>
       (?$(1>D(B . "0x7745") ;; <CJK>
       (?$(1>E(B . "0x774A") ;; <CJK>
       (?$(1>F(B . "0x774E") ;; <CJK>
       (?$(1>G(B . "0x774B") ;; <CJK>
       (?$(1>H(B . "0x774C") ;; <CJK>
       (?$(1>I(B . "0x77DE") ;; <CJK>
       (?$(1>J(B . "0x77EC") ;; <CJK>
       (?$(1>K(B . "0x7860") ;; <CJK>
       (?$(1>L(B . "0x7864") ;; <CJK>
       (?$(1>M(B . "0x7865") ;; <CJK>
       (?$(1>N(B . "0x785C") ;; <CJK>
       (?$(1>O(B . "0x786D") ;; <CJK>
       (?$(1>P(B . "0x7871") ;; <CJK>
       (?$(1>Q(B . "0x786A") ;; <CJK>
       (?$(1>R(B . "0x786E") ;; <CJK>
       (?$(1>S(B . "0x7870") ;; <CJK>
       (?$(1>T(B . "0x7869") ;; <CJK>
       (?$(1>U(B . "0x7868") ;; <CJK>
       (?$(1>V(B . "0x785E") ;; <CJK>
       (?$(1>W(B . "0x7862") ;; <CJK>
       (?$(1>X(B . "0x7974") ;; <CJK>
       (?$(1>Y(B . "0x7973") ;; <CJK>
       (?$(1>Z(B . "0x7972") ;; <CJK>
       (?$(1>[(B . "0x7970") ;; <CJK>
       (?$(1>\(B . "0x7A02") ;; <CJK>
       (?$(1>](B . "0x7A0A") ;; <CJK>
       (?$(1>^(B . "0x7A03") ;; <CJK>
       (?$(1>_(B . "0x7A0C") ;; <CJK>
       (?$(1>`(B . "0x7A04") ;; <CJK>
       (?$(1>a(B . "0x7A99") ;; <CJK>
       (?$(1>b(B . "0x7AE6") ;; <CJK>
       (?$(1>c(B . "0x7AE4") ;; <CJK>
       (?$(1>d(B . "0x7B4A") ;; <CJK>
       (?$(1>e(B . "0x7B3B") ;; <CJK>
       (?$(1>f(B . "0x7B44") ;; <CJK>
       (?$(1>g(B . "0x7B48") ;; <CJK>
       (?$(1>h(B . "0x7B4C") ;; <CJK>
       (?$(1>i(B . "0x7B4E") ;; <CJK>
       (?$(1>j(B . "0x7B40") ;; <CJK>
       (?$(1>k(B . "0x7B58") ;; <CJK>
       (?$(1>l(B . "0x7B45") ;; <CJK>
       (?$(1>m(B . "0x7CA2") ;; <CJK>
       (?$(1>n(B . "0x7C9E") ;; <CJK>
       (?$(1>o(B . "0x7CA8") ;; <CJK>
       (?$(1>p(B . "0x7CA1") ;; <CJK>
       (?$(1>q(B . "0x7D58") ;; <CJK>
       (?$(1>r(B . "0x7D6F") ;; <CJK>
       (?$(1>s(B . "0x7D63") ;; <CJK>
       (?$(1>t(B . "0x7D53") ;; <CJK>
       (?$(1>u(B . "0x7D56") ;; <CJK>
       (?$(1>v(B . "0x7D67") ;; <CJK>
       (?$(1>w(B . "0x7D6A") ;; <CJK>
       (?$(1>x(B . "0x7D4F") ;; <CJK>
       (?$(1>y(B . "0x7D6D") ;; <CJK>
       (?$(1>z(B . "0x7D5C") ;; <CJK>
       (?$(1>{(B . "0x7D6B") ;; <CJK>
       (?$(1>|(B . "0x7D52") ;; <CJK>
       (?$(1>}(B . "0x7D54") ;; <CJK>
       (?$(1>~(B . "0x7D69") ;; <CJK>
       (?$(1?!(B . "0x7D51") ;; <CJK>
       (?$(1?"(B . "0x7D5F") ;; <CJK>
       (?$(1?#(B . "0x7D4E") ;; <CJK>
       (?$(1?$(B . "0x7F3E") ;; <CJK>
       (?$(1?%(B . "0x7F3F") ;; <CJK>
       (?$(1?&(B . "0x7F65") ;; <CJK>
       (?$(1?'(B . "0x7F66") ;; <CJK>
       (?$(1?((B . "0x7FA2") ;; <CJK>
       (?$(1?)(B . "0x7FA0") ;; <CJK>
       (?$(1?*(B . "0x7FA1") ;; <CJK>
       (?$(1?+(B . "0x7FD7") ;; <CJK>
       (?$(1?,(B . "0x8051") ;; <CJK>
       (?$(1?-(B . "0x804F") ;; <CJK>
       (?$(1?.(B . "0x8050") ;; <CJK>
       (?$(1?/(B . "0x80FE") ;; <CJK>
       (?$(1?0(B . "0x80D4") ;; <CJK>
       (?$(1?1(B . "0x8143") ;; <CJK>
       (?$(1?2(B . "0x814A") ;; <CJK>
       (?$(1?3(B . "0x8152") ;; <CJK>
       (?$(1?4(B . "0x814F") ;; <CJK>
       (?$(1?5(B . "0x8147") ;; <CJK>
       (?$(1?6(B . "0x813D") ;; <CJK>
       (?$(1?7(B . "0x814D") ;; <CJK>
       (?$(1?8(B . "0x813A") ;; <CJK>
       (?$(1?9(B . "0x81E6") ;; <CJK>
       (?$(1?:(B . "0x81EE") ;; <CJK>
       (?$(1?;(B . "0x81F7") ;; <CJK>
       (?$(1?<(B . "0x81F8") ;; <CJK>
       (?$(1?=(B . "0x81F9") ;; <CJK>
       (?$(1?>(B . "0x8204") ;; <CJK>
       (?$(1??(B . "0x823C") ;; <CJK>
       (?$(1?@(B . "0x823D") ;; <CJK>
       (?$(1?A(B . "0x823F") ;; <CJK>
       (?$(1?B(B . "0x8275") ;; <CJK>
       (?$(1?C(B . "0x833B") ;; <CJK>
       (?$(1?D(B . "0x83CF") ;; <CJK>
       (?$(1?E(B . "0x83F9") ;; <CJK>
       (?$(1?F(B . "0x8423") ;; <CJK>
       (?$(1?G(B . "0x83C0") ;; <CJK>
       (?$(1?H(B . "0x83E8") ;; <CJK>
       (?$(1?I(B . "0x8412") ;; <CJK>
       (?$(1?J(B . "0x83E7") ;; <CJK>
       (?$(1?K(B . "0x83E4") ;; <CJK>
       (?$(1?L(B . "0x83FC") ;; <CJK>
       (?$(1?M(B . "0x83F6") ;; <CJK>
       (?$(1?N(B . "0x8410") ;; <CJK>
       (?$(1?O(B . "0x83C6") ;; <CJK>
       (?$(1?P(B . "0x83C8") ;; <CJK>
       (?$(1?Q(B . "0x83EB") ;; <CJK>
       (?$(1?R(B . "0x83E3") ;; <CJK>
       (?$(1?S(B . "0x83BF") ;; <CJK>
       (?$(1?T(B . "0x8401") ;; <CJK>
       (?$(1?U(B . "0x83DD") ;; <CJK>
       (?$(1?V(B . "0x83E5") ;; <CJK>
       (?$(1?W(B . "0x83D8") ;; <CJK>
       (?$(1?X(B . "0x83FF") ;; <CJK>
       (?$(1?Y(B . "0x83E1") ;; <CJK>
       (?$(1?Z(B . "0x83CB") ;; <CJK>
       (?$(1?[(B . "0x83CE") ;; <CJK>
       (?$(1?\(B . "0x83D6") ;; <CJK>
       (?$(1?](B . "0x83F5") ;; <CJK>
       (?$(1?^(B . "0x83C9") ;; <CJK>
       (?$(1?_(B . "0x8409") ;; <CJK>
       (?$(1?`(B . "0x840F") ;; <CJK>
       (?$(1?a(B . "0x83DE") ;; <CJK>
       (?$(1?b(B . "0x8411") ;; <CJK>
       (?$(1?c(B . "0x8406") ;; <CJK>
       (?$(1?d(B . "0x83C2") ;; <CJK>
       (?$(1?e(B . "0x83F3") ;; <CJK>
       (?$(1?f(B . "0x83D5") ;; <CJK>
       (?$(1?g(B . "0x83FA") ;; <CJK>
       (?$(1?h(B . "0x83C7") ;; <CJK>
       (?$(1?i(B . "0x83D1") ;; <CJK>
       (?$(1?j(B . "0x83EA") ;; <CJK>
       (?$(1?k(B . "0x8413") ;; <CJK>
       (?$(1?l(B . "0x83C3") ;; <CJK>
       (?$(1?m(B . "0x83EC") ;; <CJK>
       (?$(1?n(B . "0x83EE") ;; <CJK>
       (?$(1?o(B . "0x83C4") ;; <CJK>
       (?$(1?p(B . "0x83FB") ;; <CJK>
       (?$(1?q(B . "0x83D7") ;; <CJK>
       (?$(1?r(B . "0x83E2") ;; <CJK>
       (?$(1?s(B . "0x841B") ;; <CJK>
       (?$(1?t(B . "0x83DB") ;; <CJK>
       (?$(1?u(B . "0x83FE") ;; <CJK>
       (?$(1?v(B . "0x86D8") ;; <CJK>
       (?$(1?w(B . "0x86E2") ;; <CJK>
       (?$(1?x(B . "0x86E6") ;; <CJK>
       (?$(1?y(B . "0x86D3") ;; <CJK>
       (?$(1?z(B . "0x86E3") ;; <CJK>
       (?$(1?{(B . "0x86DA") ;; <CJK>
       (?$(1?|(B . "0x86EA") ;; <CJK>
       (?$(1?}(B . "0x86DD") ;; <CJK>
       (?$(1?~(B . "0x86EB") ;; <CJK>
       (?$(1@!(B . "0x86DC") ;; <CJK>
       (?$(1@"(B . "0x86EC") ;; <CJK>
       (?$(1@#(B . "0x86E9") ;; <CJK>
       (?$(1@$(B . "0x86D7") ;; <CJK>
       (?$(1@%(B . "0x86E8") ;; <CJK>
       (?$(1@&(B . "0x86D1") ;; <CJK>
       (?$(1@'(B . "0x8848") ;; <CJK>
       (?$(1@((B . "0x8856") ;; <CJK>
       (?$(1@)(B . "0x8855") ;; <CJK>
       (?$(1@*(B . "0x88BA") ;; <CJK>
       (?$(1@+(B . "0x88D7") ;; <CJK>
       (?$(1@,(B . "0x88B9") ;; <CJK>
       (?$(1@-(B . "0x88B8") ;; <CJK>
       (?$(1@.(B . "0x88C0") ;; <CJK>
       (?$(1@/(B . "0x88BE") ;; <CJK>
       (?$(1@0(B . "0x88B6") ;; <CJK>
       (?$(1@1(B . "0x88BC") ;; <CJK>
       (?$(1@2(B . "0x88B7") ;; <CJK>
       (?$(1@3(B . "0x88BD") ;; <CJK>
       (?$(1@4(B . "0x88B2") ;; <CJK>
       (?$(1@5(B . "0x8901") ;; <CJK>
       (?$(1@6(B . "0x88C9") ;; <CJK>
       (?$(1@7(B . "0x8995") ;; <CJK>
       (?$(1@8(B . "0x8998") ;; <CJK>
       (?$(1@9(B . "0x8997") ;; <CJK>
       (?$(1@:(B . "0x89DD") ;; <CJK>
       (?$(1@;(B . "0x89DA") ;; <CJK>
       (?$(1@<(B . "0x89DB") ;; <CJK>
       (?$(1@=(B . "0x8A4E") ;; <CJK>
       (?$(1@>(B . "0x8A4D") ;; <CJK>
       (?$(1@?(B . "0x8A39") ;; <CJK>
       (?$(1@@(B . "0x8A59") ;; <CJK>
       (?$(1@A(B . "0x8A40") ;; <CJK>
       (?$(1@B(B . "0x8A57") ;; <CJK>
       (?$(1@C(B . "0x8A58") ;; <CJK>
       (?$(1@D(B . "0x8A44") ;; <CJK>
       (?$(1@E(B . "0x8A45") ;; <CJK>
       (?$(1@F(B . "0x8A52") ;; <CJK>
       (?$(1@G(B . "0x8A48") ;; <CJK>
       (?$(1@H(B . "0x8A51") ;; <CJK>
       (?$(1@I(B . "0x8A4A") ;; <CJK>
       (?$(1@J(B . "0x8A4C") ;; <CJK>
       (?$(1@K(B . "0x8A4F") ;; <CJK>
       (?$(1@L(B . "0x8C5F") ;; <CJK>
       (?$(1@M(B . "0x8C81") ;; <CJK>
       (?$(1@N(B . "0x8C80") ;; <CJK>
       (?$(1@O(B . "0x8CBA") ;; <CJK>
       (?$(1@P(B . "0x8CBE") ;; <CJK>
       (?$(1@Q(B . "0x8CB0") ;; <CJK>
       (?$(1@R(B . "0x8CB9") ;; <CJK>
       (?$(1@S(B . "0x8CB5") ;; <CJK>
       (?$(1@T(B . "0x8D84") ;; <CJK>
       (?$(1@U(B . "0x8D80") ;; <CJK>
       (?$(1@V(B . "0x8D89") ;; <CJK>
       (?$(1@W(B . "0x8DD8") ;; <CJK>
       (?$(1@X(B . "0x8DD3") ;; <CJK>
       (?$(1@Y(B . "0x8DCD") ;; <CJK>
       (?$(1@Z(B . "0x8DC7") ;; <CJK>
       (?$(1@[(B . "0x8DD6") ;; <CJK>
       (?$(1@\(B . "0x8DDC") ;; <CJK>
       (?$(1@](B . "0x8DCF") ;; <CJK>
       (?$(1@^(B . "0x8DD5") ;; <CJK>
       (?$(1@_(B . "0x8DD9") ;; <CJK>
       (?$(1@`(B . "0x8DC8") ;; <CJK>
       (?$(1@a(B . "0x8DD7") ;; <CJK>
       (?$(1@b(B . "0x8DC5") ;; <CJK>
       (?$(1@c(B . "0x8EEF") ;; <CJK>
       (?$(1@d(B . "0x8EF7") ;; <CJK>
       (?$(1@e(B . "0x8EFA") ;; <CJK>
       (?$(1@f(B . "0x8EF9") ;; <CJK>
       (?$(1@g(B . "0x8EE6") ;; <CJK>
       (?$(1@h(B . "0x8EEE") ;; <CJK>
       (?$(1@i(B . "0x8EE5") ;; <CJK>
       (?$(1@j(B . "0x8EF5") ;; <CJK>
       (?$(1@k(B . "0x8EE7") ;; <CJK>
       (?$(1@l(B . "0x8EE8") ;; <CJK>
       (?$(1@m(B . "0x8EF6") ;; <CJK>
       (?$(1@n(B . "0x8EEB") ;; <CJK>
       (?$(1@o(B . "0x8EF1") ;; <CJK>
       (?$(1@p(B . "0x8EEC") ;; <CJK>
       (?$(1@q(B . "0x8EF4") ;; <CJK>
       (?$(1@r(B . "0x8EE9") ;; <CJK>
       (?$(1@s(B . "0x902D") ;; <CJK>
       (?$(1@t(B . "0x9034") ;; <CJK>
       (?$(1@u(B . "0x902F") ;; <CJK>
       (?$(1@v(B . "0x9106") ;; <CJK>
       (?$(1@w(B . "0x912C") ;; <CJK>
       (?$(1@x(B . "0x9104") ;; <CJK>
       (?$(1@y(B . "0x90FF") ;; <CJK>
       (?$(1@z(B . "0x90FC") ;; <CJK>
       (?$(1@{(B . "0x9108") ;; <CJK>
       (?$(1@|(B . "0x90F9") ;; <CJK>
       (?$(1@}(B . "0x90FB") ;; <CJK>
       (?$(1@~(B . "0x9101") ;; <CJK>
       (?$(1A!(B . "0x9100") ;; <CJK>
       (?$(1A"(B . "0x9107") ;; <CJK>
       (?$(1A#(B . "0x9105") ;; <CJK>
       (?$(1A$(B . "0x9103") ;; <CJK>
       (?$(1A%(B . "0x9161") ;; <CJK>
       (?$(1A&(B . "0x9164") ;; <CJK>
       (?$(1A'(B . "0x915F") ;; <CJK>
       (?$(1A((B . "0x9162") ;; <CJK>
       (?$(1A)(B . "0x9160") ;; <CJK>
       (?$(1A*(B . "0x9201") ;; <CJK>
       (?$(1A+(B . "0x920A") ;; <CJK>
       (?$(1A,(B . "0x9225") ;; <CJK>
       (?$(1A-(B . "0x9203") ;; <CJK>
       (?$(1A.(B . "0x921A") ;; <CJK>
       (?$(1A/(B . "0x9226") ;; <CJK>
       (?$(1A0(B . "0x920F") ;; <CJK>
       (?$(1A1(B . "0x920C") ;; <CJK>
       (?$(1A2(B . "0x9200") ;; <CJK>
       (?$(1A3(B . "0x9212") ;; <CJK>
       (?$(1A4(B . "0x91FF") ;; <CJK>
       (?$(1A5(B . "0x91FD") ;; <CJK>
       (?$(1A6(B . "0x9206") ;; <CJK>
       (?$(1A7(B . "0x9204") ;; <CJK>
       (?$(1A8(B . "0x9227") ;; <CJK>
       (?$(1A9(B . "0x9202") ;; <CJK>
       (?$(1A:(B . "0x921C") ;; <CJK>
       (?$(1A;(B . "0x9224") ;; <CJK>
       (?$(1A<(B . "0x9219") ;; <CJK>
       (?$(1A=(B . "0x9217") ;; <CJK>
       (?$(1A>(B . "0x9205") ;; <CJK>
       (?$(1A?(B . "0x9216") ;; <CJK>
       (?$(1A@(B . "0x957B") ;; <CJK>
       (?$(1AA(B . "0x958D") ;; <CJK>
       (?$(1AB(B . "0x958C") ;; <CJK>
       (?$(1AC(B . "0x9590") ;; <CJK>
       (?$(1AD(B . "0x9687") ;; <CJK>
       (?$(1AE(B . "0x967E") ;; <CJK>
       (?$(1AF(B . "0x9688") ;; <CJK>
       (?$(1AG(B . "0x9689") ;; <CJK>
       (?$(1AH(B . "0x9683") ;; <CJK>
       (?$(1AI(B . "0x9680") ;; <CJK>
       (?$(1AJ(B . "0x96C2") ;; <CJK>
       (?$(1AK(B . "0x96C8") ;; <CJK>
       (?$(1AL(B . "0x96C3") ;; <CJK>
       (?$(1AM(B . "0x96F1") ;; <CJK>
       (?$(1AN(B . "0x96F0") ;; <CJK>
       (?$(1AO(B . "0x976C") ;; <CJK>
       (?$(1AP(B . "0x9770") ;; <CJK>
       (?$(1AQ(B . "0x976E") ;; <CJK>
       (?$(1AR(B . "0x9807") ;; <CJK>
       (?$(1AS(B . "0x98A9") ;; <CJK>
       (?$(1AT(B . "0x98EB") ;; <CJK>
       (?$(1AU(B . "0x9CE6") ;; <CJK>
       (?$(1AV(B . "0x9EF9") ;; <CJK>
       (?$(1AW(B . "0x4E83") ;; <CJK>
       (?$(1AX(B . "0x4E84") ;; <CJK>
       (?$(1AY(B . "0x4EB6") ;; <CJK>
       (?$(1AZ(B . "0x50BD") ;; <CJK>
       (?$(1A[(B . "0x50BF") ;; <CJK>
       (?$(1A\(B . "0x50C6") ;; <CJK>
       (?$(1A](B . "0x50AE") ;; <CJK>
       (?$(1A^(B . "0x50C4") ;; <CJK>
       (?$(1A_(B . "0x50CA") ;; <CJK>
       (?$(1A`(B . "0x50B4") ;; <CJK>
       (?$(1Aa(B . "0x50C8") ;; <CJK>
       (?$(1Ab(B . "0x50C2") ;; <CJK>
       (?$(1Ac(B . "0x50B0") ;; <CJK>
       (?$(1Ad(B . "0x50C1") ;; <CJK>
       (?$(1Ae(B . "0x50BA") ;; <CJK>
       (?$(1Af(B . "0x50B1") ;; <CJK>
       (?$(1Ag(B . "0x50CB") ;; <CJK>
       (?$(1Ah(B . "0x50C9") ;; <CJK>
       (?$(1Ai(B . "0x50B6") ;; <CJK>
       (?$(1Aj(B . "0x50B8") ;; <CJK>
       (?$(1Ak(B . "0x51D7") ;; <CJK>
       (?$(1Al(B . "0x527A") ;; <CJK>
       (?$(1Am(B . "0x5278") ;; <CJK>
       (?$(1An(B . "0x527B") ;; <CJK>
       (?$(1Ao(B . "0x527C") ;; <CJK>
       (?$(1Ap(B . "0x55C3") ;; <CJK>
       (?$(1Aq(B . "0x55DB") ;; <CJK>
       (?$(1Ar(B . "0x55CC") ;; <CJK>
       (?$(1As(B . "0x55D0") ;; <CJK>
       (?$(1At(B . "0x55CB") ;; <CJK>
       (?$(1Au(B . "0x55CA") ;; <CJK>
       (?$(1Av(B . "0x55DD") ;; <CJK>
       (?$(1Aw(B . "0x55C0") ;; <CJK>
       (?$(1Ax(B . "0x55D4") ;; <CJK>
       (?$(1Ay(B . "0x55C4") ;; <CJK>
       (?$(1Az(B . "0x55E9") ;; <CJK>
       (?$(1A{(B . "0x55BF") ;; <CJK>
       (?$(1A|(B . "0x55D2") ;; <CJK>
       (?$(1A}(B . "0x558D") ;; <CJK>
       (?$(1A~(B . "0x55CF") ;; <CJK>
       (?$(1B!(B . "0x55D5") ;; <CJK>
       (?$(1B"(B . "0x55E2") ;; <CJK>
       (?$(1B#(B . "0x55D6") ;; <CJK>
       (?$(1B$(B . "0x55C8") ;; <CJK>
       (?$(1B%(B . "0x55F2") ;; <CJK>
       (?$(1B&(B . "0x55CD") ;; <CJK>
       (?$(1B'(B . "0x55D9") ;; <CJK>
       (?$(1B((B . "0x55C2") ;; <CJK>
       (?$(1B)(B . "0x5714") ;; <CJK>
       (?$(1B*(B . "0x5853") ;; <CJK>
       (?$(1B+(B . "0x5868") ;; <CJK>
       (?$(1B,(B . "0x5864") ;; <CJK>
       (?$(1B-(B . "0x584F") ;; <CJK>
       (?$(1B.(B . "0x584D") ;; <CJK>
       (?$(1B/(B . "0x5849") ;; <CJK>
       (?$(1B0(B . "0x586F") ;; <CJK>
       (?$(1B1(B . "0x5855") ;; <CJK>
       (?$(1B2(B . "0x584E") ;; <CJK>
       (?$(1B3(B . "0x585D") ;; <CJK>
       (?$(1B4(B . "0x5859") ;; <CJK>
       (?$(1B5(B . "0x5865") ;; <CJK>
       (?$(1B6(B . "0x585B") ;; <CJK>
       (?$(1B7(B . "0x583D") ;; <CJK>
       (?$(1B8(B . "0x5863") ;; <CJK>
       (?$(1B9(B . "0x5871") ;; <CJK>
       (?$(1B:(B . "0x58FC") ;; <CJK>
       (?$(1B;(B . "0x5AC7") ;; <CJK>
       (?$(1B<(B . "0x5AC4") ;; <CJK>
       (?$(1B=(B . "0x5ACB") ;; <CJK>
       (?$(1B>(B . "0x5ABA") ;; <CJK>
       (?$(1B?(B . "0x5AB8") ;; <CJK>
       (?$(1B@(B . "0x5AB1") ;; <CJK>
       (?$(1BA(B . "0x5AB5") ;; <CJK>
       (?$(1BB(B . "0x5AB0") ;; <CJK>
       (?$(1BC(B . "0x5ABF") ;; <CJK>
       (?$(1BD(B . "0x5AC8") ;; <CJK>
       (?$(1BE(B . "0x5ABB") ;; <CJK>
       (?$(1BF(B . "0x5AC6") ;; <CJK>
       (?$(1BG(B . "0x5AB7") ;; <CJK>
       (?$(1BH(B . "0x5AC0") ;; <CJK>
       (?$(1BI(B . "0x5ACA") ;; <CJK>
       (?$(1BJ(B . "0x5AB4") ;; <CJK>
       (?$(1BK(B . "0x5AB6") ;; <CJK>
       (?$(1BL(B . "0x5ACD") ;; <CJK>
       (?$(1BM(B . "0x5AB9") ;; <CJK>
       (?$(1BN(B . "0x5A90") ;; <CJK>
       (?$(1BO(B . "0x5BD6") ;; <CJK>
       (?$(1BP(B . "0x5BD8") ;; <CJK>
       (?$(1BQ(B . "0x5BD9") ;; <CJK>
       (?$(1BR(B . "0x5C1F") ;; <CJK>
       (?$(1BS(B . "0x5C33") ;; <CJK>
       (?$(1BT(B . "0x5D71") ;; <CJK>
       (?$(1BU(B . "0x5D63") ;; <CJK>
       (?$(1BV(B . "0x5D4A") ;; <CJK>
       (?$(1BW(B . "0x5D65") ;; <CJK>
       (?$(1BX(B . "0x5D72") ;; <CJK>
       (?$(1BY(B . "0x5D6C") ;; <CJK>
       (?$(1BZ(B . "0x5D5E") ;; <CJK>
       (?$(1B[(B . "0x5D68") ;; <CJK>
       (?$(1B\(B . "0x5D67") ;; <CJK>
       (?$(1B](B . "0x5D62") ;; <CJK>
       (?$(1B^(B . "0x5DF0") ;; <CJK>
       (?$(1B_(B . "0x5E4F") ;; <CJK>
       (?$(1B`(B . "0x5E4E") ;; <CJK>
       (?$(1Ba(B . "0x5E4A") ;; <CJK>
       (?$(1Bb(B . "0x5E4D") ;; <CJK>
       (?$(1Bc(B . "0x5E4B") ;; <CJK>
       (?$(1Bd(B . "0x5EC5") ;; <CJK>
       (?$(1Be(B . "0x5ECC") ;; <CJK>
       (?$(1Bf(B . "0x5EC6") ;; <CJK>
       (?$(1Bg(B . "0x5ECB") ;; <CJK>
       (?$(1Bh(B . "0x5EC7") ;; <CJK>
       (?$(1Bi(B . "0x5F40") ;; <CJK>
       (?$(1Bj(B . "0x5FAF") ;; <CJK>
       (?$(1Bk(B . "0x5FAD") ;; <CJK>
       (?$(1Bl(B . "0x60F7") ;; <CJK>
       (?$(1Bm(B . "0x6149") ;; <CJK>
       (?$(1Bn(B . "0x614A") ;; <CJK>
       (?$(1Bo(B . "0x612B") ;; <CJK>
       (?$(1Bp(B . "0x6145") ;; <CJK>
       (?$(1Bq(B . "0x6136") ;; <CJK>
       (?$(1Br(B . "0x6132") ;; <CJK>
       (?$(1Bs(B . "0x612E") ;; <CJK>
       (?$(1Bt(B . "0x6146") ;; <CJK>
       (?$(1Bu(B . "0x612F") ;; <CJK>
       (?$(1Bv(B . "0x614F") ;; <CJK>
       (?$(1Bw(B . "0x6129") ;; <CJK>
       (?$(1Bx(B . "0x6140") ;; <CJK>
       (?$(1By(B . "0x6220") ;; <CJK>
       (?$(1Bz(B . "0x9168") ;; <CJK>
       (?$(1B{(B . "0x6223") ;; <CJK>
       (?$(1B|(B . "0x6225") ;; <CJK>
       (?$(1B}(B . "0x6224") ;; <CJK>
       (?$(1B~(B . "0x63C5") ;; <CJK>
       (?$(1C!(B . "0x63F1") ;; <CJK>
       (?$(1C"(B . "0x63EB") ;; <CJK>
       (?$(1C#(B . "0x6410") ;; <CJK>
       (?$(1C$(B . "0x6412") ;; <CJK>
       (?$(1C%(B . "0x6409") ;; <CJK>
       (?$(1C&(B . "0x6420") ;; <CJK>
       (?$(1C'(B . "0x6424") ;; <CJK>
       (?$(1C((B . "0x6433") ;; <CJK>
       (?$(1C)(B . "0x6443") ;; <CJK>
       (?$(1C*(B . "0x641F") ;; <CJK>
       (?$(1C+(B . "0x6415") ;; <CJK>
       (?$(1C,(B . "0x6418") ;; <CJK>
       (?$(1C-(B . "0x6439") ;; <CJK>
       (?$(1C.(B . "0x6437") ;; <CJK>
       (?$(1C/(B . "0x6422") ;; <CJK>
       (?$(1C0(B . "0x6423") ;; <CJK>
       (?$(1C1(B . "0x640C") ;; <CJK>
       (?$(1C2(B . "0x6426") ;; <CJK>
       (?$(1C3(B . "0x6430") ;; <CJK>
       (?$(1C4(B . "0x6428") ;; <CJK>
       (?$(1C5(B . "0x6441") ;; <CJK>
       (?$(1C6(B . "0x6435") ;; <CJK>
       (?$(1C7(B . "0x642F") ;; <CJK>
       (?$(1C8(B . "0x640A") ;; <CJK>
       (?$(1C9(B . "0x641A") ;; <CJK>
       (?$(1C:(B . "0x6440") ;; <CJK>
       (?$(1C;(B . "0x6425") ;; <CJK>
       (?$(1C<(B . "0x6427") ;; <CJK>
       (?$(1C=(B . "0x640B") ;; <CJK>
       (?$(1C>(B . "0x63E7") ;; <CJK>
       (?$(1C?(B . "0x641B") ;; <CJK>
       (?$(1C@(B . "0x642E") ;; <CJK>
       (?$(1CA(B . "0x6421") ;; <CJK>
       (?$(1CB(B . "0x640E") ;; <CJK>
       (?$(1CC(B . "0x656F") ;; <CJK>
       (?$(1CD(B . "0x6592") ;; <CJK>
       (?$(1CE(B . "0x65D3") ;; <CJK>
       (?$(1CF(B . "0x6686") ;; <CJK>
       (?$(1CG(B . "0x668C") ;; <CJK>
       (?$(1CH(B . "0x6695") ;; <CJK>
       (?$(1CI(B . "0x6690") ;; <CJK>
       (?$(1CJ(B . "0x668B") ;; <CJK>
       (?$(1CK(B . "0x668A") ;; <CJK>
       (?$(1CL(B . "0x6699") ;; <CJK>
       (?$(1CM(B . "0x6694") ;; <CJK>
       (?$(1CN(B . "0x6678") ;; <CJK>
       (?$(1CO(B . "0x6720") ;; <CJK>
       (?$(1CP(B . "0x6966") ;; <CJK>
       (?$(1CQ(B . "0x695F") ;; <CJK>
       (?$(1CR(B . "0x6938") ;; <CJK>
       (?$(1CS(B . "0x694E") ;; <CJK>
       (?$(1CT(B . "0x6962") ;; <CJK>
       (?$(1CU(B . "0x6971") ;; <CJK>
       (?$(1CV(B . "0x693F") ;; <CJK>
       (?$(1CW(B . "0x6945") ;; <CJK>
       (?$(1CX(B . "0x696A") ;; <CJK>
       (?$(1CY(B . "0x6939") ;; <CJK>
       (?$(1CZ(B . "0x6942") ;; <CJK>
       (?$(1C[(B . "0x6957") ;; <CJK>
       (?$(1C\(B . "0x6959") ;; <CJK>
       (?$(1C](B . "0x697A") ;; <CJK>
       (?$(1C^(B . "0x6948") ;; <CJK>
       (?$(1C_(B . "0x6949") ;; <CJK>
       (?$(1C`(B . "0x6935") ;; <CJK>
       (?$(1Ca(B . "0x696C") ;; <CJK>
       (?$(1Cb(B . "0x6933") ;; <CJK>
       (?$(1Cc(B . "0x693D") ;; <CJK>
       (?$(1Cd(B . "0x6965") ;; <CJK>
       (?$(1Ce(B . "0x68F0") ;; <CJK>
       (?$(1Cf(B . "0x6978") ;; <CJK>
       (?$(1Cg(B . "0x6934") ;; <CJK>
       (?$(1Ch(B . "0x6969") ;; <CJK>
       (?$(1Ci(B . "0x6940") ;; <CJK>
       (?$(1Cj(B . "0x696F") ;; <CJK>
       (?$(1Ck(B . "0x6944") ;; <CJK>
       (?$(1Cl(B . "0x6976") ;; <CJK>
       (?$(1Cm(B . "0x6958") ;; <CJK>
       (?$(1Cn(B . "0x6941") ;; <CJK>
       (?$(1Co(B . "0x6974") ;; <CJK>
       (?$(1Cp(B . "0x694C") ;; <CJK>
       (?$(1Cq(B . "0x693B") ;; <CJK>
       (?$(1Cr(B . "0x694B") ;; <CJK>
       (?$(1Cs(B . "0x6937") ;; <CJK>
       (?$(1Ct(B . "0x695C") ;; <CJK>
       (?$(1Cu(B . "0x694F") ;; <CJK>
       (?$(1Cv(B . "0x6951") ;; <CJK>
       (?$(1Cw(B . "0x6932") ;; <CJK>
       (?$(1Cx(B . "0x6952") ;; <CJK>
       (?$(1Cy(B . "0x692F") ;; <CJK>
       (?$(1Cz(B . "0x697B") ;; <CJK>
       (?$(1C{(B . "0x693C") ;; <CJK>
       (?$(1C|(B . "0x6B46") ;; <CJK>
       (?$(1C}(B . "0x6B45") ;; <CJK>
       (?$(1C~(B . "0x6B43") ;; <CJK>
       (?$(1D!(B . "0x6B42") ;; <CJK>
       (?$(1D"(B . "0x6B48") ;; <CJK>
       (?$(1D#(B . "0x6B41") ;; <CJK>
       (?$(1D$(B . "0x6B9B") ;; <CJK>
       (?$(1D%(B . "0xFA0D") ;; CJK COMPATIBILITY IDEOGRAPH-FA0D
       (?$(1D&(B . "0x6BFB") ;; <CJK>
       (?$(1D'(B . "0x6BFC") ;; <CJK>
       (?$(1D((B . "0x6BF9") ;; <CJK>
       (?$(1D)(B . "0x6BF7") ;; <CJK>
       (?$(1D*(B . "0x6BF8") ;; <CJK>
       (?$(1D+(B . "0x6E9B") ;; <CJK>
       (?$(1D,(B . "0x6ED6") ;; <CJK>
       (?$(1D-(B . "0x6EC8") ;; <CJK>
       (?$(1D.(B . "0x6E8F") ;; <CJK>
       (?$(1D/(B . "0x6EC0") ;; <CJK>
       (?$(1D0(B . "0x6E9F") ;; <CJK>
       (?$(1D1(B . "0x6E93") ;; <CJK>
       (?$(1D2(B . "0x6E94") ;; <CJK>
       (?$(1D3(B . "0x6EA0") ;; <CJK>
       (?$(1D4(B . "0x6EB1") ;; <CJK>
       (?$(1D5(B . "0x6EB9") ;; <CJK>
       (?$(1D6(B . "0x6EC6") ;; <CJK>
       (?$(1D7(B . "0x6ED2") ;; <CJK>
       (?$(1D8(B . "0x6EBD") ;; <CJK>
       (?$(1D9(B . "0x6EC1") ;; <CJK>
       (?$(1D:(B . "0x6E9E") ;; <CJK>
       (?$(1D;(B . "0x6EC9") ;; <CJK>
       (?$(1D<(B . "0x6EB7") ;; <CJK>
       (?$(1D=(B . "0x6EB0") ;; <CJK>
       (?$(1D>(B . "0x6ECD") ;; <CJK>
       (?$(1D?(B . "0x6EA6") ;; <CJK>
       (?$(1D@(B . "0x6ECF") ;; <CJK>
       (?$(1DA(B . "0x6EB2") ;; <CJK>
       (?$(1DB(B . "0x6EBE") ;; <CJK>
       (?$(1DC(B . "0x6EC3") ;; <CJK>
       (?$(1DD(B . "0x6EDC") ;; <CJK>
       (?$(1DE(B . "0x6ED8") ;; <CJK>
       (?$(1DF(B . "0x6E99") ;; <CJK>
       (?$(1DG(B . "0x6E92") ;; <CJK>
       (?$(1DH(B . "0x6E8E") ;; <CJK>
       (?$(1DI(B . "0x6E8D") ;; <CJK>
       (?$(1DJ(B . "0x6EA4") ;; <CJK>
       (?$(1DK(B . "0x6EA1") ;; <CJK>
       (?$(1DL(B . "0x6EBF") ;; <CJK>
       (?$(1DM(B . "0x6EB3") ;; <CJK>
       (?$(1DN(B . "0x6ED0") ;; <CJK>
       (?$(1DO(B . "0x6ECA") ;; <CJK>
       (?$(1DP(B . "0x6E97") ;; <CJK>
       (?$(1DQ(B . "0x6EAE") ;; <CJK>
       (?$(1DR(B . "0x6EA3") ;; <CJK>
       (?$(1DS(B . "0x7147") ;; <CJK>
       (?$(1DT(B . "0x7154") ;; <CJK>
       (?$(1DU(B . "0x7152") ;; <CJK>
       (?$(1DV(B . "0x7163") ;; <CJK>
       (?$(1DW(B . "0x7160") ;; <CJK>
       (?$(1DX(B . "0x7141") ;; <CJK>
       (?$(1DY(B . "0x715D") ;; <CJK>
       (?$(1DZ(B . "0x7162") ;; <CJK>
       (?$(1D[(B . "0x7172") ;; <CJK>
       (?$(1D\(B . "0x7178") ;; <CJK>
       (?$(1D](B . "0x716A") ;; <CJK>
       (?$(1D^(B . "0x7161") ;; <CJK>
       (?$(1D_(B . "0x7142") ;; <CJK>
       (?$(1D`(B . "0x7158") ;; <CJK>
       (?$(1Da(B . "0x7143") ;; <CJK>
       (?$(1Db(B . "0x714B") ;; <CJK>
       (?$(1Dc(B . "0x7170") ;; <CJK>
       (?$(1Dd(B . "0x715F") ;; <CJK>
       (?$(1De(B . "0x7150") ;; <CJK>
       (?$(1Df(B . "0x7153") ;; <CJK>
       (?$(1Dg(B . "0x7144") ;; <CJK>
       (?$(1Dh(B . "0x714D") ;; <CJK>
       (?$(1Di(B . "0x715A") ;; <CJK>
       (?$(1Dj(B . "0x724F") ;; <CJK>
       (?$(1Dk(B . "0x728D") ;; <CJK>
       (?$(1Dl(B . "0x728C") ;; <CJK>
       (?$(1Dm(B . "0x7291") ;; <CJK>
       (?$(1Dn(B . "0x7290") ;; <CJK>
       (?$(1Do(B . "0x728E") ;; <CJK>
       (?$(1Dp(B . "0x733C") ;; <CJK>
       (?$(1Dq(B . "0x7342") ;; <CJK>
       (?$(1Dr(B . "0x733B") ;; <CJK>
       (?$(1Ds(B . "0x733A") ;; <CJK>
       (?$(1Dt(B . "0x7340") ;; <CJK>
       (?$(1Du(B . "0x734A") ;; <CJK>
       (?$(1Dv(B . "0x7349") ;; <CJK>
       (?$(1Dw(B . "0x7444") ;; <CJK>
       (?$(1Dx(B . "0x744A") ;; <CJK>
       (?$(1Dy(B . "0x744B") ;; <CJK>
       (?$(1Dz(B . "0x7452") ;; <CJK>
       (?$(1D{(B . "0x7451") ;; <CJK>
       (?$(1D|(B . "0x7457") ;; <CJK>
       (?$(1D}(B . "0x7440") ;; <CJK>
       (?$(1D~(B . "0x744F") ;; <CJK>
       (?$(1E!(B . "0x7450") ;; <CJK>
       (?$(1E"(B . "0x744E") ;; <CJK>
       (?$(1E#(B . "0x7442") ;; <CJK>
       (?$(1E$(B . "0x7446") ;; <CJK>
       (?$(1E%(B . "0x744D") ;; <CJK>
       (?$(1E&(B . "0x7454") ;; <CJK>
       (?$(1E'(B . "0x74E1") ;; <CJK>
       (?$(1E((B . "0x74FF") ;; <CJK>
       (?$(1E)(B . "0x74FE") ;; <CJK>
       (?$(1E*(B . "0x74FD") ;; <CJK>
       (?$(1E+(B . "0x751D") ;; <CJK>
       (?$(1E,(B . "0x7579") ;; <CJK>
       (?$(1E-(B . "0x7577") ;; <CJK>
       (?$(1E.(B . "0x6983") ;; <CJK>
       (?$(1E/(B . "0x75EF") ;; <CJK>
       (?$(1E0(B . "0x760F") ;; <CJK>
       (?$(1E1(B . "0x7603") ;; <CJK>
       (?$(1E2(B . "0x75F7") ;; <CJK>
       (?$(1E3(B . "0x75FE") ;; <CJK>
       (?$(1E4(B . "0x75FC") ;; <CJK>
       (?$(1E5(B . "0x75F9") ;; <CJK>
       (?$(1E6(B . "0x75F8") ;; <CJK>
       (?$(1E7(B . "0x7610") ;; <CJK>
       (?$(1E8(B . "0x75FB") ;; <CJK>
       (?$(1E9(B . "0x75F6") ;; <CJK>
       (?$(1E:(B . "0x75ED") ;; <CJK>
       (?$(1E;(B . "0x75F5") ;; <CJK>
       (?$(1E<(B . "0x75FD") ;; <CJK>
       (?$(1E=(B . "0x7699") ;; <CJK>
       (?$(1E>(B . "0x76B5") ;; <CJK>
       (?$(1E?(B . "0x76DD") ;; <CJK>
       (?$(1E@(B . "0x7755") ;; <CJK>
       (?$(1EA(B . "0x775F") ;; <CJK>
       (?$(1EB(B . "0x7760") ;; <CJK>
       (?$(1EC(B . "0x7752") ;; <CJK>
       (?$(1ED(B . "0x7756") ;; <CJK>
       (?$(1EE(B . "0x775A") ;; <CJK>
       (?$(1EF(B . "0x7769") ;; <CJK>
       (?$(1EG(B . "0x7767") ;; <CJK>
       (?$(1EH(B . "0x7754") ;; <CJK>
       (?$(1EI(B . "0x7759") ;; <CJK>
       (?$(1EJ(B . "0x776D") ;; <CJK>
       (?$(1EK(B . "0x77E0") ;; <CJK>
       (?$(1EL(B . "0x7887") ;; <CJK>
       (?$(1EM(B . "0x789A") ;; <CJK>
       (?$(1EN(B . "0x7894") ;; <CJK>
       (?$(1EO(B . "0x788F") ;; <CJK>
       (?$(1EP(B . "0x7884") ;; <CJK>
       (?$(1EQ(B . "0x7895") ;; <CJK>
       (?$(1ER(B . "0x7885") ;; <CJK>
       (?$(1ES(B . "0x7886") ;; <CJK>
       (?$(1ET(B . "0x78A1") ;; <CJK>
       (?$(1EU(B . "0x7883") ;; <CJK>
       (?$(1EV(B . "0x7879") ;; <CJK>
       (?$(1EW(B . "0x7899") ;; <CJK>
       (?$(1EX(B . "0x7880") ;; <CJK>
       (?$(1EY(B . "0x7896") ;; <CJK>
       (?$(1EZ(B . "0x787B") ;; <CJK>
       (?$(1E[(B . "0x797C") ;; <CJK>
       (?$(1E\(B . "0x7982") ;; <CJK>
       (?$(1E](B . "0x797D") ;; <CJK>
       (?$(1E^(B . "0x7979") ;; <CJK>
       (?$(1E_(B . "0x7A11") ;; <CJK>
       (?$(1E`(B . "0x7A18") ;; <CJK>
       (?$(1Ea(B . "0x7A19") ;; <CJK>
       (?$(1Eb(B . "0x7A12") ;; <CJK>
       (?$(1Ec(B . "0x7A17") ;; <CJK>
       (?$(1Ed(B . "0x7A15") ;; <CJK>
       (?$(1Ee(B . "0x7A22") ;; <CJK>
       (?$(1Ef(B . "0x7A13") ;; <CJK>
       (?$(1Eg(B . "0x7A1B") ;; <CJK>
       (?$(1Eh(B . "0x7A10") ;; <CJK>
       (?$(1Ei(B . "0x7AA3") ;; <CJK>
       (?$(1Ej(B . "0x7AA2") ;; <CJK>
       (?$(1Ek(B . "0x7A9E") ;; <CJK>
       (?$(1El(B . "0x7AEB") ;; <CJK>
       (?$(1Em(B . "0x7B66") ;; <CJK>
       (?$(1En(B . "0x7B64") ;; <CJK>
       (?$(1Eo(B . "0x7B6D") ;; <CJK>
       (?$(1Ep(B . "0x7B74") ;; <CJK>
       (?$(1Eq(B . "0x7B69") ;; <CJK>
       (?$(1Er(B . "0x7B72") ;; <CJK>
       (?$(1Es(B . "0x7B65") ;; <CJK>
       (?$(1Et(B . "0x7B73") ;; <CJK>
       (?$(1Eu(B . "0x7B71") ;; <CJK>
       (?$(1Ev(B . "0x7B70") ;; <CJK>
       (?$(1Ew(B . "0x7B61") ;; <CJK>
       (?$(1Ex(B . "0x7B78") ;; <CJK>
       (?$(1Ey(B . "0x7B76") ;; <CJK>
       (?$(1Ez(B . "0x7B63") ;; <CJK>
       (?$(1E{(B . "0x7CB2") ;; <CJK>
       (?$(1E|(B . "0x7CB4") ;; <CJK>
       (?$(1E}(B . "0x7CAF") ;; <CJK>
       (?$(1E~(B . "0x7D88") ;; <CJK>
       (?$(1F!(B . "0x7D86") ;; <CJK>
       (?$(1F"(B . "0x7D80") ;; <CJK>
       (?$(1F#(B . "0x7D8D") ;; <CJK>
       (?$(1F$(B . "0x7D7F") ;; <CJK>
       (?$(1F%(B . "0x7D85") ;; <CJK>
       (?$(1F&(B . "0x7D7A") ;; <CJK>
       (?$(1F'(B . "0x7D8E") ;; <CJK>
       (?$(1F((B . "0x7D7B") ;; <CJK>
       (?$(1F)(B . "0x7D83") ;; <CJK>
       (?$(1F*(B . "0x7D7C") ;; <CJK>
       (?$(1F+(B . "0x7D8C") ;; <CJK>
       (?$(1F,(B . "0x7D94") ;; <CJK>
       (?$(1F-(B . "0x7D84") ;; <CJK>
       (?$(1F.(B . "0x7D7D") ;; <CJK>
       (?$(1F/(B . "0x7D92") ;; <CJK>
       (?$(1F0(B . "0x7F6D") ;; <CJK>
       (?$(1F1(B . "0x7F6B") ;; <CJK>
       (?$(1F2(B . "0x7F67") ;; <CJK>
       (?$(1F3(B . "0x7F68") ;; <CJK>
       (?$(1F4(B . "0x7F6C") ;; <CJK>
       (?$(1F5(B . "0x7FA6") ;; <CJK>
       (?$(1F6(B . "0x7FA5") ;; <CJK>
       (?$(1F7(B . "0x7FA7") ;; <CJK>
       (?$(1F8(B . "0x7FDB") ;; <CJK>
       (?$(1F9(B . "0x7FDC") ;; <CJK>
       (?$(1F:(B . "0x8021") ;; <CJK>
       (?$(1F;(B . "0x8164") ;; <CJK>
       (?$(1F<(B . "0x8160") ;; <CJK>
       (?$(1F=(B . "0x8177") ;; <CJK>
       (?$(1F>(B . "0x815C") ;; <CJK>
       (?$(1F?(B . "0x8169") ;; <CJK>
       (?$(1F@(B . "0x815B") ;; <CJK>
       (?$(1FA(B . "0x8162") ;; <CJK>
       (?$(1FB(B . "0x8172") ;; <CJK>
       (?$(1FC(B . "0x6721") ;; <CJK>
       (?$(1FD(B . "0x815E") ;; <CJK>
       (?$(1FE(B . "0x8176") ;; <CJK>
       (?$(1FF(B . "0x8167") ;; <CJK>
       (?$(1FG(B . "0x816F") ;; <CJK>
       (?$(1FH(B . "0x8144") ;; <CJK>
       (?$(1FI(B . "0x8161") ;; <CJK>
       (?$(1FJ(B . "0x821D") ;; <CJK>
       (?$(1FK(B . "0x8249") ;; <CJK>
       (?$(1FL(B . "0x8244") ;; <CJK>
       (?$(1FM(B . "0x8240") ;; <CJK>
       (?$(1FN(B . "0x8242") ;; <CJK>
       (?$(1FO(B . "0x8245") ;; <CJK>
       (?$(1FP(B . "0x84F1") ;; <CJK>
       (?$(1FQ(B . "0x843F") ;; <CJK>
       (?$(1FR(B . "0x8456") ;; <CJK>
       (?$(1FS(B . "0x8476") ;; <CJK>
       (?$(1FT(B . "0x8479") ;; <CJK>
       (?$(1FU(B . "0x848F") ;; <CJK>
       (?$(1FV(B . "0x848D") ;; <CJK>
       (?$(1FW(B . "0x8465") ;; <CJK>
       (?$(1FX(B . "0x8451") ;; <CJK>
       (?$(1FY(B . "0x8440") ;; <CJK>
       (?$(1FZ(B . "0x8486") ;; <CJK>
       (?$(1F[(B . "0x8467") ;; <CJK>
       (?$(1F\(B . "0x8430") ;; <CJK>
       (?$(1F](B . "0x844D") ;; <CJK>
       (?$(1F^(B . "0x847D") ;; <CJK>
       (?$(1F_(B . "0x845A") ;; <CJK>
       (?$(1F`(B . "0x8459") ;; <CJK>
       (?$(1Fa(B . "0x8474") ;; <CJK>
       (?$(1Fb(B . "0x8473") ;; <CJK>
       (?$(1Fc(B . "0x845D") ;; <CJK>
       (?$(1Fd(B . "0x8507") ;; <CJK>
       (?$(1Fe(B . "0x845E") ;; <CJK>
       (?$(1Ff(B . "0x8437") ;; <CJK>
       (?$(1Fg(B . "0x843A") ;; <CJK>
       (?$(1Fh(B . "0x8434") ;; <CJK>
       (?$(1Fi(B . "0x847A") ;; <CJK>
       (?$(1Fj(B . "0x8443") ;; <CJK>
       (?$(1Fk(B . "0x8478") ;; <CJK>
       (?$(1Fl(B . "0x8432") ;; <CJK>
       (?$(1Fm(B . "0x8445") ;; <CJK>
       (?$(1Fn(B . "0x8429") ;; <CJK>
       (?$(1Fo(B . "0x83D9") ;; <CJK>
       (?$(1Fp(B . "0x844B") ;; <CJK>
       (?$(1Fq(B . "0x842F") ;; <CJK>
       (?$(1Fr(B . "0x8442") ;; <CJK>
       (?$(1Fs(B . "0x842D") ;; <CJK>
       (?$(1Ft(B . "0x845F") ;; <CJK>
       (?$(1Fu(B . "0x8470") ;; <CJK>
       (?$(1Fv(B . "0x8439") ;; <CJK>
       (?$(1Fw(B . "0x844E") ;; <CJK>
       (?$(1Fx(B . "0x844C") ;; <CJK>
       (?$(1Fy(B . "0x8452") ;; <CJK>
       (?$(1Fz(B . "0x846F") ;; <CJK>
       (?$(1F{(B . "0x84C5") ;; <CJK>
       (?$(1F|(B . "0x848E") ;; <CJK>
       (?$(1F}(B . "0x843B") ;; <CJK>
       (?$(1F~(B . "0x8447") ;; <CJK>
       (?$(1G!(B . "0x8436") ;; <CJK>
       (?$(1G"(B . "0x8433") ;; <CJK>
       (?$(1G#(B . "0x8468") ;; <CJK>
       (?$(1G$(B . "0x847E") ;; <CJK>
       (?$(1G%(B . "0x8444") ;; <CJK>
       (?$(1G&(B . "0x842B") ;; <CJK>
       (?$(1G'(B . "0x8460") ;; <CJK>
       (?$(1G((B . "0x8454") ;; <CJK>
       (?$(1G)(B . "0x846E") ;; <CJK>
       (?$(1G*(B . "0x8450") ;; <CJK>
       (?$(1G+(B . "0x870B") ;; <CJK>
       (?$(1G,(B . "0x8704") ;; <CJK>
       (?$(1G-(B . "0x86F7") ;; <CJK>
       (?$(1G.(B . "0x870C") ;; <CJK>
       (?$(1G/(B . "0x86FA") ;; <CJK>
       (?$(1G0(B . "0x86D6") ;; <CJK>
       (?$(1G1(B . "0x86F5") ;; <CJK>
       (?$(1G2(B . "0x874D") ;; <CJK>
       (?$(1G3(B . "0x86F8") ;; <CJK>
       (?$(1G4(B . "0x870E") ;; <CJK>
       (?$(1G5(B . "0x8709") ;; <CJK>
       (?$(1G6(B . "0x8701") ;; <CJK>
       (?$(1G7(B . "0x86F6") ;; <CJK>
       (?$(1G8(B . "0x870D") ;; <CJK>
       (?$(1G9(B . "0x8705") ;; <CJK>
       (?$(1G:(B . "0x88D6") ;; <CJK>
       (?$(1G;(B . "0x88CB") ;; <CJK>
       (?$(1G<(B . "0x88CD") ;; <CJK>
       (?$(1G=(B . "0x88CE") ;; <CJK>
       (?$(1G>(B . "0x88DE") ;; <CJK>
       (?$(1G?(B . "0x88DB") ;; <CJK>
       (?$(1G@(B . "0x88DA") ;; <CJK>
       (?$(1GA(B . "0x88CC") ;; <CJK>
       (?$(1GB(B . "0x88D0") ;; <CJK>
       (?$(1GC(B . "0x8985") ;; <CJK>
       (?$(1GD(B . "0x899B") ;; <CJK>
       (?$(1GE(B . "0x89DF") ;; <CJK>
       (?$(1GF(B . "0x89E5") ;; <CJK>
       (?$(1GG(B . "0x89E4") ;; <CJK>
       (?$(1GH(B . "0x89E1") ;; <CJK>
       (?$(1GI(B . "0x89E0") ;; <CJK>
       (?$(1GJ(B . "0x89E2") ;; <CJK>
       (?$(1GK(B . "0x89DC") ;; <CJK>
       (?$(1GL(B . "0x89E6") ;; <CJK>
       (?$(1GM(B . "0x8A76") ;; <CJK>
       (?$(1GN(B . "0x8A86") ;; <CJK>
       (?$(1GO(B . "0x8A7F") ;; <CJK>
       (?$(1GP(B . "0x8A61") ;; <CJK>
       (?$(1GQ(B . "0x8A3F") ;; <CJK>
       (?$(1GR(B . "0x8A77") ;; <CJK>
       (?$(1GS(B . "0x8A82") ;; <CJK>
       (?$(1GT(B . "0x8A84") ;; <CJK>
       (?$(1GU(B . "0x8A75") ;; <CJK>
       (?$(1GV(B . "0x8A83") ;; <CJK>
       (?$(1GW(B . "0x8A81") ;; <CJK>
       (?$(1GX(B . "0x8A74") ;; <CJK>
       (?$(1GY(B . "0x8A7A") ;; <CJK>
       (?$(1GZ(B . "0x8C3C") ;; <CJK>
       (?$(1G[(B . "0x8C4B") ;; <CJK>
       (?$(1G\(B . "0x8C4A") ;; <CJK>
       (?$(1G](B . "0x8C65") ;; <CJK>
       (?$(1G^(B . "0x8C64") ;; <CJK>
       (?$(1G_(B . "0x8C66") ;; <CJK>
       (?$(1G`(B . "0x8C86") ;; <CJK>
       (?$(1Ga(B . "0x8C84") ;; <CJK>
       (?$(1Gb(B . "0x8C85") ;; <CJK>
       (?$(1Gc(B . "0x8CCC") ;; <CJK>
       (?$(1Gd(B . "0x8D68") ;; <CJK>
       (?$(1Ge(B . "0x8D69") ;; <CJK>
       (?$(1Gf(B . "0x8D91") ;; <CJK>
       (?$(1Gg(B . "0x8D8C") ;; <CJK>
       (?$(1Gh(B . "0x8D8E") ;; <CJK>
       (?$(1Gi(B . "0x8D8F") ;; <CJK>
       (?$(1Gj(B . "0x8D8D") ;; <CJK>
       (?$(1Gk(B . "0x8D93") ;; <CJK>
       (?$(1Gl(B . "0x8D94") ;; <CJK>
       (?$(1Gm(B . "0x8D90") ;; <CJK>
       (?$(1Gn(B . "0x8D92") ;; <CJK>
       (?$(1Go(B . "0x8DF0") ;; <CJK>
       (?$(1Gp(B . "0x8DE0") ;; <CJK>
       (?$(1Gq(B . "0x8DEC") ;; <CJK>
       (?$(1Gr(B . "0x8DF1") ;; <CJK>
       (?$(1Gs(B . "0x8DEE") ;; <CJK>
       (?$(1Gt(B . "0x8DD0") ;; <CJK>
       (?$(1Gu(B . "0x8DE9") ;; <CJK>
       (?$(1Gv(B . "0x8DE3") ;; <CJK>
       (?$(1Gw(B . "0x8DE2") ;; <CJK>
       (?$(1Gx(B . "0x8DE7") ;; <CJK>
       (?$(1Gy(B . "0x8DF2") ;; <CJK>
       (?$(1Gz(B . "0x8DEB") ;; <CJK>
       (?$(1G{(B . "0x8DF4") ;; <CJK>
       (?$(1G|(B . "0x8F06") ;; <CJK>
       (?$(1G}(B . "0x8EFF") ;; <CJK>
       (?$(1G~(B . "0x8F01") ;; <CJK>
       (?$(1H!(B . "0x8F00") ;; <CJK>
       (?$(1H"(B . "0x8F05") ;; <CJK>
       (?$(1H#(B . "0x8F07") ;; <CJK>
       (?$(1H$(B . "0x8F08") ;; <CJK>
       (?$(1H%(B . "0x8F02") ;; <CJK>
       (?$(1H&(B . "0x8F0B") ;; <CJK>
       (?$(1H'(B . "0x9052") ;; <CJK>
       (?$(1H((B . "0x903F") ;; <CJK>
       (?$(1H)(B . "0x9044") ;; <CJK>
       (?$(1H*(B . "0x9049") ;; <CJK>
       (?$(1H+(B . "0x903D") ;; <CJK>
       (?$(1H,(B . "0x9110") ;; <CJK>
       (?$(1H-(B . "0x910D") ;; <CJK>
       (?$(1H.(B . "0x910F") ;; <CJK>
       (?$(1H/(B . "0x9111") ;; <CJK>
       (?$(1H0(B . "0x9116") ;; <CJK>
       (?$(1H1(B . "0x9114") ;; <CJK>
       (?$(1H2(B . "0x910B") ;; <CJK>
       (?$(1H3(B . "0x910E") ;; <CJK>
       (?$(1H4(B . "0x916E") ;; <CJK>
       (?$(1H5(B . "0x916F") ;; <CJK>
       (?$(1H6(B . "0x9248") ;; <CJK>
       (?$(1H7(B . "0x9252") ;; <CJK>
       (?$(1H8(B . "0x9230") ;; <CJK>
       (?$(1H9(B . "0x923A") ;; <CJK>
       (?$(1H:(B . "0x9266") ;; <CJK>
       (?$(1H;(B . "0x9233") ;; <CJK>
       (?$(1H<(B . "0x9265") ;; <CJK>
       (?$(1H=(B . "0x925E") ;; <CJK>
       (?$(1H>(B . "0x9283") ;; <CJK>
       (?$(1H?(B . "0x922E") ;; <CJK>
       (?$(1H@(B . "0x924A") ;; <CJK>
       (?$(1HA(B . "0x9246") ;; <CJK>
       (?$(1HB(B . "0x926D") ;; <CJK>
       (?$(1HC(B . "0x926C") ;; <CJK>
       (?$(1HD(B . "0x924F") ;; <CJK>
       (?$(1HE(B . "0x9260") ;; <CJK>
       (?$(1HF(B . "0x9267") ;; <CJK>
       (?$(1HG(B . "0x926F") ;; <CJK>
       (?$(1HH(B . "0x9236") ;; <CJK>
       (?$(1HI(B . "0x9261") ;; <CJK>
       (?$(1HJ(B . "0x9270") ;; <CJK>
       (?$(1HK(B . "0x9231") ;; <CJK>
       (?$(1HL(B . "0x9254") ;; <CJK>
       (?$(1HM(B . "0x9263") ;; <CJK>
       (?$(1HN(B . "0x9250") ;; <CJK>
       (?$(1HO(B . "0x9272") ;; <CJK>
       (?$(1HP(B . "0x924E") ;; <CJK>
       (?$(1HQ(B . "0x9253") ;; <CJK>
       (?$(1HR(B . "0x924C") ;; <CJK>
       (?$(1HS(B . "0x9256") ;; <CJK>
       (?$(1HT(B . "0x9232") ;; <CJK>
       (?$(1HU(B . "0x959F") ;; <CJK>
       (?$(1HV(B . "0x959C") ;; <CJK>
       (?$(1HW(B . "0x959E") ;; <CJK>
       (?$(1HX(B . "0x959B") ;; <CJK>
       (?$(1HY(B . "0x9692") ;; <CJK>
       (?$(1HZ(B . "0x9693") ;; <CJK>
       (?$(1H[(B . "0x9691") ;; <CJK>
       (?$(1H\(B . "0x9697") ;; <CJK>
       (?$(1H](B . "0x96CE") ;; <CJK>
       (?$(1H^(B . "0x96FA") ;; <CJK>
       (?$(1H_(B . "0x96FD") ;; <CJK>
       (?$(1H`(B . "0x96F8") ;; <CJK>
       (?$(1Ha(B . "0x96F5") ;; <CJK>
       (?$(1Hb(B . "0x9773") ;; <CJK>
       (?$(1Hc(B . "0x9777") ;; <CJK>
       (?$(1Hd(B . "0x9778") ;; <CJK>
       (?$(1He(B . "0x9772") ;; <CJK>
       (?$(1Hf(B . "0x980F") ;; <CJK>
       (?$(1Hg(B . "0x980D") ;; <CJK>
       (?$(1Hh(B . "0x980E") ;; <CJK>
       (?$(1Hi(B . "0x98AC") ;; <CJK>
       (?$(1Hj(B . "0x98F6") ;; <CJK>
       (?$(1Hk(B . "0x98F9") ;; <CJK>
       (?$(1Hl(B . "0x99AF") ;; <CJK>
       (?$(1Hm(B . "0x99B2") ;; <CJK>
       (?$(1Hn(B . "0x99B0") ;; <CJK>
       (?$(1Ho(B . "0x99B5") ;; <CJK>
       (?$(1Hp(B . "0x9AAD") ;; <CJK>
       (?$(1Hq(B . "0x9AAB") ;; <CJK>
       (?$(1Hr(B . "0x9B5B") ;; <CJK>
       (?$(1Hs(B . "0x9CEA") ;; <CJK>
       (?$(1Ht(B . "0x9CED") ;; <CJK>
       (?$(1Hu(B . "0x9CE7") ;; <CJK>
       (?$(1Hv(B . "0x9E80") ;; <CJK>
       (?$(1Hw(B . "0x9EFD") ;; <CJK>
       (?$(1Hx(B . "0x50E6") ;; <CJK>
       (?$(1Hy(B . "0x50D4") ;; <CJK>
       (?$(1Hz(B . "0x50D7") ;; <CJK>
       (?$(1H{(B . "0x50E8") ;; <CJK>
       (?$(1H|(B . "0x50F3") ;; <CJK>
       (?$(1H}(B . "0x50DB") ;; <CJK>
       (?$(1H~(B . "0x50EA") ;; <CJK>
       (?$(1I!(B . "0x50DD") ;; <CJK>
       (?$(1I"(B . "0x50E4") ;; <CJK>
       (?$(1I#(B . "0x50D3") ;; <CJK>
       (?$(1I$(B . "0x50EC") ;; <CJK>
       (?$(1I%(B . "0x50F0") ;; <CJK>
       (?$(1I&(B . "0x50EF") ;; <CJK>
       (?$(1I'(B . "0x50E3") ;; <CJK>
       (?$(1I((B . "0x50E0") ;; <CJK>
       (?$(1I)(B . "0x51D8") ;; <CJK>
       (?$(1I*(B . "0x5280") ;; <CJK>
       (?$(1I+(B . "0x5281") ;; <CJK>
       (?$(1I,(B . "0x52E9") ;; <CJK>
       (?$(1I-(B . "0x52EB") ;; <CJK>
       (?$(1I.(B . "0x5330") ;; <CJK>
       (?$(1I/(B . "0x53AC") ;; <CJK>
       (?$(1I0(B . "0x5627") ;; <CJK>
       (?$(1I1(B . "0x5615") ;; <CJK>
       (?$(1I2(B . "0x560C") ;; <CJK>
       (?$(1I3(B . "0x5612") ;; <CJK>
       (?$(1I4(B . "0x55FC") ;; <CJK>
       (?$(1I5(B . "0x560F") ;; <CJK>
       (?$(1I6(B . "0x561C") ;; <CJK>
       (?$(1I7(B . "0x5601") ;; <CJK>
       (?$(1I8(B . "0x5613") ;; <CJK>
       (?$(1I9(B . "0x5602") ;; <CJK>
       (?$(1I:(B . "0x55FA") ;; <CJK>
       (?$(1I;(B . "0x561D") ;; <CJK>
       (?$(1I<(B . "0x5604") ;; <CJK>
       (?$(1I=(B . "0x55FF") ;; <CJK>
       (?$(1I>(B . "0x55F9") ;; <CJK>
       (?$(1I?(B . "0x5889") ;; <CJK>
       (?$(1I@(B . "0x587C") ;; <CJK>
       (?$(1IA(B . "0x5890") ;; <CJK>
       (?$(1IB(B . "0x5898") ;; <CJK>
       (?$(1IC(B . "0x5886") ;; <CJK>
       (?$(1ID(B . "0x5881") ;; <CJK>
       (?$(1IE(B . "0x587F") ;; <CJK>
       (?$(1IF(B . "0x5874") ;; <CJK>
       (?$(1IG(B . "0x588B") ;; <CJK>
       (?$(1IH(B . "0x587A") ;; <CJK>
       (?$(1II(B . "0x5887") ;; <CJK>
       (?$(1IJ(B . "0x5891") ;; <CJK>
       (?$(1IK(B . "0x588E") ;; <CJK>
       (?$(1IL(B . "0x5876") ;; <CJK>
       (?$(1IM(B . "0x5882") ;; <CJK>
       (?$(1IN(B . "0x5888") ;; <CJK>
       (?$(1IO(B . "0x587B") ;; <CJK>
       (?$(1IP(B . "0x5894") ;; <CJK>
       (?$(1IQ(B . "0x588F") ;; <CJK>
       (?$(1IR(B . "0x58FE") ;; <CJK>
       (?$(1IS(B . "0x596B") ;; <CJK>
       (?$(1IT(B . "0x5ADC") ;; <CJK>
       (?$(1IU(B . "0x5AEE") ;; <CJK>
       (?$(1IV(B . "0x5AE5") ;; <CJK>
       (?$(1IW(B . "0x5AD5") ;; <CJK>
       (?$(1IX(B . "0x5AEA") ;; <CJK>
       (?$(1IY(B . "0x5ADA") ;; <CJK>
       (?$(1IZ(B . "0x5AED") ;; <CJK>
       (?$(1I[(B . "0x5AEB") ;; <CJK>
       (?$(1I\(B . "0x5AF3") ;; <CJK>
       (?$(1I](B . "0x5AE2") ;; <CJK>
       (?$(1I^(B . "0x5AE0") ;; <CJK>
       (?$(1I_(B . "0x5ADB") ;; <CJK>
       (?$(1I`(B . "0x5AEC") ;; <CJK>
       (?$(1Ia(B . "0x5ADE") ;; <CJK>
       (?$(1Ib(B . "0x5ADD") ;; <CJK>
       (?$(1Ic(B . "0x5AD9") ;; <CJK>
       (?$(1Id(B . "0x5AE8") ;; <CJK>
       (?$(1Ie(B . "0x5ADF") ;; <CJK>
       (?$(1If(B . "0x5B77") ;; <CJK>
       (?$(1Ig(B . "0x5BE0") ;; <CJK>
       (?$(1Ih(B . "0x5BE3") ;; <CJK>
       (?$(1Ii(B . "0x5C63") ;; <CJK>
       (?$(1Ij(B . "0x5D82") ;; <CJK>
       (?$(1Ik(B . "0x5D80") ;; <CJK>
       (?$(1Il(B . "0x5D7D") ;; <CJK>
       (?$(1Im(B . "0x5D86") ;; <CJK>
       (?$(1In(B . "0x5D7A") ;; <CJK>
       (?$(1Io(B . "0x5D81") ;; <CJK>
       (?$(1Ip(B . "0x5D77") ;; <CJK>
       (?$(1Iq(B . "0x5D8A") ;; <CJK>
       (?$(1Ir(B . "0x5D89") ;; <CJK>
       (?$(1Is(B . "0x5D88") ;; <CJK>
       (?$(1It(B . "0x5D7E") ;; <CJK>
       (?$(1Iu(B . "0x5D7C") ;; <CJK>
       (?$(1Iv(B . "0x5D8D") ;; <CJK>
       (?$(1Iw(B . "0x5D79") ;; <CJK>
       (?$(1Ix(B . "0x5D7F") ;; <CJK>
       (?$(1Iy(B . "0x5E58") ;; <CJK>
       (?$(1Iz(B . "0x5E59") ;; <CJK>
       (?$(1I{(B . "0x5E53") ;; <CJK>
       (?$(1I|(B . "0x5ED8") ;; <CJK>
       (?$(1I}(B . "0x5ED1") ;; <CJK>
       (?$(1I~(B . "0x5ED7") ;; <CJK>
       (?$(1J!(B . "0x5ECE") ;; <CJK>
       (?$(1J"(B . "0x5EDC") ;; <CJK>
       (?$(1J#(B . "0x5ED5") ;; <CJK>
       (?$(1J$(B . "0x5ED9") ;; <CJK>
       (?$(1J%(B . "0x5ED2") ;; <CJK>
       (?$(1J&(B . "0x5ED4") ;; <CJK>
       (?$(1J'(B . "0x5F44") ;; <CJK>
       (?$(1J((B . "0x5F43") ;; <CJK>
       (?$(1J)(B . "0x5F6F") ;; <CJK>
       (?$(1J*(B . "0x5FB6") ;; <CJK>
       (?$(1J+(B . "0x612C") ;; <CJK>
       (?$(1J,(B . "0x6128") ;; <CJK>
       (?$(1J-(B . "0x6141") ;; <CJK>
       (?$(1J.(B . "0x615E") ;; <CJK>
       (?$(1J/(B . "0x6171") ;; <CJK>
       (?$(1J0(B . "0x6173") ;; <CJK>
       (?$(1J1(B . "0x6152") ;; <CJK>
       (?$(1J2(B . "0x6153") ;; <CJK>
       (?$(1J3(B . "0x6172") ;; <CJK>
       (?$(1J4(B . "0x616C") ;; <CJK>
       (?$(1J5(B . "0x6180") ;; <CJK>
       (?$(1J6(B . "0x6174") ;; <CJK>
       (?$(1J7(B . "0x6154") ;; <CJK>
       (?$(1J8(B . "0x617A") ;; <CJK>
       (?$(1J9(B . "0x615B") ;; <CJK>
       (?$(1J:(B . "0x6165") ;; <CJK>
       (?$(1J;(B . "0x613B") ;; <CJK>
       (?$(1J<(B . "0x616A") ;; <CJK>
       (?$(1J=(B . "0x6161") ;; <CJK>
       (?$(1J>(B . "0x6156") ;; <CJK>
       (?$(1J?(B . "0x6229") ;; <CJK>
       (?$(1J@(B . "0x6227") ;; <CJK>
       (?$(1JA(B . "0x622B") ;; <CJK>
       (?$(1JB(B . "0x642B") ;; <CJK>
       (?$(1JC(B . "0x644D") ;; <CJK>
       (?$(1JD(B . "0x645B") ;; <CJK>
       (?$(1JE(B . "0x645D") ;; <CJK>
       (?$(1JF(B . "0x6474") ;; <CJK>
       (?$(1JG(B . "0x6476") ;; <CJK>
       (?$(1JH(B . "0x6472") ;; <CJK>
       (?$(1JI(B . "0x6473") ;; <CJK>
       (?$(1JJ(B . "0x647D") ;; <CJK>
       (?$(1JK(B . "0x6475") ;; <CJK>
       (?$(1JL(B . "0x6466") ;; <CJK>
       (?$(1JM(B . "0x64A6") ;; <CJK>
       (?$(1JN(B . "0x644E") ;; <CJK>
       (?$(1JO(B . "0x6482") ;; <CJK>
       (?$(1JP(B . "0x645E") ;; <CJK>
       (?$(1JQ(B . "0x645C") ;; <CJK>
       (?$(1JR(B . "0x644B") ;; <CJK>
       (?$(1JS(B . "0x6453") ;; <CJK>
       (?$(1JT(B . "0x6460") ;; <CJK>
       (?$(1JU(B . "0x6450") ;; <CJK>
       (?$(1JV(B . "0x647F") ;; <CJK>
       (?$(1JW(B . "0x643F") ;; <CJK>
       (?$(1JX(B . "0x646C") ;; <CJK>
       (?$(1JY(B . "0x646B") ;; <CJK>
       (?$(1JZ(B . "0x6459") ;; <CJK>
       (?$(1J[(B . "0x6465") ;; <CJK>
       (?$(1J\(B . "0x6477") ;; <CJK>
       (?$(1J](B . "0x6573") ;; <CJK>
       (?$(1J^(B . "0x65A0") ;; <CJK>
       (?$(1J_(B . "0x66A1") ;; <CJK>
       (?$(1J`(B . "0x66A0") ;; <CJK>
       (?$(1Ja(B . "0x669F") ;; <CJK>
       (?$(1Jb(B . "0x6705") ;; <CJK>
       (?$(1Jc(B . "0x6704") ;; <CJK>
       (?$(1Jd(B . "0x6722") ;; <CJK>
       (?$(1Je(B . "0x69B1") ;; <CJK>
       (?$(1Jf(B . "0x69B6") ;; <CJK>
       (?$(1Jg(B . "0x69C9") ;; <CJK>
       (?$(1Jh(B . "0x69A0") ;; <CJK>
       (?$(1Ji(B . "0x69CE") ;; <CJK>
       (?$(1Jj(B . "0x6996") ;; <CJK>
       (?$(1Jk(B . "0x69B0") ;; <CJK>
       (?$(1Jl(B . "0x69AC") ;; <CJK>
       (?$(1Jm(B . "0x69BC") ;; <CJK>
       (?$(1Jn(B . "0x6991") ;; <CJK>
       (?$(1Jo(B . "0x6999") ;; <CJK>
       (?$(1Jp(B . "0x698E") ;; <CJK>
       (?$(1Jq(B . "0x69A7") ;; <CJK>
       (?$(1Jr(B . "0x698D") ;; <CJK>
       (?$(1Js(B . "0x69A9") ;; <CJK>
       (?$(1Jt(B . "0x69BE") ;; <CJK>
       (?$(1Ju(B . "0x69AF") ;; <CJK>
       (?$(1Jv(B . "0x69BF") ;; <CJK>
       (?$(1Jw(B . "0x69C4") ;; <CJK>
       (?$(1Jx(B . "0x69BD") ;; <CJK>
       (?$(1Jy(B . "0x69A4") ;; <CJK>
       (?$(1Jz(B . "0x69D4") ;; <CJK>
       (?$(1J{(B . "0x69B9") ;; <CJK>
       (?$(1J|(B . "0x69CA") ;; <CJK>
       (?$(1J}(B . "0x699A") ;; <CJK>
       (?$(1J~(B . "0x69CF") ;; <CJK>
       (?$(1K!(B . "0x69B3") ;; <CJK>
       (?$(1K"(B . "0x6993") ;; <CJK>
       (?$(1K#(B . "0x69AA") ;; <CJK>
       (?$(1K$(B . "0x69A1") ;; <CJK>
       (?$(1K%(B . "0x699E") ;; <CJK>
       (?$(1K&(B . "0x69D9") ;; <CJK>
       (?$(1K'(B . "0x6997") ;; <CJK>
       (?$(1K((B . "0x6990") ;; <CJK>
       (?$(1K)(B . "0x69C2") ;; <CJK>
       (?$(1K*(B . "0x69B5") ;; <CJK>
       (?$(1K+(B . "0x69A5") ;; <CJK>
       (?$(1K,(B . "0x69C6") ;; <CJK>
       (?$(1K-(B . "0x6B4A") ;; <CJK>
       (?$(1K.(B . "0x6B4D") ;; <CJK>
       (?$(1K/(B . "0x6B4B") ;; <CJK>
       (?$(1K0(B . "0x6B9E") ;; <CJK>
       (?$(1K1(B . "0x6B9F") ;; <CJK>
       (?$(1K2(B . "0x6BA0") ;; <CJK>
       (?$(1K3(B . "0x6BC3") ;; <CJK>
       (?$(1K4(B . "0x6BC4") ;; <CJK>
       (?$(1K5(B . "0x6BFE") ;; <CJK>
       (?$(1K6(B . "0x6ECE") ;; <CJK>
       (?$(1K7(B . "0x6EF5") ;; <CJK>
       (?$(1K8(B . "0x6EF1") ;; <CJK>
       (?$(1K9(B . "0x6F03") ;; <CJK>
       (?$(1K:(B . "0x6F25") ;; <CJK>
       (?$(1K;(B . "0x6EF8") ;; <CJK>
       (?$(1K<(B . "0x6F37") ;; <CJK>
       (?$(1K=(B . "0x6EFB") ;; <CJK>
       (?$(1K>(B . "0x6F2E") ;; <CJK>
       (?$(1K?(B . "0x6F09") ;; <CJK>
       (?$(1K@(B . "0x6F4E") ;; <CJK>
       (?$(1KA(B . "0x6F19") ;; <CJK>
       (?$(1KB(B . "0x6F1A") ;; <CJK>
       (?$(1KC(B . "0x6F27") ;; <CJK>
       (?$(1KD(B . "0x6F18") ;; <CJK>
       (?$(1KE(B . "0x6F3B") ;; <CJK>
       (?$(1KF(B . "0x6F12") ;; <CJK>
       (?$(1KG(B . "0x6EED") ;; <CJK>
       (?$(1KH(B . "0x6F0A") ;; <CJK>
       (?$(1KI(B . "0x6F36") ;; <CJK>
       (?$(1KJ(B . "0x6F73") ;; <CJK>
       (?$(1KK(B . "0x6EF9") ;; <CJK>
       (?$(1KL(B . "0x6EEE") ;; <CJK>
       (?$(1KM(B . "0x6F2D") ;; <CJK>
       (?$(1KN(B . "0x6F40") ;; <CJK>
       (?$(1KO(B . "0x6F30") ;; <CJK>
       (?$(1KP(B . "0x6F3C") ;; <CJK>
       (?$(1KQ(B . "0x6F35") ;; <CJK>
       (?$(1KR(B . "0x6EEB") ;; <CJK>
       (?$(1KS(B . "0x6F07") ;; <CJK>
       (?$(1KT(B . "0x6F0E") ;; <CJK>
       (?$(1KU(B . "0x6F43") ;; <CJK>
       (?$(1KV(B . "0x6F05") ;; <CJK>
       (?$(1KW(B . "0x6EFD") ;; <CJK>
       (?$(1KX(B . "0x6EF6") ;; <CJK>
       (?$(1KY(B . "0x6F39") ;; <CJK>
       (?$(1KZ(B . "0x6F1C") ;; <CJK>
       (?$(1K[(B . "0x6EFC") ;; <CJK>
       (?$(1K\(B . "0x6F3A") ;; <CJK>
       (?$(1K](B . "0x6F1F") ;; <CJK>
       (?$(1K^(B . "0x6F0D") ;; <CJK>
       (?$(1K_(B . "0x6F1E") ;; <CJK>
       (?$(1K`(B . "0x6F08") ;; <CJK>
       (?$(1Ka(B . "0x6F21") ;; <CJK>
       (?$(1Kb(B . "0x7187") ;; <CJK>
       (?$(1Kc(B . "0x7190") ;; <CJK>
       (?$(1Kd(B . "0x7189") ;; <CJK>
       (?$(1Ke(B . "0x7180") ;; <CJK>
       (?$(1Kf(B . "0x7185") ;; <CJK>
       (?$(1Kg(B . "0x7182") ;; <CJK>
       (?$(1Kh(B . "0x718F") ;; <CJK>
       (?$(1Ki(B . "0x717B") ;; <CJK>
       (?$(1Kj(B . "0x7186") ;; <CJK>
       (?$(1Kk(B . "0x7181") ;; <CJK>
       (?$(1Kl(B . "0x7197") ;; <CJK>
       (?$(1Km(B . "0x7244") ;; <CJK>
       (?$(1Kn(B . "0x7253") ;; <CJK>
       (?$(1Ko(B . "0x7297") ;; <CJK>
       (?$(1Kp(B . "0x7295") ;; <CJK>
       (?$(1Kq(B . "0x7293") ;; <CJK>
       (?$(1Kr(B . "0x7343") ;; <CJK>
       (?$(1Ks(B . "0x734D") ;; <CJK>
       (?$(1Kt(B . "0x7351") ;; <CJK>
       (?$(1Ku(B . "0x734C") ;; <CJK>
       (?$(1Kv(B . "0x7462") ;; <CJK>
       (?$(1Kw(B . "0x7473") ;; <CJK>
       (?$(1Kx(B . "0x7471") ;; <CJK>
       (?$(1Ky(B . "0x7475") ;; <CJK>
       (?$(1Kz(B . "0x7472") ;; <CJK>
       (?$(1K{(B . "0x7467") ;; <CJK>
       (?$(1K|(B . "0x746E") ;; <CJK>
       (?$(1K}(B . "0x7500") ;; <CJK>
       (?$(1K~(B . "0x7502") ;; <CJK>
       (?$(1L!(B . "0x7503") ;; <CJK>
       (?$(1L"(B . "0x757D") ;; <CJK>
       (?$(1L#(B . "0x7590") ;; <CJK>
       (?$(1L$(B . "0x7616") ;; <CJK>
       (?$(1L%(B . "0x7608") ;; <CJK>
       (?$(1L&(B . "0x760C") ;; <CJK>
       (?$(1L'(B . "0x7615") ;; <CJK>
       (?$(1L((B . "0x7611") ;; <CJK>
       (?$(1L)(B . "0x760A") ;; <CJK>
       (?$(1L*(B . "0x7614") ;; <CJK>
       (?$(1L+(B . "0x76B8") ;; <CJK>
       (?$(1L,(B . "0x7781") ;; <CJK>
       (?$(1L-(B . "0x777C") ;; <CJK>
       (?$(1L.(B . "0x7785") ;; <CJK>
       (?$(1L/(B . "0x7782") ;; <CJK>
       (?$(1L0(B . "0x776E") ;; <CJK>
       (?$(1L1(B . "0x7780") ;; <CJK>
       (?$(1L2(B . "0x776F") ;; <CJK>
       (?$(1L3(B . "0x777E") ;; <CJK>
       (?$(1L4(B . "0x7783") ;; <CJK>
       (?$(1L5(B . "0x78B2") ;; <CJK>
       (?$(1L6(B . "0x78AA") ;; <CJK>
       (?$(1L7(B . "0x78B4") ;; <CJK>
       (?$(1L8(B . "0x78AD") ;; <CJK>
       (?$(1L9(B . "0x78A8") ;; <CJK>
       (?$(1L:(B . "0x787E") ;; <CJK>
       (?$(1L;(B . "0x78AB") ;; <CJK>
       (?$(1L<(B . "0x789E") ;; <CJK>
       (?$(1L=(B . "0x78A5") ;; <CJK>
       (?$(1L>(B . "0x78A0") ;; <CJK>
       (?$(1L?(B . "0x78AC") ;; <CJK>
       (?$(1L@(B . "0x78A2") ;; <CJK>
       (?$(1LA(B . "0x78A4") ;; <CJK>
       (?$(1LB(B . "0x7998") ;; <CJK>
       (?$(1LC(B . "0x798A") ;; <CJK>
       (?$(1LD(B . "0x798B") ;; <CJK>
       (?$(1LE(B . "0x7996") ;; <CJK>
       (?$(1LF(B . "0x7995") ;; <CJK>
       (?$(1LG(B . "0x7994") ;; <CJK>
       (?$(1LH(B . "0x7993") ;; <CJK>
       (?$(1LI(B . "0x7997") ;; <CJK>
       (?$(1LJ(B . "0x7988") ;; <CJK>
       (?$(1LK(B . "0x7992") ;; <CJK>
       (?$(1LL(B . "0x7990") ;; <CJK>
       (?$(1LM(B . "0x7A2B") ;; <CJK>
       (?$(1LN(B . "0x7A4A") ;; <CJK>
       (?$(1LO(B . "0x7A30") ;; <CJK>
       (?$(1LP(B . "0x7A2F") ;; <CJK>
       (?$(1LQ(B . "0x7A28") ;; <CJK>
       (?$(1LR(B . "0x7A26") ;; <CJK>
       (?$(1LS(B . "0x7AA8") ;; <CJK>
       (?$(1LT(B . "0x7AAB") ;; <CJK>
       (?$(1LU(B . "0x7AAC") ;; <CJK>
       (?$(1LV(B . "0x7AEE") ;; <CJK>
       (?$(1LW(B . "0x7B88") ;; <CJK>
       (?$(1LX(B . "0x7B9C") ;; <CJK>
       (?$(1LY(B . "0x7B8A") ;; <CJK>
       (?$(1LZ(B . "0x7B91") ;; <CJK>
       (?$(1L[(B . "0x7B90") ;; <CJK>
       (?$(1L\(B . "0x7B96") ;; <CJK>
       (?$(1L](B . "0x7B8D") ;; <CJK>
       (?$(1L^(B . "0x7B8C") ;; <CJK>
       (?$(1L_(B . "0x7B9B") ;; <CJK>
       (?$(1L`(B . "0x7B8E") ;; <CJK>
       (?$(1La(B . "0x7B85") ;; <CJK>
       (?$(1Lb(B . "0x7B98") ;; <CJK>
       (?$(1Lc(B . "0x5284") ;; <CJK>
       (?$(1Ld(B . "0x7B99") ;; <CJK>
       (?$(1Le(B . "0x7BA4") ;; <CJK>
       (?$(1Lf(B . "0x7B82") ;; <CJK>
       (?$(1Lg(B . "0x7CBB") ;; <CJK>
       (?$(1Lh(B . "0x7CBF") ;; <CJK>
       (?$(1Li(B . "0x7CBC") ;; <CJK>
       (?$(1Lj(B . "0x7CBA") ;; <CJK>
       (?$(1Lk(B . "0x7DA7") ;; <CJK>
       (?$(1Ll(B . "0x7DB7") ;; <CJK>
       (?$(1Lm(B . "0x7DC2") ;; <CJK>
       (?$(1Ln(B . "0x7DA3") ;; <CJK>
       (?$(1Lo(B . "0x7DAA") ;; <CJK>
       (?$(1Lp(B . "0x7DC1") ;; <CJK>
       (?$(1Lq(B . "0x7DC0") ;; <CJK>
       (?$(1Lr(B . "0x7DC5") ;; <CJK>
       (?$(1Ls(B . "0x7D9D") ;; <CJK>
       (?$(1Lt(B . "0x7DCE") ;; <CJK>
       (?$(1Lu(B . "0x7DC4") ;; <CJK>
       (?$(1Lv(B . "0x7DC6") ;; <CJK>
       (?$(1Lw(B . "0x7DCB") ;; <CJK>
       (?$(1Lx(B . "0x7DCC") ;; <CJK>
       (?$(1Ly(B . "0x7DAF") ;; <CJK>
       (?$(1Lz(B . "0x7DB9") ;; <CJK>
       (?$(1L{(B . "0x7D96") ;; <CJK>
       (?$(1L|(B . "0x7DBC") ;; <CJK>
       (?$(1L}(B . "0x7D9F") ;; <CJK>
       (?$(1L~(B . "0x7DA6") ;; <CJK>
       (?$(1M!(B . "0x7DAE") ;; <CJK>
       (?$(1M"(B . "0x7DA9") ;; <CJK>
       (?$(1M#(B . "0x7DA1") ;; <CJK>
       (?$(1M$(B . "0x7DC9") ;; <CJK>
       (?$(1M%(B . "0x7F73") ;; <CJK>
       (?$(1M&(B . "0x7FE2") ;; <CJK>
       (?$(1M'(B . "0x7FE3") ;; <CJK>
       (?$(1M((B . "0x7FE5") ;; <CJK>
       (?$(1M)(B . "0x7FDE") ;; <CJK>
       (?$(1M*(B . "0x8024") ;; <CJK>
       (?$(1M+(B . "0x805D") ;; <CJK>
       (?$(1M,(B . "0x805C") ;; <CJK>
       (?$(1M-(B . "0x8189") ;; <CJK>
       (?$(1M.(B . "0x8186") ;; <CJK>
       (?$(1M/(B . "0x8183") ;; <CJK>
       (?$(1M0(B . "0x8187") ;; <CJK>
       (?$(1M1(B . "0x818D") ;; <CJK>
       (?$(1M2(B . "0x818C") ;; <CJK>
       (?$(1M3(B . "0x818B") ;; <CJK>
       (?$(1M4(B . "0x8215") ;; <CJK>
       (?$(1M5(B . "0x8497") ;; <CJK>
       (?$(1M6(B . "0x84A4") ;; <CJK>
       (?$(1M7(B . "0x84A1") ;; <CJK>
       (?$(1M8(B . "0x849F") ;; <CJK>
       (?$(1M9(B . "0x84BA") ;; <CJK>
       (?$(1M:(B . "0x84CE") ;; <CJK>
       (?$(1M;(B . "0x84C2") ;; <CJK>
       (?$(1M<(B . "0x84AC") ;; <CJK>
       (?$(1M=(B . "0x84AE") ;; <CJK>
       (?$(1M>(B . "0x84AB") ;; <CJK>
       (?$(1M?(B . "0x84B9") ;; <CJK>
       (?$(1M@(B . "0x84B4") ;; <CJK>
       (?$(1MA(B . "0x84C1") ;; <CJK>
       (?$(1MB(B . "0x84CD") ;; <CJK>
       (?$(1MC(B . "0x84AA") ;; <CJK>
       (?$(1MD(B . "0x849A") ;; <CJK>
       (?$(1ME(B . "0x84B1") ;; <CJK>
       (?$(1MF(B . "0x84D0") ;; <CJK>
       (?$(1MG(B . "0x849D") ;; <CJK>
       (?$(1MH(B . "0x84A7") ;; <CJK>
       (?$(1MI(B . "0x84BB") ;; <CJK>
       (?$(1MJ(B . "0x84A2") ;; <CJK>
       (?$(1MK(B . "0x8494") ;; <CJK>
       (?$(1ML(B . "0x84C7") ;; <CJK>
       (?$(1MM(B . "0x84CC") ;; <CJK>
       (?$(1MN(B . "0x849B") ;; <CJK>
       (?$(1MO(B . "0x84A9") ;; <CJK>
       (?$(1MP(B . "0x84AF") ;; <CJK>
       (?$(1MQ(B . "0x84A8") ;; <CJK>
       (?$(1MR(B . "0x84D6") ;; <CJK>
       (?$(1MS(B . "0x8498") ;; <CJK>
       (?$(1MT(B . "0x84B6") ;; <CJK>
       (?$(1MU(B . "0x84CF") ;; <CJK>
       (?$(1MV(B . "0x84A0") ;; <CJK>
       (?$(1MW(B . "0x84D7") ;; <CJK>
       (?$(1MX(B . "0x84D4") ;; <CJK>
       (?$(1MY(B . "0x84D2") ;; <CJK>
       (?$(1MZ(B . "0x84DB") ;; <CJK>
       (?$(1M[(B . "0x84B0") ;; <CJK>
       (?$(1M\(B . "0x8491") ;; <CJK>
       (?$(1M](B . "0x8661") ;; <CJK>
       (?$(1M^(B . "0x8733") ;; <CJK>
       (?$(1M_(B . "0x8723") ;; <CJK>
       (?$(1M`(B . "0x8728") ;; <CJK>
       (?$(1Ma(B . "0x876B") ;; <CJK>
       (?$(1Mb(B . "0x8740") ;; <CJK>
       (?$(1Mc(B . "0x872E") ;; <CJK>
       (?$(1Md(B . "0x871E") ;; <CJK>
       (?$(1Me(B . "0x8721") ;; <CJK>
       (?$(1Mf(B . "0x8719") ;; <CJK>
       (?$(1Mg(B . "0x871B") ;; <CJK>
       (?$(1Mh(B . "0x8743") ;; <CJK>
       (?$(1Mi(B . "0x872C") ;; <CJK>
       (?$(1Mj(B . "0x8741") ;; <CJK>
       (?$(1Mk(B . "0x873E") ;; <CJK>
       (?$(1Ml(B . "0x8746") ;; <CJK>
       (?$(1Mm(B . "0x8720") ;; <CJK>
       (?$(1Mn(B . "0x8732") ;; <CJK>
       (?$(1Mo(B . "0x872A") ;; <CJK>
       (?$(1Mp(B . "0x872D") ;; <CJK>
       (?$(1Mq(B . "0x873C") ;; <CJK>
       (?$(1Mr(B . "0x8712") ;; <CJK>
       (?$(1Ms(B . "0x873A") ;; <CJK>
       (?$(1Mt(B . "0x8731") ;; <CJK>
       (?$(1Mu(B . "0x8735") ;; <CJK>
       (?$(1Mv(B . "0x8742") ;; <CJK>
       (?$(1Mw(B . "0x8726") ;; <CJK>
       (?$(1Mx(B . "0x8727") ;; <CJK>
       (?$(1My(B . "0x8738") ;; <CJK>
       (?$(1Mz(B . "0x8724") ;; <CJK>
       (?$(1M{(B . "0x871A") ;; <CJK>
       (?$(1M|(B . "0x8730") ;; <CJK>
       (?$(1M}(B . "0x8711") ;; <CJK>
       (?$(1M~(B . "0x88F7") ;; <CJK>
       (?$(1N!(B . "0x88E7") ;; <CJK>
       (?$(1N"(B . "0x88F1") ;; <CJK>
       (?$(1N#(B . "0x88F2") ;; <CJK>
       (?$(1N$(B . "0x88FA") ;; <CJK>
       (?$(1N%(B . "0x88FE") ;; <CJK>
       (?$(1N&(B . "0x88EE") ;; <CJK>
       (?$(1N'(B . "0x88FC") ;; <CJK>
       (?$(1N((B . "0x88F6") ;; <CJK>
       (?$(1N)(B . "0x88FB") ;; <CJK>
       (?$(1N*(B . "0x88F0") ;; <CJK>
       (?$(1N+(B . "0x88EC") ;; <CJK>
       (?$(1N,(B . "0x88EB") ;; <CJK>
       (?$(1N-(B . "0x899D") ;; <CJK>
       (?$(1N.(B . "0x89A1") ;; <CJK>
       (?$(1N/(B . "0x899F") ;; <CJK>
       (?$(1N0(B . "0x899E") ;; <CJK>
       (?$(1N1(B . "0x89E9") ;; <CJK>
       (?$(1N2(B . "0x89EB") ;; <CJK>
       (?$(1N3(B . "0x89E8") ;; <CJK>
       (?$(1N4(B . "0x8AAB") ;; <CJK>
       (?$(1N5(B . "0x8A99") ;; <CJK>
       (?$(1N6(B . "0x8A8B") ;; <CJK>
       (?$(1N7(B . "0x8A92") ;; <CJK>
       (?$(1N8(B . "0x8A8F") ;; <CJK>
       (?$(1N9(B . "0x8A96") ;; <CJK>
       (?$(1N:(B . "0x8C3D") ;; <CJK>
       (?$(1N;(B . "0x8C68") ;; <CJK>
       (?$(1N<(B . "0x8C69") ;; <CJK>
       (?$(1N=(B . "0x8CD5") ;; <CJK>
       (?$(1N>(B . "0x8CCF") ;; <CJK>
       (?$(1N?(B . "0x8CD7") ;; <CJK>
       (?$(1N@(B . "0x8D96") ;; <CJK>
       (?$(1NA(B . "0x8E09") ;; <CJK>
       (?$(1NB(B . "0x8E02") ;; <CJK>
       (?$(1NC(B . "0x8DFF") ;; <CJK>
       (?$(1ND(B . "0x8E0D") ;; <CJK>
       (?$(1NE(B . "0x8DFD") ;; <CJK>
       (?$(1NF(B . "0x8E0A") ;; <CJK>
       (?$(1NG(B . "0x8E03") ;; <CJK>
       (?$(1NH(B . "0x8E07") ;; <CJK>
       (?$(1NI(B . "0x8E06") ;; <CJK>
       (?$(1NJ(B . "0x8E05") ;; <CJK>
       (?$(1NK(B . "0x8DFE") ;; <CJK>
       (?$(1NL(B . "0x8E00") ;; <CJK>
       (?$(1NM(B . "0x8E04") ;; <CJK>
       (?$(1NN(B . "0x8F10") ;; <CJK>
       (?$(1NO(B . "0x8F11") ;; <CJK>
       (?$(1NP(B . "0x8F0E") ;; <CJK>
       (?$(1NQ(B . "0x8F0D") ;; <CJK>
       (?$(1NR(B . "0x9123") ;; <CJK>
       (?$(1NS(B . "0x911C") ;; <CJK>
       (?$(1NT(B . "0x9120") ;; <CJK>
       (?$(1NU(B . "0x9122") ;; <CJK>
       (?$(1NV(B . "0x911F") ;; <CJK>
       (?$(1NW(B . "0x911D") ;; <CJK>
       (?$(1NX(B . "0x911A") ;; <CJK>
       (?$(1NY(B . "0x9124") ;; <CJK>
       (?$(1NZ(B . "0x9121") ;; <CJK>
       (?$(1N[(B . "0x911B") ;; <CJK>
       (?$(1N\(B . "0x917A") ;; <CJK>
       (?$(1N](B . "0x9172") ;; <CJK>
       (?$(1N^(B . "0x9179") ;; <CJK>
       (?$(1N_(B . "0x9173") ;; <CJK>
       (?$(1N`(B . "0x92A5") ;; <CJK>
       (?$(1Na(B . "0x92A4") ;; <CJK>
       (?$(1Nb(B . "0x9276") ;; <CJK>
       (?$(1Nc(B . "0x929B") ;; <CJK>
       (?$(1Nd(B . "0x927A") ;; <CJK>
       (?$(1Ne(B . "0x92A0") ;; <CJK>
       (?$(1Nf(B . "0x9294") ;; <CJK>
       (?$(1Ng(B . "0x92AA") ;; <CJK>
       (?$(1Nh(B . "0x928D") ;; <CJK>
       (?$(1Ni(B . "0x92A6") ;; <CJK>
       (?$(1Nj(B . "0x929A") ;; <CJK>
       (?$(1Nk(B . "0x92AB") ;; <CJK>
       (?$(1Nl(B . "0x9279") ;; <CJK>
       (?$(1Nm(B . "0x9297") ;; <CJK>
       (?$(1Nn(B . "0x927F") ;; <CJK>
       (?$(1No(B . "0x92A3") ;; <CJK>
       (?$(1Np(B . "0x92EE") ;; <CJK>
       (?$(1Nq(B . "0x928E") ;; <CJK>
       (?$(1Nr(B . "0x9282") ;; <CJK>
       (?$(1Ns(B . "0x9295") ;; <CJK>
       (?$(1Nt(B . "0x92A2") ;; <CJK>
       (?$(1Nu(B . "0x927D") ;; <CJK>
       (?$(1Nv(B . "0x9288") ;; <CJK>
       (?$(1Nw(B . "0x92A1") ;; <CJK>
       (?$(1Nx(B . "0x928A") ;; <CJK>
       (?$(1Ny(B . "0x9286") ;; <CJK>
       (?$(1Nz(B . "0x928C") ;; <CJK>
       (?$(1N{(B . "0x9299") ;; <CJK>
       (?$(1N|(B . "0x92A7") ;; <CJK>
       (?$(1N}(B . "0x927E") ;; <CJK>
       (?$(1N~(B . "0x9287") ;; <CJK>
       (?$(1O!(B . "0x92A9") ;; <CJK>
       (?$(1O"(B . "0x929D") ;; <CJK>
       (?$(1O#(B . "0x928B") ;; <CJK>
       (?$(1O$(B . "0x922D") ;; <CJK>
       (?$(1O%(B . "0x969E") ;; <CJK>
       (?$(1O&(B . "0x96A1") ;; <CJK>
       (?$(1O'(B . "0x96FF") ;; <CJK>
       (?$(1O((B . "0x9758") ;; <CJK>
       (?$(1O)(B . "0x977D") ;; <CJK>
       (?$(1O*(B . "0x977A") ;; <CJK>
       (?$(1O+(B . "0x977E") ;; <CJK>
       (?$(1O,(B . "0x9783") ;; <CJK>
       (?$(1O-(B . "0x9780") ;; <CJK>
       (?$(1O.(B . "0x9782") ;; <CJK>
       (?$(1O/(B . "0x977B") ;; <CJK>
       (?$(1O0(B . "0x9784") ;; <CJK>
       (?$(1O1(B . "0x9781") ;; <CJK>
       (?$(1O2(B . "0x977F") ;; <CJK>
       (?$(1O3(B . "0x97CE") ;; <CJK>
       (?$(1O4(B . "0x97CD") ;; <CJK>
       (?$(1O5(B . "0x9816") ;; <CJK>
       (?$(1O6(B . "0x98AD") ;; <CJK>
       (?$(1O7(B . "0x98AE") ;; <CJK>
       (?$(1O8(B . "0x9902") ;; <CJK>
       (?$(1O9(B . "0x9900") ;; <CJK>
       (?$(1O:(B . "0x9907") ;; <CJK>
       (?$(1O;(B . "0x999D") ;; <CJK>
       (?$(1O<(B . "0x999C") ;; <CJK>
       (?$(1O=(B . "0x99C3") ;; <CJK>
       (?$(1O>(B . "0x99B9") ;; <CJK>
       (?$(1O?(B . "0x99BB") ;; <CJK>
       (?$(1O@(B . "0x99BA") ;; <CJK>
       (?$(1OA(B . "0x99C2") ;; <CJK>
       (?$(1OB(B . "0x99BD") ;; <CJK>
       (?$(1OC(B . "0x99C7") ;; <CJK>
       (?$(1OD(B . "0x9AB1") ;; <CJK>
       (?$(1OE(B . "0x9AE3") ;; <CJK>
       (?$(1OF(B . "0x9AE7") ;; <CJK>
       (?$(1OG(B . "0x9B3E") ;; <CJK>
       (?$(1OH(B . "0x9B3F") ;; <CJK>
       (?$(1OI(B . "0x9B60") ;; <CJK>
       (?$(1OJ(B . "0x9B61") ;; <CJK>
       (?$(1OK(B . "0x9B5F") ;; <CJK>
       (?$(1OL(B . "0x9CF1") ;; <CJK>
       (?$(1OM(B . "0x9CF2") ;; <CJK>
       (?$(1ON(B . "0x9CF5") ;; <CJK>
       (?$(1OO(B . "0x9EA7") ;; <CJK>
       (?$(1OP(B . "0x50FF") ;; <CJK>
       (?$(1OQ(B . "0x5103") ;; <CJK>
       (?$(1OR(B . "0x5130") ;; <CJK>
       (?$(1OS(B . "0x50F8") ;; <CJK>
       (?$(1OT(B . "0x5106") ;; <CJK>
       (?$(1OU(B . "0x5107") ;; <CJK>
       (?$(1OV(B . "0x50F6") ;; <CJK>
       (?$(1OW(B . "0x50FE") ;; <CJK>
       (?$(1OX(B . "0x510B") ;; <CJK>
       (?$(1OY(B . "0x510C") ;; <CJK>
       (?$(1OZ(B . "0x50FD") ;; <CJK>
       (?$(1O[(B . "0x510A") ;; <CJK>
       (?$(1O\(B . "0x528B") ;; <CJK>
       (?$(1O](B . "0x528C") ;; <CJK>
       (?$(1O^(B . "0x52F1") ;; <CJK>
       (?$(1O_(B . "0x52EF") ;; <CJK>
       (?$(1O`(B . "0x5648") ;; <CJK>
       (?$(1Oa(B . "0x5642") ;; <CJK>
       (?$(1Ob(B . "0x564C") ;; <CJK>
       (?$(1Oc(B . "0x5635") ;; <CJK>
       (?$(1Od(B . "0x5641") ;; <CJK>
       (?$(1Oe(B . "0x564A") ;; <CJK>
       (?$(1Of(B . "0x5649") ;; <CJK>
       (?$(1Og(B . "0x5646") ;; <CJK>
       (?$(1Oh(B . "0x5658") ;; <CJK>
       (?$(1Oi(B . "0x565A") ;; <CJK>
       (?$(1Oj(B . "0x5640") ;; <CJK>
       (?$(1Ok(B . "0x5633") ;; <CJK>
       (?$(1Ol(B . "0x563D") ;; <CJK>
       (?$(1Om(B . "0x562C") ;; <CJK>
       (?$(1On(B . "0x563E") ;; <CJK>
       (?$(1Oo(B . "0x5638") ;; <CJK>
       (?$(1Op(B . "0x562A") ;; <CJK>
       (?$(1Oq(B . "0x563A") ;; <CJK>
       (?$(1Or(B . "0x571A") ;; <CJK>
       (?$(1Os(B . "0x58AB") ;; <CJK>
       (?$(1Ot(B . "0x589D") ;; <CJK>
       (?$(1Ou(B . "0x58B1") ;; <CJK>
       (?$(1Ov(B . "0x58A0") ;; <CJK>
       (?$(1Ow(B . "0x58A3") ;; <CJK>
       (?$(1Ox(B . "0x58AF") ;; <CJK>
       (?$(1Oy(B . "0x58AC") ;; <CJK>
       (?$(1Oz(B . "0x58A5") ;; <CJK>
       (?$(1O{(B . "0x58A1") ;; <CJK>
       (?$(1O|(B . "0x58FF") ;; <CJK>
       (?$(1O}(B . "0x5AFF") ;; <CJK>
       (?$(1O~(B . "0x5AF4") ;; <CJK>
       (?$(1P!(B . "0x5AFD") ;; <CJK>
       (?$(1P"(B . "0x5AF7") ;; <CJK>
       (?$(1P#(B . "0x5AF6") ;; <CJK>
       (?$(1P$(B . "0x5B03") ;; <CJK>
       (?$(1P%(B . "0x5AF8") ;; <CJK>
       (?$(1P&(B . "0x5B02") ;; <CJK>
       (?$(1P'(B . "0x5AF9") ;; <CJK>
       (?$(1P((B . "0x5B01") ;; <CJK>
       (?$(1P)(B . "0x5B07") ;; <CJK>
       (?$(1P*(B . "0x5B05") ;; <CJK>
       (?$(1P+(B . "0x5B0F") ;; <CJK>
       (?$(1P,(B . "0x5C67") ;; <CJK>
       (?$(1P-(B . "0x5D99") ;; <CJK>
       (?$(1P.(B . "0x5D97") ;; <CJK>
       (?$(1P/(B . "0x5D9F") ;; <CJK>
       (?$(1P0(B . "0x5D92") ;; <CJK>
       (?$(1P1(B . "0x5DA2") ;; <CJK>
       (?$(1P2(B . "0x5D93") ;; <CJK>
       (?$(1P3(B . "0x5D95") ;; <CJK>
       (?$(1P4(B . "0x5DA0") ;; <CJK>
       (?$(1P5(B . "0x5D9C") ;; <CJK>
       (?$(1P6(B . "0x5DA1") ;; <CJK>
       (?$(1P7(B . "0x5D9A") ;; <CJK>
       (?$(1P8(B . "0x5D9E") ;; <CJK>
       (?$(1P9(B . "0x5E69") ;; <CJK>
       (?$(1P:(B . "0x5E5D") ;; <CJK>
       (?$(1P;(B . "0x5E60") ;; <CJK>
       (?$(1P<(B . "0x5E5C") ;; <CJK>
       (?$(1P=(B . "0x7DF3") ;; <CJK>
       (?$(1P>(B . "0x5EDB") ;; <CJK>
       (?$(1P?(B . "0x5EDE") ;; <CJK>
       (?$(1P@(B . "0x5EE1") ;; <CJK>
       (?$(1PA(B . "0x5F49") ;; <CJK>
       (?$(1PB(B . "0x5FB2") ;; <CJK>
       (?$(1PC(B . "0x618B") ;; <CJK>
       (?$(1PD(B . "0x6183") ;; <CJK>
       (?$(1PE(B . "0x6179") ;; <CJK>
       (?$(1PF(B . "0x61B1") ;; <CJK>
       (?$(1PG(B . "0x61B0") ;; <CJK>
       (?$(1PH(B . "0x61A2") ;; <CJK>
       (?$(1PI(B . "0x6189") ;; <CJK>
       (?$(1PJ(B . "0x619B") ;; <CJK>
       (?$(1PK(B . "0x6193") ;; <CJK>
       (?$(1PL(B . "0x61AF") ;; <CJK>
       (?$(1PM(B . "0x61AD") ;; <CJK>
       (?$(1PN(B . "0x619F") ;; <CJK>
       (?$(1PO(B . "0x6192") ;; <CJK>
       (?$(1PP(B . "0x61AA") ;; <CJK>
       (?$(1PQ(B . "0x61A1") ;; <CJK>
       (?$(1PR(B . "0x618D") ;; <CJK>
       (?$(1PS(B . "0x6166") ;; <CJK>
       (?$(1PT(B . "0x61B3") ;; <CJK>
       (?$(1PU(B . "0x622D") ;; <CJK>
       (?$(1PV(B . "0x646E") ;; <CJK>
       (?$(1PW(B . "0x6470") ;; <CJK>
       (?$(1PX(B . "0x6496") ;; <CJK>
       (?$(1PY(B . "0x64A0") ;; <CJK>
       (?$(1PZ(B . "0x6485") ;; <CJK>
       (?$(1P[(B . "0x6497") ;; <CJK>
       (?$(1P\(B . "0x649C") ;; <CJK>
       (?$(1P](B . "0x648F") ;; <CJK>
       (?$(1P^(B . "0x648B") ;; <CJK>
       (?$(1P_(B . "0x648A") ;; <CJK>
       (?$(1P`(B . "0x648C") ;; <CJK>
       (?$(1Pa(B . "0x64A3") ;; <CJK>
       (?$(1Pb(B . "0x649F") ;; <CJK>
       (?$(1Pc(B . "0x6468") ;; <CJK>
       (?$(1Pd(B . "0x64B1") ;; <CJK>
       (?$(1Pe(B . "0x6498") ;; <CJK>
       (?$(1Pf(B . "0x6576") ;; <CJK>
       (?$(1Pg(B . "0x657A") ;; <CJK>
       (?$(1Ph(B . "0x6579") ;; <CJK>
       (?$(1Pi(B . "0x657B") ;; <CJK>
       (?$(1Pj(B . "0x65B2") ;; <CJK>
       (?$(1Pk(B . "0x65B3") ;; <CJK>
       (?$(1Pl(B . "0x66B5") ;; <CJK>
       (?$(1Pm(B . "0x66B0") ;; <CJK>
       (?$(1Pn(B . "0x66A9") ;; <CJK>
       (?$(1Po(B . "0x66B2") ;; <CJK>
       (?$(1Pp(B . "0x66B7") ;; <CJK>
       (?$(1Pq(B . "0x66AA") ;; <CJK>
       (?$(1Pr(B . "0x66AF") ;; <CJK>
       (?$(1Ps(B . "0x6A00") ;; <CJK>
       (?$(1Pt(B . "0x6A06") ;; <CJK>
       (?$(1Pu(B . "0x6A17") ;; <CJK>
       (?$(1Pv(B . "0x69E5") ;; <CJK>
       (?$(1Pw(B . "0x69F8") ;; <CJK>
       (?$(1Px(B . "0x6A15") ;; <CJK>
       (?$(1Py(B . "0x69F1") ;; <CJK>
       (?$(1Pz(B . "0x69E4") ;; <CJK>
       (?$(1P{(B . "0x6A20") ;; <CJK>
       (?$(1P|(B . "0x69FF") ;; <CJK>
       (?$(1P}(B . "0x69EC") ;; <CJK>
       (?$(1P~(B . "0x69E2") ;; <CJK>
       (?$(1Q!(B . "0x6A1B") ;; <CJK>
       (?$(1Q"(B . "0x6A1D") ;; <CJK>
       (?$(1Q#(B . "0x69FE") ;; <CJK>
       (?$(1Q$(B . "0x6A27") ;; <CJK>
       (?$(1Q%(B . "0x69F2") ;; <CJK>
       (?$(1Q&(B . "0x69EE") ;; <CJK>
       (?$(1Q'(B . "0x6A14") ;; <CJK>
       (?$(1Q((B . "0x69F7") ;; <CJK>
       (?$(1Q)(B . "0x69E7") ;; <CJK>
       (?$(1Q*(B . "0x6A40") ;; <CJK>
       (?$(1Q+(B . "0x6A08") ;; <CJK>
       (?$(1Q,(B . "0x69E6") ;; <CJK>
       (?$(1Q-(B . "0x69FB") ;; <CJK>
       (?$(1Q.(B . "0x6A0D") ;; <CJK>
       (?$(1Q/(B . "0x69FC") ;; <CJK>
       (?$(1Q0(B . "0x69EB") ;; <CJK>
       (?$(1Q1(B . "0x6A09") ;; <CJK>
       (?$(1Q2(B . "0x6A04") ;; <CJK>
       (?$(1Q3(B . "0x6A18") ;; <CJK>
       (?$(1Q4(B . "0x6A25") ;; <CJK>
       (?$(1Q5(B . "0x6A0F") ;; <CJK>
       (?$(1Q6(B . "0x69F6") ;; <CJK>
       (?$(1Q7(B . "0x6A26") ;; <CJK>
       (?$(1Q8(B . "0x6A07") ;; <CJK>
       (?$(1Q9(B . "0x69F4") ;; <CJK>
       (?$(1Q:(B . "0x6A16") ;; <CJK>
       (?$(1Q;(B . "0x6B51") ;; <CJK>
       (?$(1Q<(B . "0x6BA5") ;; <CJK>
       (?$(1Q=(B . "0x6BA3") ;; <CJK>
       (?$(1Q>(B . "0x6BA2") ;; <CJK>
       (?$(1Q?(B . "0x6BA6") ;; <CJK>
       (?$(1Q@(B . "0x6C01") ;; <CJK>
       (?$(1QA(B . "0x6C00") ;; <CJK>
       (?$(1QB(B . "0x6BFF") ;; <CJK>
       (?$(1QC(B . "0x6C02") ;; <CJK>
       (?$(1QD(B . "0x6F41") ;; <CJK>
       (?$(1QE(B . "0x6F26") ;; <CJK>
       (?$(1QF(B . "0x6F7E") ;; <CJK>
       (?$(1QG(B . "0x6F87") ;; <CJK>
       (?$(1QH(B . "0x6FC6") ;; <CJK>
       (?$(1QI(B . "0x6F92") ;; <CJK>
       (?$(1QJ(B . "0x6F8D") ;; <CJK>
       (?$(1QK(B . "0x6F89") ;; <CJK>
       (?$(1QL(B . "0x6F8C") ;; <CJK>
       (?$(1QM(B . "0x6F62") ;; <CJK>
       (?$(1QN(B . "0x6F4F") ;; <CJK>
       (?$(1QO(B . "0x6F85") ;; <CJK>
       (?$(1QP(B . "0x6F5A") ;; <CJK>
       (?$(1QQ(B . "0x6F96") ;; <CJK>
       (?$(1QR(B . "0x6F76") ;; <CJK>
       (?$(1QS(B . "0x6F6C") ;; <CJK>
       (?$(1QT(B . "0x6F82") ;; <CJK>
       (?$(1QU(B . "0x6F55") ;; <CJK>
       (?$(1QV(B . "0x6F72") ;; <CJK>
       (?$(1QW(B . "0x6F52") ;; <CJK>
       (?$(1QX(B . "0x6F50") ;; <CJK>
       (?$(1QY(B . "0x6F57") ;; <CJK>
       (?$(1QZ(B . "0x6F94") ;; <CJK>
       (?$(1Q[(B . "0x6F93") ;; <CJK>
       (?$(1Q\(B . "0x6F5D") ;; <CJK>
       (?$(1Q](B . "0x6F00") ;; <CJK>
       (?$(1Q^(B . "0x6F61") ;; <CJK>
       (?$(1Q_(B . "0x6F6B") ;; <CJK>
       (?$(1Q`(B . "0x6F7D") ;; <CJK>
       (?$(1Qa(B . "0x6F67") ;; <CJK>
       (?$(1Qb(B . "0x6F90") ;; <CJK>
       (?$(1Qc(B . "0x6F53") ;; <CJK>
       (?$(1Qd(B . "0x6F8B") ;; <CJK>
       (?$(1Qe(B . "0x6F69") ;; <CJK>
       (?$(1Qf(B . "0x6F7F") ;; <CJK>
       (?$(1Qg(B . "0x6F95") ;; <CJK>
       (?$(1Qh(B . "0x6F63") ;; <CJK>
       (?$(1Qi(B . "0x6F77") ;; <CJK>
       (?$(1Qj(B . "0x6F6A") ;; <CJK>
       (?$(1Qk(B . "0x6F7B") ;; <CJK>
       (?$(1Ql(B . "0x71B2") ;; <CJK>
       (?$(1Qm(B . "0x71AF") ;; <CJK>
       (?$(1Qn(B . "0x719B") ;; <CJK>
       (?$(1Qo(B . "0x71B0") ;; <CJK>
       (?$(1Qp(B . "0x71A0") ;; <CJK>
       (?$(1Qq(B . "0x719A") ;; <CJK>
       (?$(1Qr(B . "0x71A9") ;; <CJK>
       (?$(1Qs(B . "0x71B5") ;; <CJK>
       (?$(1Qt(B . "0x719D") ;; <CJK>
       (?$(1Qu(B . "0x71A5") ;; <CJK>
       (?$(1Qv(B . "0x719E") ;; <CJK>
       (?$(1Qw(B . "0x71A4") ;; <CJK>
       (?$(1Qx(B . "0x71A1") ;; <CJK>
       (?$(1Qy(B . "0x71AA") ;; <CJK>
       (?$(1Qz(B . "0x719C") ;; <CJK>
       (?$(1Q{(B . "0x71A7") ;; <CJK>
       (?$(1Q|(B . "0x71B3") ;; <CJK>
       (?$(1Q}(B . "0x7298") ;; <CJK>
       (?$(1Q~(B . "0x729A") ;; <CJK>
       (?$(1R!(B . "0x7358") ;; <CJK>
       (?$(1R"(B . "0x7352") ;; <CJK>
       (?$(1R#(B . "0x735E") ;; <CJK>
       (?$(1R$(B . "0x735F") ;; <CJK>
       (?$(1R%(B . "0x7360") ;; <CJK>
       (?$(1R&(B . "0x735D") ;; <CJK>
       (?$(1R'(B . "0x735B") ;; <CJK>
       (?$(1R((B . "0x7361") ;; <CJK>
       (?$(1R)(B . "0x735A") ;; <CJK>
       (?$(1R*(B . "0x7359") ;; <CJK>
       (?$(1R+(B . "0x7362") ;; <CJK>
       (?$(1R,(B . "0x7487") ;; <CJK>
       (?$(1R-(B . "0x7489") ;; <CJK>
       (?$(1R.(B . "0x748A") ;; <CJK>
       (?$(1R/(B . "0x7486") ;; <CJK>
       (?$(1R0(B . "0x7481") ;; <CJK>
       (?$(1R1(B . "0x747D") ;; <CJK>
       (?$(1R2(B . "0x7485") ;; <CJK>
       (?$(1R3(B . "0x7488") ;; <CJK>
       (?$(1R4(B . "0x747C") ;; <CJK>
       (?$(1R5(B . "0x7479") ;; <CJK>
       (?$(1R6(B . "0x7508") ;; <CJK>
       (?$(1R7(B . "0x7507") ;; <CJK>
       (?$(1R8(B . "0x757E") ;; <CJK>
       (?$(1R9(B . "0x7625") ;; <CJK>
       (?$(1R:(B . "0x761E") ;; <CJK>
       (?$(1R;(B . "0x7619") ;; <CJK>
       (?$(1R<(B . "0x761D") ;; <CJK>
       (?$(1R=(B . "0x761C") ;; <CJK>
       (?$(1R>(B . "0x7623") ;; <CJK>
       (?$(1R?(B . "0x761A") ;; <CJK>
       (?$(1R@(B . "0x7628") ;; <CJK>
       (?$(1RA(B . "0x761B") ;; <CJK>
       (?$(1RB(B . "0x769C") ;; <CJK>
       (?$(1RC(B . "0x769D") ;; <CJK>
       (?$(1RD(B . "0x769E") ;; <CJK>
       (?$(1RE(B . "0x769B") ;; <CJK>
       (?$(1RF(B . "0x778D") ;; <CJK>
       (?$(1RG(B . "0x778F") ;; <CJK>
       (?$(1RH(B . "0x7789") ;; <CJK>
       (?$(1RI(B . "0x7788") ;; <CJK>
       (?$(1RJ(B . "0x78CD") ;; <CJK>
       (?$(1RK(B . "0x78BB") ;; <CJK>
       (?$(1RL(B . "0x78CF") ;; <CJK>
       (?$(1RM(B . "0x78CC") ;; <CJK>
       (?$(1RN(B . "0x78D1") ;; <CJK>
       (?$(1RO(B . "0x78CE") ;; <CJK>
       (?$(1RP(B . "0x78D4") ;; <CJK>
       (?$(1RQ(B . "0x78C8") ;; <CJK>
       (?$(1RR(B . "0x78C3") ;; <CJK>
       (?$(1RS(B . "0x78C4") ;; <CJK>
       (?$(1RT(B . "0x78C9") ;; <CJK>
       (?$(1RU(B . "0x799A") ;; <CJK>
       (?$(1RV(B . "0x79A1") ;; <CJK>
       (?$(1RW(B . "0x79A0") ;; <CJK>
       (?$(1RX(B . "0x799C") ;; <CJK>
       (?$(1RY(B . "0x79A2") ;; <CJK>
       (?$(1RZ(B . "0x799B") ;; <CJK>
       (?$(1R[(B . "0x6B76") ;; <CJK>
       (?$(1R\(B . "0x7A39") ;; <CJK>
       (?$(1R](B . "0x7AB2") ;; <CJK>
       (?$(1R^(B . "0x7AB4") ;; <CJK>
       (?$(1R_(B . "0x7AB3") ;; <CJK>
       (?$(1R`(B . "0x7BB7") ;; <CJK>
       (?$(1Ra(B . "0x7BCB") ;; <CJK>
       (?$(1Rb(B . "0x7BBE") ;; <CJK>
       (?$(1Rc(B . "0x7BAC") ;; <CJK>
       (?$(1Rd(B . "0x7BCE") ;; <CJK>
       (?$(1Re(B . "0x7BAF") ;; <CJK>
       (?$(1Rf(B . "0x7BB9") ;; <CJK>
       (?$(1Rg(B . "0x7BCA") ;; <CJK>
       (?$(1Rh(B . "0x7BB5") ;; <CJK>
       (?$(1Ri(B . "0x7CC5") ;; <CJK>
       (?$(1Rj(B . "0x7CC8") ;; <CJK>
       (?$(1Rk(B . "0x7CCC") ;; <CJK>
       (?$(1Rl(B . "0x7CCB") ;; <CJK>
       (?$(1Rm(B . "0x7DF7") ;; <CJK>
       (?$(1Rn(B . "0x7DDB") ;; <CJK>
       (?$(1Ro(B . "0x7DEA") ;; <CJK>
       (?$(1Rp(B . "0x7DE7") ;; <CJK>
       (?$(1Rq(B . "0x7DD7") ;; <CJK>
       (?$(1Rr(B . "0x7DE1") ;; <CJK>
       (?$(1Rs(B . "0x7E03") ;; <CJK>
       (?$(1Rt(B . "0x7DFA") ;; <CJK>
       (?$(1Ru(B . "0x7DE6") ;; <CJK>
       (?$(1Rv(B . "0x7DF6") ;; <CJK>
       (?$(1Rw(B . "0x7DF1") ;; <CJK>
       (?$(1Rx(B . "0x7DF0") ;; <CJK>
       (?$(1Ry(B . "0x7DEE") ;; <CJK>
       (?$(1Rz(B . "0x7DDF") ;; <CJK>
       (?$(1R{(B . "0x7F76") ;; <CJK>
       (?$(1R|(B . "0x7FAC") ;; <CJK>
       (?$(1R}(B . "0x7FB0") ;; <CJK>
       (?$(1R~(B . "0x7FAD") ;; <CJK>
       (?$(1S!(B . "0x7FED") ;; <CJK>
       (?$(1S"(B . "0x7FEB") ;; <CJK>
       (?$(1S#(B . "0x7FEA") ;; <CJK>
       (?$(1S$(B . "0x7FEC") ;; <CJK>
       (?$(1S%(B . "0x7FE6") ;; <CJK>
       (?$(1S&(B . "0x7FE8") ;; <CJK>
       (?$(1S'(B . "0x8064") ;; <CJK>
       (?$(1S((B . "0x8067") ;; <CJK>
       (?$(1S)(B . "0x81A3") ;; <CJK>
       (?$(1S*(B . "0x819F") ;; <CJK>
       (?$(1S+(B . "0x819E") ;; <CJK>
       (?$(1S,(B . "0x8195") ;; <CJK>
       (?$(1S-(B . "0x81A2") ;; <CJK>
       (?$(1S.(B . "0x8199") ;; <CJK>
       (?$(1S/(B . "0x8197") ;; <CJK>
       (?$(1S0(B . "0x8216") ;; <CJK>
       (?$(1S1(B . "0x824F") ;; <CJK>
       (?$(1S2(B . "0x8253") ;; <CJK>
       (?$(1S3(B . "0x8252") ;; <CJK>
       (?$(1S4(B . "0x8250") ;; <CJK>
       (?$(1S5(B . "0x824E") ;; <CJK>
       (?$(1S6(B . "0x8251") ;; <CJK>
       (?$(1S7(B . "0x8524") ;; <CJK>
       (?$(1S8(B . "0x853B") ;; <CJK>
       (?$(1S9(B . "0x850F") ;; <CJK>
       (?$(1S:(B . "0x8500") ;; <CJK>
       (?$(1S;(B . "0x8529") ;; <CJK>
       (?$(1S<(B . "0x850E") ;; <CJK>
       (?$(1S=(B . "0x8509") ;; <CJK>
       (?$(1S>(B . "0x850D") ;; <CJK>
       (?$(1S?(B . "0x851F") ;; <CJK>
       (?$(1S@(B . "0x850A") ;; <CJK>
       (?$(1SA(B . "0x8527") ;; <CJK>
       (?$(1SB(B . "0x851C") ;; <CJK>
       (?$(1SC(B . "0x84FB") ;; <CJK>
       (?$(1SD(B . "0x852B") ;; <CJK>
       (?$(1SE(B . "0x84FA") ;; <CJK>
       (?$(1SF(B . "0x8508") ;; <CJK>
       (?$(1SG(B . "0x850C") ;; <CJK>
       (?$(1SH(B . "0x84F4") ;; <CJK>
       (?$(1SI(B . "0x852A") ;; <CJK>
       (?$(1SJ(B . "0x84F2") ;; <CJK>
       (?$(1SK(B . "0x8515") ;; <CJK>
       (?$(1SL(B . "0x84F7") ;; <CJK>
       (?$(1SM(B . "0x84EB") ;; <CJK>
       (?$(1SN(B . "0x84F3") ;; <CJK>
       (?$(1SO(B . "0x84FC") ;; <CJK>
       (?$(1SP(B . "0x8512") ;; <CJK>
       (?$(1SQ(B . "0x84EA") ;; <CJK>
       (?$(1SR(B . "0x84E9") ;; <CJK>
       (?$(1SS(B . "0x8516") ;; <CJK>
       (?$(1ST(B . "0x84FE") ;; <CJK>
       (?$(1SU(B . "0x8528") ;; <CJK>
       (?$(1SV(B . "0x851D") ;; <CJK>
       (?$(1SW(B . "0x852E") ;; <CJK>
       (?$(1SX(B . "0x8502") ;; <CJK>
       (?$(1SY(B . "0x84FD") ;; <CJK>
       (?$(1SZ(B . "0x851E") ;; <CJK>
       (?$(1S[(B . "0x84F6") ;; <CJK>
       (?$(1S\(B . "0x8531") ;; <CJK>
       (?$(1S](B . "0x8526") ;; <CJK>
       (?$(1S^(B . "0x84E7") ;; <CJK>
       (?$(1S_(B . "0x84E8") ;; <CJK>
       (?$(1S`(B . "0x84F0") ;; <CJK>
       (?$(1Sa(B . "0x84EF") ;; <CJK>
       (?$(1Sb(B . "0x84F9") ;; <CJK>
       (?$(1Sc(B . "0x8518") ;; <CJK>
       (?$(1Sd(B . "0x8520") ;; <CJK>
       (?$(1Se(B . "0x8530") ;; <CJK>
       (?$(1Sf(B . "0x850B") ;; <CJK>
       (?$(1Sg(B . "0x8519") ;; <CJK>
       (?$(1Sh(B . "0x852F") ;; <CJK>
       (?$(1Si(B . "0x8662") ;; <CJK>
       (?$(1Sj(B . "0x8756") ;; <CJK>
       (?$(1Sk(B . "0x8763") ;; <CJK>
       (?$(1Sl(B . "0x8764") ;; <CJK>
       (?$(1Sm(B . "0x8777") ;; <CJK>
       (?$(1Sn(B . "0x87E1") ;; <CJK>
       (?$(1So(B . "0x8773") ;; <CJK>
       (?$(1Sp(B . "0x8758") ;; <CJK>
       (?$(1Sq(B . "0x8754") ;; <CJK>
       (?$(1Sr(B . "0x875B") ;; <CJK>
       (?$(1Ss(B . "0x8752") ;; <CJK>
       (?$(1St(B . "0x8761") ;; <CJK>
       (?$(1Su(B . "0x875A") ;; <CJK>
       (?$(1Sv(B . "0x8751") ;; <CJK>
       (?$(1Sw(B . "0x875E") ;; <CJK>
       (?$(1Sx(B . "0x876D") ;; <CJK>
       (?$(1Sy(B . "0x876A") ;; <CJK>
       (?$(1Sz(B . "0x8750") ;; <CJK>
       (?$(1S{(B . "0x874E") ;; <CJK>
       (?$(1S|(B . "0x875F") ;; <CJK>
       (?$(1S}(B . "0x875D") ;; <CJK>
       (?$(1S~(B . "0x876F") ;; <CJK>
       (?$(1T!(B . "0x876C") ;; <CJK>
       (?$(1T"(B . "0x877A") ;; <CJK>
       (?$(1T#(B . "0x876E") ;; <CJK>
       (?$(1T$(B . "0x875C") ;; <CJK>
       (?$(1T%(B . "0x8765") ;; <CJK>
       (?$(1T&(B . "0x874F") ;; <CJK>
       (?$(1T'(B . "0x877B") ;; <CJK>
       (?$(1T((B . "0x8775") ;; <CJK>
       (?$(1T)(B . "0x8762") ;; <CJK>
       (?$(1T*(B . "0x8767") ;; <CJK>
       (?$(1T+(B . "0x8769") ;; <CJK>
       (?$(1T,(B . "0x885A") ;; <CJK>
       (?$(1T-(B . "0x8905") ;; <CJK>
       (?$(1T.(B . "0x890C") ;; <CJK>
       (?$(1T/(B . "0x8914") ;; <CJK>
       (?$(1T0(B . "0x890B") ;; <CJK>
       (?$(1T1(B . "0x8917") ;; <CJK>
       (?$(1T2(B . "0x8918") ;; <CJK>
       (?$(1T3(B . "0x8919") ;; <CJK>
       (?$(1T4(B . "0x8906") ;; <CJK>
       (?$(1T5(B . "0x8916") ;; <CJK>
       (?$(1T6(B . "0x8911") ;; <CJK>
       (?$(1T7(B . "0x890E") ;; <CJK>
       (?$(1T8(B . "0x8909") ;; <CJK>
       (?$(1T9(B . "0x89A2") ;; <CJK>
       (?$(1T:(B . "0x89A4") ;; <CJK>
       (?$(1T;(B . "0x89A3") ;; <CJK>
       (?$(1T<(B . "0x89ED") ;; <CJK>
       (?$(1T=(B . "0x89F0") ;; <CJK>
       (?$(1T>(B . "0x89EC") ;; <CJK>
       (?$(1T?(B . "0x8ACF") ;; <CJK>
       (?$(1T@(B . "0x8AC6") ;; <CJK>
       (?$(1TA(B . "0x8AB8") ;; <CJK>
       (?$(1TB(B . "0x8AD3") ;; <CJK>
       (?$(1TC(B . "0x8AD1") ;; <CJK>
       (?$(1TD(B . "0x8AD4") ;; <CJK>
       (?$(1TE(B . "0x8AD5") ;; <CJK>
       (?$(1TF(B . "0x8ABB") ;; <CJK>
       (?$(1TG(B . "0x8AD7") ;; <CJK>
       (?$(1TH(B . "0x8ABE") ;; <CJK>
       (?$(1TI(B . "0x8AC0") ;; <CJK>
       (?$(1TJ(B . "0x8AC5") ;; <CJK>
       (?$(1TK(B . "0x8AD8") ;; <CJK>
       (?$(1TL(B . "0x8AC3") ;; <CJK>
       (?$(1TM(B . "0x8ABA") ;; <CJK>
       (?$(1TN(B . "0x8ABD") ;; <CJK>
       (?$(1TO(B . "0x8AD9") ;; <CJK>
       (?$(1TP(B . "0x8C3E") ;; <CJK>
       (?$(1TQ(B . "0x8C4D") ;; <CJK>
       (?$(1TR(B . "0x8C8F") ;; <CJK>
       (?$(1TS(B . "0x8CE5") ;; <CJK>
       (?$(1TT(B . "0x8CDF") ;; <CJK>
       (?$(1TU(B . "0x8CD9") ;; <CJK>
       (?$(1TV(B . "0x8CE8") ;; <CJK>
       (?$(1TW(B . "0x8CDA") ;; <CJK>
       (?$(1TX(B . "0x8CDD") ;; <CJK>
       (?$(1TY(B . "0x8CE7") ;; <CJK>
       (?$(1TZ(B . "0x8DA0") ;; <CJK>
       (?$(1T[(B . "0x8D9C") ;; <CJK>
       (?$(1T\(B . "0x8DA1") ;; <CJK>
       (?$(1T](B . "0x8D9B") ;; <CJK>
       (?$(1T^(B . "0x8E20") ;; <CJK>
       (?$(1T_(B . "0x8E23") ;; <CJK>
       (?$(1T`(B . "0x8E25") ;; <CJK>
       (?$(1Ta(B . "0x8E24") ;; <CJK>
       (?$(1Tb(B . "0x8E2E") ;; <CJK>
       (?$(1Tc(B . "0x8E15") ;; <CJK>
       (?$(1Td(B . "0x8E1B") ;; <CJK>
       (?$(1Te(B . "0x8E16") ;; <CJK>
       (?$(1Tf(B . "0x8E11") ;; <CJK>
       (?$(1Tg(B . "0x8E19") ;; <CJK>
       (?$(1Th(B . "0x8E26") ;; <CJK>
       (?$(1Ti(B . "0x8E27") ;; <CJK>
       (?$(1Tj(B . "0x8E14") ;; <CJK>
       (?$(1Tk(B . "0x8E12") ;; <CJK>
       (?$(1Tl(B . "0x8E18") ;; <CJK>
       (?$(1Tm(B . "0x8E13") ;; <CJK>
       (?$(1Tn(B . "0x8E1C") ;; <CJK>
       (?$(1To(B . "0x8E17") ;; <CJK>
       (?$(1Tp(B . "0x8E1A") ;; <CJK>
       (?$(1Tq(B . "0x8F2C") ;; <CJK>
       (?$(1Tr(B . "0x8F24") ;; <CJK>
       (?$(1Ts(B . "0x8F18") ;; <CJK>
       (?$(1Tt(B . "0x8F1A") ;; <CJK>
       (?$(1Tu(B . "0x8F20") ;; <CJK>
       (?$(1Tv(B . "0x8F23") ;; <CJK>
       (?$(1Tw(B . "0x8F16") ;; <CJK>
       (?$(1Tx(B . "0x8F17") ;; <CJK>
       (?$(1Ty(B . "0x9073") ;; <CJK>
       (?$(1Tz(B . "0x9070") ;; <CJK>
       (?$(1T{(B . "0x906F") ;; <CJK>
       (?$(1T|(B . "0x9067") ;; <CJK>
       (?$(1T}(B . "0x906B") ;; <CJK>
       (?$(1T~(B . "0x912F") ;; <CJK>
       (?$(1U!(B . "0x912B") ;; <CJK>
       (?$(1U"(B . "0x9129") ;; <CJK>
       (?$(1U#(B . "0x912A") ;; <CJK>
       (?$(1U$(B . "0x9132") ;; <CJK>
       (?$(1U%(B . "0x9126") ;; <CJK>
       (?$(1U&(B . "0x912E") ;; <CJK>
       (?$(1U'(B . "0x9185") ;; <CJK>
       (?$(1U((B . "0x9186") ;; <CJK>
       (?$(1U)(B . "0x918A") ;; <CJK>
       (?$(1U*(B . "0x9181") ;; <CJK>
       (?$(1U+(B . "0x9182") ;; <CJK>
       (?$(1U,(B . "0x9184") ;; <CJK>
       (?$(1U-(B . "0x9180") ;; <CJK>
       (?$(1U.(B . "0x92D0") ;; <CJK>
       (?$(1U/(B . "0x92C3") ;; <CJK>
       (?$(1U0(B . "0x92C4") ;; <CJK>
       (?$(1U1(B . "0x92C0") ;; <CJK>
       (?$(1U2(B . "0x92D9") ;; <CJK>
       (?$(1U3(B . "0x92B6") ;; <CJK>
       (?$(1U4(B . "0x92CF") ;; <CJK>
       (?$(1U5(B . "0x92F1") ;; <CJK>
       (?$(1U6(B . "0x92DF") ;; <CJK>
       (?$(1U7(B . "0x92D8") ;; <CJK>
       (?$(1U8(B . "0x92E9") ;; <CJK>
       (?$(1U9(B . "0x92D7") ;; <CJK>
       (?$(1U:(B . "0x92DD") ;; <CJK>
       (?$(1U;(B . "0x92CC") ;; <CJK>
       (?$(1U<(B . "0x92EF") ;; <CJK>
       (?$(1U=(B . "0x92C2") ;; <CJK>
       (?$(1U>(B . "0x92E8") ;; <CJK>
       (?$(1U?(B . "0x92CA") ;; <CJK>
       (?$(1U@(B . "0x92C8") ;; <CJK>
       (?$(1UA(B . "0x92CE") ;; <CJK>
       (?$(1UB(B . "0x92E6") ;; <CJK>
       (?$(1UC(B . "0x92CD") ;; <CJK>
       (?$(1UD(B . "0x92D5") ;; <CJK>
       (?$(1UE(B . "0x92C9") ;; <CJK>
       (?$(1UF(B . "0x92E0") ;; <CJK>
       (?$(1UG(B . "0x92DE") ;; <CJK>
       (?$(1UH(B . "0x92E7") ;; <CJK>
       (?$(1UI(B . "0x92D1") ;; <CJK>
       (?$(1UJ(B . "0x92D3") ;; <CJK>
       (?$(1UK(B . "0x92B5") ;; <CJK>
       (?$(1UL(B . "0x92E1") ;; <CJK>
       (?$(1UM(B . "0x92C6") ;; <CJK>
       (?$(1UN(B . "0x92B4") ;; <CJK>
       (?$(1UO(B . "0x957C") ;; <CJK>
       (?$(1UP(B . "0x95AC") ;; <CJK>
       (?$(1UQ(B . "0x95AB") ;; <CJK>
       (?$(1UR(B . "0x95AE") ;; <CJK>
       (?$(1US(B . "0x95B0") ;; <CJK>
       (?$(1UT(B . "0x96A4") ;; <CJK>
       (?$(1UU(B . "0x96A2") ;; <CJK>
       (?$(1UV(B . "0x96D3") ;; <CJK>
       (?$(1UW(B . "0x9705") ;; <CJK>
       (?$(1UX(B . "0x9708") ;; <CJK>
       (?$(1UY(B . "0x9702") ;; <CJK>
       (?$(1UZ(B . "0x975A") ;; <CJK>
       (?$(1U[(B . "0x978A") ;; <CJK>
       (?$(1U\(B . "0x978E") ;; <CJK>
       (?$(1U](B . "0x9788") ;; <CJK>
       (?$(1U^(B . "0x97D0") ;; <CJK>
       (?$(1U_(B . "0x97CF") ;; <CJK>
       (?$(1U`(B . "0x981E") ;; <CJK>
       (?$(1Ua(B . "0x981D") ;; <CJK>
       (?$(1Ub(B . "0x9826") ;; <CJK>
       (?$(1Uc(B . "0x9829") ;; <CJK>
       (?$(1Ud(B . "0x9828") ;; <CJK>
       (?$(1Ue(B . "0x9820") ;; <CJK>
       (?$(1Uf(B . "0x981B") ;; <CJK>
       (?$(1Ug(B . "0x9827") ;; <CJK>
       (?$(1Uh(B . "0x98B2") ;; <CJK>
       (?$(1Ui(B . "0x9908") ;; <CJK>
       (?$(1Uj(B . "0x98FA") ;; <CJK>
       (?$(1Uk(B . "0x9911") ;; <CJK>
       (?$(1Ul(B . "0x9914") ;; <CJK>
       (?$(1Um(B . "0x9916") ;; <CJK>
       (?$(1Un(B . "0x9917") ;; <CJK>
       (?$(1Uo(B . "0x9915") ;; <CJK>
       (?$(1Up(B . "0x99DC") ;; <CJK>
       (?$(1Uq(B . "0x99CD") ;; <CJK>
       (?$(1Ur(B . "0x99CF") ;; <CJK>
       (?$(1Us(B . "0x99D3") ;; <CJK>
       (?$(1Ut(B . "0x99D4") ;; <CJK>
       (?$(1Uu(B . "0x99CE") ;; <CJK>
       (?$(1Uv(B . "0x99C9") ;; <CJK>
       (?$(1Uw(B . "0x99D6") ;; <CJK>
       (?$(1Ux(B . "0x99D8") ;; <CJK>
       (?$(1Uy(B . "0x99CB") ;; <CJK>
       (?$(1Uz(B . "0x99D7") ;; <CJK>
       (?$(1U{(B . "0x99CC") ;; <CJK>
       (?$(1U|(B . "0x9AB3") ;; <CJK>
       (?$(1U}(B . "0x9AEC") ;; <CJK>
       (?$(1U~(B . "0x9AEB") ;; <CJK>
       (?$(1V!(B . "0x9AF3") ;; <CJK>
       (?$(1V"(B . "0x9AF2") ;; <CJK>
       (?$(1V#(B . "0x9AF1") ;; <CJK>
       (?$(1V$(B . "0x9B46") ;; <CJK>
       (?$(1V%(B . "0x9B43") ;; <CJK>
       (?$(1V&(B . "0x9B67") ;; <CJK>
       (?$(1V'(B . "0x9B74") ;; <CJK>
       (?$(1V((B . "0x9B71") ;; <CJK>
       (?$(1V)(B . "0x9B66") ;; <CJK>
       (?$(1V*(B . "0x9B76") ;; <CJK>
       (?$(1V+(B . "0x9B75") ;; <CJK>
       (?$(1V,(B . "0x9B70") ;; <CJK>
       (?$(1V-(B . "0x9B68") ;; <CJK>
       (?$(1V.(B . "0x9B64") ;; <CJK>
       (?$(1V/(B . "0x9B6C") ;; <CJK>
       (?$(1V0(B . "0x9CFC") ;; <CJK>
       (?$(1V1(B . "0x9CFA") ;; <CJK>
       (?$(1V2(B . "0x9CFD") ;; <CJK>
       (?$(1V3(B . "0x9CFF") ;; <CJK>
       (?$(1V4(B . "0x9CF7") ;; <CJK>
       (?$(1V5(B . "0x9D07") ;; <CJK>
       (?$(1V6(B . "0x9D00") ;; <CJK>
       (?$(1V7(B . "0x9CF9") ;; <CJK>
       (?$(1V8(B . "0x9CFB") ;; <CJK>
       (?$(1V9(B . "0x9D08") ;; <CJK>
       (?$(1V:(B . "0x9D05") ;; <CJK>
       (?$(1V;(B . "0x9D04") ;; <CJK>
       (?$(1V<(B . "0x9E83") ;; <CJK>
       (?$(1V=(B . "0x9ED3") ;; <CJK>
       (?$(1V>(B . "0x9F0F") ;; <CJK>
       (?$(1V?(B . "0x9F10") ;; <CJK>
       (?$(1V@(B . "0x511C") ;; <CJK>
       (?$(1VA(B . "0x5113") ;; <CJK>
       (?$(1VB(B . "0x5117") ;; <CJK>
       (?$(1VC(B . "0x511A") ;; <CJK>
       (?$(1VD(B . "0x5111") ;; <CJK>
       (?$(1VE(B . "0x51DE") ;; <CJK>
       (?$(1VF(B . "0x5334") ;; <CJK>
       (?$(1VG(B . "0x53E1") ;; <CJK>
       (?$(1VH(B . "0x5670") ;; <CJK>
       (?$(1VI(B . "0x5660") ;; <CJK>
       (?$(1VJ(B . "0x566E") ;; <CJK>
       (?$(1VK(B . "0x5673") ;; <CJK>
       (?$(1VL(B . "0x5666") ;; <CJK>
       (?$(1VM(B . "0x5663") ;; <CJK>
       (?$(1VN(B . "0x566D") ;; <CJK>
       (?$(1VO(B . "0x5672") ;; <CJK>
       (?$(1VP(B . "0x565E") ;; <CJK>
       (?$(1VQ(B . "0x5677") ;; <CJK>
       (?$(1VR(B . "0x571C") ;; <CJK>
       (?$(1VS(B . "0x571B") ;; <CJK>
       (?$(1VT(B . "0x58C8") ;; <CJK>
       (?$(1VU(B . "0x58BD") ;; <CJK>
       (?$(1VV(B . "0x58C9") ;; <CJK>
       (?$(1VW(B . "0x58BF") ;; <CJK>
       (?$(1VX(B . "0x58BA") ;; <CJK>
       (?$(1VY(B . "0x58C2") ;; <CJK>
       (?$(1VZ(B . "0x58BC") ;; <CJK>
       (?$(1V[(B . "0x58C6") ;; <CJK>
       (?$(1V\(B . "0x5B17") ;; <CJK>
       (?$(1V](B . "0x5B19") ;; <CJK>
       (?$(1V^(B . "0x5B1B") ;; <CJK>
       (?$(1V_(B . "0x5B21") ;; <CJK>
       (?$(1V`(B . "0x5B14") ;; <CJK>
       (?$(1Va(B . "0x5B13") ;; <CJK>
       (?$(1Vb(B . "0x5B10") ;; <CJK>
       (?$(1Vc(B . "0x5B16") ;; <CJK>
       (?$(1Vd(B . "0x5B28") ;; <CJK>
       (?$(1Ve(B . "0x5B1A") ;; <CJK>
       (?$(1Vf(B . "0x5B20") ;; <CJK>
       (?$(1Vg(B . "0x5B1E") ;; <CJK>
       (?$(1Vh(B . "0x5BEF") ;; <CJK>
       (?$(1Vi(B . "0x5DAC") ;; <CJK>
       (?$(1Vj(B . "0x5DB1") ;; <CJK>
       (?$(1Vk(B . "0x5DA9") ;; <CJK>
       (?$(1Vl(B . "0x5DA7") ;; <CJK>
       (?$(1Vm(B . "0x5DB5") ;; <CJK>
       (?$(1Vn(B . "0x5DB0") ;; <CJK>
       (?$(1Vo(B . "0x5DAE") ;; <CJK>
       (?$(1Vp(B . "0x5DAA") ;; <CJK>
       (?$(1Vq(B . "0x5DA8") ;; <CJK>
       (?$(1Vr(B . "0x5DB2") ;; <CJK>
       (?$(1Vs(B . "0x5DAD") ;; <CJK>
       (?$(1Vt(B . "0x5DAF") ;; <CJK>
       (?$(1Vu(B . "0x5DB4") ;; <CJK>
       (?$(1Vv(B . "0x5E67") ;; <CJK>
       (?$(1Vw(B . "0x5E68") ;; <CJK>
       (?$(1Vx(B . "0x5E66") ;; <CJK>
       (?$(1Vy(B . "0x5E6F") ;; <CJK>
       (?$(1Vz(B . "0x5EE9") ;; <CJK>
       (?$(1V{(B . "0x5EE7") ;; <CJK>
       (?$(1V|(B . "0x5EE6") ;; <CJK>
       (?$(1V}(B . "0x5EE8") ;; <CJK>
       (?$(1V~(B . "0x5EE5") ;; <CJK>
       (?$(1W!(B . "0x5F4B") ;; <CJK>
       (?$(1W"(B . "0x5FBC") ;; <CJK>
       (?$(1W#(B . "0x619D") ;; <CJK>
       (?$(1W$(B . "0x61A8") ;; <CJK>
       (?$(1W%(B . "0x6196") ;; <CJK>
       (?$(1W&(B . "0x61C5") ;; <CJK>
       (?$(1W'(B . "0x61B4") ;; <CJK>
       (?$(1W((B . "0x61C6") ;; <CJK>
       (?$(1W)(B . "0x61C1") ;; <CJK>
       (?$(1W*(B . "0x61CC") ;; <CJK>
       (?$(1W+(B . "0x61BA") ;; <CJK>
       (?$(1W,(B . "0x61BF") ;; <CJK>
       (?$(1W-(B . "0x61B8") ;; <CJK>
       (?$(1W.(B . "0x618C") ;; <CJK>
       (?$(1W/(B . "0x64D7") ;; <CJK>
       (?$(1W0(B . "0x64D6") ;; <CJK>
       (?$(1W1(B . "0x64D0") ;; <CJK>
       (?$(1W2(B . "0x64CF") ;; <CJK>
       (?$(1W3(B . "0x64C9") ;; <CJK>
       (?$(1W4(B . "0x64BD") ;; <CJK>
       (?$(1W5(B . "0x6489") ;; <CJK>
       (?$(1W6(B . "0x64C3") ;; <CJK>
       (?$(1W7(B . "0x64DB") ;; <CJK>
       (?$(1W8(B . "0x64F3") ;; <CJK>
       (?$(1W9(B . "0x64D9") ;; <CJK>
       (?$(1W:(B . "0x6533") ;; <CJK>
       (?$(1W;(B . "0x657F") ;; <CJK>
       (?$(1W<(B . "0x657C") ;; <CJK>
       (?$(1W=(B . "0x65A2") ;; <CJK>
       (?$(1W>(B . "0x66C8") ;; <CJK>
       (?$(1W?(B . "0x66BE") ;; <CJK>
       (?$(1W@(B . "0x66C0") ;; <CJK>
       (?$(1WA(B . "0x66CA") ;; <CJK>
       (?$(1WB(B . "0x66CB") ;; <CJK>
       (?$(1WC(B . "0x66CF") ;; <CJK>
       (?$(1WD(B . "0x66BD") ;; <CJK>
       (?$(1WE(B . "0x66BB") ;; <CJK>
       (?$(1WF(B . "0x66BA") ;; <CJK>
       (?$(1WG(B . "0x66CC") ;; <CJK>
       (?$(1WH(B . "0x6723") ;; <CJK>
       (?$(1WI(B . "0x6A34") ;; <CJK>
       (?$(1WJ(B . "0x6A66") ;; <CJK>
       (?$(1WK(B . "0x6A49") ;; <CJK>
       (?$(1WL(B . "0x6A67") ;; <CJK>
       (?$(1WM(B . "0x6A32") ;; <CJK>
       (?$(1WN(B . "0x6A68") ;; <CJK>
       (?$(1WO(B . "0x6A3E") ;; <CJK>
       (?$(1WP(B . "0x6A5D") ;; <CJK>
       (?$(1WQ(B . "0x6A6D") ;; <CJK>
       (?$(1WR(B . "0x6A76") ;; <CJK>
       (?$(1WS(B . "0x6A5B") ;; <CJK>
       (?$(1WT(B . "0x6A51") ;; <CJK>
       (?$(1WU(B . "0x6A28") ;; <CJK>
       (?$(1WV(B . "0x6A5A") ;; <CJK>
       (?$(1WW(B . "0x6A3B") ;; <CJK>
       (?$(1WX(B . "0x6A3F") ;; <CJK>
       (?$(1WY(B . "0x6A41") ;; <CJK>
       (?$(1WZ(B . "0x6A6A") ;; <CJK>
       (?$(1W[(B . "0x6A64") ;; <CJK>
       (?$(1W\(B . "0x6A50") ;; <CJK>
       (?$(1W](B . "0x6A4F") ;; <CJK>
       (?$(1W^(B . "0x6A54") ;; <CJK>
       (?$(1W_(B . "0x6A6F") ;; <CJK>
       (?$(1W`(B . "0x6A69") ;; <CJK>
       (?$(1Wa(B . "0x6A60") ;; <CJK>
       (?$(1Wb(B . "0x6A3C") ;; <CJK>
       (?$(1Wc(B . "0x6A5E") ;; <CJK>
       (?$(1Wd(B . "0x6A56") ;; <CJK>
       (?$(1We(B . "0x6A55") ;; <CJK>
       (?$(1Wf(B . "0x6A4D") ;; <CJK>
       (?$(1Wg(B . "0x6A4E") ;; <CJK>
       (?$(1Wh(B . "0x6A46") ;; <CJK>
       (?$(1Wi(B . "0x6B55") ;; <CJK>
       (?$(1Wj(B . "0x6B54") ;; <CJK>
       (?$(1Wk(B . "0x6B56") ;; <CJK>
       (?$(1Wl(B . "0x6BA7") ;; <CJK>
       (?$(1Wm(B . "0x6BAA") ;; <CJK>
       (?$(1Wn(B . "0x6BAB") ;; <CJK>
       (?$(1Wo(B . "0x6BC8") ;; <CJK>
       (?$(1Wp(B . "0x6BC7") ;; <CJK>
       (?$(1Wq(B . "0x6C04") ;; <CJK>
       (?$(1Wr(B . "0x6C03") ;; <CJK>
       (?$(1Ws(B . "0x6C06") ;; <CJK>
       (?$(1Wt(B . "0x6FAD") ;; <CJK>
       (?$(1Wu(B . "0x6FCB") ;; <CJK>
       (?$(1Wv(B . "0x6FA3") ;; <CJK>
       (?$(1Ww(B . "0x6FC7") ;; <CJK>
       (?$(1Wx(B . "0x6FBC") ;; <CJK>
       (?$(1Wy(B . "0x6FCE") ;; <CJK>
       (?$(1Wz(B . "0x6FC8") ;; <CJK>
       (?$(1W{(B . "0x6F5E") ;; <CJK>
       (?$(1W|(B . "0x6FC4") ;; <CJK>
       (?$(1W}(B . "0x6FBD") ;; <CJK>
       (?$(1W~(B . "0x6F9E") ;; <CJK>
       (?$(1X!(B . "0x6FCA") ;; <CJK>
       (?$(1X"(B . "0x6FA8") ;; <CJK>
       (?$(1X#(B . "0x7004") ;; <CJK>
       (?$(1X$(B . "0x6FA5") ;; <CJK>
       (?$(1X%(B . "0x6FAE") ;; <CJK>
       (?$(1X&(B . "0x6FBA") ;; <CJK>
       (?$(1X'(B . "0x6FAC") ;; <CJK>
       (?$(1X((B . "0x6FAA") ;; <CJK>
       (?$(1X)(B . "0x6FCF") ;; <CJK>
       (?$(1X*(B . "0x6FBF") ;; <CJK>
       (?$(1X+(B . "0x6FB8") ;; <CJK>
       (?$(1X,(B . "0x6FA2") ;; <CJK>
       (?$(1X-(B . "0x6FC9") ;; <CJK>
       (?$(1X.(B . "0x6FAB") ;; <CJK>
       (?$(1X/(B . "0x6FCD") ;; <CJK>
       (?$(1X0(B . "0x6FAF") ;; <CJK>
       (?$(1X1(B . "0x6FB2") ;; <CJK>
       (?$(1X2(B . "0x6FB0") ;; <CJK>
       (?$(1X3(B . "0x71C5") ;; <CJK>
       (?$(1X4(B . "0x71C2") ;; <CJK>
       (?$(1X5(B . "0x71BF") ;; <CJK>
       (?$(1X6(B . "0x71B8") ;; <CJK>
       (?$(1X7(B . "0x71D6") ;; <CJK>
       (?$(1X8(B . "0x71C0") ;; <CJK>
       (?$(1X9(B . "0x71C1") ;; <CJK>
       (?$(1X:(B . "0x71CB") ;; <CJK>
       (?$(1X;(B . "0x71D4") ;; <CJK>
       (?$(1X<(B . "0x71CA") ;; <CJK>
       (?$(1X=(B . "0x71C7") ;; <CJK>
       (?$(1X>(B . "0x71CF") ;; <CJK>
       (?$(1X?(B . "0x71BD") ;; <CJK>
       (?$(1X@(B . "0x71D8") ;; <CJK>
       (?$(1XA(B . "0x71BC") ;; <CJK>
       (?$(1XB(B . "0x71C6") ;; <CJK>
       (?$(1XC(B . "0x71DA") ;; <CJK>
       (?$(1XD(B . "0x71DB") ;; <CJK>
       (?$(1XE(B . "0x729D") ;; <CJK>
       (?$(1XF(B . "0x729E") ;; <CJK>
       (?$(1XG(B . "0x7369") ;; <CJK>
       (?$(1XH(B . "0x7366") ;; <CJK>
       (?$(1XI(B . "0x7367") ;; <CJK>
       (?$(1XJ(B . "0x736C") ;; <CJK>
       (?$(1XK(B . "0x7365") ;; <CJK>
       (?$(1XL(B . "0x736B") ;; <CJK>
       (?$(1XM(B . "0x736A") ;; <CJK>
       (?$(1XN(B . "0x747F") ;; <CJK>
       (?$(1XO(B . "0x749A") ;; <CJK>
       (?$(1XP(B . "0x74A0") ;; <CJK>
       (?$(1XQ(B . "0x7494") ;; <CJK>
       (?$(1XR(B . "0x7492") ;; <CJK>
       (?$(1XS(B . "0x7495") ;; <CJK>
       (?$(1XT(B . "0x74A1") ;; <CJK>
       (?$(1XU(B . "0x750B") ;; <CJK>
       (?$(1XV(B . "0x7580") ;; <CJK>
       (?$(1XW(B . "0x762F") ;; <CJK>
       (?$(1XX(B . "0x762D") ;; <CJK>
       (?$(1XY(B . "0x7631") ;; <CJK>
       (?$(1XZ(B . "0x763D") ;; <CJK>
       (?$(1X[(B . "0x7633") ;; <CJK>
       (?$(1X\(B . "0x763C") ;; <CJK>
       (?$(1X](B . "0x7635") ;; <CJK>
       (?$(1X^(B . "0x7632") ;; <CJK>
       (?$(1X_(B . "0x7630") ;; <CJK>
       (?$(1X`(B . "0x76BB") ;; <CJK>
       (?$(1Xa(B . "0x76E6") ;; <CJK>
       (?$(1Xb(B . "0x779A") ;; <CJK>
       (?$(1Xc(B . "0x779D") ;; <CJK>
       (?$(1Xd(B . "0x77A1") ;; <CJK>
       (?$(1Xe(B . "0x779C") ;; <CJK>
       (?$(1Xf(B . "0x779B") ;; <CJK>
       (?$(1Xg(B . "0x77A2") ;; <CJK>
       (?$(1Xh(B . "0x77A3") ;; <CJK>
       (?$(1Xi(B . "0x7795") ;; <CJK>
       (?$(1Xj(B . "0x7799") ;; <CJK>
       (?$(1Xk(B . "0x7797") ;; <CJK>
       (?$(1Xl(B . "0x78DD") ;; <CJK>
       (?$(1Xm(B . "0x78E9") ;; <CJK>
       (?$(1Xn(B . "0x78E5") ;; <CJK>
       (?$(1Xo(B . "0x78EA") ;; <CJK>
       (?$(1Xp(B . "0x78DE") ;; <CJK>
       (?$(1Xq(B . "0x78E3") ;; <CJK>
       (?$(1Xr(B . "0x78DB") ;; <CJK>
       (?$(1Xs(B . "0x78E1") ;; <CJK>
       (?$(1Xt(B . "0x78E2") ;; <CJK>
       (?$(1Xu(B . "0x78ED") ;; <CJK>
       (?$(1Xv(B . "0x78DF") ;; <CJK>
       (?$(1Xw(B . "0x78E0") ;; <CJK>
       (?$(1Xx(B . "0x79A4") ;; <CJK>
       (?$(1Xy(B . "0x7A44") ;; <CJK>
       (?$(1Xz(B . "0x7A48") ;; <CJK>
       (?$(1X{(B . "0x7A47") ;; <CJK>
       (?$(1X|(B . "0x7AB6") ;; <CJK>
       (?$(1X}(B . "0x7AB8") ;; <CJK>
       (?$(1X~(B . "0x7AB5") ;; <CJK>
       (?$(1Y!(B . "0x7AB1") ;; <CJK>
       (?$(1Y"(B . "0x7AB7") ;; <CJK>
       (?$(1Y#(B . "0x7BDE") ;; <CJK>
       (?$(1Y$(B . "0x7BE3") ;; <CJK>
       (?$(1Y%(B . "0x7BE7") ;; <CJK>
       (?$(1Y&(B . "0x7BDD") ;; <CJK>
       (?$(1Y'(B . "0x7BD5") ;; <CJK>
       (?$(1Y((B . "0x7BE5") ;; <CJK>
       (?$(1Y)(B . "0x7BDA") ;; <CJK>
       (?$(1Y*(B . "0x7BE8") ;; <CJK>
       (?$(1Y+(B . "0x7BF9") ;; <CJK>
       (?$(1Y,(B . "0x7BD4") ;; <CJK>
       (?$(1Y-(B . "0x7BEA") ;; <CJK>
       (?$(1Y.(B . "0x7BE2") ;; <CJK>
       (?$(1Y/(B . "0x7BDC") ;; <CJK>
       (?$(1Y0(B . "0x7BEB") ;; <CJK>
       (?$(1Y1(B . "0x7BD8") ;; <CJK>
       (?$(1Y2(B . "0x7BDF") ;; <CJK>
       (?$(1Y3(B . "0x7CD2") ;; <CJK>
       (?$(1Y4(B . "0x7CD4") ;; <CJK>
       (?$(1Y5(B . "0x7CD7") ;; <CJK>
       (?$(1Y6(B . "0x7CD0") ;; <CJK>
       (?$(1Y7(B . "0x7CD1") ;; <CJK>
       (?$(1Y8(B . "0x7E12") ;; <CJK>
       (?$(1Y9(B . "0x7E21") ;; <CJK>
       (?$(1Y:(B . "0x7E17") ;; <CJK>
       (?$(1Y;(B . "0x7E0C") ;; <CJK>
       (?$(1Y<(B . "0x7E1F") ;; <CJK>
       (?$(1Y=(B . "0x7E20") ;; <CJK>
       (?$(1Y>(B . "0x7E13") ;; <CJK>
       (?$(1Y?(B . "0x7E0E") ;; <CJK>
       (?$(1Y@(B . "0x7E1C") ;; <CJK>
       (?$(1YA(B . "0x7E15") ;; <CJK>
       (?$(1YB(B . "0x7E1A") ;; <CJK>
       (?$(1YC(B . "0x7E22") ;; <CJK>
       (?$(1YD(B . "0x7E0B") ;; <CJK>
       (?$(1YE(B . "0x7E0F") ;; <CJK>
       (?$(1YF(B . "0x7E16") ;; <CJK>
       (?$(1YG(B . "0x7E0D") ;; <CJK>
       (?$(1YH(B . "0x7E14") ;; <CJK>
       (?$(1YI(B . "0x7E25") ;; <CJK>
       (?$(1YJ(B . "0x7E24") ;; <CJK>
       (?$(1YK(B . "0x7F43") ;; <CJK>
       (?$(1YL(B . "0x7F7B") ;; <CJK>
       (?$(1YM(B . "0x7F7C") ;; <CJK>
       (?$(1YN(B . "0x7F7A") ;; <CJK>
       (?$(1YO(B . "0x7FB1") ;; <CJK>
       (?$(1YP(B . "0x7FEF") ;; <CJK>
       (?$(1YQ(B . "0x802A") ;; <CJK>
       (?$(1YR(B . "0x8029") ;; <CJK>
       (?$(1YS(B . "0x806C") ;; <CJK>
       (?$(1YT(B . "0x81B1") ;; <CJK>
       (?$(1YU(B . "0x81A6") ;; <CJK>
       (?$(1YV(B . "0x81AE") ;; <CJK>
       (?$(1YW(B . "0x81B9") ;; <CJK>
       (?$(1YX(B . "0x81B5") ;; <CJK>
       (?$(1YY(B . "0x81AB") ;; <CJK>
       (?$(1YZ(B . "0x81B0") ;; <CJK>
       (?$(1Y[(B . "0x81AC") ;; <CJK>
       (?$(1Y\(B . "0x81B4") ;; <CJK>
       (?$(1Y](B . "0x81B2") ;; <CJK>
       (?$(1Y^(B . "0x81B7") ;; <CJK>
       (?$(1Y_(B . "0x81A7") ;; <CJK>
       (?$(1Y`(B . "0x81F2") ;; <CJK>
       (?$(1Ya(B . "0x8255") ;; <CJK>
       (?$(1Yb(B . "0x8256") ;; <CJK>
       (?$(1Yc(B . "0x8257") ;; <CJK>
       (?$(1Yd(B . "0x8556") ;; <CJK>
       (?$(1Ye(B . "0x8545") ;; <CJK>
       (?$(1Yf(B . "0x856B") ;; <CJK>
       (?$(1Yg(B . "0x854D") ;; <CJK>
       (?$(1Yh(B . "0x8553") ;; <CJK>
       (?$(1Yi(B . "0x8561") ;; <CJK>
       (?$(1Yj(B . "0x8558") ;; <CJK>
       (?$(1Yk(B . "0x8540") ;; <CJK>
       (?$(1Yl(B . "0x8546") ;; <CJK>
       (?$(1Ym(B . "0x8564") ;; <CJK>
       (?$(1Yn(B . "0x8541") ;; <CJK>
       (?$(1Yo(B . "0x8562") ;; <CJK>
       (?$(1Yp(B . "0x8544") ;; <CJK>
       (?$(1Yq(B . "0x8551") ;; <CJK>
       (?$(1Yr(B . "0x8547") ;; <CJK>
       (?$(1Ys(B . "0x8563") ;; <CJK>
       (?$(1Yt(B . "0x853E") ;; <CJK>
       (?$(1Yu(B . "0x855B") ;; <CJK>
       (?$(1Yv(B . "0x8571") ;; <CJK>
       (?$(1Yw(B . "0x854E") ;; <CJK>
       (?$(1Yx(B . "0x856E") ;; <CJK>
       (?$(1Yy(B . "0x8575") ;; <CJK>
       (?$(1Yz(B . "0x8555") ;; <CJK>
       (?$(1Y{(B . "0x8567") ;; <CJK>
       (?$(1Y|(B . "0x8560") ;; <CJK>
       (?$(1Y}(B . "0x858C") ;; <CJK>
       (?$(1Y~(B . "0x8566") ;; <CJK>
       (?$(1Z!(B . "0x855D") ;; <CJK>
       (?$(1Z"(B . "0x8554") ;; <CJK>
       (?$(1Z#(B . "0x8565") ;; <CJK>
       (?$(1Z$(B . "0x856C") ;; <CJK>
       (?$(1Z%(B . "0x8663") ;; <CJK>
       (?$(1Z&(B . "0x8665") ;; <CJK>
       (?$(1Z'(B . "0x8664") ;; <CJK>
       (?$(1Z((B . "0x879B") ;; <CJK>
       (?$(1Z)(B . "0x878F") ;; <CJK>
       (?$(1Z*(B . "0x8797") ;; <CJK>
       (?$(1Z+(B . "0x8793") ;; <CJK>
       (?$(1Z,(B . "0x8792") ;; <CJK>
       (?$(1Z-(B . "0x8788") ;; <CJK>
       (?$(1Z.(B . "0x8781") ;; <CJK>
       (?$(1Z/(B . "0x8796") ;; <CJK>
       (?$(1Z0(B . "0x8798") ;; <CJK>
       (?$(1Z1(B . "0x8779") ;; <CJK>
       (?$(1Z2(B . "0x8787") ;; <CJK>
       (?$(1Z3(B . "0x87A3") ;; <CJK>
       (?$(1Z4(B . "0x8785") ;; <CJK>
       (?$(1Z5(B . "0x8790") ;; <CJK>
       (?$(1Z6(B . "0x8791") ;; <CJK>
       (?$(1Z7(B . "0x879D") ;; <CJK>
       (?$(1Z8(B . "0x8784") ;; <CJK>
       (?$(1Z9(B . "0x8794") ;; <CJK>
       (?$(1Z:(B . "0x879C") ;; <CJK>
       (?$(1Z;(B . "0x879A") ;; <CJK>
       (?$(1Z<(B . "0x8789") ;; <CJK>
       (?$(1Z=(B . "0x891E") ;; <CJK>
       (?$(1Z>(B . "0x8926") ;; <CJK>
       (?$(1Z?(B . "0x8930") ;; <CJK>
       (?$(1Z@(B . "0x892D") ;; <CJK>
       (?$(1ZA(B . "0x892E") ;; <CJK>
       (?$(1ZB(B . "0x8927") ;; <CJK>
       (?$(1ZC(B . "0x8931") ;; <CJK>
       (?$(1ZD(B . "0x8922") ;; <CJK>
       (?$(1ZE(B . "0x8929") ;; <CJK>
       (?$(1ZF(B . "0x8923") ;; <CJK>
       (?$(1ZG(B . "0x892F") ;; <CJK>
       (?$(1ZH(B . "0x892C") ;; <CJK>
       (?$(1ZI(B . "0x891F") ;; <CJK>
       (?$(1ZJ(B . "0x89F1") ;; <CJK>
       (?$(1ZK(B . "0x8AE0") ;; <CJK>
       (?$(1ZL(B . "0x8AE2") ;; <CJK>
       (?$(1ZM(B . "0x8AF2") ;; <CJK>
       (?$(1ZN(B . "0x8AF4") ;; <CJK>
       (?$(1ZO(B . "0x8AF5") ;; <CJK>
       (?$(1ZP(B . "0x8ADD") ;; <CJK>
       (?$(1ZQ(B . "0x8B14") ;; <CJK>
       (?$(1ZR(B . "0x8AE4") ;; <CJK>
       (?$(1ZS(B . "0x8ADF") ;; <CJK>
       (?$(1ZT(B . "0x8AF0") ;; <CJK>
       (?$(1ZU(B . "0x8AC8") ;; <CJK>
       (?$(1ZV(B . "0x8ADE") ;; <CJK>
       (?$(1ZW(B . "0x8AE1") ;; <CJK>
       (?$(1ZX(B . "0x8AE8") ;; <CJK>
       (?$(1ZY(B . "0x8AFF") ;; <CJK>
       (?$(1ZZ(B . "0x8AEF") ;; <CJK>
       (?$(1Z[(B . "0x8AFB") ;; <CJK>
       (?$(1Z\(B . "0x8C91") ;; <CJK>
       (?$(1Z](B . "0x8C92") ;; <CJK>
       (?$(1Z^(B . "0x8C90") ;; <CJK>
       (?$(1Z_(B . "0x8CF5") ;; <CJK>
       (?$(1Z`(B . "0x8CEE") ;; <CJK>
       (?$(1Za(B . "0x8CF1") ;; <CJK>
       (?$(1Zb(B . "0x8CF0") ;; <CJK>
       (?$(1Zc(B . "0x8CF3") ;; <CJK>
       (?$(1Zd(B . "0x8D6C") ;; <CJK>
       (?$(1Ze(B . "0x8D6E") ;; <CJK>
       (?$(1Zf(B . "0x8DA5") ;; <CJK>
       (?$(1Zg(B . "0x8DA7") ;; <CJK>
       (?$(1Zh(B . "0x8E33") ;; <CJK>
       (?$(1Zi(B . "0x8E3E") ;; <CJK>
       (?$(1Zj(B . "0x8E38") ;; <CJK>
       (?$(1Zk(B . "0x8E40") ;; <CJK>
       (?$(1Zl(B . "0x8E45") ;; <CJK>
       (?$(1Zm(B . "0x8E36") ;; <CJK>
       (?$(1Zn(B . "0x8E3C") ;; <CJK>
       (?$(1Zo(B . "0x8E3D") ;; <CJK>
       (?$(1Zp(B . "0x8E41") ;; <CJK>
       (?$(1Zq(B . "0x8E30") ;; <CJK>
       (?$(1Zr(B . "0x8E3F") ;; <CJK>
       (?$(1Zs(B . "0x8EBD") ;; <CJK>
       (?$(1Zt(B . "0x8F36") ;; <CJK>
       (?$(1Zu(B . "0x8F2E") ;; <CJK>
       (?$(1Zv(B . "0x8F35") ;; <CJK>
       (?$(1Zw(B . "0x8F32") ;; <CJK>
       (?$(1Zx(B . "0x8F39") ;; <CJK>
       (?$(1Zy(B . "0x8F37") ;; <CJK>
       (?$(1Zz(B . "0x8F34") ;; <CJK>
       (?$(1Z{(B . "0x9076") ;; <CJK>
       (?$(1Z|(B . "0x9079") ;; <CJK>
       (?$(1Z}(B . "0x907B") ;; <CJK>
       (?$(1Z~(B . "0x9086") ;; <CJK>
       (?$(1[!(B . "0x90FA") ;; <CJK>
       (?$(1["(B . "0x9133") ;; <CJK>
       (?$(1[#(B . "0x9135") ;; <CJK>
       (?$(1[$(B . "0x9136") ;; <CJK>
       (?$(1[%(B . "0x9193") ;; <CJK>
       (?$(1[&(B . "0x9190") ;; <CJK>
       (?$(1['(B . "0x9191") ;; <CJK>
       (?$(1[((B . "0x918D") ;; <CJK>
       (?$(1[)(B . "0x918F") ;; <CJK>
       (?$(1[*(B . "0x9327") ;; <CJK>
       (?$(1[+(B . "0x931E") ;; <CJK>
       (?$(1[,(B . "0x9308") ;; <CJK>
       (?$(1[-(B . "0x931F") ;; <CJK>
       (?$(1[.(B . "0x9306") ;; <CJK>
       (?$(1[/(B . "0x930F") ;; <CJK>
       (?$(1[0(B . "0x937A") ;; <CJK>
       (?$(1[1(B . "0x9338") ;; <CJK>
       (?$(1[2(B . "0x933C") ;; <CJK>
       (?$(1[3(B . "0x931B") ;; <CJK>
       (?$(1[4(B . "0x9323") ;; <CJK>
       (?$(1[5(B . "0x9312") ;; <CJK>
       (?$(1[6(B . "0x9301") ;; <CJK>
       (?$(1[7(B . "0x9346") ;; <CJK>
       (?$(1[8(B . "0x932D") ;; <CJK>
       (?$(1[9(B . "0x930E") ;; <CJK>
       (?$(1[:(B . "0x930D") ;; <CJK>
       (?$(1[;(B . "0x92CB") ;; <CJK>
       (?$(1[<(B . "0x931D") ;; <CJK>
       (?$(1[=(B . "0x92FA") ;; <CJK>
       (?$(1[>(B . "0x9325") ;; <CJK>
       (?$(1[?(B . "0x9313") ;; <CJK>
       (?$(1[@(B . "0x92F9") ;; <CJK>
       (?$(1[A(B . "0x92F7") ;; <CJK>
       (?$(1[B(B . "0x9334") ;; <CJK>
       (?$(1[C(B . "0x9302") ;; <CJK>
       (?$(1[D(B . "0x9324") ;; <CJK>
       (?$(1[E(B . "0x92FF") ;; <CJK>
       (?$(1[F(B . "0x9329") ;; <CJK>
       (?$(1[G(B . "0x9339") ;; <CJK>
       (?$(1[H(B . "0x9335") ;; <CJK>
       (?$(1[I(B . "0x932A") ;; <CJK>
       (?$(1[J(B . "0x9314") ;; <CJK>
       (?$(1[K(B . "0x930C") ;; <CJK>
       (?$(1[L(B . "0x930B") ;; <CJK>
       (?$(1[M(B . "0x92FE") ;; <CJK>
       (?$(1[N(B . "0x9309") ;; <CJK>
       (?$(1[O(B . "0x9300") ;; <CJK>
       (?$(1[P(B . "0x92FB") ;; <CJK>
       (?$(1[Q(B . "0x9316") ;; <CJK>
       (?$(1[R(B . "0x95BC") ;; <CJK>
       (?$(1[S(B . "0x95CD") ;; <CJK>
       (?$(1[T(B . "0x95BE") ;; <CJK>
       (?$(1[U(B . "0x95B9") ;; <CJK>
       (?$(1[V(B . "0x95BA") ;; <CJK>
       (?$(1[W(B . "0x95B6") ;; <CJK>
       (?$(1[X(B . "0x95BF") ;; <CJK>
       (?$(1[Y(B . "0x95B5") ;; <CJK>
       (?$(1[Z(B . "0x95BD") ;; <CJK>
       (?$(1[[(B . "0x96A9") ;; <CJK>
       (?$(1[\(B . "0x96D4") ;; <CJK>
       (?$(1[](B . "0x970B") ;; <CJK>
       (?$(1[^(B . "0x9712") ;; <CJK>
       (?$(1[_(B . "0x9710") ;; <CJK>
       (?$(1[`(B . "0x9799") ;; <CJK>
       (?$(1[a(B . "0x9797") ;; <CJK>
       (?$(1[b(B . "0x9794") ;; <CJK>
       (?$(1[c(B . "0x97F0") ;; <CJK>
       (?$(1[d(B . "0x97F8") ;; <CJK>
       (?$(1[e(B . "0x9835") ;; <CJK>
       (?$(1[f(B . "0x982F") ;; <CJK>
       (?$(1[g(B . "0x9832") ;; <CJK>
       (?$(1[h(B . "0x9924") ;; <CJK>
       (?$(1[i(B . "0x991F") ;; <CJK>
       (?$(1[j(B . "0x9927") ;; <CJK>
       (?$(1[k(B . "0x9929") ;; <CJK>
       (?$(1[l(B . "0x999E") ;; <CJK>
       (?$(1[m(B . "0x99EE") ;; <CJK>
       (?$(1[n(B . "0x99EC") ;; <CJK>
       (?$(1[o(B . "0x99E5") ;; <CJK>
       (?$(1[p(B . "0x99E4") ;; <CJK>
       (?$(1[q(B . "0x99F0") ;; <CJK>
       (?$(1[r(B . "0x99E3") ;; <CJK>
       (?$(1[s(B . "0x99EA") ;; <CJK>
       (?$(1[t(B . "0x99E9") ;; <CJK>
       (?$(1[u(B . "0x99E7") ;; <CJK>
       (?$(1[v(B . "0x9AB9") ;; <CJK>
       (?$(1[w(B . "0x9ABF") ;; <CJK>
       (?$(1[x(B . "0x9AB4") ;; <CJK>
       (?$(1[y(B . "0x9ABB") ;; <CJK>
       (?$(1[z(B . "0x9AF6") ;; <CJK>
       (?$(1[{(B . "0x9AFA") ;; <CJK>
       (?$(1[|(B . "0x9AF9") ;; <CJK>
       (?$(1[}(B . "0x9AF7") ;; <CJK>
       (?$(1[~(B . "0x9B33") ;; <CJK>
       (?$(1\!(B . "0x9B80") ;; <CJK>
       (?$(1\"(B . "0x9B85") ;; <CJK>
       (?$(1\#(B . "0x9B87") ;; <CJK>
       (?$(1\$(B . "0x9B7C") ;; <CJK>
       (?$(1\%(B . "0x9B7E") ;; <CJK>
       (?$(1\&(B . "0x9B7B") ;; <CJK>
       (?$(1\'(B . "0x9B82") ;; <CJK>
       (?$(1\((B . "0x9B93") ;; <CJK>
       (?$(1\)(B . "0x9B92") ;; <CJK>
       (?$(1\*(B . "0x9B90") ;; <CJK>
       (?$(1\+(B . "0x9B7A") ;; <CJK>
       (?$(1\,(B . "0x9B95") ;; <CJK>
       (?$(1\-(B . "0x9B7D") ;; <CJK>
       (?$(1\.(B . "0x9B88") ;; <CJK>
       (?$(1\/(B . "0x9D25") ;; <CJK>
       (?$(1\0(B . "0x9D17") ;; <CJK>
       (?$(1\1(B . "0x9D20") ;; <CJK>
       (?$(1\2(B . "0x9D1E") ;; <CJK>
       (?$(1\3(B . "0x9D14") ;; <CJK>
       (?$(1\4(B . "0x9D29") ;; <CJK>
       (?$(1\5(B . "0x9D1D") ;; <CJK>
       (?$(1\6(B . "0x9D18") ;; <CJK>
       (?$(1\7(B . "0x9D22") ;; <CJK>
       (?$(1\8(B . "0x9D10") ;; <CJK>
       (?$(1\9(B . "0x9D19") ;; <CJK>
       (?$(1\:(B . "0x9D1F") ;; <CJK>
       (?$(1\;(B . "0x9E88") ;; <CJK>
       (?$(1\<(B . "0x9E86") ;; <CJK>
       (?$(1\=(B . "0x9E87") ;; <CJK>
       (?$(1\>(B . "0x9EAE") ;; <CJK>
       (?$(1\?(B . "0x9EAD") ;; <CJK>
       (?$(1\@(B . "0x9ED5") ;; <CJK>
       (?$(1\A(B . "0x9ED6") ;; <CJK>
       (?$(1\B(B . "0x9EFA") ;; <CJK>
       (?$(1\C(B . "0x9F12") ;; <CJK>
       (?$(1\D(B . "0x9F3D") ;; <CJK>
       (?$(1\E(B . "0x5126") ;; <CJK>
       (?$(1\F(B . "0x5125") ;; <CJK>
       (?$(1\G(B . "0x5122") ;; <CJK>
       (?$(1\H(B . "0x5124") ;; <CJK>
       (?$(1\I(B . "0x5120") ;; <CJK>
       (?$(1\J(B . "0x5129") ;; <CJK>
       (?$(1\K(B . "0x52F4") ;; <CJK>
       (?$(1\L(B . "0x5693") ;; <CJK>
       (?$(1\M(B . "0x568C") ;; <CJK>
       (?$(1\N(B . "0x568D") ;; <CJK>
       (?$(1\O(B . "0x5686") ;; <CJK>
       (?$(1\P(B . "0x5684") ;; <CJK>
       (?$(1\Q(B . "0x5683") ;; <CJK>
       (?$(1\R(B . "0x567E") ;; <CJK>
       (?$(1\S(B . "0x5682") ;; <CJK>
       (?$(1\T(B . "0x567F") ;; <CJK>
       (?$(1\U(B . "0x5681") ;; <CJK>
       (?$(1\V(B . "0x58D6") ;; <CJK>
       (?$(1\W(B . "0x58D4") ;; <CJK>
       (?$(1\X(B . "0x58CF") ;; <CJK>
       (?$(1\Y(B . "0x58D2") ;; <CJK>
       (?$(1\Z(B . "0x5B2D") ;; <CJK>
       (?$(1\[(B . "0x5B25") ;; <CJK>
       (?$(1\\(B . "0x5B32") ;; <CJK>
       (?$(1\](B . "0x5B23") ;; <CJK>
       (?$(1\^(B . "0x5B2C") ;; <CJK>
       (?$(1\_(B . "0x5B27") ;; <CJK>
       (?$(1\`(B . "0x5B26") ;; <CJK>
       (?$(1\a(B . "0x5B2F") ;; <CJK>
       (?$(1\b(B . "0x5B2E") ;; <CJK>
       (?$(1\c(B . "0x5B7B") ;; <CJK>
       (?$(1\d(B . "0x5BF1") ;; <CJK>
       (?$(1\e(B . "0x5BF2") ;; <CJK>
       (?$(1\f(B . "0x5DB7") ;; <CJK>
       (?$(1\g(B . "0x5E6C") ;; <CJK>
       (?$(1\h(B . "0x5E6A") ;; <CJK>
       (?$(1\i(B . "0x5FBE") ;; <CJK>
       (?$(1\j(B . "0x5FBB") ;; <CJK>
       (?$(1\k(B . "0x61C3") ;; <CJK>
       (?$(1\l(B . "0x61B5") ;; <CJK>
       (?$(1\m(B . "0x61BC") ;; <CJK>
       (?$(1\n(B . "0x61E7") ;; <CJK>
       (?$(1\o(B . "0x61E0") ;; <CJK>
       (?$(1\p(B . "0x61E5") ;; <CJK>
       (?$(1\q(B . "0x61E4") ;; <CJK>
       (?$(1\r(B . "0x61E8") ;; <CJK>
       (?$(1\s(B . "0x61DE") ;; <CJK>
       (?$(1\t(B . "0x64EF") ;; <CJK>
       (?$(1\u(B . "0x64E9") ;; <CJK>
       (?$(1\v(B . "0x64E3") ;; <CJK>
       (?$(1\w(B . "0x64EB") ;; <CJK>
       (?$(1\x(B . "0x64E4") ;; <CJK>
       (?$(1\y(B . "0x64E8") ;; <CJK>
       (?$(1\z(B . "0x6581") ;; <CJK>
       (?$(1\{(B . "0x6580") ;; <CJK>
       (?$(1\|(B . "0x65B6") ;; <CJK>
       (?$(1\}(B . "0x65DA") ;; <CJK>
       (?$(1\~(B . "0x66D2") ;; <CJK>
       (?$(1]!(B . "0x6A8D") ;; <CJK>
       (?$(1]"(B . "0x6A96") ;; <CJK>
       (?$(1]#(B . "0x6A81") ;; <CJK>
       (?$(1]$(B . "0x6AA5") ;; <CJK>
       (?$(1]%(B . "0x6A89") ;; <CJK>
       (?$(1]&(B . "0x6A9F") ;; <CJK>
       (?$(1]'(B . "0x6A9B") ;; <CJK>
       (?$(1]((B . "0x6AA1") ;; <CJK>
       (?$(1])(B . "0x6A9E") ;; <CJK>
       (?$(1]*(B . "0x6A87") ;; <CJK>
       (?$(1]+(B . "0x6A93") ;; <CJK>
       (?$(1],(B . "0x6A8E") ;; <CJK>
       (?$(1]-(B . "0x6A95") ;; <CJK>
       (?$(1].(B . "0x6A83") ;; <CJK>
       (?$(1]/(B . "0x6AA8") ;; <CJK>
       (?$(1]0(B . "0x6AA4") ;; <CJK>
       (?$(1]1(B . "0x6A91") ;; <CJK>
       (?$(1]2(B . "0x6A7F") ;; <CJK>
       (?$(1]3(B . "0x6AA6") ;; <CJK>
       (?$(1]4(B . "0x6A9A") ;; <CJK>
       (?$(1]5(B . "0x6A85") ;; <CJK>
       (?$(1]6(B . "0x6A8C") ;; <CJK>
       (?$(1]7(B . "0x6A92") ;; <CJK>
       (?$(1]8(B . "0x6B5B") ;; <CJK>
       (?$(1]9(B . "0x6BAD") ;; <CJK>
       (?$(1]:(B . "0x6C09") ;; <CJK>
       (?$(1];(B . "0x6FCC") ;; <CJK>
       (?$(1]<(B . "0x6FA9") ;; <CJK>
       (?$(1]=(B . "0x6FF4") ;; <CJK>
       (?$(1]>(B . "0x6FD4") ;; <CJK>
       (?$(1]?(B . "0x6FE3") ;; <CJK>
       (?$(1]@(B . "0x6FDC") ;; <CJK>
       (?$(1]A(B . "0x6FED") ;; <CJK>
       (?$(1]B(B . "0x6FE7") ;; <CJK>
       (?$(1]C(B . "0x6FE6") ;; <CJK>
       (?$(1]D(B . "0x6FDE") ;; <CJK>
       (?$(1]E(B . "0x6FF2") ;; <CJK>
       (?$(1]F(B . "0x6FDD") ;; <CJK>
       (?$(1]G(B . "0x6FE2") ;; <CJK>
       (?$(1]H(B . "0x6FE8") ;; <CJK>
       (?$(1]I(B . "0x71E1") ;; <CJK>
       (?$(1]J(B . "0x71F1") ;; <CJK>
       (?$(1]K(B . "0x71E8") ;; <CJK>
       (?$(1]L(B . "0x71F2") ;; <CJK>
       (?$(1]M(B . "0x71E4") ;; <CJK>
       (?$(1]N(B . "0x71F0") ;; <CJK>
       (?$(1]O(B . "0x71E2") ;; <CJK>
       (?$(1]P(B . "0x7373") ;; <CJK>
       (?$(1]Q(B . "0x736E") ;; <CJK>
       (?$(1]R(B . "0x736F") ;; <CJK>
       (?$(1]S(B . "0x7497") ;; <CJK>
       (?$(1]T(B . "0x74B2") ;; <CJK>
       (?$(1]U(B . "0x74AB") ;; <CJK>
       (?$(1]V(B . "0x7490") ;; <CJK>
       (?$(1]W(B . "0x74AA") ;; <CJK>
       (?$(1]X(B . "0x74AD") ;; <CJK>
       (?$(1]Y(B . "0x74B1") ;; <CJK>
       (?$(1]Z(B . "0x74A5") ;; <CJK>
       (?$(1][(B . "0x74AF") ;; <CJK>
       (?$(1]\(B . "0x7510") ;; <CJK>
       (?$(1]](B . "0x7511") ;; <CJK>
       (?$(1]^(B . "0x7512") ;; <CJK>
       (?$(1]_(B . "0x750F") ;; <CJK>
       (?$(1]`(B . "0x7584") ;; <CJK>
       (?$(1]a(B . "0x7643") ;; <CJK>
       (?$(1]b(B . "0x7648") ;; <CJK>
       (?$(1]c(B . "0x7649") ;; <CJK>
       (?$(1]d(B . "0x7647") ;; <CJK>
       (?$(1]e(B . "0x76A4") ;; <CJK>
       (?$(1]f(B . "0x76E9") ;; <CJK>
       (?$(1]g(B . "0x77B5") ;; <CJK>
       (?$(1]h(B . "0x77AB") ;; <CJK>
       (?$(1]i(B . "0x77B2") ;; <CJK>
       (?$(1]j(B . "0x77B7") ;; <CJK>
       (?$(1]k(B . "0x77B6") ;; <CJK>
       (?$(1]l(B . "0x77B4") ;; <CJK>
       (?$(1]m(B . "0x77B1") ;; <CJK>
       (?$(1]n(B . "0x77A8") ;; <CJK>
       (?$(1]o(B . "0x77F0") ;; <CJK>
       (?$(1]p(B . "0x78F3") ;; <CJK>
       (?$(1]q(B . "0x78FD") ;; <CJK>
       (?$(1]r(B . "0x7902") ;; <CJK>
       (?$(1]s(B . "0x78FB") ;; <CJK>
       (?$(1]t(B . "0x78FC") ;; <CJK>
       (?$(1]u(B . "0x78F2") ;; <CJK>
       (?$(1]v(B . "0x7905") ;; <CJK>
       (?$(1]w(B . "0x78F9") ;; <CJK>
       (?$(1]x(B . "0x78FE") ;; <CJK>
       (?$(1]y(B . "0x7904") ;; <CJK>
       (?$(1]z(B . "0x79AB") ;; <CJK>
       (?$(1]{(B . "0x79A8") ;; <CJK>
       (?$(1]|(B . "0x7A5C") ;; <CJK>
       (?$(1]}(B . "0x7A5B") ;; <CJK>
       (?$(1]~(B . "0x7A56") ;; <CJK>
       (?$(1^!(B . "0x7A58") ;; <CJK>
       (?$(1^"(B . "0x7A54") ;; <CJK>
       (?$(1^#(B . "0x7A5A") ;; <CJK>
       (?$(1^$(B . "0x7ABE") ;; <CJK>
       (?$(1^%(B . "0x7AC0") ;; <CJK>
       (?$(1^&(B . "0x7AC1") ;; <CJK>
       (?$(1^'(B . "0x7C05") ;; <CJK>
       (?$(1^((B . "0x7C0F") ;; <CJK>
       (?$(1^)(B . "0x7BF2") ;; <CJK>
       (?$(1^*(B . "0x7C00") ;; <CJK>
       (?$(1^+(B . "0x7BFF") ;; <CJK>
       (?$(1^,(B . "0x7BFB") ;; <CJK>
       (?$(1^-(B . "0x7C0E") ;; <CJK>
       (?$(1^.(B . "0x7BF4") ;; <CJK>
       (?$(1^/(B . "0x7C0B") ;; <CJK>
       (?$(1^0(B . "0x7BF3") ;; <CJK>
       (?$(1^1(B . "0x7C02") ;; <CJK>
       (?$(1^2(B . "0x7C09") ;; <CJK>
       (?$(1^3(B . "0x7C03") ;; <CJK>
       (?$(1^4(B . "0x7C01") ;; <CJK>
       (?$(1^5(B . "0x7BF8") ;; <CJK>
       (?$(1^6(B . "0x7BFD") ;; <CJK>
       (?$(1^7(B . "0x7C06") ;; <CJK>
       (?$(1^8(B . "0x7BF0") ;; <CJK>
       (?$(1^9(B . "0x7BF1") ;; <CJK>
       (?$(1^:(B . "0x7C10") ;; <CJK>
       (?$(1^;(B . "0x7C0A") ;; <CJK>
       (?$(1^<(B . "0x7CE8") ;; <CJK>
       (?$(1^=(B . "0x7E2D") ;; <CJK>
       (?$(1^>(B . "0x7E3C") ;; <CJK>
       (?$(1^?(B . "0x7E42") ;; <CJK>
       (?$(1^@(B . "0x7E33") ;; <CJK>
       (?$(1^A(B . "0x9848") ;; <CJK>
       (?$(1^B(B . "0x7E38") ;; <CJK>
       (?$(1^C(B . "0x7E2A") ;; <CJK>
       (?$(1^D(B . "0x7E49") ;; <CJK>
       (?$(1^E(B . "0x7E40") ;; <CJK>
       (?$(1^F(B . "0x7E47") ;; <CJK>
       (?$(1^G(B . "0x7E29") ;; <CJK>
       (?$(1^H(B . "0x7E4C") ;; <CJK>
       (?$(1^I(B . "0x7E30") ;; <CJK>
       (?$(1^J(B . "0x7E3B") ;; <CJK>
       (?$(1^K(B . "0x7E36") ;; <CJK>
       (?$(1^L(B . "0x7E44") ;; <CJK>
       (?$(1^M(B . "0x7E3A") ;; <CJK>
       (?$(1^N(B . "0x7F45") ;; <CJK>
       (?$(1^O(B . "0x7F7F") ;; <CJK>
       (?$(1^P(B . "0x7F7E") ;; <CJK>
       (?$(1^Q(B . "0x7F7D") ;; <CJK>
       (?$(1^R(B . "0x7FF4") ;; <CJK>
       (?$(1^S(B . "0x7FF2") ;; <CJK>
       (?$(1^T(B . "0x802C") ;; <CJK>
       (?$(1^U(B . "0x81BB") ;; <CJK>
       (?$(1^V(B . "0x81C4") ;; <CJK>
       (?$(1^W(B . "0x81CC") ;; <CJK>
       (?$(1^X(B . "0x81CA") ;; <CJK>
       (?$(1^Y(B . "0x81C5") ;; <CJK>
       (?$(1^Z(B . "0x81C7") ;; <CJK>
       (?$(1^[(B . "0x81BC") ;; <CJK>
       (?$(1^\(B . "0x81E9") ;; <CJK>
       (?$(1^](B . "0x825B") ;; <CJK>
       (?$(1^^(B . "0x825A") ;; <CJK>
       (?$(1^_(B . "0x825C") ;; <CJK>
       (?$(1^`(B . "0x8583") ;; <CJK>
       (?$(1^a(B . "0x8580") ;; <CJK>
       (?$(1^b(B . "0x858F") ;; <CJK>
       (?$(1^c(B . "0x85A7") ;; <CJK>
       (?$(1^d(B . "0x8595") ;; <CJK>
       (?$(1^e(B . "0x85A0") ;; <CJK>
       (?$(1^f(B . "0x858B") ;; <CJK>
       (?$(1^g(B . "0x85A3") ;; <CJK>
       (?$(1^h(B . "0x857B") ;; <CJK>
       (?$(1^i(B . "0x85A4") ;; <CJK>
       (?$(1^j(B . "0x859A") ;; <CJK>
       (?$(1^k(B . "0x859E") ;; <CJK>
       (?$(1^l(B . "0x8577") ;; <CJK>
       (?$(1^m(B . "0x857C") ;; <CJK>
       (?$(1^n(B . "0x8589") ;; <CJK>
       (?$(1^o(B . "0x85A1") ;; <CJK>
       (?$(1^p(B . "0x857A") ;; <CJK>
       (?$(1^q(B . "0x8578") ;; <CJK>
       (?$(1^r(B . "0x8557") ;; <CJK>
       (?$(1^s(B . "0x858E") ;; <CJK>
       (?$(1^t(B . "0x8596") ;; <CJK>
       (?$(1^u(B . "0x8586") ;; <CJK>
       (?$(1^v(B . "0x858D") ;; <CJK>
       (?$(1^w(B . "0x8599") ;; <CJK>
       (?$(1^x(B . "0x859D") ;; <CJK>
       (?$(1^y(B . "0x8581") ;; <CJK>
       (?$(1^z(B . "0x85A2") ;; <CJK>
       (?$(1^{(B . "0x8582") ;; <CJK>
       (?$(1^|(B . "0x8588") ;; <CJK>
       (?$(1^}(B . "0x8585") ;; <CJK>
       (?$(1^~(B . "0x8579") ;; <CJK>
       (?$(1_!(B . "0x8576") ;; <CJK>
       (?$(1_"(B . "0x8598") ;; <CJK>
       (?$(1_#(B . "0x8590") ;; <CJK>
       (?$(1_$(B . "0x859F") ;; <CJK>
       (?$(1_%(B . "0x8668") ;; <CJK>
       (?$(1_&(B . "0x87BE") ;; <CJK>
       (?$(1_'(B . "0x87AA") ;; <CJK>
       (?$(1_((B . "0x87AD") ;; <CJK>
       (?$(1_)(B . "0x87C5") ;; <CJK>
       (?$(1_*(B . "0x87B0") ;; <CJK>
       (?$(1_+(B . "0x87AC") ;; <CJK>
       (?$(1_,(B . "0x87B9") ;; <CJK>
       (?$(1_-(B . "0x87B5") ;; <CJK>
       (?$(1_.(B . "0x87BC") ;; <CJK>
       (?$(1_/(B . "0x87AE") ;; <CJK>
       (?$(1_0(B . "0x87C9") ;; <CJK>
       (?$(1_1(B . "0x87C3") ;; <CJK>
       (?$(1_2(B . "0x87C2") ;; <CJK>
       (?$(1_3(B . "0x87CC") ;; <CJK>
       (?$(1_4(B . "0x87B7") ;; <CJK>
       (?$(1_5(B . "0x87AF") ;; <CJK>
       (?$(1_6(B . "0x87C4") ;; <CJK>
       (?$(1_7(B . "0x87CA") ;; <CJK>
       (?$(1_8(B . "0x87B4") ;; <CJK>
       (?$(1_9(B . "0x87B6") ;; <CJK>
       (?$(1_:(B . "0x87BF") ;; <CJK>
       (?$(1_;(B . "0x87B8") ;; <CJK>
       (?$(1_<(B . "0x87BD") ;; <CJK>
       (?$(1_=(B . "0x87DE") ;; <CJK>
       (?$(1_>(B . "0x87B2") ;; <CJK>
       (?$(1_?(B . "0x8935") ;; <CJK>
       (?$(1_@(B . "0x8933") ;; <CJK>
       (?$(1_A(B . "0x893C") ;; <CJK>
       (?$(1_B(B . "0x893E") ;; <CJK>
       (?$(1_C(B . "0x8941") ;; <CJK>
       (?$(1_D(B . "0x8952") ;; <CJK>
       (?$(1_E(B . "0x8937") ;; <CJK>
       (?$(1_F(B . "0x8942") ;; <CJK>
       (?$(1_G(B . "0x89AD") ;; <CJK>
       (?$(1_H(B . "0x89AF") ;; <CJK>
       (?$(1_I(B . "0x89AE") ;; <CJK>
       (?$(1_J(B . "0x89F2") ;; <CJK>
       (?$(1_K(B . "0x89F3") ;; <CJK>
       (?$(1_L(B . "0x8B1E") ;; <CJK>
       (?$(1_M(B . "0x8B18") ;; <CJK>
       (?$(1_N(B . "0x8B16") ;; <CJK>
       (?$(1_O(B . "0x8B11") ;; <CJK>
       (?$(1_P(B . "0x8B05") ;; <CJK>
       (?$(1_Q(B . "0x8B0B") ;; <CJK>
       (?$(1_R(B . "0x8B22") ;; <CJK>
       (?$(1_S(B . "0x8B0F") ;; <CJK>
       (?$(1_T(B . "0x8B12") ;; <CJK>
       (?$(1_U(B . "0x8B15") ;; <CJK>
       (?$(1_V(B . "0x8B07") ;; <CJK>
       (?$(1_W(B . "0x8B0D") ;; <CJK>
       (?$(1_X(B . "0x8B08") ;; <CJK>
       (?$(1_Y(B . "0x8B06") ;; <CJK>
       (?$(1_Z(B . "0x8B1C") ;; <CJK>
       (?$(1_[(B . "0x8B13") ;; <CJK>
       (?$(1_\(B . "0x8B1A") ;; <CJK>
       (?$(1_](B . "0x8C4F") ;; <CJK>
       (?$(1_^(B . "0x8C70") ;; <CJK>
       (?$(1__(B . "0x8C72") ;; <CJK>
       (?$(1_`(B . "0x8C71") ;; <CJK>
       (?$(1_a(B . "0x8C6F") ;; <CJK>
       (?$(1_b(B . "0x8C95") ;; <CJK>
       (?$(1_c(B . "0x8C94") ;; <CJK>
       (?$(1_d(B . "0x8CF9") ;; <CJK>
       (?$(1_e(B . "0x8D6F") ;; <CJK>
       (?$(1_f(B . "0x8E4E") ;; <CJK>
       (?$(1_g(B . "0x8E4D") ;; <CJK>
       (?$(1_h(B . "0x8E53") ;; <CJK>
       (?$(1_i(B . "0x8E50") ;; <CJK>
       (?$(1_j(B . "0x8E4C") ;; <CJK>
       (?$(1_k(B . "0x8E47") ;; <CJK>
       (?$(1_l(B . "0x8F43") ;; <CJK>
       (?$(1_m(B . "0x8F40") ;; <CJK>
       (?$(1_n(B . "0x9085") ;; <CJK>
       (?$(1_o(B . "0x907E") ;; <CJK>
       (?$(1_p(B . "0x9138") ;; <CJK>
       (?$(1_q(B . "0x919A") ;; <CJK>
       (?$(1_r(B . "0x91A2") ;; <CJK>
       (?$(1_s(B . "0x919B") ;; <CJK>
       (?$(1_t(B . "0x9199") ;; <CJK>
       (?$(1_u(B . "0x919F") ;; <CJK>
       (?$(1_v(B . "0x91A1") ;; <CJK>
       (?$(1_w(B . "0x919D") ;; <CJK>
       (?$(1_x(B . "0x91A0") ;; <CJK>
       (?$(1_y(B . "0x93A1") ;; <CJK>
       (?$(1_z(B . "0x9383") ;; <CJK>
       (?$(1_{(B . "0x93AF") ;; <CJK>
       (?$(1_|(B . "0x9364") ;; <CJK>
       (?$(1_}(B . "0x9356") ;; <CJK>
       (?$(1_~(B . "0x9347") ;; <CJK>
       (?$(1`!(B . "0x937C") ;; <CJK>
       (?$(1`"(B . "0x9358") ;; <CJK>
       (?$(1`#(B . "0x935C") ;; <CJK>
       (?$(1`$(B . "0x9376") ;; <CJK>
       (?$(1`%(B . "0x9349") ;; <CJK>
       (?$(1`&(B . "0x9350") ;; <CJK>
       (?$(1`'(B . "0x9351") ;; <CJK>
       (?$(1`((B . "0x9360") ;; <CJK>
       (?$(1`)(B . "0x936D") ;; <CJK>
       (?$(1`*(B . "0x938F") ;; <CJK>
       (?$(1`+(B . "0x934C") ;; <CJK>
       (?$(1`,(B . "0x936A") ;; <CJK>
       (?$(1`-(B . "0x9379") ;; <CJK>
       (?$(1`.(B . "0x9357") ;; <CJK>
       (?$(1`/(B . "0x9355") ;; <CJK>
       (?$(1`0(B . "0x9352") ;; <CJK>
       (?$(1`1(B . "0x934F") ;; <CJK>
       (?$(1`2(B . "0x9371") ;; <CJK>
       (?$(1`3(B . "0x9377") ;; <CJK>
       (?$(1`4(B . "0x937B") ;; <CJK>
       (?$(1`5(B . "0x9361") ;; <CJK>
       (?$(1`6(B . "0x935E") ;; <CJK>
       (?$(1`7(B . "0x9363") ;; <CJK>
       (?$(1`8(B . "0x9367") ;; <CJK>
       (?$(1`9(B . "0x9380") ;; <CJK>
       (?$(1`:(B . "0x934E") ;; <CJK>
       (?$(1`;(B . "0x9359") ;; <CJK>
       (?$(1`<(B . "0x95C7") ;; <CJK>
       (?$(1`=(B . "0x95C0") ;; <CJK>
       (?$(1`>(B . "0x95C9") ;; <CJK>
       (?$(1`?(B . "0x95C3") ;; <CJK>
       (?$(1`@(B . "0x95C5") ;; <CJK>
       (?$(1`A(B . "0x95B7") ;; <CJK>
       (?$(1`B(B . "0x96AE") ;; <CJK>
       (?$(1`C(B . "0x96B0") ;; <CJK>
       (?$(1`D(B . "0x96AC") ;; <CJK>
       (?$(1`E(B . "0x9720") ;; <CJK>
       (?$(1`F(B . "0x971F") ;; <CJK>
       (?$(1`G(B . "0x9718") ;; <CJK>
       (?$(1`H(B . "0x971D") ;; <CJK>
       (?$(1`I(B . "0x9719") ;; <CJK>
       (?$(1`J(B . "0x979A") ;; <CJK>
       (?$(1`K(B . "0x97A1") ;; <CJK>
       (?$(1`L(B . "0x979C") ;; <CJK>
       (?$(1`M(B . "0x979E") ;; <CJK>
       (?$(1`N(B . "0x979D") ;; <CJK>
       (?$(1`O(B . "0x97D5") ;; <CJK>
       (?$(1`P(B . "0x97D4") ;; <CJK>
       (?$(1`Q(B . "0x97F1") ;; <CJK>
       (?$(1`R(B . "0x9841") ;; <CJK>
       (?$(1`S(B . "0x9844") ;; <CJK>
       (?$(1`T(B . "0x984A") ;; <CJK>
       (?$(1`U(B . "0x9849") ;; <CJK>
       (?$(1`V(B . "0x9845") ;; <CJK>
       (?$(1`W(B . "0x9843") ;; <CJK>
       (?$(1`X(B . "0x9925") ;; <CJK>
       (?$(1`Y(B . "0x992B") ;; <CJK>
       (?$(1`Z(B . "0x992C") ;; <CJK>
       (?$(1`[(B . "0x992A") ;; <CJK>
       (?$(1`\(B . "0x9933") ;; <CJK>
       (?$(1`](B . "0x9932") ;; <CJK>
       (?$(1`^(B . "0x992F") ;; <CJK>
       (?$(1`_(B . "0x992D") ;; <CJK>
       (?$(1``(B . "0x9931") ;; <CJK>
       (?$(1`a(B . "0x9930") ;; <CJK>
       (?$(1`b(B . "0x9998") ;; <CJK>
       (?$(1`c(B . "0x99A3") ;; <CJK>
       (?$(1`d(B . "0x99A1") ;; <CJK>
       (?$(1`e(B . "0x9A02") ;; <CJK>
       (?$(1`f(B . "0x99FA") ;; <CJK>
       (?$(1`g(B . "0x99F4") ;; <CJK>
       (?$(1`h(B . "0x99F7") ;; <CJK>
       (?$(1`i(B . "0x99F9") ;; <CJK>
       (?$(1`j(B . "0x99F8") ;; <CJK>
       (?$(1`k(B . "0x99F6") ;; <CJK>
       (?$(1`l(B . "0x99FB") ;; <CJK>
       (?$(1`m(B . "0x99FD") ;; <CJK>
       (?$(1`n(B . "0x99FE") ;; <CJK>
       (?$(1`o(B . "0x99FC") ;; <CJK>
       (?$(1`p(B . "0x9A03") ;; <CJK>
       (?$(1`q(B . "0x9ABE") ;; <CJK>
       (?$(1`r(B . "0x9AFE") ;; <CJK>
       (?$(1`s(B . "0x9AFD") ;; <CJK>
       (?$(1`t(B . "0x9B01") ;; <CJK>
       (?$(1`u(B . "0x9AFC") ;; <CJK>
       (?$(1`v(B . "0x9B48") ;; <CJK>
       (?$(1`w(B . "0x9B9A") ;; <CJK>
       (?$(1`x(B . "0x9BA8") ;; <CJK>
       (?$(1`y(B . "0x9B9E") ;; <CJK>
       (?$(1`z(B . "0x9B9B") ;; <CJK>
       (?$(1`{(B . "0x9BA6") ;; <CJK>
       (?$(1`|(B . "0x9BA1") ;; <CJK>
       (?$(1`}(B . "0x9BA5") ;; <CJK>
       (?$(1`~(B . "0x9BA4") ;; <CJK>
       (?$(1a!(B . "0x9B86") ;; <CJK>
       (?$(1a"(B . "0x9BA2") ;; <CJK>
       (?$(1a#(B . "0x9BA0") ;; <CJK>
       (?$(1a$(B . "0x9BAF") ;; <CJK>
       (?$(1a%(B . "0x9D33") ;; <CJK>
       (?$(1a&(B . "0x9D41") ;; <CJK>
       (?$(1a'(B . "0x9D67") ;; <CJK>
       (?$(1a((B . "0x9D36") ;; <CJK>
       (?$(1a)(B . "0x9D2E") ;; <CJK>
       (?$(1a*(B . "0x9D2F") ;; <CJK>
       (?$(1a+(B . "0x9D31") ;; <CJK>
       (?$(1a,(B . "0x9D38") ;; <CJK>
       (?$(1a-(B . "0x9D30") ;; <CJK>
       (?$(1a.(B . "0x9D45") ;; <CJK>
       (?$(1a/(B . "0x9D42") ;; <CJK>
       (?$(1a0(B . "0x9D43") ;; <CJK>
       (?$(1a1(B . "0x9D3E") ;; <CJK>
       (?$(1a2(B . "0x9D37") ;; <CJK>
       (?$(1a3(B . "0x9D40") ;; <CJK>
       (?$(1a4(B . "0x9D3D") ;; <CJK>
       (?$(1a5(B . "0x7FF5") ;; <CJK>
       (?$(1a6(B . "0x9D2D") ;; <CJK>
       (?$(1a7(B . "0x9E8A") ;; <CJK>
       (?$(1a8(B . "0x9E89") ;; <CJK>
       (?$(1a9(B . "0x9E8D") ;; <CJK>
       (?$(1a:(B . "0x9EB0") ;; <CJK>
       (?$(1a;(B . "0x9EC8") ;; <CJK>
       (?$(1a<(B . "0x9EDA") ;; <CJK>
       (?$(1a=(B . "0x9EFB") ;; <CJK>
       (?$(1a>(B . "0x9EFF") ;; <CJK>
       (?$(1a?(B . "0x9F24") ;; <CJK>
       (?$(1a@(B . "0x9F23") ;; <CJK>
       (?$(1aA(B . "0x9F22") ;; <CJK>
       (?$(1aB(B . "0x9F54") ;; <CJK>
       (?$(1aC(B . "0x9FA0") ;; <CJK>
       (?$(1aD(B . "0x5131") ;; <CJK>
       (?$(1aE(B . "0x512D") ;; <CJK>
       (?$(1aF(B . "0x512E") ;; <CJK>
       (?$(1aG(B . "0x5698") ;; <CJK>
       (?$(1aH(B . "0x569C") ;; <CJK>
       (?$(1aI(B . "0x5697") ;; <CJK>
       (?$(1aJ(B . "0x569A") ;; <CJK>
       (?$(1aK(B . "0x569D") ;; <CJK>
       (?$(1aL(B . "0x5699") ;; <CJK>
       (?$(1aM(B . "0x5970") ;; <CJK>
       (?$(1aN(B . "0x5B3C") ;; <CJK>
       (?$(1aO(B . "0x5C69") ;; <CJK>
       (?$(1aP(B . "0x5C6A") ;; <CJK>
       (?$(1aQ(B . "0x5DC0") ;; <CJK>
       (?$(1aR(B . "0x5E6D") ;; <CJK>
       (?$(1aS(B . "0x5E6E") ;; <CJK>
       (?$(1aT(B . "0x61D8") ;; <CJK>
       (?$(1aU(B . "0x61DF") ;; <CJK>
       (?$(1aV(B . "0x61ED") ;; <CJK>
       (?$(1aW(B . "0x61EE") ;; <CJK>
       (?$(1aX(B . "0x61F1") ;; <CJK>
       (?$(1aY(B . "0x61EA") ;; <CJK>
       (?$(1aZ(B . "0x61F0") ;; <CJK>
       (?$(1a[(B . "0x61EB") ;; <CJK>
       (?$(1a\(B . "0x61D6") ;; <CJK>
       (?$(1a](B . "0x61E9") ;; <CJK>
       (?$(1a^(B . "0x64FF") ;; <CJK>
       (?$(1a_(B . "0x6504") ;; <CJK>
       (?$(1a`(B . "0x64FD") ;; <CJK>
       (?$(1aa(B . "0x64F8") ;; <CJK>
       (?$(1ab(B . "0x6501") ;; <CJK>
       (?$(1ac(B . "0x6503") ;; <CJK>
       (?$(1ad(B . "0x64FC") ;; <CJK>
       (?$(1ae(B . "0x6594") ;; <CJK>
       (?$(1af(B . "0x65DB") ;; <CJK>
       (?$(1ag(B . "0x66DA") ;; <CJK>
       (?$(1ah(B . "0x66DB") ;; <CJK>
       (?$(1ai(B . "0x66D8") ;; <CJK>
       (?$(1aj(B . "0x6AC5") ;; <CJK>
       (?$(1ak(B . "0x6AB9") ;; <CJK>
       (?$(1al(B . "0x6ABD") ;; <CJK>
       (?$(1am(B . "0x6AE1") ;; <CJK>
       (?$(1an(B . "0x6AC6") ;; <CJK>
       (?$(1ao(B . "0x6ABA") ;; <CJK>
       (?$(1ap(B . "0x6AB6") ;; <CJK>
       (?$(1aq(B . "0x6AB7") ;; <CJK>
       (?$(1ar(B . "0x6AC7") ;; <CJK>
       (?$(1as(B . "0x6AB4") ;; <CJK>
       (?$(1at(B . "0x6AAD") ;; <CJK>
       (?$(1au(B . "0x6B5E") ;; <CJK>
       (?$(1av(B . "0x6BC9") ;; <CJK>
       (?$(1aw(B . "0x6C0B") ;; <CJK>
       (?$(1ax(B . "0x7007") ;; <CJK>
       (?$(1ay(B . "0x700C") ;; <CJK>
       (?$(1az(B . "0x700D") ;; <CJK>
       (?$(1a{(B . "0x7001") ;; <CJK>
       (?$(1a|(B . "0x7005") ;; <CJK>
       (?$(1a}(B . "0x7014") ;; <CJK>
       (?$(1a~(B . "0x700E") ;; <CJK>
       (?$(1b!(B . "0x6FFF") ;; <CJK>
       (?$(1b"(B . "0x7000") ;; <CJK>
       (?$(1b#(B . "0x6FFB") ;; <CJK>
       (?$(1b$(B . "0x7026") ;; <CJK>
       (?$(1b%(B . "0x6FFC") ;; <CJK>
       (?$(1b&(B . "0x6FF7") ;; <CJK>
       (?$(1b'(B . "0x700A") ;; <CJK>
       (?$(1b((B . "0x7201") ;; <CJK>
       (?$(1b)(B . "0x71FF") ;; <CJK>
       (?$(1b*(B . "0x71F9") ;; <CJK>
       (?$(1b+(B . "0x7203") ;; <CJK>
       (?$(1b,(B . "0x71FD") ;; <CJK>
       (?$(1b-(B . "0x7376") ;; <CJK>
       (?$(1b.(B . "0x74B8") ;; <CJK>
       (?$(1b/(B . "0x74C0") ;; <CJK>
       (?$(1b0(B . "0x74B5") ;; <CJK>
       (?$(1b1(B . "0x74C1") ;; <CJK>
       (?$(1b2(B . "0x74BE") ;; <CJK>
       (?$(1b3(B . "0x74B6") ;; <CJK>
       (?$(1b4(B . "0x74BB") ;; <CJK>
       (?$(1b5(B . "0x74C2") ;; <CJK>
       (?$(1b6(B . "0x7514") ;; <CJK>
       (?$(1b7(B . "0x7513") ;; <CJK>
       (?$(1b8(B . "0x765C") ;; <CJK>
       (?$(1b9(B . "0x7664") ;; <CJK>
       (?$(1b:(B . "0x7659") ;; <CJK>
       (?$(1b;(B . "0x7650") ;; <CJK>
       (?$(1b<(B . "0x7653") ;; <CJK>
       (?$(1b=(B . "0x7657") ;; <CJK>
       (?$(1b>(B . "0x765A") ;; <CJK>
       (?$(1b?(B . "0x76A6") ;; <CJK>
       (?$(1b@(B . "0x76BD") ;; <CJK>
       (?$(1bA(B . "0x76EC") ;; <CJK>
       (?$(1bB(B . "0x77C2") ;; <CJK>
       (?$(1bC(B . "0x77BA") ;; <CJK>
       (?$(1bD(B . "0x78FF") ;; <CJK>
       (?$(1bE(B . "0x790C") ;; <CJK>
       (?$(1bF(B . "0x7913") ;; <CJK>
       (?$(1bG(B . "0x7914") ;; <CJK>
       (?$(1bH(B . "0x7909") ;; <CJK>
       (?$(1bI(B . "0x7910") ;; <CJK>
       (?$(1bJ(B . "0x7912") ;; <CJK>
       (?$(1bK(B . "0x7911") ;; <CJK>
       (?$(1bL(B . "0x79AD") ;; <CJK>
       (?$(1bM(B . "0x79AC") ;; <CJK>
       (?$(1bN(B . "0x7A5F") ;; <CJK>
       (?$(1bO(B . "0x7C1C") ;; <CJK>
       (?$(1bP(B . "0x7C29") ;; <CJK>
       (?$(1bQ(B . "0x7C19") ;; <CJK>
       (?$(1bR(B . "0x7C20") ;; <CJK>
       (?$(1bS(B . "0x7C1F") ;; <CJK>
       (?$(1bT(B . "0x7C2D") ;; <CJK>
       (?$(1bU(B . "0x7C1D") ;; <CJK>
       (?$(1bV(B . "0x7C26") ;; <CJK>
       (?$(1bW(B . "0x7C28") ;; <CJK>
       (?$(1bX(B . "0x7C22") ;; <CJK>
       (?$(1bY(B . "0x7C25") ;; <CJK>
       (?$(1bZ(B . "0x7C30") ;; <CJK>
       (?$(1b[(B . "0x7E5C") ;; <CJK>
       (?$(1b\(B . "0x7E50") ;; <CJK>
       (?$(1b](B . "0x7E56") ;; <CJK>
       (?$(1b^(B . "0x7E63") ;; <CJK>
       (?$(1b_(B . "0x7E58") ;; <CJK>
       (?$(1b`(B . "0x7E62") ;; <CJK>
       (?$(1ba(B . "0x7E5F") ;; <CJK>
       (?$(1bb(B . "0x7E51") ;; <CJK>
       (?$(1bc(B . "0x7E60") ;; <CJK>
       (?$(1bd(B . "0x7E57") ;; <CJK>
       (?$(1be(B . "0x7E53") ;; <CJK>
       (?$(1bf(B . "0x7FB5") ;; <CJK>
       (?$(1bg(B . "0x7FB3") ;; <CJK>
       (?$(1bh(B . "0x7FF7") ;; <CJK>
       (?$(1bi(B . "0x7FF8") ;; <CJK>
       (?$(1bj(B . "0x8075") ;; <CJK>
       (?$(1bk(B . "0x81D1") ;; <CJK>
       (?$(1bl(B . "0x81D2") ;; <CJK>
       (?$(1bm(B . "0x81D0") ;; <CJK>
       (?$(1bn(B . "0x825F") ;; <CJK>
       (?$(1bo(B . "0x825E") ;; <CJK>
       (?$(1bp(B . "0x85B4") ;; <CJK>
       (?$(1bq(B . "0x85C6") ;; <CJK>
       (?$(1br(B . "0x85C0") ;; <CJK>
       (?$(1bs(B . "0x85C3") ;; <CJK>
       (?$(1bt(B . "0x85C2") ;; <CJK>
       (?$(1bu(B . "0x85B3") ;; <CJK>
       (?$(1bv(B . "0x85B5") ;; <CJK>
       (?$(1bw(B . "0x85BD") ;; <CJK>
       (?$(1bx(B . "0x85C7") ;; <CJK>
       (?$(1by(B . "0x85C4") ;; <CJK>
       (?$(1bz(B . "0x85BF") ;; <CJK>
       (?$(1b{(B . "0x85CB") ;; <CJK>
       (?$(1b|(B . "0x85CE") ;; <CJK>
       (?$(1b}(B . "0x85C8") ;; <CJK>
       (?$(1b~(B . "0x85C5") ;; <CJK>
       (?$(1c!(B . "0x85B1") ;; <CJK>
       (?$(1c"(B . "0x85B6") ;; <CJK>
       (?$(1c#(B . "0x85D2") ;; <CJK>
       (?$(1c$(B . "0x8624") ;; <CJK>
       (?$(1c%(B . "0x85B8") ;; <CJK>
       (?$(1c&(B . "0x85B7") ;; <CJK>
       (?$(1c'(B . "0x85BE") ;; <CJK>
       (?$(1c((B . "0x8669") ;; <CJK>
       (?$(1c)(B . "0x87E7") ;; <CJK>
       (?$(1c*(B . "0x87E6") ;; <CJK>
       (?$(1c+(B . "0x87E2") ;; <CJK>
       (?$(1c,(B . "0x87DB") ;; <CJK>
       (?$(1c-(B . "0x87EB") ;; <CJK>
       (?$(1c.(B . "0x87EA") ;; <CJK>
       (?$(1c/(B . "0x87E5") ;; <CJK>
       (?$(1c0(B . "0x87DF") ;; <CJK>
       (?$(1c1(B . "0x87F3") ;; <CJK>
       (?$(1c2(B . "0x87E4") ;; <CJK>
       (?$(1c3(B . "0x87D4") ;; <CJK>
       (?$(1c4(B . "0x87DC") ;; <CJK>
       (?$(1c5(B . "0x87D3") ;; <CJK>
       (?$(1c6(B . "0x87ED") ;; <CJK>
       (?$(1c7(B . "0x87D8") ;; <CJK>
       (?$(1c8(B . "0x87E3") ;; <CJK>
       (?$(1c9(B . "0x87A4") ;; <CJK>
       (?$(1c:(B . "0x87D7") ;; <CJK>
       (?$(1c;(B . "0x87D9") ;; <CJK>
       (?$(1c<(B . "0x8801") ;; <CJK>
       (?$(1c=(B . "0x87F4") ;; <CJK>
       (?$(1c>(B . "0x87E8") ;; <CJK>
       (?$(1c?(B . "0x87DD") ;; <CJK>
       (?$(1c@(B . "0x8953") ;; <CJK>
       (?$(1cA(B . "0x894B") ;; <CJK>
       (?$(1cB(B . "0x894F") ;; <CJK>
       (?$(1cC(B . "0x894C") ;; <CJK>
       (?$(1cD(B . "0x8946") ;; <CJK>
       (?$(1cE(B . "0x8950") ;; <CJK>
       (?$(1cF(B . "0x8951") ;; <CJK>
       (?$(1cG(B . "0x8949") ;; <CJK>
       (?$(1cH(B . "0x8B2A") ;; <CJK>
       (?$(1cI(B . "0x8B27") ;; <CJK>
       (?$(1cJ(B . "0x8B23") ;; <CJK>
       (?$(1cK(B . "0x8B33") ;; <CJK>
       (?$(1cL(B . "0x8B30") ;; <CJK>
       (?$(1cM(B . "0x8B35") ;; <CJK>
       (?$(1cN(B . "0x8B47") ;; <CJK>
       (?$(1cO(B . "0x8B2F") ;; <CJK>
       (?$(1cP(B . "0x8B3C") ;; <CJK>
       (?$(1cQ(B . "0x8B3E") ;; <CJK>
       (?$(1cR(B . "0x8B31") ;; <CJK>
       (?$(1cS(B . "0x8B25") ;; <CJK>
       (?$(1cT(B . "0x8B37") ;; <CJK>
       (?$(1cU(B . "0x8B26") ;; <CJK>
       (?$(1cV(B . "0x8B36") ;; <CJK>
       (?$(1cW(B . "0x8B2E") ;; <CJK>
       (?$(1cX(B . "0x8B24") ;; <CJK>
       (?$(1cY(B . "0x8B3B") ;; <CJK>
       (?$(1cZ(B . "0x8B3D") ;; <CJK>
       (?$(1c[(B . "0x8B3A") ;; <CJK>
       (?$(1c\(B . "0x8C42") ;; <CJK>
       (?$(1c](B . "0x8C75") ;; <CJK>
       (?$(1c^(B . "0x8C99") ;; <CJK>
       (?$(1c_(B . "0x8C98") ;; <CJK>
       (?$(1c`(B . "0x8C97") ;; <CJK>
       (?$(1ca(B . "0x8CFE") ;; <CJK>
       (?$(1cb(B . "0x8D04") ;; <CJK>
       (?$(1cc(B . "0x8D02") ;; <CJK>
       (?$(1cd(B . "0x8D00") ;; <CJK>
       (?$(1ce(B . "0x8E5C") ;; <CJK>
       (?$(1cf(B . "0x8E62") ;; <CJK>
       (?$(1cg(B . "0x8E60") ;; <CJK>
       (?$(1ch(B . "0x8E57") ;; <CJK>
       (?$(1ci(B . "0x8E56") ;; <CJK>
       (?$(1cj(B . "0x8E5E") ;; <CJK>
       (?$(1ck(B . "0x8E65") ;; <CJK>
       (?$(1cl(B . "0x8E67") ;; <CJK>
       (?$(1cm(B . "0x8E5B") ;; <CJK>
       (?$(1cn(B . "0x8E5A") ;; <CJK>
       (?$(1co(B . "0x8E61") ;; <CJK>
       (?$(1cp(B . "0x8E5D") ;; <CJK>
       (?$(1cq(B . "0x8E69") ;; <CJK>
       (?$(1cr(B . "0x8E54") ;; <CJK>
       (?$(1cs(B . "0x8F46") ;; <CJK>
       (?$(1ct(B . "0x8F47") ;; <CJK>
       (?$(1cu(B . "0x8F48") ;; <CJK>
       (?$(1cv(B . "0x8F4B") ;; <CJK>
       (?$(1cw(B . "0x9128") ;; <CJK>
       (?$(1cx(B . "0x913A") ;; <CJK>
       (?$(1cy(B . "0x913B") ;; <CJK>
       (?$(1cz(B . "0x913E") ;; <CJK>
       (?$(1c{(B . "0x91A8") ;; <CJK>
       (?$(1c|(B . "0x91A5") ;; <CJK>
       (?$(1c}(B . "0x91A7") ;; <CJK>
       (?$(1c~(B . "0x91AF") ;; <CJK>
       (?$(1d!(B . "0x91AA") ;; <CJK>
       (?$(1d"(B . "0x93B5") ;; <CJK>
       (?$(1d#(B . "0x938C") ;; <CJK>
       (?$(1d$(B . "0x9392") ;; <CJK>
       (?$(1d%(B . "0x93B7") ;; <CJK>
       (?$(1d&(B . "0x939B") ;; <CJK>
       (?$(1d'(B . "0x939D") ;; <CJK>
       (?$(1d((B . "0x9389") ;; <CJK>
       (?$(1d)(B . "0x93A7") ;; <CJK>
       (?$(1d*(B . "0x938E") ;; <CJK>
       (?$(1d+(B . "0x93AA") ;; <CJK>
       (?$(1d,(B . "0x939E") ;; <CJK>
       (?$(1d-(B . "0x93A6") ;; <CJK>
       (?$(1d.(B . "0x9395") ;; <CJK>
       (?$(1d/(B . "0x9388") ;; <CJK>
       (?$(1d0(B . "0x9399") ;; <CJK>
       (?$(1d1(B . "0x939F") ;; <CJK>
       (?$(1d2(B . "0x938D") ;; <CJK>
       (?$(1d3(B . "0x93B1") ;; <CJK>
       (?$(1d4(B . "0x9391") ;; <CJK>
       (?$(1d5(B . "0x93B2") ;; <CJK>
       (?$(1d6(B . "0x93A4") ;; <CJK>
       (?$(1d7(B . "0x93A8") ;; <CJK>
       (?$(1d8(B . "0x93B4") ;; <CJK>
       (?$(1d9(B . "0x93A3") ;; <CJK>
       (?$(1d:(B . "0x93A5") ;; <CJK>
       (?$(1d;(B . "0x95D2") ;; <CJK>
       (?$(1d<(B . "0x95D3") ;; <CJK>
       (?$(1d=(B . "0x95D1") ;; <CJK>
       (?$(1d>(B . "0x96B3") ;; <CJK>
       (?$(1d?(B . "0x96D7") ;; <CJK>
       (?$(1d@(B . "0x96DA") ;; <CJK>
       (?$(1dA(B . "0x5DC2") ;; <CJK>
       (?$(1dB(B . "0x96DF") ;; <CJK>
       (?$(1dC(B . "0x96D8") ;; <CJK>
       (?$(1dD(B . "0x96DD") ;; <CJK>
       (?$(1dE(B . "0x9723") ;; <CJK>
       (?$(1dF(B . "0x9722") ;; <CJK>
       (?$(1dG(B . "0x9725") ;; <CJK>
       (?$(1dH(B . "0x97AC") ;; <CJK>
       (?$(1dI(B . "0x97AE") ;; <CJK>
       (?$(1dJ(B . "0x97A8") ;; <CJK>
       (?$(1dK(B . "0x97AB") ;; <CJK>
       (?$(1dL(B . "0x97A4") ;; <CJK>
       (?$(1dM(B . "0x97AA") ;; <CJK>
       (?$(1dN(B . "0x97A2") ;; <CJK>
       (?$(1dO(B . "0x97A5") ;; <CJK>
       (?$(1dP(B . "0x97D7") ;; <CJK>
       (?$(1dQ(B . "0x97D9") ;; <CJK>
       (?$(1dR(B . "0x97D6") ;; <CJK>
       (?$(1dS(B . "0x97D8") ;; <CJK>
       (?$(1dT(B . "0x97FA") ;; <CJK>
       (?$(1dU(B . "0x9850") ;; <CJK>
       (?$(1dV(B . "0x9851") ;; <CJK>
       (?$(1dW(B . "0x9852") ;; <CJK>
       (?$(1dX(B . "0x98B8") ;; <CJK>
       (?$(1dY(B . "0x9941") ;; <CJK>
       (?$(1dZ(B . "0x993C") ;; <CJK>
       (?$(1d[(B . "0x993A") ;; <CJK>
       (?$(1d\(B . "0x9A0F") ;; <CJK>
       (?$(1d](B . "0x9A0B") ;; <CJK>
       (?$(1d^(B . "0x9A09") ;; <CJK>
       (?$(1d_(B . "0x9A0D") ;; <CJK>
       (?$(1d`(B . "0x9A04") ;; <CJK>
       (?$(1da(B . "0x9A11") ;; <CJK>
       (?$(1db(B . "0x9A0A") ;; <CJK>
       (?$(1dc(B . "0x9A05") ;; <CJK>
       (?$(1dd(B . "0x9A07") ;; <CJK>
       (?$(1de(B . "0x9A06") ;; <CJK>
       (?$(1df(B . "0x9AC0") ;; <CJK>
       (?$(1dg(B . "0x9ADC") ;; <CJK>
       (?$(1dh(B . "0x9B08") ;; <CJK>
       (?$(1di(B . "0x9B04") ;; <CJK>
       (?$(1dj(B . "0x9B05") ;; <CJK>
       (?$(1dk(B . "0x9B29") ;; <CJK>
       (?$(1dl(B . "0x9B35") ;; <CJK>
       (?$(1dm(B . "0x9B4A") ;; <CJK>
       (?$(1dn(B . "0x9B4C") ;; <CJK>
       (?$(1do(B . "0x9B4B") ;; <CJK>
       (?$(1dp(B . "0x9BC7") ;; <CJK>
       (?$(1dq(B . "0x9BC6") ;; <CJK>
       (?$(1dr(B . "0x9BC3") ;; <CJK>
       (?$(1ds(B . "0x9BBF") ;; <CJK>
       (?$(1dt(B . "0x9BC1") ;; <CJK>
       (?$(1du(B . "0x9BB5") ;; <CJK>
       (?$(1dv(B . "0x9BB8") ;; <CJK>
       (?$(1dw(B . "0x9BD3") ;; <CJK>
       (?$(1dx(B . "0x9BB6") ;; <CJK>
       (?$(1dy(B . "0x9BC4") ;; <CJK>
       (?$(1dz(B . "0x9BB9") ;; <CJK>
       (?$(1d{(B . "0x9BBD") ;; <CJK>
       (?$(1d|(B . "0x9D5C") ;; <CJK>
       (?$(1d}(B . "0x9D53") ;; <CJK>
       (?$(1d~(B . "0x9D4F") ;; <CJK>
       (?$(1e!(B . "0x9D4A") ;; <CJK>
       (?$(1e"(B . "0x9D5B") ;; <CJK>
       (?$(1e#(B . "0x9D4B") ;; <CJK>
       (?$(1e$(B . "0x9D59") ;; <CJK>
       (?$(1e%(B . "0x9D56") ;; <CJK>
       (?$(1e&(B . "0x9D4C") ;; <CJK>
       (?$(1e'(B . "0x9D57") ;; <CJK>
       (?$(1e((B . "0x9D52") ;; <CJK>
       (?$(1e)(B . "0x9D54") ;; <CJK>
       (?$(1e*(B . "0x9D5F") ;; <CJK>
       (?$(1e+(B . "0x9D58") ;; <CJK>
       (?$(1e,(B . "0x9D5A") ;; <CJK>
       (?$(1e-(B . "0x9E8E") ;; <CJK>
       (?$(1e.(B . "0x9E8C") ;; <CJK>
       (?$(1e/(B . "0x9EDF") ;; <CJK>
       (?$(1e0(B . "0x9F01") ;; <CJK>
       (?$(1e1(B . "0x9F00") ;; <CJK>
       (?$(1e2(B . "0x9F16") ;; <CJK>
       (?$(1e3(B . "0x9F25") ;; <CJK>
       (?$(1e4(B . "0x9F2B") ;; <CJK>
       (?$(1e5(B . "0x9F2A") ;; <CJK>
       (?$(1e6(B . "0x9F29") ;; <CJK>
       (?$(1e7(B . "0x9F28") ;; <CJK>
       (?$(1e8(B . "0x9F4C") ;; <CJK>
       (?$(1e9(B . "0x9F55") ;; <CJK>
       (?$(1e:(B . "0x5134") ;; <CJK>
       (?$(1e;(B . "0x5135") ;; <CJK>
       (?$(1e<(B . "0x5296") ;; <CJK>
       (?$(1e=(B . "0x52F7") ;; <CJK>
       (?$(1e>(B . "0x53B4") ;; <CJK>
       (?$(1e?(B . "0x56AB") ;; <CJK>
       (?$(1e@(B . "0x56AD") ;; <CJK>
       (?$(1eA(B . "0x56A6") ;; <CJK>
       (?$(1eB(B . "0x56A7") ;; <CJK>
       (?$(1eC(B . "0x56AA") ;; <CJK>
       (?$(1eD(B . "0x56AC") ;; <CJK>
       (?$(1eE(B . "0x58DA") ;; <CJK>
       (?$(1eF(B . "0x58DD") ;; <CJK>
       (?$(1eG(B . "0x58DB") ;; <CJK>
       (?$(1eH(B . "0x5912") ;; <CJK>
       (?$(1eI(B . "0x5B3D") ;; <CJK>
       (?$(1eJ(B . "0x5B3E") ;; <CJK>
       (?$(1eK(B . "0x5B3F") ;; <CJK>
       (?$(1eL(B . "0x5DC3") ;; <CJK>
       (?$(1eM(B . "0x5E70") ;; <CJK>
       (?$(1eN(B . "0x5FBF") ;; <CJK>
       (?$(1eO(B . "0x61FB") ;; <CJK>
       (?$(1eP(B . "0x6507") ;; <CJK>
       (?$(1eQ(B . "0x6510") ;; <CJK>
       (?$(1eR(B . "0x650D") ;; <CJK>
       (?$(1eS(B . "0x6509") ;; <CJK>
       (?$(1eT(B . "0x650C") ;; <CJK>
       (?$(1eU(B . "0x650E") ;; <CJK>
       (?$(1eV(B . "0x6584") ;; <CJK>
       (?$(1eW(B . "0x65DE") ;; <CJK>
       (?$(1eX(B . "0x65DD") ;; <CJK>
       (?$(1eY(B . "0x66DE") ;; <CJK>
       (?$(1eZ(B . "0x6AE7") ;; <CJK>
       (?$(1e[(B . "0x6AE0") ;; <CJK>
       (?$(1e\(B . "0x6ACC") ;; <CJK>
       (?$(1e](B . "0x6AD1") ;; <CJK>
       (?$(1e^(B . "0x6AD9") ;; <CJK>
       (?$(1e_(B . "0x6ACB") ;; <CJK>
       (?$(1e`(B . "0x6ADF") ;; <CJK>
       (?$(1ea(B . "0x6ADC") ;; <CJK>
       (?$(1eb(B . "0x6AD0") ;; <CJK>
       (?$(1ec(B . "0x6AEB") ;; <CJK>
       (?$(1ed(B . "0x6ACF") ;; <CJK>
       (?$(1ee(B . "0x6ACD") ;; <CJK>
       (?$(1ef(B . "0x6ADE") ;; <CJK>
       (?$(1eg(B . "0x6B60") ;; <CJK>
       (?$(1eh(B . "0x6BB0") ;; <CJK>
       (?$(1ei(B . "0x6C0C") ;; <CJK>
       (?$(1ej(B . "0x7019") ;; <CJK>
       (?$(1ek(B . "0x7027") ;; <CJK>
       (?$(1el(B . "0x7020") ;; <CJK>
       (?$(1em(B . "0x7016") ;; <CJK>
       (?$(1en(B . "0x702B") ;; <CJK>
       (?$(1eo(B . "0x7021") ;; <CJK>
       (?$(1ep(B . "0x7022") ;; <CJK>
       (?$(1eq(B . "0x7023") ;; <CJK>
       (?$(1er(B . "0x7029") ;; <CJK>
       (?$(1es(B . "0x7017") ;; <CJK>
       (?$(1et(B . "0x7024") ;; <CJK>
       (?$(1eu(B . "0x701C") ;; <CJK>
       (?$(1ev(B . "0x702A") ;; <CJK>
       (?$(1ew(B . "0x720C") ;; <CJK>
       (?$(1ex(B . "0x720A") ;; <CJK>
       (?$(1ey(B . "0x7207") ;; <CJK>
       (?$(1ez(B . "0x7202") ;; <CJK>
       (?$(1e{(B . "0x7205") ;; <CJK>
       (?$(1e|(B . "0x72A5") ;; <CJK>
       (?$(1e}(B . "0x72A6") ;; <CJK>
       (?$(1e~(B . "0x72A4") ;; <CJK>
       (?$(1f!(B . "0x72A3") ;; <CJK>
       (?$(1f"(B . "0x72A1") ;; <CJK>
       (?$(1f#(B . "0x74CB") ;; <CJK>
       (?$(1f$(B . "0x74C5") ;; <CJK>
       (?$(1f%(B . "0x74B7") ;; <CJK>
       (?$(1f&(B . "0x74C3") ;; <CJK>
       (?$(1f'(B . "0x7516") ;; <CJK>
       (?$(1f((B . "0x7660") ;; <CJK>
       (?$(1f)(B . "0x77C9") ;; <CJK>
       (?$(1f*(B . "0x77CA") ;; <CJK>
       (?$(1f+(B . "0x77C4") ;; <CJK>
       (?$(1f,(B . "0x77F1") ;; <CJK>
       (?$(1f-(B . "0x791D") ;; <CJK>
       (?$(1f.(B . "0x791B") ;; <CJK>
       (?$(1f/(B . "0x7921") ;; <CJK>
       (?$(1f0(B . "0x791C") ;; <CJK>
       (?$(1f1(B . "0x7917") ;; <CJK>
       (?$(1f2(B . "0x791E") ;; <CJK>
       (?$(1f3(B . "0x79B0") ;; <CJK>
       (?$(1f4(B . "0x7A67") ;; <CJK>
       (?$(1f5(B . "0x7A68") ;; <CJK>
       (?$(1f6(B . "0x7C33") ;; <CJK>
       (?$(1f7(B . "0x7C3C") ;; <CJK>
       (?$(1f8(B . "0x7C39") ;; <CJK>
       (?$(1f9(B . "0x7C2C") ;; <CJK>
       (?$(1f:(B . "0x7C3B") ;; <CJK>
       (?$(1f;(B . "0x7CEC") ;; <CJK>
       (?$(1f<(B . "0x7CEA") ;; <CJK>
       (?$(1f=(B . "0x7E76") ;; <CJK>
       (?$(1f>(B . "0x7E75") ;; <CJK>
       (?$(1f?(B . "0x7E78") ;; <CJK>
       (?$(1f@(B . "0x7E70") ;; <CJK>
       (?$(1fA(B . "0x7E77") ;; <CJK>
       (?$(1fB(B . "0x7E6F") ;; <CJK>
       (?$(1fC(B . "0x7E7A") ;; <CJK>
       (?$(1fD(B . "0x7E72") ;; <CJK>
       (?$(1fE(B . "0x7E74") ;; <CJK>
       (?$(1fF(B . "0x7E68") ;; <CJK>
       (?$(1fG(B . "0x7F4B") ;; <CJK>
       (?$(1fH(B . "0x7F4A") ;; <CJK>
       (?$(1fI(B . "0x7F83") ;; <CJK>
       (?$(1fJ(B . "0x7F86") ;; <CJK>
       (?$(1fK(B . "0x7FB7") ;; <CJK>
       (?$(1fL(B . "0x7FFD") ;; <CJK>
       (?$(1fM(B . "0x7FFE") ;; <CJK>
       (?$(1fN(B . "0x8078") ;; <CJK>
       (?$(1fO(B . "0x81D7") ;; <CJK>
       (?$(1fP(B . "0x81D5") ;; <CJK>
       (?$(1fQ(B . "0x8264") ;; <CJK>
       (?$(1fR(B . "0x8261") ;; <CJK>
       (?$(1fS(B . "0x8263") ;; <CJK>
       (?$(1fT(B . "0x85EB") ;; <CJK>
       (?$(1fU(B . "0x85F1") ;; <CJK>
       (?$(1fV(B . "0x85ED") ;; <CJK>
       (?$(1fW(B . "0x85D9") ;; <CJK>
       (?$(1fX(B . "0x85E1") ;; <CJK>
       (?$(1fY(B . "0x85E8") ;; <CJK>
       (?$(1fZ(B . "0x85DA") ;; <CJK>
       (?$(1f[(B . "0x85D7") ;; <CJK>
       (?$(1f\(B . "0x85EC") ;; <CJK>
       (?$(1f](B . "0x85F2") ;; <CJK>
       (?$(1f^(B . "0x85F8") ;; <CJK>
       (?$(1f_(B . "0x85D8") ;; <CJK>
       (?$(1f`(B . "0x85DF") ;; <CJK>
       (?$(1fa(B . "0x85E3") ;; <CJK>
       (?$(1fb(B . "0x85DC") ;; <CJK>
       (?$(1fc(B . "0x85D1") ;; <CJK>
       (?$(1fd(B . "0x85F0") ;; <CJK>
       (?$(1fe(B . "0x85E6") ;; <CJK>
       (?$(1ff(B . "0x85EF") ;; <CJK>
       (?$(1fg(B . "0x85DE") ;; <CJK>
       (?$(1fh(B . "0x85E2") ;; <CJK>
       (?$(1fi(B . "0x8800") ;; <CJK>
       (?$(1fj(B . "0x87FA") ;; <CJK>
       (?$(1fk(B . "0x8803") ;; <CJK>
       (?$(1fl(B . "0x87F6") ;; <CJK>
       (?$(1fm(B . "0x87F7") ;; <CJK>
       (?$(1fn(B . "0x8809") ;; <CJK>
       (?$(1fo(B . "0x880C") ;; <CJK>
       (?$(1fp(B . "0x880B") ;; <CJK>
       (?$(1fq(B . "0x8806") ;; <CJK>
       (?$(1fr(B . "0x87FC") ;; <CJK>
       (?$(1fs(B . "0x8808") ;; <CJK>
       (?$(1ft(B . "0x87FF") ;; <CJK>
       (?$(1fu(B . "0x880A") ;; <CJK>
       (?$(1fv(B . "0x8802") ;; <CJK>
       (?$(1fw(B . "0x8962") ;; <CJK>
       (?$(1fx(B . "0x895A") ;; <CJK>
       (?$(1fy(B . "0x895B") ;; <CJK>
       (?$(1fz(B . "0x8957") ;; <CJK>
       (?$(1f{(B . "0x8961") ;; <CJK>
       (?$(1f|(B . "0x895C") ;; <CJK>
       (?$(1f}(B . "0x8958") ;; <CJK>
       (?$(1f~(B . "0x895D") ;; <CJK>
       (?$(1g!(B . "0x8959") ;; <CJK>
       (?$(1g"(B . "0x8988") ;; <CJK>
       (?$(1g#(B . "0x89B7") ;; <CJK>
       (?$(1g$(B . "0x89B6") ;; <CJK>
       (?$(1g%(B . "0x89F6") ;; <CJK>
       (?$(1g&(B . "0x8B50") ;; <CJK>
       (?$(1g'(B . "0x8B48") ;; <CJK>
       (?$(1g((B . "0x8B4A") ;; <CJK>
       (?$(1g)(B . "0x8B40") ;; <CJK>
       (?$(1g*(B . "0x8B53") ;; <CJK>
       (?$(1g+(B . "0x8B56") ;; <CJK>
       (?$(1g,(B . "0x8B54") ;; <CJK>
       (?$(1g-(B . "0x8B4B") ;; <CJK>
       (?$(1g.(B . "0x8B55") ;; <CJK>
       (?$(1g/(B . "0x8B51") ;; <CJK>
       (?$(1g0(B . "0x8B42") ;; <CJK>
       (?$(1g1(B . "0x8B52") ;; <CJK>
       (?$(1g2(B . "0x8B57") ;; <CJK>
       (?$(1g3(B . "0x8C43") ;; <CJK>
       (?$(1g4(B . "0x8C77") ;; <CJK>
       (?$(1g5(B . "0x8C76") ;; <CJK>
       (?$(1g6(B . "0x8C9A") ;; <CJK>
       (?$(1g7(B . "0x8D06") ;; <CJK>
       (?$(1g8(B . "0x8D07") ;; <CJK>
       (?$(1g9(B . "0x8D09") ;; <CJK>
       (?$(1g:(B . "0x8DAC") ;; <CJK>
       (?$(1g;(B . "0x8DAA") ;; <CJK>
       (?$(1g<(B . "0x8DAD") ;; <CJK>
       (?$(1g=(B . "0x8DAB") ;; <CJK>
       (?$(1g>(B . "0x8E6D") ;; <CJK>
       (?$(1g?(B . "0x8E78") ;; <CJK>
       (?$(1g@(B . "0x8E73") ;; <CJK>
       (?$(1gA(B . "0x8E6A") ;; <CJK>
       (?$(1gB(B . "0x8E6F") ;; <CJK>
       (?$(1gC(B . "0x8E7B") ;; <CJK>
       (?$(1gD(B . "0x8EC2") ;; <CJK>
       (?$(1gE(B . "0x8F52") ;; <CJK>
       (?$(1gF(B . "0x8F51") ;; <CJK>
       (?$(1gG(B . "0x8F4F") ;; <CJK>
       (?$(1gH(B . "0x8F50") ;; <CJK>
       (?$(1gI(B . "0x8F53") ;; <CJK>
       (?$(1gJ(B . "0x8FB4") ;; <CJK>
       (?$(1gK(B . "0x9140") ;; <CJK>
       (?$(1gL(B . "0x913F") ;; <CJK>
       (?$(1gM(B . "0x91B0") ;; <CJK>
       (?$(1gN(B . "0x91AD") ;; <CJK>
       (?$(1gO(B . "0x93DE") ;; <CJK>
       (?$(1gP(B . "0x93C7") ;; <CJK>
       (?$(1gQ(B . "0x93CF") ;; <CJK>
       (?$(1gR(B . "0x93C2") ;; <CJK>
       (?$(1gS(B . "0x93DA") ;; <CJK>
       (?$(1gT(B . "0x93D0") ;; <CJK>
       (?$(1gU(B . "0x93F9") ;; <CJK>
       (?$(1gV(B . "0x93EC") ;; <CJK>
       (?$(1gW(B . "0x93CC") ;; <CJK>
       (?$(1gX(B . "0x93D9") ;; <CJK>
       (?$(1gY(B . "0x93A9") ;; <CJK>
       (?$(1gZ(B . "0x93E6") ;; <CJK>
       (?$(1g[(B . "0x93CA") ;; <CJK>
       (?$(1g\(B . "0x93D4") ;; <CJK>
       (?$(1g](B . "0x93EE") ;; <CJK>
       (?$(1g^(B . "0x93E3") ;; <CJK>
       (?$(1g_(B . "0x93D5") ;; <CJK>
       (?$(1g`(B . "0x93C4") ;; <CJK>
       (?$(1ga(B . "0x93CE") ;; <CJK>
       (?$(1gb(B . "0x93C0") ;; <CJK>
       (?$(1gc(B . "0x93D2") ;; <CJK>
       (?$(1gd(B . "0x93E7") ;; <CJK>
       (?$(1ge(B . "0x957D") ;; <CJK>
       (?$(1gf(B . "0x95DA") ;; <CJK>
       (?$(1gg(B . "0x95DB") ;; <CJK>
       (?$(1gh(B . "0x96E1") ;; <CJK>
       (?$(1gi(B . "0x9729") ;; <CJK>
       (?$(1gj(B . "0x972B") ;; <CJK>
       (?$(1gk(B . "0x972C") ;; <CJK>
       (?$(1gl(B . "0x9728") ;; <CJK>
       (?$(1gm(B . "0x9726") ;; <CJK>
       (?$(1gn(B . "0x97B3") ;; <CJK>
       (?$(1go(B . "0x97B7") ;; <CJK>
       (?$(1gp(B . "0x97B6") ;; <CJK>
       (?$(1gq(B . "0x97DD") ;; <CJK>
       (?$(1gr(B . "0x97DE") ;; <CJK>
       (?$(1gs(B . "0x97DF") ;; <CJK>
       (?$(1gt(B . "0x985C") ;; <CJK>
       (?$(1gu(B . "0x9859") ;; <CJK>
       (?$(1gv(B . "0x985D") ;; <CJK>
       (?$(1gw(B . "0x9857") ;; <CJK>
       (?$(1gx(B . "0x98BF") ;; <CJK>
       (?$(1gy(B . "0x98BD") ;; <CJK>
       (?$(1gz(B . "0x98BB") ;; <CJK>
       (?$(1g{(B . "0x98BE") ;; <CJK>
       (?$(1g|(B . "0x9948") ;; <CJK>
       (?$(1g}(B . "0x9947") ;; <CJK>
       (?$(1g~(B . "0x9943") ;; <CJK>
       (?$(1h!(B . "0x99A6") ;; <CJK>
       (?$(1h"(B . "0x99A7") ;; <CJK>
       (?$(1h#(B . "0x9A1A") ;; <CJK>
       (?$(1h$(B . "0x9A15") ;; <CJK>
       (?$(1h%(B . "0x9A25") ;; <CJK>
       (?$(1h&(B . "0x9A1D") ;; <CJK>
       (?$(1h'(B . "0x9A24") ;; <CJK>
       (?$(1h((B . "0x9A1B") ;; <CJK>
       (?$(1h)(B . "0x9A22") ;; <CJK>
       (?$(1h*(B . "0x9A20") ;; <CJK>
       (?$(1h+(B . "0x9A27") ;; <CJK>
       (?$(1h,(B . "0x9A23") ;; <CJK>
       (?$(1h-(B . "0x9A1E") ;; <CJK>
       (?$(1h.(B . "0x9A1C") ;; <CJK>
       (?$(1h/(B . "0x9A14") ;; <CJK>
       (?$(1h0(B . "0x9AC2") ;; <CJK>
       (?$(1h1(B . "0x9B0B") ;; <CJK>
       (?$(1h2(B . "0x9B0A") ;; <CJK>
       (?$(1h3(B . "0x9B0E") ;; <CJK>
       (?$(1h4(B . "0x9B0C") ;; <CJK>
       (?$(1h5(B . "0x9B37") ;; <CJK>
       (?$(1h6(B . "0x9BEA") ;; <CJK>
       (?$(1h7(B . "0x9BEB") ;; <CJK>
       (?$(1h8(B . "0x9BE0") ;; <CJK>
       (?$(1h9(B . "0x9BDE") ;; <CJK>
       (?$(1h:(B . "0x9BE4") ;; <CJK>
       (?$(1h;(B . "0x9BE6") ;; <CJK>
       (?$(1h<(B . "0x9BE2") ;; <CJK>
       (?$(1h=(B . "0x9BF0") ;; <CJK>
       (?$(1h>(B . "0x9BD4") ;; <CJK>
       (?$(1h?(B . "0x9BD7") ;; <CJK>
       (?$(1h@(B . "0x9BEC") ;; <CJK>
       (?$(1hA(B . "0x9BDC") ;; <CJK>
       (?$(1hB(B . "0x9BD9") ;; <CJK>
       (?$(1hC(B . "0x9BE5") ;; <CJK>
       (?$(1hD(B . "0x9BD5") ;; <CJK>
       (?$(1hE(B . "0x9BE1") ;; <CJK>
       (?$(1hF(B . "0x9BDA") ;; <CJK>
       (?$(1hG(B . "0x9D77") ;; <CJK>
       (?$(1hH(B . "0x9D81") ;; <CJK>
       (?$(1hI(B . "0x9D8A") ;; <CJK>
       (?$(1hJ(B . "0x9D84") ;; <CJK>
       (?$(1hK(B . "0x9D88") ;; <CJK>
       (?$(1hL(B . "0x9D71") ;; <CJK>
       (?$(1hM(B . "0x9D80") ;; <CJK>
       (?$(1hN(B . "0x9D78") ;; <CJK>
       (?$(1hO(B . "0x9D86") ;; <CJK>
       (?$(1hP(B . "0x9D8B") ;; <CJK>
       (?$(1hQ(B . "0x9D8C") ;; <CJK>
       (?$(1hR(B . "0x9D7D") ;; <CJK>
       (?$(1hS(B . "0x9D6B") ;; <CJK>
       (?$(1hT(B . "0x9D74") ;; <CJK>
       (?$(1hU(B . "0x9D75") ;; <CJK>
       (?$(1hV(B . "0x9D70") ;; <CJK>
       (?$(1hW(B . "0x9D69") ;; <CJK>
       (?$(1hX(B . "0x9D85") ;; <CJK>
       (?$(1hY(B . "0x9D73") ;; <CJK>
       (?$(1hZ(B . "0x9D7B") ;; <CJK>
       (?$(1h[(B . "0x9D82") ;; <CJK>
       (?$(1h\(B . "0x9D6F") ;; <CJK>
       (?$(1h](B . "0x9D79") ;; <CJK>
       (?$(1h^(B . "0x9D7F") ;; <CJK>
       (?$(1h_(B . "0x9D87") ;; <CJK>
       (?$(1h`(B . "0x9D68") ;; <CJK>
       (?$(1ha(B . "0x9E94") ;; <CJK>
       (?$(1hb(B . "0x9E91") ;; <CJK>
       (?$(1hc(B . "0x9EC0") ;; <CJK>
       (?$(1hd(B . "0x9EFC") ;; <CJK>
       (?$(1he(B . "0x9F2D") ;; <CJK>
       (?$(1hf(B . "0x9F40") ;; <CJK>
       (?$(1hg(B . "0x9F41") ;; <CJK>
       (?$(1hh(B . "0x9F4D") ;; <CJK>
       (?$(1hi(B . "0x9F56") ;; <CJK>
       (?$(1hj(B . "0x9F57") ;; <CJK>
       (?$(1hk(B . "0x9F58") ;; <CJK>
       (?$(1hl(B . "0x5337") ;; <CJK>
       (?$(1hm(B . "0x56B2") ;; <CJK>
       (?$(1hn(B . "0x56B5") ;; <CJK>
       (?$(1ho(B . "0x56B3") ;; <CJK>
       (?$(1hp(B . "0x58E3") ;; <CJK>
       (?$(1hq(B . "0x5B45") ;; <CJK>
       (?$(1hr(B . "0x5DC6") ;; <CJK>
       (?$(1hs(B . "0x5DC7") ;; <CJK>
       (?$(1ht(B . "0x5EEE") ;; <CJK>
       (?$(1hu(B . "0x5EEF") ;; <CJK>
       (?$(1hv(B . "0x5FC0") ;; <CJK>
       (?$(1hw(B . "0x5FC1") ;; <CJK>
       (?$(1hx(B . "0x61F9") ;; <CJK>
       (?$(1hy(B . "0x6517") ;; <CJK>
       (?$(1hz(B . "0x6516") ;; <CJK>
       (?$(1h{(B . "0x6515") ;; <CJK>
       (?$(1h|(B . "0x6513") ;; <CJK>
       (?$(1h}(B . "0x65DF") ;; <CJK>
       (?$(1h~(B . "0x66E8") ;; <CJK>
       (?$(1i!(B . "0x66E3") ;; <CJK>
       (?$(1i"(B . "0x66E4") ;; <CJK>
       (?$(1i#(B . "0x6AF3") ;; <CJK>
       (?$(1i$(B . "0x6AF0") ;; <CJK>
       (?$(1i%(B . "0x6AEA") ;; <CJK>
       (?$(1i&(B . "0x6AE8") ;; <CJK>
       (?$(1i'(B . "0x6AF9") ;; <CJK>
       (?$(1i((B . "0x6AF1") ;; <CJK>
       (?$(1i)(B . "0x6AEE") ;; <CJK>
       (?$(1i*(B . "0x6AEF") ;; <CJK>
       (?$(1i+(B . "0x703C") ;; <CJK>
       (?$(1i,(B . "0x7035") ;; <CJK>
       (?$(1i-(B . "0x702F") ;; <CJK>
       (?$(1i.(B . "0x7037") ;; <CJK>
       (?$(1i/(B . "0x7034") ;; <CJK>
       (?$(1i0(B . "0x7031") ;; <CJK>
       (?$(1i1(B . "0x7042") ;; <CJK>
       (?$(1i2(B . "0x7038") ;; <CJK>
       (?$(1i3(B . "0x703F") ;; <CJK>
       (?$(1i4(B . "0x703A") ;; <CJK>
       (?$(1i5(B . "0x7039") ;; <CJK>
       (?$(1i6(B . "0x7040") ;; <CJK>
       (?$(1i7(B . "0x703B") ;; <CJK>
       (?$(1i8(B . "0x7033") ;; <CJK>
       (?$(1i9(B . "0x7041") ;; <CJK>
       (?$(1i:(B . "0x7213") ;; <CJK>
       (?$(1i;(B . "0x7214") ;; <CJK>
       (?$(1i<(B . "0x72A8") ;; <CJK>
       (?$(1i=(B . "0x737D") ;; <CJK>
       (?$(1i>(B . "0x737C") ;; <CJK>
       (?$(1i?(B . "0x74BA") ;; <CJK>
       (?$(1i@(B . "0x76AB") ;; <CJK>
       (?$(1iA(B . "0x76AA") ;; <CJK>
       (?$(1iB(B . "0x76BE") ;; <CJK>
       (?$(1iC(B . "0x76ED") ;; <CJK>
       (?$(1iD(B . "0x77CC") ;; <CJK>
       (?$(1iE(B . "0x77CE") ;; <CJK>
       (?$(1iF(B . "0x77CF") ;; <CJK>
       (?$(1iG(B . "0x77CD") ;; <CJK>
       (?$(1iH(B . "0x77F2") ;; <CJK>
       (?$(1iI(B . "0x7925") ;; <CJK>
       (?$(1iJ(B . "0x7923") ;; <CJK>
       (?$(1iK(B . "0x7927") ;; <CJK>
       (?$(1iL(B . "0x7928") ;; <CJK>
       (?$(1iM(B . "0x7924") ;; <CJK>
       (?$(1iN(B . "0x7929") ;; <CJK>
       (?$(1iO(B . "0x79B2") ;; <CJK>
       (?$(1iP(B . "0x7A6E") ;; <CJK>
       (?$(1iQ(B . "0x7A6C") ;; <CJK>
       (?$(1iR(B . "0x7A6D") ;; <CJK>
       (?$(1iS(B . "0x7AF7") ;; <CJK>
       (?$(1iT(B . "0x7C49") ;; <CJK>
       (?$(1iU(B . "0x7C48") ;; <CJK>
       (?$(1iV(B . "0x7C4A") ;; <CJK>
       (?$(1iW(B . "0x7C47") ;; <CJK>
       (?$(1iX(B . "0x7C45") ;; <CJK>
       (?$(1iY(B . "0x7CEE") ;; <CJK>
       (?$(1iZ(B . "0x7E7B") ;; <CJK>
       (?$(1i[(B . "0x7E7E") ;; <CJK>
       (?$(1i\(B . "0x7E81") ;; <CJK>
       (?$(1i](B . "0x7E80") ;; <CJK>
       (?$(1i^(B . "0x7FBA") ;; <CJK>
       (?$(1i_(B . "0x7FFF") ;; <CJK>
       (?$(1i`(B . "0x8079") ;; <CJK>
       (?$(1ia(B . "0x81DB") ;; <CJK>
       (?$(1ib(B . "0x81D9") ;; <CJK>
       (?$(1ic(B . "0x820B") ;; <CJK>
       (?$(1id(B . "0x8268") ;; <CJK>
       (?$(1ie(B . "0x8269") ;; <CJK>
       (?$(1if(B . "0x8622") ;; <CJK>
       (?$(1ig(B . "0x85FF") ;; <CJK>
       (?$(1ih(B . "0x8601") ;; <CJK>
       (?$(1ii(B . "0x85FE") ;; <CJK>
       (?$(1ij(B . "0x861B") ;; <CJK>
       (?$(1ik(B . "0x8600") ;; <CJK>
       (?$(1il(B . "0x85F6") ;; <CJK>
       (?$(1im(B . "0x8604") ;; <CJK>
       (?$(1in(B . "0x8609") ;; <CJK>
       (?$(1io(B . "0x8605") ;; <CJK>
       (?$(1ip(B . "0x860C") ;; <CJK>
       (?$(1iq(B . "0x85FD") ;; <CJK>
       (?$(1ir(B . "0x8819") ;; <CJK>
       (?$(1is(B . "0x8810") ;; <CJK>
       (?$(1it(B . "0x8811") ;; <CJK>
       (?$(1iu(B . "0x8817") ;; <CJK>
       (?$(1iv(B . "0x8813") ;; <CJK>
       (?$(1iw(B . "0x8816") ;; <CJK>
       (?$(1ix(B . "0x8963") ;; <CJK>
       (?$(1iy(B . "0x8966") ;; <CJK>
       (?$(1iz(B . "0x89B9") ;; <CJK>
       (?$(1i{(B . "0x89F7") ;; <CJK>
       (?$(1i|(B . "0x8B60") ;; <CJK>
       (?$(1i}(B . "0x8B6A") ;; <CJK>
       (?$(1i~(B . "0x8B5D") ;; <CJK>
       (?$(1j!(B . "0x8B68") ;; <CJK>
       (?$(1j"(B . "0x8B63") ;; <CJK>
       (?$(1j#(B . "0x8B65") ;; <CJK>
       (?$(1j$(B . "0x8B67") ;; <CJK>
       (?$(1j%(B . "0x8B6D") ;; <CJK>
       (?$(1j&(B . "0x8DAE") ;; <CJK>
       (?$(1j'(B . "0x8E86") ;; <CJK>
       (?$(1j((B . "0x8E88") ;; <CJK>
       (?$(1j)(B . "0x8E84") ;; <CJK>
       (?$(1j*(B . "0x8F59") ;; <CJK>
       (?$(1j+(B . "0x8F56") ;; <CJK>
       (?$(1j,(B . "0x8F57") ;; <CJK>
       (?$(1j-(B . "0x8F55") ;; <CJK>
       (?$(1j.(B . "0x8F58") ;; <CJK>
       (?$(1j/(B . "0x8F5A") ;; <CJK>
       (?$(1j0(B . "0x908D") ;; <CJK>
       (?$(1j1(B . "0x9143") ;; <CJK>
       (?$(1j2(B . "0x9141") ;; <CJK>
       (?$(1j3(B . "0x91B7") ;; <CJK>
       (?$(1j4(B . "0x91B5") ;; <CJK>
       (?$(1j5(B . "0x91B2") ;; <CJK>
       (?$(1j6(B . "0x91B3") ;; <CJK>
       (?$(1j7(B . "0x940B") ;; <CJK>
       (?$(1j8(B . "0x9413") ;; <CJK>
       (?$(1j9(B . "0x93FB") ;; <CJK>
       (?$(1j:(B . "0x9420") ;; <CJK>
       (?$(1j;(B . "0x940F") ;; <CJK>
       (?$(1j<(B . "0x9414") ;; <CJK>
       (?$(1j=(B . "0x93FE") ;; <CJK>
       (?$(1j>(B . "0x9415") ;; <CJK>
       (?$(1j?(B . "0x9410") ;; <CJK>
       (?$(1j@(B . "0x9428") ;; <CJK>
       (?$(1jA(B . "0x9419") ;; <CJK>
       (?$(1jB(B . "0x940D") ;; <CJK>
       (?$(1jC(B . "0x93F5") ;; <CJK>
       (?$(1jD(B . "0x9400") ;; <CJK>
       (?$(1jE(B . "0x93F7") ;; <CJK>
       (?$(1jF(B . "0x9407") ;; <CJK>
       (?$(1jG(B . "0x940E") ;; <CJK>
       (?$(1jH(B . "0x9416") ;; <CJK>
       (?$(1jI(B . "0x9412") ;; <CJK>
       (?$(1jJ(B . "0x93FA") ;; <CJK>
       (?$(1jK(B . "0x9409") ;; <CJK>
       (?$(1jL(B . "0x93F8") ;; <CJK>
       (?$(1jM(B . "0x940A") ;; <CJK>
       (?$(1jN(B . "0x93FF") ;; <CJK>
       (?$(1jO(B . "0x93FC") ;; <CJK>
       (?$(1jP(B . "0x940C") ;; <CJK>
       (?$(1jQ(B . "0x93F6") ;; <CJK>
       (?$(1jR(B . "0x9411") ;; <CJK>
       (?$(1jS(B . "0x9406") ;; <CJK>
       (?$(1jT(B . "0x95DE") ;; <CJK>
       (?$(1jU(B . "0x95E0") ;; <CJK>
       (?$(1jV(B . "0x95DF") ;; <CJK>
       (?$(1jW(B . "0x972E") ;; <CJK>
       (?$(1jX(B . "0x972F") ;; <CJK>
       (?$(1jY(B . "0x97B9") ;; <CJK>
       (?$(1jZ(B . "0x97BB") ;; <CJK>
       (?$(1j[(B . "0x97FD") ;; <CJK>
       (?$(1j\(B . "0x97FE") ;; <CJK>
       (?$(1j](B . "0x9860") ;; <CJK>
       (?$(1j^(B . "0x9862") ;; <CJK>
       (?$(1j_(B . "0x9863") ;; <CJK>
       (?$(1j`(B . "0x985F") ;; <CJK>
       (?$(1ja(B . "0x98C1") ;; <CJK>
       (?$(1jb(B . "0x98C2") ;; <CJK>
       (?$(1jc(B . "0x9950") ;; <CJK>
       (?$(1jd(B . "0x994E") ;; <CJK>
       (?$(1je(B . "0x9959") ;; <CJK>
       (?$(1jf(B . "0x994C") ;; <CJK>
       (?$(1jg(B . "0x994B") ;; <CJK>
       (?$(1jh(B . "0x9953") ;; <CJK>
       (?$(1ji(B . "0x9A32") ;; <CJK>
       (?$(1jj(B . "0x9A34") ;; <CJK>
       (?$(1jk(B . "0x9A31") ;; <CJK>
       (?$(1jl(B . "0x9A2C") ;; <CJK>
       (?$(1jm(B . "0x9A2A") ;; <CJK>
       (?$(1jn(B . "0x9A36") ;; <CJK>
       (?$(1jo(B . "0x9A29") ;; <CJK>
       (?$(1jp(B . "0x9A2E") ;; <CJK>
       (?$(1jq(B . "0x9A38") ;; <CJK>
       (?$(1jr(B . "0x9A2D") ;; <CJK>
       (?$(1js(B . "0x9AC7") ;; <CJK>
       (?$(1jt(B . "0x9ACA") ;; <CJK>
       (?$(1ju(B . "0x9AC6") ;; <CJK>
       (?$(1jv(B . "0x9B10") ;; <CJK>
       (?$(1jw(B . "0x9B12") ;; <CJK>
       (?$(1jx(B . "0x9B11") ;; <CJK>
       (?$(1jy(B . "0x9C0B") ;; <CJK>
       (?$(1jz(B . "0x9C08") ;; <CJK>
       (?$(1j{(B . "0x9BF7") ;; <CJK>
       (?$(1j|(B . "0x9C05") ;; <CJK>
       (?$(1j}(B . "0x9C12") ;; <CJK>
       (?$(1j~(B . "0x9BF8") ;; <CJK>
       (?$(1k!(B . "0x9C40") ;; <CJK>
       (?$(1k"(B . "0x9C07") ;; <CJK>
       (?$(1k#(B . "0x9C0E") ;; <CJK>
       (?$(1k$(B . "0x9C06") ;; <CJK>
       (?$(1k%(B . "0x9C17") ;; <CJK>
       (?$(1k&(B . "0x9C14") ;; <CJK>
       (?$(1k'(B . "0x9C09") ;; <CJK>
       (?$(1k((B . "0x9D9F") ;; <CJK>
       (?$(1k)(B . "0x9D99") ;; <CJK>
       (?$(1k*(B . "0x9DA4") ;; <CJK>
       (?$(1k+(B . "0x9D9D") ;; <CJK>
       (?$(1k,(B . "0x9D92") ;; <CJK>
       (?$(1k-(B . "0x9D98") ;; <CJK>
       (?$(1k.(B . "0x9D90") ;; <CJK>
       (?$(1k/(B . "0x9D9B") ;; <CJK>
       (?$(1k0(B . "0x9DA0") ;; <CJK>
       (?$(1k1(B . "0x9D94") ;; <CJK>
       (?$(1k2(B . "0x9D9C") ;; <CJK>
       (?$(1k3(B . "0x9DAA") ;; <CJK>
       (?$(1k4(B . "0x9D97") ;; <CJK>
       (?$(1k5(B . "0x9DA1") ;; <CJK>
       (?$(1k6(B . "0x9D9A") ;; <CJK>
       (?$(1k7(B . "0x9DA2") ;; <CJK>
       (?$(1k8(B . "0x9DA8") ;; <CJK>
       (?$(1k9(B . "0x9D9E") ;; <CJK>
       (?$(1k:(B . "0x9DA3") ;; <CJK>
       (?$(1k;(B . "0x9DBF") ;; <CJK>
       (?$(1k<(B . "0x9DA9") ;; <CJK>
       (?$(1k=(B . "0x9D96") ;; <CJK>
       (?$(1k>(B . "0x9DA6") ;; <CJK>
       (?$(1k?(B . "0x9DA7") ;; <CJK>
       (?$(1k@(B . "0x9E99") ;; <CJK>
       (?$(1kA(B . "0x9E9B") ;; <CJK>
       (?$(1kB(B . "0x9E9A") ;; <CJK>
       (?$(1kC(B . "0x9EE5") ;; <CJK>
       (?$(1kD(B . "0x9EE4") ;; <CJK>
       (?$(1kE(B . "0x9EE7") ;; <CJK>
       (?$(1kF(B . "0x9EE6") ;; <CJK>
       (?$(1kG(B . "0x9F30") ;; <CJK>
       (?$(1kH(B . "0x9F2E") ;; <CJK>
       (?$(1kI(B . "0x9F5B") ;; <CJK>
       (?$(1kJ(B . "0x9F60") ;; <CJK>
       (?$(1kK(B . "0x9F5E") ;; <CJK>
       (?$(1kL(B . "0x9F5D") ;; <CJK>
       (?$(1kM(B . "0x9F59") ;; <CJK>
       (?$(1kN(B . "0x9F91") ;; <CJK>
       (?$(1kO(B . "0x513A") ;; <CJK>
       (?$(1kP(B . "0x5139") ;; <CJK>
       (?$(1kQ(B . "0x5298") ;; <CJK>
       (?$(1kR(B . "0x5297") ;; <CJK>
       (?$(1kS(B . "0x56C3") ;; <CJK>
       (?$(1kT(B . "0x56BD") ;; <CJK>
       (?$(1kU(B . "0x56BE") ;; <CJK>
       (?$(1kV(B . "0x5B48") ;; <CJK>
       (?$(1kW(B . "0x5B47") ;; <CJK>
       (?$(1kX(B . "0x5DCB") ;; <CJK>
       (?$(1kY(B . "0x5DCF") ;; <CJK>
       (?$(1kZ(B . "0x5EF1") ;; <CJK>
       (?$(1k[(B . "0x61FD") ;; <CJK>
       (?$(1k\(B . "0x651B") ;; <CJK>
       (?$(1k](B . "0x6B02") ;; <CJK>
       (?$(1k^(B . "0x6AFC") ;; <CJK>
       (?$(1k_(B . "0x6B03") ;; <CJK>
       (?$(1k`(B . "0x6AF8") ;; <CJK>
       (?$(1ka(B . "0x6B00") ;; <CJK>
       (?$(1kb(B . "0x7043") ;; <CJK>
       (?$(1kc(B . "0x7044") ;; <CJK>
       (?$(1kd(B . "0x704A") ;; <CJK>
       (?$(1ke(B . "0x7048") ;; <CJK>
       (?$(1kf(B . "0x7049") ;; <CJK>
       (?$(1kg(B . "0x7045") ;; <CJK>
       (?$(1kh(B . "0x7046") ;; <CJK>
       (?$(1ki(B . "0x721D") ;; <CJK>
       (?$(1kj(B . "0x721A") ;; <CJK>
       (?$(1kk(B . "0x7219") ;; <CJK>
       (?$(1kl(B . "0x737E") ;; <CJK>
       (?$(1km(B . "0x7517") ;; <CJK>
       (?$(1kn(B . "0x766A") ;; <CJK>
       (?$(1ko(B . "0x77D0") ;; <CJK>
       (?$(1kp(B . "0x792D") ;; <CJK>
       (?$(1kq(B . "0x7931") ;; <CJK>
       (?$(1kr(B . "0x792F") ;; <CJK>
       (?$(1ks(B . "0x7C54") ;; <CJK>
       (?$(1kt(B . "0x7C53") ;; <CJK>
       (?$(1ku(B . "0x7CF2") ;; <CJK>
       (?$(1kv(B . "0x7E8A") ;; <CJK>
       (?$(1kw(B . "0x7E87") ;; <CJK>
       (?$(1kx(B . "0x7E88") ;; <CJK>
       (?$(1ky(B . "0x7E8B") ;; <CJK>
       (?$(1kz(B . "0x7E86") ;; <CJK>
       (?$(1k{(B . "0x7E8D") ;; <CJK>
       (?$(1k|(B . "0x7F4D") ;; <CJK>
       (?$(1k}(B . "0x7FBB") ;; <CJK>
       (?$(1k~(B . "0x8030") ;; <CJK>
       (?$(1l!(B . "0x81DD") ;; <CJK>
       (?$(1l"(B . "0x8618") ;; <CJK>
       (?$(1l#(B . "0x862A") ;; <CJK>
       (?$(1l$(B . "0x8626") ;; <CJK>
       (?$(1l%(B . "0x861F") ;; <CJK>
       (?$(1l&(B . "0x8623") ;; <CJK>
       (?$(1l'(B . "0x861C") ;; <CJK>
       (?$(1l((B . "0x8619") ;; <CJK>
       (?$(1l)(B . "0x8627") ;; <CJK>
       (?$(1l*(B . "0x862E") ;; <CJK>
       (?$(1l+(B . "0x8621") ;; <CJK>
       (?$(1l,(B . "0x8620") ;; <CJK>
       (?$(1l-(B . "0x8629") ;; <CJK>
       (?$(1l.(B . "0x861E") ;; <CJK>
       (?$(1l/(B . "0x8625") ;; <CJK>
       (?$(1l0(B . "0x8829") ;; <CJK>
       (?$(1l1(B . "0x881D") ;; <CJK>
       (?$(1l2(B . "0x881B") ;; <CJK>
       (?$(1l3(B . "0x8820") ;; <CJK>
       (?$(1l4(B . "0x8824") ;; <CJK>
       (?$(1l5(B . "0x881C") ;; <CJK>
       (?$(1l6(B . "0x882B") ;; <CJK>
       (?$(1l7(B . "0x884A") ;; <CJK>
       (?$(1l8(B . "0x896D") ;; <CJK>
       (?$(1l9(B . "0x8969") ;; <CJK>
       (?$(1l:(B . "0x896E") ;; <CJK>
       (?$(1l;(B . "0x896B") ;; <CJK>
       (?$(1l<(B . "0x89FA") ;; <CJK>
       (?$(1l=(B . "0x8B79") ;; <CJK>
       (?$(1l>(B . "0x8B78") ;; <CJK>
       (?$(1l?(B . "0x8B45") ;; <CJK>
       (?$(1l@(B . "0x8B7A") ;; <CJK>
       (?$(1lA(B . "0x8B7B") ;; <CJK>
       (?$(1lB(B . "0x8D10") ;; <CJK>
       (?$(1lC(B . "0x8D14") ;; <CJK>
       (?$(1lD(B . "0x8DAF") ;; <CJK>
       (?$(1lE(B . "0x8E8E") ;; <CJK>
       (?$(1lF(B . "0x8E8C") ;; <CJK>
       (?$(1lG(B . "0x8F5E") ;; <CJK>
       (?$(1lH(B . "0x8F5B") ;; <CJK>
       (?$(1lI(B . "0x8F5D") ;; <CJK>
       (?$(1lJ(B . "0x9146") ;; <CJK>
       (?$(1lK(B . "0x9144") ;; <CJK>
       (?$(1lL(B . "0x9145") ;; <CJK>
       (?$(1lM(B . "0x91B9") ;; <CJK>
       (?$(1lN(B . "0x943F") ;; <CJK>
       (?$(1lO(B . "0x943B") ;; <CJK>
       (?$(1lP(B . "0x9436") ;; <CJK>
       (?$(1lQ(B . "0x9429") ;; <CJK>
       (?$(1lR(B . "0x943D") ;; <CJK>
       (?$(1lS(B . "0x943C") ;; <CJK>
       (?$(1lT(B . "0x9430") ;; <CJK>
       (?$(1lU(B . "0x9439") ;; <CJK>
       (?$(1lV(B . "0x942A") ;; <CJK>
       (?$(1lW(B . "0x9437") ;; <CJK>
       (?$(1lX(B . "0x942C") ;; <CJK>
       (?$(1lY(B . "0x9440") ;; <CJK>
       (?$(1lZ(B . "0x9431") ;; <CJK>
       (?$(1l[(B . "0x95E5") ;; <CJK>
       (?$(1l\(B . "0x95E4") ;; <CJK>
       (?$(1l](B . "0x95E3") ;; <CJK>
       (?$(1l^(B . "0x9735") ;; <CJK>
       (?$(1l_(B . "0x973A") ;; <CJK>
       (?$(1l`(B . "0x97BF") ;; <CJK>
       (?$(1la(B . "0x97E1") ;; <CJK>
       (?$(1lb(B . "0x9864") ;; <CJK>
       (?$(1lc(B . "0x98C9") ;; <CJK>
       (?$(1ld(B . "0x98C6") ;; <CJK>
       (?$(1le(B . "0x98C0") ;; <CJK>
       (?$(1lf(B . "0x9958") ;; <CJK>
       (?$(1lg(B . "0x9956") ;; <CJK>
       (?$(1lh(B . "0x9A39") ;; <CJK>
       (?$(1li(B . "0x9A3D") ;; <CJK>
       (?$(1lj(B . "0x9A46") ;; <CJK>
       (?$(1lk(B . "0x9A44") ;; <CJK>
       (?$(1ll(B . "0x9A42") ;; <CJK>
       (?$(1lm(B . "0x9A41") ;; <CJK>
       (?$(1ln(B . "0x9A3A") ;; <CJK>
       (?$(1lo(B . "0x9A3F") ;; <CJK>
       (?$(1lp(B . "0x9ACD") ;; <CJK>
       (?$(1lq(B . "0x9B15") ;; <CJK>
       (?$(1lr(B . "0x9B17") ;; <CJK>
       (?$(1ls(B . "0x9B18") ;; <CJK>
       (?$(1lt(B . "0x9B16") ;; <CJK>
       (?$(1lu(B . "0x9B3A") ;; <CJK>
       (?$(1lv(B . "0x9B52") ;; <CJK>
       (?$(1lw(B . "0x9C2B") ;; <CJK>
       (?$(1lx(B . "0x9C1D") ;; <CJK>
       (?$(1ly(B . "0x9C1C") ;; <CJK>
       (?$(1lz(B . "0x9C2C") ;; <CJK>
       (?$(1l{(B . "0x9C23") ;; <CJK>
       (?$(1l|(B . "0x9C28") ;; <CJK>
       (?$(1l}(B . "0x9C29") ;; <CJK>
       (?$(1l~(B . "0x9C24") ;; <CJK>
       (?$(1m!(B . "0x9C21") ;; <CJK>
       (?$(1m"(B . "0x9DB7") ;; <CJK>
       (?$(1m#(B . "0x9DB6") ;; <CJK>
       (?$(1m$(B . "0x9DBC") ;; <CJK>
       (?$(1m%(B . "0x9DC1") ;; <CJK>
       (?$(1m&(B . "0x9DC7") ;; <CJK>
       (?$(1m'(B . "0x9DCA") ;; <CJK>
       (?$(1m((B . "0x9DCF") ;; <CJK>
       (?$(1m)(B . "0x9DBE") ;; <CJK>
       (?$(1m*(B . "0x9DC5") ;; <CJK>
       (?$(1m+(B . "0x9DC3") ;; <CJK>
       (?$(1m,(B . "0x9DBB") ;; <CJK>
       (?$(1m-(B . "0x9DB5") ;; <CJK>
       (?$(1m.(B . "0x9DCE") ;; <CJK>
       (?$(1m/(B . "0x9DB9") ;; <CJK>
       (?$(1m0(B . "0x9DBA") ;; <CJK>
       (?$(1m1(B . "0x9DAC") ;; <CJK>
       (?$(1m2(B . "0x9DC8") ;; <CJK>
       (?$(1m3(B . "0x9DB1") ;; <CJK>
       (?$(1m4(B . "0x9DAD") ;; <CJK>
       (?$(1m5(B . "0x9DCC") ;; <CJK>
       (?$(1m6(B . "0x9DB3") ;; <CJK>
       (?$(1m7(B . "0x9DCD") ;; <CJK>
       (?$(1m8(B . "0x9DB2") ;; <CJK>
       (?$(1m9(B . "0x9E7A") ;; <CJK>
       (?$(1m:(B . "0x9E9C") ;; <CJK>
       (?$(1m;(B . "0x9EEB") ;; <CJK>
       (?$(1m<(B . "0x9EEE") ;; <CJK>
       (?$(1m=(B . "0x9EED") ;; <CJK>
       (?$(1m>(B . "0x9F1B") ;; <CJK>
       (?$(1m?(B . "0x9F18") ;; <CJK>
       (?$(1m@(B . "0x9F1A") ;; <CJK>
       (?$(1mA(B . "0x9F31") ;; <CJK>
       (?$(1mB(B . "0x9F4E") ;; <CJK>
       (?$(1mC(B . "0x9F65") ;; <CJK>
       (?$(1mD(B . "0x9F64") ;; <CJK>
       (?$(1mE(B . "0x9F92") ;; <CJK>
       (?$(1mF(B . "0x4EB9") ;; <CJK>
       (?$(1mG(B . "0x56C6") ;; <CJK>
       (?$(1mH(B . "0x56C5") ;; <CJK>
       (?$(1mI(B . "0x56CB") ;; <CJK>
       (?$(1mJ(B . "0x5971") ;; <CJK>
       (?$(1mK(B . "0x5B4B") ;; <CJK>
       (?$(1mL(B . "0x5B4C") ;; <CJK>
       (?$(1mM(B . "0x5DD5") ;; <CJK>
       (?$(1mN(B . "0x5DD1") ;; <CJK>
       (?$(1mO(B . "0x5EF2") ;; <CJK>
       (?$(1mP(B . "0x6521") ;; <CJK>
       (?$(1mQ(B . "0x6520") ;; <CJK>
       (?$(1mR(B . "0x6526") ;; <CJK>
       (?$(1mS(B . "0x6522") ;; <CJK>
       (?$(1mT(B . "0x6B0B") ;; <CJK>
       (?$(1mU(B . "0x6B08") ;; <CJK>
       (?$(1mV(B . "0x6B09") ;; <CJK>
       (?$(1mW(B . "0x6C0D") ;; <CJK>
       (?$(1mX(B . "0x7055") ;; <CJK>
       (?$(1mY(B . "0x7056") ;; <CJK>
       (?$(1mZ(B . "0x7057") ;; <CJK>
       (?$(1m[(B . "0x7052") ;; <CJK>
       (?$(1m\(B . "0x721E") ;; <CJK>
       (?$(1m](B . "0x721F") ;; <CJK>
       (?$(1m^(B . "0x72A9") ;; <CJK>
       (?$(1m_(B . "0x737F") ;; <CJK>
       (?$(1m`(B . "0x74D8") ;; <CJK>
       (?$(1ma(B . "0x74D5") ;; <CJK>
       (?$(1mb(B . "0x74D9") ;; <CJK>
       (?$(1mc(B . "0x74D7") ;; <CJK>
       (?$(1md(B . "0x766D") ;; <CJK>
       (?$(1me(B . "0x76AD") ;; <CJK>
       (?$(1mf(B . "0x7935") ;; <CJK>
       (?$(1mg(B . "0x79B4") ;; <CJK>
       (?$(1mh(B . "0x7A70") ;; <CJK>
       (?$(1mi(B . "0x7A71") ;; <CJK>
       (?$(1mj(B . "0x7C57") ;; <CJK>
       (?$(1mk(B . "0x7C5C") ;; <CJK>
       (?$(1ml(B . "0x7C59") ;; <CJK>
       (?$(1mm(B . "0x7C5B") ;; <CJK>
       (?$(1mn(B . "0x7C5A") ;; <CJK>
       (?$(1mo(B . "0x7CF4") ;; <CJK>
       (?$(1mp(B . "0x7CF1") ;; <CJK>
       (?$(1mq(B . "0x7E91") ;; <CJK>
       (?$(1mr(B . "0x7F4F") ;; <CJK>
       (?$(1ms(B . "0x7F87") ;; <CJK>
       (?$(1mt(B . "0x81DE") ;; <CJK>
       (?$(1mu(B . "0x826B") ;; <CJK>
       (?$(1mv(B . "0x8634") ;; <CJK>
       (?$(1mw(B . "0x8635") ;; <CJK>
       (?$(1mx(B . "0x8633") ;; <CJK>
       (?$(1my(B . "0x862C") ;; <CJK>
       (?$(1mz(B . "0x8632") ;; <CJK>
       (?$(1m{(B . "0x8636") ;; <CJK>
       (?$(1m|(B . "0x882C") ;; <CJK>
       (?$(1m}(B . "0x8828") ;; <CJK>
       (?$(1m~(B . "0x8826") ;; <CJK>
       (?$(1n!(B . "0x882A") ;; <CJK>
       (?$(1n"(B . "0x8825") ;; <CJK>
       (?$(1n#(B . "0x8971") ;; <CJK>
       (?$(1n$(B . "0x89BF") ;; <CJK>
       (?$(1n%(B . "0x89BE") ;; <CJK>
       (?$(1n&(B . "0x89FB") ;; <CJK>
       (?$(1n'(B . "0x8B7E") ;; <CJK>
       (?$(1n((B . "0x8B84") ;; <CJK>
       (?$(1n)(B . "0x8B82") ;; <CJK>
       (?$(1n*(B . "0x8B86") ;; <CJK>
       (?$(1n+(B . "0x8B85") ;; <CJK>
       (?$(1n,(B . "0x8B7F") ;; <CJK>
       (?$(1n-(B . "0x8D15") ;; <CJK>
       (?$(1n.(B . "0x8E95") ;; <CJK>
       (?$(1n/(B . "0x8E94") ;; <CJK>
       (?$(1n0(B . "0x8E9A") ;; <CJK>
       (?$(1n1(B . "0x8E92") ;; <CJK>
       (?$(1n2(B . "0x8E90") ;; <CJK>
       (?$(1n3(B . "0x8E96") ;; <CJK>
       (?$(1n4(B . "0x8E97") ;; <CJK>
       (?$(1n5(B . "0x8F60") ;; <CJK>
       (?$(1n6(B . "0x8F62") ;; <CJK>
       (?$(1n7(B . "0x9147") ;; <CJK>
       (?$(1n8(B . "0x944C") ;; <CJK>
       (?$(1n9(B . "0x9450") ;; <CJK>
       (?$(1n:(B . "0x944A") ;; <CJK>
       (?$(1n;(B . "0x944B") ;; <CJK>
       (?$(1n<(B . "0x944F") ;; <CJK>
       (?$(1n=(B . "0x9447") ;; <CJK>
       (?$(1n>(B . "0x9445") ;; <CJK>
       (?$(1n?(B . "0x9448") ;; <CJK>
       (?$(1n@(B . "0x9449") ;; <CJK>
       (?$(1nA(B . "0x9446") ;; <CJK>
       (?$(1nB(B . "0x973F") ;; <CJK>
       (?$(1nC(B . "0x97E3") ;; <CJK>
       (?$(1nD(B . "0x986A") ;; <CJK>
       (?$(1nE(B . "0x9869") ;; <CJK>
       (?$(1nF(B . "0x98CB") ;; <CJK>
       (?$(1nG(B . "0x9954") ;; <CJK>
       (?$(1nH(B . "0x995B") ;; <CJK>
       (?$(1nI(B . "0x9A4E") ;; <CJK>
       (?$(1nJ(B . "0x9A53") ;; <CJK>
       (?$(1nK(B . "0x9A54") ;; <CJK>
       (?$(1nL(B . "0x9A4C") ;; <CJK>
       (?$(1nM(B . "0x9A4F") ;; <CJK>
       (?$(1nN(B . "0x9A48") ;; <CJK>
       (?$(1nO(B . "0x9A4A") ;; <CJK>
       (?$(1nP(B . "0x9A49") ;; <CJK>
       (?$(1nQ(B . "0x9A52") ;; <CJK>
       (?$(1nR(B . "0x9A50") ;; <CJK>
       (?$(1nS(B . "0x9AD0") ;; <CJK>
       (?$(1nT(B . "0x9B19") ;; <CJK>
       (?$(1nU(B . "0x9B2B") ;; <CJK>
       (?$(1nV(B . "0x9B3B") ;; <CJK>
       (?$(1nW(B . "0x9B56") ;; <CJK>
       (?$(1nX(B . "0x9B55") ;; <CJK>
       (?$(1nY(B . "0x9C46") ;; <CJK>
       (?$(1nZ(B . "0x9C48") ;; <CJK>
       (?$(1n[(B . "0x9C3F") ;; <CJK>
       (?$(1n\(B . "0x9C44") ;; <CJK>
       (?$(1n](B . "0x9C39") ;; <CJK>
       (?$(1n^(B . "0x9C33") ;; <CJK>
       (?$(1n_(B . "0x9C41") ;; <CJK>
       (?$(1n`(B . "0x9C3C") ;; <CJK>
       (?$(1na(B . "0x9C37") ;; <CJK>
       (?$(1nb(B . "0x9C34") ;; <CJK>
       (?$(1nc(B . "0x9C32") ;; <CJK>
       (?$(1nd(B . "0x9C3D") ;; <CJK>
       (?$(1ne(B . "0x9C36") ;; <CJK>
       (?$(1nf(B . "0x9DDB") ;; <CJK>
       (?$(1ng(B . "0x9DD2") ;; <CJK>
       (?$(1nh(B . "0x9DDE") ;; <CJK>
       (?$(1ni(B . "0x9DDA") ;; <CJK>
       (?$(1nj(B . "0x9DCB") ;; <CJK>
       (?$(1nk(B . "0x9DD0") ;; <CJK>
       (?$(1nl(B . "0x9DDC") ;; <CJK>
       (?$(1nm(B . "0x9DD1") ;; <CJK>
       (?$(1nn(B . "0x9DDF") ;; <CJK>
       (?$(1no(B . "0x9DE9") ;; <CJK>
       (?$(1np(B . "0x9DD9") ;; <CJK>
       (?$(1nq(B . "0x9DD8") ;; <CJK>
       (?$(1nr(B . "0x9DD6") ;; <CJK>
       (?$(1ns(B . "0x9DF5") ;; <CJK>
       (?$(1nt(B . "0x9DD5") ;; <CJK>
       (?$(1nu(B . "0x9DDD") ;; <CJK>
       (?$(1nv(B . "0x9EB6") ;; <CJK>
       (?$(1nw(B . "0x9EF0") ;; <CJK>
       (?$(1nx(B . "0x9F35") ;; <CJK>
       (?$(1ny(B . "0x9F33") ;; <CJK>
       (?$(1nz(B . "0x9F32") ;; <CJK>
       (?$(1n{(B . "0x9F42") ;; <CJK>
       (?$(1n|(B . "0x9F6B") ;; <CJK>
       (?$(1n}(B . "0x9F95") ;; <CJK>
       (?$(1n~(B . "0x9FA2") ;; <CJK>
       (?$(1o!(B . "0x513D") ;; <CJK>
       (?$(1o"(B . "0x5299") ;; <CJK>
       (?$(1o#(B . "0x58E8") ;; <CJK>
       (?$(1o$(B . "0x58E7") ;; <CJK>
       (?$(1o%(B . "0x5972") ;; <CJK>
       (?$(1o&(B . "0x5B4D") ;; <CJK>
       (?$(1o'(B . "0x5DD8") ;; <CJK>
       (?$(1o((B . "0x882F") ;; <CJK>
       (?$(1o)(B . "0x5F4F") ;; <CJK>
       (?$(1o*(B . "0x6201") ;; <CJK>
       (?$(1o+(B . "0x6203") ;; <CJK>
       (?$(1o,(B . "0x6204") ;; <CJK>
       (?$(1o-(B . "0x6529") ;; <CJK>
       (?$(1o.(B . "0x6525") ;; <CJK>
       (?$(1o/(B . "0x6596") ;; <CJK>
       (?$(1o0(B . "0x66EB") ;; <CJK>
       (?$(1o1(B . "0x6B11") ;; <CJK>
       (?$(1o2(B . "0x6B12") ;; <CJK>
       (?$(1o3(B . "0x6B0F") ;; <CJK>
       (?$(1o4(B . "0x6BCA") ;; <CJK>
       (?$(1o5(B . "0x705B") ;; <CJK>
       (?$(1o6(B . "0x705A") ;; <CJK>
       (?$(1o7(B . "0x7222") ;; <CJK>
       (?$(1o8(B . "0x7382") ;; <CJK>
       (?$(1o9(B . "0x7381") ;; <CJK>
       (?$(1o:(B . "0x7383") ;; <CJK>
       (?$(1o;(B . "0x7670") ;; <CJK>
       (?$(1o<(B . "0x77D4") ;; <CJK>
       (?$(1o=(B . "0x7C67") ;; <CJK>
       (?$(1o>(B . "0x7C66") ;; <CJK>
       (?$(1o?(B . "0x7E95") ;; <CJK>
       (?$(1o@(B . "0x826C") ;; <CJK>
       (?$(1oA(B . "0x863A") ;; <CJK>
       (?$(1oB(B . "0x8640") ;; <CJK>
       (?$(1oC(B . "0x8639") ;; <CJK>
       (?$(1oD(B . "0x863C") ;; <CJK>
       (?$(1oE(B . "0x8631") ;; <CJK>
       (?$(1oF(B . "0x863B") ;; <CJK>
       (?$(1oG(B . "0x863E") ;; <CJK>
       (?$(1oH(B . "0x8830") ;; <CJK>
       (?$(1oI(B . "0x8832") ;; <CJK>
       (?$(1oJ(B . "0x882E") ;; <CJK>
       (?$(1oK(B . "0x8833") ;; <CJK>
       (?$(1oL(B . "0x8976") ;; <CJK>
       (?$(1oM(B . "0x8974") ;; <CJK>
       (?$(1oN(B . "0x8973") ;; <CJK>
       (?$(1oO(B . "0x89FE") ;; <CJK>
       (?$(1oP(B . "0x8B8C") ;; <CJK>
       (?$(1oQ(B . "0x8B8E") ;; <CJK>
       (?$(1oR(B . "0x8B8B") ;; <CJK>
       (?$(1oS(B . "0x8B88") ;; <CJK>
       (?$(1oT(B . "0x8C45") ;; <CJK>
       (?$(1oU(B . "0x8D19") ;; <CJK>
       (?$(1oV(B . "0x8E98") ;; <CJK>
       (?$(1oW(B . "0x8F64") ;; <CJK>
       (?$(1oX(B . "0x8F63") ;; <CJK>
       (?$(1oY(B . "0x91BC") ;; <CJK>
       (?$(1oZ(B . "0x9462") ;; <CJK>
       (?$(1o[(B . "0x9455") ;; <CJK>
       (?$(1o\(B . "0x945D") ;; <CJK>
       (?$(1o](B . "0x9457") ;; <CJK>
       (?$(1o^(B . "0x945E") ;; <CJK>
       (?$(1o_(B . "0x97C4") ;; <CJK>
       (?$(1o`(B . "0x97C5") ;; <CJK>
       (?$(1oa(B . "0x9800") ;; <CJK>
       (?$(1ob(B . "0x9A56") ;; <CJK>
       (?$(1oc(B . "0x9A59") ;; <CJK>
       (?$(1od(B . "0x9B1E") ;; <CJK>
       (?$(1oe(B . "0x9B1F") ;; <CJK>
       (?$(1of(B . "0x9B20") ;; <CJK>
       (?$(1og(B . "0x9C52") ;; <CJK>
       (?$(1oh(B . "0x9C58") ;; <CJK>
       (?$(1oi(B . "0x9C50") ;; <CJK>
       (?$(1oj(B . "0x9C4A") ;; <CJK>
       (?$(1ok(B . "0x9C4D") ;; <CJK>
       (?$(1ol(B . "0x9C4B") ;; <CJK>
       (?$(1om(B . "0x9C55") ;; <CJK>
       (?$(1on(B . "0x9C59") ;; <CJK>
       (?$(1oo(B . "0x9C4C") ;; <CJK>
       (?$(1op(B . "0x9C4E") ;; <CJK>
       (?$(1oq(B . "0x9DFB") ;; <CJK>
       (?$(1or(B . "0x9DF7") ;; <CJK>
       (?$(1os(B . "0x9DEF") ;; <CJK>
       (?$(1ot(B . "0x9DE3") ;; <CJK>
       (?$(1ou(B . "0x9DEB") ;; <CJK>
       (?$(1ov(B . "0x9DF8") ;; <CJK>
       (?$(1ow(B . "0x9DE4") ;; <CJK>
       (?$(1ox(B . "0x9DF6") ;; <CJK>
       (?$(1oy(B . "0x9DE1") ;; <CJK>
       (?$(1oz(B . "0x9DEE") ;; <CJK>
       (?$(1o{(B . "0x9DE6") ;; <CJK>
       (?$(1o|(B . "0x9DF2") ;; <CJK>
       (?$(1o}(B . "0x9DF0") ;; <CJK>
       (?$(1o~(B . "0x9DE2") ;; <CJK>
       (?$(1p!(B . "0x9DEC") ;; <CJK>
       (?$(1p"(B . "0x9DF4") ;; <CJK>
       (?$(1p#(B . "0x9DF3") ;; <CJK>
       (?$(1p$(B . "0x9DE8") ;; <CJK>
       (?$(1p%(B . "0x9DED") ;; <CJK>
       (?$(1p&(B . "0x9EC2") ;; <CJK>
       (?$(1p'(B . "0x9ED0") ;; <CJK>
       (?$(1p((B . "0x9EF2") ;; <CJK>
       (?$(1p)(B . "0x9EF3") ;; <CJK>
       (?$(1p*(B . "0x9F06") ;; <CJK>
       (?$(1p+(B . "0x9F1C") ;; <CJK>
       (?$(1p,(B . "0x9F38") ;; <CJK>
       (?$(1p-(B . "0x9F37") ;; <CJK>
       (?$(1p.(B . "0x9F36") ;; <CJK>
       (?$(1p/(B . "0x9F43") ;; <CJK>
       (?$(1p0(B . "0x9F4F") ;; <CJK>
       (?$(1p1(B . "0x9F71") ;; <CJK>
       (?$(1p2(B . "0x9F70") ;; <CJK>
       (?$(1p3(B . "0x9F6E") ;; <CJK>
       (?$(1p4(B . "0x9F6F") ;; <CJK>
       (?$(1p5(B . "0x56D3") ;; <CJK>
       (?$(1p6(B . "0x56CD") ;; <CJK>
       (?$(1p7(B . "0x5B4E") ;; <CJK>
       (?$(1p8(B . "0x5C6D") ;; <CJK>
       (?$(1p9(B . "0x652D") ;; <CJK>
       (?$(1p:(B . "0x66ED") ;; <CJK>
       (?$(1p;(B . "0x66EE") ;; <CJK>
       (?$(1p<(B . "0x6B13") ;; <CJK>
       (?$(1p=(B . "0x705F") ;; <CJK>
       (?$(1p>(B . "0x7061") ;; <CJK>
       (?$(1p?(B . "0x705D") ;; <CJK>
       (?$(1p@(B . "0x7060") ;; <CJK>
       (?$(1pA(B . "0x7223") ;; <CJK>
       (?$(1pB(B . "0x74DB") ;; <CJK>
       (?$(1pC(B . "0x74E5") ;; <CJK>
       (?$(1pD(B . "0x77D5") ;; <CJK>
       (?$(1pE(B . "0x7938") ;; <CJK>
       (?$(1pF(B . "0x79B7") ;; <CJK>
       (?$(1pG(B . "0x79B6") ;; <CJK>
       (?$(1pH(B . "0x7C6A") ;; <CJK>
       (?$(1pI(B . "0x7E97") ;; <CJK>
       (?$(1pJ(B . "0x7F89") ;; <CJK>
       (?$(1pK(B . "0x826D") ;; <CJK>
       (?$(1pL(B . "0x8643") ;; <CJK>
       (?$(1pM(B . "0x8838") ;; <CJK>
       (?$(1pN(B . "0x8837") ;; <CJK>
       (?$(1pO(B . "0x8835") ;; <CJK>
       (?$(1pP(B . "0x884B") ;; <CJK>
       (?$(1pQ(B . "0x8B94") ;; <CJK>
       (?$(1pR(B . "0x8B95") ;; <CJK>
       (?$(1pS(B . "0x8E9E") ;; <CJK>
       (?$(1pT(B . "0x8E9F") ;; <CJK>
       (?$(1pU(B . "0x8EA0") ;; <CJK>
       (?$(1pV(B . "0x8E9D") ;; <CJK>
       (?$(1pW(B . "0x91BE") ;; <CJK>
       (?$(1pX(B . "0x91BD") ;; <CJK>
       (?$(1pY(B . "0x91C2") ;; <CJK>
       (?$(1pZ(B . "0x946B") ;; <CJK>
       (?$(1p[(B . "0x9468") ;; <CJK>
       (?$(1p\(B . "0x9469") ;; <CJK>
       (?$(1p](B . "0x96E5") ;; <CJK>
       (?$(1p^(B . "0x9746") ;; <CJK>
       (?$(1p_(B . "0x9743") ;; <CJK>
       (?$(1p`(B . "0x9747") ;; <CJK>
       (?$(1pa(B . "0x97C7") ;; <CJK>
       (?$(1pb(B . "0x97E5") ;; <CJK>
       (?$(1pc(B . "0x9A5E") ;; <CJK>
       (?$(1pd(B . "0x9AD5") ;; <CJK>
       (?$(1pe(B . "0x9B59") ;; <CJK>
       (?$(1pf(B . "0x9C63") ;; <CJK>
       (?$(1pg(B . "0x9C67") ;; <CJK>
       (?$(1ph(B . "0x9C66") ;; <CJK>
       (?$(1pi(B . "0x9C62") ;; <CJK>
       (?$(1pj(B . "0x9C5E") ;; <CJK>
       (?$(1pk(B . "0x9C60") ;; <CJK>
       (?$(1pl(B . "0x9E02") ;; <CJK>
       (?$(1pm(B . "0x9DFE") ;; <CJK>
       (?$(1pn(B . "0x9E07") ;; <CJK>
       (?$(1po(B . "0x9E03") ;; <CJK>
       (?$(1pp(B . "0x9E06") ;; <CJK>
       (?$(1pq(B . "0x9E05") ;; <CJK>
       (?$(1pr(B . "0x9E00") ;; <CJK>
       (?$(1ps(B . "0x9E01") ;; <CJK>
       (?$(1pt(B . "0x9E09") ;; <CJK>
       (?$(1pu(B . "0x9DFF") ;; <CJK>
       (?$(1pv(B . "0x9DFD") ;; <CJK>
       (?$(1pw(B . "0x9E04") ;; <CJK>
       (?$(1px(B . "0x9EA0") ;; <CJK>
       (?$(1py(B . "0x9F1E") ;; <CJK>
       (?$(1pz(B . "0x9F46") ;; <CJK>
       (?$(1p{(B . "0x9F74") ;; <CJK>
       (?$(1p|(B . "0x9F75") ;; <CJK>
       (?$(1p}(B . "0x9F76") ;; <CJK>
       (?$(1p~(B . "0x56D4") ;; <CJK>
       (?$(1q!(B . "0x652E") ;; <CJK>
       (?$(1q"(B . "0x65B8") ;; <CJK>
       (?$(1q#(B . "0x6B18") ;; <CJK>
       (?$(1q$(B . "0x6B19") ;; <CJK>
       (?$(1q%(B . "0x6B17") ;; <CJK>
       (?$(1q&(B . "0x6B1A") ;; <CJK>
       (?$(1q'(B . "0x7062") ;; <CJK>
       (?$(1q((B . "0x7226") ;; <CJK>
       (?$(1q)(B . "0x72AA") ;; <CJK>
       (?$(1q*(B . "0x77D8") ;; <CJK>
       (?$(1q+(B . "0x77D9") ;; <CJK>
       (?$(1q,(B . "0x7939") ;; <CJK>
       (?$(1q-(B . "0x7C69") ;; <CJK>
       (?$(1q.(B . "0x7C6B") ;; <CJK>
       (?$(1q/(B . "0x7CF6") ;; <CJK>
       (?$(1q0(B . "0x7E9A") ;; <CJK>
       (?$(1q1(B . "0x7E98") ;; <CJK>
       (?$(1q2(B . "0x7E9B") ;; <CJK>
       (?$(1q3(B . "0x7E99") ;; <CJK>
       (?$(1q4(B . "0x81E0") ;; <CJK>
       (?$(1q5(B . "0x81E1") ;; <CJK>
       (?$(1q6(B . "0x8646") ;; <CJK>
       (?$(1q7(B . "0x8647") ;; <CJK>
       (?$(1q8(B . "0x8648") ;; <CJK>
       (?$(1q9(B . "0x8979") ;; <CJK>
       (?$(1q:(B . "0x897A") ;; <CJK>
       (?$(1q;(B . "0x897C") ;; <CJK>
       (?$(1q<(B . "0x897B") ;; <CJK>
       (?$(1q=(B . "0x89FF") ;; <CJK>
       (?$(1q>(B . "0x8B98") ;; <CJK>
       (?$(1q?(B . "0x8B99") ;; <CJK>
       (?$(1q@(B . "0x8EA5") ;; <CJK>
       (?$(1qA(B . "0x8EA4") ;; <CJK>
       (?$(1qB(B . "0x8EA3") ;; <CJK>
       (?$(1qC(B . "0x946E") ;; <CJK>
       (?$(1qD(B . "0x946D") ;; <CJK>
       (?$(1qE(B . "0x946F") ;; <CJK>
       (?$(1qF(B . "0x9471") ;; <CJK>
       (?$(1qG(B . "0x9473") ;; <CJK>
       (?$(1qH(B . "0x9749") ;; <CJK>
       (?$(1qI(B . "0x9872") ;; <CJK>
       (?$(1qJ(B . "0x995F") ;; <CJK>
       (?$(1qK(B . "0x9C68") ;; <CJK>
       (?$(1qL(B . "0x9C6E") ;; <CJK>
       (?$(1qM(B . "0x9C6D") ;; <CJK>
       (?$(1qN(B . "0x9E0B") ;; <CJK>
       (?$(1qO(B . "0x9E0D") ;; <CJK>
       (?$(1qP(B . "0x9E10") ;; <CJK>
       (?$(1qQ(B . "0x9E0F") ;; <CJK>
       (?$(1qR(B . "0x9E12") ;; <CJK>
       (?$(1qS(B . "0x9E11") ;; <CJK>
       (?$(1qT(B . "0x9EA1") ;; <CJK>
       (?$(1qU(B . "0x9EF5") ;; <CJK>
       (?$(1qV(B . "0x9F09") ;; <CJK>
       (?$(1qW(B . "0x9F47") ;; <CJK>
       (?$(1qX(B . "0x9F78") ;; <CJK>
       (?$(1qY(B . "0x9F7B") ;; <CJK>
       (?$(1qZ(B . "0x9F7A") ;; <CJK>
       (?$(1q[(B . "0x9F79") ;; <CJK>
       (?$(1q\(B . "0x571E") ;; <CJK>
       (?$(1q](B . "0x7066") ;; <CJK>
       (?$(1q^(B . "0x7C6F") ;; <CJK>
       (?$(1q_(B . "0x883C") ;; <CJK>
       (?$(1q`(B . "0x8DB2") ;; <CJK>
       (?$(1qa(B . "0x8EA6") ;; <CJK>
       (?$(1qb(B . "0x91C3") ;; <CJK>
       (?$(1qc(B . "0x9474") ;; <CJK>
       (?$(1qd(B . "0x9478") ;; <CJK>
       (?$(1qe(B . "0x9476") ;; <CJK>
       (?$(1qf(B . "0x9475") ;; <CJK>
       (?$(1qg(B . "0x9A60") ;; <CJK>
       (?$(1qh(B . "0x9C74") ;; <CJK>
       (?$(1qi(B . "0x9C73") ;; <CJK>
       (?$(1qj(B . "0x9C71") ;; <CJK>
       (?$(1qk(B . "0x9C75") ;; <CJK>
       (?$(1ql(B . "0x9E14") ;; <CJK>
       (?$(1qm(B . "0x9E13") ;; <CJK>
       (?$(1qn(B . "0x9EF6") ;; <CJK>
       (?$(1qo(B . "0x9F0A") ;; <CJK>
       (?$(1qp(B . "0x9FA4") ;; <CJK>
       (?$(1qq(B . "0x7068") ;; <CJK>
       (?$(1qr(B . "0x7065") ;; <CJK>
       (?$(1qs(B . "0x7CF7") ;; <CJK>
       (?$(1qt(B . "0x866A") ;; <CJK>
       (?$(1qu(B . "0x883E") ;; <CJK>
       (?$(1qv(B . "0x883D") ;; <CJK>
       (?$(1qw(B . "0x883F") ;; <CJK>
       (?$(1qx(B . "0x8B9E") ;; <CJK>
       (?$(1qy(B . "0x8C9C") ;; <CJK>
       (?$(1qz(B . "0x8EA9") ;; <CJK>
       (?$(1q{(B . "0x8EC9") ;; <CJK>
       (?$(1q|(B . "0x974B") ;; <CJK>
       (?$(1q}(B . "0x9873") ;; <CJK>
       (?$(1q~(B . "0x9874") ;; <CJK>
       (?$(1r!(B . "0x98CC") ;; <CJK>
       (?$(1r"(B . "0x9961") ;; <CJK>
       (?$(1r#(B . "0x99AB") ;; <CJK>
       (?$(1r$(B . "0x9A64") ;; <CJK>
       (?$(1r%(B . "0x9A66") ;; <CJK>
       (?$(1r&(B . "0x9A67") ;; <CJK>
       (?$(1r'(B . "0x9B24") ;; <CJK>
       (?$(1r((B . "0x9E15") ;; <CJK>
       (?$(1r)(B . "0x9E17") ;; <CJK>
       (?$(1r*(B . "0x9F48") ;; <CJK>
       (?$(1r+(B . "0x6207") ;; <CJK>
       (?$(1r,(B . "0x6B1E") ;; <CJK>
       (?$(1r-(B . "0x7227") ;; <CJK>
       (?$(1r.(B . "0x864C") ;; <CJK>
       (?$(1r/(B . "0x8EA8") ;; <CJK>
       (?$(1r0(B . "0x9482") ;; <CJK>
       (?$(1r1(B . "0x9480") ;; <CJK>
       (?$(1r2(B . "0x9481") ;; <CJK>
       (?$(1r3(B . "0x9A69") ;; <CJK>
       (?$(1r4(B . "0x9A68") ;; <CJK>
       (?$(1r5(B . "0x9B2E") ;; <CJK>
       (?$(1r6(B . "0x9E19") ;; <CJK>
       (?$(1r7(B . "0x7229") ;; <CJK>
       (?$(1r8(B . "0x864B") ;; <CJK>
       (?$(1r9(B . "0x8B9F") ;; <CJK>
       (?$(1r:(B . "0x9483") ;; <CJK>
       (?$(1r;(B . "0x9C79") ;; <CJK>
       (?$(1r<(B . "0x9EB7") ;; <CJK>
       (?$(1r=(B . "0x7675") ;; <CJK>
       (?$(1r>(B . "0x9A6B") ;; <CJK>
       (?$(1r?(B . "0x9C7A") ;; <CJK>
       (?$(1r@(B . "0x9E1D") ;; <CJK>
       (?$(1rA(B . "0x7069") ;; <CJK>
       (?$(1rB(B . "0x706A") ;; <CJK>
       (?$(1rC(B . "0x9EA4") ;; <CJK>
       (?$(1rD(B . "0x9F7E") ;; <CJK>
       (?$(1rE(B . "0x9F49") ;; <CJK>
       (?$(1rF(B . "0x9F98") ;; <CJK>
       ))))

(provide 'ubig5)
