<?php
/*
 * LibreNMS module to display F5 LTM Bandwidth Controller Details
 *
 * Copyright (c) 2019 Yacine BENAMSILI <https://github.com/yac01/ yacine.benamsili@homail.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.  Please see LICENSE.txt at the top level of
 * the source code distribution for details.
 */

$component = new LibreNMS\Component();
$options = array();
$options['filter']['type'] = array('=','f5-ltm-bwc');
$components = $component->getComponents($device['device_id'], $options);

// We only care about our device id.
$components = $components[$device['device_id']];

// Is the ID we are looking for a valid LTM VS
if (isset($components[$vars['id']])) {
    $label = $components[$vars['id']]['label'];
    $hash = $components[$vars['id']]['hash'];

    include "includes/html/graphs/common.inc.php";
    $rrd_options .= " -l 0 -E ";
    $rrd_options .= " COMMENT:'Bits           Now      Ave      Max\\n'";

    $rrd_filename = rrd_name($device['hostname'], array('f5-ltm-bwc', $label, $hash));
    if (rrdtool_check_rrd_exists($rrd_filename)) {
        $rrd_options .= " DEF:DS=" . $rrd_filename . ":pktsin:AVERAGE ";
        $rrd_options .= " LINE1.25:DS#205F9A:'Packets In '";
        $rrd_options .= " GPRINT:DS:LAST:%6.2lf%s ";
        $rrd_options .= " GPRINT:DS:AVERAGE:%6.2lf%s ";
        $rrd_options .= " GPRINT:DS:MAX:%6.2lf%s\l ";
    }
}
