/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledException;
import util.demangler.GenericDemangledFunctionPointer;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledTemplate;
import util.demangler.ParameterReceiver;

public class GenericDemangledFunction
extends GenericDemangledObject
implements ParameterReceiver {
    protected GenericDemangledDataType returnType;
    protected String callingConvention;
    protected boolean thisPassedOnStack = true;
    protected List<GenericDemangledDataType> parameterList = new ArrayList<GenericDemangledDataType>();
    protected GenericDemangledTemplate template;
    protected boolean isOverloadedOperator = false;
    private boolean virtual = false;
    private String templatedConstructorType;

    public GenericDemangledFunction(String name) throws GenericDemangledException {
        if (name == null) {
            throw new GenericDemangledException("Function name cannot be null; failed to parse mangled name properly");
        }
        this.name = name;
    }

    public void setReturnType(GenericDemangledDataType returnType) {
        this.returnType = returnType;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    public void setThisPassedOnStack(boolean thisPassedOnStack) {
        this.thisPassedOnStack = thisPassedOnStack;
    }

    public boolean isPassedOnStack() {
        return this.thisPassedOnStack;
    }

    public void setTemplate(GenericDemangledTemplate template) {
        this.template = template;
    }

    public GenericDemangledTemplate getTemplate() {
        return this.template;
    }

    public void setVirtual() {
        this.virtual = true;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    public void setOverloadedOperator(boolean isOverloadedOperator) {
        this.isOverloadedOperator = isOverloadedOperator;
    }

    public boolean isOverloadedOperator() {
        return this.isOverloadedOperator;
    }

    @Override
    public void addParameter(GenericDemangledDataType parameter) {
        this.parameterList.add(parameter);
    }

    @Override
    public List<GenericDemangledDataType> getParameters() {
        return new ArrayList<GenericDemangledDataType>(this.parameterList);
    }

    public GenericDemangledDataType getReturnType() {
        return this.returnType;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setTemplatedConstructorType(String type) {
        this.templatedConstructorType = type;
    }

    @Override
    public String getSignature(boolean format) {
        StringBuffer buffer = new StringBuffer();
        if (!(this.returnType instanceof GenericDemangledFunctionPointer)) {
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.isStatic()) {
                buffer.append("static ");
            }
            if (this.virtual) {
                buffer.append("virtual ");
            }
            buffer.append((String)(this.returnType == null ? "" : this.returnType.toSignature() + " "));
        }
        buffer.append((String)(this.callingConvention == null ? "" : this.callingConvention + " "));
        if (this.namespace != null) {
            buffer.append(this.namespace.toNamespace());
        }
        buffer.append(this.name);
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        if (this.specialMidfix != null) {
            buffer.append('[').append(this.specialMidfix).append(']');
        }
        if (this.name.endsWith("()")) {
            if (this.name.equals("operator")) {
                buffer.append("()");
            }
        } else {
            String pad;
            if (this.templatedConstructorType != null) {
                buffer.append('<').append(this.templatedConstructorType).append('>');
            }
            Iterator<GenericDemangledDataType> paramIterator = this.parameterList.iterator();
            buffer.append('(');
            String string = pad = format ? this.pad(buffer.length()) : "";
            if (!paramIterator.hasNext()) {
                buffer.append("void");
            }
            while (paramIterator.hasNext()) {
                buffer.append(paramIterator.next().toSignature());
                if (!paramIterator.hasNext()) continue;
                buffer.append(',');
                if (format) {
                    buffer.append('\n');
                }
                buffer.append(pad);
            }
            buffer.append(')');
            buffer.append((String)(this.storageClass == null ? "" : " " + this.storageClass));
        }
        if (this.returnType instanceof GenericDemangledFunctionPointer) {
            GenericDemangledFunctionPointer funcPtr = (GenericDemangledFunctionPointer)this.returnType;
            String partialSig = funcPtr.toSignature(buffer.toString());
            buffer = new StringBuffer();
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.virtual) {
                buffer.append("virtual ");
            }
            buffer.append(partialSig);
        } else if (this.specialSuffix != null) {
            buffer.append(this.specialSuffix);
        }
        return buffer.toString();
    }

    public String getParameterString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        Iterator<GenericDemangledDataType> dditer = this.parameterList.iterator();
        while (dditer.hasNext()) {
            buffer.append(dditer.next().toSignature());
            if (!dditer.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }
}

