/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.PowerPC_ElfExtension;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class PowerPC_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 20 && elf.is32Bit();
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 20 || !elf.is32Bit()) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        Language language = elfRelocationContext.getProgram().getLanguage();
        if (!"PowerPC".equals(language.getProcessor().toString()) || language.getLanguageDescription().getSize() != 32) {
            PowerPC_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Long.toString(type), null, (String)"Unsupported language for 32-bit PowerPC relocation", (MessageLog)elfRelocationContext.getLog());
        }
        int addend = (int)relocation.getAddend();
        int offset = (int)relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        int symbolValue = (int)elfRelocationContext.getSymbolValue(sym);
        int oldValue = memory.getInt(relocationAddress);
        int newValue = 0;
        switch (type) {
            case 1: 
            case 20: 
            case 24: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 2: {
                newValue = symbolValue + addend >> 2;
                newValue = oldValue & 0xFC000003 | newValue << 2;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case 5: {
                newValue = symbolValue + addend >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case 6: {
                newValue = symbolValue + addend + 32768 >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                newValue = symbolValue + addend >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x3FFFFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 10: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = newValue << 2 & 0x3FFFFFC;
                newValue = oldValue & 0xFC000003 | newValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 22: {
                newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 26: {
                newValue = symbolValue + addend - offset;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x20FFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 21: {
                int value = symbolValue + addend;
                ElfDynamicTable dynamicTable = elf.getDynamicTable();
                if (dynamicTable != null && dynamicTable.containsDynamicValue(PowerPC_ElfExtension.DT_PPC_GOT)) {
                    memory.setInt(relocationAddress, value);
                    break;
                }
                int displacement = value - offset;
                if (displacement << 6 >> 6 == displacement) {
                    newValue = 0x48000000 | displacement & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                if (value > 0 && value <= 0x1FFFFFC || value < 0 && value >= -33554432) {
                    newValue = 0x48000002 | value & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                String symbolName = sym.getNameAsString();
                PowerPC_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                break;
            }
            default: {
                String symbolName = sym.getNameAsString();
                PowerPC_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
    }
}

