/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.img2.Img2;
import ghidra.file.formats.ios.img2.Img2Util;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class Img2Analyzer
extends FileFormatAnalyzer {
    public boolean canAnalyze(Program program) {
        try {
            return Img2Util.isIMG2(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean getDefaultEnablement(Program program) {
        return Img2Util.isIMG2(program);
    }

    public String getDescription() {
        return "Annotates an IMG2 file.";
    }

    public String getName() {
        return "IMG2 Annotation";
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace());
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        Img2 header = new Img2(reader);
        if (!header.getSignature().equals("Img2")) {
            log.appendMsg("Invalid Img2 file!");
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, this.toAddr(program, 0L), headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        this.changeFormatToString(headerData.getComponent(0));
        this.changeFormatToString(headerData.getComponent(1));
        Address dataStartAddress = headerData.getMaxAddress().add(1L);
        Address dataEndAddress = dataStartAddress.add((long)header.getDataLen());
        try {
            this.createFragment(program, "DATA", dataStartAddress, dataEndAddress);
        }
        catch (Exception e) {
            this.createFragment(program, "DATA_" + dataStartAddress, dataStartAddress, dataEndAddress);
        }
        if (header.getDataLen() != header.getDataLenPadded()) {
            Address paddingStartAddress = dataEndAddress.add(1L);
            Address paddingEndAddress = paddingStartAddress.add((long)(header.getDataLenPadded() - header.getDataLen()));
            this.createFragment(program, "PADDING", paddingStartAddress, paddingEndAddress);
        }
        this.removeEmptyFragments(program);
        return true;
    }
}

