/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class YAFFS2Buffer {
    private static int recordSize = 2112;
    private InputStream inStream;
    private OutputStream outStream;
    private byte[] recordBuffer;

    public YAFFS2Buffer(InputStream inStream) {
        this(inStream, recordSize);
    }

    public YAFFS2Buffer(InputStream inStream, int recordSize) {
        this.inStream = inStream;
        this.outStream = null;
        this.initialize(recordSize);
    }

    private void initialize(int recordSize) {
        this.recordBuffer = new byte[recordSize];
    }

    public byte[] readRecord() throws IOException {
        if (this.inStream == null) {
            if (this.outStream == null) {
                throw new IOException("input buffer is closed");
            }
            throw new IOException("reading from an output buffer");
        }
        long numBytes = this.inStream.read(this.recordBuffer, 0, recordSize);
        if (numBytes == -1L) {
            return null;
        }
        return this.recordBuffer;
    }

    public long skip(long numToSkip) throws IOException {
        return this.inStream.skip(numToSkip);
    }

    public boolean isEOFRecord(byte[] record) {
        int sz = this.getRecordSize();
        for (int i = 0; i < sz; ++i) {
            if (record[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int getRecordSize() {
        return recordSize;
    }

    public void close() throws IOException {
        if (this.inStream != System.in) {
            this.inStream.close();
        }
        this.inStream = null;
    }
}

