/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.propertylist;

import ghidra.framework.options.OptionType;

class ConflictInfo {
    private String listName;
    private String propertyName;
    private String displayedPropertyName;
    private String groupName;
    private OptionType myType;
    private OptionType latestType;
    private OptionType origType;
    private Object myValue;
    private Object latestValue;
    private Object origValue;
    private String myTypeString;
    private String latestTypeString;
    private String origTypeString;

    ConflictInfo(String listName, String propertyName, OptionType latestType, OptionType myType, OptionType origType, Object latestValue, Object myValue, Object origValue) {
        this.listName = listName;
        this.propertyName = propertyName;
        int pos = propertyName.lastIndexOf(46);
        if (pos > 0) {
            this.groupName = listName + " " + propertyName.substring(0, pos);
            this.displayedPropertyName = propertyName.substring(pos + 1);
        } else {
            this.groupName = listName;
            this.displayedPropertyName = propertyName;
        }
        this.myType = myType;
        this.latestType = latestType;
        this.origType = origType;
        this.myValue = myValue;
        this.latestValue = latestValue;
        this.origValue = origValue;
        this.myTypeString = this.getTypeString(myType);
        this.latestTypeString = this.getTypeString(latestType);
        this.origTypeString = this.getTypeString(origType);
    }

    boolean isTypeMatch() {
        return this.myType == this.latestType;
    }

    String getListName() {
        return this.listName;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    String getDisplayedPropertyName() {
        return this.displayedPropertyName;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getLatestTypeString() {
        return this.latestTypeString;
    }

    String getMyTypeString() {
        return this.myTypeString;
    }

    String getOrigTypeString() {
        return this.origTypeString;
    }

    Object getLatestValue() {
        return this.latestValue;
    }

    Object getMyValue() {
        return this.myValue;
    }

    Object getOrigValue() {
        return this.origValue;
    }

    OptionType getLatestType() {
        return this.latestType;
    }

    OptionType getMyType() {
        return this.myType;
    }

    OptionType getOrigType() {
        return this.origType;
    }

    private String getTypeString(OptionType type) {
        switch (type) {
            case BOOLEAN_TYPE: {
                return "boolean";
            }
            case DOUBLE_TYPE: {
                return "double";
            }
            case INT_TYPE: {
                return "integer";
            }
            case LONG_TYPE: {
                return "long";
            }
            case STRING_TYPE: {
                return "string";
            }
            case DATE_TYPE: {
                return "date";
            }
        }
        return "unknown";
    }
}

