/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisState;
import ghidra.program.model.listing.Program;
import java.util.HashMap;

public class AnalysisStateInfo {
    private static HashMap<Program, HashMap<Class<? extends AnalysisState>, AnalysisState>> programStates = new HashMap();

    private AnalysisStateInfo() {
    }

    public static <T extends AnalysisState> T getAnalysisState(Program program, Class<T> analysisStateClass) {
        HashMap<Class<? extends AnalysisState>, AnalysisState> stateMap = programStates.get(program);
        if (stateMap != null) {
            return (T)stateMap.get(analysisStateClass);
        }
        return null;
    }

    public static void putAnalysisState(Program program, AnalysisState state) {
        HashMap<Class<AnalysisState>, AnalysisState> stateMap = programStates.get(program);
        if (stateMap == null) {
            stateMap = new HashMap();
            programStates.put(program, stateMap);
            program.addCloseListener(() -> programStates.remove(program));
        }
        stateMap.put(state.getClass(), state);
    }
}

