/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.Msg;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class DeleteAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final ImageIcon DELETE_ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    private static final String[] popupPath = new String[]{"Delete"};
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);

    public DeleteAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Delete Components", GROUP_NAME, popupPath, null, DELETE_ICON);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.setDescription("Delete the selected components");
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.deleteSelectedComponents();
        }
        catch (OutOfMemoryError memExc) {
            Msg.showError((Object)this, null, (String)"Out of Memory", (Object)"Couldn't delete components. Out of memory.", (Throwable)memExc);
        }
        catch (UsrException ue) {
            this.model.setStatus(ue.getMessage());
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isDeleteAllowed());
    }
}

