/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.cmd.disassemble.ArmDisassembleCommand;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.disassemble.Hcs12DisassembleCommand;
import ghidra.app.cmd.disassemble.MipsDisassembleCommand;
import ghidra.app.cmd.disassemble.PowerPCDisassembleCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.disassembler.ArmDisassembleAction;
import ghidra.app.plugin.core.disassembler.ContextAction;
import ghidra.app.plugin.core.disassembler.DisassembleAction;
import ghidra.app.plugin.core.disassembler.Hcs12DisassembleAction;
import ghidra.app.plugin.core.disassembler.MipsDisassembleAction;
import ghidra.app.plugin.core.disassembler.PowerPCDisassembleAction;
import ghidra.app.plugin.core.disassembler.ProcessorStateDialog;
import ghidra.app.plugin.core.disassembler.RestrictedDisassembleAction;
import ghidra.app.plugin.core.disassembler.SetFlowOverrideAction;
import ghidra.app.plugin.core.disassembler.StaticDisassembleAction;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Analysis", shortDescription="Disassembler", description="This plugin provides functionality for dynamic disassembly, static disassembly. In dynamic disassembly, disassembling begins from the selected addresses or if there is no selection then at the address of the current cursor location and attempts to continue disassembling through fallthroughs and along all flows from a disassembled instruction. For instance, if a jump instruction is disassembled then the address being jumped to will be disassembled. The dynamic disassembly will also follow data pointers to addresses containing undefined data, which is then disassembled.  In static disassembly a range or set of ranges is given and disassembly is attempted on each range. Any defined code in the ranges before the static disassembly are first removed.", eventsConsumed={ProgramActivatedPluginEvent.class})
public class DisassemblerPlugin
extends Plugin {
    static final String GROUP_NAME = "Disassembly";
    private DockingAction disassembleRestrictedAction;
    private DockingAction disassembleAction;
    private DockingAction disassembleStaticAction;
    private DockingAction contextAction;
    private DockingAction armDisassembleAction;
    private DockingAction armThumbDisassembleAction;
    private DockingAction hcs12DisassembleAction;
    private DockingAction xgateDisassembleAction;
    private DockingAction mipsDisassembleAction;
    private DockingAction mips16DisassembleAction;
    private DockingAction ppcDisassembleAction;
    private DockingAction ppcVleDisassembleAction;
    private DockingAction setFlowOverrideAction;

    public static String getDescription() {
        return "Provides disassembler services for all supplied machine language modules.";
    }

    public static String getDescriptiveName() {
        return "Disassembler";
    }

    public static String getCategory() {
        return "Disassemblers";
    }

    public DisassemblerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            this.programActivated(ev.getActiveProgram());
        }
    }

    protected void programActivated(Program program) {
        if (program == null) {
            return;
        }
        Options options = program.getOptions("Disassembler");
        options.registerOption("Mark Bad Disassembly", (Object)true, null, "Place ERROR Bookmark at locations where disassembly could not be perfomed.");
        options.registerOption("Mark Unimplemented Pcode", (Object)true, null, "Place WARNING Bookmark at locations where a disassembled instruction has unimplemented pcode.");
        options.registerOption("Restrict Disassembly to Executable Memory", (Object)false, null, "Restrict disassembly to executable memory blocks.");
    }

    private void createActions() {
        this.disassembleAction = new DisassembleAction(this, GROUP_NAME);
        this.disassembleRestrictedAction = new RestrictedDisassembleAction(this, GROUP_NAME);
        this.disassembleStaticAction = new StaticDisassembleAction(this, GROUP_NAME);
        this.contextAction = new ContextAction(this, GROUP_NAME);
        this.armDisassembleAction = new ArmDisassembleAction(this, GROUP_NAME, false);
        this.armThumbDisassembleAction = new ArmDisassembleAction(this, GROUP_NAME, true);
        this.hcs12DisassembleAction = new Hcs12DisassembleAction(this, GROUP_NAME, false);
        this.xgateDisassembleAction = new Hcs12DisassembleAction(this, GROUP_NAME, true);
        this.mipsDisassembleAction = new MipsDisassembleAction(this, GROUP_NAME, false);
        this.mips16DisassembleAction = new MipsDisassembleAction(this, GROUP_NAME, true);
        this.ppcDisassembleAction = new PowerPCDisassembleAction(this, GROUP_NAME, false);
        this.ppcVleDisassembleAction = new PowerPCDisassembleAction(this, GROUP_NAME, true);
        this.setFlowOverrideAction = new SetFlowOverrideAction(this, GROUP_NAME);
        this.tool.addAction((DockingActionIf)this.disassembleAction);
        this.tool.addAction((DockingActionIf)this.disassembleRestrictedAction);
        this.tool.addAction((DockingActionIf)this.disassembleStaticAction);
        this.tool.addAction((DockingActionIf)this.armDisassembleAction);
        this.tool.addAction((DockingActionIf)this.armThumbDisassembleAction);
        this.tool.addAction((DockingActionIf)this.hcs12DisassembleAction);
        this.tool.addAction((DockingActionIf)this.xgateDisassembleAction);
        this.tool.addAction((DockingActionIf)this.mipsDisassembleAction);
        this.tool.addAction((DockingActionIf)this.mips16DisassembleAction);
        this.tool.addAction((DockingActionIf)this.ppcDisassembleAction);
        this.tool.addAction((DockingActionIf)this.ppcVleDisassembleAction);
        this.tool.addAction((DockingActionIf)this.contextAction);
        this.tool.addAction((DockingActionIf)this.setFlowOverrideAction);
    }

    void disassembleRestrictedCallback(ListingActionContext context) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        DisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new DisassembleCommand(currentSelection, (AddressSetView)currentSelection, true);
        } else {
            Address addr = currentLocation.getAddress();
            cmd = new DisassembleCommand(addr, (AddressSetView)new AddressSet(addr, addr), true);
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
    }

    void disassembleStaticCallback(ListingActionContext context) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        DisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new DisassembleCommand(currentSelection, (AddressSetView)currentSelection, false);
        } else {
            Address addr = currentLocation.getAddress();
            cmd = new DisassembleCommand(addr, (AddressSetView)new AddressSet(addr, addr), false);
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
    }

    void disassembleCallback(ListingActionContext context) {
        boolean isDynamicListing;
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        DisassembleCommand cmd = null;
        boolean bl = isDynamicListing = context instanceof CodeViewerActionContext && ((CodeViewerActionContext)context).isDyanmicListing();
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new DisassembleCommand(currentSelection, null, true);
        } else {
            Address addr = currentLocation.getAddress();
            try {
                currentProgram.getMemory().getByte(addr);
                AddressSet restrictedSet = null;
                if (isDynamicListing) {
                    Address max;
                    Address min;
                    try {
                        min = addr.subtractNoWrap(1000L);
                    }
                    catch (AddressOverflowException e) {
                        min = addr.getAddressSpace().getMinAddress();
                    }
                    try {
                        max = addr.addNoWrap(1000L);
                    }
                    catch (AddressOverflowException e) {
                        max = addr.getAddressSpace().getMaxAddress();
                    }
                    restrictedSet = new AddressSet(min, max);
                }
                cmd = new DisassembleCommand(addr, (AddressSetView)restrictedSet, true);
            }
            catch (MemoryAccessException e) {
                this.tool.setStatusInfo("Can't disassemble unitialized memory!", true);
            }
        }
        if (cmd != null) {
            cmd.enableCodeAnalysis(!isDynamicListing);
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
        }
    }

    boolean checkDisassemblyEnabled(ListingActionContext context, Address address, boolean followPtr) {
        ProgramSelection currentSelection = context.getSelection();
        Program currentProgram = context.getProgram();
        if (currentSelection != null && !currentSelection.isEmpty()) {
            return true;
        }
        Listing listing = currentProgram.getListing();
        if (listing.getInstructionContaining(address) != null) {
            return false;
        }
        Data data = listing.getDefinedDataContaining(address);
        if (data != null) {
            Address ptrAddr;
            if (followPtr && data.isPointer() && (ptrAddr = data.getAddress(0)) != null) {
                return this.checkDisassemblyEnabled(context, ptrAddr, false);
            }
            return false;
        }
        return currentProgram.getMemory().contains(address);
    }

    public void disassembleMessageReported(String msg) {
        this.tool.setStatusInfo(msg);
    }

    public void disassemblyDone(Disassembler task) {
    }

    public void setDefaultContext(ListingActionContext context) {
        Program contextProgram = context.getProgram();
        ProgramContext programContext = contextProgram.getProgramContext();
        Register[] registers = programContext.getProcessorStateRegisters();
        if (registers.length == 0) {
            return;
        }
        this.tool.showDialog((DialogComponentProvider)new ProcessorStateDialog(contextProgram.getProgramContext()), context.getComponentProvider());
    }

    public boolean hasContextRegisters(Program currentProgram) {
        Register[] registers = currentProgram.getProgramContext().getProcessorStateRegisters();
        return registers.length > 0;
    }

    public void disassembleArmCallback(ListingActionContext context, boolean thumbMode) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        ArmDisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new ArmDisassembleCommand(currentSelection, null, thumbMode);
        } else {
            Address addr = currentLocation.getAddress();
            try {
                currentProgram.getMemory().getByte(addr);
                cmd = new ArmDisassembleCommand(addr, null, thumbMode);
            }
            catch (MemoryAccessException e) {
                this.tool.setStatusInfo("Can't disassemble unitialized memory!", true);
            }
        }
        if (cmd != null) {
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
        }
    }

    public void disassembleHcs12Callback(ListingActionContext context, boolean xgMode) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        Hcs12DisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new Hcs12DisassembleCommand(currentSelection, null, xgMode);
        } else {
            Address addr = currentLocation.getAddress();
            try {
                currentProgram.getMemory().getByte(addr);
                cmd = new Hcs12DisassembleCommand(addr, null, xgMode);
            }
            catch (MemoryAccessException e) {
                this.tool.setStatusInfo("Can't disassemble unitialized memory!", true);
            }
        }
        if (cmd != null) {
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
        }
    }

    public void disassembleMipsCallback(ListingActionContext context, boolean mips16) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        MipsDisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new MipsDisassembleCommand(currentSelection, null, mips16);
        } else {
            Address addr = currentLocation.getAddress();
            try {
                currentProgram.getMemory().getByte(addr);
                cmd = new MipsDisassembleCommand(addr, null, mips16);
            }
            catch (MemoryAccessException e) {
                this.tool.setStatusInfo("Can't disassemble unitialized memory!", true);
            }
        }
        if (cmd != null) {
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
        }
    }

    public void disassemblePPCCallback(ListingActionContext context, boolean vle) {
        ProgramSelection currentSelection = context.getSelection();
        ProgramLocation currentLocation = context.getLocation();
        Program currentProgram = context.getProgram();
        PowerPCDisassembleCommand cmd = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            cmd = new PowerPCDisassembleCommand(currentSelection, null, vle);
        } else {
            Address addr = currentLocation.getAddress();
            try {
                currentProgram.getMemory().getByte(addr);
                cmd = new PowerPCDisassembleCommand(addr, null, vle);
            }
            catch (MemoryAccessException e) {
                this.tool.setStatusInfo("Can't disassemble unitialized memory!", true);
            }
        }
        if (cmd != null) {
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)currentProgram);
        }
    }
}

