/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.plugin.core.function.VariableCommentDialog;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;

class VariableCommentAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    VariableCommentAction(FunctionPlugin plugin) {
        super("Edit Variable Comment", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function Variables", "Edit Comment..."}, null, "FunctionVariable"));
        this.setKeyBindingData(new KeyBindingData(59, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.funcPlugin.getFunction(context);
        Variable var = this.getVariable(function, context.getLocation());
        if (var == null) {
            return;
        }
        VariableCommentDialog dialog = this.funcPlugin.getVariableCommentDialog();
        if (dialog == null) {
            dialog = new VariableCommentDialog(this.funcPlugin);
        }
        dialog.showDialog(function.getProgram(), var);
    }

    private Variable getVariable(Function function, ProgramLocation currentLocation) {
        if (function == null) {
            return null;
        }
        if (currentLocation instanceof VariableLocation) {
            return ((VariableLocation)currentLocation).getVariable();
        }
        return null;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        if (!(loc instanceof VariableLocation)) {
            return false;
        }
        VariableLocation varLoc = (VariableLocation)loc;
        Variable var = varLoc.getVariable();
        return var != null && !varLoc.isReturn();
    }
}

