/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

class LocationReferencesTableModel
extends AddressBasedTableModel<LocationReference> {
    private LocationReferencesProvider provider;
    private boolean initialized = false;
    private boolean performFullReload = false;

    LocationReferencesTableModel(LocationReferencesProvider locationReferencesProvider) {
        super("References", (ServiceProvider)locationReferencesProvider.getTool(), locationReferencesProvider.getProgram(), null, true);
        this.provider = locationReferencesProvider;
        this.addTableColumn((DynamicTableColumn)new ContextTableColumn());
    }

    protected void doLoad(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        LocationDescriptor locationDescriptor = this.provider.getLocationDescriptor();
        locationDescriptor.setUseDynamicSearching(this.provider.useDynamicDataTypeSearching());
        locationDescriptor.getReferences(accumulator, monitor, this.performFullReload);
        this.initialized = true;
        this.performFullReload = false;
    }

    private Collection<Address> toAddresses(Iterable<LocationReference> references) {
        HashSet<Address> set = new HashSet<Address>();
        for (LocationReference locationReference : references) {
            set.add(locationReference.getLocationOfUse());
        }
        return set;
    }

    Collection<Address> getReferenceAddresses() {
        return this.toAddresses(this.getAllData());
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void reload() {
        this.initialized = false;
        super.reload();
    }

    void fullReload() {
        this.performFullReload = true;
        this.reload();
    }

    @Override
    public Address getAddress(int row) {
        return ((LocationReference)this.getRowObject(row)).getLocationOfUse();
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        LocationReference ref = (LocationReference)this.getRowObject(row);
        ProgramLocation location = ref.getProgramLocation();
        if (location != null) {
            return location;
        }
        return super.getProgramLocation(row, column);
    }

    private class OffcutTableCellRenderer
    extends AbstractGhidraColumnRenderer<String> {
        private OffcutTableCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value.toString().indexOf("<< OFFCUT >>") >= 0) {
                this.setForeground(Color.RED);
            }
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    private class ContextTableColumn
    extends AbstractProgramBasedDynamicTableColumn<LocationReference, String> {
        private static final String OFFCUT_STRING = "<< OFFCUT >>";
        private OffcutTableCellRenderer renderer;

        private ContextTableColumn() {
            this.renderer = new OffcutTableCellRenderer();
        }

        public String getValue(LocationReference rowObject, Settings settings, Program p, ServiceProvider sp) throws IllegalArgumentException {
            String refType = rowObject.getRefTypeString();
            if (!StringUtils.isBlank((CharSequence)refType)) {
                return refType + (rowObject.isOffcutReference() ? OFFCUT_STRING : "");
            }
            return rowObject.getContext();
        }

        public String getColumnName() {
            return "Context";
        }

        public String getColumnDescription() {
            return "<html>Provides information about the references, such as<br>the reference type (for applied references) or the context<br>of use for discovered references";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }
}

