/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.progmgr.MultiTabPlugin;
import ghidra.program.model.listing.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class ProgramListPanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 230);
    private List<Program> hiddenList;
    private List<Program> shownList;
    private JList<Program> programList;
    private MultiTabPlugin multiTabPlugin;
    private DefaultListModel<Program> listModel;
    private JTextField filterField;

    ProgramListPanel(List<Program> hiddenList, List<Program> shownList, MultiTabPlugin multiTabPlugin) {
        super(new BorderLayout());
        this.hiddenList = hiddenList;
        this.shownList = shownList;
        this.multiTabPlugin = multiTabPlugin;
        this.create();
    }

    void setProgramLists(List<Program> hiddenList, List<Program> shownList) {
        this.hiddenList = hiddenList;
        this.shownList = shownList;
        this.initListModel();
        this.programList.clearSelection();
    }

    JList<Program> getList() {
        return this.programList;
    }

    JTextField getFilterField() {
        return this.filterField;
    }

    Program getSelectedProgram() {
        int index = this.programList.getSelectedIndex();
        if (index >= 0) {
            return this.listModel.get(index);
        }
        return null;
    }

    void selectProgram(Program program) {
        int index = this.listModel.indexOf(program);
        this.programList.setSelectedIndex(index);
    }

    @Override
    public void requestFocus() {
        this.filterField.requestFocus();
        this.filterField.selectAll();
        this.filterList(this.filterField.getText());
    }

    private void create() {
        this.listModel = new DefaultListModel();
        this.initListModel();
        this.programList = new JList<Program>(this.listModel);
        this.programList.setBackground(BACKGROUND_COLOR);
        this.programList.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.programList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = ProgramListPanel.this.programList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    ProgramListPanel.this.programList.setSelectedIndex(index);
                }
            }
        });
        this.programList.setCellRenderer((ListCellRenderer<Program>)((Object)new ProgramListCellRenderer()));
        JScrollPane sp = new JScrollPane();
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setBorder(BorderFactory.createEmptyBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        this.filterField = this.createFilterField();
        northPanel.add(this.filterField);
        JSeparator separator = new JSeparator();
        northPanel.add(separator);
        northPanel.setBackground(BACKGROUND_COLOR);
        this.add((Component)northPanel, "North");
        this.add(this.programList, "Center");
        Border innerBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border outerBorder = BorderFactory.createLineBorder(Color.BLACK);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        this.setBorder(compoundBorder);
        this.setBackground(BACKGROUND_COLOR);
    }

    private JTextField createFilterField() {
        JTextField newFilterField = new JTextField(20);
        newFilterField.setBackground(BACKGROUND_COLOR);
        newFilterField.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        newFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            private void filter(Document document) {
                try {
                    String text = document.getText(0, document.getLength());
                    ProgramListPanel.this.filterList(text);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return newFilterField;
    }

    private void filterList(String filterText) {
        int selectedIndex;
        boolean hasFilter;
        ArrayList<Program> allDataList = new ArrayList<Program>();
        allDataList.addAll(this.hiddenList);
        allDataList.addAll(this.shownList);
        boolean bl = hasFilter = filterText.trim().length() != 0;
        if (hasFilter) {
            String lowerCaseFilterText = filterText.toLowerCase();
            Iterator iterator = allDataList.iterator();
            while (iterator.hasNext()) {
                Program program = (Program)iterator.next();
                String programString = this.multiTabPlugin.getStringUsedInList(program).toLowerCase();
                if (programString.indexOf(lowerCaseFilterText) >= 0) continue;
                iterator.remove();
            }
        }
        this.listModel.clear();
        for (Program program : allDataList) {
            this.listModel.addElement(program);
        }
        if (this.listModel.getSize() > 0 && (selectedIndex = this.programList.getSelectedIndex()) < 0) {
            this.programList.setSelectedIndex(0);
        }
    }

    private void initListModel() {
        int i;
        this.listModel.clear();
        for (i = 0; i < this.hiddenList.size(); ++i) {
            this.listModel.addElement(this.hiddenList.get(i));
        }
        for (i = 0; i < this.shownList.size(); ++i) {
            this.listModel.addElement(this.shownList.get(i));
        }
    }

    private class ProgramListCellRenderer
    extends GListCellRenderer<Program> {
        private ProgramListCellRenderer() {
        }

        protected String getItemText(Program program) {
            return ProgramListPanel.this.multiTabPlugin.getStringUsedInList(program);
        }

        public Component getListCellRendererComponent(JList<? extends Program> list, Program value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent(list, (Object)value, index, isSelected, hasFocus);
            if (ProgramListPanel.this.hiddenList.contains(value)) {
                this.setBold();
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

