/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.program.model.address.AddressSetView;

public class StringTableOptions {
    private int minStringSize = 5;
    private int alignment = 1;
    private boolean includeAllCharSizes = true;
    private boolean nullTerminationRequired = true;
    private boolean includeUndefinedStrings = true;
    private boolean includeDefinedStrings = true;
    private boolean onlyShowWordStrings = false;
    private AddressSetView addressSet = null;
    private boolean requirePascal = false;
    private boolean includePartiallyDefinedStrings = true;
    private boolean includeConflictingStrings = true;
    private String wordModelFile = "";
    private boolean wordModelInitialized = false;
    private boolean loadedBlocksOnly = false;

    public boolean useLoadedBlocksOnly() {
        return this.loadedBlocksOnly;
    }

    public void setUseLoadedBlocksOnly(boolean loadedBlocksOnly) {
        this.loadedBlocksOnly = loadedBlocksOnly;
    }

    public int getMinStringSize() {
        return this.minStringSize;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean getIncludeAllCharSizes() {
        return this.includeAllCharSizes;
    }

    public String getWordModelFile() {
        return this.wordModelFile;
    }

    public boolean getWordModelInitialized() {
        return this.wordModelInitialized;
    }

    public boolean isNullTerminationRequired() {
        return this.nullTerminationRequired;
    }

    public boolean includeUndefinedStrings() {
        return this.includeUndefinedStrings;
    }

    public boolean includeDefinedStrings() {
        return this.includeDefinedStrings;
    }

    public boolean includePartiallyDefinedStrings() {
        return this.includePartiallyDefinedStrings;
    }

    public boolean includeConflictingStrings() {
        return this.includeConflictingStrings;
    }

    public boolean onlyShowWordStrings() {
        return this.onlyShowWordStrings;
    }

    public void setNullTerminationRequired(boolean required) {
        this.nullTerminationRequired = required;
    }

    public void setMinStringSize(int minStringSize) {
        this.minStringSize = minStringSize;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setIncludeAllCharSizes(boolean includeAllCharSizes) {
        this.includeAllCharSizes = includeAllCharSizes;
    }

    public void setIncludeUndefinedStrings(boolean includeUndefinedStrings) {
        this.includeUndefinedStrings = includeUndefinedStrings;
    }

    public void setIncludeDefinedStrings(boolean includeDefinedStrings) {
        this.includeDefinedStrings = includeDefinedStrings;
    }

    public void setOnlyShowWordStrings(boolean onlyShowWordStrings) {
        this.onlyShowWordStrings = onlyShowWordStrings;
    }

    public AddressSetView getAddressSet() {
        return this.addressSet;
    }

    public void setAddressSet(AddressSetView addressSet) {
        this.addressSet = addressSet;
    }

    public void setRequirePascal(boolean requirePascal) {
        this.requirePascal = requirePascal;
    }

    public boolean isPascalRequired() {
        return this.requirePascal;
    }

    public void setIncludePartiallyDefinedStrings(boolean includePartiallyDefinedStrings) {
        this.includePartiallyDefinedStrings = includePartiallyDefinedStrings;
    }

    public void setIncludeConflictingStrings(boolean includeConflictingStrings) {
        this.includeConflictingStrings = includeConflictingStrings;
    }

    public void setWordModelFile(String wordModelFile) {
        this.wordModelFile = wordModelFile;
    }

    public void setWordModelInitialized(boolean wordModelInitialized) {
        this.wordModelInitialized = wordModelInitialized;
    }

    public StringTableOptions copy() {
        StringTableOptions options = new StringTableOptions();
        options.setMinStringSize(this.minStringSize);
        options.setAddressSet(this.addressSet);
        options.setAlignment(this.alignment);
        options.setRequirePascal(this.requirePascal);
        options.setNullTerminationRequired(this.nullTerminationRequired);
        options.setIncludeAllCharSizes(this.includeAllCharSizes);
        options.setIncludeConflictingStrings(this.includeConflictingStrings);
        options.setIncludeUndefinedStrings(this.includeUndefinedStrings);
        options.setIncludeDefinedStrings(this.includeDefinedStrings);
        options.setIncludePartiallyDefinedStrings(this.includePartiallyDefinedStrings);
        options.setOnlyShowWordStrings(this.onlyShowWordStrings);
        options.setWordModelFile(this.wordModelFile);
        options.setWordModelInitialized(this.wordModelInitialized);
        return options;
    }
}

