/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.label.GDLabel;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.layout.MiddleLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.ResourceManager;

public class AddressSetEditorPanel
extends JPanel {
    private static Icon ADD_ICON = ResourceManager.loadImage((String)"images/Plus.png");
    private static Icon SUBTRACT_ICON = ResourceManager.loadImage((String)"images/list-remove.png");
    private AddressInput minAddressField;
    private AddressInput maxAddressField;
    private JButton addRangeButton;
    private JPanel bottomButtons;
    private JButton removeRangeButton;
    private AddressSetListModel listModel;
    private JList<AddressRange> list;
    private HashSet<ChangeListener> listeners = new HashSet();
    private JButton subtractRangeButton;
    private final AddressSet addressSet;
    private final AddressFactory addressFactory;

    public AddressSetEditorPanel(AddressFactory addressFactory, AddressSetView addressSet) {
        super(new BorderLayout());
        this.addressFactory = addressFactory;
        this.addressSet = new AddressSet(addressSet);
        this.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.add((Component)this.createAddRangePanel(), "North");
        this.add(this.createRangeListPanel(), "Center");
        this.add(this.createRemoveRangePanel(), "South");
        this.validateAddRemoveButton();
        this.validateRemoveButton();
    }

    private JPanel createAddRangePanel() {
        JPanel minAddressPanel = new JPanel();
        minAddressPanel.setLayout(new BorderLayout());
        GDLabel minLabel = new GDLabel("Min:");
        minLabel.setToolTipText("Enter minimum address to add or remove");
        minAddressPanel.add((Component)minLabel, "West");
        this.minAddressField = new AddressInput();
        this.minAddressField.setAddressFactory(this.addressFactory);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddressSetEditorPanel.this.validateAddRemoveButton();
            }
        };
        this.minAddressField.addChangeListener(listener);
        minAddressPanel.add((Component)this.minAddressField, "Center");
        JPanel maxAddressPanel = new JPanel();
        maxAddressPanel.setLayout(new BorderLayout());
        GDLabel maxLabel = new GDLabel("Max:");
        maxLabel.setToolTipText("Enter maximum address to add or remove");
        maxAddressPanel.add((Component)maxLabel, "West");
        this.maxAddressField = new AddressInput();
        this.maxAddressField.setAddressFactory(this.addressFactory);
        this.maxAddressField.addChangeListener(listener);
        maxAddressPanel.add((Component)this.maxAddressField, "Center");
        maxAddressPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.addRangeButton = new JButton(ADD_ICON);
        this.addRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSetEditorPanel.this.addRange();
            }
        });
        this.addRangeButton.setToolTipText("Add the range to the set of included addresses");
        this.subtractRangeButton = new JButton(SUBTRACT_ICON);
        this.subtractRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSetEditorPanel.this.subtractRange();
            }
        });
        this.subtractRangeButton.setToolTipText("Remove the range from the set of included addresses");
        JPanel addressPanel = new JPanel();
        addressPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10), "Add/Remove Address Range"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        addressPanel.setLayout(new GridBagLayout());
        addressPanel.add((Component)minAddressPanel, gbc);
        gbc.gridx = 1;
        addressPanel.add((Component)maxAddressPanel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        addressPanel.add((Component)this.addRangeButton, gbc);
        gbc.gridx = 3;
        addressPanel.add((Component)this.subtractRangeButton, gbc);
        return addressPanel;
    }

    private Component createRemoveRangePanel() {
        this.bottomButtons = new JPanel();
        this.bottomButtons.setLayout((LayoutManager)new MiddleLayout());
        this.removeRangeButton = new JButton("Remove Selected Range(s)");
        this.removeRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSetEditorPanel.this.removeRange();
            }
        });
        this.bottomButtons.add(this.removeRangeButton);
        return this.bottomButtons;
    }

    private Component createRangeListPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.listModel = new AddressSetListModel(this.addressSet.toList());
        this.list = new JList<AddressRange>(this.listModel);
        this.list.setSelectionMode(2);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddressSetEditorPanel.this.validateRemoveButton();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), "Included Address Ranges:"));
        panel.add(scrollPane);
        return panel;
    }

    public synchronized AddressSetView getAddressSetView() {
        return new AddressSet((AddressSetView)this.addressSet);
    }

    private synchronized void removeRange() {
        int[] selectedIndices = this.list.getSelectedIndices();
        AddressSet removeRanges = new AddressSet();
        for (int selectedIndice : selectedIndices) {
            AddressRange addressRange = this.listModel.getElementAt(selectedIndice);
            removeRanges.add(addressRange);
        }
        this.addressSet.delete((AddressSetView)removeRanges);
        this.listModel.setData(this.addressSet.toList());
        this.list.clearSelection();
        this.notifyListeners();
    }

    private synchronized void addRange() {
        Address minAddress = this.getMinAddress();
        Address maxAddress = this.getMaxAddress();
        this.addressSet.addRange(minAddress, maxAddress);
        this.listModel.setData(this.addressSet.toList());
        this.notifyListeners();
        this.minAddressField.clear();
        this.maxAddressField.clear();
        this.minAddressField.requestFocus();
    }

    private synchronized void subtractRange() {
        Address minAddress = this.getMinAddress();
        Address maxAddress = this.getMaxAddress();
        this.addressSet.deleteRange(minAddress, maxAddress);
        this.listModel.setData(this.addressSet.toList());
        this.notifyListeners();
        this.minAddressField.clear();
        this.maxAddressField.clear();
        this.minAddressField.requestFocus();
    }

    private void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private Address getMinAddress() {
        return this.minAddressField.getAddress();
    }

    private Address getMaxAddress() {
        return this.maxAddressField.getAddress();
    }

    private void validateRemoveButton() {
        int selectedIndex = this.list.getSelectedIndex();
        boolean enabled = selectedIndex != -1;
        this.removeRangeButton.setEnabled(enabled);
    }

    private void validateAddRemoveButton() {
        boolean valid = this.hasValidMinMax();
        this.addRangeButton.setEnabled(valid);
        this.subtractRangeButton.setEnabled(valid);
    }

    private boolean hasValidMinMax() {
        Address maxAddress = this.getMaxAddress();
        if (maxAddress == null) {
            return false;
        }
        Address minAddress = this.getMinAddress();
        if (minAddress == null) {
            return false;
        }
        if (!minAddress.getAddressSpace().equals(maxAddress.getAddressSpace())) {
            return false;
        }
        return minAddress.compareTo((Object)maxAddress) <= 0;
    }

    static class AddressSetListModel
    extends AbstractListModel<AddressRange> {
        private List<AddressRange> addressList;

        AddressSetListModel(List<AddressRange> list) {
            this.addressList = list;
        }

        public void setData(List<AddressRange> list) {
            this.addressList = list;
            this.fireContentsChanged(this, 0, list.size());
        }

        @Override
        public AddressRange getElementAt(int index) {
            return this.addressList.get(index);
        }

        @Override
        public int getSize() {
            return this.addressList.size();
        }
    }
}

