/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.EntryPoint;
import ghidra.util.Conv;
import java.io.IOException;

public class EntryTableBundle {
    public static final byte UNUSED = 0;
    public static final byte MOVEABLE = -1;
    public static final byte CONSTANT = -2;
    private byte count;
    private byte type;
    private EntryPoint[] entryPoints;

    EntryTableBundle(FactoryBundledWithBinaryReader reader) throws IOException {
        this.count = reader.readNextByte();
        if (this.count == 0) {
            return;
        }
        this.type = reader.readNextByte();
        if (this.type == 0) {
            return;
        }
        int count_int = Conv.byteToInt((byte)this.count);
        this.entryPoints = new EntryPoint[count_int];
        for (int i = 0; i < count_int; ++i) {
            this.entryPoints[i] = new EntryPoint(reader, this);
        }
    }

    public boolean isMoveable() {
        return this.type == -1;
    }

    public boolean isConstant() {
        return this.type == -2;
    }

    public byte getCount() {
        return this.count;
    }

    public byte getType() {
        return this.type;
    }

    public EntryPoint[] getEntryPoints() {
        return this.entryPoints;
    }
}

