/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableIconFactory;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.framework.model.Tool;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class NavigatableComponentProviderAdapter
extends ComponentProviderAdapter
implements Navigatable {
    private WeakSet<NavigatableRemovalListener> navigationListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private boolean isConnected;
    private ImageIcon navigatableIcon;
    private boolean disposed = false;

    public NavigatableComponentProviderAdapter(PluginTool tool, String name, String owner, Class<?> contextType) {
        super(tool, name, owner, contextType);
        this.registerNavigatable();
    }

    public Icon getIcon() {
        if (this.isConnected()) {
            return super.getIcon();
        }
        if (this.navigatableIcon == null) {
            Icon primaryIcon = super.getIcon();
            this.navigatableIcon = NavigatableIconFactory.createSnapshotOverlayIcon(primaryIcon);
        }
        return this.navigatableIcon;
    }

    @Override
    public Icon getNavigatableIcon() {
        return this.getIcon();
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public boolean supportsMarkers() {
        return this.isConnected;
    }

    protected void setConnected(boolean newValue) {
        this.isConnected = newValue;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.unregisterNavigatable();
        this.disposed = true;
        for (NavigatableRemovalListener listener : this.navigationListeners) {
            listener.navigatableRemoved(this);
        }
    }

    void registerNavigatable() {
        NavigatableRegistry.registerNavigatable((Tool)this.tool, this);
    }

    void unregisterNavigatable() {
        NavigatableRegistry.unregisterNavigatable((Tool)this.tool, this);
    }

    @Override
    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    @Override
    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void readDataState(SaveState saveState) {
        this.unregisterNavigatable();
        this.initializeInstanceID(saveState.getLong("NAV_ID", this.getInstanceID()));
        this.registerNavigatable();
    }

    public void writeDataState(SaveState saveState) {
        saveState.putLong("NAV_ID", this.getInstanceID());
    }
}

