/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GIconLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.GIconProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.SelectFromListDialog;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBAction;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileSystemBrowserComponentProvider;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.plugins.fsbrowser.tasks.GFileSystemExtractAllTask;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

class FSBActionManager {
    private static final int MAX_PROJECT_SIZE_TO_SEARCH_WITHOUT_WARNING_USER = 1000;
    private static final int MAX_TEXT_FILE_LEN = 65536;
    DockingAction actionShowSupportedFileSystemsAndLoaders;
    DockingAction actionImport;
    DockingAction actionOpenPrograms;
    DockingAction actionOpenFileSystemChooser;
    DockingAction actionOpenFileSystemNewWindow;
    DockingAction actionOpenFileSystemNested;
    DockingAction actionGetInfo;
    DockingAction actionListMountedFileSystems;
    DockingAction actionViewAsText;
    DockingAction actionViewAsImage;
    DockingAction actionExportAll;
    DockingAction actionExport;
    DockingAction actionExpand;
    DockingAction actionCollapse;
    DockingAction actionImportBatch;
    DockingAction actionCloseFileSystem;
    protected FileSystemBrowserPlugin plugin;
    protected FileSystemBrowserComponentProvider provider;
    private TextEditorService textEditorService;
    private GTree gTree;
    private GhidraFileChooser chooserExport;
    private GhidraFileChooser chooserExportAll;
    private List<DockingAction> actions = new ArrayList<DockingAction>();

    FSBActionManager(FileSystemBrowserPlugin plugin, FileSystemBrowserComponentProvider provider, TextEditorService textEditorService, GTree gTree) {
        this.plugin = plugin;
        this.provider = provider;
        this.textEditorService = textEditorService;
        this.gTree = gTree;
        this.chooserExport = new GhidraFileChooser((Component)provider.getComponent());
        this.chooserExportAll = new GhidraFileChooser((Component)provider.getComponent());
        this.createActions();
    }

    private void createActions() {
        this.actionCloseFileSystem = this.createCloseAction();
        this.actions.add(this.actionCloseFileSystem);
        this.actionOpenPrograms = this.createOpenAllProgramsAction();
        this.actions.add(this.actionOpenPrograms);
        this.actionImport = this.createImportAction();
        this.actions.add(this.actionImport);
        this.actionImportBatch = this.createBatchImportAction();
        this.actions.add(this.actionImportBatch);
        this.actionOpenFileSystemNewWindow = this.createOpenFileSystemActionNewWindow();
        this.actions.add(this.actionOpenFileSystemNewWindow);
        this.actionOpenFileSystemNested = this.createOpenNestedFileSystemAction();
        this.actions.add(this.actionOpenFileSystemNested);
        this.actionOpenFileSystemChooser = this.createOpenNewFileSystemAction();
        this.actions.add(this.actionOpenFileSystemChooser);
        this.actionExpand = this.createExpandAllAction();
        this.actions.add(this.actionExpand);
        this.actionCollapse = this.createCollapseAllAction();
        this.actions.add(this.actionCollapse);
        this.actionViewAsImage = this.createViewAsImageAction();
        this.actions.add(this.actionViewAsImage);
        this.actionViewAsText = this.createViewAsTextAction();
        this.actions.add(this.actionViewAsText);
        this.actionExport = this.createExportAction();
        this.actions.add(this.actionExport);
        this.actionExportAll = this.createExportAllAction();
        this.actions.add(this.actionExportAll);
        this.actionGetInfo = this.createGetInfoAction();
        this.actions.add(this.actionGetInfo);
        this.actionShowSupportedFileSystemsAndLoaders = this.createSupportedFileSystemsAction();
        this.actions.add(this.actionShowSupportedFileSystemsAndLoaders);
        this.actionListMountedFileSystems = this.createListMountedFilesystemsAction();
        this.actions.add(this.actionListMountedFileSystems);
    }

    private void removeActions() {
        for (DockingAction action : this.actions) {
            this.plugin.getTool().removeLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    public void registerComponentActionsInTool() {
        for (DockingAction action : this.actions) {
            this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    public void dispose() {
        this.removeActions();
    }

    private List<FSRL> getLoadableFSRLsFromContext(ActionContext context) {
        FSBNode[] contextObject = context.getContextObject();
        if (contextObject instanceof FSBNode) {
            contextObject = new FSBNode[]{(FSBNode)contextObject};
        }
        if (!(contextObject instanceof FSBNode[])) {
            return Collections.emptyList();
        }
        ArrayList<FSRL> fsrls = new ArrayList<FSRL>();
        for (FSBNode node : contextObject) {
            FSRL fsrl = node.getFSRL();
            FSRL validated = this.vaildateFsrl(fsrl, node);
            if (validated != null) {
                fsrls.add(validated);
                continue;
            }
            if (node instanceof FSBRootNode && fsrl.getFS().hasContainer()) {
                fsrls.add(fsrl.getFS().getContainer());
                continue;
            }
            if (!(node instanceof FSBFileNode)) continue;
            fsrls.add(fsrl);
        }
        return fsrls;
    }

    private FSRL vaildateFsrl(FSRL fsrl, FSBNode node) {
        FSBRootNode rootNode;
        GFileSystem fs;
        if ((node instanceof FSBDirNode || node instanceof FSBRootNode) && (fs = (rootNode = FSBUtils.getNodesRoot(node)).getFSRef().getFilesystem()) instanceof GFileSystemProgramProvider) {
            try {
                GFile gfile = fs.lookup(node.getFSRL().getPath());
                if (gfile != null && ((GFileSystemProgramProvider)((Object)fs)).canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private FSRL getLoadableFSRLFromContext(ActionContext context) {
        FSBRootNode rootNode;
        GFileSystem fs;
        if (context == null || !(context.getContextObject() instanceof FSBNode)) {
            return null;
        }
        FSBNode node = (FSBNode)context.getContextObject();
        FSRL fsrl = node.getFSRL();
        if ((node instanceof FSBDirNode || node instanceof FSBRootNode) && (fs = (rootNode = FSBUtils.getNodesRoot(node)).getFSRef().getFilesystem()) instanceof GFileSystemProgramProvider) {
            try {
                GFile gfile = fs.lookup(node.getFSRL().getPath());
                if (gfile != null && ((GFileSystemProgramProvider)((Object)fs)).canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (node instanceof FSBRootNode && fsrl.getFS().hasContainer()) {
            return fsrl.getFS().getContainer();
        }
        return node instanceof FSBFileNode ? fsrl : null;
    }

    private String getFormattedTreePath(ActionContext context) {
        if (context != null && context.getContextObject() instanceof FSBNode) {
            TreePath treePath = ((FSBNode)context.getContextObject()).getTreePath();
            StringBuilder path = new StringBuilder();
            for (Object pathElement : treePath.getPath()) {
                if (!(pathElement instanceof FSBNode)) continue;
                FSBNode node = (FSBNode)pathElement;
                FSRL fsrl = node.getFSRL();
                if (path.length() != 0) {
                    path.append("/");
                }
                String s = fsrl instanceof FSRLRoot ? (fsrl.getFS().hasContainer() ? fsrl.getFS().getContainer().getName() : "/") : fsrl.getName();
                path.append(s);
            }
            return path.toString();
        }
        return null;
    }

    private boolean isSelectedContextAllDirs(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof FSBNode[]) {
            for (FSBNode node : (FSBNode[])context.getContextObject()) {
                boolean isDir;
                boolean bl = isDir = node instanceof FSBDirNode || node instanceof FSBRootNode;
                if (isDir) continue;
                return false;
            }
            return true;
        }
        return contextObject instanceof FSBDirNode || contextObject instanceof FSBRootNode;
    }

    private List<FSRL> getFSRLsFromNodes(FSBNode[] nodes, boolean dirsOk) {
        ArrayList<FSRL> fsrls = new ArrayList<FSRL>();
        for (FSBNode node : nodes) {
            FSRL fsrl = node.getFSRL();
            if (!dirsOk && node instanceof FSBRootNode && fsrl.getFS().hasContainer()) {
                fsrl = fsrl.getFS().getContainer();
            } else {
                boolean isDir;
                boolean bl = isDir = node instanceof FSBDirNode || node instanceof FSBRootNode;
                if (isDir && !dirsOk) continue;
            }
            fsrls.add(fsrl);
        }
        return fsrls;
    }

    private List<FSRL> getFSRLsFromContext(ActionContext context, boolean dirsOk) {
        FSBNode[] contextObject = context.getContextObject();
        if (contextObject instanceof FSBNode) {
            contextObject = new FSBNode[]{(FSBNode)contextObject};
        }
        if (contextObject instanceof FSBNode[]) {
            return this.getFSRLsFromNodes(contextObject, dirsOk);
        }
        return Collections.emptyList();
    }

    private List<FSRL> getFileFSRLsFromContext(ActionContext context) {
        return this.getFSRLsFromContext(context, false);
    }

    private void openProgramFromFile(FSRL file, String suggestedDestinationPath) {
        ProgramManager pm = FSBUtils.getProgramManager(this.plugin.getTool(), false);
        if (pm == null) {
            return;
        }
        TaskLauncher.launchModal((String)"Open Programs", monitor -> {
            boolean success = this.doOpenProgramFromFile(file, suggestedDestinationPath, pm, monitor);
            if (!success) {
                ImporterUtilities.showImportDialog(this.plugin.getTool(), pm, file, null, suggestedDestinationPath, monitor);
            }
        });
    }

    private boolean doOpenProgramFromFile(FSRL fsrl, String suggestedDestinationPath, ProgramManager programManager, TaskMonitor monitor) {
        Object consumer = new Object();
        Program program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, consumer, programManager, 1);
        if (program == null) {
            return this.searchProjectForMatchingFileOrFail(fsrl, suggestedDestinationPath, programManager, monitor);
        }
        program.release(consumer);
        return true;
    }

    private boolean searchProjectForMatchingFileOrFail(FSRL fsrl, String suggestedDestinationPath, ProgramManager programManager, TaskMonitor monitor) {
        boolean doSearch = this.isProjectSmallEnoughToSearchWithoutWarningUser() || OptionDialog.showYesNoDialog(null, (String)"Search Project for matching program?", (String)"Search entire Project for matching program? (WARNING, could take large amount of time)") == 1;
        Map<Object, Object> matchedFSRLs = doSearch ? ProgramMappingService.searchProjectForMatchingFiles(Arrays.asList(fsrl), monitor) : Collections.emptyMap();
        DomainFile domainFile = (DomainFile)matchedFSRLs.get(fsrl);
        if (domainFile != null) {
            ProgramMappingService.createAssociation(fsrl, domainFile);
            this.showProgramInProgramManager(fsrl, domainFile, programManager, true);
            return true;
        }
        return false;
    }

    private void openProgramsFromFiles(List<FSRL> files) {
        ProgramManager pm = FSBUtils.getProgramManager(this.plugin.getTool(), false);
        if (pm == null) {
            return;
        }
        TaskLauncher.launchModal((String)"Open Programs", monitor -> {
            List<FSRL> unmatchedFiles = this.doOpenProgramsFromFiles(files, pm, monitor);
            if (unmatchedFiles.size() == 1) {
                ImporterUtilities.showImportDialog(this.plugin.getTool(), pm, unmatchedFiles.get(0), null, null, monitor);
            } else if (unmatchedFiles.size() > 1) {
                BatchImportDialog.showAndImport(this.plugin.getTool(), null, unmatchedFiles, null, pm);
            }
        });
    }

    private List<FSRL> doOpenProgramsFromFiles(List<FSRL> fsrls, ProgramManager programManager, TaskMonitor monitor) {
        int programsOpened = 0;
        List<FSRL> unmatchedFiles = new ArrayList<FSRL>();
        Object consumer = new Object();
        for (FSRL fsrl : fsrls) {
            Program program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, consumer, programManager, programsOpened == 0 ? 1 : 2);
            if (program == null) {
                unmatchedFiles.add(fsrl);
                continue;
            }
            program.release(consumer);
            ++programsOpened;
        }
        if (!unmatchedFiles.isEmpty()) {
            unmatchedFiles = this.searchProjectForMatchingFilesOrFail(unmatchedFiles, programManager, monitor, programsOpened);
        }
        return unmatchedFiles;
    }

    private List<FSRL> searchProjectForMatchingFilesOrFail(List<FSRL> fsrlList, ProgramManager programManager, TaskMonitor monitor, int programsOpened) {
        boolean doSearch = this.isProjectSmallEnoughToSearchWithoutWarningUser() || OptionDialog.showYesNoDialog(null, (String)"Search Project for matching programs?", (String)"Search entire Project for matching programs? (WARNING, could take large amount of time)") == 1;
        Map matchedFSRLs = doSearch ? ProgramMappingService.searchProjectForMatchingFiles(fsrlList, monitor) : Collections.emptyMap();
        ArrayList<FSRL> unmatchedFSRLs = new ArrayList<FSRL>();
        for (FSRL fsrl : fsrlList) {
            DomainFile domainFile = (DomainFile)matchedFSRLs.get(fsrl);
            if (domainFile != null) {
                ProgramMappingService.createAssociation(fsrl, domainFile);
            }
            if (this.showProgramInProgramManager(fsrl, domainFile, programManager, programsOpened == 0)) {
                ++programsOpened;
                continue;
            }
            unmatchedFSRLs.add(fsrl);
        }
        return unmatchedFSRLs;
    }

    private boolean isProjectSmallEnoughToSearchWithoutWarningUser() {
        int fc = AppInfo.getActiveProject().getProjectData().getFileCount();
        return fc >= 0 && fc < 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showProgramInProgramManager(FSRL fsrl, DomainFile domainFile, ProgramManager programManager, boolean show) {
        Program program = null;
        Object consumer = new Object();
        try {
            program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, domainFile, consumer, programManager, show ? 1 : 2);
            boolean bl = program != null;
            return bl;
        }
        finally {
            if (program != null) {
                program.release(consumer);
            }
        }
    }

    private void showInfoForFile(FSRL fsrl, TaskMonitor monitor) {
        Object title;
        Object info;
        if (fsrl != null) {
            info = "";
            title = "Info about " + fsrl.getName();
            if (fsrl instanceof FSRLRoot && ((FSRLRoot)fsrl).hasContainer()) {
                FSRL containerFSRL = ((FSRLRoot)fsrl).getContainer();
                title = containerFSRL.getName();
                info = this.getInfoStringFor(containerFSRL, monitor);
                info = (String)info + "------------------------------------\n";
            }
            info = (String)info + this.getInfoStringFor(fsrl, monitor);
        } else {
            title = "Missing File";
            info = "Unable to retrieve information";
        }
        MultiLineMessageDialog.showMessageDialog((Component)this.plugin.getTool().getActiveWindow(), (String)title, null, (String)info, (int)1);
    }

    private String getInfoStringFor(FSRL fsrl, TaskMonitor monitor) {
        String string;
        block10: {
            RefdFile refdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);
            try {
                String nodeInfo;
                GFileSystem fs = refdFile.fsRef.getFilesystem();
                String result = "File system: " + fs.getDescription() + "\n";
                result = result + "FSRL: " + fsrl + "\n";
                DomainFile associatedDomainFile = ProgramMappingService.getCachedDomainFileFor(fsrl);
                if (associatedDomainFile != null) {
                    result = result + "Project file: " + associatedDomainFile.getPathname() + "\n";
                }
                if ((nodeInfo = fs.getInfo(refdFile.file, monitor)) != null) {
                    result = result + nodeInfo;
                }
                string = result;
                if (refdFile == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (refdFile != null) {
                        try {
                            refdFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancelledException | IOException e) {
                    return "Error retrieving information: " + e.getMessage() + "\n";
                }
            }
            refdFile.close();
        }
        return string;
    }

    private void showSupportedFileSystems() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table><tr><td>Supported File Systems</td><td>Supported Loaders</td></tr>\n");
        sb.append("<tr valign='top'><td><ul>");
        for (String fileSystemName : FileSystemService.getInstance().getAllFilesystemNames()) {
            sb.append("<li>" + fileSystemName + "\n");
        }
        sb.append("</ul></td><td><ul>");
        for (String loaderName : LoaderService.getAllLoaderNames()) {
            sb.append("<li>" + loaderName + "\n");
        }
        sb.append("</ul></td></tr></table>");
        MultiLineMessageDialog.showModalMessageDialog((Component)this.plugin.getTool().getActiveWindow(), (String)"Supported File Systems and Loaders", (String)"", (String)sb.toString(), (int)1);
    }

    private DockingAction createSupportedFileSystemsAction() {
        FSBAction action = new FSBAction("Display Supported File Systems and Loaders", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSBActionManager.this.showSupportedFileSystems();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        action.setToolBarData(new ToolBarData((Icon)ImageManager.INFO));
        action.setDescription(action.getMenuText());
        action.setEnabled(true);
        return action;
    }

    private DockingAction createExportAction() {
        FSBAction action = new FSBAction("Export", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFileFSRLFromContext(context);
                if (fsrl != null) {
                    int answer;
                    File selectedFile = new File(FSBActionManager.this.chooserExport.getCurrentDirectory(), fsrl.getName());
                    FSBActionManager.this.chooserExport.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
                    FSBActionManager.this.chooserExport.setTitle("Select Where To Export File");
                    FSBActionManager.this.chooserExport.setApproveButtonText(this.getMenuText());
                    FSBActionManager.this.chooserExport.setSelectedFile(selectedFile);
                    File outputFile = FSBActionManager.this.chooserExport.getSelectedFile();
                    if (outputFile == null) {
                        return;
                    }
                    if (outputFile.exists() && (answer = OptionDialog.showYesNoDialog((Component)FSBActionManager.this.provider.getComponent(), (String)"Confirm Overwrite", (String)(outputFile.getAbsolutePath() + "\nThe file already exists.\nDo you want to overwrite it?"))) == 2) {
                        return;
                    }
                    FSBActionManager.this.gTree.runTask(monitor -> this.doExtractFile(fsrl, outputFile, monitor));
                }
            }

            private void doExtractFile(FSRL fsrl, File outputFile, TaskMonitor monitor) {
                monitor.setMessage("Exporting...");
                try {
                    File cacheFile = FileSystemService.getInstance().getFile(fsrl, monitor);
                    long totalBytesCopied = FileUtilities.copyFile((File)cacheFile, (File)outputFile, (boolean)false, (TaskMonitor)monitor);
                    Msg.info((Object)((Object)this), (Object)("Exported " + fsrl.getName() + " to " + outputFile + ", " + totalBytesCopied + " bytes copied."));
                }
                catch (CancelledException | IOException | UnsupportedOperationException e) {
                    FSUtilities.displayException((Object)this, FSBActionManager.this.plugin.getTool().getActiveWindow(), "Error Exporting File", e.getMessage(), e);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL fsrl = FSBUtils.getFileFSRLFromContext(context);
                return !FSBActionManager.this.gTree.isBusy() && fsrl != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText() + "..."}, (Icon)ImageManager.EXTRACT, "F", -1, "B"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createExportAllAction() {
        FSBAction action = new FSBAction("Export All", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, true);
                if (fsrl == null) {
                    return;
                }
                if (fsrl instanceof FSRLRoot) {
                    fsrl = fsrl.appendPath("/");
                }
                FSBActionManager.this.chooserExportAll.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                FSBActionManager.this.chooserExportAll.setTitle("Select Export Directory");
                FSBActionManager.this.chooserExportAll.setApproveButtonText(this.getMenuText());
                FSBActionManager.this.chooserExportAll.setSelectedFile(null);
                File outputFile = FSBActionManager.this.chooserExportAll.getSelectedFile();
                if (outputFile == null) {
                    return;
                }
                if (!outputFile.isDirectory()) {
                    Msg.showInfo(((Object)((Object)this)).getClass(), (Component)FSBActionManager.this.provider.getComponent(), (String)this.getMenuText(), (Object)"Selected file is not a directory.");
                    return;
                }
                Window parentComp = FSBActionManager.this.plugin.getTool().getActiveWindow();
                TaskLauncher.launch((Task)new GFileSystemExtractAllTask(fsrl, outputFile, parentComp));
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, true);
                return !FSBActionManager.this.gTree.isBusy() && fsrl != null && FSBActionManager.this.isSelectedContextAllDirs(context);
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText() + "..."}, (Icon)ImageManager.EXTRACT, "F", -1, "C"));
        action.setEnabled(false);
        return action;
    }

    private DockingAction createViewAsImageAction() {
        FSBAction action = new FSBAction("View As Image", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, false);
                if (fsrl != null) {
                    FSBActionManager.this.gTree.runTask(monitor -> this.doViewAsImage(fsrl, monitor));
                }
            }

            private void doViewAsImage(FSRL fsrl, TaskMonitor monitor) {
                Window parent = FSBActionManager.this.plugin.getTool().getActiveWindow();
                try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);){
                    Icon icon = GIconProvider.getIconForFile(refdFile.file, monitor);
                    if (icon == null) {
                        Msg.showError((Object)((Object)this), (Component)parent, (String)"Unable To View Image", (Object)("Unable to view " + fsrl.getName() + " as an image."));
                    } else {
                        SystemUtilities.runSwingLater(() -> {
                            GIconLabel label = new GIconLabel(icon);
                            JOptionPane.showMessageDialog(null, label, "Image Viewer: " + fsrl.getName(), 1);
                        });
                    }
                }
                catch (CancelledException | IOException e) {
                    FSUtilities.displayException((Object)this, parent, "Error Viewing Image File", e.getMessage(), e);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, false);
                return !FSBActionManager.this.gTree.isBusy() && fsrl != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.VIEW_AS_IMAGE, "G"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createViewAsTextAction() {
        FSBAction action = new FSBAction("View As Text", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, false);
                if (fsrl != null) {
                    FSBActionManager.this.gTree.runTask(monitor -> this.doViewAsText(fsrl, monitor));
                }
            }

            private void doViewAsText(FSRL fsrl, TaskMonitor monitor) {
                Window parent = FSBActionManager.this.plugin.getTool().getActiveWindow();
                try {
                    File file = FileSystemService.getInstance().getFile(fsrl, monitor);
                    if (file.length() == -1L || file.length() > 65536L) {
                        Msg.showInfo((Object)((Object)this), (Component)parent, (String)"View As Text Failed", (Object)"File too large to view as text inside Ghidra. Please use the \"EXPORT\" action.");
                        return;
                    }
                    if (file.length() == 0L) {
                        Msg.showInfo((Object)((Object)this), (Component)parent, (String)"View As Text Failed", (Object)("File " + fsrl.getName() + " is empty (0 bytes)."));
                        return;
                    }
                    try {
                        FileInputStream inputStream = new FileInputStream(file);
                        SystemUtilities.runSwingLater(() -> FSBActionManager.this.textEditorService.edit(fsrl.getName(), inputStream));
                    }
                    catch (IOException e) {
                        Msg.showError((Object)((Object)this), (Component)parent, (String)"View As Text Failed", (Object)("Error when trying to view text file " + fsrl.getName()), (Throwable)e);
                    }
                }
                catch (CancelledException | IOException e) {
                    FSUtilities.displayException((Object)this, parent, "Error viewing text file", e.getMessage(), e);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, false);
                return !FSBActionManager.this.gTree.isBusy() && fsrl != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.VIEW_AS_TEXT, "G"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createListMountedFilesystemsAction() {
        FSBAction action = new FSBAction("List Mounted Filesystems", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FileSystemRef fsRef;
                FSRLRoot fsFSRL = SelectFromListDialog.selectFromList(FileSystemService.getInstance().getMountedFilesystems(), "Select filesystem", "Choose filesystem to view", f -> f.toPrettyString());
                if (fsFSRL != null && (fsRef = FileSystemService.getInstance().getMountedFilesystem(fsFSRL)) != null) {
                    FSBActionManager.this.plugin.createNewFileSystemBrowser(fsRef, true);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !FSBActionManager.this.gTree.isBusy();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.LIST_MOUNTED, "L"));
        action.setToolBarData(new ToolBarData((Icon)ImageManager.LIST_MOUNTED, "ZZZZ"));
        action.setDescription(action.getMenuText());
        action.setEnabled(true);
        return action;
    }

    private DockingAction createExpandAllAction() {
        FSBAction action = new FSBAction("Expand All", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                if (context.getContextObject() instanceof GTreeNode) {
                    GTreeNode node = (GTreeNode)context.getContextObject();
                    FSBActionManager.this.gTree.expandTree(node);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object co = context.getContextObject();
                return !FSBActionManager.this.gTree.isBusy() && (co instanceof FSBRootNode || co instanceof FSBDirNode);
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.EXPAND_ALL, "B", -1, "A"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createCollapseAllAction() {
        FSBAction action = new FSBAction("Collapse All", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                if (context.getContextObject() instanceof GTreeNode) {
                    GTreeNode node = (GTreeNode)context.getContextObject();
                    FSBActionManager.this.gTree.collapseAll(node);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object co = context.getContextObject();
                return !FSBActionManager.this.gTree.isBusy() && (co instanceof FSBRootNode || co instanceof FSBDirNode);
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.COLLAPSE_ALL, "B", -1, "B"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createGetInfoAction() {
        FSBAction action = new FSBAction("Get Info", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, true);
                FSBActionManager.this.gTree.runTask(monitor -> FSBActionManager.this.showInfoForFile(fsrl, monitor));
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext(context, true);
                return !FSBActionManager.this.gTree.isBusy() && fsrl != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.INFO, "A"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createOpenFileSystemActionNewWindow() {
        FSBAction action = new FSBAction("Open File System In New Window", "Open File System in new window", this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL containerFSRL = FSBUtils.getFileFSRLFromContext(context);
                if (containerFSRL != null) {
                    FSBActionManager.this.gTree.runTask(monitor -> this.doOpenFileSystem(containerFSRL, monitor));
                }
            }

            private void doOpenFileSystem(FSRL containerFSRL, TaskMonitor monitor) {
                try {
                    monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
                    FileSystemRef ref = FileSystemService.getInstance().probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
                    if (ref == null) {
                        Msg.showWarn((Object)((Object)this), (Component)FSBActionManager.this.plugin.getTool().getActiveWindow(), (String)"Open Filesystem", (Object)("No filesystem provider for " + containerFSRL.getName()));
                        return;
                    }
                    SystemUtilities.runSwingLater(() -> FSBActionManager.this.plugin.createNewFileSystemBrowser(ref, true));
                }
                catch (CancelledException | IOException e) {
                    FSUtilities.displayException((Object)this, FSBActionManager.this.plugin.getTool().getActiveWindow(), "Open Filesystem", "Error opening filesystem for " + containerFSRL.getName(), e);
                }
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL containerFSRL = FSBUtils.getFSRLFromContext(context, false);
                return !FSBActionManager.this.gTree.isBusy() && containerFSRL != null;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.OPEN_FILE_SYSTEM, "C"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createOpenNewFileSystemAction() {
        FSBAction action = new FSBAction("Open File System Chooser", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                FSBActionManager.this.plugin.openFileSystem();
            }

            public boolean isAddToPopup(ActionContext context) {
                return false;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.OPEN_FILE_SYSTEM, "C"));
        action.setDescription(action.getMenuText());
        action.setToolBarData(new ToolBarData((Icon)ImageManager.OPEN_FILE_SYSTEM, "B"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createOpenAllProgramsAction() {
        FSBAction action = new FSBAction("Open Programs", "Open Program(s)", this.plugin){

            public void actionPerformed(ActionContext context) {
                if (!FSBActionManager.this.plugin.hasProgramManager()) {
                    Msg.showInfo((Object)((Object)this), (Component)FSBActionManager.this.plugin.getTool().getActiveWindow(), (String)"Open Program Error", (Object)"There is no tool currently open that can be used to show a program.");
                    return;
                }
                List<FSRL> files = FSBActionManager.this.getLoadableFSRLsFromContext(context);
                if (files.size() == 1) {
                    String treePath = FilenameUtils.getFullPathNoEndSeparator((String)FSBActionManager.this.getFormattedTreePath(context));
                    FSBActionManager.this.openProgramFromFile(files.get(0), treePath);
                } else if (files.size() > 1) {
                    FSBActionManager.this.openProgramsFromFiles(files);
                }
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !FSBActionManager.this.gTree.isBusy() && !FSBActionManager.this.getLoadableFSRLsFromContext(context).isEmpty();
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.OPEN_ALL, "D", -1, "B"));
        action.setEnabled(this.plugin.hasProgramManager());
        return action;
    }

    private DockingAction createCloseAction() {
        FSBAction action = new FSBAction("Close", (Plugin)this.plugin){

            public void actionPerformed(ActionContext context) {
                if (!(context.getContextObject() instanceof FSBRootNode)) {
                    return;
                }
                FSBRootNode node = (FSBRootNode)context.getContextObject();
                if (node == FSBActionManager.this.gTree.getRootNode()) {
                    FileSystemRef fsRef = node.getFSRef();
                    if (fsRef != null && !fsRef.isClosed() && OptionDialog.showYesNoDialog((Component)FSBActionManager.this.provider.getComponent(), (String)"Close File System", (String)("Do you want to close the filesystem browser for " + fsRef.getFilesystem().getName() + "?")) == 1) {
                        FSBActionManager.this.plugin.removeFileSystemBrowser(fsRef.getFilesystem().getFSRL());
                        this.setEnabled(false);
                    }
                } else {
                    FSBActionManager.this.gTree.runTask(monitor -> {
                        int indexInParent = node.getIndexInParent();
                        GTreeNode parent = node.getParent();
                        parent.removeNode((GTreeNode)node);
                        FSBFileNode prevNode = node.getPrevNode();
                        parent.addNode(indexInParent, (GTreeNode)prevNode);
                        node.dispose();
                    });
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !FSBActionManager.this.gTree.isBusy() && context.getContextObject() instanceof FSBRootNode;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.CLOSE, "ZZZZ"));
        action.setDescription(action.getMenuText());
        action.setToolBarData(new ToolBarData((Icon)ImageManager.CLOSE, "ZZZZ"));
        action.setEnabled(false);
        return action;
    }

    private DockingAction createImportAction() {
        FSBAction action = new FSBAction("Import Single", "Import", this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBActionManager.this.getLoadableFSRLFromContext(context);
                if (fsrl == null) {
                    return;
                }
                String treePath = FSBActionManager.this.getFormattedTreePath(context);
                String suggestedPath = FilenameUtils.getFullPathNoEndSeparator((String)treePath).replaceAll(":/", "/");
                PluginTool tool = FSBActionManager.this.plugin.getTool();
                ProgramManager pm = FSBUtils.getProgramManager(tool, false);
                ImporterUtilities.showImportDialog(tool, pm, fsrl, null, suggestedPath);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !FSBActionManager.this.gTree.isBusy() && FSBActionManager.this.getLoadableFSRLFromContext(context) != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.IMPORT, "F", -1, "A"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createBatchImportAction() {
        FSBAction action = new FSBAction("Import Batch", "Batch Import", this.plugin){

            public void actionPerformed(ActionContext context) {
                List<FSRL> files = FSBActionManager.this.getFSRLsFromContext(context, true);
                if (files.isEmpty()) {
                    return;
                }
                boolean allDirs = FSBActionManager.this.isSelectedContextAllDirs(context);
                if (files.size() > 1 && !allDirs) {
                    files = FSBActionManager.this.getFileFSRLsFromContext(context);
                }
                BatchImportDialog.showAndImport(FSBActionManager.this.plugin.getTool(), null, files, null, FSBUtils.getProgramManager(FSBActionManager.this.plugin.getTool(), false));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !FSBActionManager.this.gTree.isBusy() && !FSBActionManager.this.getFSRLsFromContext(context, true).isEmpty();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.IMPORT, "F", -1, "B"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createOpenNestedFileSystemAction() {
        FSBAction action = new FSBAction("Open File System Nested", "Open File System", this.plugin){

            public void actionPerformed(ActionContext context) {
                FSRL containerFSRL = FSBUtils.getFileFSRLFromContext(context);
                if (containerFSRL != null && context.getContextObject() instanceof FSBFileNode) {
                    FSBFileNode fileNode = (FSBFileNode)context.getContextObject();
                    FSBActionManager.this.gTree.runTask(monitor -> {
                        try {
                            FileSystemRef fsRef = FileSystemService.getInstance().probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
                            if (fsRef == null) {
                                Msg.showWarn((Object)((Object)this), (Component)FSBActionManager.this.gTree, (String)"No File System Provider", (Object)("No file system provider for " + containerFSRL.getName()));
                                return;
                            }
                            FSBRootNode nestedRootNode = new FSBRootNode(fsRef, FSBActionManager.this.gTree, fileNode);
                            FSBRootNode containingFSBRootNode = FSBNode.findContainingFileSystemFSBRootNode(fileNode);
                            if (containingFSBRootNode != null) {
                                containingFSBRootNode.getSubRootNodes().add(nestedRootNode);
                            }
                            nestedRootNode.setChildren(nestedRootNode.generateChildren(monitor));
                            int indexInParent = fileNode.getIndexInParent();
                            GTreeNode parent = fileNode.getParent();
                            parent.removeNode((GTreeNode)fileNode);
                            parent.addNode(indexInParent, (GTreeNode)nestedRootNode);
                            FSBActionManager.this.gTree.expandPath((GTreeNode)nestedRootNode);
                        }
                        catch (CancelledException | IOException e) {
                            FSUtilities.displayException((Object)this, (Component)FSBActionManager.this.gTree, "Error Opening FileSystem", e.getMessage(), e);
                        }
                    });
                }
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                FSRL containerFSRL = FSBUtils.getFileFSRLFromContext(context);
                return !FSBActionManager.this.gTree.isBusy() && containerFSRL != null && context.getContextObject() instanceof FSBFileNode;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.OPEN_FILE_SYSTEM, "C"));
        action.setEnabled(true);
        return action;
    }
}

