/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;

public abstract class AddressPreviewTableModel
extends AddressBasedTableModel<Address> {
    private int selectionSize = 1;

    protected AddressPreviewTableModel(String modelName, ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        this(modelName, serviceProvider, program, monitor, false);
    }

    protected AddressPreviewTableModel(String modelName, ServiceProvider serviceProvider, Program program, TaskMonitor monitor, boolean loadIncrementally) {
        super(modelName, serviceProvider, program, monitor, loadIncrementally);
    }

    public void setSelectionSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Selection size must be at least 1; found size " + size);
        }
        this.selectionSize = size;
    }

    @Override
    public Address getAddress(int row) {
        return (Address)this.getRowObject(row);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        if (this.selectionSize == 1) {
            return super.getProgramSelection(rows);
        }
        int addOn = this.selectionSize - 1;
        AddressSet addressSet = new AddressSet();
        for (int element : rows) {
            Address minAddr;
            Address maxAddr = minAddr = this.getAddress(element);
            try {
                maxAddr = minAddr.addNoWrap((long)addOn);
                addressSet.addRange(minAddr, maxAddr);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

