/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.renderer;

import com.google.common.base.Function;
import functioncalls.graph.FcgEdge;
import java.awt.Color;
import java.awt.Paint;

public class FcgEdgePaintTransformer
implements Function<FcgEdge, Paint> {
    private Color directColor;
    private Color indirectColor;
    private Color[] directColorWithAlpha = new Color[10];

    public FcgEdgePaintTransformer(Color directColor, Color indirectColor) {
        this.directColor = directColor;
        this.indirectColor = indirectColor;
        this.directColorWithAlpha = this.alphatize(directColor);
    }

    private Color[] alphatize(Color c) {
        Color[] alphad = new Color[10];
        alphad[0] = c;
        for (int i = 1; i < 10; ++i) {
            double newAlpha = 255.0 - (double)i * 25.5;
            alphad[i] = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)newAlpha);
        }
        return alphad;
    }

    public Paint apply(FcgEdge e) {
        if (e.isDirectEdge()) {
            return this.getDirectEdgeColor(e);
        }
        return this.indirectColor;
    }

    private Color getDirectEdgeColor(FcgEdge e) {
        return this.directColor;
    }
}

