/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.io;

import java.io.IOException;
import java.io.InputStream;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class RandomAccessInputStream
extends InputStream {
    private final SynchronizedRandomAccessStream ras;
    private long streamPos;
    private final long endPos;

    public RandomAccessInputStream(SynchronizedRandomAccessStream ras, long offset, long length) {
        try {
            long rasLength = ras.length();
            if (length == -1L) {
                length = rasLength;
            }
            if (offset > rasLength || offset < 0L) {
                throw new IllegalArgumentException("offset out of bounds (offset=" + offset + " length=" + length + ")");
            }
            if (length > rasLength - offset || length < 0L) {
                throw new IllegalArgumentException("length out of bounds (offset=" + offset + " length=" + length + ")");
            }
            this.ras = ras;
            this.streamPos = offset;
            this.endPos = offset + length;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RandomAccessInputStream(SynchronizedRandomAccessStream ras) {
        this(ras, 0L, -1L);
    }

    public int available() throws IOException {
        long remaining = this.endPos - this.streamPos;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (remaining < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)remaining;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int res = this.read(tmp, 0, 1);
        if (res == 1) {
            return tmp[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int bytesToRead = (int)(this.streamPos + (long)len > this.endPos ? this.endPos - this.streamPos : (long)len);
            if (bytesToRead == 0) {
                return -1;
            }
            int res = this.ras.readFrom(this.streamPos, b, off, bytesToRead);
            if (res > 0) {
                this.streamPos += (long)res;
            }
            return res;
        }
        catch (RuntimeIOException ex) {
            IOException ioe = ex.getIOCause();
            if (ioe != null) {
                ex.printStackTrace();
                throw ioe;
            }
            throw ex;
        }
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public long skip(long n) throws IOException {
        try {
            long res = this.ras.skipFrom(this.streamPos, n);
            if (res > 0L) {
                this.streamPos += res;
            }
            return res;
        }
        catch (RuntimeIOException ex) {
            IOException ioe = ex.getIOCause();
            if (ioe != null) {
                ex.printStackTrace();
                throw ioe;
            }
            throw ex;
        }
    }
}

