/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import generic.concurrent.GThreadPool;
import generic.util.WindowUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.TaskUtilities;
import ghidra.util.task.BasicTaskMonitor;
import ghidra.util.task.Task;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

class TaskRunner {
    private Task task;
    private Component parent;
    private int delayMs;
    private int dialogWidth;
    private TaskDialog taskDialog;
    private CountDownLatch finished = new CountDownLatch(1);

    TaskRunner(Task task, Component parent, int delayMs, int dialogWidth) {
        this.task = task;
        this.parent = parent;
        this.delayMs = delayMs;
        this.dialogWidth = dialogWidth;
    }

    void run() {
        BasicTaskMonitor internalMonitor = new BasicTaskMonitor();
        WrappingTaskMonitor monitor = new WrappingTaskMonitor((TaskMonitor)internalMonitor);
        this.startTaskThread((TaskMonitor)monitor);
        Swing.runIfSwingOrRunLater(() -> this.showTaskDialog(monitor));
        this.waitForModalTask();
    }

    private void waitForModalTask() {
        if (!this.task.isModal()) {
            return;
        }
        try {
            this.finished.await();
        }
        catch (InterruptedException e) {
            Msg.debug((Object)this, (Object)"Task Launcher unexpectedly interrupted waiting for task thread", (Throwable)e);
        }
    }

    protected TaskDialog buildTaskDialog(Component comp, TaskMonitor monitor) {
        TaskDialog dialog = this.createTaskDialog(comp);
        dialog.setMinimumSize(this.dialogWidth, 0);
        dialog.setStatusJustification(this.task.getStatusTextAlignment());
        return dialog;
    }

    private void startTaskThread(TaskMonitor monitor) {
        TaskUtilities.addTrackedTask((Task)this.task, (TaskMonitor)monitor);
        String name = "Task - " + this.task.getTaskTitle();
        GThreadPool pool = GThreadPool.getSharedThreadPool((String)"GSwing Worker");
        Executor executor = pool.getExecutor();
        executor.execute(() -> {
            Thread.currentThread().setName(name);
            try {
                this.task.monitoredRun(monitor);
            }
            finally {
                this.taskFinished();
            }
        });
    }

    private TaskDialog createTaskDialog(Component comp) {
        Component centerOverComponent = comp;
        Component currentParent = centerOverComponent;
        if (currentParent != null) {
            currentParent = WindowUtilities.windowForComponent((Component)comp);
        }
        if (currentParent == null) {
            centerOverComponent = null;
        }
        return new TaskDialog(centerOverComponent, this.task){

            @Override
            public synchronized boolean isCompleted() {
                return super.isCompleted() || TaskRunner.this.isFinished();
            }
        };
    }

    private void showTaskDialog(WrappingTaskMonitor monitor) {
        Swing.assertThisIsTheSwingThread((String)"Must be on the Swing thread build the Task Dialog");
        this.taskDialog = this.buildTaskDialog(this.parent, (TaskMonitor)monitor);
        monitor.setDelegate((TaskMonitor)this.taskDialog);
        this.taskDialog.show(Math.max(this.delayMs, 0));
    }

    boolean isFinished() {
        return this.finished.getCount() == 0L;
    }

    private void taskFinished() {
        this.finished.countDown();
        Swing.runLater(() -> {
            if (this.taskDialog != null) {
                this.taskDialog.taskProcessed();
            }
        });
    }
}

