/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Field;
import db.buffers.DataBuffer;
import java.io.IOException;

class IndexBuffer {
    private static final int FIELD_TYPE_SIZE = 1;
    private static final int KEY_COUNT_SIZE = 4;
    private static final int FIELD_TYPE_OFFSET = 0;
    private static final int KEY_COUNT_OFFSET = 1;
    static final int INDEX_HEADER_SIZE = 5;
    static final int PRIMARY_KEY_SIZE = 8;
    Field indexKey;
    int keyCount;
    IndexDataBuffer dataBuffer;

    IndexBuffer(Field indexKey, byte[] data) throws IOException {
        this.indexKey = indexKey;
        if (data == null) {
            this.dataBuffer = new IndexDataBuffer(5);
            this.dataBuffer.putByte(0, indexKey.getFieldType());
            this.dataBuffer.putInt(1, 0);
        } else {
            if (data[0] != indexKey.getFieldType()) {
                throw new IOException("Invalid index data");
            }
            this.dataBuffer = new IndexDataBuffer(data);
        }
        this.keyCount = this.dataBuffer.getInt(1);
    }

    Field getIndexKey() {
        return this.indexKey;
    }

    private void setKeyCount(int cnt) {
        this.keyCount = cnt;
        this.dataBuffer.putInt(1, this.keyCount);
    }

    byte[] getData() {
        byte[] data = this.dataBuffer.getData();
        if (data.length <= 5) {
            return null;
        }
        return data;
    }

    long getPrimaryKey(int index) {
        return this.dataBuffer.getLong(5 + index * 8);
    }

    int getIndex(long primaryKey) {
        return this.getKeyIndex(primaryKey);
    }

    private int getKeyIndex(long primaryKey) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            long k = this.getPrimaryKey(i);
            if (k == primaryKey) {
                return i;
            }
            if (k < primaryKey) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    void addEntry(long primaryKey) {
        int index = this.getKeyIndex(primaryKey);
        if (index < 0) {
            index = -index - 1;
            IndexDataBuffer newDataBuffer = new IndexDataBuffer(this.dataBuffer.length() + 8);
            int len = 5 + index * 8;
            newDataBuffer.copy(0, this.dataBuffer, 0, len);
            newDataBuffer.copy(len + 8, this.dataBuffer, len, this.dataBuffer.length() - len);
            newDataBuffer.putLong(len, primaryKey);
            this.dataBuffer = newDataBuffer;
            this.setKeyCount(this.keyCount + 1);
        }
    }

    void deleteEntry(long primaryKey) {
        int index = this.getKeyIndex(primaryKey);
        if (index >= 0) {
            IndexDataBuffer newDataBuffer = new IndexDataBuffer(this.dataBuffer.length() - 8);
            int len = 5 + index * 8;
            newDataBuffer.copy(0, this.dataBuffer, 0, len);
            newDataBuffer.copy(len, this.dataBuffer, len + 8, this.dataBuffer.length() - len - 8);
            this.dataBuffer = newDataBuffer;
            this.setKeyCount(this.keyCount - 1);
        }
    }

    long[] getPrimaryKeys() {
        long[] keys = new long[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            keys[i] = this.getPrimaryKey(i);
        }
        return keys;
    }

    class IndexDataBuffer
    extends DataBuffer {
        IndexDataBuffer(byte[] data) {
            super(data);
        }

        IndexDataBuffer(int size) {
            super(size);
        }

        @Override
        protected byte[] getData() {
            return this.data;
        }

        @Override
        protected void setData(byte[] data) {
            this.data = data;
        }
    }
}

