/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisState;
import ghidra.app.plugin.core.analysis.AnalysisStateInfo;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;

public class PdbAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "PDB";
    private static final String DESCRIPTION = "Automatically loads a PDB file if found.";
    private static final String ERROR_TITLE = "Error in PDB Analyzer";
    private static final String SYMBOLPATH_OPTION_NAME = "Symbol Repository Path";
    private static final String SYMBOLPATH_OPTION_DESCRIPTION = "Directory path to root of Microsoft Symbol Repository Directory";
    private static final String SYMBOLPATH_OPTION_DEFAULT_VALUE = "C:\\Symbols";
    private String symbolsRepositoryPath = "C:\\Symbols";
    private static final String OPTION_NAME_INCLUDE_PE_PDB_PATH = "Unsafe: Include PE PDB Path in PDB Search";
    private static final String OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH = "If checked, specifically searching for PDB in PE-Header-Specified Location.";
    private boolean includePeSpecifiedPdbPath = false;

    public PdbAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        if (PdbParser.isAlreadyLoaded(program)) {
            return true;
        }
        File pdb = this.lookForPdb(program, this.includePeSpecifiedPdbPath, log);
        if (pdb == null) {
            return false;
        }
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)program);
        return this.parsePdb(pdb, program, mgr, monitor, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File lookForPdb(Program program, boolean includePeSpecifiedPdbPath, MessageLog log) {
        Object message = "";
        try {
            Object missingState;
            File pdb = PdbParser.findPDB(program, includePeSpecifiedPdbPath, this.symbolsRepositoryPath);
            if (pdb == null) {
                missingState = (PdbMissingState)AnalysisStateInfo.getAnalysisState((Program)program, PdbMissingState.class);
                if (missingState != null) {
                    File file = null;
                    return file;
                }
                AnalysisStateInfo.putAnalysisState((Program)program, (AnalysisState)new PdbMissingState());
                String pdbName = program.getOptions("Program Information").getString("PDB File", (String)null);
                message = pdbName == null ? "Program has no associated PDB file." : "Unable to locate PDB file \"" + pdbName + "\" with matching GUID.";
                message = SystemUtilities.isInHeadlessMode() ? (String)message + "\n Use a script to set the PDB file location. I.e.,\n    setAnalysisOption(currentProgram, \"PDB.Symbol Repository Path\", \"/path/to/pdb/folder\");\n This must be done using a pre-script (prior to analysis)." : (String)message + "\n You may set the PDB \"Symbol Repository Path\"\n using \"Edit->Options for [program]\" prior to analysis.\nIt is important that a PDB is used during initial analysis \nif available.";
            }
            missingState = pdb;
            return missingState;
        }
        catch (PdbException pe) {
            message = (String)message + pe.getMessage();
        }
        finally {
            if (((String)message).length() > 0) {
                log.appendMsg(this.getName(), (String)message);
                log.setStatus((String)message);
            }
        }
        return null;
    }

    boolean parsePdb(File pdb, Program program, AutoAnalysisManager mgr, TaskMonitor monitor, MessageLog log) {
        DataTypeManagerService dataTypeManagerService = mgr.getDataTypeManagerService();
        PdbParser parser = new PdbParser(pdb, program, dataTypeManagerService, true, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (PdbException e) {
            String message = e.getMessage();
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        catch (CancelledException e) {
            return false;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)((Object)this), null, (String)ERROR_TITLE, (Object)msg, (Throwable)e);
            return false;
        }
    }

    public boolean canAnalyze(Program program) {
        return "Portable Executable (PE)".equals(program.getExecutableFormat());
    }

    public void registerOptions(Options options, Program program) {
        String pdbStorageLocation = Preferences.getProperty((String)"PDB Storage Directory", null, (boolean)true);
        if (pdbStorageLocation != null) {
            File pdbDirectory = new File(pdbStorageLocation);
            if (pdbDirectory.isDirectory()) {
                options.registerOption(SYMBOLPATH_OPTION_NAME, (Object)pdbStorageLocation, null, SYMBOLPATH_OPTION_DESCRIPTION);
            }
        } else {
            options.registerOption(SYMBOLPATH_OPTION_NAME, (Object)SYMBOLPATH_OPTION_DEFAULT_VALUE, null, SYMBOLPATH_OPTION_DESCRIPTION);
        }
        options.registerOption(OPTION_NAME_INCLUDE_PE_PDB_PATH, (Object)this.includePeSpecifiedPdbPath, null, OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH);
    }

    public void optionsChanged(Options options, Program program) {
        String symbolPath = options.getString(SYMBOLPATH_OPTION_NAME, SYMBOLPATH_OPTION_DEFAULT_VALUE);
        this.setSymbolsRepositoryPath(symbolPath);
        Preferences.setProperty((String)"PDB Storage Directory", (String)symbolPath);
        Preferences.store();
        this.includePeSpecifiedPdbPath = options.getBoolean(OPTION_NAME_INCLUDE_PE_PDB_PATH, this.includePeSpecifiedPdbPath);
    }

    public void setSymbolsRepositoryPath(String symbolPath) {
        this.symbolsRepositoryPath = symbolPath;
    }

    private static class PdbMissingState
    implements AnalysisState {
        private PdbMissingState() {
        }
    }
}

