/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.bean;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanSerializer;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.properties.FontProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformOptionsProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultBeanSerializer
implements BeanSerializer {
    private static HashMap m_default_beans = new HashMap();
    private static LookAndFeel m_look_and_feel = null;
    private static HashSet m_supported_properties = new HashSet();

    private boolean areDifferent(Object object, Object object2) {
        boolean bl = true;
        if (object != null) {
            if (object2 != null) {
                bl = object != object2 && !object.equals(object2) && !object2.equals(object);
            }
        } else {
            bl = object2 == null ? false : object2 != object && !object2.equals(object);
        }
        return bl;
    }

    private JETABean getDefaultBean(Class clazz) {
        JETABean jETABean;
        if (DefaultBeanSerializer.isLookAndFeelChanged()) {
            m_default_beans.clear();
        }
        if ((jETABean = (JETABean)m_default_beans.get(clazz)) == null) {
            try {
                jETABean = JETABeanFactory.createBean(clazz.getName(), null, true, false);
                if (jETABean == null) {
                    Component component = (Component)clazz.newInstance();
                    jETABean = new JETABean(component);
                }
                m_default_beans.put(clazz, jETABean);
            }
            catch (Exception exception) {
                FormsLogger.severe(exception);
            }
        }
        return jETABean;
    }

    private static boolean isLookAndFeelChanged() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (m_look_and_feel != lookAndFeel) {
            m_look_and_feel = lookAndFeel;
            return true;
        }
        return false;
    }

    protected boolean isPropertySerializable(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (object instanceof JETAProperty) {
            JETAProperty jETAProperty = (JETAProperty)object;
            if (jETAProperty instanceof TransformOptionsProperty) {
                return true;
            }
            return !jETAProperty.isTransient();
        }
        if (m_supported_properties.contains(clazz)) {
            return true;
        }
        return object instanceof Color || object instanceof Font || object instanceof String || object instanceof Calendar || object instanceof Date;
    }

    public PropertiesMemento writeBean(JETABean jETABean) throws FormException {
        try {
            Object[] objectArray = new Object[]{};
            PropertiesMemento propertiesMemento = new PropertiesMemento();
            Component component = jETABean.getDelegate();
            if (component != null) {
                propertiesMemento.setBeanClassName(component.getClass().getName());
                JETABean jETABean2 = this.getDefaultBean(component.getClass());
                if (jETABean2 != null) {
                    Collection collection = jETABean.getPropertyDescriptors();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        JETAPropertyDescriptor jETAPropertyDescriptor = (JETAPropertyDescriptor)iterator.next();
                        try {
                            Object object;
                            Object object2 = jETAPropertyDescriptor.getPropertyValue(jETABean2);
                            if (!this.areDifferent(object2, object = jETAPropertyDescriptor.getPropertyValue(jETABean)) || !this.isPropertySerializable(object) || !(object instanceof Serializable)) continue;
                            if (object instanceof Font) {
                                propertiesMemento.addProperty(jETAPropertyDescriptor.getName(), new FontProperty((Font)object));
                                continue;
                            }
                            if (object instanceof Color) {
                                propertiesMemento.addProperty(jETAPropertyDescriptor.getName(), new ColorHolder((Color)object));
                                continue;
                            }
                            if (object instanceof TransformOptionsProperty) {
                                propertiesMemento.addProperty(jETAPropertyDescriptor.getName(), new Integer(((TransformOptionsProperty)object).getPropertyValue()));
                                continue;
                            }
                            propertiesMemento.addProperty(jETAPropertyDescriptor.getName(), (Serializable)object);
                        }
                        catch (Exception exception) {
                            FormsLogger.severe(exception);
                        }
                    }
                    try {
                        propertiesMemento.addProperty("name", (Serializable)((Object)component.getName()));
                    }
                    catch (Exception exception) {
                        FormsLogger.severe(exception);
                    }
                }
            }
            return propertiesMemento;
        }
        catch (Exception exception) {
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    public void writeBean(OutputStream outputStream, JETABean jETABean) throws FormException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this.writeBean(jETABean));
        }
        catch (Exception exception) {
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    static {
        m_supported_properties.add(Color.class);
        m_supported_properties.add(Font.class);
        m_supported_properties.add(String.class);
        m_supported_properties.add(Calendar.class);
        m_supported_properties.add(Date.class);
        m_supported_properties.add(Boolean.class);
        m_supported_properties.add(Byte.class);
        m_supported_properties.add(Character.class);
        m_supported_properties.add(Short.class);
        m_supported_properties.add(Integer.class);
        m_supported_properties.add(Long.class);
        m_supported_properties.add(Float.class);
        m_supported_properties.add(Double.class);
    }
}

