/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.impl.MarkupItemStorage;
import ghidra.feature.vt.api.impl.MarkupItemStorageImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemDestinationAddressEditStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.markuptype.DataTypeMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionEntryPointBasedAbstractMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.Collection;

public class MarkupItemImpl
implements VTMarkupItem {
    private VTMarkupType markupType;
    private MarkupItemStorage markupItemStorage;
    private Stringable cachedSourceValue;
    private Stringable cachedDestinationValue;
    private Stringable cachedOriginalDestinationValue;
    private long sourceModificationNumber;
    private long destinationModificationNumber;
    private Boolean hasSameValues;
    private static boolean isUnApplyingItems = false;
    private static boolean gettingStatus = false;

    public MarkupItemImpl(VTAssociation association, VTMarkupType markupType, Address sourceAddress) {
        this(new MarkupItemStorageImpl(association, markupType, sourceAddress));
    }

    public MarkupItemImpl(MarkupItemStorage markupItem) {
        this.markupItemStorage = markupItem;
        this.markupType = markupItem.getMarkupType();
    }

    @Override
    public void setDefaultDestinationAddress(Address address, String addressSource) {
        this.doSetDestinationAddress(address, addressSource, true);
    }

    @Override
    public void setDestinationAddress(Address destinationAddress) {
        this.doSetDestinationAddress(destinationAddress, "User Defined", false);
    }

    private void doSetDestinationAddress(Address address, String addressSource, boolean isDefault) {
        if (this.canUnapply()) {
            throw new IllegalStateException("Can't set destination address on applied markup item");
        }
        if (address == null) {
            addressSource = null;
        }
        this.cachedDestinationValue = null;
        this.cachedOriginalDestinationValue = null;
        Address oldDestinationAddress = this.markupItemStorage.getDestinationAddress();
        String oldAddressSource = this.markupItemStorage.getDestinationAddressSource();
        boolean isResettingAddress = "User Defined".equals(oldAddressSource) && !"User Defined".equals(addressSource);
        address = this.markupType.validateDestinationAddress(this.markupItemStorage.getAssociation(), this.markupItemStorage.getSourceAddress(), address);
        if (SystemUtilities.isEqual((Object)address, (Object)oldDestinationAddress)) {
            return;
        }
        this.markupItemStorage = this.markupItemStorage.setDestinationAddress(address, addressSource);
        this.markupItemStorage = this.maybeReset();
        this.hasSameValues = null;
        if (isDefault && !isResettingAddress) {
            return;
        }
        VTAssociation association = this.markupItemStorage.getAssociation();
        VTSessionDB session = (VTSessionDB)association.getSession();
        session.setObjectChanged(1031, this, oldDestinationAddress, address);
    }

    @Override
    public VTMarkupType getMarkupType() {
        return this.markupItemStorage.getMarkupType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VTMarkupItemStatus getStatus() {
        this.validateDestinationCache();
        VTMarkupItemStatus status = this.markupItemStorage.getStatus();
        if (status == VTMarkupItemStatus.UNAPPLIED) {
            if (!gettingStatus) {
                try {
                    gettingStatus = true;
                    boolean conflictsWithOtherMarkup = this.getMarkupType().conflictsWithOtherMarkup(this, this.getAssociation().getMarkupItems(TaskMonitorAdapter.DUMMY_MONITOR));
                    if (conflictsWithOtherMarkup) {
                        VTMarkupItemStatus vTMarkupItemStatus = VTMarkupItemStatus.CONFLICT;
                        return vTMarkupItemStatus;
                    }
                }
                catch (CancelledException cancelledException) {
                }
                finally {
                    gettingStatus = false;
                }
            }
            if (this.hasSameSourceDestinationValues()) {
                return VTMarkupItemStatus.SAME;
            }
        }
        return status;
    }

    private boolean hasSameSourceDestinationValues() {
        if (this.hasSameValues == null) {
            this.hasSameValues = this.getMarkupType().hasSameSourceAndDestinationValues(this);
        }
        return this.hasSameValues;
    }

    @Override
    public void setConsidered(VTMarkupItemConsideredStatus consideredStatus) {
        if (this.canUnapply()) {
            throw new IllegalArgumentException("Cannot set an applied item to considered.");
        }
        VTMarkupItemStatus oldStatus = this.markupItemStorage.getStatus();
        this.markupItemStorage = this.markupItemStorage.setStatus(consideredStatus.getMarkupItemStatus());
        this.markupItemStorage = this.maybeReset();
        VTMarkupItemStatus newStatus = this.markupItemStorage.getStatus();
        if (oldStatus != newStatus) {
            this.fireMarkupItemStatusChanged(oldStatus, newStatus);
        }
    }

    @Override
    public void apply(VTMarkupItemApplyActionType applyType, ToolOptions options) throws VersionTrackingApplyException {
        VTMarkupItemStatus oldStatus;
        if (applyType == null) {
            throw new IllegalArgumentException("Apply action type cannot be null!");
        }
        if (this.getAssociation().getStatus() != VTAssociationStatus.ACCEPTED) {
            throw new VersionTrackingApplyException("Can't apply a markup item for a match that is not accepted.");
        }
        if (options == null) {
            options = new ToolOptions("VT Options Default");
        }
        VTMarkupItemStatus newStatus = oldStatus = this.markupItemStorage.getStatus();
        if (this.getDestinationAddress() == null) {
            this.markupItemStorage = this.markupItemStorage.setApplyFailed("Can't apply without a valid destination");
            this.fireMarkupItemStatusChanged(oldStatus, VTMarkupItemStatus.FAILED_APPLY);
            throw new VersionTrackingApplyException("Cannot apply a markup item without first setting the destination address");
        }
        if (!this.canApply()) {
            return;
        }
        VTAssociation association = this.markupItemStorage.getAssociation();
        Stringable sourceValue = this.markupType.getSourceValue(association, this.getSourceAddress());
        Stringable destinationValue = this.markupType.getOriginalDestinationValue(association, this.getDestinationAddress());
        this.markupItemStorage.setSourceDestinationValues(sourceValue, destinationValue);
        try {
            if (this.markupType.applyMarkup(this, options)) {
                newStatus = applyType.getApplyStatus();
                this.markupItemStorage = this.markupItemStorage.setStatus(newStatus);
            }
        }
        catch (VersionTrackingApplyException e) {
            newStatus = VTMarkupItemStatus.FAILED_APPLY;
            this.markupItemStorage = this.markupItemStorage.setApplyFailed(e.getMessage());
            throw e;
        }
        finally {
            if (oldStatus != newStatus) {
                this.fireMarkupItemStatusChanged(oldStatus, newStatus);
            }
        }
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType actionType) {
        return this.markupType.supportsApplyAction(actionType);
    }

    @Override
    public VTAssociation getAssociation() {
        return this.markupItemStorage.getAssociation();
    }

    @Override
    public ProgramLocation getSourceLocation() {
        return this.markupType.getSourceLocation(this.markupItemStorage.getAssociation(), this.markupItemStorage.getSourceAddress());
    }

    @Override
    public ProgramLocation getDestinationLocation() {
        return this.markupType.getDestinationLocation(this.markupItemStorage.getAssociation(), this.markupItemStorage.getDestinationAddress());
    }

    public String getDisplayName() {
        return this.markupType.getDisplayName();
    }

    @Override
    public String getStatusDescription() {
        return this.markupItemStorage.getStatusDescription();
    }

    public String toString() {
        return this.markupItemStorage.toString();
    }

    @Override
    public VTMarkupItemDestinationAddressEditStatus getDestinationAddressEditStatus() {
        VTMarkupType type = this.getMarkupType();
        if (type instanceof FunctionEntryPointBasedAbstractMarkupType) {
            return VTMarkupItemDestinationAddressEditStatus.UNEDITABLE_FUNCTION_ENTRY_POINT;
        }
        if (type instanceof DataTypeMarkupType) {
            return VTMarkupItemDestinationAddressEditStatus.UNEDITABLE_DATA_ADDRESS;
        }
        if (!this.getAssociation().getStatus().canApply()) {
            return VTMarkupItemDestinationAddressEditStatus.UNEDITABLE_UNAPPLIABLE_ASSOCIATION_STATUS;
        }
        VTMarkupItemStatus status = this.getStatus();
        if (!status.isAppliable() && status != VTMarkupItemStatus.SAME) {
            return VTMarkupItemDestinationAddressEditStatus.UNEDITABLE_UNAPPLIABLE_MARKUP_STATUS;
        }
        return VTMarkupItemDestinationAddressEditStatus.EDITABLE;
    }

    @Override
    public boolean canApply() {
        VTAssociation association = this.getAssociation();
        VTAssociationStatus associationStatus = association.getStatus();
        try {
            Collection<VTMarkupItem> markupItems = association.getMarkupItems(TaskMonitorAdapter.DUMMY_MONITOR);
            return associationStatus.canApply() && this.getStatus().isAppliable() && !this.markupType.conflictsWithOtherMarkup(this, markupItems);
        }
        catch (CancelledException e) {
            return false;
        }
    }

    @Override
    public boolean canUnapply() {
        return this.markupItemStorage.getStatus().isUnappliable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unapply() throws VersionTrackingApplyException {
        Address destinationAddress = this.markupItemStorage.getDestinationAddress();
        VTMarkupItemStatus oldStatus = this.markupItemStorage.getStatus();
        this.markupType.unapplyMarkup(this);
        this.markupItemStorage.setStatus(VTMarkupItemStatus.UNAPPLIED);
        this.markupItemStorage = this.maybeReset();
        VTMarkupItemStatus newStatus = this.markupItemStorage.getStatus();
        if (oldStatus != newStatus) {
            this.fireMarkupItemStatusChanged(oldStatus, newStatus);
        }
        if (isUnApplyingItems) {
            return;
        }
        try {
            isUnApplyingItems = true;
            VTAssociation association = this.markupItemStorage.getAssociation();
            try {
                Collection<VTMarkupItem> markupItems = association.getMarkupItems(TaskMonitorAdapter.DUMMY_MONITOR);
                for (VTMarkupItem currentMarkupItem : markupItems) {
                    Address itemDestination;
                    if (currentMarkupItem == this || currentMarkupItem.getMarkupType() != this.markupType || !currentMarkupItem.canUnapply() || !destinationAddress.equals((Object)(itemDestination = currentMarkupItem.getDestinationAddress()))) continue;
                    currentMarkupItem.unapply();
                }
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
        finally {
            isUnApplyingItems = false;
        }
        this.hasSameValues = null;
    }

    private MarkupItemStorage maybeReset() {
        VTMarkupItemStatus status = this.getStatus();
        if (!status.isDefault()) {
            return this.markupItemStorage;
        }
        String addressSource = this.getDestinationAddressSource();
        if ("User Defined".equals(addressSource)) {
            return this.markupItemStorage;
        }
        this.hasSameValues = null;
        return this.markupItemStorage.reset();
    }

    @Override
    public String getDestinationAddressSource() {
        return this.markupItemStorage.getDestinationAddressSource();
    }

    public boolean isStoredInDB() {
        return this.markupItemStorage instanceof DatabaseObject;
    }

    @Override
    public Stringable getCurrentDestinationValue() {
        this.validateDestinationCache();
        if (this.cachedDestinationValue == null) {
            this.cachedDestinationValue = this.markupType.getCurrentDestinationValue(this.markupItemStorage.getAssociation(), this.markupItemStorage.getDestinationAddress());
        }
        return this.cachedDestinationValue;
    }

    @Override
    public Stringable getOriginalDestinationValue() {
        Stringable destinationValue = this.markupItemStorage.getDestinationValue();
        if (destinationValue != null) {
            return destinationValue;
        }
        this.validateDestinationCache();
        if (this.cachedOriginalDestinationValue == null) {
            this.cachedOriginalDestinationValue = this.markupType.getOriginalDestinationValue(this.markupItemStorage.getAssociation(), this.markupItemStorage.getDestinationAddress());
        }
        return this.cachedOriginalDestinationValue;
    }

    @Override
    public Stringable getSourceValue() {
        Stringable sourceValue = this.markupItemStorage.getSourceValue();
        if (sourceValue != null) {
            return sourceValue;
        }
        this.validateSourceCache();
        if (this.cachedSourceValue == null) {
            this.cachedSourceValue = this.markupType.getSourceValue(this.markupItemStorage.getAssociation(), this.markupItemStorage.getSourceAddress());
        }
        return this.cachedSourceValue;
    }

    private void validateSourceCache() {
        long currentSourceModificationNumber = this.getSourceModificationNumber();
        if (this.sourceModificationNumber != currentSourceModificationNumber) {
            this.cachedSourceValue = null;
            this.sourceModificationNumber = currentSourceModificationNumber;
            this.hasSameValues = null;
        }
    }

    private void validateDestinationCache() {
        long currentDestinationModificationNumber = this.getDestinationModificationNumber();
        if (this.destinationModificationNumber != currentDestinationModificationNumber) {
            this.cachedDestinationValue = null;
            this.cachedOriginalDestinationValue = null;
            this.destinationModificationNumber = currentDestinationModificationNumber;
            this.hasSameValues = null;
        }
    }

    private long getSourceModificationNumber() {
        return this.markupItemStorage.getAssociation().getSession().getSourceProgram().getModificationNumber();
    }

    private long getDestinationModificationNumber() {
        return this.markupItemStorage.getAssociation().getSession().getDestinationProgram().getModificationNumber();
    }

    @Override
    public Address getDestinationAddress() {
        return this.markupItemStorage.getDestinationAddress();
    }

    @Override
    public Address getSourceAddress() {
        return this.markupItemStorage.getSourceAddress();
    }

    private void fireMarkupItemStatusChanged(VTMarkupItemStatus oldStatus, VTMarkupItemStatus newStatus) {
        VTAssociation association = this.markupItemStorage.getAssociation();
        if (!(association instanceof VTAssociationDB)) {
            return;
        }
        VTAssociationDB associationDB = (VTAssociationDB)association;
        associationDB.markupItemStatusChanged(this);
        VTSessionDB session = (VTSessionDB)association.getSession();
        session.setObjectChanged(1030, this.markupItemStorage, (Object)oldStatus, (Object)newStatus);
    }
}

