/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.markuptype.FunctionEntryPointBasedAbstractMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.FunctionNameStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class FunctionNameMarkupType
extends FunctionEntryPointBasedAbstractMarkupType {
    public static final VTMarkupType INSTANCE = new FunctionNameMarkupType();

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        String defaultFunctionName;
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return list;
        }
        Address sourceAddress = sourceFunction.getEntryPoint();
        String sourceFunctionName = sourceFunction.getName();
        if (sourceFunctionName.equals(defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)sourceAddress))) {
            return list;
        }
        MarkupItemImpl markupItemImpl = new MarkupItemImpl(association, this, sourceAddress);
        markupItemImpl.setDefaultDestinationAddress(association.getDestinationAddress(), "Function");
        list.add(markupItemImpl);
        return list;
    }

    private FunctionNameMarkupType() {
        super("Function Name");
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.ADD || applyAction == VTMarkupItemApplyActionType.ADD_AS_PRIMARY || applyAction == VTMarkupItemApplyActionType.REPLACE_DEFAULT_ONLY || applyAction == VTMarkupItemApplyActionType.REPLACE;
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        Function function = this.getSourceFunction(association);
        if (function == null) {
            return null;
        }
        Symbol symbol = function.getSymbol();
        return new FunctionNameStringable(symbol);
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        String currentName;
        if (!markupItem.canUnapply()) {
            throw new VersionTrackingApplyException("Attempted to unapply a non-applied markup item");
        }
        FunctionNameStringable sourceSymbolStringable = (FunctionNameStringable)markupItem.getSourceValue();
        Address destinationAddress = markupItem.getDestinationAddress();
        FunctionNameStringable destinationSymbolStringable = (FunctionNameStringable)markupItem.getOriginalDestinationValue();
        String destinationName = destinationSymbolStringable.getSymbolName();
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        Function destinationFunction = functionManager.getFunctionAt(destinationAddress);
        if (destinationFunction == null) {
            return;
        }
        Namespace destinationNamespace = destinationFunction.getParentNamespace();
        SymbolTable symbolTable = destinationProgram.getSymbolTable();
        Symbol desiredSymbol = symbolTable.getSymbol(destinationName, destinationAddress, destinationNamespace);
        if (desiredSymbol != null && desiredSymbol.getSymbolType() == SymbolType.LABEL) {
            SetLabelPrimaryCmd setLabelPrimaryCmd = new SetLabelPrimaryCmd(desiredSymbol.getAddress(), desiredSymbol.getName(), desiredSymbol.getParentNamespace());
            setLabelPrimaryCmd.applyTo((DomainObject)destinationProgram);
        }
        if ((currentName = destinationFunction.getName()).equals(destinationName)) {
            String sourceName = sourceSymbolStringable.getSymbolName();
            Symbol sourceAsLabel = symbolTable.getSymbol(sourceName, destinationAddress, destinationNamespace);
            if (sourceAsLabel != null) {
                sourceAsLabel.delete();
            }
            return;
        }
        try {
            destinationSymbolStringable.applyFunctionName(destinationProgram, destinationFunction);
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + destinationName, e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + destinationName, e);
        }
        catch (CircularDependencyException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + destinationName + " due to circular dependancy on namespaces", e);
        }
    }

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)markupOptions.getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        if (functionNameChoice == VTMatchApplyChoices.FunctionNameChoices.EXCLUDE) {
            throw new IllegalArgumentException("Can't apply " + markupItem.getMarkupType().getDisplayName() + " since it is excluded.");
        }
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destinationAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        Function destinationFunction = functionManager.getFunctionAt(destinationAddress);
        if (destinationFunction == null) {
            throw new VersionTrackingApplyException("Couldn't find destination function to apply a name.");
        }
        Symbol destinationSymbol = destinationFunction.getSymbol();
        if (functionNameChoice == VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY && destinationSymbol.getSource() != SourceType.DEFAULT) {
            return false;
        }
        FunctionNameStringable symbolStringable = (FunctionNameStringable)markupItem.getSourceValue();
        if (symbolStringable == null) {
            throw new VersionTrackingApplyException("Cannot apply function name.  The function from the source program no longer exists. Markup Item: " + markupItem);
        }
        if (symbolStringable.getSymbolSourceType() == SourceType.DEFAULT) {
            return false;
        }
        String name = symbolStringable.getSymbolName();
        try {
            boolean isPrimary;
            boolean bl = isPrimary = functionNameChoice == VTMatchApplyChoices.FunctionNameChoices.ADD_AS_PRIMARY;
            if (functionNameChoice == VTMatchApplyChoices.FunctionNameChoices.ADD || isPrimary) {
                if (destinationFunction.isExternal()) {
                    throw new VersionTrackingApplyException("Can't add the function name \"" + name + "\" to the external function \"" + destinationFunction.getName() + "\". External function names can only be replaced.");
                }
                symbolStringable.addFunctionName(destinationProgram, destinationFunction, isPrimary);
            } else {
                symbolStringable.applyFunctionName(destinationProgram, destinationFunction);
            }
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to a duplicate name", e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to invalid input", e);
        }
        catch (CircularDependencyException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to circular dependancy on namespaces", e);
        }
        return true;
    }

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destinationAddress) {
        Address defaultDestinationAddress = association.getDestinationAddress();
        FunctionNameFieldLocation functionNameLocation = this.getFunctionNameLocation(association, defaultDestinationAddress, false);
        if (functionNameLocation != null) {
            return functionNameLocation;
        }
        LabelFieldLocation labelLocation = this.getPrimaryLabelLocation(association, defaultDestinationAddress, false);
        if (labelLocation != null) {
            return labelLocation;
        }
        Program program = this.getDestinationProgram(association);
        return new AddressFieldLocation(program, defaultDestinationAddress);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        Address defaultSourceAddress = association.getSourceAddress();
        FunctionNameFieldLocation functionNameLocation = this.getFunctionNameLocation(association, defaultSourceAddress, true);
        if (functionNameLocation != null) {
            return functionNameLocation;
        }
        LabelFieldLocation labelLocation = this.getPrimaryLabelLocation(association, defaultSourceAddress, true);
        if (labelLocation != null) {
            return labelLocation;
        }
        Program program = this.getSourceProgram(association);
        return new AddressFieldLocation(program, defaultSourceAddress);
    }

    private FunctionNameFieldLocation getFunctionNameLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Function function = program.getFunctionManager().getFunctionContaining(address);
        if (function == null) {
            return null;
        }
        Address entryAddress = function.getEntryPoint();
        FunctionNameStringable value = (FunctionNameStringable)(isSource ? this.getSourceValue(association, address) : this.getCurrentDestinationValue(association, address));
        String name = value != null ? value.getSymbolName() : "";
        return new FunctionNameFieldLocation(program, entryAddress, name);
    }

    private LabelFieldLocation getPrimaryLabelLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Symbol primarySymbol = program.getSymbolTable().getPrimarySymbol(address);
        if (primarySymbol == null) {
            return null;
        }
        return new LabelFieldLocation(primarySymbol);
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destinationAddress) {
        Address expectedDestinationAddress = association.getDestinationAddress();
        if (expectedDestinationAddress.equals((Object)destinationAddress)) {
            Function function = this.getDestinationFunction(association);
            if (function == null) {
                return null;
            }
            String functionName = function.getName();
            Namespace namespace = function.getParentNamespace();
            Program program = this.getDestinationProgram(association);
            Address address = association.getDestinationAddress();
            SymbolTable symbolTable = program.getSymbolTable();
            Symbol symbol = symbolTable.getSymbol(functionName, address, namespace);
            return new FunctionNameStringable(symbol);
        }
        return null;
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)options.getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        switch (functionNameChoice) {
            case ADD: 
            case ADD_AS_PRIMARY: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case REPLACE_DEFAULT_ONLY: 
            case REPLACE_ALWAYS: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.ADD);
                break;
            }
            case ADD_AS_PRIMARY: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.ADD_AS_PRIMARY);
                break;
            }
            case REPLACE_DEFAULT_ONLY: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY);
                break;
            }
            case REPLACE: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS);
            }
        }
        return options;
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        VTAssociation association = markupItem.getAssociation();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return false;
        }
        String sourceName = sourceFunction.getName();
        String destinationName = destinationFunction.getName();
        return sourceName.equals(destinationName);
    }
}

