/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DisplayStringProvider;
import docking.widgets.table.GTable;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.util.AbstractTextFilter;

public class AllTextFilter<T>
extends AbstractTextFilter<T> {
    private final ThreadedTableModel<T, ?> model;

    public AllTextFilter(VTController controller, GTable table, ThreadedTableModel<T, ?> model) {
        super(controller, table, "Filter");
        this.model = model;
    }

    @Override
    protected Filter<T> createEmptyCopy() {
        return new AllTextFilter<T>(this.controller, this.table, this.model);
    }

    @Override
    public boolean passesFilter(T t) {
        String filterText = this.getTextFieldText();
        if (filterText == null || filterText.trim().length() == 0) {
            return true;
        }
        filterText = filterText.toLowerCase();
        int columnCount = this.table.getColumnCount();
        for (int column = 0; column < columnCount; ++column) {
            String displayString;
            DisplayStringProvider displayable;
            String displayString2;
            int modelColumn = this.table.convertColumnIndexToModel(column);
            Object value = this.model.getColumnValueForRow(t, modelColumn);
            if (value == null) continue;
            if (value instanceof DisplayStringProvider && (displayString2 = (displayable = (DisplayStringProvider)value).getDisplayString()) != null && (displayString2 = displayString2.toLowerCase()).indexOf(filterText) != -1) {
                return true;
            }
            if (!this.isJavaDisplayableAsString(value) || (displayString = value.toString().toLowerCase()).indexOf(filterText) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaDisplayableAsString(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Character;
    }
}

