/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.CommentsDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class CommentsDBAdapterV0
extends CommentsDBAdapter {
    private static final int EOL_COMMENT_COLUMN = 0;
    private static final int PRE_COMMENT_COLUMN = 1;
    private static final int POST_COMMENT_COLUMN = 2;
    private static final int PLATE_COMMENT_COLUMN = 3;
    private static final String[] V0_NAMES = new String[4];
    private Table commentTable;
    private AddressMap addrMap;

    public CommentsDBAdapterV0(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.commentTable = handle.getTable("Comments");
        if (this.commentTable == null) {
            throw new VersionException("Missing Table: Comments");
        }
        if (this.commentTable.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    @Override
    public Record getRecord(long addr) throws IOException {
        return this.adaptRecord(this.commentTable.getRecord(addr));
    }

    @Override
    public Record createRecord(long addr, int commentCol, String comment) throws IOException {
        return null;
    }

    @Override
    public boolean deleteRecord(long addr) throws IOException {
        return false;
    }

    @Override
    public boolean deleteRecords(Address start, Address end) throws IOException {
        return false;
    }

    @Override
    public void updateRecord(Record commentRec) throws IOException {
    }

    @Override
    public AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, end, false);
    }

    @Override
    public AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    public RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        AddressKeyRecordIterator it = null;
        it = atStart ? new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, start, true) : new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, end, false);
        return new RecordIteratorAdapter(it);
    }

    @Override
    public RecordIterator getRecords(Address addr) throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.commentTable, this.addrMap, addr, true));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.commentTable, this.addrMap));
    }

    @Override
    public void putRecord(Record record) throws IOException {
    }

    @Override
    public int getRecordCount() throws IOException {
        return this.commentTable.getRecordCount();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    private Record adaptRecord(Record recV0) {
        if (recV0 == null) {
            return null;
        }
        Record record = COMMENTS_SCHEMA.createRecord(recV0.getKey());
        String comment = recV0.getString(0);
        if (comment != null) {
            record.setString(0, comment);
        }
        if ((comment = recV0.getString(1)) != null) {
            record.setString(1, comment);
        }
        if ((comment = recV0.getString(2)) != null) {
            record.setString(2, comment);
        }
        if ((comment = recV0.getString(3)) != null) {
            record.setString(3, comment);
        }
        return record;
    }

    static {
        CommentsDBAdapterV0.V0_NAMES[0] = "EOL";
        CommentsDBAdapterV0.V0_NAMES[1] = "Pre";
        CommentsDBAdapterV0.V0_NAMES[2] = "Post";
        CommentsDBAdapterV0.V0_NAMES[3] = "Plate";
    }

    class RecordIteratorAdapter
    implements RecordIterator {
        RecordIterator it;

        RecordIteratorAdapter(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            return false;
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public Record next() throws IOException {
            Record rec = this.it.next();
            return CommentsDBAdapterV0.this.adaptRecord(rec);
        }

        public Record previous() throws IOException {
            Record rec = this.it.previous();
            return CommentsDBAdapterV0.this.adaptRecord(rec);
        }
    }
}

