/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;
import java.io.InputStream;

class MemoryBlockInputStream
extends InputStream {
    private long index = 0L;
    private long resetIndex = 0L;
    private long numBytes = 0L;
    MemoryBlockDB block;

    MemoryBlockInputStream(MemoryBlockDB block) {
        this.block = block;
        this.numBytes = !block.isInitialized() ? 0L : (long)((int)block.getSize());
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.numBytes - this.index);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.resetIndex = this.index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.index = this.resetIndex;
    }

    @Override
    public long skip(long n) throws IOException {
        long numSkipped = Math.min(n, this.numBytes - this.index);
        this.index += numSkipped;
        return numSkipped;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.numBytes) {
            return -1;
        }
        try {
            return this.block.getByte(this.index++) & 0xFF;
        }
        catch (MemoryAccessException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.index >= this.numBytes) {
            return -1;
        }
        long remaining = this.numBytes - this.index;
        if (remaining < (long)len) {
            len = (int)remaining;
        }
        try {
            len = this.block.getBytes(this.index, b, off, len);
            this.index += (long)len;
            return len;
        }
        catch (MemoryAccessException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }
}

