/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldStackVariableDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class OldStackVariableDBAdapterV1
extends OldStackVariableDBAdapter {
    static final String STACK_VARS_TABLE_NAME = "Stack Variables";
    static final int SCHEMA_VERSION = 1;
    static final int V1_STACK_VAR_FUNCTION_KEY_COL = 0;
    static final int V1_STACK_VAR_OFFSET_COL = 1;
    static final int V1_STACK_VAR_DATA_TYPE_ID_COL = 2;
    static final int V1_STACK_VAR_NAME_COL = 3;
    static final int V1_STACK_VAR_COMMENT_COL = 4;
    static final int V1_STACK_VAR_DT_LENGTH_COL = 5;
    static final Schema V1_STACK_VARS_SCHEMA = new Schema(1, "Key", new Class[]{LongField.class, IntField.class, LongField.class, StringField.class, StringField.class, IntField.class}, new String[]{"Function ID", "Offset", "DataType ID", "Name", "Comment", "DataType Length"});
    private Table table;

    OldStackVariableDBAdapterV1(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        this.table = dbHandle.getTable(STACK_VARS_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Stack Variables");
        }
        if (this.table.getSchema().getVersion() != 1) {
            int version = this.table.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    public Record getStackVariableRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public long[] getStackVariableKeys(long functionKey) throws IOException {
        return this.table.findRecords((Field)new LongField(functionKey), 0);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(STACK_VARS_TABLE_NAME);
    }
}

