/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.Operator;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AddressEvaluator {
    private static final String TOKEN_CHARS = "+-*/()<>|^&~ ";

    public static Address evaluate(Program p, Address baseAddr, String s) {
        StringTokenizer parser = new StringTokenizer(s, TOKEN_CHARS, true);
        AddressFactory af = p.getAddressFactory();
        SymbolTable st = p.getSymbolTable();
        ArrayList<Object> list = new ArrayList<Object>();
        if (baseAddr != null) {
            list.add(baseAddr);
        }
        while (parser.hasMoreTokens()) {
            String tok = parser.nextToken();
            if (tok.equals(" ")) continue;
            Object obj = Operator.getOperator(tok);
            if (obj == null) {
                obj = AddressEvaluator.getValueObject(st, af, tok);
            }
            if (obj == null) {
                return null;
            }
            list.add(obj);
        }
        Object obj = AddressEvaluator.eval(list);
        if (obj instanceof Address) {
            return (Address)obj;
        }
        if (obj instanceof Long) {
            try {
                return af.getDefaultAddressSpace().getAddress((Long)obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long evaluateToLong(String s) {
        StringTokenizer parser = new StringTokenizer(s, TOKEN_CHARS, true);
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.hasMoreTokens()) {
            String tok = parser.nextToken();
            if (tok.equals(" ")) continue;
            Object obj = Operator.getOperator(tok);
            if (obj == null) {
                obj = AddressEvaluator.getValueObject(tok);
            }
            if (obj == null) {
                return null;
            }
            list.add(obj);
        }
        Object obj = AddressEvaluator.eval(list);
        if (obj instanceof Address) {
            return new Long(((Address)obj).getOffset());
        }
        if (obj instanceof Long) {
            try {
                return (Long)obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Address evaluate(Program p, String s) {
        return AddressEvaluator.evaluate(p, null, s);
    }

    public static Address evaluate(Program p, byte[] addrBytes) {
        boolean isBigEndian = p.getMemory().isBigEndian();
        int ptrSize = p.getDefaultPointerSize();
        int index = 0;
        long offset = 0L;
        if (addrBytes == null || addrBytes.length != ptrSize) {
            return null;
        }
        if (isBigEndian) {
            for (index = 0; index < addrBytes.length; ++index) {
                offset += (long)((addrBytes[index] & 0xFF) << (addrBytes.length - index - 1) * 8);
            }
        } else {
            for (index = addrBytes.length - 1; index >= 0; --index) {
                offset += (long)((addrBytes[index] & 0xFF) << index * 8);
            }
        }
        AddressSpace space = p.getAddressFactory().getDefaultAddressSpace();
        try {
            return space.getAddress(offset, true);
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    private static Object getValueObject(SymbolTable st, AddressFactory af, String tok) {
        try {
            return new Long(NumericUtilities.parseHexLong((String)tok));
        }
        catch (NumberFormatException numberFormatException) {
            Address address = af.getAddress(tok);
            if (address != null) {
                return address;
            }
            List<Symbol> globalSymbols = st.getLabelOrFunctionSymbols(tok, null);
            if (globalSymbols.size() == 1) {
                return globalSymbols.get(0).getAddress();
            }
            return null;
        }
    }

    private static Object getValueObject(String strValue) {
        try {
            int start = 0;
            int radix = 10;
            if (strValue.indexOf("0x") == 0) {
                start = 2;
                radix = 16;
            }
            strValue = strValue.endsWith("UL") ? strValue.substring(start, strValue.length() - 2) : (strValue.endsWith("L") || strValue.endsWith("l") || strValue.endsWith("U") ? strValue.substring(start, strValue.length() - 1) : strValue.substring(start));
            return radix == 10 ? new Long(NumericUtilities.parseLong((String)strValue)) : new Long(NumericUtilities.parseHexLong((String)strValue));
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static Object eval(List<Object> list) {
        Object obj;
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != Operator.LEFT_PAREN) continue;
                done = false;
                int end = AddressEvaluator.findMatchingParen(list, i);
                if (end < 0) {
                    return null;
                }
                Object obj2 = AddressEvaluator.eval(list.subList(i + 1, end));
                if (obj2 == null) {
                    return null;
                }
                list.subList(i, i + 2).clear();
                list.set(i, obj2);
            }
        }
        if (list.size() > 1 && list.get(0) == Operator.MINUS && (obj = list.get(1)) instanceof Long) {
            obj = new Long(-((Long)obj).longValue());
            list.remove(0);
            list.set(0, obj);
        }
        if (list.size() > 1 && list.get(0) == Operator.NOT && (obj = list.get(1)) instanceof Long) {
            obj = new Long((long)((Long)obj ^ 0xFFFFFFFFFFFFFFFFL));
            list.remove(0);
            list.set(0, obj);
        }
        if (list.size() > 3 && list.get(2) == Operator.NOT && (obj = list.get(3)) instanceof Long) {
            obj = new Long((long)((Long)obj ^ 0xFFFFFFFFFFFFFFFFL));
            list.remove(2);
            list.set(2, obj);
        }
        done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < list.size() - 1; ++i) {
                if ((list.get(i) != Operator.LEFTSHIFT || list.get(i + 1) != Operator.LEFTSHIFT) && (list.get(i) != Operator.RIGHTSHIFT || list.get(i + 1) != Operator.RIGHTSHIFT)) continue;
                done = false;
                if (i == 0 || i == list.size() - 2) {
                    return null;
                }
                Object value = AddressEvaluator.computeValue(list.get(i - 1), (Operator)list.get(i), list.get(i + 2));
                if (value == null) {
                    return null;
                }
                list.subList(i, i + 3).clear();
                list.set(i - 1, value);
            }
        }
        if (!AddressEvaluator.evaluateOperator(list, Operator.TIMES, Operator.DIVIDE)) {
            return null;
        }
        if (!AddressEvaluator.evaluateOperator(list, Operator.PLUS, Operator.MINUS)) {
            return null;
        }
        if (!AddressEvaluator.evaluateOperator(list, Operator.AND, null)) {
            return null;
        }
        if (!AddressEvaluator.evaluateOperator(list, Operator.XOR, null)) {
            return null;
        }
        if (!AddressEvaluator.evaluateOperator(list, Operator.OR, null)) {
            return null;
        }
        if (list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    private static boolean evaluateOperator(List<Object> list, Operator op1, Operator op2) {
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj != op1 && obj != op2) continue;
                done = false;
                if (i == 0 || i == list.size() - 1) {
                    return false;
                }
                Object value = AddressEvaluator.computeValue(list.get(i - 1), (Operator)obj, list.get(i + 1));
                if (value == null) {
                    return false;
                }
                list.subList(i, i + 2).clear();
                list.set(i - 1, value);
            }
        }
        return true;
    }

    private static Object computeValue(Object v1, Operator op, Object v2) {
        if (op == Operator.TIMES && v1 instanceof Long && v2 instanceof Long) {
            return new Long((Long)v1 * (Long)v2);
        }
        if (op == Operator.DIVIDE) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 / (Long)v2);
            }
        } else if (op == Operator.AND) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 & (Long)v2);
            }
        } else if (op == Operator.XOR) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 ^ (Long)v2);
            }
        } else if (op == Operator.OR) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 | (Long)v2);
            }
        } else if (op == Operator.LEFTSHIFT) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 << (int)((Long)v2).longValue());
            }
        } else if (op == Operator.RIGHTSHIFT) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 >> (int)((Long)v2).longValue());
            }
        } else if (op == Operator.PLUS) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 + (Long)v2);
            }
            if (v1 instanceof Address && v2 instanceof Long) {
                return ((Address)v1).addWrap((Long)v2);
            }
            if (v1 instanceof Long && v2 instanceof Address) {
                return ((Address)v2).addWrap((Long)v1);
            }
        } else if (op == Operator.NOT) {
            if (v2 instanceof Long) {
                return new Long((long)((Long)v2 ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (v2 instanceof Address) {
                return ((Address)v2).getNewAddress((long)((Long)v2 ^ 0xFFFFFFFFFFFFFFFFL));
            }
        } else if (op == Operator.MINUS) {
            if (v1 instanceof Long && v2 instanceof Long) {
                return new Long((Long)v1 - (Long)v2);
            }
            if (v1 instanceof Address && v2 instanceof Long) {
                return ((Address)v1).subtractWrap((Long)v2);
            }
            if (v1 instanceof Address && v2 instanceof Address) {
                return new Long(((Address)v1).subtract((Address)v2));
            }
        }
        return null;
    }

    private static int findMatchingParen(List<Object> list, int index) {
        int depth = 1;
        for (int j = index + 1; j < list.size(); ++j) {
            Object obj = list.get(j);
            if (obj == Operator.LEFT_PAREN) {
                ++depth;
                continue;
            }
            if (obj != Operator.RIGHT_PAREN || --depth != 0) continue;
            return j;
        }
        return -1;
    }
}

