/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Arrays;

public class RegisterFieldLocation
extends ProgramLocation {
    private String[] registerNames;
    private String[] registerStrings;

    public RegisterFieldLocation(Program program, Address addr, String[] registerNames, String[] registerStrings, int row, int charOffset) {
        super(program, addr, addr, null, null, row, 0, charOffset);
        this.registerNames = registerNames;
        this.registerStrings = registerStrings;
    }

    public RegisterFieldLocation() {
    }

    public String[] getRegisterStrings() {
        return this.registerStrings;
    }

    public Register getRegister() {
        if (this.getRow() < this.registerNames.length) {
            return this.program.getRegister(this.registerNames[this.getRow()]);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.registerNames);
        result = 31 * result + Arrays.hashCode(this.registerStrings);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterFieldLocation other = (RegisterFieldLocation)obj;
        if (!Arrays.equals(this.registerNames, other.registerNames)) {
            return false;
        }
        return Arrays.equals(this.registerStrings, other.registerStrings);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_Register_Names", this.registerNames);
        obj.putStrings("_Register_Strings", this.registerStrings);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.registerNames = obj.getStrings("_Register_Names", new String[0]);
        this.registerStrings = obj.getStrings("_Register_Strings", new String[0]);
    }
}

