/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import org.apache.jackrabbit.core.NodeId;

class LockToken {
    private final NodeId id;

    public LockToken(NodeId id) {
        this.id = id;
    }

    public NodeId getId() {
        return this.id;
    }

    public static LockToken parse(String s) throws IllegalArgumentException {
        int sep = s.lastIndexOf(45);
        if (sep == -1 || sep == s.length() - 1) {
            throw new IllegalArgumentException("Separator not found.");
        }
        String uuid = s.substring(0, sep);
        if (LockToken.getCheckDigit(uuid) != s.charAt(s.length() - 1)) {
            throw new IllegalArgumentException("Bad check digit.");
        }
        return new LockToken(NodeId.valueOf(uuid));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.id.toString());
        buf.append('-');
        buf.append(LockToken.getCheckDigit(this.id.toString()));
        return buf.toString();
    }

    private static char getCheckDigit(String uuid) {
        int result = 0;
        int multiplier = 36;
        for (int i = 0; i < uuid.length(); ++i) {
            int num;
            char c = uuid.charAt(i);
            if (c >= '0' && c <= '9') {
                num = c - 48;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                num = c - 65 + 10;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c < 'a' || c > 'f') continue;
            num = c - 97 + 10;
            result += multiplier * num;
            --multiplier;
        }
        int rem = result % 37;
        if (rem != 0) {
            rem = 37 - rem;
        }
        if (rem >= 0 && rem <= 9) {
            return (char)(48 + rem);
        }
        if (rem >= 10 && rem <= 35) {
            return (char)(65 + rem - 10);
        }
        return '+';
    }
}

