/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.security.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.core.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlManager
implements JackrabbitAccessControlManager {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractAccessControlManager.class);

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        return this.getPrivilegeRegistry().getRegisteredPrivileges();
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        this.checkInitialized();
        return this.getPrivilegeRegistry().getPrivilege(privilegeName);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 32);
        log.debug("Implementation does not provide applicable policies -> getPolicy() always returns an empty array.");
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 32);
        log.debug("Implementation does not provide applicable policies -> returning empty iterator.");
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 64);
        throw new AccessControlException("AccessControlPolicy " + policy + " cannot be applied.");
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 64);
        throw new AccessControlException("No AccessControlPolicy has been set through this API -> Cannot be removed.");
    }

    public AccessControlPolicy[] getApplicablePolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        log.debug("Implementation does not provide applicable policies -> returning empty array.");
        return new AccessControlPolicy[0];
    }

    protected abstract void checkInitialized() throws IllegalStateException;

    protected abstract void checkPrivileges(String var1, int var2) throws AccessDeniedException, PathNotFoundException, RepositoryException;

    protected abstract PrivilegeRegistry getPrivilegeRegistry() throws RepositoryException;

    protected abstract void checkValidNodePath(String var1) throws PathNotFoundException, RepositoryException;
}

