/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;

public class StateChangeDispatcher {
    private final Collection listeners = new CopyOnWriteArrayList();
    private final transient Collection nsListeners = new CopyOnWriteArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addListener(ItemStateListener listener) {
        if (!$assertionsDisabled && this.getReference(this.listeners, listener) != null) {
            throw new AssertionError();
        }
        this.listeners.add(new WeakReference<ItemStateListener>(listener));
        if (listener instanceof NodeStateListener) {
            if (!$assertionsDisabled && this.getReference(this.nsListeners, listener) != null) {
                throw new AssertionError();
            }
            this.nsListeners.add(new WeakReference<ItemStateListener>(listener));
        }
    }

    private Reference getReference(Collection coll, ItemStateListener listener) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            Object o = ref.get();
            if (o == listener) {
                return ref;
            }
            if (o != null) continue;
            coll.remove(ref);
        }
        return null;
    }

    public void removeListener(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            this.nsListeners.remove(this.getReference(this.nsListeners, listener));
        }
        this.listeners.remove(this.getReference(this.listeners, listener));
    }

    public void notifyStateCreated(ItemState created) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            ItemStateListener l = (ItemStateListener)ref.get();
            if (l == null) continue;
            l.stateCreated(created);
        }
    }

    public void notifyStateModified(ItemState modified) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            ItemStateListener l = (ItemStateListener)ref.get();
            if (l == null) continue;
            l.stateModified(modified);
        }
    }

    public void notifyStateDestroyed(ItemState destroyed) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            ItemStateListener l = (ItemStateListener)ref.get();
            if (l == null) continue;
            l.stateDestroyed(destroyed);
        }
    }

    public void notifyStateDiscarded(ItemState discarded) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            ItemStateListener l = (ItemStateListener)ref.get();
            if (l == null) continue;
            l.stateDiscarded(discarded);
        }
    }

    public void notifyNodeAdded(NodeState state, Name name, int index, NodeId id) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            NodeStateListener n = (NodeStateListener)ref.get();
            if (n == null) continue;
            n.nodeAdded(state, name, index, id);
        }
    }

    public void notifyNodesReplaced(NodeState state) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            NodeStateListener n = (NodeStateListener)ref.get();
            if (n == null) continue;
            n.nodesReplaced(state);
        }
    }

    public void notifyNodeModified(NodeState state) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            NodeStateListener n = (NodeStateListener)ref.get();
            if (n == null) continue;
            n.nodeModified(state);
        }
    }

    public void notifyNodeRemoved(NodeState state, Name name, int index, NodeId id) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            NodeStateListener n = (NodeStateListener)ref.get();
            if (n == null) continue;
            n.nodeRemoved(state, name, index, id);
        }
    }

    static {
        $assertionsDisabled = !StateChangeDispatcher.class.desiredAssertionStatus();
    }
}

