/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.ByteArrayArray;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class StringArrayArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    private ByteArrayArray byteStore = new ByteArrayArray();

    public void put(int index, String[] value) {
        if (value == null) {
            this.remove(index);
        }
        byte[] bytes = this.stringArrayToBytes(value);
        this.byteStore.put(index, bytes);
    }

    public String[] get(int index) {
        byte[] bytes = this.byteStore.get(index);
        if (bytes == null) {
            return null;
        }
        return this.bytesToStringArray(bytes);
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putStringArray(toIndex, toCol, this.get(index));
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.byteStore.getLastNonEmptyIndex();
    }

    @Override
    public void remove(int index) {
        this.byteStore.remove(index);
    }

    private byte[] stringArrayToBytes(String[] value) {
        int len = 4;
        for (int i = 0; i < value.length; ++i) {
            len += 2;
            if (value[i] == null) continue;
            len += value[i].length();
        }
        byte[] bytes = new byte[len];
        int n = value.length;
        bytes[0] = (byte)(n >> 24);
        bytes[1] = (byte)(n >> 16);
        bytes[2] = (byte)(n >> 8);
        bytes[3] = (byte)n;
        int pos = 4;
        for (int i = 0; i < n; ++i) {
            if (value[i] == null) {
                bytes[pos++] = -1;
                bytes[pos++] = -1;
                continue;
            }
            int strlen = value[i].length();
            bytes[pos++] = (byte)(strlen >> 8);
            bytes[pos++] = (byte)strlen;
            System.arraycopy(value[i].getBytes(), 0, bytes, pos, strlen);
            pos += strlen;
        }
        return bytes;
    }

    private String[] bytesToStringArray(byte[] bytes) {
        int numStrings = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        String[] strings = new String[numStrings];
        int pos = 4;
        for (int i = 0; i < numStrings; ++i) {
            int strlen = (bytes[pos] << 8) + (bytes[pos + 1] & 0xFF);
            if (strlen >= 0) {
                strings[i] = new String(bytes, pos + 2, strlen);
                pos += strlen;
            }
            pos += 2;
        }
        return strings;
    }
}

