/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.catacombae.hfsexplorer.ExtractProgressMonitor;
import org.catacombae.hfsexplorer.SimpleGUIProgressMonitor;
import org.catacombae.hfsexplorer.SpeedUnitUtils;
import org.catacombae.hfsexplorer.gui.ExtractProgressPanel;
import org.catacombae.hfsexplorer.gui.ExtractSettingsPanel;

public class ExtractProgressDialog
extends JDialog
implements ExtractProgressMonitor {
    private final ExtractProgressPanel progressPanel;
    private final ExtractSettingsPanel settingsPanel;
    private final ExtractProgressMonitor.ExtractProperties extractProperties;
    private final JButton cancelButton;
    private volatile boolean cancelSignaled = false;
    private long completedSize = 0L;
    private long totalSize = -1L;
    private DecimalFormat sizeFormatter = new DecimalFormat("0.00");

    public ExtractProgressDialog(Frame owner) {
        this(owner, false);
    }

    private ExtractProgressDialog(Frame owner, boolean modal) {
        super(owner, "Extracting...", modal);
        final JPanel backgroundPanel = new JPanel();
        this.extractProperties = new ExtractProgressMonitor.ExtractProperties();
        this.progressPanel = new ExtractProgressPanel();
        this.settingsPanel = new ExtractSettingsPanel(this.extractProperties);
        this.cancelButton = this.progressPanel.cancelButton;
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ExtractProgressDialog.this.signalCancel();
            }
        });
        this.progressPanel.addShowSettingsButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ExtractProgressDialog.this.progressPanel.getShowSettingsButtonSelected();
                if (selected) {
                    backgroundPanel.add(ExtractProgressDialog.this.settingsPanel);
                } else {
                    backgroundPanel.remove(ExtractProgressDialog.this.settingsPanel);
                }
                ExtractProgressDialog.this.pack();
            }
        });
        backgroundPanel.setLayout(new BoxLayout(backgroundPanel, 3));
        backgroundPanel.add(this.progressPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ExtractProgressDialog.this.requestCloseWindow();
            }
        });
        this.add(backgroundPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public void updateCalculateDir(String dirname) {
        this.progressPanel.updateCalculateDir(dirname);
    }

    public void updateTotalProgress(double fraction, String message) {
        this.progressPanel.updateTotalProgress(fraction, message);
    }

    public void updateCurrentDir(String dirname) {
        this.progressPanel.updateCurrentDir(dirname);
    }

    public void updateCurrentFile(String filename, long fileSize) {
        this.progressPanel.updateCurrentFile(filename, fileSize);
    }

    public synchronized void signalCancel() {
        this.cancelButton.setEnabled(false);
        this.cancelSignaled = true;
    }

    public boolean cancelSignaled() {
        return this.cancelSignaled;
    }

    public void confirmCancel() {
        if (this.isVisible()) {
            this.dispose();
        }
    }

    private synchronized void requestCloseWindow() {
        if (!this.cancelSignaled) {
            this.signalCancel();
        }
        this.dispose();
    }

    public void setDataSize(long totalSize) {
        this.totalSize = totalSize;
        this.addDataProgress(0L);
    }

    public void addDataProgress(long dataSize) {
        this.completedSize += dataSize;
        String message = SpeedUnitUtils.bytesToBinaryUnit((long)this.completedSize, (DecimalFormat)this.sizeFormatter) + "/" + SpeedUnitUtils.bytesToBinaryUnit((long)this.totalSize, (DecimalFormat)this.sizeFormatter);
        this.updateTotalProgress((double)this.completedSize / (double)this.totalSize, message);
    }

    public ExtractProgressMonitor.CreateDirectoryFailedAction createDirectoryFailed(String dirname, File parentDirectory) {
        return SimpleGUIProgressMonitor.createDirectoryFailed(this, dirname, parentDirectory);
    }

    public ExtractProgressMonitor.CreateFileFailedAction createFileFailed(String filename, File parentDirectory) {
        return SimpleGUIProgressMonitor.createFileFailed(this, filename, parentDirectory);
    }

    public ExtractProgressMonitor.DirectoryExistsAction directoryExists(File directory) {
        return SimpleGUIProgressMonitor.directoryExists(this, directory);
    }

    public ExtractProgressMonitor.FileExistsAction fileExists(File file) {
        return SimpleGUIProgressMonitor.fileExists(this, file);
    }

    public String displayRenamePrompt(String currentName, File outDir) {
        return SimpleGUIProgressMonitor.displayRenamePrompt(this, currentName, outDir);
    }

    public ExtractProgressMonitor.ExtractProperties getExtractProperties() {
        return this.extractProperties;
    }
}

