/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.UnicodeNormalizationToolkit;
import org.catacombae.hfsexplorer.Util;

public class HFSUniStr255
implements StructElements {
    private final byte[] length = new byte[2];
    private final byte[] unicode;

    public HFSUniStr255(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.length, 0, 2);
        this.unicode = new byte[2 * Util.unsign((short)this.getLength())];
        System.arraycopy(data, offset + 2, this.unicode, 0, this.unicode.length);
    }

    public HFSUniStr255(String unicodeString) {
        char[] unicodeChars = unicodeString.toCharArray();
        if (unicodeChars.length > 255) {
            throw new RuntimeException("String too large.");
        }
        System.arraycopy(Util.toByteArrayBE((short)((short)unicodeChars.length)), 0, this.length, 0, 2);
        this.unicode = Util.readByteArrayBE((char[])unicodeChars);
    }

    public int length() {
        return 2 + this.unicode.length;
    }

    public short getLength() {
        return Util.readShortBE((byte[])this.length);
    }

    public byte[] getRawUnicode() {
        return Util.createCopy((byte[])this.unicode);
    }

    public char[] getUnicode() {
        return Util.readCharArrayBE((byte[])this.unicode);
    }

    public String getUnicodeAsDecomposedString() {
        return new String(this.getUnicode());
    }

    public String getUnicodeAsComposedString() {
        return UnicodeNormalizationToolkit.getDefaultInstance().compose(this.getUnicodeAsDecomposedString());
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        System.arraycopy(this.length, 0, result, 0, 2);
        System.arraycopy(this.unicode, 0, result, 2, this.unicode.length);
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " length: " + Util.unsign((short)this.getLength()));
        ps.println(prefix + " unicode (decomposed): \"" + this.getUnicodeAsDecomposedString() + "\"");
        ps.println(prefix + "           (composed): \"" + this.getUnicodeAsComposedString() + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSUniStr255:");
        this.printFields(ps, prefix);
    }

    public String toString() {
        return this.getUnicodeAsComposedString();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSUniStr255.class.getSimpleName());
        db.addUIntBE("length", this.length);
        db.addEncodedString("unicode", this.unicode, "UTF-16BE");
        return db.getResult();
    }
}

