/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDFragmentName
extends MDParsableItem {
    private String name;
    private boolean stripTerminator = true;

    public MDFragmentName(MDMang dmang) {
        super(dmang);
    }

    public void keepTerminator() {
        this.stripTerminator = false;
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insertString(builder, this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void parseInternal() throws MDException {
        this.name = this.dmang.parseFragmentName(this);
        if (this.dmang.peek() == '@' && this.stripTerminator) {
            this.dmang.increment();
        }
    }

    public String parseFragmentName_Md() {
        char ch;
        StringBuilder frag = new StringBuilder();
        while ((ch = this.dmang.peek()) != '\uffff' && (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || ch == '$' || ch == '<' || ch == '>' || ch == '-' || ch == '.')) {
            frag.append(ch);
            this.dmang.next();
        }
        return frag.toString();
    }

    public String parseFragmentName_VS2All() throws MDException {
        char ch;
        StringBuilder frag = new StringBuilder();
        while ((ch = this.dmang.peek()) != '\uffff') {
            if (ch == '.') {
                throw new MDException("Illegal '.' character in MDFragmentName");
            }
            if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '_' && ch != '$' && ch != '<' && ch != '>' && ch != '-') break;
            frag.append(ch);
            this.dmang.next();
        }
        return frag.toString();
    }
}

