/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageConsumer;

public class GifImage
extends AbstractFopImage {
    public GifImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadBitmap() {
        int[] tmpMap;
        block18: {
            tmpMap = null;
            try {
                DummyConnection con = new DummyConnection(this.inputStream);
                ImageProducer ip = (ImageProducer)con.getContent();
                if (ip == null) {
                    boolean bl = false;
                    return bl;
                }
                FopImageConsumer consumer = new FopImageConsumer(ip);
                ip.startProduction(consumer);
                while (!consumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.height = consumer.getHeight();
                this.width = consumer.getWidth();
                try {
                    tmpMap = consumer.getImage();
                }
                catch (Exception ex) {
                    log.error((Object)("Image grabbing interrupted : " + ex.getMessage()), (Throwable)ex);
                    boolean bl = false;
                    IOUtils.closeQuietly((InputStream)this.inputStream);
                    this.inputStream = null;
                    return bl;
                }
                ColorModel cm = consumer.getColorModel();
                this.bitsPerPixel = 8;
                this.colorSpace = ColorSpace.getInstance(1004);
                if (cm.hasAlpha()) {
                    int transparencyType = cm.getTransparency();
                    if (transparencyType == 1) {
                        this.isTransparent = false;
                        break block18;
                    }
                    if (transparencyType == 2) {
                        if (cm instanceof IndexColorModel) {
                            IndexColorModel indexcm = (IndexColorModel)cm;
                            this.isTransparent = false;
                            byte[] alphas = new byte[indexcm.getMapSize()];
                            byte[] reds = new byte[indexcm.getMapSize()];
                            byte[] greens = new byte[indexcm.getMapSize()];
                            byte[] blues = new byte[indexcm.getMapSize()];
                            indexcm.getAlphas(alphas);
                            indexcm.getReds(reds);
                            indexcm.getGreens(greens);
                            indexcm.getBlues(blues);
                            for (int i = 0; i < indexcm.getMapSize(); ++i) {
                                if ((alphas[i] & 0xFF) != 0) continue;
                                this.isTransparent = true;
                                this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                break block18;
                            }
                            break block18;
                        }
                        this.isTransparent = false;
                        break block18;
                    }
                    this.isTransparent = false;
                    break block18;
                }
                this.isTransparent = false;
            }
            catch (Exception ex) {
                log.error((Object)("Error while loading image (Gif): " + ex.getMessage()), (Throwable)ex);
                boolean ip = false;
                return ip;
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.inputStream = null;
            }
        }
        this.bitmaps = new byte[this.width * this.height * 3];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int p = tmpMap[i * this.width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
            }
        }
        return true;
    }

    protected boolean loadOriginalData() {
        return this.loadDefaultOriginalData();
    }

    protected static class DummyConnection
    extends URLConnection {
        private InputStream inputStream;

        DummyConnection(InputStream is) {
            super(null);
            this.inputStream = is;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public void connect() throws IOException {
        }

        public String getContentType() {
            return "image/gif";
        }

        public int getContentLength() {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }
}

