/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.quicksearch.web.Result;
import org.openide.util.NbBundle;

final class Query {
    private Thread searchThread;
    private static Query theInstance;
    private int searchOffset;
    private static final String SITE_SEARCH;
    static final int MAX_NUM_OF_RESULTS = 50;
    private static final String[] URL_PATTERNS;

    private Query() {
    }

    public static Query getDefault() {
        if (null == theInstance) {
            theInstance = new Query();
        }
        return theInstance;
    }

    public Result search(String string) {
        this.abort();
        Result result = new Result();
        this.searchThread = new Thread(this.createSearch(string, result, 0));
        this.searchThread.start();
        try {
            this.searchThread.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    public Result searchMore(String string) {
        this.searchOffset += 50;
        Result result = new Result();
        Thread thread = new Thread(this.createSearch(string, result, this.searchOffset));
        thread.start();
        try {
            thread.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private void abort() {
        if (null == this.searchThread) {
            return;
        }
        this.searchOffset = 0;
        this.searchThread.interrupt();
        this.searchThread = null;
    }

    private Runnable createSearch(final String string, final Result result, final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string3 = string;
                string3 = string3.replaceAll(" ", "+");
                string3 = string3.replaceAll("#", "%23");
                string3 = string3 + "&num=50";
                string3 = string3 + "&hl=" + Locale.getDefault().getLanguage();
                if (null != SITE_SEARCH) {
                    string3 = string3 + "&sitesearch=" + SITE_SEARCH;
                }
                if (n > 0) {
                    string3 = string3 + "&start=" + n;
                }
                try {
                    String string2;
                    Socket socket = new Socket("google.com", 80);
                    PrintStream printStream = new PrintStream(socket.getOutputStream());
                    printStream.print("GET /search?q=" + string3 + " HTTP/1.0\r\n");
                    printStream.print("User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0\r\n");
                    printStream.print("Connection: close\r\n\r\n");
                    InputStreamReader inputStreamReader = new InputStreamReader(socket.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2);
                    }
                    inputStreamReader.close();
                    result.parse(stringBuffer.toString(), n);
                    result.filterUrl(URL_PATTERNS);
                }
                catch (IOException iOException) {
                    Logger.getLogger(Query.class.getName()).log(Level.INFO, null, iOException);
                }
            }
        };
        return runnable;
    }

    private static String getSiteSearch() {
        String string = null;
        try {
            string = NbBundle.getMessage(Query.class, (String)"quicksearch.web.site");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    private static String[] getUrlPatterns() {
        try {
            String string = NbBundle.getMessage(Query.class, (String)"quicksearch.web.url_patterns");
            return string.split("\\s|,|;|:");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    static {
        SITE_SEARCH = Query.getSiteSearch();
        URL_PATTERNS = Query.getUrlPatterns();
    }
}

