/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.netbeans.api.visual.anchor.AnchorShape;

public class ArrowAnchorShape
implements AnchorShape {
    private static final Stroke STROKE = new BasicStroke(1.0f, 1, 1);
    private GeneralPath path;
    private int size;

    public ArrowAnchorShape(int n, int n2) {
        this.size = n2;
        this.path = new GeneralPath();
        double d = Math.PI * (double)n / 180.0;
        double d2 = Math.cos(d / 2.0);
        double d3 = (double)(-n2) * Math.sqrt(1.0 - d2 * d2);
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo((float)(d2 *= (double)n2), (float)(-d3));
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo((float)d2, (float)d3);
    }

    public boolean isLineOriented() {
        return true;
    }

    public int getRadius() {
        return this.size + 1;
    }

    public double getCutDistance() {
        return 0.0;
    }

    public void paint(Graphics2D graphics2D, boolean bl) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE);
        graphics2D.draw(this.path);
        graphics2D.setStroke(stroke);
    }
}

