(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/websocket#wsmagic '"258EAFA5-E914-47DA-95CA-C5AB0DC85B11")
  (define std/net/websocket#open-websocket-client__%
    (lambda (_g5065_
             _redirect12691275_
             _headers12701277_
             _cookies12711279_
             _params12721281_
             _url1283_)
      (let* ((_redirect1285_
              (if (eq? _redirect12691275_ absent-value)
                  '#t
                  _redirect12691275_))
             (_headers1287_
              (if (eq? _headers12701277_ absent-value) '#f _headers12701277_))
             (_cookies1289_
              (if (eq? _cookies12711279_ absent-value) '#f _cookies12711279_))
             (_params1291_
              (if (eq? _params12721281_ absent-value) '#f _params12721281_))
             (_url1293_ (std/net/websocket#url->request-url _url1283_))
             (_nonce1295_ (std/crypto/etc#random-bytes '16))
             (_nonce641297_
              (std/text/base64#u8vector->base64-string _nonce1295_))
             (_headers1302_
              (cons (cons '"Upgrade" '"websocket")
                    (cons (cons '"Connection" '"Upgrade")
                          (cons (cons '"Sec-WebSocket-Key" _nonce641297_)
                                (cons (cons '"Sec-WebSocket-Version" '13)
                                      (let ((_$e1299_ _headers1287_))
                                        (if _$e1299_ _$e1299_ '())))))))
             (_req1304_
              (std/net/request#http-get__%
               '#f
               _redirect1285_
               _headers1302_
               _cookies1289_
               _params1291_
               absent-value
               _url1293_)))
        (with-exception-catcher
         (lambda (_g13061308_)
           (if '#t
               (let ((_e1311_ _g13061308_))
                 (std/net/request#request-close _req1304_)
                 (raise _e1311_))
               (raise _g13061308_)))
         (lambda ()
           (let ((_status1314_
                  (##structure-ref
                   _req1304_
                   '4
                   std/net/request#request::t
                   '#f)))
             (if (let () (declare (not safe)) (##fx= _status1314_ '101))
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Unexpected server response"
                  _url1293_
                  _status1314_)))
           (let* ((_rheaders1316_
                   (##structure-ref
                    _req1304_
                    '6
                    std/net/request#request::t
                    '#f))
                  (_Connection1318_ (assoc '"Connection" _rheaders1316_))
                  (_Upgrade1320_ (assoc '"Upgrade" _rheaders1316_))
                  (_Sec-WebSocket-Accept1322_
                   (assoc '"Sec-Websocket-Accept" _rheaders1316_))
                  (_Sec-WebSocket-Extensions1324_
                   (assoc '"Sec-Websocket-Extensions" _rheaders1316_))
                  (_Sec-WebSocket-Protocol1326_
                   (assoc '"Sec-Websocket-Protocol" _rheaders1316_)))
             (if (and _Connection1318_
                      (equal? (std/srfi/13#string-downcase__0
                               (cdr _Connection1318_))
                              '"upgrade"))
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; no connection upgrade"
                  _url1293_
                  _Connection1318_))
             (if (and _Upgrade1320_
                      (equal? (std/srfi/13#string-downcase__0
                               (cdr _Upgrade1320_))
                              '"websocket"))
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; no websocket upgrade"
                  _url1293_
                  _Upgrade1320_))
             (let* ((_accept641329_
                     (if _Sec-WebSocket-Accept1322_
                         (cdr _Sec-WebSocket-Accept1322_)
                         '#f))
                    (_digest1331_
                     (let ((__obj5062
                            (make-object std/crypto/digest#digest::t '2)))
                       (std/crypto/digest#digest:::init!
                        __obj5062
                        std/crypto/digest#digest::sha1)
                       __obj5062))
                    (_g5066_ (std/crypto/digest#digest-update!__0
                              _digest1331_
                              (std/text/utf8#string->utf8__0 _nonce641297_)))
                    (_g5067_ (std/crypto/digest#digest-update!__0
                              _digest1331_
                              (std/text/utf8#string->utf8__0
                               std/net/websocket#wsmagic)))
                    (_verify1335_
                     (std/crypto/digest#digest-final!__0 _digest1331_))
                    (_verify641337_
                     (std/text/base64#u8vector->base64-string _verify1335_)))
               (if (equal? _accept641329_ _verify641337_)
                   '#!void
                   (std/error#raise-io-error
                    'open-websocket-client
                    '"Bad server response; nonce verification failure"
                    _url1293_
                    _nonce641297_
                    _accept641329_
                    _verify641337_)))
             (if _Sec-WebSocket-Extensions1324_
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; includes unsupported exensions"
                  _url1293_
                  _Sec-WebSocket-Extensions1324_)
                 '#!void)
             (if _Sec-WebSocket-Protocol1326_
                 (let* ((_proto1340_ (cdr _Sec-WebSocket-Protocol1326_))
                        (_uproto1342_
                         (assoc '"Sec-WebSocket-Protocol" _headers1302_))
                        (_uproto1344_
                         (string-split
                          (if _uproto1342_ (cdr _uproto1342_) '#f)
                          '#\,)))
                   (if (member _proto1340_ _uproto1344_)
                       '#!void
                       (std/error#raise-io-error
                        'open-websocket-client
                        '"Bad server response; unexpected protocol"
                        _url1293_
                        _Sec-WebSocket-Protocol1326_)))
                 '#!void))
           (std/net/websocket#make-websocket-client
            (##structure-ref _req1304_ '1 std/net/request#request::t '#f)))))))
  (define std/net/websocket#open-websocket-client__@
    (lambda (_keys12681350_ . _args1352_)
      (apply std/net/websocket#open-websocket-client__%
             _keys12681350_
             (table-ref _keys12681350_ 'redirect: absent-value)
             (table-ref _keys12681350_ 'headers: absent-value)
             (table-ref _keys12681350_ 'cookies: absent-value)
             (table-ref _keys12681350_ 'params: absent-value)
             _args1352_)))
  (define std/net/websocket#open-websocket-client
    (lambda _args12731358_
      (apply keyword-dispatch
             '#(params:
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                redirect:
                headers:
                #f
                #f
                #f
                #f)
             std/net/websocket#open-websocket-client__@
             _args12731358_)))
  (define std/net/websocket#url->request-url
    (lambda (_url1257_)
      (let ((_colon1259_ (std/srfi/13#string-index__0 _url1257_ '#\:)))
        (if _colon1259_
            (let* ((_scheme1262_ (substring _url1257_ '0 _colon1259_))
                   (_$e1264_ _scheme1262_))
              (if (equal? '"ws" _$e1264_)
                  (string-append
                   '"http"
                   (substring _url1257_ _colon1259_ (string-length _url1257_)))
                  (if (equal? '"wss" _$e1264_)
                      (string-append
                       '"https"
                       (substring
                        _url1257_
                        _colon1259_
                        (string-length _url1257_)))
                      _url1257_)))
            _url1257_))))
  (define std/net/websocket#websocket::t
    (make-struct-type
     'std/net/websocket#websocket::t
     '#f
     '7
     'websocket
     '((final: . #t))
     ':init!
     '(port rd wr cs q mx cv)))
  (define std/net/websocket#websocket?
    (make-struct-predicate std/net/websocket#websocket::t))
  (define std/net/websocket#make-websocket
    (lambda _$args1254_
      (apply make-struct-instance std/net/websocket#websocket::t _$args1254_)))
  (define std/net/websocket#websocket-port
    (make-struct-field-accessor std/net/websocket#websocket::t '0))
  (define std/net/websocket#websocket-rd
    (make-struct-field-accessor std/net/websocket#websocket::t '1))
  (define std/net/websocket#websocket-wr
    (make-struct-field-accessor std/net/websocket#websocket::t '2))
  (define std/net/websocket#websocket-cs
    (make-struct-field-accessor std/net/websocket#websocket::t '3))
  (define std/net/websocket#websocket-q
    (make-struct-field-accessor std/net/websocket#websocket::t '4))
  (define std/net/websocket#websocket-mx
    (make-struct-field-accessor std/net/websocket#websocket::t '5))
  (define std/net/websocket#websocket-cv
    (make-struct-field-accessor std/net/websocket#websocket::t '6))
  (define std/net/websocket#websocket-port-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '0))
  (define std/net/websocket#websocket-rd-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '1))
  (define std/net/websocket#websocket-wr-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '2))
  (define std/net/websocket#websocket-cs-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '3))
  (define std/net/websocket#websocket-q-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '4))
  (define std/net/websocket#websocket-mx-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '5))
  (define std/net/websocket#websocket-cv-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '6))
  (define std/net/websocket#websocket:::init!
    (lambda (_self1251_ _port1252_)
      (if (let ((__tmp5068
                 (let () (declare (not safe)) (##vector-length _self1251_))))
            (declare (not safe))
            (##fx< '7 __tmp5068))
          (begin
            (let ()
              (declare (not safe))
              (##vector-set! _self1251_ '1 _port1252_))
            (let () (declare (not safe)) (##vector-set! _self1251_ '2 '#f))
            (let () (declare (not safe)) (##vector-set! _self1251_ '3 '#f))
            (let () (declare (not safe)) (##vector-set! _self1251_ '4 '#f))
            (let ((__tmp5069
                   (let ((__obj5063 (make-object std/misc/queue#queue::t '3)))
                     (std/misc/queue#queue:::init! __obj5063)
                     __obj5063)))
              (declare (not safe))
              (##vector-set! _self1251_ '5 __tmp5069))
            (let ((__tmp5070 (make-mutex)))
              (declare (not safe))
              (##vector-set! _self1251_ '6 __tmp5070))
            (let ((__tmp5071 (make-condition-variable)))
              (declare (not safe))
              (##vector-set! _self1251_ '7 __tmp5071)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self1251_))))
  (bind-method!
   std/net/websocket#websocket::t
   ':init!
   std/net/websocket#websocket:::init!
   '#f)
  (define std/net/websocket#make-websocket-client
    (lambda (_port1118_)
      (std/logger#start-logger!__0)
      (let* ((_ws1120_
              (let ((__obj5064
                     (make-object std/net/websocket#websocket::t '7)))
                (std/net/websocket#websocket:::init! __obj5064 _port1118_)
                __obj5064))
             (_reader1122_
              (gerbil/gambit/threads#spawn/name
               'websocket-reader
               std/net/websocket#websocket-reader
               _ws1120_))
             (_writer1124_
              (gerbil/gambit/threads#spawn/name
               'websocket-writer
               std/net/websocket#websocket-writer
               _ws1120_)))
        (##direct-structure-set!
         _ws1120_
         _reader1122_
         '2
         std/net/websocket#websocket::t
         '#f)
        (##direct-structure-set!
         _ws1120_
         _writer1124_
         '3
         std/net/websocket#websocket::t
         '#f)
        _ws1120_)))
  (define std/net/websocket#websocket-send
    (lambda (_ws1106_ _bytes1107_ _type1108_)
      (if (not (u8vector? _bytes1107_))
          (error '"Bad argument; expected u8vector" _bytes1107_)
          (if (not (or (eq? _type1108_ 'binary) (eq? _type1108_ 'text)))
              (error '"Bad argument; expected 'binary or 'text" _type1108_)
              (let ((_$e1113_
                     (##direct-structure-ref
                      _ws1106_
                      '4
                      std/net/websocket#websocket::t
                      '#f)))
                (if _$e1113_
                    ((lambda (_how1116_)
                       (std/error#raise-io-error
                        'websocket-send
                        '"Websocket has been closed"
                        _ws1106_
                        _how1116_))
                     _$e1113_)
                    (thread-send
                     (##direct-structure-ref
                      _ws1106_
                      '3
                      std/net/websocket#websocket::t
                      '#f)
                     (cons _type1108_ _bytes1107_))))))))
  (define std/net/websocket#websocket-write
    (lambda (_ws1103_ _obj1104_)
      (if (string? _obj1104_)
          (std/net/websocket#websocket-send
           _ws1103_
           (std/text/utf8#string->utf8__0 _obj1104_)
           'text)
          (if (u8vector? _obj1104_)
              (std/net/websocket#websocket-send _ws1103_ _obj1104_ 'binary)
              (error '"Bad argument; expected bytes or string" _obj1104_)))))
  (define std/net/websocket#websocket-recv__%
    (lambda (_ws991_ _timeo992_ _raise?993_)
      (let* ((_timeo995_ (std/misc/timeout#make-timeout__0 _timeo992_))
             (_ws9961008_ _ws991_)
             (_E9981012_ (lambda () (error '"No clause matching" _ws9961008_)))
             (_K9991055_
              (lambda (_cv1015_ _mx1016_ _q1017_)
                (let _lp1019_ ()
                  (mutex-lock! _mx1016_)
                  (if (not (std/misc/queue#queue-empty? _q1017_))
                      (let* ((_g10211028_ (std/misc/queue#dequeue!__0 _q1017_))
                             (_E10231032_
                              (lambda ()
                                (error '"No clause matching" _g10211028_)))
                             (_K10241038_
                              (lambda (_data1035_ _type1036_)
                                (mutex-unlock! _mx1016_)
                                (values _data1035_ _type1036_))))
                        (if (let () (declare (not safe)) (##pair? _g10211028_))
                            (let ((_hd10251041_
                                   (let ()
                                     (declare (not safe))
                                     (##car _g10211028_)))
                                  (_tl10261043_
                                   (let ()
                                     (declare (not safe))
                                     (##cdr _g10211028_))))
                              (let* ((_type1046_ _hd10251041_)
                                     (_data1048_ _tl10261043_))
                                (_K10241038_ _data1048_ _type1046_)))
                            (_E10231032_)))
                      (let ((_$e1050_
                             (##direct-structure-ref
                              _ws991_
                              '4
                              std/net/websocket#websocket::t
                              '#f)))
                        (if _$e1050_
                            ((lambda (_how1053_)
                               (mutex-unlock! _mx1016_)
                               (if _raise?993_
                                   (std/error#raise-io-error
                                    'websocket-recv
                                    '"Websocket has been closed"
                                    _ws991_
                                    _how1053_)
                                   '#!eof))
                             _$e1050_)
                            (if (mutex-unlock! _mx1016_ _cv1015_ _timeo995_)
                                (_lp1019_)
                                (if _raise?993_
                                    (std/error#raise-timeout
                                     'websocket-recv
                                     '"timeout"
                                     _ws991_)
                                    '#f)))))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _ws9961008_
               'std/net/websocket#websocket::t))
            (let* ((_e10001058_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '1)))
                   (_e10011061_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '2)))
                   (_e10021064_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '3)))
                   (_e10031067_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '4)))
                   (_e10041070_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '5)))
                   (_q1073_ _e10041070_)
                   (_e10051075_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '6)))
                   (_mx1078_ _e10051075_)
                   (_e10061080_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _ws9961008_ '7)))
                   (_cv1083_ _e10061080_))
              (_K9991055_ _cv1083_ _mx1078_ _q1073_))
            (_E9981012_)))))
  (define std/net/websocket#websocket-recv__0
    (lambda (_ws1088_)
      (let* ((_timeo1090_ '#f) (_raise?1092_ '#t))
        (std/net/websocket#websocket-recv__%
         _ws1088_
         _timeo1090_
         _raise?1092_))))
  (define std/net/websocket#websocket-recv__1
    (lambda (_ws1094_ _timeo1095_)
      (let ((_raise?1097_ '#t))
        (std/net/websocket#websocket-recv__%
         _ws1094_
         _timeo1095_
         _raise?1097_))))
  (define std/net/websocket#websocket-recv
    (lambda _g5073_
      (let ((_g5072_ (let () (declare (not safe)) (##length _g5073_))))
        (cond ((let () (declare (not safe)) (##fx= _g5072_ 1))
               (apply std/net/websocket#websocket-recv__0 _g5073_))
              ((let () (declare (not safe)) (##fx= _g5072_ 2))
               (apply std/net/websocket#websocket-recv__1 _g5073_))
              ((let () (declare (not safe)) (##fx= _g5072_ 3))
               (apply std/net/websocket#websocket-recv__% _g5073_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-recv
                _g5073_))))))
  (define std/net/websocket#websocket-read__%
    (lambda (_ws908_ _timeo909_ _raise?910_)
      (let* ((_g911924_
              (std/net/websocket#websocket-recv__%
               _ws908_
               _timeo909_
               _raise?910_))
             (_E915928_ (lambda () (error '"No clause matching" _g911924_))))
        (let ((_K920961_ (lambda (_data959_) _data959_))
              (_K917945_
               (lambda (_data943_) (std/text/utf8#utf8->string__0 _data943_)))
              (_K916934_ (lambda (_r932_) _r932_)))
          (if (let ((__tmp5074
                     (if (let () (declare (not safe)) (##values? _g911924_))
                         (let ()
                           (declare (not safe))
                           (##vector-length _g911924_))
                         '1)))
                (declare (not safe))
                (##fx= __tmp5074 '2))
              (let* ((_e921964_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _g911924_ '0)))
                     (_e922969_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _g911924_ '1))))
                (if (let () (declare (not safe)) (##eq? _e922969_ 'binary))
                    (let ((_data967_ _e921964_)) (_K920961_ _data967_))
                    (if (let () (declare (not safe)) (##eq? _e922969_ 'text))
                        (let ((_data951_ _e921964_))
                          (std/text/utf8#utf8->string__0 _data951_))
                        (let ((_r937_ _g911924_)) (_K916934_ _r937_)))))
              (let ((_r937_ _g911924_)) (_K916934_ _r937_)))))))
  (define std/net/websocket#websocket-read__0
    (lambda (_ws975_)
      (let* ((_timeo977_ '#f) (_raise?979_ '#f))
        (std/net/websocket#websocket-read__% _ws975_ _timeo977_ _raise?979_))))
  (define std/net/websocket#websocket-read__1
    (lambda (_ws981_ _timeo982_)
      (let ((_raise?984_ '#f))
        (std/net/websocket#websocket-read__% _ws981_ _timeo982_ _raise?984_))))
  (define std/net/websocket#websocket-read
    (lambda _g5076_
      (let ((_g5075_ (let () (declare (not safe)) (##length _g5076_))))
        (cond ((let () (declare (not safe)) (##fx= _g5075_ 1))
               (apply std/net/websocket#websocket-read__0 _g5076_))
              ((let () (declare (not safe)) (##fx= _g5075_ 2))
               (apply std/net/websocket#websocket-read__1 _g5076_))
              ((let () (declare (not safe)) (##fx= _g5075_ 3))
               (apply std/net/websocket#websocket-read__% _g5076_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-read
                _g5076_))))))
  (define std/net/websocket#websocket-close__%__%
    (lambda (__804807_ _hard?802809_ _ws811_ _how812_)
      (let* ((_hard?814_
              (if (eq? _hard?802809_ absent-value) '#f _hard?802809_))
             (_ws815827_ _ws811_)
             (_E817831_ (lambda () (error '"No clause matching" _ws815827_)))
             (_K818843_
              (lambda (_cv834_ _mx835_ _q836_ _cs837_ _writer838_ _port839_)
                (if _hard?814_ (close-port _port839_) '#!void)
                (if _cs837_
                    '#!void
                    (begin
                      (mutex-lock! _mx835_)
                      (if (##direct-structure-ref
                           _ws811_
                           '4
                           std/net/websocket#websocket::t
                           '#f)
                          (mutex-unlock! _mx835_)
                          (let ((_how841_ (if _hard?814_ 'abort _how812_)))
                            (##direct-structure-set!
                             _ws811_
                             _how841_
                             '4
                             std/net/websocket#websocket::t
                             '#f)
                            (thread-send _writer838_ (cons 'close _how841_))
                            (condition-variable-broadcast! _cv834_)
                            (mutex-unlock! _mx835_))))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _ws815827_
               'std/net/websocket#websocket::t))
            (let* ((_e819846_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '1)))
                   (_port849_ _e819846_)
                   (_e820851_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '2)))
                   (_e821854_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '3)))
                   (_writer857_ _e821854_)
                   (_e822859_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '4)))
                   (_cs862_ _e822859_)
                   (_e823864_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '5)))
                   (_q867_ _e823864_)
                   (_e824869_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '6)))
                   (_mx872_ _e824869_)
                   (_e825874_
                    (let () (declare (not safe)) (##vector-ref _ws815827_ '7)))
                   (_cv877_ _e825874_))
              (_K818843_ _cv877_ _mx872_ _q867_ _cs862_ _writer857_ _port849_))
            (_E817831_)))))
  (define std/net/websocket#websocket-close__%__0
    (lambda (__804882_ _hard?802883_ _ws884_)
      (let ((_how886_ '1000))
        (std/net/websocket#websocket-close__%__%
         __804882_
         _hard?802883_
         _ws884_
         _how886_))))
  (define std/net/websocket#websocket-close__%
    (lambda _g5078_
      (let ((_g5077_ (let () (declare (not safe)) (##length _g5078_))))
        (cond ((let () (declare (not safe)) (##fx= _g5077_ 3))
               (apply std/net/websocket#websocket-close__%__0 _g5078_))
              ((let () (declare (not safe)) (##fx= _g5077_ 4))
               (apply std/net/websocket#websocket-close__%__% _g5078_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-close__%
                _g5078_))))))
  (define std/net/websocket#websocket-close__@
    (lambda (_keys801896_ . _args898_)
      (apply std/net/websocket#websocket-close__%
             _keys801896_
             (table-ref _keys801896_ 'hard: absent-value)
             _args898_)))
  (define std/net/websocket#websocket-close
    (lambda _args803904_
      (apply keyword-dispatch
             '#(hard:)
             std/net/websocket#websocket-close__@
             _args803904_)))
  (define std/net/websocket#max-frame-size (expt '2 '20))
  (define std/net/websocket#max-message-size (expt '2 '20))
  (define std/net/websocket#set-websocket-max-frame-size!
    (lambda (_sz798_) (set! std/net/websocket#max-frame-size _sz798_)))
  (define std/net/websocket#set-websocket-max-message-size!
    (lambda (_sz796_) (set! std/net/websocket#max-message-size _sz796_)))
  (define std/net/websocket#websocket-reader
    (lambda (_ws599_)
      (letrec* ((_buf601_ (make-u8vector '1024))
                (_skip-to-eof602_
                 (lambda (_port787_)
                   (let ((_len789_ (u8vector-length _buf601_)))
                     (let _lp791_ ()
                       (let ((_rd794_ (read-subu8vector
                                       _buf601_
                                       '0
                                       _len789_
                                       _port787_)))
                         (if (let ()
                               (declare (not safe))
                               (##fx= _len789_ _rd794_))
                             (_lp791_)
                             '#!void))))))
                (_skip-payload603_
                 (lambda (_port771_ _plen772_)
                   (let ((_len774_ (u8vector-length _buf601_)))
                     (let _lp776_ ((_need778_ _plen772_))
                       (let ((_$e780_ (let ()
                                        (declare (not safe))
                                        (##fxzero? _need778_))))
                         (if _$e780_
                             _$e780_
                             (if (let ()
                                   (declare (not safe))
                                   (##fx<= _need778_ _len774_))
                                 (let ((_rd783_ (read-subu8vector
                                                 _buf601_
                                                 '0
                                                 _need778_
                                                 _port771_)))
                                   (if (let ()
                                         (declare (not safe))
                                         (##fx< _rd783_ _need778_))
                                       (_read-eof608_)
                                       '#!void))
                                 (let ((_rd785_ (read-subu8vector
                                                 _buf601_
                                                 '0
                                                 _len774_
                                                 _port771_)))
                                   (if (let ()
                                         (declare (not safe))
                                         (##fx< _rd785_ _len774_))
                                       (_read-eof608_)
                                       (_lp776_ (let ()
                                                  (declare (not safe))
                                                  (##fx- _need778_
                                                         _len774_))))))))))))
                (_read-header604_
                 (lambda (_port762_)
                   (let* ((_b0764_ (read-u8 _port762_))
                          (_g5079_ (if (eof-object? _b0764_)
                                       (_read-eof608_)
                                       '#!void))
                          (_b1767_ (read-u8 _port762_))
                          (_g5080_ (if (eof-object? _b1767_)
                                       (_read-eof608_)
                                       '#!void)))
                     (values (let ()
                               (declare (not safe))
                               (##fxand _b0764_ '128))
                             (let ()
                               (declare (not safe))
                               (##fxand _b0764_ '15))
                             (let ()
                               (declare (not safe))
                               (##fxand _b1767_ '128))
                             (let ()
                               (declare (not safe))
                               (##fxand _b1767_ '127))))))
                (_read-payload605_
                 (lambda (_port754_ _plen755_)
                   (if (let () (declare (not safe)) (##fxzero? _plen755_))
                       '#u8()
                       (let* ((_data757_ (make-u8vector _plen755_))
                              (_rd759_ (read-subu8vector
                                        _data757_
                                        '0
                                        _plen755_
                                        _port754_)))
                         (if (let ()
                               (declare (not safe))
                               (##fx< _rd759_ _plen755_))
                             (_read-eof608_)
                             _data757_)))))
                (_read-u16606_
                 (lambda (_port745_)
                   (let* ((_b0747_ (read-u8 _port745_))
                          (_g5081_ (if (eof-object? _b0747_)
                                       (_read-eof608_)
                                       '#!void))
                          (_b1750_ (read-u8 _port745_))
                          (_g5082_ (if (eof-object? _b1750_)
                                       (_read-eof608_)
                                       '#!void)))
                     (let ((__tmp5083
                            (let ()
                              (declare (not safe))
                              (##fxarithmetic-shift _b0747_ '8))))
                       (declare (not safe))
                       (##fxior __tmp5083 _b1750_)))))
                (_read-u64607_
                 (lambda (_port736_)
                   (let ((_rd738_ (read-subu8vector _buf601_ '0 '8 _port736_)))
                     (if (let () (declare (not safe)) (##fx= _rd738_ '8))
                         (let _lp740_ ((_k742_ '0) (_r743_ '0))
                           (if (let () (declare (not safe)) (##fx< _k742_ '8))
                               (_lp740_ (let ()
                                          (declare (not safe))
                                          (##fx+ _k742_ '1))
                                        (bitwise-ior
                                         (arithmetic-shift _r743_ '8)
                                         (let ()
                                           (declare (not safe))
                                           (##u8vector-ref _buf601_ _k742_))))
                               _r743_))
                         (_read-eof608_)))))
                (_read-eof608_ (lambda () (raise 'eof))))
        (let* ((_ws609621_ _ws599_)
               (_E611625_ (lambda () (error '"No clause matching" _ws609621_)))
               (_K612701_
                (lambda (_cv628_ _mx629_ _q630_ _writer631_ _port632_)
                  (letrec ((_receive634_
                            (lambda (_type698_ _data699_)
                              (mutex-lock! _mx629_)
                              (if (##direct-structure-ref
                                   _ws599_
                                   '4
                                   std/net/websocket#websocket::t
                                   '#f)
                                  (begin
                                    (mutex-unlock! _mx629_)
                                    (raise 'abort))
                                  (begin
                                    (std/misc/queue#enqueue!
                                     _q630_
                                     (cons _type698_ _data699_))
                                    (condition-variable-broadcast! _cv628_)
                                    (mutex-unlock! _mx629_))))))
                    (with-unwind-protect
                     (lambda ()
                       (with-exception-catcher
                        (lambda (_g635638_)
                          (if '#t
                              (let ((_e641_ _g635638_))
                                (let ((_$e643_ _e641_))
                                  (if (eq? 'eof _$e643_)
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws599_
                                       'eof)
                                      (if (eq? 'abort _$e643_)
                                          '#!void
                                          (begin
                                            (std/logger#log-error
                                             '"unhandled exception"
                                             _e641_)
                                            (std/net/websocket#websocket-close__%__%
                                             '#f
                                             absent-value
                                             _ws599_
                                             'abort)
                                            (raise _e641_)))))
                                _e641_)
                              (raise _g635638_)))
                        (lambda ()
                          (let _lp647_ ((_type649_ '#f) (_frags650_ '()))
                            (let ((_g5084_ (_read-header604_ _port632_)))
                              (begin
                                (let ((_g5085_ (let ()
                                                 (declare (not safe))
                                                 (if (##values? _g5084_)
                                                     (##vector-length _g5084_)
                                                     1))))
                                  (if (not (let ()
                                             (declare (not safe))
                                             (##fx= _g5085_ 4)))
                                      (error "Context expects 4 values"
                                             _g5085_)))
                                (let ((_fin652_
                                       (let ()
                                         (declare (not safe))
                                         (##vector-ref _g5084_ 0)))
                                      (_opcode653_
                                       (let ()
                                         (declare (not safe))
                                         (##vector-ref _g5084_ 1)))
                                      (_mask654_
                                       (let ()
                                         (declare (not safe))
                                         (##vector-ref _g5084_ 2)))
                                      (_plen655_
                                       (let ()
                                         (declare (not safe))
                                         (##vector-ref _g5084_ 3))))
                                  (let ((_plen660_
                                         (let ((_$e657_ _plen655_))
                                           (if (eq? '126 _$e657_)
                                               (_read-u16606_ _port632_)
                                               (if (eq? '127 _$e657_)
                                                   (_read-u64607_ _port632_)
                                                   _plen655_)))))
                                    (if (not (let ()
                                               (declare (not safe))
                                               (##fxzero? _mask654_)))
                                        (begin
                                          (std/logger#warning
                                           '"server sent masked frame; closing websocket connection")
                                          (std/net/websocket#websocket-close__%__%
                                           '#f
                                           absent-value
                                           _ws599_
                                           '1002)
                                          (_skip-to-eof602_ _port632_))
                                        (if (> _plen660_
                                               std/net/websocket#max-frame-size)
                                            (begin
                                              (std/logger#warning
                                               '"frame size ~a exceeds max frame size; closing websocket connection"
                                               _plen660_)
                                              (std/net/websocket#websocket-close__%__%
                                               '#f
                                               absent-value
                                               _ws599_
                                               '1009)
                                              (_skip-to-eof602_ _port632_))
                                            (let ((_$e663_ _opcode653_))
                                              (let ((_default665669_
                                                     (lambda ()
                                                       (std/logger#warning
                                                        '"unexpected frame ~x from server; closing websocket connection"
                                                        _opcode653_)
                                                       (std/net/websocket#websocket-close__%__%
                                                        '#f
                                                        absent-value
                                                        _ws599_
                                                        '1002)
                                                       (_skip-to-eof602_
                                                        _port632_)))
                                                    (_table666671_
                                                     '#(0
                                                        1
                                                        1
                                                        #f
                                                        #f
                                                        #f
                                                        #f
                                                        #f
                                                        2
                                                        3
                                                        4)))
                                                (if (fixnum? _$e663_)
                                                    (if (and (let ()
                                                               (declare
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (not safe))
                       (##fx>= _$e663_ '0))
                     (let () (declare (not safe)) (##fx< _$e663_ '11)))
                (let ((_x674_ (let ()
                                (declare (not safe))
                                (##vector-ref _table666671_ _$e663_))))
                  (if _x674_
                      (if (let () (declare (not safe)) (##fx< _x674_ '2))
                          (if (let () (declare (not safe)) (##fx= _x674_ '0))
                              (let ((_dlen677_
                                     (foldl1 ##fx+
                                             _plen660_
                                             (map u8vector-length
                                                  _frags650_))))
                                (if (not _type649_)
                                    (begin
                                      (std/logger#warning
                                       '"unexpected continuation frame from server; closing websocket connection")
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws599_
                                       '1002)
                                      (_skip-to-eof602_ _port632_))
                                    (if (let ()
                                          (declare (not safe))
                                          (##fx> _dlen677_
                                                 std/net/websocket#max-message-size))
                                        (begin
                                          (std/logger#warning
                                           '"message length ~a exceeds max message size; closing websocket connection"
                                           _dlen677_)
                                          (std/net/websocket#websocket-close__%__%
                                           '#f
                                           absent-value
                                           _ws599_
                                           '1009)
                                          (_skip-to-eof602_ _port632_))
                                        (if (let ()
                                              (declare (not safe))
                                              (##fxzero? _fin652_))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##fxzero? _plen660_))
                                                (_lp647_ _type649_ _frags650_)
                                                (let ((_data679_
                                                       (_read-payload605_
                                                        _port632_
                                                        _plen660_)))
                                                  (_lp647_ _type649_
                                                           (cons _data679_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _frags650_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                            (let* ((_data681_
                                                    (_read-payload605_
                                                     _port632_
                                                     _plen660_))
                                                   (_message683_
                                                    (append-u8vectors
                                                     (reverse (cons _data681_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _frags650_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_receive634_
                                               _type649_
                                               _message683_)
                                              (_lp647_ '#f '()))))))
                              (let ((_xtype686_
                                     (if (let ()
                                           (declare (not safe))
                                           (##fx= _opcode653_ '1))
                                         'text
                                         'binary)))
                                (if _type649_
                                    (begin
                                      (std/logger#warning
                                       '"unexpected frame ~x from server; closing websocket connection"
                                       _opcode653_)
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws599_
                                       '1002)
                                      (_skip-to-eof602_ _port632_))
                                    (if (let ()
                                          (declare (not safe))
                                          (##fxzero? _fin652_))
                                        (let ((_data688_
                                               (_read-payload605_
                                                _port632_
                                                _plen660_)))
                                          (_lp647_ _xtype686_
                                                   (cons _data688_ '())))
                                        (let ((_data690_
                                               (_read-payload605_
                                                _port632_
                                                _plen660_)))
                                          (_receive634_ _xtype686_ _data690_)
                                          (_lp647_ '#f '()))))))
                          (if (let () (declare (not safe)) (##fx= _x674_ '2))
                              (let ((_how692_ (_read-u16606_ _port632_)))
                                (std/net/websocket#websocket-close__%__%
                                 '#f
                                 absent-value
                                 _ws599_
                                 _how692_)
                                (_skip-to-eof602_ _port632_))
                              (if (let ()
                                    (declare (not safe))
                                    (##fx= _x674_ '3))
                                  (let ((_data694_
                                         (_read-payload605_
                                          _port632_
                                          _plen660_)))
                                    (thread-send
                                     _writer631_
                                     (cons 'pong _data694_))
                                    (_lp647_ _type649_ _frags650_))
                                  (begin
                                    (_skip-payload603_ _port632_ _plen660_)
                                    (_lp647_ _type649_ _frags650_)))))
                      (_default665669_)))
                (_default665669_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (_default665669_))))))))))))))
                     (lambda ()
                       (with-exception-catcher
                        void
                        (lambda () (close-input-port _port632_)))))))))
          (if (let ()
                (declare (not safe))
                (##structure-direct-instance-of?
                 _ws609621_
                 'std/net/websocket#websocket::t))
              (let* ((_e613704_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '1)))
                     (_port707_ _e613704_)
                     (_e614709_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '2)))
                     (_e615712_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '3)))
                     (_writer715_ _e615712_)
                     (_e616717_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '4)))
                     (_e617720_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '5)))
                     (_q723_ _e617720_)
                     (_e618725_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '6)))
                     (_mx728_ _e618725_)
                     (_e619730_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws609621_ '7)))
                     (_cv733_ _e619730_))
                (_K612701_ _cv733_ _mx728_ _q723_ _writer715_ _port707_))
              (_E611625_))))))
  (define std/net/websocket#websocket-writer
    (lambda (_ws407_)
      (letrec* ((_buf409_ (make-u8vector '65535))
                (_mask-bytes410_ (make-u8vector '4))
                (_write-u16411_
                 (lambda (_plen596_ _port597_)
                   (write-u8
                    (let ((__tmp5086
                           (let ()
                             (declare (not safe))
                             (##fxarithmetic-shift _plen596_ '-8))))
                      (declare (not safe))
                      (##fxand __tmp5086 '255))
                    _port597_)
                   (write-u8
                    (let () (declare (not safe)) (##fxand _plen596_ '255))
                    _port597_)))
                (_write-payload412_
                 (lambda (_mask585_ _data586_ _start587_ _end588_ _port589_)
                   (let _lp591_ ((_k593_ _start587_) (_x594_ '0))
                     (if (let () (declare (not safe)) (##fx< _k593_ _end588_))
                         (begin
                           (let ((__tmp5087
                                  (let ((__tmp5090
                                         (let ()
                                           (declare (not safe))
                                           (##u8vector-ref _data586_ _k593_)))
                                        (__tmp5088
                                         (let ((__tmp5089
                                                (let ()
                                                  (declare (not safe))
                                                  (##fxmodulo _x594_ '4))))
                                           (declare (not safe))
                                           (##u8vector-ref
                                            _mask585_
                                            __tmp5089))))
                                    (declare (not safe))
                                    (##fxxor __tmp5090 __tmp5088))))
                             (declare (not safe))
                             (##u8vector-set! _buf409_ _x594_ __tmp5087))
                           (_lp591_ (let ()
                                      (declare (not safe))
                                      (##fx+ _k593_ '1))
                                    (let ()
                                      (declare (not safe))
                                      (##fx+ _x594_ '1))))
                         (write-subu8vector _buf409_ '0 _x594_ _port589_)))))
                (_send-frame413_
                 (lambda (_port567_
                          _fin568_
                          _opcode569_
                          _data570_
                          _start571_
                          _end572_)
                   (let* ((_plen574_
                           (let ()
                             (declare (not safe))
                             (##fx- _end572_ _start571_)))
                          (_fin576_
                           (let ()
                             (declare (not safe))
                             (##fxarithmetic-shift _fin568_ '7)))
                          (_b0578_ (let ()
                                     (declare (not safe))
                                     (##fxior _fin576_ _opcode569_)))
                          (_mask580_
                           (let ()
                             (declare (not safe))
                             (##fxarithmetic-shift '1 '7)))
                          (_b1582_ (let ((__tmp5091
                                          (if (let ()
                                                (declare (not safe))
                                                (##fx< _plen574_ '126))
                                              _plen574_
                                              '126)))
                                     (declare (not safe))
                                     (##fxior _mask580_ __tmp5091))))
                     (std/crypto/etc#random-bytes!__0 _mask-bytes410_)
                     (write-u8 _b0578_ _port567_)
                     (write-u8 _b1582_ _port567_)
                     (if (let () (declare (not safe)) (##fx< _plen574_ '126))
                         '#!void
                         (_write-u16411_ _plen574_ _port567_))
                     (write-subu8vector _mask-bytes410_ '0 '4 _port567_)
                     (_write-payload412_
                      _mask-bytes410_
                      _data570_
                      _start571_
                      _end572_
                      _port567_)
                     (force-output _port567_))))
                (_send414_
                 (lambda (_port552_ _opcode553_ _data554_)
                   (let ((_end556_ (u8vector-length _data554_)))
                     (let _lp558_ ((_start560_ '0) (_opcode561_ _opcode553_))
                       (let ((_have563_
                              (let ()
                                (declare (not safe))
                                (##fx- _end556_ _start560_))))
                         (if (let ()
                               (declare (not safe))
                               (##fx< _have563_ '65536))
                             (_send-frame413_
                              _port552_
                              '1
                              _opcode561_
                              _data554_
                              _start560_
                              _end556_)
                             (let ((_xend565_
                                    (let ()
                                      (declare (not safe))
                                      (##fx+ _start560_ '65535))))
                               (_send-frame413_
                                _port552_
                                '0
                                _opcode561_
                                _data554_
                                _start560_
                                _xend565_)
                               (_lp558_ _xend565_ '0)))))))))
        (let* ((_ws415421_ _ws407_)
               (_E417425_ (lambda () (error '"No clause matching" _ws415421_)))
               (_K418544_
                (lambda (_port428_)
                  (with-unwind-protect
                   (lambda ()
                     (with-exception-catcher
                      (lambda (_g429432_)
                        (if '#t
                            (let ((_e435_ _g429432_))
                              (std/logger#log-error
                               '"unhandled exception"
                               _e435_)
                              (std/net/websocket#websocket-close__%__%
                               '#f
                               absent-value
                               _ws407_
                               'abort)
                              (with-exception-catcher
                               void
                               (lambda () (close-port _port428_))))
                            (raise _g429432_)))
                      (lambda ()
                        (let _lp439_ ()
                          (let* ((_g441462_ (thread-receive))
                                 (_E447466_
                                  (lambda ()
                                    (error '"No clause matching" _g441462_))))
                            (let ((_K458532_
                                   (lambda (_data530_)
                                     (_send414_ _port428_ '1 _data530_)
                                     (_lp439_)))
                                  (_K455517_
                                   (lambda (_data515_)
                                     (_send414_ _port428_ '2 _data515_)
                                     (_lp439_)))
                                  (_K452501_
                                   (lambda (_data499_)
                                     (_send414_ _port428_ '10 _data499_)
                                     (_lp439_)))
                                  (_K449485_
                                   (lambda (_how481_)
                                     (if (fixnum? _how481_)
                                         (let ((_bytes483_ (make-u8vector '2)))
                                           (let ((__tmp5092
                                                  (let ((__tmp5093
                                                         (let ()
                                                           (declare (not safe))
                                                           (##fxarithmetic-shift
                                                            _how481_
                                                            '-8))))
                                                    (declare (not safe))
                                                    (##fxand __tmp5093 '255))))
                                             (declare (not safe))
                                             (##u8vector-set!
                                              _bytes483_
                                              '0
                                              __tmp5092))
                                           (let ((__tmp5094
                                                  (let ()
                                                    (declare (not safe))
                                                    (##fxand _how481_ '255))))
                                             (declare (not safe))
                                             (##u8vector-set!
                                              _bytes483_
                                              '1
                                              __tmp5094))
                                           (_send414_ _port428_ '8 _bytes483_))
                                         '#!void)))
                                  (_K448472_
                                   (lambda (_bogus470_)
                                     (std/logger#warning
                                      '"unexpected message ~a"
                                      _bogus470_)
                                     (_lp439_))))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _g441462_))
                                  (let ((_tl460537_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _g441462_)))
                                        (_hd459535_
                                         (let ()
                                           (declare (not safe))
                                           (##car _g441462_))))
                                    (if (let ()
                                          (declare (not safe))
                                          (##eq? _hd459535_ 'text))
                                        (let ((_data540_ _tl460537_))
                                          (_K458532_ _data540_))
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _hd459535_ 'binary))
                                            (let ((_data525_ _tl460537_))
                                              (_K455517_ _data525_))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##eq? _hd459535_ 'pong))
                                                (let ((_data509_ _tl460537_))
                                                  (_K452501_ _data509_))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##eq? _hd459535_
                                                             'close))
                                                    (let ((_how493_
                                                           _tl460537_))
                                                      (_K449485_ _how493_))
                                                    (let ((_bogus475_
                                                           _g441462_))
                                                      (_K448472_
                                                       _bogus475_)))))))
                                  (let ((_bogus475_ _g441462_))
                                    (_K448472_ _bogus475_)))))))))
                   (lambda ()
                     (with-exception-catcher
                      void
                      (lambda () (close-output-port _port428_))))))))
          (if (let ()
                (declare (not safe))
                (##structure-direct-instance-of?
                 _ws415421_
                 'std/net/websocket#websocket::t))
              (let* ((_e419547_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ws415421_ '1)))
                     (_port550_ _e419547_))
                (_K418544_ _port550_))
              (_E417425_)))))))
