# ReadMe

This is an effort to recreate Open-Dyslexic with the SIL-OFL typeface.

## Why?

The Bitstream license was too restrictive, and my attempts at clarifying what was allowed (pretty much anything) just confused everything even  more. I should have also done it from the start. Also, restarting it allows me to implement it more consistently, with reusable components and give it additional scrutiny. 

It is a typeface that uses various methods to help with some symptoms of dyslexia (as defined by the DSM-V). Goals were to make reading comfortable, with visual cues to help with blinding on white pages, confusing similar letters, and not being able to keep your place among others. By keeping it free and opensource, it would be easier to have studies done, and information from those studies and users can in turn help the typeface continue to improve.

In short:

* Bolder letters, even bolder punctuation.
* Letter are heavier at their bottom. Like underlining the 9 on an Uno card. 
* uniquely shaped characters to make confusing them more difficult.
* Extended ascenders on lowercase letters to help with recognition.
* wider horizontal spacing and more spacing between lines.

## Downloads

Releases are listed here: https://github.com/antijingoist/opendyslexic/releases
These releases contain the font files in OTF and WOFF, and a PDF of the full list of characters. There are no exe's, and no installers in these packages.

Releases are $0. You can donate using the sponsors button above or from opendyslexic.org If you donate from the Patreon, you'll get access to some goodies: an OpenDyslexic screensaver, software and a zip file of the studies I am aware of up to this point.

## Submissions

Open-Dyslexic submissions were messy because they mostly came in compiled typeface files, creating a lot of work in comparing files, properly pulling them from the compiled typeface and moving them over to the app native source being used.

As such, submissions are accepted as long as:

* it's provided as a pull request against the typeface source
* it's submitted as an SVG document

## Contributions also include contributions from antijingoist/open-dyslexic

They are listed here: https://github.com/antijingoist/open-dyslexic/graphs/contributors

## Additional Significant Contributers 

The following people contributed to the project existing.

* My wife
* Cheryl Marshall
* Eric Bailey
* Steven V James
* @Nguarracino
* Plow Software

Includes contributions from Rob Carpenter (the rounded a), Charade-Estel (help with accents, longer ascenders and descenders, and Robert Gabriel for continued work on the Chrome extension. 

## Allowed uses:

_see OFL-FAQ.txt_ 

## Re-hosting

K.I.S.S. If you put it on a CDN to share, let me know, and I can include links here.

## Sharing Products making use of OpenDyslexic

I'll work on a submission process for this. E-mail wasn't the best place to receive these, but until then, you can email.

## Studies

I'll have a proper release of these, but in the meantime, its in the patreon rewards. Or you could search google for opendyslexic filetype:pdf, (!pdf opendyslexic on duckduckgo). Remember to count the number of participants and check the version number.

## Attribution

_the OFL-FAQ.txt document is fantastic at frequently asked questions, and it contains information about this also. :)_

If you _need_  my *preferred* attribution method: 

 * Include name, typeface name and URL so others know where to find it..

♡ Copying is an act of love. Please copy.
