/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Component;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class CBpbar {
    ProgressMonitor pbar;
    int count;
    int pcntg;
    int level;
    static int MAXLEVEL = 6;
    int[] fanout = new int[MAXLEVEL];
    int[] visited = new int[MAXLEVEL];
    String notePrefix;

    public CBpbar(Component C, String uberTitle, String notePrefix) {
        this.notePrefix = notePrefix;
        this.pbar = new ProgressMonitor(C, uberTitle, notePrefix + " 0", 0, 100);
        this.level = 0;
        this.fanout[this.level] = 1;
    }

    public void inc() {
        ++this.count;
        int oldpcntg = this.pcntg;
        if (this.level < MAXLEVEL && this.level >= 0) {
            int n = this.level;
            this.visited[n] = this.visited[n] + 1;
            this.pcntg = 0;
            int spread = 100;
            for (int i = 0; i < this.level; ++i) {
                this.pcntg += spread * this.visited[i] / this.fanout[i];
                spread /= this.fanout[i];
            }
            if (this.pcntg != oldpcntg) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CBpbar.this.pbar.setProgress(CBpbar.this.pcntg);
                        CBpbar.this.pbar.setNote(CBpbar.this.notePrefix + " " + CBpbar.this.count);
                    }
                });
            }
        }
    }

    public void pop() {
        --this.level;
    }

    public void push(int fanout) {
        ++this.level;
        if (this.level < MAXLEVEL) {
            this.fanout[this.level] = fanout;
        }
    }

    public void close() {
        this.pbar.close();
    }

    public boolean isCanceled() {
        return this.pbar.isCanceled();
    }
}

