import { Enum } from "./kinds";
export const Align = Enum("start", "center", "end");
export const Anchor = Enum("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
export const AngleUnits = Enum("deg", "rad", "grad", "turn");
export const BoxOrigin = Enum("corner", "center");
export const ButtonType = Enum("default", "primary", "success", "warning", "danger", "light");
export const CalendarPosition = Enum("auto", "above", "below");
export const Dimension = Enum("width", "height");
export const Dimensions = Enum("width", "height", "both");
export const Direction = Enum("clock", "anticlock");
export const Distribution = Enum("uniform", "normal");
export const FontStyle = Enum("normal", "italic", "bold", "bold italic");
export const HatchPatternType = Enum("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
export const HTTPMethod = Enum("POST", "GET");
export const HexTileOrientation = Enum("pointytop", "flattop");
export const HoverMode = Enum("mouse", "hline", "vline");
export const LatLon = Enum("lat", "lon");
export const LegendClickPolicy = Enum("none", "hide", "mute");
export const LegendLocation = Anchor;
export const LineCap = Enum("butt", "round", "square");
export const LineJoin = Enum("miter", "round", "bevel");
export const LineDash = Enum("solid", "dashed", "dotted", "dotdash", "dashdot");
export const LinePolicy = Enum("prev", "next", "nearest", "interp", "none");
export const Location = Enum("above", "below", "left", "right");
export const Logo = Enum("normal", "grey");
export const MarkerType = Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
export const MutedPolicy = Enum("show", "ignore");
export const Orientation = Enum("vertical", "horizontal");
export const OutputBackend = Enum("canvas", "svg", "webgl");
export const PaddingUnits = Enum("percent", "absolute");
export const Place = Enum("above", "below", "left", "right", "center");
export const PointPolicy = Enum("snap_to_data", "follow_mouse", "none");
export const RadiusDimension = Enum("x", "y", "max", "min");
export const RenderLevel = Enum("image", "underlay", "glyph", "guide", "annotation", "overlay");
export const RenderMode = Enum("canvas", "css");
export const ResetPolicy = Enum("standard", "event_only");
export const RoundingFunction = Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup");
export const SelectionMode = Enum("replace", "append", "intersect", "subtract");
export const Side = Enum("above", "below", "left", "right");
export const SizingMode = Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
export const Sort = Enum("ascending", "descending");
export const SpatialUnits = Enum("screen", "data");
export const StartEnd = Enum("start", "end");
export const StepMode = Enum("after", "before", "center");
export const TapBehavior = Enum("select", "inspect");
export const TextAlign = Enum("left", "right", "center");
export const TextBaseline = Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
export const TextureRepetition = Enum("repeat", "repeat_x", "repeat_y", "no_repeat");
export const TickLabelOrientation = Enum("vertical", "horizontal", "parallel", "normal");
export const TooltipAttachment = Enum("horizontal", "vertical", "left", "right", "above", "below");
export const UpdateMode = Enum("replace", "append");
export const VerticalAlign = Enum("top", "middle", "bottom");
//# sourceMappingURL=enums.js.map