# -*- indent-tabs-mode: nil; -*-
# vim:ft=perl:et:sw=4
# $Id: Constants.pm.in 12612 2016-01-01 01:48:29Z sikeda $

# Sympa - SYsteme de Multi-Postage Automatique
#
# Copyright (c) 1997, 1998, 1999 Institut Pasteur & Christophe Wolfhugel
# Copyright (c) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
# 2006, 2007, 2008, 2009, 2010, 2011 Comite Reseau des Universites
# Copyright (c) 2011, 2012, 2013, 2014, 2015, 2016 GIP RENATER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Sympa::Constants;

use strict;

use constant VERSION => '6.2.16';
use constant USER    => '_sympa';
use constant GROUP   => '_sympa';

use constant CONFIG           => '/var/sympa/etc/sympa.conf';
use constant WWSCONFIG        => '/var/sympa/etc/wwsympa.conf';
use constant SENDMAIL_ALIASES => '/var/sympa/sympa_aliases';

use constant PIDDIR     => '/var/run/sympa';
use constant EXPLDIR    => '/var/sympa/list_data';
use constant SPOOLDIR   => '/var/spool/sympa';
use constant SYSCONFDIR => '/etc';
use constant LOCALEDIR  => '/usr/local/share/locale';
use constant LIBEXECDIR => '/usr/local/libexec/sympa';
use constant SBINDIR    => '/usr/local/sbin';
use constant SCRIPTDIR  => '/usr/local/bin';
use constant MODULEDIR  => '/usr/local/libdata/perl5/site_perl';
use constant DEFAULTDIR => '/usr/local/share/sympa';
use constant STATICDIR  => '/var/www/sympa';
use constant ARCDIR     => '/usr/local/arc';
use constant BOUNCEDIR  => '/usr/local/bounce';

use constant EMAIL_LEN  => 100;
use constant FAMILY_LEN => 50;
use constant LIST_LEN   => 50;
use constant ROBOT_LEN  => 80;

1;
__END__

=encoding utf-8

=head1 NAME

Sympa::Constants - Definition of constants

=head1 DESCRIPTION

This module keeps definition of constants used by Sympa software.

=cut
